 /* $Id: db_material.c,v 1.666 2004/09/20 10:50:19 shrike Exp $  */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>

#include "merc.h"
#include "db.h"
#include "material.h"

DECLARE_DBLOAD_FUN(load_material);

DBFUN db_load_material[] =
{
     { "MATERIAL",   load_material},
     { NULL}
};

DBLOAD_FUN(load_material)
{
     material_t *material;

     material = material_new();

     for (;;)
     {
          char *word = feof(fp) ? "End" : fread_word(fp);
          bool fMatch = FALSE;

          switch (UPPER(word[0]))
          {

          case 'E':
               if (!str_cmp(word, "End"))
               {
                         if (IS_NULLSTR(material->ename))
                         {
                                   db_error("load_material",
                                                  "material name not defined");
                                   material_free(material);
                                   materials.nused--;
                         }
                         return;
               }
               SKEY("Ename",    material->ename);
               break;
          case 'D':
               KEY("Density",   material->density,      fread_number(fp));
               break;
          case 'F':
               KEY("Flags",     material->flag,         fread_fstring(material_flags, fp));
               KEY("Fragility", material->fragility,    fread_number(fp));
               break;
          case 'R':
               KEY("Rigidity",  material->rigidity,     fread_number(fp));
               SKEY("Rname",    material->rname);

               if (!str_cmp(word, "Race"))
               {
                  mtrace_t *mtrace;

                  mtrace         = varr_enew(&material->races);
                  mtrace->name   = str_dup(fread_word(fp));
                  mtrace->status = fread_fstring(material_wear_status, fp);
                  fMatch = TRUE;
               }

               if (!str_cmp(word, "Repair"))
               {
                  mrepair_t *mrepair;

                  mrepair                = varr_enew(&material->repairer);
                  mrepair->vnum          = (fread_number(fp));
                  mrepair->repair_rate   = (fread_number(fp));
                  fMatch = TRUE;
               }
               break;
          }

          if (!fMatch)
               db_error("load_material", "%s: Unknown keyword", word);
     }
}
