/* $Id: db_meteor.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

 /************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 
#include <stdio.h>

#include "merc.h"
#include "db.h"
#include "meteor.h"

DECLARE_DBLOAD_FUN(load_meteor);

DBFUN db_load_meteor[] =
{
        { "METEOR",   load_meteor},
        { NULL}
};

DBLOAD_FUN(load_meteor)
{
        meteor_t * meteor;

        meteor = meteor_new();
    
        for (;;)
        {
                char *word = feof(fp) ? "End" : fread_word(fp);
                bool fMatch = FALSE;

                switch (UPPER(word[0]))
                {
                
                case 'E':
                        if (!str_cmp(word, "End"))
                        {
                                if (IS_NULLSTR(meteor->name))
                                {
                                        db_error("load_meteor",
                                                 "meteor name not defined");
                                        meteor_free(meteor);
                                        meteors.nused--;
                                }
                                return;
                        }
                        break;
                case 'W':
                        KEY("Wait", meteor->wait_tick,           fread_number(fp));
                        break;
                case 'S':
                        KEY("Size", meteor->size,                fread_number(fp));
                        break;
                case 'N':
                        SKEY("Name", meteor->name);
                        KEY("Nopk", meteor->nopk_damage,         fread_fstring(meteor_bool_flags, fp));
                        break;
                case 'A':
                        KEY("Autostart", meteor->auto_start,     fread_fstring(meteor_bool_flags, fp));
                        break;
                case 'R':
                        KEY("RoomAffect", meteor->room_affect,   fread_fstring(meteor_bool_flags, fp));
                        break;
                case 'D':
                        KEY("Damage", meteor->damage,            fread_number(fp));
                        break;
                case 'O':
                        if (!str_cmp(word, "Objects"))
                        {
                                mobject_t *mobject;

                                mobject = varr_enew(&meteor->objects);
                                mobject->obj_vnum    = fread_number(fp);
                                mobject->obj_count   = fread_number(fp);
                mobject->chanse      = fread_number(fp);
                                fMatch = TRUE;
                        }
                        break;
                }

                if (!fMatch)
                        db_error("load_meteor", "%s: Unknown keyword", word);
        }
}               
