/*  $Id: db_price.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <limits.h>
#include <stdio.h>
#include <ctype.h>

#include "typedef.h"
#include "const.h"
#include "varr.h"
#include "price.h"
#include "cmd.h"
#include "db.h"
#include "str.h"
#include "tables.h"

DECLARE_DBLOAD_FUN(load_price);


DBFUN db_load_prices[] =
{
	{ "PRICE",	load_price	},
	{ NULL }
};


/*
 * Load prices from files
 */

DBLOAD_FUN(load_price)
{
	price_t *price = price_new();
	
        for (;;) 
        {
		char *word = feof(fp) ? "End" : fread_word(fp);
		bool fMatch = FALSE;

		switch (UPPER(word[0])){
		case 'E':
			if (!str_cmp(word, "End")) 
                        {
				if (IS_NULLSTR(price->name)) 
                                {
					db_error("load_price", "price name not defined");
					price_free(price);
					prices.nused--;
				}
				return;
			}
			break;
		case 'N':
			SKEY("Name", price->name);
			break;
                case 'D':
                        SKEY("Descriptor", price->descriptor);
                        break;
                case 'A':
                        KEY("Amount", price->amount, fread_number(fp));
                        break;
                case 'T':
                        KEY("Type", price->amount_type, fread_number(fp));
                        break;
		}

		if (!fMatch) 
			db_error("load_price", "%s: Unknown keyword", word);
	}
}
