/*  $Id: db_race.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/
 
#include <stdio.h>

#include "merc.h"
#include "db.h"

DECLARE_DBLOAD_FUN(load_race);
DECLARE_DBLOAD_FUN(load_pcrace);

DBFUN db_load_races[] =
{
        { "RACE",       load_race       },
        { "PCRACE",     load_pcrace     },
        { NULL }
};

static race_t *race_curr;

DBINIT_FUN(init_race)
{
     race_curr = NULL;
}

DBLOAD_FUN(load_race)
{
    int i;

    race_curr = race_new();
    race_curr->file_name = get_filename(filename);

    for (;;) 
    {
        char *word = feof(fp) ? "End" : fread_word(fp);
        bool fMatch = FALSE;

        switch(UPPER(word[0])) 
        {
        case 'A':
            KEY("Aff", race_curr->aff,     fread_fstring(affect_flags, fp));
            KEY("Act", race_curr->act,     fread_fstring(act_flags, fp));
            break;
       
        case 'D':
            KEY("Dodge", race_curr->dodge, fread_number(fp));
            break;

        case 'E':
            if (!str_cmp(word, "End")) 
            {
                if (IS_NULLSTR(race_curr->name)) 
                {
                    db_error("load_race", "race name undefined");
                    race_free(race_curr);
                    races.nused--;
                }
                return;
            }
            break;

        case 'F':
            KEY("Flags", race_curr->flags,   fread_fstring(race_flags, fp));
            KEY("Form", race_curr->form,     fread_fstring(form_flags, fp));
            break;

        case 'H':
            KEY("HateSect", race_curr->hated_sectors,  fread_fstring(sector_flag_types, fp));
            break;

        case 'I':
            KEY("Immune", race_curr->immunes,  fread_fstring(imm_flags, fp));
            break;

        case 'L':
            KEY("LoveSect", race_curr->loved_sectors,  fread_fstring(sector_flag_types, fp));
            break;

        case 'N':
            SKEY("Name", race_curr->name);
            break;

        case 'O':
            KEY("Off", race_curr->off,        fread_fstring(off_flags, fp));
            break;

        case 'P':
            KEY("Parts", race_curr->parts,   fread_fstring(part_flags, fp));
                 BITS_CNT(race_curr->parts, race_curr->pcnt, MAX_PARTS);
            break;

        case 'R':
            if (!str_cmp(word, "Resist"))
            {
                char *dam_type = fread_word(fp);
                int dt = flag_value(dam_flags, dam_type);
                int percent = fread_number(fp);

                if (dt == -1)
                {
                    db_error("load_race", "unknown damage type '%s'",  dam_type);
                }

                race_curr->resists[dt] = percent;
                fMatch = TRUE;
            }
            break;

        case 'S':
            if (!str_cmp(word, "SP"))
            {
                int num = fread_number (fp);
                int vnum = fread_number (fp);
                int prob = fread_number (fp);
                int level = fread_number (fp);

                race_curr->spec_parts[num] = vnum;
                race_curr->spec_prob[num]  = prob;
                race_curr->spec_levels[num] = level;
                fMatch = TRUE;
            }
            break;

       case 'W':
            if (!str_cmp(word, "WearLoc")) 
            {
                 for (i = 0; i < MAX_WEAR; i++)
                      race_curr->wear_loc[i] = fread_number(fp);
                 fMatch = TRUE;
            }
            break;
       }

       if (!fMatch)
            db_error("load_race", "%s: Unknown keyword", word);
     }
}

DBLOAD_FUN(load_pcrace)
{
     pcrace_t *pcr;
     if (!race_curr) 
               db_error("load_pcrace", "#PCRACE before #RACE");

     pcr = race_curr->pcdata = race_pcdata_new();

     for (;;) 
     {
     
               int i;
               char *word = feof(fp) ? "End" : fread_word(fp);
               bool fMatch = FALSE;

               switch(UPPER(word[0])) 
               {
               case 'B':
                    SKEY("BonusSkills", pcr->bonus_skills);
                    break;

               case 'C':
                    if (!str_cmp(word, "Class")) 
                    {
                              rclass_t *rcl;

                              rcl = varr_enew(&pcr->classes);
                              rcl->name = str_dup(fread_word(fp));
                              rcl->mult = fread_number(fp);
                              fMatch = TRUE;
                    }
                    break;

               case 'E':
                    if (!str_cmp(word, "End")) 
                    {
                              if (pcr->who_name[0] == '\0') 
                              {
                                        db_error("load_pcrace",
                                             "race who_name undefined");
                                        race_pcdata_free(pcr);
                                        race_curr->pcdata = NULL;
                              }
                              varr_qsort(&pcr->classes, cmpstr);
                              varr_qsort(&pcr->skills, cmpint);
                              return;
                    }
                    break;

               case 'H':
                    KEY("HPBonus", pcr->hp_bonus, fread_number(fp));
                    break;

               case 'M':
                    KEY("ManaBonus", pcr->mana_bonus, fread_number(fp));
                    if (!str_cmp(word, "MaxStats")) 
                    {
                              for (i = 0; i < MAX_STATS; i++)
                                        pcr->max_stats[i] = fread_number(fp);
                              fMatch = TRUE;
                    }

               case 'P':
                    KEY("Points", pcr->points, fread_number(fp));
                    KEY("PracBonus", pcr->prac_bonus, fread_number(fp));
                    break;

               case 'R':
                    KEY("RestrictAlign", pcr->restrict_align,    fread_fstring(ralign_names, fp));
                    KEY("RestrictSex", pcr->restrict_sex,        fread_fstring(restrict_sex_table, fp));
                    KEY("RestrictEthos", pcr->restrict_ethos,    fread_fstring(ethos_table, fp));
                    break;

               case 'S':
                    KEY("Size", pcr->size, fread_number(fp));
                    KEY("Slang", pcr->slang, fread_fword(slang_table, fp));
                    if (!str_cmp(word, "ShortName")) 
                    {
                              const char *p = fread_string(fp);
                              strnzcpy(pcr->who_name, sizeof(pcr->who_name), p);
                              free_string(p);
                              fMatch = TRUE;
                    }
                    if (!str_cmp(word, "Skill")) 
                    {
                              race_skill_t *race_skill;

                              race_skill = varr_enew(&pcr->skills);
                              race_skill->sn = sn_lookup(fread_word(fp));
                              race_skill->level = fread_number(fp);
                              fMatch = TRUE;
                    }
                    if (!str_cmp(word, "Stats")) 
                    {
                              for (i = 0; i < MAX_STATS; i++)
                                        pcr->stats[i] = fread_number(fp);
                              fMatch = TRUE;
                    }
               }

               if (!fMatch)
                    db_error("load_pcrace", "%s: Unknown keyword", word);
     }
}
