/* $Id: db_riddle.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>

#include "merc.h"
#include "db.h"
#include "riddle.h"

DECLARE_DBLOAD_FUN(load_riddles);

DBFUN db_load_riddles[] =
{
	{ "RIDDLE",   load_riddles},
	{ NULL}
};

DBLOAD_FUN(load_riddles)
{
	riddle_t * riddle;

	riddle = riddle_new();
    
	for (;;)
	{
		char *word = feof(fp) ? "End" : fread_word(fp);
		bool fMatch = FALSE;

		switch (UPPER(word[0]))
		{
		
    		case 'E':
    			if (!str_cmp(word, "End"))
    			{
    				if (IS_NULLSTR(riddle->question))
    				{
    					db_error("load_riddle",
    						 "riddle question not defined");
    					riddle_free(riddle);
    					riddles.nused--;
    				}
    				return;
    			}
    			break;
                    
            case 'Q':
                    MLSKEY("Question", riddle->question);
                    
            break;
            case 'A':
                    SKEY("Answer", riddle->answer);
    		break;
        }

		if (!fMatch)
			db_error("load_riddle", "%s: Unknown keyword", word);
	}
}               
