/* $Id: db_ritual.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>

#include "merc.h"
#include "db.h"

DECLARE_DBLOAD_FUN(load_ritual);

DBFUN db_load_ritual[] =
{
	{ "ritual",   load_ritual},
	{ NULL}
};

DBLOAD_FUN(load_ritual)
{
    ritual_t * ritual;

    ritual = ritual_new();
    
    for (;;)
    {
        char *word = feof(fp) ? "End" : fread_word(fp);
        bool fMatch = FALSE;

        switch (UPPER(word[0]))
        {
        case 'C':
            if (!str_cmp(word, "Component"))
            {
                int num = fread_number (fp);
                int vnum = fread_number (fp);
                if (num >= 0 && num < MAX_RITUAL_COMP)
                    // todo: validate?
                    ritual->components[num] = vnum;
                fMatch = TRUE;
            }
            break;

        case 'D':
            KEY("Duration", ritual->duration, fread_number(fp));
            break;

        case 'E':
            if (!str_cmp(word, "End"))
            {
                if (IS_NULLSTR(ritual->name))
                {
                    db_error("load_ritual",
                             "ritual name not defined");
                    ritual_free(ritual);
                    rituals.nused--;
                }
                return;
            }
            KEY("Extra", ritual->extra, fread_flags(fp));
            break;

        case 'M':
            KEY("MinSkill", ritual->min_skill, fread_number(fp));
            break;

        case 'N':
            SKEY("Name", ritual->name);
            break;

        case 'P':
            KEY("Period", ritual->time, fread_flags(fp));
            break;

        case 'S':
            KEY("Sector", ritual->sector, fread_flags(fp));
            break;

        }

        if (!fMatch)
            db_error("load_ritual", "%s: Unknown keyword", word);
    }
}
