/* $Id: db_skills.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/
 

#include <stdio.h>
#include <stdlib.h>

#include "merc.h"
#include "db.h"

DECLARE_DBLOAD_FUN(load_skill);

DBFUN db_load_skills[] =
{
      { "SKILL",  load_skill  },
      { NULL }
};

DBLOAD_FUN(load_skill)
{
      skill_t *skill;

      skill = skill_new();


      for (;;)
      {
            char *word = feof(fp) ? "End" : fread_word(fp);
            bool fMatch = FALSE;

            switch(UPPER(word[0])) {
            case 'B':
                  KEY("Beats", skill->beats, fread_number(fp));
                  KEY("Bonus", skill->bonus, fread_number(fp));
                  break;
            case 'C':
                  KEY("ClanEnergy",  skill->clan_energy,     fread_number(fp));
                  break;
            case 'D':
                  KEY("Delay",       skill->delay,      fread_number(fp));
                  KEY("Discipline",  skill->discipline, fread_fstring(psi_disciplines, fp));
                  KEY("DoFun",       skill->do_fun,   fread_namedp(dofun_table, fp));
                  break;
            case 'E':
                  if (!str_cmp(word, "End"))
                  {
                        if (IS_NULLSTR(skill->name))
                        {
                              db_error("load_skill",
                                        "skill name undefined");
                              skill_free(skill);
                              skills.nused--;
                        }
                        return;
                  }
                  break;

            case 'F':
                  KEY("Flags", skill->flags,   fread_fstring(skill_flags, fp));
                  break;

            case 'G':
                  KEY("Group", skill->group,   fread_fstring(skill_groups, fp));
                  if (!str_cmp(word, "Gsn"))
                  {
                        skill->pgsn = fread_namedp(gsn_table, fp);
                        *skill->pgsn = skills.nused - 1;
                        fMatch = TRUE;
                  }
                  break;

            case 'I':
                  KEY("InitialCost",  skill->initial,     fread_number(fp));
                  break;

            case 'L':
                  if (!str_cmp(word, "LearnMult"))
      {
                        skill->learnmult[0] = fread_number(fp);
                        skill->learnmult[1] = fread_number(fp);
                        fMatch = TRUE;
                  }
                  break;

            case 'M':
                  KEY("MaintainCost",  skill->maintain,    fread_number(fp));
                  KEY("MinMana",       skill->min_mana,    fread_number(fp));
                  KEY("MinPos",        skill->min_pos,     fread_fword(position_table, fp));
                  break;

            case 'N':
                  SKEY("Name",          skill->name);
                  SKEY("NounDamage",    skill->noun_damage);
                  SKEY("NounRus",       skill->noun_rus);
                  break;

            case 'O':
                  SKEY("ObjWearOff",    skill->msg_obj);
                  break;

            case 'S':
                  KEY("SkillGender",    skill->gender,      fread_number(fp));
                  KEY("Slot",           skill->slot,        fread_number(fp));
                  KEY("SpellFun",       skill->spell_fun,   fread_namedp(spellfn_table, fp));
                  KEY("Stat1",          skill->stat1,       GET_STAT_BY_NAME(fread_word(fp)))
                  KEY("Stat2",          skill->stat2,       GET_STAT_BY_NAME(fread_word(fp)))
                  KEY("Stat3",          skill->stat3,       GET_STAT_BY_NAME(fread_word(fp)))
                  break;

            case 'T':
                  KEY("Type",           skill->type,        fread_fword(skill_types, fp));
                  KEY("Target",         skill->target,      fread_fword(skill_targets, fp));
                  break;
            case 'W':
                  SKEY("WearOff",       skill->msg_off);
                  SKEY("WearOffOther",  skill->msg_off_other);
                  break;
            }

            if (!fMatch)
                  db_error("load_skill", "%s: Unknown keyword", word);
      }
}
