/*  $Id: db_tattoo.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>

#include "merc.h"
#include "db.h"

DECLARE_DBLOAD_FUN(load_tattoo);

DBFUN db_load_tattoo[] =
{
    { "TATTOO",   load_tattoo},
    { NULL}
};

DECLARE_DBLOAD_FUN(load_paint);

DBFUN db_load_paint[] =
{
    { "PAINT",   load_paint},
    { NULL}
};

DBLOAD_FUN(load_tattoo)
{
    tattoo_t * tattoo;

    tattoo = tattoo_new();
    
    for (;;)
    {
        char *word = feof(fp) ? "End" : fread_word(fp);
        bool fMatch = FALSE;

        switch (UPPER(word[0]))
        {
        case 'A':
            if (!str_cmp(word, "ActComp"))
            {
                int num = fread_number (fp);
                int vnum = fread_number (fp);
                if (num >= 0 && num < MAX_TATTOO_COMP)
                    // todo: validate?
                    tattoo->act_comp[num] = vnum;
                fMatch = TRUE;
            }
            break;

        case 'D':
            MLSKEY("Desc",       tattoo->desc);
            break;

        case 'E':
            if (!str_cmp(word, "End"))
            {
                if (IS_NULLSTR(tattoo->name))
                {
                    db_error("load_tattoo",
                             "tattoo name not defined");
                    tattoo_free(tattoo);
                    tattooes.nused--;
                }
                return;
            }
            KEY("Extra",   tattoo->extra, fread_flags(fp));
            break;

        case 'M':
            KEY("MinSkill",   tattoo->min_skill, fread_number(fp));
            KEY("MaxAct",     tattoo->max_activations, fread_number(fp));
            break;

        case 'N':
            SKEY("Name",       tattoo->name);
            break;

        case 'P':
            if (!str_cmp(word, "PaintComp"))
            {
                int num = fread_number (fp);
                int vnum = fread_number (fp);
                if (num >= 0 && num < MAX_TATTOO_COMP)
                    // todo: validate?
                    tattoo->paint_comp[num] = vnum;
                fMatch = TRUE;
            }
            KEY("Paints", tattoo->paints, fread_flags(fp));
            break;

        case 'W':
            KEY("WaitAct",   tattoo->wait_act, fread_number(fp));
            KEY("WaitPaint", tattoo->wait_paint, fread_number(fp));
            KEY("WearLoc",   tattoo->wear_loc, fread_flags(fp));
            break;
        }

        if (!fMatch)
            db_error("load_tattoo", "%s: Unknown keyword", word);
    }
}

DBLOAD_FUN(load_paint)
{
    paint_t * paint;

    paint = paint_new();
    
    for (;;)
    {
        char *word = feof(fp) ? "End" : fread_word(fp);
        bool fMatch = FALSE;

        switch (UPPER(word[0]))
        {
        case 'C':
            KEY("Color", paint->color, fread_number(fp));
            if (!str_cmp(word, "Component"))
            {
                int num = fread_number (fp);
                int vnum = fread_number (fp);
                if (num >= 0 && num < MAX_RITUAL_COMP)
                    // todo: validate?
                    paint->components[num] = vnum;
                fMatch = TRUE;
            }
            break;

        case 'E':
            if (!str_cmp(word, "End"))
            {
                if (IS_NULLSTR(paint->name))
                {
                    db_error("load_paint",
                             "paint name not defined");
                    paint_free(paint);
                    paints.nused--;
                }
                return;
            }
            break;

        case 'L':
            MLSKEY("Long", paint->desc);
            break;

        case 'M':
            KEY("MinSkill", paint->min_skill, fread_number(fp));
            KEY("Mana", paint->mana_cost, fread_number(fp));
            KEY("MaxPort", paint->max_portions, fread_number(fp));
            break;

        case 'N':
            SKEY("Name", paint->name);
            break;

        case 'O':
            SKEY("ObjName", paint->obj_name);
            break;

        case 'P':
            KEY("Power", paint->power, fread_number(fp));
            break;

        case 'S':
            MLSKEY("Short", paint->short_desc);
            break;
        }

        if (!fMatch)
            db_error("load_paint", "%s: Unknown keyword", word);
    }
}
