/*  $Id: dofun.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>

#include "typedef.h"
#include "namedp.h"
#include "dofun.h"

namedp_t dofun_table[] =
{
    { "do_add_bp",          do_add_bp               },
    { "do_add_qp",          do_add_qp               },
    { "do_add_rp",          do_add_rp               },
    { "do_addapply",        do_addapply             },
    { "do_admin",           do_admin                },
    { "do_advance",         do_advance              },
    { "do_advisor",         do_advisor              },
    { "do_advself",         do_advself              },
    { "do_affects",         do_affects              },
    { "do_affrooms",        do_affrooms             },
    { "do_afk",             do_afk                  },
    { "do_alia",            do_alia                 },
    { "do_alias",           do_alias                },
    { "do_alist",           do_alist                },
    { "do_allow",           do_allow                },
    { "do_ambush",          do_ambush               },
    { "do_analyse",         do_analyse              },
    { "do_knowmob",         do_knowmob              },
    { "do_annihilate",      do_annihilate           },
    { "do_answer",          do_answer               },
    { "do_anvil",           do_anvil                },
    { "do_areas",           do_areas                },
    { "do_arrest",          do_arrest               },
    { "do_asave",           do_asave                },
    { "do_ashow",           do_ashow                },
    { "do_ask",             do_ask                  },
    { "do_assassinate",     do_assassinate          },
    { "do_at",              do_at                   },
    { "do_auction",         do_auction              },
    { "do_autorepair",      do_autorepair           },
    { "do_autoskills",      do_autoskills           },
    { "do_axedigging",      do_axedigging           },

    { "do_backhand",        do_backhand             },
    { "do_backstab",        do_backstab             },
    { "do_balance",         do_balance              },
    { "do_bamfin",          do_bamfin               },
    { "do_bamfout",         do_bamfout              },
    { "do_ban",             do_ban                  },
    { "do_bandage",         do_bandage              },
    { "do_bash",            do_bash                 },
    { "do_bash_door",       do_bash_door            },
    { "do_bd",              do_bd                   },
    { "do_beret",           do_beret                },
    { "do_berserk",         do_berserk              },
    { "do_blackjack",       do_blackjack            },
    { "do_bleed",           do_bleed                },
    { "do_blindness_dust",  do_blindness_dust       },
    { "do_blink",           do_blink                },
    { "do_bloodthirst",     do_bloodthirst          },
    { "do_body",            do_body                 },
    { "do_boneshatter",     do_boneshatter          },
    { "do_bonus",           do_bonus                },
    { "do_bppractice",      do_bppractice           },
    { "do_brandish",        do_brandish             },
    { "do_bribe",           do_bribe                },
    { "do_btalk",           do_btalk                },
    { "do_bug",             do_bug                  },
    { "do_butcher",         do_butcher              },
    { "do_buy",             do_buy                  },

    { "do_cache",           do_cache                },
    { "do_caltrops",        do_caltrops             },
    { "do_camouflage",      do_camouflage           },
    { "do_camp",            do_camp                 },
    { "do_cannon",          do_cannon               },
    { "do_cast",            do_cast                 },
    { "do_castout",         do_castout              },
    { "do_cconfig",         do_cconfig              },
    { "do_changes",         do_changes              },
    { "do_channels",        do_channels             },
    { "do_charge",          do_charge               },
    { "do_charge_set",      do_charge_set           },
    { "do_chat",            do_chat                 },
    { "do_check",           do_check                },
    { "do_choke",           do_choke                },
    { "do_circle",          do_circle               },
    { "do_clan",            do_clan                 },
    { "do_allytalk",        do_allytalk             },
    { "do_clanbank",        do_clanbank             },
    { "do_clanreward",      do_clanreward           },
    { "do_clanlist",        do_clanlist             },
    { "do_claws",           do_claws                },
    { "do_clear",           do_clear                },
    { "do_cleave",          do_cleave               },
    { "do_climat",          do_climat               },
    { "do_clone",           do_clone                },
    { "do_close",           do_close                },
    { "do_commands",        do_commands             },
    { "do_compare",         do_compare              },
    { "do_compress",        do_compress             },
    { "do_concentrate",     do_concentrate          },
    { "do_condemn",         do_condemn              },
    { "do_confiscate",      do_confiscate           },
    { "do_conquer",         do_conquer              },
    { "do_consider",        do_consider             },
    { "do_count",           do_count                },
    { "do_create",          do_create               },
    { "do_crecall",         do_crecall              },
    { "do_credits",         do_credits              },
    { "do_crossslice",      do_crossslice           },
    { "do_crush_boots",     do_crush_boots          },
    { "do_cutreply",        do_cutreply             },

    { "do_date",            do_date                 },
    { "do_deaf",            do_deaf                 },
    { "do_deathgrip",       do_deathgrip            },
    { "do_delet",           do_delet                },
    { "do_delete",          do_delete               },
    { "do_demand",          do_demand               },
    { "do_demon",           do_demon                },
    { "do_deny",            do_deny                 },
    { "do_deposit",         do_deposit              },
    { "do_description",     do_description          },
    { "do_detect_hidden",   do_detect_hidden        },
    { "do_deliverance",     do_deliverance          },
    { "do_devtalk",         do_devtalk              },
    { "do_diplomacy",       do_diplomacy            },
    { "do_dirt",            do_dirt                 },
    { "do_disable",         do_disable              },
    { "do_disarm",          do_disarm               },
    { "do_disciplines",     do_disciplines          },
    { "do_disconnect",      do_disconnect           },
    { "do_dishonor",        do_dishonor             },
    { "do_dismount",        do_dismount             },
    { "do_divorce",         do_divorce              },
    { "do_donate",          do_donate               },
    { "do_down",            do_down                 },
    { "do_draw",            do_draw                 },
    { "do_drink",           do_drink                },
    { "do_drop",            do_drop                 },
    { "do_drumming_maces",  do_drumming_maces       },
    { "do_duel",            do_duel                 },
    { "do_dump",            do_dump                 },

    { "do_east",            do_east                 },
    { "do_eat",             do_eat                  },
    { "do_echo",            do_echo                 },
    { "do_edit",            do_edit                 },
    { "do_embalmment",      do_embalmment           },
    { "do_emote",           do_emote                },
    { "do_empower",         do_empower              },
    { "do_element",         do_element              },
    { "do_enable",          do_enable               },
    { "do_enchant",         do_enchant              },
    { "do_endure",          do_endure               },
    { "do_enter",           do_enter                },
    { "do_envenom",         do_envenom              },
    { "do_equipment",       do_equipment            },
    { "do_escape",          do_escape               },
    { "do_estimate",        do_estimate             },
    { "do_examine",         do_examine              },
    { "do_execute",         do_execute              },
    { "do_exits",           do_exits                },
    { "do_explock",         do_explock              },
    { "do_explode",         do_explode              },
    { "do_explored",        do_explored             },
    { "do_eyejab",          do_eyejab               },

    { "do_fade",            do_fade                 },
    { "do_feint",           do_feint                },
    { "do_fill",            do_fill                 },
    { "do_find",            do_find                 },
    { "do_fix",             do_fix                  },
    { "do_flee",            do_flee                 },
    { "do_flurry",          do_flurry               },
    { "do_fly",             do_fly                  },
    { "do_follow",          do_follow               },
    { "do_force",           do_force                },
    { "do_forest",          do_forest               },
    { "do_forge",           do_forge                },
    { "do_forger",          do_forger               },
    { "do_forget",          do_forget               },
    { "do_fortitude",       do_fortitude            },
    { "do_form",            do_form                 },
    { "do_freeze",          do_freeze               },
    { "do_fvlist",          do_fvlist               },

    { "do_gaffects",        do_gaffects             },
    { "do_gain",            do_gain                 },
    { "do_gamble",          do_gamble               },
    { "do_get",             do_get                  },
    { "do_give",            do_give                 },
    { "do_glist",           do_glist                },
    { "do_gossip",          do_gossip               },
    { "do_goto",            do_goto                 },
    { "do_gquest",          do_gquest               },
    { "do_grant",           do_grant                },
    { "do_group",           do_group                },
    { "do_gtell",           do_gtell                },
    { "do_guard",           do_guard                },

    { "do_hara",            do_hara                 },
    { "do_hash",            do_hash                 },
    { "do_headprice",       do_headprice            },
    { "do_heal",            do_heal                 },
    { "do_help",            do_help                 },
    { "do_herbs",           do_herbs                },
    { "do_herotalk",        do_herotalk             },
    { "do_hide",            do_hide                 },
    { "do_history",         do_history              },
    { "do_holylight",       do_holylight            },
    { "do_hometown",        do_hometown             },
    { "do_horn_prick",      do_horn_prick           },
    { "do_human",           do_human                },
    { "do_humor",           do_humor                },
    { "do_hunt",            do_hunt                 },

    { "do_idea",            do_idea                 },
    { "do_identify",        do_identify             },
    { "do_immdescription",  do_immdescription       },
    { "do_immname",         do_immname              },
    { "do_immtalk",         do_immtalk              },
    { "do_imotd",           do_imotd                },
    { "do_improvement",     do_improvement          },
    { "do_incognito",       do_incognito            },
    { "do_info",            do_info                 },
    { "do_inventory",       do_inventory            },
    { "do_invis",           do_invis                },
    { "do_ititle",          do_ititle               },

    { "do_judge",           do_judge                },

    { "do_katana",          do_katana               },
    { "do_kick",            do_kick                 },
    { "do_kidnap",          do_kidnap               },
    { "do_kill",            do_kill                 },
    { "do_label",           do_label                },
    { "do_lang",            do_lang                 },
    { "do_lash",            do_lash                 },
    { "do_layhands",        do_layhands             },
    { "do_learn",           do_learn                },
    { "do_leg_sweep",       do_leg_sweep            },
    { "do_limit_strip",     do_limit_strip          },
    { "do_limited",         do_limited              },
    { "do_links",           do_links                },
    { "do_lion_call",       do_lion_call            },
    { "do_list",            do_list                 },
    { "do_listen",          do_listen               },
    { "do_load",            do_load                 },
    { "do_lock",            do_lock                 },
    { "do_log",             do_log                  },
    { "do_look",            do_look                 },
    { "do_lore",            do_lore                 },

    { "do_maintain",        do_maintain             },
    { "do_make",            do_make                 },
    { "do_manage",          do_manage               },
    { "do_marry",           do_marry                },
    { "do_mech",            do_mech                 },
    { "do_medical_help",    do_medical_help         },
    { "do_memory",          do_memory               },
    { "do_merge",           do_merge                },
    { "do_mining",          do_mining               },
    { "do_mintage",         do_mintage              },
    { "do_miracles",        do_miracles             },
    { "do_mob",             do_mob                  },
    { "do_motd",            do_motd                 },
    { "do_mount",           do_mount                },
    { "do_mpstat",          do_mpstat               },
    { "do_msgstat",         do_msgstat              },
    { "do_mtset",           do_mtset                },
    { "do_mtshow",          do_mtshow               },
    { "do_muddy",           do_muddy                },
    { "do_muddyshow",       do_muddyshow            },
    { "do_murde",           do_murde                },
    { "do_murder",          do_murder               },
    { "do_music",           do_music                },
    { "do_mwhere",          do_mwhere               },
    { "do_myrank",          do_myrank               },

    { "do_needle_prick",    do_needle_prick         },
    { "do_nerve",           do_nerve                },
    { "do_newlock",         do_newlock              },
    { "do_news",            do_news                 },
    { "do_no_pk",           do_no_pk                },
    { "do_noaffect",        do_noaffect             },
    { "do_nochannels",      do_nochannels           },
    { "do_noemote",         do_noemote              },
    { "do_noexp",           do_noexp                },
    { "do_nofollow",        do_nofollow             },
    { "do_nogive",          do_nogive               },
    { "do_noquest",         do_noquest              },
    { "do_nonote",          do_nonote               },
    { "do_north",           do_north                },
    { "do_nocast",          do_nocast               },
    { "do_nosummon",        do_nosummon             },
    { "do_note",            do_note                 },
    { "do_notell",          do_notell               },
    { "do_notitle",         do_notitle              },
    { "do_nowar",           do_nowar                },
    { "do_nowhois",         do_nowhois              },
    { "do_nuclear_strike",  do_nuclear_strike       },

    { "do_objectfindwearlocation", do_objectfindwearlocation   },
    { "do_objlist",         do_objlist              },
    { "do_ooc",             do_ooc                  },
    { "do_open",            do_open                 },
    { "do_order",           do_order                },
    { "do_oscore",          do_oscore               },
    { "do_oskills",         do_oskills              },
    { "do_ospells",         do_ospells              },
    { "do_outfit",          do_outfit               },
    { "do_overhead",        do_overhead             },
    { "do_owhere",          do_owhere               },
    { "do_owner",           do_owner                },

    { "do_password",        do_password             },
    { "do_peace",           do_peace                },
    { "do_peacefu",         do_peacefu              },
    { "do_peaceful",        do_peaceful             },
    { "do_pecho",           do_pecho                },
    { "do_penalty",         do_penalty              },
    { "do_permban",         do_permban              },
    { "do_petitio",         do_petitio              },
    { "do_petition",        do_petition             },
    { "do_pick",            do_pick                 },
    { "do_pincer",          do_pincer               },
    { "do_pipe",            do_pipe                 },
    { "do_pload",           do_pload                },
    { "do_pmote",           do_pmote                },
    { "do_poison_smoke",    do_poison_smoke         },
    { "do_popularity",      do_popularity           },
    { "do_pose",            do_pose                 },
    { "do_pour",            do_pour                 },
    { "do_powers",          do_powers               },
    { "do_practice",        do_practice             },
    { "do_pray",            do_pray                 },
    { "do_prefi",           do_prefi                },
    { "do_prefix",          do_prefix               },
    { "do_pretitle",        do_pretitle             },
    { "do_price",           do_price                },
    { "do_programs",        do_programs             },
    { "do_promote",         do_promote              },
    { "do_prompt",          do_prompt               },
    { "do_proposal",        do_proposal             },
    { "do_protect",         do_protect              },
    { "do_pugil",           do_pugil                },
    { "do_punload",         do_punload              },
    { "do_purge",           do_purge                },
    { "do_push",            do_push                 },
    { "do_put",             do_put                  },
    { "do_pwipe",           do_pwipe                },
    { "do_qppractice",      do_qppractice           },
    { "do_qptrans",         do_qptrans              },
    { "do_quaff",           do_quaff                },
    { "do_quest",           do_quest                },
    { "do_qui",             do_qui                  },
    { "do_quickdraw",       do_quickdraw            },
    { "do_quiet",           do_quiet                },
    { "do_quit",            do_quit                 },

    { "do_raffects",        do_raffects             },
    { "do_ranking",         do_ranking              },
    { "do_rating",          do_rating               },
    { "do_readext",         do_readext              },
    { "do_reboo",           do_reboo                },
    { "do_reboot",          do_reboot               },
    { "do_recall",          do_recall               },
    { "do_recho",           do_recho                },
    { "do_recite",          do_recite               },
    { "do_reelin",          do_reelin               },
    { "do_remember",        do_remember             },
    { "do_remove",          do_remove               },
    { "do_rename",          do_rename               },
    { "do_renegate",        do_renegate             },
    { "do_rent",            do_rent                 },
    { "do_repair",          do_repair               },
    { "do_repeat",          do_repeat               },
    { "do_replay",          do_replay               },
    { "do_reply",           do_reply                },
    { "do_report",          do_report               },
    { "do_request",         do_request              },
    { "do_rescue",          do_rescue               },
    { "do_resets",          do_resets               },
    { "do_resistance",      do_resistance           },
    { "do_resoul",          do_resoul               },
    { "do_rest",            do_rest                 },
    { "do_restore",         do_restore              },
    { "do_return",          do_return               },
    { "do_reunion",         do_reunion              },
    { "do_reward",          do_reward               },
    { "do_rtalk",           do_rtalk                },
    { "do_rules",           do_rules                },

    { "do_sacrifice",       do_sacrifice            },
    { "do_saffects",        do_saffects             },
    { "do_save",            do_save                 },
    { "do_say",             do_say                  },
    { "do_scalp",           do_scalp                },
    { "do_scan",            do_scan                 },
    { "do_score",           do_score                },
    { "do_scribe",          do_scribe               },
    { "do_scroll",          do_scroll               },
    { "do_second_wield",    do_second_wield         },
    { "do_sell",            do_sell                 },
    { "do_send",            do_send                 },
    { "do_sense",           do_sense                },
    { "do_set",             do_oldset                  },
    { "do_setext",          do_setext               },
    { "do_settraps",        do_settraps             },
    { "do_sharpen",         do_sharpen              },
    { "do_sheathe",         do_sheathe              },
    { "do_shield",          do_shield               },
    { "do_shiftweapon",     do_shiftweapon          },
    { "do_shoot",           do_shoot                },
    { "do_shout",           do_shout                },
    { "do_shutdow",         do_shutdow              },
    { "do_shutdown",        do_shutdown             },
    { "do_sing",            do_sing                 },
    { "do_sit",             do_sit                  },
    { "do_skills",          do_skills               },
    { "do_sla",             do_sla                  },
    { "do_slay",            do_slay                 },
    { "do_sleep",           do_sleep                },
    { "do_slook",           do_slook                },
    { "do_slot",            do_slot                 },
    { "do_smelt",           do_smelt                },
    { "do_smite",           do_smite                },
    { "do_smithing",        do_smithing             },
    { "do_smote",           do_smote                },
    { "do_snare",           do_snare                },
    { "do_sneak",           do_sneak                },
    { "do_snoop",           do_snoop                },
    { "do_socials",         do_socials              },
    { "do_sockets",         do_sockets              },
    { "do_songs",           do_songs                },
    { "do_soul",            do_soul                 },
    { "do_soulswitch",      do_soulswitch           },
    { "do_south",           do_south                },
    { "do_speak",           do_speak                },
    { "do_specialization",  do_specialization       },
    { "do_specreset",       do_specreset            },
    { "do_spellbane",       do_spellbane            },
    { "do_spells",          do_spells               },
    { "do_split",           do_split                },
    { "do_sprecall",        do_sprecall             },
    { "do_sptalk",          do_sptalk               },
    { "do_spy",             do_spy                  },
    { "do_stance",          do_stance               },
    { "do_style",           do_style                },
    { "do_stand",           do_stand                },
    { "do_stat",            do_stat                 },
    { "do_steal",           do_steal                },
    { "do_stealth",         do_stealth              },
    { "do_stimpack",        do_stimpack             },
    { "do_strangle",        do_strangle             },
    { "do_string",          do_string               },
    { "do_strip_weapon",    do_strip_weapon         },
    { "do_strstat",         do_strstat              },
    { "do_study",           do_study                },
    { "do_surrender",       do_surrender            },
    { "do_switch",          do_switch               },

    { "do_tail",            do_tail                 },
    { "do_tame",            do_tame                 },
    { "do_target",          do_target               },
    { "do_taunt",           do_taunt                },
    { "do_teach",           do_teach                },
    { "do_tell",            do_tell                 },
    { "do_thornsaura",      do_thornsaura           },
    { "do_throw",           do_throw                },
    { "do_thumbling",       do_thumbling            },
    { "do_tick",            do_tick                 },
    { "do_tiger",           do_tiger                },
    { "do_time",            do_time                 },
    { "do_title",           do_title                },
    { "do_toggle",          do_toggle               },
    { "do_track",           do_track                },
    { "do_train",           do_train                },
    { "do_transaction",     do_transaction          },
    { "do_transfer",        do_transfer             },
    { "do_trap",            do_trap                 },
    { "do_trip",            do_trip                 },
    { "do_trophy",          do_trophy               },
    { "do_truesight",       do_truesight            },
    { "do_trust",           do_trust                },
    { "do_twit",            do_twit                 },
    { "do_typo",            do_typo                 },

    { "do_ultravision",     do_ultravision          },
    { "do_unalias",         do_unalias              },
    { "do_undercut",        do_undercut             },
    { "do_universal_cast",  do_universal_cast       },
    { "do_unlock",          do_unlock               },
    { "do_unread",          do_unread               },
    { "do_up",              do_up                   },
    { "do_use",             do_use                  },

    { "do_value",           do_value                },
    { "do_vampire",         do_vampire              },
    { "do_vanish",          do_vanish               },
    { "do_vbite",           do_vbite                },
    { "do_violate",         do_violate              },
    { "do_visible",         do_visible              },
    { "do_vnum",            do_vnum                 },
    { "do_vtouch",          do_vtouch               },

    { "do_wake",            do_wake                 },
    { "do_wanted",          do_wanted               },
    { "do_warcry",          do_warcry               },
    { "do_warfare",         do_warfare              },
    { "do_warstat",         do_warstat              },
    { "do_warparm",         do_warparm              },
    { "do_weapon",          do_weapon               },
    { "do_weaponsong",      do_weaponsong           },
    { "do_wear",            do_wear                 },
    { "do_weather",         do_weather              },
    { "do_weddingroom",     do_weddingroom          },
    { "do_west",            do_west                 },
    { "do_where",           do_where                },
    { "do_who",             do_who                  },
    { "do_whois",           do_whois                },
    { "do_wimpy",           do_wimpy                },
    { "do_wish",            do_wish                 },
    { "do_withdraw",        do_withdraw             },
    { "do_wizhelp",         do_wizhelp              },
    { "do_wizlist",         do_wizlist              },
    { "do_wizlock",         do_wizlock              },
    { "do_wiznet",          do_wiznet               },
    { "do_worth",           do_worth                },
    { "do_woodchop",        do_woodchop             },
    { "do_wquest",          do_wquest               },

    { "do_yell",            do_yell                 },

    { "do_zap",             do_zap                  },
    { "do_zecho",           do_zecho                },

    { "do_immolation",      do_immolation           },
    { "do_metamorphosis",   do_metamorphosis        },
    { "do_bearform",        do_bearform             },
    { "do_wolfform",        do_wolfform             },
    { "do_rejuvenation",    do_rejuvenation         },
    { "do_datetime",        do_datetime             },
    { "do_gc",              do_gc                   },
    { "do_ejection",        do_ejection             },
    { "do_abilities",       do_abilities            },
    { "do_languages",       do_languages            },
    { "do_do",              do_do                   },
    { "do_desc_check",      do_desc_check           },

    { "do_validate",        do_validate             },

    { "do_ogrep",           do_ogrep                },
    { "do_mgrep",           do_mgrep                },
    { "do_rgrep",           do_rgrep                },

    { "do_autosnoop",       do_autosnoop            },
    { "do_commshow",        do_commshow             },

    // Welesh : commands TODO
    { "do_clanhistory",     do_clanhistory          },
    { "do_clanstock",       do_clanstock            },
    { "do_perform",         do_perform              },
    { "do_activate",        do_activate             },
    { "do_voodoo",          do_voodoo               },
    { "do_adventure",       do_adventure            },
    { "do_tattooes",        do_tattooes             },
    { "do_rituals",         do_rituals              },
    { "do_name",            do_name                 },

    // event system
    { "do_mestat",          do_mestat               },
    { "do_aestat",          do_aestat               },
    { "do_oestat",          do_oestat               },
    { "do_restat",          do_restat               },
    { "do_rmaterial",       do_rmaterial            },

    { "do_keyring",         do_keyring              },
    { "do_notrack",         do_notrack              },
    { "do_newset",          do_set                  },

    { NULL }
};

// TODO: temporary disabled
//    { "do_artefact", do_artefact },
//    { "do_examine_deck", do_examine_deck },
//    { "do_examine_hand", do_examine_hand },
//    { "do_examine_table", do_examine_table },
//    { "do_createtable", do_CreateTable },
//    { "do_createhand", do_CreateHand },
//    { "do_createdeck", do_CreateDeck },
//    { "do_statdeck", do_StatDeck },
//    { "do_lay_card", do_lay_card },
//    { "do_cover_card", do_cover_card },
//    { "do_deal_card", do_deal_card },
