/* $Id: hometown.h,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#ifndef _HOMETOWN_H_
#define _HOMETOWN_H_

struct altar_t {
	ROOM_INDEX_DATA *	room;
	OBJ_INDEX_DATA *	pit;
};

struct hometown_t {
	const char* area;

	ROOM_INDEX_DATA *	recall[MAX_ANUM];	/* recall points */
	OBJ_INDEX_DATA *	map[MAX_ANUM];		/* maps		 */
	altar_t			altar[MAX_ANUM];
	const char *		restrict_race;
	const char *		restrict_class;
	flag32_t		restrict_align;
	flag32_t		flags;
};

/* hometown flags */
#define HOMETOWN_HIDDEN 	(A)     /* hometown will not appear in who */
#define HOMETOWN_CLASSES_RESTRICTED	(B)
#define HOMETOWN_RACES_RESTRICTED (C)
#define HOMETOWN_CHANGED    (Z)

extern varr hometowns;

hometown_t * 	hometown_new(void);
int		htn_lookup	(const char *name);
const char *	hometown_name	(int htn);

#define HOMETOWN(htn)	((hometown_t*) VARR_GET(&hometowns, htn))

bool		hometown_restrict(hometown_t *h, CHAR_DATA *ch);
void		hometown_print_avail(CHAR_DATA *ch);
int 		hometown_permanent(CHAR_DATA *ch);

ROOM_INDEX_DATA*	get_recall(CHAR_DATA *ch);
OBJ_INDEX_DATA*		get_map(CHAR_DATA *ch);
ROOM_INDEX_DATA*	get_random_recall(void);
altar_t *		get_altar(CHAR_DATA *ch);

#endif
