/* $Id: liquid.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "merc.h"

varr liquids  = {sizeof (liquid_t), 4};

liquid_t * liquid_new ()
{
     liquid_t * liquid;

     liquid                       = varr_enew (&liquids);
     liquid->name                 = str_empty;
     liquid->color                = str_empty;
     liquid->food                 = 0;
     liquid->full                 = 0;
     liquid->proof                = 0;
     liquid->thirst               = 0;
     liquid->ssize                = 0;

     return liquid ;
}

void liquid_free(liquid_t *liquid)
{
    free_string(liquid->name);
    free_string(liquid->color);

    free(liquid);
}


const char * liquid_name(int ln)
{
      liquid_t *liquid;

      if (ln < 0)
            return str_empty;

      liquid = LIQUID(ln);


      if (liquid == NULL)
            return "none";
      else
            return liquid->name;

}

const char * liquid_color(int ln)
{
      liquid_t *liquid;

      if (ln < 0)
            return str_empty;;

      liquid = LIQUID(ln);

      if (liquid == NULL)
            return "none";
      else
            return liquid->color;

}

int liquid_lookup(const char *name)
{
     int liq;

     for (liq = 0; liq < liquids.nused; liq++)
         if (!str_cmp(name, LIQUID(liq)->name))
              return liq;

     return -1;
}

void show_liquid_types(BUFFER *output)
{
     int  liq;
     int  col;

     col = 0;

     for (liq = 0; liq < liquids.nused; liq++)
     {
          buf_printf(output, "%-19.18s", LIQUID(liq)->name);
          if (++col % 4 == 0)
                buf_add(output, "\n");
     }

     if (col % 4)
               buf_add(output, "\n");
}


void show_liquidlist(CHAR_DATA *ch)
{
     int liq;
     BUFFER *buffer;

     buffer = buf_new(-1);

     buf_add(buffer,"Name                 Color          Proof Full Thirst Food Ssize\n");

     for (liq = 0; liq < liquids.nused; liq++)
          buf_printf(buffer, "%-20s %-14s %5d %4d %6d %4d %5d\n",
                    LIQUID(liq)->name,
                    LIQUID(liq)->color,
                    LIQUID(liq)->proof,
                    LIQUID(liq)->full,
                    LIQUID(liq)->thirst,
                    LIQUID(liq)->food,
                    LIQUID(liq)->ssize);

     page_to_char(buf_string(buffer), ch);
     buf_free(buffer);
}
