/* $Id: liquid.h,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#ifndef _LIQUID_H_
#define _LIQUID_H_

typedef struct liquid_t liquid_t;

struct liquid_t
{
     const char  *name;    // Name key
     const char  *color;   // Color

     int          proof;   // Proof
     int          full;    // Full
     int          thirst;  // Thirst
     int          food;    // Food
     int          ssize;   // Ssize
     flag64_t     flag;    // Flags
};


liquid_t *         liquid_new     (void);
void               liquid_free    (liquid_t*);

extern varr     liquids;

int          liquid_lookup           (const char *name);
void         show_liquid_types       (BUFFER *output);
void         show_liquidlist         (CHAR_DATA *ch);
const char  *liquid_color            (int liquid_n);
const char  *liquid_name             (int liquid_n);


#define LIQUID(liq_n)         ((liquid_t*) VARR_GET(&liquids, liq_n))
//#define liquid_lookup(liq_n)  ((liquid_t*) varr_get(&liquids, liq_n))

#endif

