/* $Id: planet.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */
/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 
#include <stdio.h>

#include "typedef.h"
#include "varr.h"
#include "socials.h"
#include "str.h"
#include "merc.h"

varr planets = { sizeof(planet_t), 4 };


planet_t *planet_new(void)
{
    planet_t *planet;

    planet                     = varr_enew(&planets);
    
    planet->skill_group.nsize  = sizeof(planet_skill_group);
    planet->skill_group.nstep  = 4;
    
    planet->moons.nsize        = sizeof(planet_moon);
    planet->moons.nstep        = 4;
    
    planet->solars.nsize       = sizeof(planet_solar);
    planet->solars.nstep       = 4;
    
    planet->name               = str_empty;
    

    return planet;
}

void planet_free(planet_t *planet)
{
    varr_free(&planet->skill_group);
    varr_free(&planet->solars);
    varr_free(&planet->moons);
    
    free_string(planet->name);
}

// Return planet name 
const char *planet_name(int pn)
{
    planet_t *planet;

    planet = planet_lookup(pn);
    
    if (planet == NULL)
        return "unknown";
        
    return planet->name;
}


int pn_lookup(const char *name)
{
    int i;

    for (i = 0; i < planets.nused; i++)
    {
        if (!str_cmp(name, PLANET(i)->name))
            return i;
    }

    return -1;
}

