/* $Id: planet.h,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#ifndef _PLANET_H_
#define _PLANET_H_

#define PLANET_CHANGED            (A)


typedef struct planet_skill_group     planet_skill_group;
typedef struct planet_moon            planet_moon;
typedef struct planet_solar           planet_solar;
typedef struct planet_t               planet_t;


//TODO: in table.c planet_flag also
/*
flag_t planet_flag[] =
{
      { str_empty,         TABLE_BITVAL,               },
      { "changed",         PLANET_CHANGED, FALSE       },
      
      {NULL}
};
*/
struct planet_skill_group
{
      flag32_t            discipline;
      int                 delta;
};

struct planet_moon
{
      const char         *name;
};

struct planet_solar
{
      const char         *name;
};

struct planet_t
{
      const char         *name;
      flag64_t            flags;
      
      int                 gravity;
      int                 planet_id;
      int                 magic_mod;
            
      varr                skill_group;
      varr                moons;
      varr                solars;
};

extern varr planets;

#define PLANET(pn)             ((planet_t*) VARR_GET(&planets, pn))
#define planet_lookup(pn)      ((planet_t*) varr_get(&planets, pn))

planet_t *         planet_new   (void);
void               planet_free  (planet_t *planet);
const char *       planet_name  (int pn);
int                pn_lookup    (const char *name);


#endif


