/* $Id: socials.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#include <stdio.h>

#include "typedef.h"
#include "varr.h"
#include "socials.h"
#include "str.h"
#include "merc.h"

varr socials = { sizeof(social_t), 8 };

social_t *social_new()
{
    social_t *soc;

    soc =  varr_enew(&socials);

    soc->alias = str_empty;
    soc->description = str_empty;
    soc->age = 0;
    soc->level = 0;
    
    return soc;

}

void social_free(social_t *soc)
{
        free_string(soc->name);
        free_string(soc->alias);
        free_string(soc->description);
        
        free_string(soc->all_char);
        free_string(soc->all_room);
        free_string(soc->all_self);

        free_string(soc->found_char);
        free_string(soc->found_vict);
        free_string(soc->found_notvict);

        free_string(soc->noarg_char);
        free_string(soc->noarg_room);

        free_string(soc->self_char);
        free_string(soc->self_room);

        free_string(soc->notfound_char);
}

social_t *social_lookup(const char *name,
                        int (*cmpfun)(const char *s1, const char *s2))
{
        int i;

        for (i = 0; i < socials.nused; i++) 
        {
                social_t *soc = VARR_GET(&socials, i);
                if (!cmpfun(name, soc->name) || is_name(name, soc->alias))
                        return soc;
        }

        return NULL;
}
