/* $Id: socials.h,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#ifndef _SOCIALS_H_
#define _SOCIALS_H_

/*
 * Structure for a social in the socials table.
 */
struct social_t
{
    const char *    name;
    flag32_t        min_pos;
    const char *    alias;
    const char *    description;

    const char *    found_char;
    const char *    found_vict;
    const char *    found_notvict;

    const char *    noarg_char;
    const char *    noarg_room;

    const char *    self_char;
    const char *    self_room;

    const char *    notfound_char;
    
    const char *    all_char;
    const char *    all_room;
    const char *    all_self;
    
    int             age;
    int             level;
};
typedef struct social_t social_t;

extern varr socials;

social_t *	social_new();
void		social_free(social_t *soc);
social_t *	social_lookup(const char *name,
			      int (*cmpfun)(const char *s1, const char *s2));
#define find_social(name) \
			social_lookup((name), str_cmp)
#endif
