/* $Id: specvar.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

 
#include <stdio.h>
#include <stdlib.h>

#include "merc.h"
#include "fight.h"

varr specvars  = {sizeof (specvar_t), 4};

specvar_t * specvar_new ()
{
        specvar_t * specvar;

        specvar                        = varr_enew (&specvars);
        specvar->vars.nsize            = sizeof (vars_t);
        specvar->vars.nstep            = 4;
        specvar->name                  = str_empty;

        return specvar ;
}

void specvar_free(specvar_t *specvar)
{
    free_string(specvar->name);
    varr_free(&specvar->vars);
    
    free(specvar);
}

