/* $Id: specvar.h,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#ifndef _SPECVAR_H_
#define _SPECVAR_H_

typedef struct specvar_t specvar_t;
typedef struct vars_t    vars_t;

struct specvar_t
{
    const char * name;      // Name key
    varr         vars;      // Vars
};

struct vars_t
{
    const char * name;      // variables name
    int          value;     // 
};


specvar_t *       specvar_new     (void);
void              specvar_free    (specvar_t*);

extern varr specvars;


#define SPECVAR(sn)        ((specvar_t*) VARR_GET(&specvars, sn))
#define specvar_lookup(sn) ((specvar_t*) varr_get(&specvars, sn))


#define specvar_vars_lookup(specvar, str) \
    ((vars_t*) varr_bsearch(&specvar->vars, &str, cmpstr))

#endif
