/* $Id: effects.c,v 1.666 2004/09/20 10:49:48 shrike Exp $                    */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 /************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"
#include "update.h"
#include "war.h"

void sound_effect(void *vo, int level, int dam, int target)
{
    if (target == TARGET_ROOM)
    {
        ROOM_INDEX_DATA *room = (ROOM_INDEX_DATA *) vo;
        OBJ_DATA *obj, *obj_next;

        for (obj = room->contents; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
//            acid_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }
    if (target == TARGET_CHAR) 
    {
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        OBJ_DATA *obj, *obj_next;

        for (obj = victim->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
//            acid_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }
}

void acid_effect(void *vo, int level, int dam, int target)
{
    if (target == TARGET_ROOM) /* nail objects on the floor */
    {
        ROOM_INDEX_DATA *room = (ROOM_INDEX_DATA *) vo;
        OBJ_DATA *obj, *obj_next;

        for (obj = room->contents; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            acid_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }

    if (target == TARGET_CHAR)  /* do the effect on a victim */
    {
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        OBJ_DATA *obj, *obj_next;

        if (victim && victim->in_war && victim->war_status == PS_ALIVE)
            return;

        /* let's toast some gear */
        for (obj = victim->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            acid_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }

    if (target == TARGET_OBJ) /* toast an object */
    {
        OBJ_DATA *obj = (OBJ_DATA *) vo;
        OBJ_DATA *t_obj,*n_obj;
        int chance;
        char *msg;

        if (IS_OBJ_STAT(obj, ITEM_BURN_PROOF)
        || IS_OBJ_STAT(obj, ITEM_NOPURGE)
        || IS_OBJ_STAT(obj, ITEM_HIDURABILITY)
        || number_range(0,4) == 0)
            return;
        if (IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE))
            return;

        chance = level / 4 + dam / 10;

        if (chance > 25)
            chance = (chance - 25) / 2 + 25;
        if (chance > 50)
            chance = (chance - 50) / 2 + 50;

        if (IS_OBJ_STAT(obj,ITEM_BLESS))
            chance -= 5;

        chance -= obj->level * 2;

        switch (obj->pIndexData->item_type)
        {
        default:
            return;
        case ITEM_CORPSE_PC: if (obj->value[2]) return;
        case ITEM_CONTAINER:
        case ITEM_CORPSE_NPC:
            msg = "$p   .";
            break;
        case ITEM_ARMOR:
            msg = "$p   .";
            break;
        case ITEM_CLOTHING:
            msg = "$p   .";
            break;
        case ITEM_STAFF:
        case ITEM_WAND:
            chance -= 10;
            msg = "$p   .";
            break;
        case ITEM_SCROLL:
            chance += 10;
            msg = "$p   .";
            break; 
        }
        chance = URANGE(5,chance,95);

        if (number_percent() > chance)
            return;

        if (obj->carried_by != NULL)
            act(msg,obj->carried_by,obj,NULL,TO_ALL);
        else if (obj->in_room != NULL && obj->in_room->people != NULL)
            act(msg,obj->in_room->people,obj,NULL,TO_ALL);

        if (obj->pIndexData->item_type == ITEM_ARMOR)  /* etch it */
        {
            AFFECT_DATA *paf;
            bool af_found = FALSE;
            int i;

            affect_enchant(obj);

            for ( paf = obj->affected; paf != NULL; paf = paf->next)
            {
                if ( paf->location == APPLY_AC)
                {
                    af_found = TRUE;
                    paf->type = -1;
                    paf->modifier += level + 1;
                    paf->level = UMAX(paf->level,level);
                    break;
                }
            }
 
            if (!af_found)
            /* needs a new affect */
            {
                paf = aff_new();
 
                paf->type       = -1;
                paf->level      = level;
                paf->duration   = -1;
                paf->location   = APPLY_AC;
                paf->modifier   = level + 1;
                paf->bitvector  = 0;
                paf->next       = obj->affected;
                obj->affected   = paf;
            }
 
            if (obj->carried_by != NULL && obj->wear_loc != WEAR_NONE)
                for (i = 0; i < 4; i++)
                    obj->carried_by->armor[i] +=level + 1;;
        return;
        }

        /* get rid of the object */
        if (obj->contains)  /* dump contents */
        {
            for (t_obj = obj->contains; t_obj != NULL; t_obj = n_obj)
            {
                n_obj = t_obj->next_content;
                obj_from_obj(t_obj);
                if (obj->in_room != NULL)
                    obj_to_room(t_obj,obj->in_room);
                else if (obj->carried_by != NULL)
                    obj_to_room(t_obj,obj->carried_by->in_room);
                else
                {
                    extract_obj(t_obj);
                    continue;
                }
                acid_effect(t_obj,level/2,dam/2,TARGET_OBJ);
            }
        }
        extract_obj(obj);
        return;
    }
}


void cold_effect(void *vo, int level, int dam, int target)
{
    if (target == TARGET_ROOM) /* nail objects on the floor */
    {
        ROOM_INDEX_DATA *room = (ROOM_INDEX_DATA *) vo;
        OBJ_DATA *obj, *obj_next;
 
        for (obj = room->contents; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            cold_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }

    if (target == TARGET_CHAR) /* whack a character */
    {
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        OBJ_DATA *obj, *obj_next;
    
        /* chill touch effect */
        if (!saves_spell(level/4 + dam / 20, victim, DAM_COLD)
        && !is_affected(victim, gsn_chill_touch))
        {
            AFFECT_DATA af;

            act("$n   .", victim, NULL, NULL, TO_ROOM);
            act("     .", victim, NULL, NULL, TO_CHAR);
            af.where     = TO_AFFECTS;
            af.type      = sn_lookup("chill touch");
            af.level     = level;
            af.duration  = 6;
            af.location  = APPLY_STR;
            af.modifier  = - number_range(10, 20);;
            af.bitvector = 0;
            affect_join( victim, &af );
        }

        /* hunger! (warmth sucked out */
        if (!IS_NPC(victim))
            gain_condition(victim,COND_HUNGER,dam/20);

        if (victim && victim->in_war && victim->war_status == PS_ALIVE)
            return;

        /* let's toast some gear */
        for (obj = victim->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            cold_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }

    if (target == TARGET_OBJ) /* toast an object */
    {
        OBJ_DATA *obj = (OBJ_DATA *) vo;
        int chance;
        char *msg;

        if (IS_OBJ_STAT(obj,ITEM_BURN_PROOF)
        || IS_OBJ_STAT(obj,ITEM_NOPURGE)
        || IS_OBJ_STAT(obj, ITEM_HIDURABILITY)
        || number_range(0,4) == 0)
            return;
        if (IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE))
            return;

        chance = level / 4 + dam / 10;

        if (chance > 25)
            chance = (chance - 25) / 2 + 25;
        if (chance > 50)
            chance = (chance - 50) / 2 + 50;

        if (IS_OBJ_STAT(obj,ITEM_BLESS))
            chance -= 5;

        chance -= obj->level * 2;

        switch(obj->pIndexData->item_type)
        {
        default:
            return;
        case ITEM_POTION:
            msg = "$p    !";
            chance += 25;
            break;
        case ITEM_DRINK_CON:
            msg = "$p    !";
            chance += 5;
            break;
        }

        chance = URANGE(5,chance,95);

        if (number_percent() > chance)
            return;

        if (obj->carried_by != NULL)
            act(msg,obj->carried_by,obj,NULL,TO_ALL);
        else if (obj->in_room != NULL && obj->in_room->people != NULL)
            act(msg,obj->in_room->people,obj,NULL,TO_ALL);

        extract_obj(obj);
        return;
    }
}

void fire_effect(void *vo, int level, int dam, int target)
{
    
    if (target == TARGET_ROOM)  /* nail objects on the floor */
    {
        ROOM_INDEX_DATA *room = (ROOM_INDEX_DATA *) vo;
        OBJ_DATA *obj, *obj_next;
        for (obj = room->contents; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            fire_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }
 
    if (target == TARGET_CHAR)   /* do the effect on a victim */
    {
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        OBJ_DATA *obj, *obj_next;

        /* chance of blindness */
        if (!IS_AFFECTED(victim,AFF_BLIND) && !IS_UNDEAD(victim)
        &&  !saves_spell(level / 4 + dam / 20, victim,DAM_FIRE))
        {
            AFFECT_DATA af;
            act("$n is blinded by smoke!",victim,NULL,NULL,TO_ROOM);
            act("Your eyes tear up from smoke...you can't see a thing!",
                victim,NULL,NULL,TO_CHAR);
     
            af.where        = TO_AFFECTS;
            af.type         = sn_lookup("fire breath");
            af.level        = level + level / 10;
            af.duration     = number_range(0, level/10);
            af.location     = APPLY_HITROLL;
            af.modifier     = 0 - number_fuzzy(level/5);
            af.bitvector    = AFF_BLIND;
 
            affect_to_char(victim,&af);
        }

        /* getting thirsty */
        if (!IS_NPC(victim))
            gain_condition(victim, COND_THIRST, dam/20);

        if (victim && victim->in_war && victim->war_status == PS_ALIVE)
            return;
        
        /* let's toast some gear! */
        for (obj = victim->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            fire_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }

    if (target == TARGET_OBJ)  /* toast an object */
    {
        OBJ_DATA *obj = (OBJ_DATA *) vo;
        OBJ_DATA *t_obj,*n_obj;
        int chance;
        char *msg;

        if (IS_OBJ_STAT(obj,ITEM_BURN_PROOF)
        ||  IS_OBJ_STAT(obj,ITEM_NOPURGE)
        || IS_OBJ_STAT(obj, ITEM_HIDURABILITY)
        ||  number_range(0,4) == 0)
            return;
        if (IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE))
            return;

        chance = level / 4 + dam / 10;
 
        if (chance > 25)
            chance = (chance - 25) / 2 + 25;
        if (chance > 50)
            chance = (chance - 50) / 2 + 50;

        if (IS_OBJ_STAT(obj,ITEM_BLESS))
            chance -= 5;
        chance -= obj->level * 2;

        if  (check_material(obj, "ice"))  
        {
            chance += 30;
            msg = "$p   !";
        } else
        switch ( obj->pIndexData->item_type )
        {
        default:             
            return;
        case ITEM_CONTAINER:
            msg = "$p   !";
            break;
        case ITEM_POTION:
            chance += 25;
            msg = "$p   !";
            break;
        case ITEM_SCROLL:
            chance += 50;
            msg = "$p   !";
            break;
        case ITEM_STAFF:
            chance += 10;
            msg = "$p   !";
            break;
        case ITEM_WAND:
            msg = "$p   !";
            break;
        case ITEM_FOOD:
            msg = "$p   !";
            break;
        case ITEM_PILL:
            msg = "$p   !";
            break;
        }

        chance = URANGE(5,chance,95);

        if (number_percent() > chance)
            return;
 
        if (obj->carried_by != NULL)
            act( msg, obj->carried_by, obj, NULL, TO_ALL );
        else if (obj->in_room != NULL && obj->in_room->people != NULL)
            act(msg,obj->in_room->people,obj,NULL,TO_ALL);

        if (obj->contains)
        {
            /* dump the contents */
            for (t_obj = obj->contains; t_obj != NULL; t_obj = n_obj)
            {
                n_obj = t_obj->next_content;
                obj_from_obj(t_obj);
                if (obj->in_room != NULL)
                    obj_to_room(t_obj,obj->in_room);
                else if (obj->carried_by != NULL)
                    obj_to_room(t_obj,obj->carried_by->in_room);
                else
                {
                    extract_obj(t_obj);
                    continue;
                }
            fire_effect(t_obj, level/2, dam/2, TARGET_OBJ);
            }
        }
 
        extract_obj( obj );
    return;
    }
}

void poison_effect(void *vo,int level, int dam, int target)
{
    if (target == TARGET_ROOM)  /* nail objects on the floor */
    {
        ROOM_INDEX_DATA *room = (ROOM_INDEX_DATA *) vo;
        OBJ_DATA *obj, *obj_next;
 
        for (obj = room->contents; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            poison_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }
 
    if (target == TARGET_CHAR)   /* do the effect on a victim */
    {
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        OBJ_DATA *obj, *obj_next;

        /* chance of poisoning */
        if (!saves_spell(level / 4 + dam / 20,victim,DAM_POISON))
        {
            AFFECT_DATA af;

            act("You feel poison coursing through your veins.",
                victim, NULL, NULL, TO_CHAR);
            act("$n looks very ill.",
                victim, NULL, NULL, TO_ROOM);

            af.where     = TO_AFFECTS;
            af.type      = gsn_poison;
            af.level     = level;
            af.duration  = level / 2;
            af.location  = APPLY_STR;
            af.modifier  = -(level / 10 + 1);
            af.bitvector = AFF_POISON;
            affect_join( victim, &af );
        }

        /* equipment */
        for (obj = victim->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            poison_effect(obj, level, dam, TARGET_OBJ);
        }
        return;
    }

    if (target == TARGET_OBJ)  /* do some poisoning */
    {
        OBJ_DATA *obj = (OBJ_DATA *) vo;
        int chance;

        if (IS_OBJ_STAT(obj,ITEM_BURN_PROOF)
        ||  IS_OBJ_STAT(obj,ITEM_BLESS)
        ||  number_range(0,4) == 0)
            return;

        chance = level / 4 + dam / 10;
        if (chance > 25)
            chance = (chance - 25) / 2 + 25;
        if (chance > 50)
            chance = (chance - 50) / 2 + 50;

        chance -= obj->level * 2;

        switch (obj->pIndexData->item_type)
        {
        default:
            return;
        case ITEM_FOOD:
            break;
        case ITEM_DRINK_CON:
            if (obj->value[0] == obj->value[1])
                return;
        break;
        }

        chance = URANGE(5,chance,95);

        if (number_percent() > chance)
            return;

        obj->value[3] = 1;
        return;
    }
}

void shock_effect(void *vo,int level, int dam, int target)
{
    if (target == TARGET_ROOM)
    {
        ROOM_INDEX_DATA *room = (ROOM_INDEX_DATA *) vo;
        OBJ_DATA *obj, *obj_next;

        for (obj = room->contents; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            shock_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }

    if (target == TARGET_CHAR)
    {
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        OBJ_DATA *obj, *obj_next;

        /* daze and confused? */
        if (!saves_spell(level / 4 + dam / 20, victim, DAM_LIGHTNING))
        {
            act("     .",
                victim, NULL, NULL, TO_CHAR) ;
            DAZE_STATE (victim, UMAX(12, level / 4 + number_fuzzy (1))) ;
        }

        if (victim && victim->in_war && victim->war_status == PS_ALIVE)
            return;
        
        /* toast some gear */
        for (obj = victim->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            shock_effect(obj, level, dam, TARGET_OBJ);
        }
        return;
    }

    if (target == TARGET_OBJ)
    {
        OBJ_DATA *obj = (OBJ_DATA *) vo;
        int chance;
        char *msg;

        if (IS_OBJ_STAT(obj,ITEM_BURN_PROOF)
        || IS_OBJ_STAT(obj,ITEM_NOPURGE)
        || IS_OBJ_STAT(obj, ITEM_HIDURABILITY)
        || number_range(0,4) == 0)
            return;

        if (IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE))
            return;

        chance = level / 4 + dam / 10;

        if (chance > 25)
            chance = (chance - 25) / 2 + 25;
        if (chance > 50)
            chance = (chance - 50) /2 + 50;

        if (IS_OBJ_STAT(obj,ITEM_BLESS))
            chance -= 5;

        chance -= obj->level * 2;

        switch(obj->pIndexData->item_type)
        {
        default:
            return;
        case ITEM_WAND:
        case ITEM_STAFF:
            chance += 10;
            msg = "$p   !";
            break;
        case ITEM_JEWELRY:
            chance -= 10;
            msg = "$p      .";
        }
    
        chance = URANGE(5,chance,95);

        if (number_percent() > chance)
            return;

        if (obj->carried_by != NULL)
            act(msg, obj->carried_by, obj, NULL, TO_ALL);
        else if (obj->in_room != NULL && obj->in_room->people != NULL)
            act(msg,obj->in_room->people,obj,NULL,TO_ALL);

        extract_obj(obj);
        return;
    }
}

void sand_effect(void *vo, int level, int dam, int target)
{
    if (target == TARGET_ROOM) /* nail objects on the floor */
    {
        ROOM_INDEX_DATA *room = (ROOM_INDEX_DATA *) vo;
        OBJ_DATA *obj, *obj_next;

        for (obj = room->contents; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            sand_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }

    if (target == TARGET_CHAR)  /* do the effect on a victim */
    {
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        OBJ_DATA *obj, *obj_next;
    
        if (!IS_AFFECTED(victim,AFF_BLIND) && !IS_UNDEAD(victim)
        && !saves_spell(level / 4 + dam / 20, victim, DAM_COLD))
        {
            AFFECT_DATA af;
            act("$n   ,   !", victim, NULL, NULL, TO_ROOM);
            act("   ...    !",
                victim, NULL, NULL, TO_CHAR);
     
            af.where        = TO_AFFECTS;
            af.type         = sn_lookup("sand storm");
            af.level        = level;
            af.duration     = number_range(0,level/10);
            af.location     = APPLY_HITROLL;
            af.modifier     = 0 - number_fuzzy(level/5);
            af.bitvector    = AFF_BLIND;
 
            affect_to_char(victim,&af);
        }

        if (victim && victim->in_war && victim->war_status == PS_ALIVE)
            return;
        
        /* let's toast some gear */
        for (obj = victim->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            sand_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }

    if (target == TARGET_OBJ) /* toast an object */
    {
        OBJ_DATA *obj = (OBJ_DATA *) vo;
        OBJ_DATA *t_obj,*n_obj;
        int chance;
        char *msg;

        if (IS_OBJ_STAT(obj,ITEM_BURN_PROOF)
        || IS_OBJ_STAT(obj,ITEM_NOPURGE)
        || IS_OBJ_STAT(obj, ITEM_HIDURABILITY)
        || number_range(0,4) == 0)
            return;

        if (IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE))
            return;

        chance = level / 4 + dam / 10;

        if (chance > 25)
            chance = (chance - 25) / 2 + 25;
        if (chance > 50)
            chance = (chance - 50) / 2 + 50;

        if (IS_OBJ_STAT(obj,ITEM_BLESS))
            chance -= 5;

        chance -= obj->level * 2;

        switch (obj->pIndexData->item_type)
        {
        default:
            return;
        case ITEM_CORPSE_PC: if(obj->value[2]) return;
        case ITEM_CONTAINER:
        case ITEM_CORPSE_NPC:
            chance += 50;
            msg = "$p    .";
            break;
        case ITEM_ARMOR:
            chance -=10;
            msg = "$p  .";
            break;
        case ITEM_CLOTHING:
            msg = "$p  .";
            break;
        case ITEM_WAND:
            chance = 50;
            msg = "$p    .";
            break;
        case ITEM_SCROLL:
            chance += 20;
            msg = "$p  .";
            break; 
        case ITEM_POTION:
            chance +=10;
            msg = "$p    .";
            break;
        }

        chance = URANGE(5,chance,95);

        if (number_percent() > chance)
            return;

        if (obj->carried_by != NULL)
            act(msg,obj->carried_by,obj,NULL,TO_ALL);
        else if (obj->in_room != NULL && obj->in_room->people != NULL)
            act(msg,obj->in_room->people,obj,NULL,TO_ALL);

        if (obj->pIndexData->item_type == ITEM_ARMOR)  /* etch it */
        {
            AFFECT_DATA *paf;
            bool af_found = FALSE;
            int i;

            affect_enchant(obj);

            for ( paf = obj->affected; paf != NULL; paf = paf->next)
            {
                if ( paf->location == APPLY_AC)
                {
                    af_found = TRUE;
                    paf->type = -1;
                    paf->modifier += level / 10 + 1;
                    paf->level = UMAX(paf->level,level);
                    break;
                }
            }
 
            if (!af_found)
            /* needs a new affect */
            {
                paf = aff_new();
 
                paf->type       = -1;
                paf->level      = level;
                paf->duration   = level;
                paf->location   = APPLY_AC;
                paf->modifier   = level / 10 + 1;
                paf->bitvector  = 0;
                paf->next       = obj->affected;
                obj->affected   = paf;
            }
 
            if (obj->carried_by != NULL && obj->wear_loc != WEAR_NONE)
                for (i = 0; i < 4; i++)
                    obj->carried_by->armor[i] +=level /10 + 1;
        return;
        }   

        /* get rid of the object */
        if (obj->contains)  /* dump contents */
        {
            for (t_obj = obj->contains; t_obj != NULL; t_obj = n_obj)
            {
            n_obj = t_obj->next_content;
            obj_from_obj(t_obj);
            if (obj->in_room != NULL)
                obj_to_room(t_obj,obj->in_room);
            else if (obj->carried_by != NULL)
                obj_to_room(t_obj,obj->carried_by->in_room);
            else
            {
                extract_obj(t_obj);
                continue;
            }
            sand_effect(t_obj,level/2,dam/2,TARGET_OBJ);
            }
        }
    extract_obj(obj);
    return;
    }
}

void scream_effect(void *vo, int level, int dam, int target)
{
    if (target == TARGET_ROOM)  /* nail objects on the floor */
    {
        ROOM_INDEX_DATA *room = (ROOM_INDEX_DATA *) vo;
        OBJ_DATA *obj, *obj_next;
        for (obj = room->contents; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            scream_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }
 
    if (target == TARGET_CHAR)   /* do the effect on a victim */
    {
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        OBJ_DATA *obj, *obj_next;

        if (!saves_spell(level / 4 + dam / 20, victim, DAM_SOUND))
        {
            AFFECT_DATA af;
            act("$n   !", victim, NULL, NULL, TO_ROOM);
            act("   !", victim, NULL, NULL, TO_CHAR);
     
            af.where        = TO_AFFECTS;
            af.type         = gsn_scream;
            af.level        = level;
            af.duration     = 0;
            af.location     = APPLY_NONE;
            af.modifier     = 0;
            af.bitvector    = AFF_CALM;
 
            affect_to_char(victim,&af);
        }

        /* daze and confused? */
        if (!saves_spell(level + dam / 20, victim, DAM_SOUND))
        {
            act("    !!!", victim, NULL, NULL, TO_CHAR);
            DAZE_STATE(victim, UMAX(12, level / 4 + dam / 20));
        }
     
        /* getting thirsty */
        if (!IS_NPC(victim))
            gain_condition(victim, COND_THIRST, dam / 20);
        
        if (victim && victim->in_war && victim->war_status == PS_ALIVE)
            return;
        
        /* let's toast some gear! */
        for (obj = victim->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            scream_effect(obj,level,dam,TARGET_OBJ);
        }
        return;
    }

    if (target == TARGET_OBJ)  /* toast an object */
    {
        OBJ_DATA *obj = (OBJ_DATA *) vo;
        OBJ_DATA *t_obj,*n_obj;
        int chance;
        char *msg;

        if (IS_OBJ_STAT(obj, ITEM_BURN_PROOF)
        || IS_OBJ_STAT(obj, ITEM_NOPURGE)
        || IS_OBJ_STAT(obj, ITEM_INVENTORY)
        || IS_OBJ_STAT(obj, ITEM_HIDURABILITY)
        ||  number_range(0,4) == 0)
            return;

        if (IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE))
            return;
 
        chance = level / 4 + dam / 10;
 
        if (chance > 25)
            chance = (chance - 25) / 2 + 25;
        if (chance > 50)
            chance = (chance - 50) / 2 + 50;

        if (IS_OBJ_STAT(obj,ITEM_BLESS))
            chance -= 5;
        chance -= obj->level * 2;

        if (check_material(obj, "ice"))  
        {
            chance += 30;
            msg = "$p     !";
        }
        else if (check_material(obj, "glass"))
        {
            chance += 30;
            msg = "$p    ";
        } else
        switch ( obj->pIndexData->item_type )
        {
        default:             
            return;
        case ITEM_POTION:
            chance += 25;
            msg = "  $p     !";
            break;
        case ITEM_SCROLL:
            chance += 50;
            msg = "$p !";
            break;
        case ITEM_DRINK_CON:
            msg = "$p     !";
            chance += 5;
            break;
        case ITEM_PILL:
            msg = "$p !";
            break;
        }

        chance = URANGE(5,chance,95);

        if (number_percent() > chance)
            return;
 
        if (obj->carried_by != NULL)
            act( msg, obj->carried_by, obj, NULL, TO_ALL );
        else if (obj->in_room != NULL && obj->in_room->people != NULL)
            act(msg,obj->in_room->people,obj,NULL,TO_ALL);

        if (obj->contains)
        {
            /* dump the contents */
 
            for (t_obj = obj->contains; t_obj != NULL; t_obj = n_obj)
            {
                n_obj = t_obj->next_content;
                obj_from_obj(t_obj);
                if (obj->in_room != NULL)
                    obj_to_room(t_obj,obj->in_room);
                else if (obj->carried_by != NULL)
                    obj_to_room(t_obj,obj->carried_by->in_room);
                else
                {
                    extract_obj(t_obj);
                    continue;
                }
                scream_effect(t_obj,level/2,dam/2,TARGET_OBJ);
            }
        }
        extract_obj( obj );
        return;
    }
}



