/* $Id: ext_flags.c,v 1.666 2004/09/20 10:49:48 shrike Exp $                            */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "merc.h"
#include "ext_flags.h"
#include "log.h"

void ext_empty_flag(ext_flag_t flag)
{
  int i;
  
  for (i = 0; i < B_MASK+1; i++)
  {
    // .    ,       :)

    flag[i] = 0;
  }
}

bool ext_is_empty_flag(ext_flag_t flag)
{
  int i;
  bool result = TRUE;
//  result = true;
  
  for (i = 0; i < B_MASK+1; i++)
  {
    result &= (flag[i] == 0);
  }
  return result;
}

char* ext_format_flags(ext_flag_t flag)
{
  int i;
  int j;

  static char buf[NL*(B_MASK+1)*FLAG_STR_LEN]; 
  char letter[16];
  
  buf[0] = '\0';

  //     
  for (i = 0; i < B_MASK; i++)
    for (j = 0; j < NL; j++)
    {
      if (EXT_IS_SET(flag, ((1 << (j + BASE)) + i)))
      {
        snprintf(letter, sizeof(letter), "%c%d", 'A'+j, i);
        strnzcat(buf, sizeof(buf), letter);
      }
    }
  return buf;
}
	
void ext_read_flags(const char* str, ext_flag_t flag)
{
//  ext_flag_t flag;
  int i;
  int flag_letter = 0;
  int index;
  bool reading_flag = FALSE;
  char str_index[FLAG_STR_LEN];
  int c = 0;  // counter for str_index fill

  EXT_CLEAN_FLAGS(flag);
  if (str[0] == '\0') return;
  
  for (i = 0; str[i] != '\0'; i++)
  {
     if (str[i] >= 'A' && str[i] <= 'Z')
     {
        if (reading_flag)
        { 
           index = atoi(str_index);
           if (index > B_MASK)
             log_printf("ext_read_flags: index larger than allowed (%d/%d)", index, B_MASK);
           else
             EXT_SET_BIT(flag, ((1 << (flag_letter + BASE)) + index));
                                              
           reading_flag = FALSE;
        }
      
        reading_flag = TRUE;
        flag_letter = str[i] - 'A';
        c = 0;
        str_index[c] = '\0';    
     } 
     else
     {
       str_index[c] = str[i];
       str_index[c+1] = '\0';
       if (c < FLAG_STR_LEN-1) ++c; //    !
       else
       { 
         log_printf("ext_read_flags: overflow reading index (%s)", str_index);
          c = 0;
          str_index[c] = '\0';    
       }
 

       if (!is_number(str_index))
       {
         log_printf("ext_read_flags: index is not a number! (%s)", str_index);
         reading_flag = FALSE;
       }
     }
  }
  if (reading_flag) //     :)
  { 
    index = atoi(str_index);
    if (index > B_MASK)
      log_printf("ext_read_flags: index larger than allowed (%d/%d)", index, B_MASK);
    else
      EXT_SET_BIT(flag, ((1 << (flag_letter + BASE)) + index));
  }
  return;
} 
