/* $Id: ext_flags.h,v 1.666 2004/09/20 10:49:48 shrike Exp $                              */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


//   -- (c) Aseroth. 
// base      int,   
//  .  -  BASE,
//    .     '  
//  ( 26,  32,       6)


#ifndef EXT_FLAGS_H
#define EXT_FLAGS_H

#define BASE 3
// ,   BASE  : (0000 0111   )
// !  ,   !
#define B_MASK ((1 << BASE) - 1)

// 3 -        'A63'
//  -  BASE  7   ,  
// .
#define FLAG_STR_LEN 3

typedef int ext_single_bit;
typedef ext_single_bit ext_flag_t[B_MASK+1];
void ext_empty_flag(ext_flag_t flag);
bool ext_is_empty_flag(ext_flag_t flag);
char* ext_format_flags(ext_flag_t flag);
void ext_read_flags(const char* str, ext_flag_t flag);


// ӣ       ,   
//     ,   BASE
//   ,       BASE 
//#define EXT_IS_SET(flag, bit) (1)
#define EXT_IS_SET(flag, bit)    (flag[(bit & B_MASK)] & (bit& ~(B_MASK)))
#define EXT_SET_BIT(var, bit)    (var[(bit & B_MASK)] |= (bit& ~(B_MASK)))
#define EXT_TOGGLE_BIT(var, bit) (var[(bit & B_MASK)] ^= (bit& ~(B_MASK)))
#define EXT_REMOVE_BIT(var, bit) (var[(bit & B_MASK)] &= ~(bit& ~(B_MASK)))

// :   -̣      -- !
//    .h   ,       -- 

#define EXT_CLEAN_FLAGS(flag)   (ext_empty_flag(flag))
#define EXT_IS_EMPTY_FLAGS(flag)    (ext_is_empty_flag(flag))

/* flags by letters. SHIT. initially copied from const.h */
//    208 . expandable :)

//  .     
//  
#define NL 26

#define EXT_A0  ((1 << (BASE + 0)) + 00)
#define EXT_B0  ((1 << (BASE + 1)) + 00)
#define EXT_C0  ((1 << (BASE + 2)) + 00)
#define EXT_D0  ((1 << (BASE + 3)) + 00)
#define EXT_E0  ((1 << (BASE + 4)) + 00)
#define EXT_F0  ((1 << (BASE + 5)) + 00)
#define EXT_G0  ((1 << (BASE + 6)) + 00)
#define EXT_H0  ((1 << (BASE + 7)) + 00)
#define EXT_I0  ((1 << (BASE + 8)) + 00)
#define EXT_J0  ((1 << (BASE + 9)) + 00)
#define EXT_K0  ((1 << (BASE + 10)) + 00)
#define EXT_L0  ((1 << (BASE + 11)) + 00)
#define EXT_M0  ((1 << (BASE + 12)) + 00)
#define EXT_N0  ((1 << (BASE + 13)) + 00)
#define EXT_O0  ((1 << (BASE + 14)) + 00)
#define EXT_P0  ((1 << (BASE + 15)) + 00)
#define EXT_Q0  ((1 << (BASE + 16)) + 00)
#define EXT_R0  ((1 << (BASE + 17)) + 00)
#define EXT_S0  ((1 << (BASE + 18)) + 00)
#define EXT_T0  ((1 << (BASE + 19)) + 00)
#define EXT_U0  ((1 << (BASE + 20)) + 00)
#define EXT_V0  ((1 << (BASE + 21)) + 00)
#define EXT_W0  ((1 << (BASE + 22)) + 00)
#define EXT_X0  ((1 << (BASE + 23)) + 00)
#define EXT_Y0  ((1 << (BASE + 24)) + 00)
#define EXT_Z0  ((1 << (BASE + 25)) + 00)

#define EXT_A1  ((1 << (BASE + 0)) + 01)
#define EXT_B1  ((1 << (BASE + 1)) + 01)
#define EXT_C1  ((1 << (BASE + 2)) + 01)
#define EXT_D1  ((1 << (BASE + 3)) + 01)
#define EXT_E1  ((1 << (BASE + 4)) + 01)
#define EXT_F1  ((1 << (BASE + 5)) + 01)
#define EXT_G1  ((1 << (BASE + 6)) + 01)
#define EXT_H1  ((1 << (BASE + 7)) + 01)
#define EXT_I1  ((1 << (BASE + 8)) + 01)
#define EXT_J1  ((1 << (BASE + 9)) + 01)
#define EXT_K1  ((1 << (BASE + 10)) + 01)
#define EXT_L1  ((1 << (BASE + 11)) + 01)
#define EXT_M1  ((1 << (BASE + 12)) + 01)
#define EXT_N1  ((1 << (BASE + 13)) + 01)
#define EXT_O1  ((1 << (BASE + 14)) + 01)
#define EXT_P1  ((1 << (BASE + 15)) + 01)
#define EXT_Q1  ((1 << (BASE + 16)) + 01)
#define EXT_R1  ((1 << (BASE + 17)) + 01)
#define EXT_S1  ((1 << (BASE + 18)) + 01)
#define EXT_T1  ((1 << (BASE + 19)) + 01)
#define EXT_U1  ((1 << (BASE + 20)) + 01)
#define EXT_V1  ((1 << (BASE + 21)) + 01)
#define EXT_W1  ((1 << (BASE + 22)) + 01)
#define EXT_X1  ((1 << (BASE + 23)) + 01)
#define EXT_Y1  ((1 << (BASE + 24)) + 01)
#define EXT_Z1  ((1 << (BASE + 25)) + 01)

#define EXT_A2  ((1 << (BASE + 0)) + 02)
#define EXT_B2  ((1 << (BASE + 1)) + 02)
#define EXT_C2  ((1 << (BASE + 2)) + 02)
#define EXT_D2  ((1 << (BASE + 3)) + 02)
#define EXT_E2  ((1 << (BASE + 4)) + 02)
#define EXT_F2  ((1 << (BASE + 5)) + 02)
#define EXT_G2  ((1 << (BASE + 6)) + 02)
#define EXT_H2  ((1 << (BASE + 7)) + 02)
#define EXT_I2  ((1 << (BASE + 8)) + 02)
#define EXT_J2  ((1 << (BASE + 9)) + 02)
#define EXT_K2  ((1 << (BASE + 10)) + 02)
#define EXT_L2  ((1 << (BASE + 11)) + 02)
#define EXT_M2  ((1 << (BASE + 12)) + 02)
#define EXT_N2  ((1 << (BASE + 13)) + 02)
#define EXT_O2  ((1 << (BASE + 14)) + 02)
#define EXT_P2  ((1 << (BASE + 15)) + 02)
#define EXT_Q2  ((1 << (BASE + 16)) + 02)
#define EXT_R2  ((1 << (BASE + 17)) + 02)
#define EXT_S2  ((1 << (BASE + 18)) + 02)
#define EXT_T2  ((1 << (BASE + 19)) + 02)
#define EXT_U2  ((1 << (BASE + 20)) + 02)
#define EXT_V2  ((1 << (BASE + 21)) + 02)
#define EXT_W2  ((1 << (BASE + 22)) + 02)
#define EXT_X2  ((1 << (BASE + 23)) + 02)
#define EXT_Y2  ((1 << (BASE + 24)) + 02)
#define EXT_Z2  ((1 << (BASE + 25)) + 02)

#define EXT_A3  ((1 << (BASE + 0)) + 03)
#define EXT_B3  ((1 << (BASE + 1)) + 03)
#define EXT_C3  ((1 << (BASE + 2)) + 03)
#define EXT_D3  ((1 << (BASE + 3)) + 03)
#define EXT_E3  ((1 << (BASE + 4)) + 03)
#define EXT_F3  ((1 << (BASE + 5)) + 03)
#define EXT_G3  ((1 << (BASE + 6)) + 03)
#define EXT_H3  ((1 << (BASE + 7)) + 03)
#define EXT_I3  ((1 << (BASE + 8)) + 03)
#define EXT_J3  ((1 << (BASE + 9)) + 03)
#define EXT_K3  ((1 << (BASE + 10)) + 03)
#define EXT_L3  ((1 << (BASE + 11)) + 03)
#define EXT_M3  ((1 << (BASE + 12)) + 03)
#define EXT_N3  ((1 << (BASE + 13)) + 03)
#define EXT_O3  ((1 << (BASE + 14)) + 03)
#define EXT_P3  ((1 << (BASE + 15)) + 03)
#define EXT_Q3  ((1 << (BASE + 16)) + 03)
#define EXT_R3  ((1 << (BASE + 17)) + 03)
#define EXT_S3  ((1 << (BASE + 18)) + 03)
#define EXT_T3  ((1 << (BASE + 19)) + 03)
#define EXT_U3  ((1 << (BASE + 20)) + 03)
#define EXT_V3  ((1 << (BASE + 21)) + 03)
#define EXT_W3  ((1 << (BASE + 22)) + 03)
#define EXT_X3  ((1 << (BASE + 23)) + 03)
#define EXT_Y3  ((1 << (BASE + 24)) + 03)
#define EXT_Z3  ((1 << (BASE + 25)) + 03)

#define EXT_A4  ((1 << (BASE + 0)) + 04)
#define EXT_B4  ((1 << (BASE + 1)) + 04)
#define EXT_C4  ((1 << (BASE + 2)) + 04)
#define EXT_D4  ((1 << (BASE + 3)) + 04)
#define EXT_E4  ((1 << (BASE + 4)) + 04)
#define EXT_F4  ((1 << (BASE + 5)) + 04)
#define EXT_G4  ((1 << (BASE + 6)) + 04)
#define EXT_H4  ((1 << (BASE + 7)) + 04)
#define EXT_I4  ((1 << (BASE + 8)) + 04)
#define EXT_J4  ((1 << (BASE + 9)) + 04)
#define EXT_K4  ((1 << (BASE + 10)) + 04)
#define EXT_L4  ((1 << (BASE + 11)) + 04)
#define EXT_M4  ((1 << (BASE + 12)) + 04)
#define EXT_N4  ((1 << (BASE + 13)) + 04)
#define EXT_O4  ((1 << (BASE + 14)) + 04)
#define EXT_P4  ((1 << (BASE + 15)) + 04)
#define EXT_Q4  ((1 << (BASE + 16)) + 04)
#define EXT_R4  ((1 << (BASE + 17)) + 04)
#define EXT_S4  ((1 << (BASE + 18)) + 04)
#define EXT_T4  ((1 << (BASE + 19)) + 04)
#define EXT_U4  ((1 << (BASE + 20)) + 04)
#define EXT_V4  ((1 << (BASE + 21)) + 04)
#define EXT_W4  ((1 << (BASE + 22)) + 04)
#define EXT_X4  ((1 << (BASE + 24)) + 04)
#define EXT_Y4  ((1 << (BASE + 23)) + 04)
#define EXT_Z4  ((1 << (BASE + 25)) + 04)

#define EXT_A5  ((1 << (BASE + 0)) + 05)
#define EXT_B5  ((1 << (BASE + 1)) + 05)
#define EXT_C5  ((1 << (BASE + 2)) + 05)
#define EXT_D5  ((1 << (BASE + 3)) + 05)
#define EXT_E5  ((1 << (BASE + 4)) + 05)
#define EXT_F5  ((1 << (BASE + 5)) + 05)
#define EXT_G5  ((1 << (BASE + 6)) + 05)
#define EXT_H5  ((1 << (BASE + 7)) + 05)
#define EXT_I5  ((1 << (BASE + 8)) + 05)
#define EXT_J5  ((1 << (BASE + 9)) + 05)
#define EXT_K5  ((1 << (BASE + 10)) + 05)
#define EXT_L5  ((1 << (BASE + 11)) + 05)
#define EXT_M5  ((1 << (BASE + 12)) + 05)
#define EXT_N5  ((1 << (BASE + 13)) + 05)
#define EXT_O5  ((1 << (BASE + 14)) + 05)
#define EXT_P5  ((1 << (BASE + 15)) + 05)
#define EXT_Q5  ((1 << (BASE + 16)) + 05)
#define EXT_R5  ((1 << (BASE + 17)) + 05)
#define EXT_S5  ((1 << (BASE + 18)) + 05)
#define EXT_T5  ((1 << (BASE + 19)) + 05)
#define EXT_U5  ((1 << (BASE + 20)) + 05)
#define EXT_V5  ((1 << (BASE + 21)) + 05)
#define EXT_W5  ((1 << (BASE + 22)) + 05)
#define EXT_X5  ((1 << (BASE + 23)) + 05)
#define EXT_Y5  ((1 << (BASE + 24)) + 05)
#define EXT_Z5  ((1 << (BASE + 25)) + 05)

#define EXT_A6  ((1 << (BASE + 0)) + 06)
#define EXT_B6  ((1 << (BASE + 1)) + 06)
#define EXT_C6  ((1 << (BASE + 2)) + 06)
#define EXT_D6  ((1 << (BASE + 3)) + 06)
#define EXT_E6  ((1 << (BASE + 4)) + 06)
#define EXT_F6  ((1 << (BASE + 5)) + 06)
#define EXT_G6  ((1 << (BASE + 6)) + 06)
#define EXT_H6  ((1 << (BASE + 7)) + 06)
#define EXT_I6  ((1 << (BASE + 8)) + 06)
#define EXT_J6  ((1 << (BASE + 9)) + 06)
#define EXT_K6  ((1 << (BASE + 10)) + 06)
#define EXT_L6  ((1 << (BASE + 11)) + 06)
#define EXT_M6  ((1 << (BASE + 12)) + 06)
#define EXT_N6  ((1 << (BASE + 13)) + 06)
#define EXT_O6  ((1 << (BASE + 14)) + 06)
#define EXT_P6  ((1 << (BASE + 15)) + 06)
#define EXT_Q6  ((1 << (BASE + 16)) + 06)
#define EXT_R6  ((1 << (BASE + 17)) + 06)
#define EXT_S6  ((1 << (BASE + 18)) + 06)
#define EXT_T6  ((1 << (BASE + 19)) + 06)
#define EXT_U6  ((1 << (BASE + 20)) + 06)
#define EXT_V6  ((1 << (BASE + 21)) + 06)
#define EXT_W6  ((1 << (BASE + 22)) + 06)
#define EXT_X6  ((1 << (BASE + 23)) + 06)
#define EXT_Y6  ((1 << (BASE + 24)) + 06)
#define EXT_Z6  ((1 << (BASE + 25)) + 06)

#define EXT_A7  ((1 << (BASE + 0)) + 07)
#define EXT_B7  ((1 << (BASE + 1)) + 07)
#define EXT_C7  ((1 << (BASE + 2)) + 07)
#define EXT_D7  ((1 << (BASE + 3)) + 07)
#define EXT_E7  ((1 << (BASE + 4)) + 07)
#define EXT_F7  ((1 << (BASE + 5)) + 07)
#define EXT_G7  ((1 << (BASE + 6)) + 07)
#define EXT_H7  ((1 << (BASE + 7)) + 07)
#define EXT_I7  ((1 << (BASE + 8)) + 07)
#define EXT_J7  ((1 << (BASE + 9)) + 07)
#define EXT_K7  ((1 << (BASE + 10)) + 07)
#define EXT_L7  ((1 << (BASE + 11)) + 07)
#define EXT_M7  ((1 << (BASE + 12)) + 07)
#define EXT_N7  ((1 << (BASE + 13)) + 07)
#define EXT_O7  ((1 << (BASE + 14)) + 07)
#define EXT_P7  ((1 << (BASE + 15)) + 07)
#define EXT_Q7  ((1 << (BASE + 16)) + 07)
#define EXT_R7  ((1 << (BASE + 17)) + 07)
#define EXT_S7  ((1 << (BASE + 18)) + 07)
#define EXT_T7  ((1 << (BASE + 19)) + 07)
#define EXT_U7  ((1 << (BASE + 20)) + 07)
#define EXT_V7  ((1 << (BASE + 21)) + 07)
#define EXT_W7  ((1 << (BASE + 22)) + 07)
#define EXT_X7  ((1 << (BASE + 23)) + 07)
#define EXT_Y7  ((1 << (BASE + 24)) + 07)
#define EXT_Z7  ((1 << (BASE + 25)) + 07) 


#endif
