/* $Id: fight.c,v 1.666 2004/09/20 10:49:48 shrike Exp $                            */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 /************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#define OLD_VERSION

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <war.h>

#if !defined (WIN32)
    #include <unistd.h>
#endif

#include "merc.h"
#include "db/lang.h"
#include "comm/comm_act.h"
#include "quest.h"
#include "gquest.h"
#include "fight.h"
#include "rating.h"
#include "update.h"
#include "mob_prog.h"
#include "obj_prog.h"
#include "cyborg.h"
#include "conquer.h"
#include "artefacts.h"
#include "wanderers.h"
#include "align.h"
#include "shamans.h"

DECLARE_DO_FUN(do_yell          );
DECLARE_DO_FUN(do_quit_count    );
DECLARE_DO_FUN(do_crush         );
DECLARE_DO_FUN(do_crush_boots   );
DECLARE_DO_FUN(do_emote         );
DECLARE_DO_FUN(do_dismount      );
DECLARE_DO_FUN(do_bash          );
DECLARE_DO_FUN(do_berserk       );
DECLARE_DO_FUN(do_disarm        );
DECLARE_DO_FUN(do_kick          );
DECLARE_DO_FUN(do_horn_prick    );
DECLARE_DO_FUN(do_dirt          );
DECLARE_DO_FUN(do_trip          );
DECLARE_DO_FUN(do_tail          );
DECLARE_DO_FUN(do_look_in       );
DECLARE_DO_FUN(do_get           );
DECLARE_DO_FUN(do_sacrifice     );
DECLARE_DO_FUN(do_visible       );
DECLARE_DO_FUN(do_recall        );
DECLARE_DO_FUN(do_flee          );
DECLARE_DO_FUN(do_fly           );


void agent_net_printf(CHAR_DATA *ch, CHAR_DATA *victim, int);
/*
 * Local functions.
 */
void    check_assist        (CHAR_DATA *ch, CHAR_DATA *victim);
bool    check_dodge         (CHAR_DATA *ch, CHAR_DATA *victim);
bool    check_hand_block    (CHAR_DATA *ch, CHAR_DATA *victim);
bool    check_parry         (CHAR_DATA *ch, CHAR_DATA *victim, int loc);
bool    check_block         (CHAR_DATA *ch, CHAR_DATA *victim, int loc);
bool    check_blink         (CHAR_DATA *ch, CHAR_DATA *victim);
bool    check_shield        (CHAR_DATA *ch, CHAR_DATA *victim);
bool    check_towershield   (CHAR_DATA *ch, CHAR_DATA *victim);
bool    check_stand_off     (CHAR_DATA *ch, CHAR_DATA *victim);
bool    check_stoneskin     (CHAR_DATA *ch, CHAR_DATA *victim);
bool    check_mirror_image  (CHAR_DATA *ch, CHAR_DATA *victim);
void    dam_message         (CHAR_DATA *ch, CHAR_DATA *victim, int dam, int dt, bool immune ,int dam_type);
void    death_cry           (CHAR_DATA *ch);
void    death_cry_org       (CHAR_DATA *ch, int part);
void    group_gain          (CHAR_DATA *ch, CHAR_DATA *victim);
int     xp_compute          (CHAR_DATA *gch, CHAR_DATA *victim, int total_levels, int members);
bool    is_safe             (CHAR_DATA *ch, CHAR_DATA *victim);
void    make_corpse         (CHAR_DATA *ch);
void    one_hit             (CHAR_DATA *ch, CHAR_DATA *victim, int dt, int loc);
void    mob_hit             (CHAR_DATA *ch, CHAR_DATA *victim, int dt);
void    set_fighting        (CHAR_DATA *ch, CHAR_DATA *victim);
void    disarm              (CHAR_DATA *ch, CHAR_DATA *victim, OBJ_DATA *weapon);
int     critical_strike     (CHAR_DATA *ch, CHAR_DATA *victim, int dam);
void    check_eq_damage     (CHAR_DATA *ch, CHAR_DATA *victim, int loc);
void    check_shield_damage (CHAR_DATA *ch, CHAR_DATA *victim, int loc);
void    check_weapon_damage (CHAR_DATA *ch, CHAR_DATA *victim, int loc);

void    handle_death        (CHAR_DATA *ch, CHAR_DATA *victim);
extern bool check_perception(CHAR_DATA *ch, CHAR_DATA *victim);
extern bool check_riposte   (CHAR_DATA *ch, CHAR_DATA *victim, int dam);
extern bool check_restrike  (CHAR_DATA *ch, CHAR_DATA *victim);
extern bool check_absorb    (CHAR_DATA *ch, CHAR_DATA *victim, int sn, bool distant);
extern bool check_spellbane (CHAR_DATA *ch, CHAR_DATA *victim, int sn);
extern bool is_specialized  (CHAR_DATA *ch, int spec);
extern bool is_spec         (CHAR_DATA *ch, int sn);
extern void upgrade_npc (CHAR_DATA * mob);
extern bool does_not_affect_exp (CHAR_DATA * mob);
extern bool align_ok(CHAR_DATA *ch, int align);
int     check_forest_fighting        (CHAR_DATA *ch);

extern int *psi_attack[];
extern int *psi_defense[];

extern bool check_galka     (CHAR_DATA *ch);

extern STAT_DATA stat_record;

#define FOREST_ATTACK  1
#define FOREST_DEFENCE 2
#define FOREST_NONE    0

typedef struct damage_data DAMAGE_DATA;
struct damage_data
{
    int max_dam;
    char color;
    char *mes[3];
};

DAMAGE_DATA damage_table [] =
{
    {0,    'w', {"misses", "poaxaec o", "poaxac o"}},
    {4,    'c', {"scratches", "apaae", "apaa"}},
    {8,    'c', {"grazes", "aeae", "aea"}},
    {12,   'c', {"hits", "oo aeae", "oo aea"}},
    {16,   'c', {"injures", "opeae", "opea"}},
    {20,   'c', {"wounds", "cea pa", "cea pa"}},
    {24,   'c', {"mauls", "pa", "pa"}},
    {28,   'c', {"decimates", "co pa", "co pa"}},
    {32,   'c', {"devastates", "ocoae", "ocoa"}},
    {36,   'c', {"maims", "ae", "ae"}},
    {42,   'M', {"MUTILATES", "POET", "POT"}},
    {52,   'M', {"DISEMBOWELS", "OOTPOET", "OOTPOT"}},
    {65,   'M', {"DISMEMBERS", "PCEHET", "PCEHT"}},
    {80,   'M', {"MASSACRES", "HTOET", "HTOT"}},
    {100,  'M', {"MANGLES", "EPEMBET", "EPEMBT"}},
    {130,  'y', {"** DEMOLISHES **", "** COKPET **", "** COKPT **"}},
    {175,  'y', {"*** DEVASTATES ***", "*** P3PBET ***", "*** P3PBT ***"}},
    {250,  'Y', {"== OBLITERATES ==", "== CTPET B OPOOK ==", "== CTPT B OPOOK =="}},
    {325,  'Y', {"=== ATOMIZES ===", "=== PCEET H TOM ===", "=== PCET H TOM ==="}},
    {400,  'M', {">> ANNIHILATES <<", ">> HHPET <<", ">> HHPT <<"}},
    {500,  'M', {">>> ERADICATES <<<", ">>> BPBET C KOPHEM <<<", ">>> BPBT C KOPHEM <<<"}},
    {650,  'M', {"-=> ELECTRONIZES <=-", "-=> EKTPOH3PET <=-", "-=> EKTPOH3PT <=-"}},
    {800,  'M', {"-==> SKELETONIZES <==-", "-==> CKEETOH3PET <==-", "-==> CKEETOH3PT <==-"}},
    {1000, 'R', {"## NUKES ##", "## CTPET C  3EM ##", "## CTPT C  3EM ##"}},
    {1250, 'R', {"### TERMINATES ###", "### E3HTEPPET ###", "### E3HTEPPT ###"}},
    {1500, 'R', {"[*][*] TEARS UP [*][*]",
            "[*][*] P3PET H CT [*][*]",
            "[*][*] P3PT H CT [*][*]"}},
    {3000, 'R', {"{*[*][*][*] POWER HITS [*][*][*]",
            "{*[*][*][*] POWER HITS [*][*][*]",
            "{*[*][*][*] POWER HITS [*][*][*]"}},
    {5000, 'R', {"{*<(*)><(*)> U.N.S.P.E.A.K.A.B.L.E <(*)><(*)>",
            "{*<(*)><(*)> U.N.S.P.E.A.K.A.B.L.E <(*)><(*)>",
            "{*<(*)><(*)> U.N.S.P.E.A.K.A.B.L.E <(*)><(*)>"}},
    {10000,'C', {"{*{R<{Y*{D={W(+){D={Y*{R> {CH{W*{CI{W*{CT{W*{CS {R<{Y*{D={W(+){D={Y*{R>",
            "{*{R<{Y*{D={W(+){D={Y*{R> {CH{W*{CI{W*{CT{W*{CS {R<{Y*{D={W(+){D={Y*{R>",
            "{*{R<{Y*{D={W(+){D={Y*{R> {CH{W*{CI{W*{CT{W*{CS {R<{Y*{D={W(+){D={Y*{R>"}},
    {50000,'C', {"{*{R<{Y*{D={W(+){D={Y*{R> {CS{W*{CU{W*{CP{W*{CE{W*{CR {CH{W*{CI{W*{CT{W*{CS {R<{Y*{D={W(+){D={Y*{R>",
            "{*{R<{Y*{D={W(+){D={Y*{R> {CS{W*{CU{W*{CP{W*{CE{W*{CR {CH{W*{CI{W*{CT{W*{CS {R<{Y*{D={W(+){D={Y*{R>",
            "{*{R<{Y*{D={W(+){D={Y*{R> {CS{W*{CU{W*{CP{W*{CE{W*{CR {CH{W*{CI{W*{CT{W*{CS {R<{Y*{D={W(+){D={Y*{R>"}},
    {-1,   'W', {"[{R*{W][{R*{W][{R*{W] DIVINE HITS [{R*{W][{R*{W][{R*{W]",
            "[{R*{W][{R*{W][{R*{W] DIVINE HITS [{R*{W][{R*{W][{R*{W]",
            "[{R*{W][{R*{W][{R*{W] DIVINE HITS [{R*{W][{R*{W][{R*{W]"}},
};

/*
 * Gets all money from the corpse.
 */
void get_gold_corpse(CHAR_DATA *ch, OBJ_DATA *corpse)
{
    OBJ_DATA *tmp, *tmp_next;
    OBJ_DATA *get_coins=NULL;
    for (tmp = corpse->contains; tmp; tmp = tmp_next)
    {
        tmp_next = tmp->next_content;
        if (tmp->pIndexData->item_type == ITEM_MONEY)
            if (IS_SET(ch->plr_flags, PLR_AUTOGOLD)
            && !IS_SET(ch->in_room->room_flags, ROOM_BATTLE_ARENA))
            {
                if (IS_SET(ch->plr_flags, PLR_AUTOSILVER))
                {
                    if (!can_get_obj(ch, tmp, TRUE))
                        get_obj(ch, tmp, corpse, TRUE);
                }
                else
                    if (tmp->value[1])
                {
                    obj_to_obj(get_coins = create_money(tmp->value[1], 0), corpse);
                    if (!can_get_obj(ch, get_coins, TRUE))
                    {
                        get_obj(ch, get_coins, corpse, TRUE);
                        if (tmp->value[0]) obj_to_obj(create_money(0, tmp->value[0]), corpse);
                        extract_obj(tmp);
                    }
                    else extract_obj(get_coins);
                }
            }
    }
}

int check_forest_fighting(CHAR_DATA* ch)
{
    AFFECT_DATA* paf;

    if (ch->in_room->sector_type != SECT_FOREST
    && ch->in_room->sector_type != SECT_HILLS
    && ch->in_room->sector_type != SECT_MOUNTAIN)
        return FOREST_NONE;
    for (paf = ch->affected; paf; paf = paf->next)
    {
        if (paf->type == gsn_forest_fighting)
        {
            if (paf->location == APPLY_AC)
                return FOREST_DEFENCE;
            else
                return FOREST_ATTACK;
        }
    }
    return FOREST_NONE;
}

/*
 * Control the fights going on.
 * Called periodically by update_handler.
 */
void violence_update(void)
{
    CHAR_DATA *ch;
    CHAR_DATA *ch_next;
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    bool room_trig = FALSE;

    for (ch = char_list; ch != NULL; ch = ch_next)
    {
        ch_next = ch->next;

        /* decrement the wait */
        if (ch->desc == NULL)
            ch->wait = UMAX(0, ch->wait - PULSE_VIOLENCE);

        // here we will demonstrate the wrath of gods towards those
        // who have wrong align

        if(!IS_NPC(ch))
            if (!align_ok (ch, RALIGN(ch)))
                wrath_of_gods (ch);

        if ((victim = ch->fighting) == NULL || ch->in_room == NULL)
            continue;

        if (IS_AWAKE(ch) && ch->in_room == victim->in_room)
            multi_hit(ch, victim, TYPE_UNDEFINED);
        else
            stop_fighting(ch, FALSE);

        if ((victim = ch->fighting) == NULL)
            continue;

        if (!IS_NPC(victim))
            ch->last_fought = victim;

        SET_FIGHT_TIME(ch);

        for (obj = ch->carrying; obj; obj = obj_next)
        {
            obj_next = obj->next_content;
            if (ch->fighting == NULL)
                break;
            oprog_call(OPROG_FIGHT, obj, ch, NULL);
        }

        if ((victim = ch->fighting) == NULL)
            continue;

        /*
         * Fun for the whole family!
         */
        check_assist(ch, victim);
        if (IS_NPC(ch))
        {
            if (HAS_TRIGGER_MOB(ch, TRIG_FIGHT))
                p_percent_trigger(ch, NULL, NULL, victim, NULL, NULL, TRIG_FIGHT);
            if (HAS_TRIGGER_MOB(ch, TRIG_HPCNT))
                p_hprct_trigger(ch, victim);
        }

        for (obj = ch->carrying; obj; obj = obj_next)
        {
            obj_next = obj->next_content;

            if (obj->wear_loc != WEAR_NONE && HAS_TRIGGER_OBJ(obj, TRIG_FIGHT))
                p_percent_trigger(NULL, obj, NULL, victim, NULL, NULL, TRIG_FIGHT);
        }

        if (ch && ch->in_room)
        {
              if ( HAS_TRIGGER_ROOM(ch->in_room, TRIG_FIGHT) && room_trig == FALSE)
              {
                  room_trig = TRUE;
                  p_percent_trigger(NULL, NULL, ch->in_room, victim, NULL, NULL, TRIG_FIGHT);
              }
        }
    }
}

/* for auto assisting */
void check_assist(CHAR_DATA *ch,CHAR_DATA *victim)
{
    CHAR_DATA *rch, *rch_next;

    if (ch->in_room == NULL)
        return;

    for (rch = ch->in_room->people; rch != NULL; rch = rch_next)
    {
        rch_next = rch->next_in_room;

        if (IS_AWAKE(rch) && rch->fighting == NULL)
        {
            /* quick check for ASSIST_PLAYER */
            if (!IS_NPC(ch) && IS_NPC(rch)
            && IS_SET(rch->pIndexData->off_flags, ASSIST_PLAYERS)
            && rch->level + 6 > victim->level)
            {
                do_emote(rch, "screams and attacks!");
                multi_hit(rch,victim,TYPE_UNDEFINED);
                continue;
            }

            /* PCs next */
            if (!IS_NPC(rch) || IS_AFFECTED(rch, AFF_CHARM))
            {
                if (((!IS_NPC(rch)
                && IS_SET(rch->plr_flags, PLR_AUTOASSIST))
                || IS_AFFECTED(rch, AFF_CHARM))
                && is_same_group(ch,rch)
                && !is_safe_nomessage(rch, victim))
                    multi_hit (rch,victim,TYPE_UNDEFINED);
                continue;
            }

            if (!IS_NPC(ch) && RIDDEN(rch) == ch)
            {
                multi_hit(rch,victim,TYPE_UNDEFINED);
                continue;
            }

            /* now check the NPC cases */

            if (IS_NPC(ch))
            {
                if ((IS_NPC(rch) && IS_SET(rch->pIndexData->off_flags,ASSIST_ALL))
                || (IS_NPC(rch) && rch->race == ch->race
                && IS_SET(rch->pIndexData->off_flags,ASSIST_RACE))
                || (IS_NPC(rch) && IS_SET(rch->pIndexData->off_flags,ASSIST_ALIGN)
                && ((IS_GOOD(rch) && IS_GOOD(ch))
                || (IS_EVIL(rch) && IS_EVIL(ch))
                || (IS_NEUTRAL(rch) && IS_NEUTRAL(ch))))
                || (rch->pIndexData == ch->pIndexData
                && IS_SET(rch->pIndexData->off_flags,ASSIST_VNUM)))
                {
                    CHAR_DATA *vch;
                    CHAR_DATA *target;
                    int number;

                    if (number_bits(1) == 0)
                        continue;

                    target = NULL;
                    number = 0;

                    for (vch = ch->in_room->people; vch; vch = vch->next_in_room)
                    {
                        if (can_see(rch,vch) &&  is_same_group(vch,victim) &&  number_range(0,number) == 0)
                        {
                            target = vch;
                            number++;
                        }
                    }

                    if (target != NULL)
                    {
                        do_emote(rch,"screams and attacks!");
                        multi_hit(rch,target,TYPE_UNDEFINED);
                    }
                }
            }
        }
    }
}
/* Do one group of attacks.
 * Used by :  void multi_hit(..)
 */
int one_attack(CHAR_DATA *ch, CHAR_DATA *victim, int dt, int dex, int con, int att, int dual, int haste)
{
    if (number_percent() < dex || att == 1);
       one_hit(ch, victim, dt, WEAR_WIELD);

    if (JUST_KILLED(victim) || JUST_KILLED(ch))
        return 1;

    if (number_range(1,con)<++att)
    {
        ch->move -= att/2;
        return 0;
    }

    if (number_percent() < dex * dual/100)
    {
        one_hit(ch, victim, dt, WEAR_SECOND_WIELD);
        if (get_eq_char(ch, WEAR_SECOND_WIELD) != NULL)
            check_improve(ch, gsn_second_weapon, TRUE, 7);
        else
            check_improve(ch, gsn_hand_to_hand, TRUE, 7);

        if (JUST_KILLED(victim) || JUST_KILLED(ch))
            return 1;

        if (number_range(1, con) < ++att)
        {
            ch->move -= att / 2;
            return 0;
        }
    }

    if (number_range(0, ch->level) < haste)
        return one_attack(ch, victim, dt, dex/2, con, att, dual, 0);
    return 0;
}

/*
 * Do one serie of attacks.
 */
void multi_hit(CHAR_DATA *ch, CHAR_DATA *victim, int dt)
{
    int chance, dual, dex, con, att, bonus, haste;
    OBJ_DATA *wield;
    int nhits;


    /* no attacks for stunnies -- just a check */
    if (ch->position < POS_RESTING)
        return;

#if 0
    /* become CRIMINAL in Law rooms */
    if (!IS_NPC(ch) && !IS_NPC(victim)
    && IS_SET(ch->in_room->room_flags, ROOM_LAW)
    && !IS_SET(victim->plr_flags, PLR_WANTED)
    && !IS_SET(ch->plr_flags, PLR_WANTED))
    {
        char_act("This room is under supervision of the law! Now you're {RCRIMINAL{x!", ch);
        SET_BIT(ch->plr_flags, PLR_WANTED);
    }
#endif

    /* ridden's adjustment */
    if (RIDDEN(victim) && !IS_NPC(victim->mount))
    {
        if (victim->mount->fighting == NULL
        || victim->mount->fighting == ch)
            victim = victim->mount;
        //else
        //    do_dismount(victim->mount, str_empty);
    }

    if (IS_AFFECTED(ch, AFF_WEAK_STUN))
    {
        act_puts("You are too stunned to respond $N's attack.",
            ch, NULL, victim, TO_CHAR, POS_FIGHTING);
        act_puts("$n is too stunned to respond your attack.",
            ch, NULL, victim, TO_VICT, POS_FIGHTING);
        REMOVE_BIT(ch->affected_by, AFF_WEAK_STUN);
        return;
    }

    if (IS_AFFECTED(ch, AFF_STUN))
    {
        act_puts("You are too stunned to respond $N's attack.",
            ch, NULL, victim, TO_CHAR, POS_FIGHTING);
        act_puts("$n is too stunned to respond your attack.",
            ch, NULL, victim, TO_VICT, POS_FIGHTING);
        act_puts("$n seems to be stunned.",
            ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);
        affect_bit_strip(ch, TO_AFFECTS, AFF_STUN);
        SET_BIT(ch->affected_by, AFF_WEAK_STUN);
        return;
    }

    if (IS_NPC(ch))
    {
        mob_hit(ch, victim, dt);
        return;
    }

    if (ch->move <= 0)
    {
        act_puts("You are too tired for attack.", ch, NULL, victim, TO_CHAR, POS_FIGHTING);
        return;
    }

    if (number_percent() < get_skill(ch, gsn_area_attack))
    {
        int count = 0, max_count;
        CHAR_DATA *vch, *vch_next;

        check_improve(ch, gsn_area_attack, TRUE, 6);

        max_count = 3 + (LVL(ch)>=70) + (LVL(ch)>=80) + (LVL(ch)>=90);

        // GM : ADV FURY
        if (is_affected(ch, gsn_adv_fury))
        {
            max_count += LVL(ch) / 20;
            check_improve(ch, gsn_adv_fury, TRUE, 6);
        }

        for (vch = ch->in_room->people; vch; vch = vch_next)
        {
            vch_next = vch->next_in_room;
            if (vch != victim && vch->fighting == ch)
            {
                one_hit(ch, vch, dt, WEAR_WIELD);
                if (JUST_KILLED(ch))
                    return;
                if (++count == max_count)
                    break;
            }
        }
    }

    if ((chance = get_skill(ch, gsn_zeal)))
    {
        if (number_percent() < chance / 10)
        {
            int count = 0, max_count;
            bool found =  TRUE;
            CHAR_DATA *vch, *vch_next;
            check_improve(ch, gsn_zeal, TRUE, 2);
            max_count = URANGE(1, LVL(ch) / 10, 8);
            char_act(" أ     ", ch);
            act("$n أ     .",  ch, NULL, NULL, TO_ROOM);
            while (found && count < max_count && ch->fighting != NULL)
            {
                found = FALSE;
                for (vch = ch->in_room->people; vch; vch = vch_next)
                {
                    vch_next = vch->next_in_room;
                    if (vch->fighting == ch)
                    {
                        found = TRUE;
                        one_hit(ch, vch, dt, WEAR_WIELD);
                        if (JUST_KILLED(ch))
                            return;
                        if (++count == max_count)
                            break;
                    }
                }
            }
        }
        else
            check_improve(ch, gsn_zeal, FALSE, 1);
    }

/*
 *   
 *  dex -  ,      , ,
 *       .
 *  haste     dex,    
 *    haste',       .
 *  con -      , 
 *     1 mv,   
 *  (  ,    -   )
 */

    dex = dex_app[get_curr_stat(ch, STAT_DEX)].att;
    con = get_curr_stat(ch, STAT_CON)-3;
    haste = 0;
    bonus = 0;
    if (IS_AFFECTED(ch, AFF_SLOW))
        dex /= 2;
    else if (IS_AFFECTED(ch, AFF_HASTE))
    {
        AFFECT_DATA *af;
        for (af = ch->affected; af != NULL; af = af->next)
        {
            if (af->bitvector == AFF_HASTE)
            {
                bonus += URANGE(2, af->level/10, 10);
                haste = UMAX(haste, af->level);
            }
        }
        if (!haste)
            haste = ch->level;
        bonus += ch->mod_stat[STAT_DEX];
        dex += bonus/3;
    }

    if (IS_SET(victim->form, FORM_BEAR)) dex += 20;
    if (IS_SET(ch->form, FORM_WOLF)) dex += 20;

    switch (ch->stance)
    {
    case STANCE_OFFENSE_II  : break;
    case STANCE_OFFENSE     : dex -= 10; break;
    case STANCE_DEFENSE     : dex -= 30; break;
    case STANCE_DEFENSE_II  : dex -= 40; break;
    default                 : dex -= 20;
    }
    dex = URANGE(0, dex, dex_app[get_curr_stat(ch, STAT_DEX)].att + 15);

/*
 *         ,    .
 *      ,    ,
 *     ,       ,
 *   ,      .
 */
    if (get_eq_char(ch, WEAR_WIELD))
        dual = get_skill(ch, gsn_second_weapon) * 2 / 3;
    else
        dual = get_skill(ch, gsn_hand_to_hand) * 2 / 3;

    if (get_eq_char(ch, WEAR_SHIELD) || get_eq_char(ch, WEAR_HOLD))
        dual = 0;

    if (((wield=get_eq_char(ch,WEAR_WIELD)) != NULL)
    && (IS_WEAPON_STAT(wield, WEAPON_TWO_HANDS)
    || IS_WEAPON_STAT(wield, WEAPON_KATANA))
    && (get_eq_char(ch,WEAR_SECOND_WIELD) == NULL))
        dual = 0;

    // before all attacks because of all those returns
    if (altar_works (ch, ALTAR_HASTE_POS))
    {
        nhits = number_range (0,2);
        while (nhits--)
        {
            if (number_percent () < 80)
            {
                act("$n becomes blurred and starts to move very fast.",
                    ch, NULL, NULL, TO_ROOM);
                char_act("You become blurred and start to move very fast.", ch);

                one_hit(ch, ch->fighting, TYPE_UNDEFINED, WEAR_WIELD);
            }
        }
    }

    if (check_forest_fighting(ch) == FOREST_ATTACK)
    {
        chance = get_skill(ch, gsn_forest_fighting);
        while (number_percent() < chance)
        {
            one_hit(ch, victim, dt, WEAR_WIELD);
            check_improve (ch, gsn_forest_fighting, TRUE, 8);
            if (ch->fighting != victim || JUST_KILLED(ch) || JUST_KILLED(victim))
                return;
            chance /= 3;
        }
    }

//    .
    att = 0;
// 
    if (one_attack(ch, victim, dt, dex, con, ++att, dual, haste))
        return;
// 
    if (number_percent() < get_skill(ch, gsn_second_attack))
    {
        check_improve(ch, gsn_second_attack, TRUE, 7);
        if (one_attack(ch, victim, dt, dex, con, ++att, dual, haste))
            return;
    }
    if (ch->stance == STANCE_DEFENSE_II)
        return;
// 
    if (number_percent() < get_skill(ch, gsn_third_attack))
    {
        check_improve(ch, gsn_third_attack, TRUE, 7);
        if (one_attack(ch, victim, dt, dex, con, ++att, dual, haste))
            return;
    }
    if (ch->stance == STANCE_DEFENSE || ch->stance == STANCE_DEFENSE_II)
        return;
// 
    if (number_percent() < get_skill(ch, gsn_fourth_attack))
    {
        check_improve(ch, gsn_fourth_attack, TRUE, 7);
        if (one_attack(ch, victim, dt, dex, con, ++att, dual, haste))
            return;
    }
    if (ch->stance == STANCE_DEFENSE || ch->stance == STANCE_DEFENSE_II
    || ch->stance == STANCE_NORMAL)
        return;
// 
    if (number_percent() < get_skill(ch, gsn_fifth_attack))
    {
        check_improve(ch,gsn_fifth_attack,TRUE, 7);
        if (one_attack(ch, victim, dt, dex, con, ++att, dual, haste))
            return;
    }
}

/* procedure for all mobile attacks */
void mob_hit(CHAR_DATA *ch, CHAR_DATA *victim, int dt)
{
    CHAR_DATA *vch, *vch_next;
    flag64_t act = ch->pIndexData->act;
    flag64_t off = ch->pIndexData->off_flags;
    int chance;

    /* no attack by ridden mobiles except spec_casts */
    if (RIDDEN(ch))
    {
        if (ch->fighting != victim)
            set_fighting(ch, victim);
        return;
    }

    one_hit(ch, victim, dt, WEAR_WIELD);

    if (JUST_KILLED(ch) || JUST_KILLED(victim))
        return;

    /* Area attack -- BALLS nasty! */

    if (IS_SET(off, OFF_AREA_ATTACK))
    {
        for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
        {
            vch_next = vch->next_in_room;
            if ((vch != victim && vch->fighting == ch))
                one_hit(ch, vch, dt, WEAR_WIELD);
            if (JUST_KILLED(ch))
                return;
        }
    }

    if (IS_AFFECTED(ch, AFF_HASTE) || IS_SET(off, OFF_FAST))
        one_hit(ch, victim, dt, WEAR_WIELD);

    if (JUST_KILLED(ch) || JUST_KILLED(victim))
        return;

    if (ch->fighting != victim || dt == gsn_backstab || dt == gsn_circle
    || dt == gsn_dual_backstab || dt == gsn_cleave || dt == gsn_ambush
    || dt == gsn_vampiric_bite || dt == gsn_charge)
        return;

    if (number_percent() < (get_skill(ch, gsn_second_attack) / 2) + 20)
    {
        one_hit(ch, victim, dt, WEAR_WIELD);
        if (ch->fighting != victim || JUST_KILLED(ch) || JUST_KILLED(victim))
            return;
    }

    if ((number_percent() < (get_skill(ch, gsn_third_attack) / 3) + 12)
        && !IS_AFFECTED(ch, AFF_SLOW))
    {
        one_hit(ch, victim, dt, WEAR_WIELD);
        if (ch->fighting != victim || JUST_KILLED(ch) || JUST_KILLED(victim))
            return;
    }

    if ((number_percent() < (get_skill(ch, gsn_fourth_attack) / 4) + 8)
        && !IS_AFFECTED(ch, AFF_SLOW))
    {
        one_hit(ch, victim, dt, WEAR_WIELD);
        if (ch->fighting != victim || JUST_KILLED(ch) || JUST_KILLED(victim))
            return;
    }


    if (check_forest_fighting(ch) == FOREST_ATTACK)
    {
        chance = get_skill(ch, gsn_forest_fighting);
        while (number_percent() < chance)
        {
            one_hit(ch, victim, dt, WEAR_WIELD);
            check_improve (ch, gsn_forest_fighting, TRUE, 8);
            if (ch->fighting != victim || JUST_KILLED(ch) || JUST_KILLED(victim))
                return;
            chance /= 3;
        }
    }

    if (!MOUNTED(ch))
    {
        affect_strip(ch, gsn_mount_fighting);
        affect_strip(ch, gsn_mount_control);
    }

    if (number_percent() < get_skill(ch, gsn_mount_fighting)
    && MOUNTED(ch))
    {
        chance = get_skill(ch, gsn_mount_fighting);
        while (number_percent() < chance)
        {
            one_hit(ch, victim, dt, WEAR_WIELD);
            check_improve (ch, gsn_mount_fighting, TRUE, 8);
            if (ch->fighting != victim || JUST_KILLED(ch) || JUST_KILLED(victim))
                return;
            chance /= 3;
        }
    }

    /* PC waits */

    if (ch->wait > 0)
        return;

    if (ch->fighting && number_bits(2) == 1
    && IS_CYBORG(ch))
    {
        do_annihilate(ch, str_empty);
        return;
    }

    if (ch->fighting && number_bits(3) == 1
    && IS_MECH(ch))
    {
        do_flamethrower(ch, str_empty);
        return;
    }

    if (ch->fighting && number_bits(3) == 1
    && IS_MECH(ch))
    {
        do_machinegun(ch, str_empty);
        return;
    }


#if 0
    switch (number_range(0, 2))
    {
    case 1:
        if (IS_SET(act, ACT_MAGE))
        {
            mob_cast_mage(ch, victim);
            return;
        }
        break;
    case 2:
        if (IS_SET(act, ACT_CLERIC))
        {
            mob_cast_cleric(ch, victim);
            return;
        }
        break;
    }
#endif

    /* now for the skills */

    switch (number_range(0, 10))
    {
    case 0:
        if (IS_SET(off, OFF_BASH))
            do_bash(ch, str_empty);
        break;

    case 1:
        if (IS_SET(off, OFF_BERSERK)
        && !IS_AFFECTED(ch, AFF_BERSERK))
            do_berserk(ch, str_empty);
        break;


    case 2:
        if (IS_SET(off, OFF_DISARM)
        || IS_SET(act, ACT_WARRIOR | ACT_THIEF))
        {
            if (number_range(0, 1)
            && get_eq_char(victim, WEAR_SECOND_WIELD))
                do_disarm(ch, "second");
            else if (get_eq_char(victim, WEAR_WIELD))
                do_disarm(ch, str_empty);
        }
        break;

    case 3:
        if (IS_SET(off, OFF_KICK))
            do_kick(ch, str_empty);
        break;

    case 4:
        if (IS_SET(off, OFF_DIRT_KICK))
        {
            if (IS_AFFECTED(ch, AFF_FLYING))
            {
                do_fly(ch, "down");
                do_dirt(ch, str_empty);
                do_fly(ch, "up");
            }
            else
                do_dirt(ch, str_empty);
        }
        break;

    case 5:
        if (IS_SET(off, OFF_TAIL))
            do_tail(ch, str_empty);
        break;

    case 6:
        if (IS_SET(off, OFF_TRIP)
        && !IS_AFFECTED(victim, AFF_FLYING))
            do_trip(ch, str_empty);
        break;
    case 7:
        if (IS_SET(off, OFF_CRUSH))
        {
            if (get_eq_char(ch, WEAR_FEET) != NULL)
                do_crush_boots(ch, str_empty);
            else
                do_crush(ch, str_empty);
        }
        break;
    }
}

int get_dam_type(CHAR_DATA *ch, OBJ_DATA *wield, int *dt)
{
    int dam_type;

    if (*dt == TYPE_UNDEFINED)
    {
        *dt = TYPE_HIT;
        if (wield &&  wield->pIndexData->item_type == ITEM_WEAPON)
            *dt += wield->value[3];
        else
            *dt += ch->dam_type;
    }

    if (*dt < TYPE_HIT)
        if (wield)
            dam_type = attack_table[wield->value[3]].damage;
        else
            dam_type = attack_table[ch->dam_type].damage;
    else
    {
        dam_type = attack_table[*dt - TYPE_HIT].damage;
    }

    if (dam_type == TYPE_UNDEFINED)
        dam_type = DAM_BASH;

    return dam_type;
}

/*
 * Hit one guy once.
 */

void one_hit_new( CHAR_DATA *ch, CHAR_DATA *victim, int dt, int loc )
{
    OBJ_DATA *wield,*worn;
/*    int victim_ac;
    int thac0;
    int thac0_00;
    int thac0_32;
*/
    long           dam=0,part=0;
    int            diceroll;
    int            sn,skill,num1,i,j,todam,eqdam;
    int            dam_type;
    bool           result;
    char buf[256], *word;
    material_t     *material;


    material = NULL;
    sn = -1;


    /* just in case */
    if (victim == ch || ch == NULL || victim == NULL )
        return;

    /*
     * Can't beat a dead char!
     * Guard against weird room-leavings.
     */
     //ch->position == POS_DEAD are necessary
    if (victim->position == POS_DEAD ||  ch->position == POS_DEAD || ch->in_room  != victim->in_room)
        return;

    /*
     * Figure out the type of damage message.
     */
    wield = get_eq_char( ch, WEAR_WIELD );

    if ( dt == TYPE_UNDEFINED )
    {
        dt = TYPE_HIT;
        if ( wield != NULL && wield->pIndexData->item_type == ITEM_WEAPON )
            dt += wield->value[3];
        else
            dt += ch->dam_type;
    }

    if (dt < TYPE_HIT)
        if (wield != NULL)
            dam_type = attack_table[wield->value[3]].damage;
        else
            dam_type = attack_table[ch->dam_type].damage;
    else
        dam_type = attack_table[dt - TYPE_HIT].damage;

    if (dam_type == -1)
        dam_type = DAM_BASH;

    /* get the weapon skill */
    sn = get_weapon_sn(wield);
    skill = get_weapon_skill(ch,sn);
    if (wield) skill*=str_app[get_curr_stat(ch, STAT_STR)].wield/
                      UMAX(str_app[get_curr_stat(ch, STAT_STR)].wield,wield->weight/5);


    /*     */
    num1 = number_range(0, victim->pcnt);
    i=0;
    j=0;
    /*
           ,  i  
           ,   .
        i  num1, part  ,  .
    */
    while (i<num1 && j<MAX_PARTS)
    {
        if (IS_SET(victim->parts,(flag64_t) 1 << j))
        {
            i++;
            part = (flag64_t) 1 << j;
        }
        j++;
    }
    switch (part)
    {
    default:     word=""; break;
    case  PART_HEAD: word=" "; break;
    case  PART_ARMS: word=" "; break;
    case  PART_LEGS: word=" "; break;
    case  PART_HEART: word=" "; break;
    case  PART_BRAINS: word=" "; break;
    case  PART_GUTS: word=" "; break;
    case  PART_HANDS: word=" "; break;
    case  PART_FEET: word=" "; break;
    case  PART_FINGERS: word=" "; break;
    case  PART_EAR: word=" "; break;
    case  PART_EYE: word=" "; break;
    case  PART_LONG_TONGUE: word=" "; break;
    case  PART_EYESTALKS: word=" "; break;
    case  PART_TENTACLES: word=" "; break;
    case  PART_FINS: word=" "; break;
    case  PART_WINGS: word=" "; break;
    case  PART_TAIL: word=" "; break;
    case  PART_CLAWS: word=" "; break;
    case  PART_FANGS: word=" "; break;
    case  PART_HORNS: word=" "; break;
    case  PART_SCALES: word="  "; break;
    case  PART_TUSKS: word=" "; break;
    }
    snprintf(buf, sizeof(buf), "  %s %s.\n", word, IS_NPC(victim) ? mlstr_cval(victim->short_descr, ch) : victim->name);
    if (strcmp(word,""))
        snprintf(buf, sizeof(buf), "%s   %s.\n", IS_NPC(ch) ? mlstr_cval(ch->short_descr, ch) : ch->name, word );
    else
        snprintf(buf, sizeof(buf), "%s   .\n", IS_NPC(ch) ? mlstr_cval(ch->short_descr, ch) : ch->name);

    /*
     *  ,  ,     :
     * 1)  
     * 2)      (<100)  
     */
    if (check_dodge(ch, victim))
    {
        damage( ch, victim, 0, dt, dam_type, FALSE );
        tail_chain();
        return;
    }
    if (number_percent()>skill)
    {
        damage( ch, victim, 0, dt, dam_type, TRUE );
        tail_chain();
        return;
    }

    todam=ch->size/5;
    eqdam=ch->size/victim->size;

    /*    */
    if (wield == NULL)
        dam = number_range(ch->level / 2, ch->level)*
              ch->size * skill / 100;
    else
    {
        if (!IS_NPC(ch) && sn!=-1) check_improve(ch, sn, TRUE, 5);
        dam = dice(wield->value[1], wield->value[2]) * skill/100;
        /* sharpness! */
        if (IS_WEAPON_STAT(wield,WEAPON_SHARP))
        {
            int percent;
            if ((percent = number_percent()) <= (skill / 8))
                dam = 2 * dam + (dam * 8 * percent / 100);
            todam+=percent/3;
        }
    }

    if ( get_skill(ch,gsn_enhanced_damage) > 0 )
    {
        diceroll = number_percent();
        if (diceroll <= get_skill(ch,gsn_enhanced_damage))
        {
            check_improve(ch,gsn_enhanced_damage,TRUE,6);
            dam += dam * diceroll/120;
            eqdam+= diceroll/50;
        }
    }

    worn=NULL;

/*  sh/b, parry -        . */
    if (check_block(ch, victim, WEAR_WIELD))
    {
        worn = get_eq_char(victim, WEAR_SHIELD);
        if (worn)
        {
            eq_damage(ch, victim, worn, todam/5, eqdam/3+1);
            dam/=2;
        }
    }
    else if (check_parry(ch, victim, WEAR_WIELD))
    {
        worn = get_eq_char(victim, WEAR_WIELD);
        if (worn)
        {
            eq_damage(ch, victim, worn, todam/4, eqdam/4+1);
            damage( ch, victim, 0, dt, dam_type, FALSE );
            tail_chain();
            return;
        }
        /*       ,     
           ,    ,      
            ,       */
        else
        {
            part=PART_HANDS;
            dam*=1.5;
            todam*=1.3;
            eqdam*=1.5;
        }
    }

/*
       ,  worn!=0,
       ,    ,
      ,  shield block  ,
       ,  worn=0,     - 
*/

    if (!worn)
        worn = get_eq_char(victim, part2wear(part));

    if (worn && worn->material)
        material = material_lookup(worn->material);

     if (material == NULL)
          material = MATERIAL(0);

    if (worn && (IS_SET(material->flag, MAT_ARMOR)))
    {
        /*    -   */
        float glubina;
//      printf("todam: %d, eqdam: %d, ", todam, eqdam);
        switch (dam_type)
        {
        case DAM_SLASH:
            if (material->rigidity &&  material->density)
                /*  -  *  / ...... */
                glubina=2000/(float)(material->rigidity *  material->density);
            else glubina=100;
//          printf("glubina: %f, dam old: %ld, ", glubina, dam);

            if (glubina>0 && glubina<worn->value[4]+1)
            {
                eq_damage(ch, victim, worn, todam,
                          eqdam*glubina*100/((worn->value[4]+1)*
                                             (number_percent()>ch->damroll?20:10)));
                dam=wield ? wield->weight * ch->level *
                    material->rigidity/(4500) :
                    dam*material->rigidity/100;
            }
            else
            {
                eq_damage(ch, victim, worn, todam, glubina*100/((worn->value[4]+1)*
                                                                (number_percent()>ch->damroll?10:5)));
                if (glubina<100 && glubina>0)
                    dam*=glubina/(glubina+worn->value[4]+1);
            }
//          printf("dam: %ld\n",dam);
            break;
        case DAM_BASH:
//          printf("glubina: 0(bash), dam old: %ld, ", dam);
            dam*=(100 + material->rigidity*5)/(worn->value[4]*600+600);
            eq_damage(ch, victim, worn, todam * material->fragility, eqdam * material->fragility);
//        printf("dam: %ld\n",dam);
            break;
        case DAM_PIERCE:
            /*  ,     ;
                    */
            if (material->density>50 &&
                material->rigidity>20)
                glubina=1000/(float)
                        (material->rigidity*material->density);
            else glubina=100;
//          printf("glubina: %f, dam old: %ld, ", glubina, dam);
            if (glubina>0 && glubina<=worn->value[4]+1)
            {
                if (material->density>40)
                    eq_damage(ch, victim, worn,
                              todam*material->rigidity/5,
                              eqdam*material->rigidity/5);
                if (material->density>0)
                    glubina*=40/(float)material->density;
            }
            else if (glubina>0 && glubina>worn->value[4]+1)
            {
                if (material->density>40)
                    eq_damage(ch, victim, worn,
                              todam*material->rigidity/3,
                              eqdam*material->rigidity/2);
                if (material->density>0)
                    glubina*=40/(float)material->density;
            }
            if (glubina<worn->value[4]+1)
                dam*=glubina/(worn->value[4]+1);
            else
                dam*=(glubina-worn->value[4]-1)/glubina;
//        printf("dam: %ld\n",dam);
            break;
        default:
            break;
        }
    }

    if ( victim->position == POS_RESTING )
        dam *= 2;
    if ( !IS_AWAKE(victim) )
        dam *= 2;
    else if (victim->position < POS_FIGHTING)
        dam = dam * 3 / 2;

    if ( dt == gsn_backstab && wield != NULL)
    {
        if ( wield->value[0] != 2 )
            dam *= 2 + (LVL(ch) / 10);
        else
            dam *= 2 + (LVL(ch) / 8);
    }

    dam = UMAX(dam,1);
    result = damage( ch, victim, dam, dt, dam_type, TRUE );
    check_improve(ch, sn, result!=0, 2);

    /* but do we have a funky weapon? */
    if (result && wield != NULL)
    {
        long dam;

        if (ch->fighting == victim && IS_WEAPON_STAT(wield,WEAPON_POISON))
        {
            int level;
            AFFECT_DATA *poison, af;

            if ((poison = affect_find(wield->affected,gsn_poison)) == NULL)
                level = wield->level;
            else
                level = poison->level;

            if (!saves_spell(level / 2,victim,DAM_POISON))
            {
                char_act("You feel poison coursing through your veins.", victim);
                act("$n is poisoned by the venom on $p.", victim, wield, NULL, TO_ROOM);

                af.where     = TO_AFFECTS;
                af.type      = gsn_poison;
                af.level     = level * 3/4;
                af.duration  = level / 2;
                af.location  = APPLY_STR;
                af.modifier  = -1;
                af.bitvector = AFF_POISON;
                affect_join( victim, &af );
            }

            /* weaken the poison if it's temporary */
            if (poison != NULL)
            {
                poison->level = UMAX(0,poison->level - 2);
                poison->duration = UMAX(0,poison->duration - 1);

                if (poison->level == 0 || poison->duration == 0)
                    act("The poison on $p has worn off.", ch, wield, NULL, TO_CHAR);
            }
        }

        if (ch->fighting == victim && IS_WEAPON_STAT(wield, WEAPON_VAMPIRIC))
        {
            dam = number_range(1, wield->level / 5 + 1);
            // max dam for vamp
            if (IS_SET(ch->form, FORM_VAMPIRE))
                dam = wield->level / 5 + 1;
            act("$p draws life from $n.", victim, wield, NULL, TO_ROOM);
            act("You feel $p drawing your life away.", victim, wield, NULL, TO_CHAR | ACT_VERBOSE);
            damage(ch, victim, dam, 0, DAM_NEGATIVE, FALSE);
//        ch->alignment = UMAX(-1000, ch->alignment - 1);
            // more hp for vamp (max == 200)
            if (IS_SET(ch->form, FORM_VAMPIRE))
                ch->hit += dam * 10;
            else
                ch->hit += dam / 2;
        }

        if (ch->fighting == victim && IS_WEAPON_STAT(wield, WEAPON_FLAMING))
        {
            dam = number_range(1, wield->level / 4 + 1);
            act("$n is burned by $p.",victim,wield,NULL,TO_ROOM | ACT_VERBOSE);
            act("$p sears your flesh.",victim,wield,NULL,TO_CHAR | ACT_VERBOSE);
            fire_effect( (void *) victim, wield->level / 2, dam, TARGET_CHAR);
            damage(ch, victim, dam, 0, DAM_FIRE, FALSE);
        }

        if (ch->fighting == victim && IS_WEAPON_STAT(wield,WEAPON_FROST))
        {
            dam = number_range(1,wield->level / 6 + 2);
            act("$p freezes $n.",victim,wield,NULL,TO_ROOM | ACT_VERBOSE);
            act("The cold touch of $p surrounds you with ice.", victim,wield,NULL,TO_CHAR | ACT_VERBOSE);
            cold_effect(victim,wield->level/2,dam,TARGET_CHAR);
            damage(ch,victim,dam,0,DAM_COLD,FALSE);
        }

        if (ch->fighting == victim && IS_WEAPON_STAT(wield,WEAPON_SHOCKING))
        {
            dam = number_range(1,wield->level/5 + 2);
            act("$n is struck by lightning from $p.", victim,wield,NULL,TO_ROOM | ACT_VERBOSE);
            act("You are shocked by $p.", victim,wield,NULL,TO_CHAR | ACT_VERBOSE);
            shock_effect(victim,wield->level/2,dam,TARGET_CHAR);
            damage(ch,victim,dam,0,DAM_LIGHTNING,FALSE);
        }

        if (ch->fighting == victim && IS_WEAPON_STAT(wield,WEAPON_RADIATION))
        {
            dam = number_range(1,wield->level/5 + 2);
            act("$n    $p.", victim,wield,NULL,TO_ROOM | ACT_VERBOSE);
            act("    $p.", victim,wield,NULL,TO_CHAR | ACT_VERBOSE);
            radiation_effect(victim, wield->level, TARGET_CHAR);
            damage(ch,victim,dam,0,DAM_RADIATION,FALSE);
        }

        if (ch->fighting == victim && IS_OBJ_STAT(wield,ITEM_DEATH))
        {
            dam = number_range(3,wield->level/4 + 4);
            act("The death power of $p torments $n.", victim,wield,NULL,TO_ROOM | ACT_VERBOSE);
            act("The death power of $p torments you.", victim,wield,NULL,TO_CHAR | ACT_VERBOSE);
            damage(ch,victim,dam,0,DAM_NEGATIVE,FALSE);
        }
        if (ch->fighting == victim && IS_OBJ_STAT(wield, ITEM_SINGING))
        {
            dam = number_range(10,wield->level/4 + 4);
            act("$p ϣ !!\n$n,   !", victim, wield, NULL, TO_ROOM | ACT_VERBOSE);
            act("$p ϣ !!\n  !", victim, wield, NULL, TO_CHAR | ACT_VERBOSE);
            damage(ch,victim,dam,0,DAM_SOUND,FALSE);


        }

    }
    tail_chain( );
    return;
}

void delete_player(CHAR_DATA *victim, char* msg)
{
    char *name;

    char_act("You became a ghost permanently and leave the realm.", victim);
    act("$n is dead, and will not rise again.", victim, NULL, NULL, TO_ROOM);
    victim->hit = 1;
    victim->position = POS_STANDING;
    wiznet_printf(victim, NULL, 0, 0, 0, "$N is deleted due to %s.", msg);
    RESET_FIGHT_TIME(victim);
    name = capitalize(victim->name);
    do_quit_count(victim, str_empty);
    dunlink(PLAYER_PATH, name);
}

/*
 * handle_death - called from `damage' if `ch' has killed `victim'
 */
void handle_death(CHAR_DATA *ch, CHAR_DATA *victim)
{
    char *penalty=str_empty;
    bool vnpc = IS_NPC(victim);
    bool is_duel = (!IS_NPC(victim))
                   && (!IS_NPC(ch) || IS_AFFECTED(ch, AFF_CHARM))
                   && (IS_SET(victim->in_room->room_flags, ROOM_BATTLE_ARENA));
//    int chance = 0;
    int headprice = 0;
    OBJ_DATA *corpse;
    CHAR_EXPLORED_DATA *curr_expl_area;
    bool area_found;
    CHAR_DATA *gch;

    clan_t *clan = NULL;

    if (ch == victim && victim->fighting != NULL)
    {
        ch = victim->fighting;
    }

    if (IS_AFFECTED(ch, AFF_CHARM))
    {
        if (ch->master != NULL)
            ch = ch->master;
    }
    // TODO temporary artefacts removed
    // check_artefact_appearance(ch, victim, artefactList);
    clan = CLAN(ch->clan);

    if (!IS_NPC(victim))
        wiznet_printf(ch, NULL, WIZ_DEATHS, 0, 0, "$N kills %s.", victim->name);

    if (!IS_NPC(victim))
        log_printf("Kill: %s kills %s.", ch->name, victim->name);

    if (!IS_NPC(ch) && !IS_NPC(victim))
        agent_net_printf(victim, ch, ANET_KILLED);

    if ((!IS_NPC(ch)
    || IS_AFFECTED(ch, AFF_CHARM))
    && !IS_NPC(victim) && ch != victim)
    {
        if (victim->level == LEVEL_HERO)
            info(victim, LEVEL_HERO, "{r[{RINFO{r]{W The so-called hero {Y%s {Wwas killed!{x\n", victim->name);
        else
            info(victim, LEVEL_HERO, "{r[{RINFO{r]{W Someone called {y%s {Wwas killed!{x", victim->name);
    }

    if (IS_NPC (victim))
        ++stat_record.mobs_killed;
    else
    {
        if (IS_NPC(ch))
            ++stat_record.pc_killed_by_mobs;
        else
        {
            ++stat_record.PK_count;
            if (IS_SET (victim->in_room->room_flags, ROOM_BATTLE_ARENA))
                ++stat_record.PK_on_CR;
        }
    }

    if (victim->in_war)
    {
        // when true - this death was during the war and was handled - so we must return
        if (war_handle_death (ch, victim)) // in this function we reset fight_time
        {
            victim->position = POS_RESTING;
            return;
        }
    }

    if (!IS_NPC(ch)
    && !IS_NPC(victim)
    && !IS_SET(victim->in_room->room_flags, ROOM_BATTLE_ARENA)
    && victim->pcdata->headprice > 0)
    {
        headprice = victim->pcdata->headprice;
        if (IS_SET(clan->flags, CLAN_HIDDEN))
            headprice = number_range(headprice * 2, headprice * 10);
        act("You recive a $j gold as headprice, for killing $N.",
            ch, (const void *) headprice, victim, TO_CHAR);
        ch->pcdata->bank_g += headprice;
        victim->pcdata->headprice = 0;
    }

    if (!IS_NPC(victim))
    {
        if (victim->daze > 0)
            victim->daze = 0;
        if (victim->wait > 0)
            victim->wait = 0;
    }

    group_gain(ch, victim);

    if (IS_NPC(ch) && ch->pIndexData->vnum == MOB_VNUM_STALKER)
        ch->status = 10;

     // Death trigger
    if (vnpc && HAS_TRIGGER_MOB(victim, TRIG_DEATH))
    {
        victim->position = POS_STANDING;
        p_percent_trigger(victim, NULL, NULL, ch, NULL, NULL, TRIG_DEATH);
    }

    // moved here from raw_kill to avoid bugs
    // where death is avoided thru death_prog
    {
        OBJ_DATA* obj;
        OBJ_DATA* obj_next;

        for (obj = victim->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            if (obj->wear_loc != WEAR_NONE
            && oprog_call(OPROG_DEATH, obj, victim, ch))
            {
                victim->position = POS_STANDING;
                return;
            }
        }
    }

    // tattoo 'nine green spiders'
    {
        int ssn = sn_lookup ("nine green spiders");

        if (is_affected (victim, ssn) && check_tattoo (victim, ssn)
            && (number_percent() < get_skill (victim, ssn) - 10))
        {
            check_improve(victim, ssn, TRUE, 1);

            while (victim->affected)
                affect_remove(victim, victim->affected);

            if (ch && IS_NPC(ch) && !IS_SET (ch->pIndexData->act, ACT_CLAN_GUARD))
            {
                remove_mind(ch, victim->name);
                ch->last_fought = NULL;
            }

            stop_fighting(victim, TRUE);

            RESET_FIGHT_TIME(victim);

            victim->last_death_time = current_time;

            victim->hit     = (victim->max_hit/2);
            victim->mana    = (victim->max_mana/5);
            victim->move    = (victim->max_move/10);
            victim->position = POS_STANDING;

            char_act ("Nine green spiders give you their energy. One more time you've tricked death.", victim);
            act ("Nine green spiders on $n's tattoo glow brightly and are gone.", victim, NULL, NULL, TO_ROOM);

            return;
        }
    }

    // take revenge
/*    if (HAS_SKILL(victim, gsn_take_revenge))
    {
        chance = get_skill(victim, gsn_take_revenge) / 3;
        char_act("Loading skill data............[ {GOK{x ]", victim);

        if (!IS_NPC(ch))
            chance += get_curr_stat(victim, STAT_LCK) - get_curr_stat(ch, STAT_LCK);
        else
            chance += get_curr_stat(victim, STAT_LCK);
        char_act("Loading luck bonus............[ {GOK{x ]", victim);

        if (IS_RAFFECTED(victim->in_room, RAFF_PREVENT))
        {
            char_act("Prevent found.................[{YEXIT{x]", victim);
            chance = 0;
            check_improve (victim, gsn_take_revenge, FALSE, 1);
        }
        if (IS_SET(victim->in_room->room_flags, ROOM_BATTLE_ARENA))
        {
            char_act("Battle arena found............[{YEXIT{x]", victim);
            chance = 0;
            check_improve (victim, gsn_take_revenge, FALSE, 1);
        }

        if (chance >= number_percent())
        {
            while (victim->affected)
                affect_remove(victim, victim->affected);

            if (ch && IS_NPC(ch))
                remove_mind(ch, victim->name);

            stop_fighting(victim, TRUE);

            RESET_FIGHT_TIME(ch);

            victim->last_death_time = current_time;

            char_act("Loading char stats............[ {GOK{x ]", victim);

            victim->hit     = (victim->max_hit) / 10;
            victim->mana    = (victim->max_mana) / 10;
            victim->move    = (victim->max_move) / 10;
            char_act("Creating life form ( 1/10)....[ {GOK{x ]", victim);

            if (number_percent() < (get_curr_stat(victim, STAT_LCK) * 2) + 60)
            {
                victim->hit     += (victim->max_hit) / 10;
                victim->mana    += (victim->max_mana) / 10;
                victim->move    += (victim->max_move) / 10;
                char_act("Creating life form ( 2/10)....[ {GOK{x ]", victim);
            } else
            {
                char_act("Creating life form ( 2/10)....[{RFAIL{x]", victim);
            }
            if (number_percent() < (get_curr_stat(victim, STAT_LCK) * 2) + 50)
            {
                victim->hit     += (victim->max_hit) / 10;
                victim->mana    += (victim->max_mana) / 10;
                victim->move    += (victim->max_move) / 10;
                char_act("Creating life form ( 3/10)....[ {GOK{x ]", victim);
            } else
            {
                char_act("Creating life form ( 3/10)....[{RFAIL{x]", victim);
            }
            if (number_percent() < (get_curr_stat(victim, STAT_LCK) * 2) + 40)
            {
                victim->hit     += (victim->max_hit) / 10;
                victim->mana    += (victim->max_mana) / 10;
                victim->move    += (victim->max_move) / 10;
                char_act("Creating life form ( 4/10)....[ {GOK{x ]", victim);
            } else
            {
                char_act("Creating life form ( 4/10)....[{RFAIL{x]", victim);
            }
            if (number_percent() < (get_curr_stat(victim, STAT_LCK) * 2) + 30)
            {
                victim->hit     += (victim->max_hit) / 10;
                victim->mana    += (victim->max_mana) / 10;
                victim->move    += (victim->max_move) / 10;
                char_act("Creating life form ( 5/10)....[ {GOK{x ]", victim);
            } else
            {
                char_act("Creating life form ( 5/10)....[{RFAIL{x]", victim);
            }
            if (number_percent() < (get_curr_stat(victim, STAT_LCK) * 2) + 20)
            {
                victim->hit     += (victim->max_hit) / 10;
                victim->mana    += (victim->max_mana) / 10;
                victim->move    += (victim->max_move) / 10;
                char_act("Creating life form ( 6/10)....[ {GOK{x ]", victim);
            } else
            {
                char_act("Creating life form ( 6/10)....[{RFAIL{x]", victim);
            }
            if (number_percent() < (get_curr_stat(victim, STAT_LCK) * 2) + 10)
            {
                victim->hit     += (victim->max_hit) / 10;
                victim->mana    += (victim->max_mana) / 10;
                victim->move    += (victim->max_move) / 10;
                char_act("Creating life form ( 7/10)....[ {GOK{x ]", victim);
            } else
            {
                char_act("Creating life form ( 7/10)....[{RFAIL{x]", victim);
            }
            if (number_percent() < (get_curr_stat(victim, STAT_LCK) * 2) - 0)
            {
                victim->hit     += (victim->max_hit) / 10;
                victim->mana    += (victim->max_mana) / 10;
                victim->move    += (victim->max_move) / 10;
                char_act("Creating life form ( 8/10)....[ {GOK{x ]", victim);
            } else
            {
                char_act("Creating life form ( 8/10)....[{RFAIL{x]", victim);
            }
            if (number_percent() < (get_curr_stat(victim, STAT_LCK) * 2) - 10)
            {
                victim->hit     += (victim->max_hit) / 10;
                victim->mana    += (victim->max_mana) / 10;
                victim->move    += (victim->max_move) / 10;
                char_act("Creating life form ( 9/10)....[ {GOK{x ]", victim);
            } else
            {
                char_act("Creating life form ( 9/10)....[{RFAIL{x]", victim);
            }
            if (number_percent() < (get_curr_stat(victim, STAT_LCK) * 2) - 20)
            {
                victim->hit     += (victim->max_hit) / 10;
                victim->mana    += (victim->max_mana) / 10;
                victim->move    += (victim->max_move) / 10;
                char_act("Creating life form (10/10)....[ {GOK{x ]", victim);
            } else
            {
                char_act("Creating life form (10/10)....[{RFAIL{x]", victim);
            }

            victim->position = POS_STANDING;
            check_improve (victim, gsn_take_revenge, TRUE, 1);

            return;
        } else
        {
            check_improve (victim, gsn_take_revenge, FALSE, 1);
            char_act("Loading char stats............[{RFAIL{x]", victim);
        }
    }*/

    for (gch = ch->in_room->people; gch; gch = gch->next_in_room)
    {
        if (is_same_group(gch, ch))
        {
            if (!IS_NPC(gch) && gch->pcdata && gch->pcdata->explored_areas && gch->in_room &&
                gch->level > 5 && !IS_SET(gch->in_room->room_flags, ROOM_BATTLE_ARENA) &&
                gch->in_room && gch->in_room->area && !gch->in_room->area->clan)
            {
                area_found = FALSE;
                for (curr_expl_area = gch->pcdata->explored_areas ; curr_expl_area ; curr_expl_area=curr_expl_area->next)
                    if (!str_cmp (gch->in_room->area->name, curr_expl_area->name))
                    {
                        area_found = TRUE;
                        break;
                    }
                if (!area_found)
                {
                    curr_expl_area = new_char_explored_data () ;
                    curr_expl_area->name = str_dup (gch->in_room->area->name) ;
                    curr_expl_area->explored_room_count    = 0 ;
                    if (gch->pcdata->explored_areas)
                        curr_expl_area->next = gch->pcdata->explored_areas ;
                    gch->pcdata->explored_areas = curr_expl_area ;
                }
                if (IS_EVIL(victim))
                {
                    curr_expl_area->attitude_evil    -= 4;
                    curr_expl_area->attitude_good    += 2;
                    if (number_percent() > 50)
                        curr_expl_area->attitude_neutral += 1;
                    else
                        curr_expl_area->attitude_neutral -= 1;
                }
                else if (IS_GOOD(victim))
                {
                    curr_expl_area->attitude_evil    += 2;
                    curr_expl_area->attitude_good    -= 4;
                    curr_expl_area->attitude_neutral += 1 ;
                }
                else if (IS_NEUTRAL(victim))
                {
                    curr_expl_area->attitude_evil    -= 2;
                    if (number_percent() > 50)
                        curr_expl_area->attitude_evil += 1;
                    else
                        curr_expl_area->attitude_evil -= 1;
                    curr_expl_area->attitude_good    -= 2;
                    if (number_percent() > 50)
                        curr_expl_area->attitude_good += 1;
                    else
                        curr_expl_area->attitude_good -= 1;
                    curr_expl_area->attitude_neutral -= 4;
                }
                if (IS_IMMORTAL(gch))
                {
                    char_printf(gch, "New attitude for area %s: good = %d, neutral = %d, evil = %d\n",
                        gch->in_room->area->name, curr_expl_area->attitude_good, curr_expl_area->attitude_neutral, curr_expl_area->attitude_evil);
                }
            }
            // alignment changes
            // Welesh : commented out
            /*if (! (IS_NPC (gch) || (gch->in_war && gch->war_status == PS_ALIVE)
                   || IS_SET(gch->in_room->room_flags, ROOM_BATTLE_ARENA)))
            {
                int old_align = RALIGN(gch), new_align;

                // we change char's alignment
                if (IS_GOOD (victim) || (IS_NEUTRAL (victim) && (number_percent() > 50)))
                    gch->alignment -= 1;
                if (IS_EVIL (victim))
                    gch->alignment += 1;

                new_align = RALIGN(gch);
                if (new_align != old_align)
                    new_align_msg (gch, old_align, new_align);
            }*/
        }
    }

    if (!is_duel && !IS_NPC (victim))
    {
        if (IS_SAMURAI(victim))
        {
            if (is_affected(victim, gsn_dishonor))
                ++victim->pcdata->death;
        }
        else
            ++victim->pcdata->death;
    }

    raw_kill(ch, victim);

    /* RT new auto commands */
    if (!IS_NPC(ch) && vnpc
    && (corpse = get_obj_list(ch, "corpse", ch->in_room->contents)))
    {
        if (HAS_SKILL(ch, gsn_vampire))
        {
            act_puts("$n suck {Rblood{z from $N's corpse!!", ch, NULL, victim, TO_ROOM, POS_SLEEPING);
            char_act("You suck {Rblood{z from the corpse!!", ch);
            gain_condition(ch, COND_BLOODLUST, 3);
        } else if (IS_UNDEAD(ch))
        {
            act_puts("$n look much better, after kill!", ch, NULL, victim, TO_ROOM, POS_SLEEPING);
            char_act("You look much better now!!", ch);
            ch->hit  += corpse->level;
            ch->hit  =  UMIN(ch->hit,ch->max_hit);
            ch->mana += corpse->level * 2;
            ch->mana =  UMIN(ch->mana,ch->max_mana);
            ch->move += corpse->level / 2;
            ch->move =  UMIN(ch->move,ch->max_move);
        }

        if (IS_SET(ch->plr_flags, PLR_AUTOLOOK))
            do_look_in(ch, "corpse");
        if (corpse->contains)
        {
            /* corpse exists and not empty */
            if (IS_SET(ch->plr_flags, PLR_AUTOLOOT))
                do_get(ch, "all corpse");
            else if (IS_SET(ch->plr_flags, PLR_AUTOGOLD))
                get_gold_corpse(ch, corpse);
        }

        if (IS_SET(ch->plr_flags, PLR_AUTOSAC))
            do_sacrifice(ch, "corpse");
    }

    if (vnpc || victim->position == POS_STANDING)
        return;

    if (is_duel
    && !IS_SAMURAI(victim)
    && ((victim->pcdata != NULL) && !IS_NEWBIE(victim)))
    {
        if (victim->pcdata)
        {
            if (victim->pcdata->questpoints >= 10)
            {
                victim->pcdata->questpoints -= 10;
                char_act("The cost of this death for you is {Y10{y qp{x.", victim);
            } else
            {
                is_duel = FALSE;
                char_act("You've just died.", victim);
            }

        }
    }

    if (IS_NEWBIE(victim))
    {
        if (!is_duel)
            if ((victim->pcdata->death > 0) && ((victim->pcdata->death % 5) == 0))
            {
                --victim->perm_stat[STAT_CON];
                char_act("You feel your life power has decreased after 5th death.(HELP CONDEATH)", victim);
            }
    } else
    {
        if (IS_NPC(ch)
        && !IS_AFFECTED(victim, AFF_CHARM)
        && !IS_AFFECTED(ch, AFF_CHARM)
        && number_percent() > get_curr_stat(victim, STAT_LCK)
        && victim->level > 9)
        {
            switch (number_range(0,3))
            {
            case 0:
                penalty = "Strength";
                if (--victim->perm_stat[STAT_STR] < 3)
                    victim->perm_stat[STAT_STR] = 3;
                break;
            case 1:
                penalty = "Intelligence";
                if (--victim->perm_stat[STAT_INT] < 3)
                    victim->perm_stat[STAT_INT] = 3;
                break;
            case 2:
                penalty = "Wisdom";
                if (--victim->perm_stat[STAT_WIS] < 3)
                    victim->perm_stat[STAT_WIS] = 3;
                break;
            case 3:
                penalty = "Dexterity";
                if (--victim->perm_stat[STAT_DEX] < 3)
                    victim->perm_stat[STAT_DEX] = 3;
                break;
            }
            act_puts("You lose one point of {W$t{z.", victim, penalty, NULL, TO_CHAR | ACT_TRANS, POS_DEAD);
        } else
        {
            if (!is_duel && ((victim->pcdata->death > 0) && ((victim->pcdata->death % 3) == 0)) && victim->level > 9)
            {
                if (!IS_SAMURAI(victim))
                {
                    --victim->perm_stat[STAT_CON];
                    char_act("You feel your life power has decreased with this death. ({CHELP CONDEATH{x)", victim);
                }
            }
        }
    }

    if ((victim->perm_stat[STAT_CON] < 10) && (victim->pcdata != NULL))
    {
        delete_player(victim, "CON-death");
        return;
    }

    /* Dying penalty: 2/3 way back. */
    if (IS_SET(victim->plr_flags, PLR_WANTED) && victim->level > 1)
    {
        REMOVE_BIT(victim->plr_flags, PLR_WANTED);
        victim->level--;
        victim->pcdata->plevels++;
        victim->exp = exp_for_level(victim, victim->level);
        victim->exp_tl = 0;

        ++stat_record.criminals_killed;

    } else if (!is_duel)
    {
        if (victim->exp_tl > 0)
            gain_exp(victim, -victim->exp_tl*2/3);
    } else
    {
        if (victim->exp_tl > 0)
            gain_exp(victim, -victim->exp_tl/15);
    }

    /* Die too much and is deleted ... :( */

    if (IS_SAMURAI(victim))
    {
        if (victim->pcdata->death >= 25)
        {
            delete_player(victim, "25 deaths limit for Samurai");
            return;
        }
    }
}

bool cant_kill(CHAR_DATA *ch, CHAR_DATA *victim)
{
    int clan;
    /*
     * ghosts are safe
     * this check must be done first to avoid
     * suicyco muttafuckas who recite 'leather-bound book' (#5743)
     * without any target specified
     * extracted NPCs are safe too
     */

    char msg[MAX_INPUT_LENGTH];
    int i;

    if (!victim)
        return TRUE;

    // before all
    if (!IS_NPC(ch) && !IS_NPC(victim) && ch->in_war && (ch->in_war == victim->in_war)
    && !IS_SET (ch->in_war->flags, WS_PREPARING | WS_SET_PARMS)
    && (ch->war_status == PS_ALIVE) && (victim->war_status == PS_ALIVE))
        return FALSE;

    // area_guards can't be attacked by non-clan players
    for (i = 0; i < MAX_GUARD_COUNT; ++i)
    {
        if (victim->in_room && victim->in_room->area && (victim == victim->in_room->area->areaguards[i]))
        {
            if  (!ch->clan)
                return TRUE;
            else
            {
                if ((ch->clan != victim->clan) && (ch->fighting != victim))
                {
                    sprintf (msg, "{RAttention! Area %s {Ris attacked by %s{x!!!",
                        victim->in_room->area->name, ch->name);
                    do_clan (victim, msg);
                }
                return FALSE;
            }
        }
    }

    for (i = 0; i < MAX_ALTAR_COUNT; ++i)
    {
        if (victim->in_room && victim->in_room->area && (victim == victim->in_room->area->priests[i]))
        {
            if  ((!ch->clan) || victim->in_room->area->guards_left)
                return TRUE;
            else
            {
                if ((ch->clan != victim->clan) && (ch->fighting != victim))
                {
                    sprintf (msg, "Help! %s tries to demolish an altar in te area %s{x!!!",
                        ch->name, victim->in_room->area->name);
                    do_clan (victim, msg);
                }
                return FALSE;
            }
        }
    }

    if (!IS_NPC(victim))
    {
        if (IS_SET(victim->plr_flags, PLR_GHOST))
            return TRUE;
        if (ch != victim
        && !IS_NPC(ch)
        && IS_SET(ch->plr_flags, PLR_GHOST))
            return TRUE;
    } else if (victim->extracted)
        return TRUE;

    // GM : Ally can kill in ally clan_area
    if (ch != victim
    && !IS_NPC(victim)
    && (clan = victim->in_room->area->clan)
    && victim->clan != clan
    && (ch->clan == clan
    || CLAN(ch->clan)->diplomacy[clan] == DIP_ALLY))
        return FALSE;

    if (victim->fighting == ch
    || ch == victim
    || IS_IMMORTAL(ch))
        return FALSE;

    /* handle ROOM_PEACE flags */
    if ((victim->in_room
    && IS_SET(victim->in_room->room_flags, ROOM_PEACE))
    || (ch->in_room
    && IS_SET(ch->in_room->room_flags, ROOM_PEACE)))
        return TRUE;

    if ((victim->in_room && IS_SET(victim->in_room->room_flags, ROOM_FULL_PK))
    && (ch->in_room && IS_SET(ch->in_room->room_flags, ROOM_FULL_PK)))
        return FALSE;

    /* link dead players whose adrenalin is not gushing are safe */
    if (!IS_NPC(victim) && !IS_PUMPED(victim) && victim->desc == NULL)
        return TRUE;

    return !in_PK(ch, victim);
}

bool is_safe_nomessage(CHAR_DATA *ch, CHAR_DATA *victim)
{
    bool safe;
    CHAR_DATA *mount;

    if (IS_NPC(victim)
    &&  IS_SET(victim->affected_by, AFF_CHARM)
    &&  victim->master)
        return is_safe_nomessage(ch, victim->master);

    if (IS_NPC(ch)
    &&  IS_SET(ch->affected_by, AFF_CHARM)
    &&  ch->master)
        return is_safe_nomessage(ch->master, victim);

    if ((mount = RIDDEN(victim)))
        return is_safe_nomessage(ch, mount);

    if ((safe = cant_kill(ch, victim)))
        return safe;

    if (victim != ch && IS_SET(ch->plr_flags, PLR_GHOST))
    {
        char_act("You return to your normal form.", ch);
        REMOVE_BIT(ch->plr_flags, PLR_GHOST);
    }

    return safe;
}

bool is_safe(CHAR_DATA *ch, CHAR_DATA *victim)
{
    if (is_safe_nomessage(ch, victim))
    {
        act("The gods protect $N.", ch, NULL, victim, TO_CHAR);
        act("The gods protect $N from $n.", ch, NULL, victim, TO_ROOM);
        return TRUE;
    }
    return FALSE;
}

bool is_safe_spell(CHAR_DATA *ch, CHAR_DATA *victim, bool area)
{
#if 0
    if (ch == victim && !area)
        return TRUE;
#endif
    if (area)
    {
        if (IS_IMMORTAL(victim)
        || is_same_group(ch, victim)
        || (RIDDEN(victim) && is_same_group(ch, victim->mount))
        || ch == victim
        || RIDDEN(ch) == victim
        || MOUNTED(ch) == victim)
            return TRUE;
    }

    return is_safe(ch, victim);
}

/*
 * Check for parry.
 */
bool check_parry(CHAR_DATA *ch, CHAR_DATA *victim, int loc)
{
    int chance;//, wchance, schance; // removed automated shield and weapon cleave
    OBJ_DATA *wield, *wield2; //, *cobj;

    if (!IS_AWAKE(victim))
        return FALSE;

    wield = get_eq_char(victim, WEAR_WIELD);
    wield2 = get_eq_char(victim, WEAR_SECOND_WIELD);

    if (IS_NPC(victim))
        chance  = UMIN(35, LVL(victim));
    else
    {
        if (wield == NULL)
            return FALSE;
        chance = get_skill(victim, gsn_parry) / 2;
        if (wield && wield2 && wield->value[0] == WEAPON_SWORD
        && wield2->value[0] == WEAPON_SWORD)
            chance += get_skill(victim, gsn_flourentine) / 4;

        if (wield && wield->value[0] == WEAPON_SWORD)
            chance += get_skill(victim, gsn_mastering_sword) / 6;

        if (victim->stance != STANCE_NORMAL)
        {
            if (number_percent() < get_skill(victim,gsn_stance))
            {
                if (victim->stance == STANCE_DEFENSE)
                    chance += 10;
                else if (victim->stance == STANCE_DEFENSE_II)
                    chance += 20;
                else if (victim->stance == STANCE_OFFENSE)
                    chance  -= 10;
                else
                    chance -= 20;
            }
            else
                check_improve(victim, gsn_stance, FALSE, 4);
        }
    }

    if (IS_AFFECTED(victim, AFF_BLIND))
    {
        chance -= chance / 3;
        chance += chance * get_skill(victim, gsn_blind_fighting) / 300;
    }

    if (IS_AFFECTED(ch, AFF_HASTE))     chance -= 5;
    if (IS_AFFECTED(ch, AFF_SLOW))      chance += 10;
    if (IS_AFFECTED(victim, AFF_HASTE)) chance += 5;
    if (IS_AFFECTED(victim, AFF_SLOW))  chance -= 5;

    if (is_affected(victim, gsn_bash))  chance = chance * 2 / 3;
    if (is_affected(victim, gsn_throw)) chance = chance * 3 / 4;
    if (is_affected(victim, gsn_trip))  chance = chance * 4 / 5;

    if (check_forest_fighting(victim) == FOREST_DEFENCE
    && (number_percent() < get_skill(victim, gsn_forest_fighting)))
    {
        chance = chance * 120 / 100;
        check_improve (victim, gsn_forest_fighting, TRUE, 7);
    }

    if (number_percent() < get_skill(victim, gsn_mount_control)
    && MOUNTED(victim))
    {
        chance = chance * 120 / 100;
        check_improve (victim, gsn_mount_control, TRUE, 7);
    }

    if (number_percent() < get_skill(victim, gsn_mount_fighting)
    && MOUNTED(victim))
    {
        chance = chance * 140 / 100;
        check_improve (victim, gsn_mount_fighting, TRUE, 7);
    }

    if (number_percent() < get_skill(victim, gsn_thumbling))
    {
        chance = chance * 130 / 100;
        check_improve (victim, gsn_thumbling, TRUE, 7);
    }

    if (is_affected(victim, sn_lookup("combat mind")))
        chance = chance * 13/10;

    if (is_affected(ch, sn_lookup("combat mind")))
        chance = chance * 10/13;

    // ADV FURY
    if (is_affected(ch, gsn_adv_fury))
    {
        chance /= 10;
        check_improve(ch, gsn_adv_fury, TRUE, 6);
    }

    chance += LVL(victim) - LVL(ch);
    chance = URANGE(10, chance, 80);

    if (number_percent() >= chance)
        return FALSE;

    act("You parry $n's attack.", ch, NULL, victim, TO_VICT | ACT_VERBOSE);
    act("$N parries your attack.", ch, NULL, victim, TO_CHAR | ACT_VERBOSE);


/*    // GM : weapon and shield cleave
    wchance = get_skill(victim, gsn_weapon_cleave) / 10;

    if (HAS_SKILL(victim, gsn_weapon_cleave)
    && (cobj = get_eq_char(ch, WEAR_WIELD)) != NULL)
    {
        wchance += get_curr_stat(victim, STAT_DEX) + get_curr_stat(victim, STAT_STR);
        wchance -= get_curr_stat(ch, STAT_STR) + get_curr_stat(ch, STAT_DEX);
        wchance += LVL(victim) - LVL(ch);
        wchance += cobj->level - wield->level;

        if (IS_NPC(ch))
        {
            if (IS_AFFECTED(ch, AFF_CHARM))
                wchance += 15;
            else
                wchance += 10;
        }

        if (IS_OBJ_STAT(cobj, ITEM_HIDURABILITY))
            wchance /= 10;

        if (cobj->pIndexData->limit != -1
        || IS_OBJ_STAT(cobj, ITEM_INDESTRUCTABLE)
        || IS_SET(cobj->pIndexData->extra_flags, ITEM_QUEST))
            wchance = 0;

        if (wield)
        {
            if (wield->value[0] != WEAPON_AXE)
                wchance /= 2;
            if (wield->value[0] != WEAPON_SWORD
            && wield->value[0] != WEAPON_AXE)
                wchance = 0;
        }

        if (ch->in_war && ch->war_status == PS_ALIVE)
            wchance = 0;

        if (number_percent() < wchance)
        {
            act("   $N   .", victim, NULL, ch, TO_CHAR);
            act("$n      .", victim, NULL, ch, TO_VICT);
            act("$n   $N   .", victim, NULL, ch, TO_NOTVICT);
            check_improve(victim, gsn_weapon_cleave, TRUE, 1);
            extract_obj(get_eq_char(ch, WEAR_WIELD));
        } else
        {
            check_improve(victim, gsn_weapon_cleave, FALSE, 1);
        }
    }

    schance = get_skill(victim, gsn_shield_cleave) / 10;

    if (HAS_SKILL(victim, gsn_shield_cleave)
    && (cobj = get_eq_char(ch, WEAR_SHIELD)) != NULL)
    {
        schance += get_curr_stat(victim, STAT_DEX) + get_curr_stat(victim, STAT_STR);
        schance -= get_curr_stat(ch, STAT_STR) + get_curr_stat(ch, STAT_DEX);
        schance += LVL(victim) - LVL(ch);
        schance += cobj->level - wield->level;

        if (IS_NPC(ch))
        {
            if (IS_AFFECTED(ch, AFF_CHARM))
                schance += 15;
            else
                schance += 10;
        }

        if (IS_OBJ_STAT(cobj, ITEM_HIDURABILITY))
            schance /= 10;

        if (cobj->pIndexData->limit != -1
        || IS_OBJ_STAT(cobj, ITEM_INDESTRUCTABLE)
        || check_material(cobj, "titanium")
        || IS_SET(cobj->pIndexData->extra_flags, ITEM_QUEST))
            schance = 0;

        if (wield)
        {
            if (wield->value[0] != WEAPON_AXE)
                schance /= 2;
            if (wield->value[0] != WEAPON_SWORD
            && wield->value[0] != WEAPON_AXE)
                schance = 0;
        }

        if (ch->in_war && ch->war_status == PS_ALIVE)
            schance = 0;

        if (number_percent() < schance)
        {
            act("   $N.", victim, NULL, ch, TO_CHAR);
            act("$n   .",victim, NULL, ch, TO_VICT);
            act("$n   $N.", victim, NULL, ch, TO_NOTVICT);
            check_improve(victim, gsn_shield_cleave, TRUE, 1);
            extract_obj(get_eq_char(ch, WEAR_SHIELD));
        } else
        {
            check_improve(victim, gsn_shield_cleave, FALSE, 1);
        }
    }*/

    check_weapon_damage(ch, victim, loc);

    if (number_percent() >  get_skill(victim, gsn_parry))
    {
        //     ..  
        /* size */
        if (ch->size < victim->size)
            chance += (ch->size - victim->size) * 3;
        else
            chance += (ch->size - victim->size) * 7 / 5;

        /* stats */
        chance += get_curr_stat(ch, STAT_STR);
        chance -= get_curr_stat(victim, STAT_DEX) * 4/3;

        if (IS_AFFECTED(ch, AFF_FLYING))
            chance -= 10;

        /* speed */
        if (IS_NPC(ch) && IS_SET(ch->pIndexData->off_flags, OFF_FAST))
            chance += 10;
        if (IS_NPC(victim) && IS_SET(victim->pIndexData->off_flags, OFF_FAST))
            chance -= 20;

        /* level */
        chance += (LVL(victim) - LVL(ch)) * 2;

        /* now the attack */
        if (number_percent() < (chance / 20 ))
        {
            act("You couldn't manage to keep your position!", ch, NULL, victim, TO_VICT | ACT_VERBOSE);
            act("You fall down!", ch, NULL, victim, TO_VICT | ACT_VERBOSE);
            act("$N couldn't manage to hold your attack and falls down!", ch, NULL, victim, TO_CHAR | ACT_VERBOSE);
            act("$n stunning force makes $N falling down.", ch, NULL, victim, TO_NOTVICT | ACT_VERBOSE);

            DAZE_STATE(victim, PULSE_VIOLENCE * number_range(1, 3));
            victim->position = POS_RESTING;
        }
    }

    check_improve(victim, gsn_parry, TRUE, 6);
    if (!IS_NPC(victim) && wield != NULL && wield2 != NULL
    && wield->value[0] == WEAPON_SWORD
    && wield2->value[0] == WEAPON_SWORD)
        check_improve(victim, gsn_flourentine, TRUE, 6);
    return TRUE;
}

bool check_shield(CHAR_DATA *ch, CHAR_DATA *victim)
{

    if (!is_affected(victim, gsn_shield)
    || get_eq_char(victim, WEAR_SHIELD) != NULL)
        return FALSE;

    if (number_percent() > 5 + affect_level(victim, gsn_shield)/8 -
        (LVL(ch) - LVL(victim))/3)
        return FALSE;

    act("      $c1{$n}.",  ch, NULL, victim, TO_VICT | ACT_VERBOSE);
    act("   $c4{$N}   .", ch, NULL, victim, TO_CHAR | ACT_VERBOSE);
    return TRUE;
}

bool check_towershield(CHAR_DATA *ch, CHAR_DATA *victim)
{
    int chance;
    int sn = sn_lookup("tower shield");

    if (!check_tattoo (ch, sn)
        || get_eq_char(victim, WEAR_SHIELD) != NULL)
        return FALSE;

    chance = get_skill (ch, sn)/10 -  (LVL(ch) - LVL(victim))/3;
    chance = URANGE(5, chance, 10);

    if (number_percent() > chance)
        return FALSE;

    act("      $c1{$n}.",  ch, NULL, victim, TO_VICT | ACT_VERBOSE);
    act("   $c4{$N}   .", ch, NULL, victim, TO_CHAR | ACT_VERBOSE);
    return TRUE;
}

/*
 * check blink
 */
bool check_blink(CHAR_DATA *ch, CHAR_DATA *victim)
{
    int chance;

    if (!IS_NPC (victim) && !IS_SET(victim->plr_flags, PLR_BLINK))
        return FALSE;

    if (IS_NPC(victim))
    {
        if (IS_SET (victim->abilities, EA_BLINK))
            chance = 25;
        else
            return FALSE;
    }
    else
        chance = get_skill(victim, gsn_blink) / 2;

    if (is_affected(victim, gsn_bash)) chance = chance * 2 / 3;
    if (is_affected(victim, gsn_throw)) chance = chance * 3 / 4;
    if (is_affected(victim, gsn_trip)) chance = chance * 4 / 5;

    if (chance != 0)
        chance += LVL(victim) - LVL(ch);
    chance += get_skill(victim, gsn_blur) / 3;
    check_improve(victim, gsn_blur, TRUE, 1);

    if (number_percent() >= chance
    || victim->mana < 10)
        return FALSE;
    if (check_perception(ch, victim))
        return FALSE;

    victim->mana -= UMAX(LVL(victim) / 10, 1);

    act("You blink out $n's attack.", ch, NULL, victim, TO_VICT);
    act("$N blinks out your attack.", ch, NULL, victim, TO_CHAR);

    check_improve(victim, gsn_blink, TRUE, 4);
    return TRUE;
}

/*
 * Check for shield block.
 */
bool check_block(CHAR_DATA *ch, CHAR_DATA *victim, int loc)
{
    int chance;

    if (!IS_AWAKE(victim))
        return FALSE;

    if (get_eq_char(victim, WEAR_SHIELD) == NULL)
        return FALSE;

    if (IS_NPC(victim))
        chance = 10;
    else
    {
        if (get_skill(victim,gsn_shield_block) <= 1)
            return FALSE;
        chance = get_skill(victim,gsn_shield_block) / 2;
        chance -= (victim->class == CLASS_WARRIOR) ? 0 : 10;
    }

    if (IS_AFFECTED(victim, AFF_BLIND))
    {
        chance -= chance / 3;
        chance += chance * get_skill(victim, gsn_blind_fighting) / 300;
    }

    if (IS_AFFECTED(ch, AFF_HASTE))       chance -= 5;
    if (IS_AFFECTED(ch, AFF_SLOW))        chance += 5;
    if (IS_AFFECTED(victim, AFF_HASTE))   chance += 5;
    if (IS_AFFECTED(victim, AFF_SLOW))    chance -= 5;

    if (is_affected(victim, gsn_bash)) chance = chance * 2 / 3;
    if (is_affected(victim, gsn_throw)) chance = chance * 3 / 4;
    if (is_affected(victim, gsn_trip)) chance = chance * 4 / 5;

    if (check_forest_fighting(victim) == FOREST_DEFENCE
    && (number_percent() < get_skill(victim, gsn_forest_fighting)))
    {
        chance = chance * 6/5;
        check_improve (victim, gsn_forest_fighting, TRUE, 7);
    }

    if (MOUNTED(victim))
        chance = chance * 6/5;

    if (number_percent() < get_skill(victim, gsn_mount_control)
        && MOUNTED(victim))
    {
        chance = chance * 120 / 100;
        check_improve (victim, gsn_mount_control, TRUE, 7);
    }

    if (number_percent() < get_skill(victim, gsn_mount_fighting)
        && MOUNTED(victim))
    {
        chance = chance * 140 / 100;
        check_improve (victim, gsn_mount_fighting, TRUE, 7);
    }

    if (is_affected(victim, sn_lookup("combat mind")))
    chance = chance * 6/5;

    if (is_affected(victim, sn_lookup("combat mind")))
    chance = chance * 5/6;

    chance = URANGE(5, chance, 80);

    if (number_percent() >= chance + LVL(victim) - LVL(ch))
        return FALSE;

    act("Your shield blocks $n's attack.", ch, NULL, victim, TO_VICT);
    act("$N deflects your attack with $gN{his} shield.", ch, NULL, victim, TO_CHAR);
    check_shield_damage(ch, victim, loc);
    check_improve(victim, gsn_shield_block, TRUE, 6);
    return TRUE;
}

/* check for stand off skill */
bool check_stand_off(CHAR_DATA *ch, CHAR_DATA *victim)
{
    int chance;
    OBJ_DATA *obj1;

    obj1 = get_eq_char(victim, WEAR_WIELD);

    if (!IS_AWAKE(victim))
        return FALSE;

    if (IS_NPC(victim))
        return FALSE;


    if (!obj1)
        return FALSE;


    if ((obj1->value[0] != WEAPON_SPEAR) &&
        (obj1->value[0] != WEAPON_POLEARM) &&
        (obj1->value[0] != WEAPON_LANCE))
        return FALSE;

    chance = get_skill(victim, gsn_stand_off) / 2;

    if (chance == 0)
        return FALSE;

    /* chance for high dex // not only victim's.. *grin* :E*/
    chance += 4 * (get_curr_stat(victim,STAT_DEX)
                   - get_curr_stat(victim,STAT_DEX));

    if (victim->stance != STANCE_NORMAL)
    {
        if (number_percent() < get_skill(victim,gsn_stance))
        {
            check_improve(victim,gsn_stance,TRUE,6);
            if (victim->stance == STANCE_DEFENSE)
                chance += 10;
            else if (victim->stance == STANCE_DEFENSE_II)
                chance  += 20;
            else if (victim->stance == STANCE_OFFENSE)
                chance = -10;
            else if (victim->stance == STANCE_OFFENSE_II)
                chance = -20;
        }
    }

    if (MOUNTED(victim))
    {
        chance += 5;
        // it's harder to parry small character when mounted
        // so as it's easier to parry bigger
        chance += (ch->size - victim->size) * 5;

        if (number_percent() < get_skill(victim, gsn_mount_control))
        {
            chance += 5;
            check_improve (victim, gsn_mount_control, TRUE, 6);
        }

        if (number_percent() < get_skill(victim, gsn_mount_fighting))
        {
            chance += 10;
            check_improve (victim, gsn_mount_fighting, TRUE, 6);
        }
    }
    else
    {
        // and it just a lil'bit easier to parry when not mounted
        chance += (ch->size - victim->size) * 2;
    }

    if (IS_AFFECTED(ch,AFF_HASTE))       chance -= 5;
    if (IS_AFFECTED(ch,AFF_SLOW))        chance += 10;
    if (IS_AFFECTED(victim,AFF_HASTE))   chance += 5;
    if (IS_AFFECTED(victim,AFF_SLOW))    chance -= 5;

    chance = URANGE(5, chance, 80);

    if (number_percent() >= chance + (LVL(victim) - LVL(ch)) / 2)
    {
        check_improve(victim, gsn_stand_off, FALSE, 4);
        return FALSE;
    }

    act("    $n  .", ch, NULL,
        victim, TO_VICT);
    act("  $N    ", ch, NULL, victim,
        TO_CHAR);

    check_improve(victim, gsn_stand_off, TRUE, 6);
    return TRUE;

}

/*
 * Check for dodge.
 */
bool check_dodge(CHAR_DATA *ch, CHAR_DATA *victim)
{
    int chance, val;
    race_t *r;
    class_t *cl;

    if (!IS_AWAKE(victim))
        return FALSE;

    if (MOUNTED(victim))
        return FALSE;

    if (IS_NPC(victim))
        chance  = UMIN(30, LVL(victim));
    else
    {
        chance  = get_skill(victim, gsn_dodge) / 2;

        // GM : Σ -   .
        // GM :     20.  .

        if ((cl = class_lookup(victim->class)) != NULL)
        {
            if (cl->dodge)
                chance += cl->dodge / 2;
        }

//        r = RACE(ORG_RACE(victim));
        r = RACE(victim->race);

        if (r->dodge)
            chance += r->dodge / 2;

        /* chance for high dex. */
        chance += 2 * (get_curr_stat(victim, STAT_DEX) - 20);
        chance += 2 * (ch->size - victim->size);

        if (victim->class == CLASS_THIEF || victim->class == CLASS_NINJA)
            chance = chance * 11 / 10;

        if (IS_SET(victim->form, FORM_VAMPIRE))
            chance = get_skill(victim, gsn_dodge) * 3 / 5;
        else if (IS_SET(ch->form, FORM_VAMPIRE))
            chance = chance * 3 / 5;
        if (is_affected(victim, sn_lookup("mind focusing")))
            chance += 5;

        if (victim->stance != STANCE_NORMAL)
        {
            if (number_percent() < get_skill(victim, gsn_stance))
            {
                check_improve(victim, gsn_stance, TRUE, 6);
                if (victim->stance == STANCE_DEFENSE)
                    chance += 10;
                else if (victim->stance == STANCE_DEFENSE_II)
                    chance  += 20;
                else if (victim->stance == STANCE_OFFENSE)
                    chance = -10;
                else if (victim->stance == STANCE_OFFENSE_II)
                    chance = -20;
            }
        }
    }

    if (IS_AFFECTED(victim, AFF_BLIND))
    {
        chance -= chance/3;
        chance += chance * get_skill(victim, gsn_blind_fighting) / 300;
    }

    if (IS_AFFECTED(ch, AFF_HASTE))       chance -= 5;
    if (IS_AFFECTED(ch, AFF_SLOW))        chance += 10;
    if (IS_AFFECTED(victim, AFF_HASTE))   chance += 10;
    if (IS_AFFECTED(victim ,AFF_SLOW))    chance -= 15;

    if (is_affected(victim, gsn_bash))    chance = chance * 2 / 3;
    if (is_affected(victim, gsn_throw))   chance = chance * 3 / 4;
    if (is_affected(victim, gsn_trip))    chance = chance * 4 / 5;

    if (check_forest_fighting(victim) == FOREST_DEFENCE
    && (get_skill(victim, gsn_forest_fighting) > number_percent()))
    {
        chance = chance * 6/5;
        check_improve (victim, gsn_forest_fighting, TRUE, 7);
    }

    if (number_percent () < get_skill (victim, gsn_thumbling))
    {
        chance = chance * 13 / 10 ;
        check_improve (victim, gsn_thumbling, TRUE, 7);
    }

    if (number_percent () < get_skill (victim, gsn_awareness))
    {
        chance = chance * 12 / 10 ;
        check_improve (victim, gsn_awareness, TRUE, 7);
    }

    if (is_affected(victim, sn_lookup("combat mind")))
    {
        chance = chance * 11 / 10;
        if (is_affected(victim, sn_lookup("mind focusing")))
            chance = chance * 13 / 11;
    }

    if (is_affected(ch, sn_lookup("combat mind")))
    {
        chance = chance * 10 / 11;
        if (is_affected(ch, sn_lookup("mind focusing")))
            chance = chance * 11 / 13;
    }

    chance += (LVL(victim) - LVL(ch)) / 2;

    if ((val = get_skill(ch, gsn_perception)) > 0)
    {
        if (number_percent() > val / 4)
        {
            check_improve(ch, gsn_perception, TRUE, 4);
            if (number_percent() < val / 3)
                chance -= number_range(0, ch->level / 3);
            else
                chance -= number_range(0, ch->level / 4);
        }
        else
            check_improve(ch, gsn_perception, FALSE, 3);
    }

    if (!IS_NPC(ch) && ch->pcdata && ch->pcdata->security == 1)
        char_printf(ch, "ch dodge : chance = %d", chance);
    if (!IS_NPC(victim) && victim->pcdata && victim->pcdata->security == 1)
        char_printf(victim, "victim dodge : chance = %d", chance);

    if (!IS_NPC (victim))
    {
        if (!is_class_warrior(victim) && is_class_mage(victim))
            chance = URANGE(5, chance, 60);
        else if (is_class_warrior(victim) && is_class_mage(victim))
            chance = URANGE(5, chance, 70);
        else if (is_class_warrior(victim) && !is_class_mage(victim))
            chance = URANGE(5, chance, 80);
        else
            chance = URANGE(5, chance, 70);
    }
    else
        chance = URANGE(5, chance, 80);

    if (is_contacted(ch, victim))
        chance /= 10;

    if (number_percent() >= chance)
        return FALSE;

    act("You dodge $n's attack.", ch, NULL, victim, TO_VICT | ACT_VERBOSE);
    act("$N dodges your attack.", ch, NULL, victim, TO_CHAR | ACT_VERBOSE);
//    act("You dodge $n's attack.", ch, NULL, victim, TO_VICT);
//    act("$N dodges your attack.", ch, NULL, victim, TO_CHAR);

    if (number_percent() < get_skill(victim,gsn_dodge) / 20
    && !(IS_AFFECTED(ch, AFF_FLYING) || ch->position < POS_FIGHTING))
    {
        /* size */
        if (victim->size < ch->size)
            /* bigger = harder to trip */
            chance += (victim->size - ch->size) * 2;

        /* dex */
        chance += get_curr_stat(victim, STAT_DEX);
        chance -= get_curr_stat(ch, STAT_DEX) * 3 / 2;

        if (IS_AFFECTED(victim, AFF_FLYING))
            chance -= 10;

        /* speed */
        if ((IS_NPC(victim) && IS_SET(victim->pIndexData->off_flags, OFF_FAST))
        || IS_AFFECTED(victim, AFF_HASTE))
            chance += 10;
        if ((IS_NPC(ch) && IS_SET(ch->pIndexData->off_flags, OFF_FAST))
        || IS_AFFECTED(ch, AFF_HASTE))
            chance -= 20;

        /* level */
        chance += (LVL(victim) - LVL(ch)) * 2;

        /* now the attack */
        if (number_percent() < (chance / 20))
        {
            act("$n lost his postion and fall down!",  ch, NULL, victim, TO_VICT);
            act("As $N moves you lost your position fall down!", ch, NULL, victim, TO_CHAR);
            act("As $N dodges $n's attack, $n lost his position and falls down.", ch, NULL, victim, TO_NOTVICT);

            DAZE_STATE(ch, PULSE_VIOLENCE * number_range(1, 3));
            ch->position = POS_RESTING;
        }
    }
    check_improve(victim, gsn_dodge, TRUE, 6);
    return TRUE;
}

bool check_hand_block(CHAR_DATA *ch, CHAR_DATA *victim)
{
    int chance;
    OBJ_DATA *wield;
    OBJ_DATA *swield;

    if (!IS_AWAKE(victim)
    || IS_NPC(victim)
    || ((chance=get_skill(victim, gsn_hand_block)) <= 0))
        return FALSE;

    if (get_eq_char(victim, WEAR_WIELD)
    || get_eq_char(victim, WEAR_SECOND_WIELD)
    || get_eq_char(victim, WEAR_HOLD)
    || get_eq_char(victim, WEAR_SHIELD))
        return FALSE;

    chance /= 3;

    if (get_eq_char(victim, WEAR_WIELD))
        chance -= 10;
    if (get_eq_char(victim, WEAR_SECOND_WIELD))
        chance -= 10;
    if (get_eq_char(victim, WEAR_HOLD))
        chance -= 5;
    if (get_eq_char(victim, WEAR_SHIELD))
        chance -= 5;

    if (victim->style)
    {
        if (victim->style == STYLE_IRONBODY)
            chance += 10;
        if (victim->style == STYLE_DRUNKMAN)
            chance -= 20;
    }

    chance += LVL(victim) - LVL(ch);
    chance += 2 * (get_curr_stat(victim, STAT_DEX) - get_curr_stat(ch, STAT_DEX));
    if (victim->stance != STANCE_NORMAL)
    {
        if (number_percent() < get_skill(victim, gsn_stance))
        {
            check_improve(victim, gsn_stance, TRUE, 6);
            if (victim->stance == STANCE_DEFENSE)
                chance += 40;
            else if (victim->stance == STANCE_DEFENSE_II)
                chance += 20;
            else if (victim->stance == STANCE_OFFENSE)
                chance -= 10;
            else if (victim->stance == STANCE_OFFENSE_II)
                chance -= 20;
        }
    }

    if (IS_AFFECTED(victim, AFF_BLIND))
    {
        chance -= chance / 3;
        chance += chance * get_skill(victim, gsn_blind_fighting) / 300;
    }

    if (IS_AFFECTED(ch, AFF_HASTE))     chance -= 5;
    if (IS_AFFECTED(ch, AFF_SLOW))      chance += 10;
    if (IS_AFFECTED(victim, AFF_HASTE)) chance += 5;
    if (IS_AFFECTED(victim, AFF_SLOW))  chance -= 5;


    if (is_affected(victim, gsn_bash))  chance = chance * 2 / 3;
    if (is_affected(victim, gsn_throw)) chance = chance * 3 / 4;
    if (is_affected(victim, gsn_trip))  chance = chance * 4 / 5;

    if (number_percent() < get_skill(victim, gsn_thumbling))
    {
        chance = chance * 3 / 2;
        check_improve (victim, gsn_thumbling, TRUE, 7);
    }

    if (is_affected(victim, sn_lookup("mind focusing")))
        chance = chance * 4 / 3;
    if (is_affected(victim, sn_lookup("combat mind")))
        chance = chance * 4 / 3;
    if (is_affected(ch, sn_lookup("combat mind")))
        chance = chance * 4 / 5;

    chance = URANGE(5, chance, 80);

    if (number_percent() < chance)
    {
        // GM : aikido skill
        if (number_range(0, 9000) < get_skill(victim, sn_lookup("aikido")))
        {
            act("Your hand blocks $n's attack and use aikido power.", ch, NULL, victim, TO_VICT);
            act("$N blocks your attack with $gN{his} hand and use aikido power.", ch, NULL, victim, TO_CHAR);
            DAZE_STATE(ch, PULSE_VIOLENCE * 2);
            check_improve(victim, sn_lookup("aikido"), TRUE, 1);
        }
        else
        {
            act("Your hand blocks $n's attack.", ch, NULL, victim, TO_VICT);
            act("$N blocks your attack with $gN{his} hand.", ch, NULL, victim, TO_CHAR);
            check_improve(victim, sn_lookup("aikido"), FALSE, 4);
        }

        check_improve(victim, gsn_hand_block, TRUE, 1);
        // GM : code for auto-disarm
        if (number_percent() < 99 || (wield = get_eq_char(ch, WEAR_WIELD)) == NULL)
            return TRUE;
        chance = get_skill(victim, gsn_disarm) / 3;
        chance += get_skill(victim, sn_lookup("aikido")) / 20;
        chance += get_skill(victim, gsn_hand_to_hand) - get_weapon_skill(ch, get_weapon_sn(wield));
        chance -= (get_curr_stat(ch, STAT_STR) - get_curr_stat(victim, STAT_DEX)) * 4;
        if (number_percent() < chance)
        {
            if (!IS_OBJ_STAT(wield, ITEM_NOREMOVE))
            {
                disarm(victim, ch, wield);
                check_improve(victim, gsn_disarm, TRUE, 1);
            }
            if ((swield = get_eq_char(ch, WEAR_SECOND_WIELD)) != NULL)
            {
                if (!IS_OBJ_STAT(swield, ITEM_NOREMOVE))
                {
                    disarm(victim, ch, swield);
                    check_improve(victim, gsn_disarm, TRUE, 1);
                }
            }
        }
        return TRUE;
    }
    else
        check_improve(victim, gsn_hand_block, FALSE, 1);
    return FALSE;
}

/*
 * Set position of a victim.
 */
void update_pos(CHAR_DATA *victim)
{
    if (victim->hit > 0)
    {
        if (victim->position <= POS_STUNNED)
            victim->position = POS_STANDING;
        return;
    }

    if (IS_NPC(victim) && victim->hit < 1)
    {
        victim->position = POS_DEAD;
        return;
    }

    if (victim->hit <= -11)
    {
        victim->position = POS_DEAD;
        return;
    }

    if (victim->hit <= -6)
        victim->position = POS_MORTAL;
    else if (victim->hit <= -3)
        victim->position = POS_INCAP;
    else
        victim->position = POS_STUNNED;
}

/*
 * Start fights.
 */
void set_fighting(CHAR_DATA *ch, CHAR_DATA *victim)
{
    if (ch->fighting != NULL)
    {
        return;
    }

    if (IS_AFFECTED(ch, AFF_SLEEP))
        affect_bit_strip(ch, TO_AFFECTS, AFF_SLEEP);

    ch->fighting = victim;
    ch->position = POS_FIGHTING;
}

/*
 * Stop fights.
 */
void stop_fighting(CHAR_DATA *ch, bool fBoth)
{
    CHAR_DATA *fch;

    for (fch = char_list; fch; fch = fch->next)
    {
        if (fch == ch || (fBoth && fch->fighting == ch))
        {
            fch->fighting = NULL;
            fch->position = IS_NPC(fch) ? ch->default_pos :
                            POS_STANDING;
            update_pos(fch);
        }
    }
}

/*
 * Make a corpse out of a character.
 */
void make_corpse(CHAR_DATA *ch)
{
    OBJ_DATA *corpse;
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;

    if (IS_NPC(ch))
    {
        corpse      = create_named_obj(get_obj_index(OBJ_VNUM_CORPSE_NPC), ch->level, word_form(mlstr_val(ch->short_descr, 2), 1, 2, RULES_CASE));
        corpse->timer   = number_range(3, 6);
        if (ch->gold > 0 || ch->silver > 0)
        {
            if (IS_SET(ch->form,FORM_INSTANT_DECAY))
                obj_to_room(create_money(ch->gold, ch->silver), ch->in_room);
            else
                obj_to_obj(create_money(ch->gold, ch->silver), corpse);
            ch->gold = 0;
        }
        corpse->owner = str_dup(fix_short(mlstr_mval(ch->short_descr)));
        corpse->cost = 0;
        corpse->level = ch->level;
        corpse->value[2] = ch->pIndexData->vnum;
    }
    else
    {
        corpse      = create_named_obj(get_obj_index(OBJ_VNUM_CORPSE_PC), ch->level, ch->name);
        corpse->timer   = number_range(25, 40);
        corpse->owner = str_dup(ch->name);
        corpse->altar = get_altar(ch);
        corpse->level = ch->level;

        if (ch->gold > 0 || ch->silver > 0)
        {
            obj_to_obj(create_money(ch->gold, ch->silver), corpse);
            ch->gold = 0;
            ch->silver = 0;
        }
        corpse->cost = 0;
        corpse->value[2] = IS_SET(ch->comm,PLR_PEACE) ? 1 : 0;
    }

    for (obj = ch->carrying; obj != NULL; obj = obj_next)
    {
        obj_next = obj->next_content;

        if (IS_OBJ_STAT(obj,ITEM_NOLOOT))
            continue;

        obj_from_char(obj);
        if (IS_SET(obj->extra_flags,ITEM_ROT_DEATH))
        {
            obj->timer = number_range(5,10);
        }
        REMOVE_BIT(obj->extra_flags,ITEM_VIS_DEATH);
        REMOVE_BIT(obj->extra_flags,ITEM_ROT_DEATH);

        if (IS_SET(obj->extra_flags, ITEM_INVENTORY)
            || (obj->pIndexData->limit != -1
                && (obj->pIndexData->count > obj->pIndexData->limit))
            || obj->pIndexData->item_type == ITEM_SHAMAN_TATTOO)
        {
            extract_obj(obj);
            continue;
        }
        else if (IS_SET(ch->form, FORM_INSTANT_DECAY))
            obj_to_room(obj, ch->in_room);
        else
            obj_to_obj(obj, corpse);
    }

    if (!IS_SET(ch->form, FORM_INSTANT_DECAY))
        obj_to_room(corpse, ch->in_room);
    else
        extract_obj_raw(obj, X_F_NORECURSE);
    return;
}


void death_cry(CHAR_DATA *ch)
{
    death_cry_org(ch, -1);
}

/*
 * Improved Death_cry contributed by Diavolo.
 */
void death_cry_org(CHAR_DATA *ch, int part)
{
    ROOM_INDEX_DATA *was_in_room;
    char *msg;
    int door;
    int vnum;
    bool wanted;

    vnum = 0; wanted = FALSE;
    msg = "Your hear $n's death scream.";

    if (part == -1)
        part = number_bits(4);

    if (!IS_NPC(ch) && IS_SET(ch->plr_flags, PLR_WANTED))
    {
        wanted = TRUE;
        part = 3;
    }

    switch (part)
    {
    case  0:
        msg  = "$n hits the ground ... DEAD.";
        break;
    case  1:
        if (ch->material == 0)
        {
            msg  = "$n splatters blood on your armor.";
            break;
        }
        /* FALLTHRU */
    case  2:
        if (IS_SET(ch->parts,PART_GUTS))
        {
            msg = "$n spills $s guts all over the floor.";
            vnum = OBJ_VNUM_GUTS;
        }
        break;
    case  3:
        if (IS_SET(ch->parts,PART_HEAD))
        {
            msg  = "$n's severed head plops on the ground.";
            vnum = OBJ_VNUM_SEVERED_HEAD;
        }
        break;
    case  4:
        if (IS_SET(ch->parts,PART_HEART))
        {
            msg  = "$n's heart is torn from $gn{his} chest.";
            vnum = OBJ_VNUM_TORN_HEART;
        }
        break;
    case  5:
        if (IS_SET(ch->parts,PART_ARMS))
        {
            msg  = "$n's arm is sliced from $gn{his} dead body.";
            vnum = OBJ_VNUM_SLICED_ARM;
        }
        break;
    case  6:
        if (IS_SET(ch->parts,PART_LEGS))
        {
            msg  = "$n's leg is sliced from $gn{his} dead body.";
            vnum = OBJ_VNUM_SLICED_LEG;
        }
        break;
    case 7:
        if (IS_SET(ch->parts,PART_BRAINS))
        {
            msg = "$n's head is shattered, and $gn{his} brains splash all over you.";
            vnum = OBJ_VNUM_BRAINS;
        }
        break;
    }

    act(msg, ch, NULL, NULL, TO_ROOM);

    if (vnum != 0)
    {
        OBJ_DATA *obj;
        const char *name;

        /* XXX */
        name        = IS_NPC(ch) ? mlstr_mval(ch->short_descr) :
                      ch->name;
        obj     = create_named_obj(get_obj_index(vnum), 0,
                                   name);
        obj->owner = str_dup(name);
        obj->timer  = wanted ? 0 : number_range(4, 7);
        obj->level  = ch->level;

        if (obj->pIndexData->item_type == ITEM_FOOD)
        {
            if (IS_SET(ch->form,FORM_POISON))
                obj->value[3] = 1;
            else if (!IS_SET(ch->form,FORM_EDIBLE))
                SET_BIT(obj->extra_flags, ITEM_NOT_EDIBLE);
        }

        obj_to_room(obj, ch->in_room);
    }

    // special parts (in the dependency on race)
    if (IS_SET (muddy_mode, MUDDY_SPEC_PARTS))
    {
        int              ind;
        OBJ_INDEX_DATA * spec_part_ind;
        OBJ_DATA       * spec_part;
        race_t         * race = RACE (ch->race);

        for (ind = 0; ind < MAX_SPEC_PARTS - 1; ++ind)
        {
            if (ch->level < race->spec_levels[ind])
                continue;
            if (number_range (0, MAX_SPEC_PROB) > race->spec_prob[ind])
                continue;
            spec_part_ind = get_obj_index (race->spec_parts[ind]);
            if (spec_part_ind == NULL)
                continue;
            spec_part = create_obj (spec_part_ind, race->spec_levels[ind]);
            obj_to_room(spec_part, ch->in_room);
            act ("You can pick up $p from $n's dead body.", ch, spec_part, NULL, TO_ROOM);
        }
    }

    if (IS_NPC(ch))
        msg = "You hear someone's death scream.";
    else
        msg = "You hear someone's death cry.";

    was_in_room = ch->in_room;
    for (door = 0; door <= 5; door++)
    {
        EXIT_DATA *pexit;

        if ((pexit = was_in_room->exit[door]) != NULL
            &&   pexit->to_room.r != NULL
            &&   pexit->to_room.r != was_in_room)
        {
            ch->in_room = pexit->to_room.r;
            act(msg, ch, NULL, NULL, TO_ROOM);
        }
    }
    ch->in_room = was_in_room;
}

void raw_kill_org(CHAR_DATA *ch, CHAR_DATA *victim, int part)
{
    CHAR_DATA *tmp_ch;

    int i;
    OBJ_DATA *tattoo;
    OBJ_DATA *clanmark;

    /* don't remember killed victims anymore */
    if (IS_NPC(ch))
        remove_mind(ch, victim->name);

    stop_fighting(victim, TRUE);
    rating_update(ch, victim);
    quest_handle_death(ch, victim);

    // added for global quests
    gq_mobdeath (ch, victim);

    areacontrol_handle_death(ch, victim);

    if (IS_NPC(ch) && ch->master)
        create_memorial(ch->master, victim);
    else
        create_memorial(ch, victim);

    RESET_FIGHT_TIME(victim);
    victim->last_death_time = current_time;
    death_cry_org(victim, part);

    tattoo = get_eq_char(victim, WEAR_TATTOO);
    if (tattoo != NULL)
        obj_from_char(tattoo);
    clanmark = get_eq_char(victim, WEAR_CLANMARK);
    if (clanmark != NULL)
        obj_from_char(clanmark);
    make_corpse(victim);

    free_contacts(victim);

    if (!IS_NPC(victim))
    {
    int i;
    for(i = 0; i < victim->pcdata->learned.nused; i++)
        {
           pcskill_t *ps = VARR_GET(&victim->pcdata->learned, i);
           REMOVE_BIT(ps->xs_flags, XS_FORGOT);
        }
    }

    if (IS_NPC(victim))
    {
        victim->pIndexData->killed++;
        kill_table[URANGE(0, victim->level, MAX_LEVEL-1)].killed++;
        extract_char(victim, TRUE);
        return;
    }

    SET_BIT(victim->plr_flags, PLR_GHOST);
    char_act("You turn into an invincible ghost for a few minutes.\n"
        "As long as you don't attack anything.",
            victim);

    extract_char(victim, FALSE);

    while (victim->affected)
        affect_remove(victim, victim->affected);
    victim->affected_by = 0;

    if (!IS_NPC(victim) && victim->stance)
        victim->stance = STANCE_NORMAL;

    if (!IS_NPC(victim) && victim->style)
        victim->style = STYLE_NORMAL;

    for (i = 0; i < 4; i++)
        victim->armor[i]    = 100;
    victim->position    = POS_RESTING;
    victim->hit         = victim->max_hit / 10;
    victim->mana        = victim->max_mana / 10;
    victim->move        = victim->max_move;

    /* RT added to prevent infinite deaths */
    REMOVE_BIT(victim->plr_flags, PLR_BOUGHT_PET);

    victim->pcdata->condition[COND_THIRST] = 40;
    victim->pcdata->condition[COND_HUNGER] = 40;
    victim->pcdata->condition[COND_FULL] = 40;
    victim->pcdata->condition[COND_BLOODLUST] = 40;
    victim->pcdata->condition[COND_DESIRE] = 40;

    victim->carry_weight = 0;
    victim->aff_level = 0;

    if (tattoo != NULL)
    {
        obj_to_char(tattoo, victim);
        equip_char(victim, tattoo, WEAR_TATTOO);
    }
    if (clanmark != NULL)
    {
        obj_to_char(clanmark, victim);
        equip_char(victim, clanmark, WEAR_CLANMARK);
    }

    if (victim->level > 1)
        save_char_obj(victim, FALSE, FALSE);

    /*
     * Calm down the tracking mobiles
     */
    for (tmp_ch = char_list; tmp_ch != NULL; tmp_ch = tmp_ch->next)
    {
        if (tmp_ch->last_fought == victim)
            tmp_ch->last_fought = NULL;
        remove_mind(tmp_ch, victim->name);

        if (IS_NPC(tmp_ch) && IS_SET(tmp_ch->pIndexData->act, ACT_WANDERER)
            && (tmp_ch->hunting == victim))
            tmp_ch->hunting = NULL;
    }
}

void group_gain(CHAR_DATA *ch, CHAR_DATA *victim)
{
    CHAR_DATA *lch;
    CHAR_DATA *gch, *gch1;
    int xp;
    int members;
    int group_levels;
    int race;
    bool is_same_race;

    if (!IS_NPC(victim) || victim == ch)
        return;

    if (IS_SET(victim->pIndexData->act, ACT_PET)
    || victim->pIndexData->vnum < 100
    || victim->master
    || victim->leader)
        return;

    lch = ch->leader ? ch->leader : ch;

    members = 0;
    group_levels = 0;
    race = ch->race;
    is_same_race = TRUE;

    for (gch = ch->in_room->people; gch; gch = gch->next_in_room)
    {
        if (is_same_group(gch, ch))
        {
/*            if (IS_NPC(gch)
            && (gch->pIndexData->vnum == MOB_VNUM_LESSER_GOLEM
            || gch->pIndexData->vnum == MOB_VNUM_STONE_GOLEM
            || gch->pIndexData->vnum == MOB_VNUM_IRON_GOLEM
//            || gch->pIndexData->vnum == MOB_VNUM_DEMON
            || gch->pIndexData->vnum == MOB_VNUM_ADAMANTITE_GOLEM
            || gch->pIndexData->vnum == MOB_VNUM_DIAMOND_GOLEM
            || gch->pIndexData->vnum == MOB_VNUM_CREATED_GOLEM
            || gch->pIndexData->vnum == MOB_VNUM_FOREST_GIANT))*/
            if (does_not_affect_exp (gch))
                continue;
            if (!IS_NPC(gch)
            && abs(gch->level - lch->level) <= 8)
                members++;
            if (!IS_NPC(gch) && gch->race != ch->race)
                is_same_race = FALSE;
            group_levels += gch->level;
        }
    }

    for (gch = ch->in_room->people; gch; gch = gch->next_in_room)
    {
        if (!is_same_group(gch, ch) || IS_NPC(gch))
            continue;

        if (gch->level - lch->level > 8)
        {
            char_act("You are too high for this group.", gch);
            continue;
        }

        if (gch->level - lch->level < -8)
        {
            char_act("You are too low for this group.", gch);
            continue;
        }

        xp = xp_compute(gch, victim, group_levels, members);
        if (is_same_race && (members > 1))
            xp = xp * 1.2;

        act_puts("You receive {M$j{x experience points.",
            gch, (const void *) xp, NULL, TO_CHAR, POS_DEAD);
        gain_exp(gch, xp);

        // upgrade_npc. todo: add levels for wanderers
        //if (IS_SET (gch->comm, PLR_PEACE))
        if (gch->level >= LEVEL_HERO - 10)
        {
            for (gch1 = ch->in_room->people; gch1; gch1 = gch1->next_in_room)
            {
                if (is_same_group(gch, gch1) && IS_NPC (gch1)
                && IS_AFFECTED(gch1, AFF_CHARM)
                && IS_SET (gch1->pIndexData->act, ACT_RECEIVE_LEVEL)
                && gch1->master == gch)
                {
                    gch1->mob_tnl -= 2*xp;
                    if (gch1->mob_tnl <= 0)
                        upgrade_npc (gch1);
                }
            }
        }
    }
}

/*
 * Compute xp for a kill.
 * Also adjust alignment of killer.
 * Edit this function to change xp computations.
 */
int xp_compute(CHAR_DATA *gch, CHAR_DATA *victim, int total_levels, int members)
{
    int xp;
    int base_exp;
    int level_range = victim->level - gch->level;
    int neg_cha = 0, pos_cha = 0;

/* base exp */
    switch (level_range)
    {
    case -9:    base_exp =   1;     break;
    case -8:    base_exp =   2;     break;
    case -7:    base_exp =   5;     break;
    case -6:    base_exp =   9;     break;
    case -5:    base_exp =  11;     break;
    case -4:    base_exp =  22;     break;
    case -3:    base_exp =  33;     break;
    case -2:    base_exp =  43;     break;
    case -1:    base_exp =  60;     break;
    case  0:    base_exp =  74;     break;
    case  1:    base_exp =  84;     break;
    case  2:    base_exp =  99;     break;
    case  3:    base_exp = 121;     break;
    case  4:    base_exp = 143;     break;
    default:
        if (level_range > 4)
            base_exp = 140 + 20 * (level_range - 4);
        else
            base_exp = 0;
    }

/* calculate exp multiplier */
#if 0
    if (IS_NPC(victim) && IS_SET(victim->pIndexData->act, ACT_NOALIGN))
        xp = base_exp;
    else
#endif
    if ((IS_EVIL(gch) && IS_GOOD(victim))
    || (IS_EVIL(victim) && IS_GOOD(gch)))
        xp = base_exp * 8/5;
    else if (IS_GOOD(gch) && IS_GOOD(victim))
        xp = 0;
    else if (!IS_NEUTRAL(gch) && IS_NEUTRAL(victim))
        xp = base_exp * 1.1;
    else if (IS_NEUTRAL(gch) && !IS_NEUTRAL(victim))
        xp = base_exp * 1.3;
    else
        xp = base_exp;

    /* more exp at the low levels */
    if (gch->level < 6)
        xp = 15 * xp / (gch->level + 4);

    /* randomize the rewards */
    xp = number_range(xp * 3/4, xp * 5/4);

/* adjust for grouping */
    xp = xp * gch->level/total_levels;
    if (members == 2 || members == 3)
    {
        xp *= members * (110 + members * 5);
        xp /= 100;
    }

#if 0
    xp += (xp * (gch->max_hit - gch->hit)) / (gch->max_hit * 5);
#endif

    if (IS_GOOD(gch))
    {
        if (IS_GOOD(victim))
        {
            /* added for global quests */
            if (gq_findplr (gch) != NULL)
            {
                if (is_gquest_mob(victim))
                    gch->pcdata->has_killed++;
            }
            else
            {
                /* end-added */
                gch->pcdata->anti_killed++;

                neg_cha = 1;
            }
        }
        else if (IS_NEUTRAL(victim))
        {
            gch->pcdata->has_killed++;
            pos_cha = 1;
        }
        else if (IS_EVIL(victim))
        {
            gch->pcdata->has_killed++;
            pos_cha = 1;
        }
    }
    else if (IS_NEUTRAL(gch))
    {
        if (IS_GOOD(victim))
        {
            gch->pcdata->has_killed++;
            pos_cha = 1;
        }
        else if (IS_NEUTRAL(victim))
        {
            gch->pcdata->anti_killed++;
            neg_cha = 1;
        }
        else if (IS_EVIL(victim))
        {
            gch->pcdata->has_killed++;
            pos_cha =1;
        }
    }
    else if (IS_EVIL(gch))
    {
        if (IS_GOOD(victim))
        {
            gch->pcdata->has_killed++;
            pos_cha = 1;
        }
        else if (IS_NEUTRAL(victim))
        {
            gch->pcdata->has_killed++;
            pos_cha = 1;
        }
        else if (IS_EVIL(victim))
        {
            gch->pcdata->anti_killed++;
            neg_cha = 1;
        }
    }

    if (neg_cha)
    {
        if ((gch->pcdata->anti_killed % 100) == 99)
        {
            act_puts("You have killed $j $T up to now.",
                gch, (const void *) gch->pcdata->anti_killed, IS_GOOD(gch) ?  "goods" : IS_EVIL(gch) ?  "evils" : "neutrals", TO_CHAR, POS_DEAD);
            if (gch->perm_stat[STAT_CHA] > 3 && IS_GOOD(gch))
            {
                char_act("So your charisma has reduced by one.", gch);
                gch->perm_stat[STAT_CHA] -= 1;
            }
        }
    }
    else if (pos_cha)
    {
        if ((gch->pcdata->has_killed % 200) == 199)
        {
            act_puts("You have killed $j $T up to now.",
                gch, (const void *) gch->pcdata->anti_killed, IS_GOOD(gch) ?  "anti-goods" : IS_EVIL(gch) ?  "anti-evils" : "anti-neutrals", TO_CHAR, POS_DEAD);
            if (gch->perm_stat[STAT_CHA] < get_max_train(gch, STAT_CHA)
            &&  IS_GOOD(gch))
            {
                char_act("So your charisma has increased by one.", gch);
                gch->perm_stat[STAT_CHA] += 1;
            }
        }
    }

    xp -= xp/4;

    if (gch->pcdata)
    {
        if (IS_SET(gch->pcdata->wishes, WISH_EXPRATE2))
        {
            xp = xp * 1.4;
        }
        else
        {
            if (IS_SET(gch->pcdata->wishes, WISH_EXPRATE1))
            {
                xp = xp * 1.2;
            }
        }
    }

    if (altar_works (gch, ALTAR_EXPERIENCE_POS))
        xp = xp * 1.2;

    if (IS_SET(gch->comm, COMM_BONUS))
    {
        xp = xp * LVL(gch) / 91;
    }
    return xp;
}

char *upfirst(const char *str)
{
    static char strcap[MAX_STRING_LENGTH];
    int len;

    if (IS_NULLSTR(str))
        return str_empty;

    len = strlen(str);
    strnzcpy(strcap, len+1, str);
    if (str[0] == '{' && len > 2)
        strcap[2] = UPPER(str[2]);
    else
        strcap[0] = UPPER(str[0]);

    return strcap;
}


void dam_message(CHAR_DATA *ch, CHAR_DATA *victim,
                 int dam, int dt, bool immune, int dam_type)
{
    char buf_ve[256], buf_ce[256], buf_vr[256];
    char buf_cr[256], eng_buf[256], rus_buf[256];
    const char *eng_dam = NULL;
    const char *ch_dam = NULL;
    const char *rus_dam = NULL;
    const char *rus_mdam = NULL;
    const char *v_dam  = NULL;
    const char *attack, *r_attack;
    char *dam_gen;
    char punct;
    DAMAGE_DATA *dam_d;
    char c;
    int lang_rus, lang_eng, n_gen;
    static char *gen[] = {"", "", "ϣ", ""};

    dam_d = damage_table;
    while (dam_d->max_dam != -1 && dam > dam_d->max_dam)
        dam_d++;

    lang_rus = lang_lookup("rus");
    lang_eng = lang_lookup("eng");
    ch_dam = dam_d->mes[ch->lang];
    v_dam = dam_d->mes[victim->lang];
    eng_dam = dam_d->mes[lang_eng];
    rus_dam = dam_d->mes[lang_rus];
    rus_mdam = dam_d->mes[2];
    c = dam_d->color;

    if (victim->level < 20) punct   = (dam <= 24) ? '.' : '!';
    else if (victim->level < 50)  punct = (dam <= 50) ? '.' : '!';
    else punct = (dam <= 75) ? '.' : '!';

    if ((dt == TYPE_HIT) || (dt == TYPE_HUNGER))
    {
        if (ch == victim)
        {
            switch (dam_type)
            {
            case DAM_HUNGER :
                snprintf(eng_buf, sizeof(eng_buf), "$n's hunger {%c%s{x $gn{him}%c", c, eng_dam, punct);
                snprintf(rus_buf, sizeof(rus_buf), " $c1{$n} {%c%s{x $gn{}%c", c, rus_dam,punct);
                snprintf(buf_cr, sizeof(buf_cr), "  {%c%s{x %c", c, ch_dam,punct);
                snprintf(buf_ce, sizeof(buf_ce), "Your hunger {%c%s{x yourself%c", c, ch_dam,punct);
                break;
            case DAM_THIRST :
                snprintf(rus_buf, sizeof(rus_buf), " $c1{$n} {%c%s{x $gn{}%c", c, rus_dam,punct);
                snprintf(eng_buf, sizeof(eng_buf), "$n's thirst {%c%s{x $gn{him}%c", c, eng_dam,punct);
                snprintf(buf_cr, sizeof(buf_cr), "  {%c%s{x %c", c, ch_dam,punct);
                snprintf(buf_ce, sizeof(buf_ce), "Your thirst {%c%s{x yourself%c", c, ch_dam,punct);
                break;
            case DAM_LIGHT_V :
                snprintf(rus_buf, sizeof(rus_buf), "  {%c%s{x $c6{$n}!%c", c, rus_dam,punct);
                snprintf(eng_buf, sizeof(eng_buf), "Sunlight {%c%s{x $n!%c", c, eng_dam, punct);
                snprintf(buf_cr, sizeof(buf_cr), "  {%c%s{x %c", c, ch_dam,punct);
                snprintf(buf_ce, sizeof(buf_ce), "Sunlight {%c%s{x you%c", c, ch_dam,punct);
                break;
            case DAM_TRAP_ROOM :
                snprintf(rus_buf, sizeof(rus_buf), "   {%c%s{x $c6{$n}%c", c, rus_dam,punct);
                snprintf(eng_buf, sizeof(eng_buf), "Trap in room {%c%s{x $n%c", c, eng_dam, punct);
                snprintf(buf_cr, sizeof(buf_cr), "   {%c%s{x %c", c, ch_dam,punct);
                snprintf(buf_ce, sizeof(buf_ce), "Trap in room {%c%s{x you%c", c, ch_dam,punct);
                break;
            case DAM_SPACE :
                snprintf(rus_buf, sizeof(rus_buf), " {%c%s{x $c6{$n}%c", c, rus_dam,punct);
                snprintf(eng_buf, sizeof(eng_buf), "Tightness {%c%s{x $n%c", c, eng_dam, punct);
                snprintf(buf_cr, sizeof(buf_cr), " {%c%s{x %c", c, ch_dam,punct);
                snprintf(buf_ce, sizeof(buf_ce), "Tightness {%c%s{x you%c", c, ch_dam,punct);
            default :
                snprintf(rus_buf, sizeof(rus_buf), "$n {%c%s{x %c", c, rus_dam, punct);
                snprintf(eng_buf, sizeof(eng_buf), "$n {%c%s{x $gn{himself}%c", c, eng_dam, punct);
                snprintf(buf_cr, sizeof(buf_cr), " {%c%s{x %c", c, ch_dam,punct);
                snprintf(buf_ce, sizeof(buf_ce), "You {%c%s{x yourself%c", c, ch_dam,punct);
                break;
            }
        }
        else
        {

            snprintf(rus_buf, sizeof(rus_buf), "$n {%c%s{x $c6{$N}%c", c, rus_dam, punct);
            snprintf(eng_buf, sizeof(eng_buf), "$n {%c%s{x $N%c", c, eng_dam, punct);
            snprintf(buf_cr, sizeof(buf_cr), " {%c%s{x $c6{$N}%c", c, ch_dam, punct);
            snprintf(buf_ce, sizeof(buf_ce), "You {%c%s{x $N%c", c, ch_dam, punct);
            snprintf(buf_vr, sizeof(buf_vr), "$n {%c%s{x %c", c, v_dam, punct);
            snprintf(buf_ve, sizeof(buf_ve), "$n {%c%s{x you%c", c, v_dam, punct);

        }
    }
    else
    {
        skill_t *sk;

#define MAX_DAMAGE_MESSAGE 43
        if ((sk = skill_lookup(dt)))
        {
            attack      = sk->noun_damage;
            r_attack    = sk->noun_rus;
            if (r_attack == NULL)
                r_attack = attack;
            n_gen = sk->gender;
            dam_gen = gen[n_gen];
        }
        else if (dt >= TYPE_HIT && dt <= TYPE_HIT + MAX_DAMAGE_MESSAGE)
        {
            attack      = attack_table[dt - TYPE_HIT].noun;
            r_attack    = attack_table[dt - TYPE_HIT].rnoun;
            n_gen = attack_table[dt - TYPE_HIT].gender;
            dam_gen = gen[n_gen];
        }
        else
        {
            bug("[*****] BUG: Dam_message: bad dt %d.", dt);
            dt = TYPE_HIT;
            attack = attack_table[0].name;
            r_attack    = attack_table[0].rnoun;
            n_gen = attack_table[0].gender;
            dam_gen = gen[n_gen];
        }

        if (3 == n_gen)
        {
            rus_dam = rus_mdam;
            if (lang_rus == ch->lang)
                ch_dam = rus_mdam;
            if (ch != victim && lang_rus == victim->lang)
                v_dam = rus_mdam;
        }

        if (immune)
        {
            if (ch == victim)
            {
                snprintf(eng_buf, sizeof(eng_buf),"$n is unaffected by $gn{his} own %s.", attack);
                snprintf(rus_buf, sizeof(rus_buf),"$n   %s.", r_attack);
                snprintf(buf_cr, sizeof(buf_cr)," ,    .");
                snprintf(buf_ce, sizeof(buf_ce),"Luckily, you are immune to that.");
            }
            else
            {
                snprintf(eng_buf, sizeof(eng_buf),"$N is unaffected by $n's %s!",attack);
                snprintf(rus_buf, sizeof(rus_buf),"$N   %s $c1{$n}!",r_attack);
                snprintf(buf_cr, sizeof(buf_cr),"$N   %s!",r_attack);
                snprintf(buf_ce, sizeof(buf_ce),"$N is unaffected by your %s!",attack);
                snprintf(buf_vr, sizeof(buf_vr),"%s $c1{$n}    !",r_attack);
                snprintf(buf_ve, sizeof(buf_ve),"$n's %s is powerless against you!",attack);
            }
        }
        else
        {
            if (ch == victim)
            {
                snprintf(eng_buf, sizeof(eng_buf), "$n's %s {%c%s{x $gn{him}%c", attack, c, eng_dam, punct);
                snprintf(rus_buf, sizeof(rus_buf), "%s $c1{$n} {%c%s{x $gn{}%c", upfirst(r_attack), c,rus_dam,punct);
                snprintf(buf_cr, sizeof(buf_cr), "%s %s {%c%s{x %c", dam_gen, r_attack, c, ch_dam, punct);
                snprintf(buf_ce, sizeof(buf_ce), "Your %s {%c%s{x you%c", attack, c, ch_dam,punct);
            }
            else
            {
                // GM : autodamage
                if ((IS_SET(ch->plr_flags,PLR_AUTODAMAGE) && dam !=0)
                || (IS_SET(victim->plr_flags,PLR_AUTODAMAGE) && dam !=0))
                {
                    snprintf(rus_buf, sizeof(rus_buf), "$n %s {%c%s{x $c%d{$N}%c", attack, c, rus_dam, (dam == 0 ? 1 : 6), punct );
                    snprintf(eng_buf, sizeof(eng_buf), "%s $n {%c%s{x $c6{$N}%c", upfirst(r_attack), c, eng_dam, punct );

                    if (IS_SET(ch->plr_flags,PLR_AUTODAMAGE))
                    {
                        snprintf(buf_cr, sizeof(buf_cr), "%s %s {%c%s{x $c%d{$N}%c {%c[%d]{x",  dam_gen, r_attack, c, ch_dam, (dam == 0 ? 1 : 6), punct, c, dam );
                        snprintf(buf_ce, sizeof(buf_ce), "Your %s {%c%s{x $c6{$N}%c {%c[%d]{x",  attack, c, ch_dam, punct, c, dam );
                    }
                    else
                    {
                        snprintf(buf_cr, sizeof(buf_cr), "%s %s {%c%s{x $c%d{$N}%c", dam_gen, r_attack, c, ch_dam, (dam == 0 ? 1 : 6), punct);
                        snprintf(buf_ce, sizeof(buf_ce), "Your %s {%c%s{x $c6{$N}%c", attack, c, ch_dam, punct);
                    }
                    if (IS_SET(victim->plr_flags,PLR_AUTODAMAGE))
                    {
                        snprintf(buf_vr, sizeof(buf_vr), "%s $c1{$n} {%c%s{x %c {%c[%d]{x", upfirst(r_attack), c, v_dam, punct, c, dam );
                        snprintf(buf_ve, sizeof(buf_ve), "$n %s {%c%s{x you%c {%c[%d]{x", attack, c, v_dam, punct, c, dam );
                    }
                    else
                    {
                        snprintf(buf_vr, sizeof(buf_vr), "%s $c1{$n} {%c%s{x %c", upfirst(r_attack), c, v_dam, punct);
                        snprintf(buf_ve, sizeof(buf_ve), "$n %s {%c%s{x you%c", attack, c, v_dam, punct);
                    }
                }
                else
                {
                    snprintf(eng_buf, sizeof(eng_buf), "$n %s {%c%s{x $c%d{$N}%c", attack, c, eng_dam,(dam == 0 ? 1 : 6), punct);
                    snprintf(rus_buf, sizeof(rus_buf), "%s $c1{$n} {%c%s{x $c%d{$N}%c", upfirst(r_attack), c, rus_dam, (dam == 0 ? 1 : 6), punct);
                    snprintf(buf_cr, sizeof(buf_cr), "%s %s {%c%s{x $c%d{$N}%c", dam_gen, r_attack, c, ch_dam,(dam == 0 ? 1 : 6), punct);
                    snprintf(buf_ce, sizeof(buf_ce), "Your %s {%c%s{x $c%d{$N}%c", attack, c, ch_dam,(dam == 0 ? 1 : 6), punct);
                    snprintf(buf_vr, sizeof(buf_vr), "%s $c1{$n} {%c%s{x %c", upfirst(r_attack), c, v_dam, punct);
                    snprintf(buf_ve, sizeof(buf_ve), "$n %s {%c%s{x you%c", attack, c, v_dam, punct);
                }
            }
        }
    }

    if (ch == victim)
    {
        CHAR_DATA *wch;

        for (wch = ch->in_room->people; wch; wch = wch->next_in_room)
        {
            if (ch == wch) continue;
            if (IS_NPC(wch)) continue;
            act_puts((wch->lang == lang_rus) ? rus_buf : eng_buf, ch, NULL, wch, TO_VICT, POS_RESTING);
        }
        act_puts((ch->lang == lang_rus) ? buf_cr : buf_ce, ch, NULL, NULL, TO_CHAR, POS_RESTING);
    }
    else
    {
        CHAR_DATA *wch;

        if (ch != NULL && ch->in_room != NULL)
            for (wch = ch->in_room->people; wch != NULL; wch = wch->next_in_room)
            {
                if ((ch == wch) || (victim == wch)) continue;
                if (dam || dt < TYPE_HIT || !IS_SET(wch->comm,COMM_NOVERBOSE))
                {
                    if (wch->lang == lang_rus)
                        act_raw_global(ch, wch, NULL, (void*)victim, rus_buf, 0);
                    else
                        act_raw_global(ch, wch, NULL, (void*)victim, eng_buf, 0);
                }
            }

        if (ch && victim && victim->in_room && (ch->in_room != victim->in_room))
            for (wch=victim->in_room->people; wch ; wch = wch->next_in_room)
            {
                if ((ch == wch) || (victim == wch)) continue;
                if (dam || dt < TYPE_HIT || !IS_SET(wch->comm,COMM_NOVERBOSE))
                {
                    if (wch->lang == lang_rus)
                        act_raw_global(ch, wch, NULL, (void*)victim, rus_buf, 0);
                    else
                        act_raw_global(ch, wch, NULL, (void*)victim, eng_buf, 0);
                }
            }

        if (dam || dt < TYPE_HIT || !IS_SET(ch->comm, COMM_NOVERBOSE))
            act_puts((ch->lang == lang_rus) ? buf_cr : buf_ce, ch, NULL, victim, TO_CHAR, POS_RESTING);

        if (dam || dt < TYPE_HIT || !IS_SET(victim->comm, COMM_NOVERBOSE))
            act_puts((victim->lang == lang_rus) ? buf_vr : buf_ve, ch, NULL, victim, TO_VICT, POS_RESTING);
    }

    return;
}

bool check_mortal_strike(CHAR_DATA *ch, CHAR_DATA *victim)
{
    int chance;
    if ((chance = get_skill(ch, gsn_mortal_strike))
    && get_eq_char(ch, WEAR_WIELD)
    && !is_immune(victim, DAM_WEAPON)
    && !is_immune(victim, DAM_PHYSICAL)
    && LVL(ch) > (LVL(victim) - 5))
    {
        chance /= 30;
        chance += 1 + (LVL(ch) - LVL(victim)) / 2;
        if (number_percent() < chance)
        {
            act_puts("Your flash strike instantly slays $N!", ch, NULL, victim, TO_CHAR, POS_RESTING);
            act_puts("$n flash strike instantly slays $N!", ch, NULL, victim, TO_NOTVICT, POS_RESTING);
            act_puts("$n flash strike instantly slays you!", ch, NULL, victim, TO_VICT, POS_DEAD);
            handle_death(ch, victim);
            check_improve(ch, gsn_mortal_strike, TRUE, 1);
            return TRUE;
        }
        else
            check_improve(ch, gsn_mortal_strike, FALSE, 3);
    }
    return FALSE;
}

DO_FUN(do_kill)
{
    CHAR_DATA *victim;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (argument[0] == '\0')
    {
        char_act("Kill whom?", ch);
        return;
    }

    if (ch->fighting != NULL)
    {
    do_target(ch, argument);
    return;
    }

    WAIT_STATE(ch, 1 * PULSE_VIOLENCE);

    if ((victim = get_char_room(ch, argument)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (!IS_NPC(victim))
    {
        char_act("You must MURDER a player.", ch);
        return;
    }

    if (victim == ch)
    {
        char_act("You hit yourself.  Ouch!", ch);
        multi_hit(ch, ch, TYPE_UNDEFINED);
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM) && ch->master == victim)
    {
        act("$N is your beloved master.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (is_safe(ch, victim))
        return;

    if (check_mortal_strike(ch, victim))
    return;

    multi_hit(ch, victim, TYPE_UNDEFINED);
}

DO_FUN(do_murde)
{
    char_act("If you want to MURDER, spell it out.", ch);
    return;
}

DO_FUN(do_murder)
{
    CHAR_DATA *victim;
    bool attacked;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (argument[0] == '\0')
    {
        char_act("Murder whom?", ch);
        return;
    }

    if (ch->fighting != NULL)
    {
        do_target(ch, argument);
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM)
    || (IS_NPC(ch)
    && IS_SET(ch->pIndexData->act, ACT_PET)))
        return;

    WAIT_STATE(ch, 1 * PULSE_VIOLENCE);

    if ((victim = get_char_room(ch, argument)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (victim == ch)
    {
        char_act("Suicide is a mortal sin.", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM) && ch->master == victim)
    {
        act("$N is your beloved master.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (is_safe(ch, victim))
        return;

    attacked = !IS_NPC(ch) && !IS_NPC(victim)
               && victim->position > POS_STUNNED
               && (victim->fighting != ch);

    if (attacked)
        agent_net_printf(victim, ch, ANET_ATTACK);

    if (check_mortal_strike(ch, victim))
        return;

    multi_hit(ch, victim, TYPE_UNDEFINED);

    if (victim == NULL || JUST_KILLED(victim)
    || ch == NULL || JUST_KILLED(ch))
        return;

    if (attacked && victim->position > POS_STUNNED)
        act_yell(victim, "Help! $i trying to murder me!", ch, NULL);
}

DO_FUN(do_flee)
{
    ROOM_INDEX_DATA *was_in;
    ROOM_INDEX_DATA *now_in;
    CHAR_DATA *victim;
    int attempt, max_att = 6;

    if (RIDDEN(ch))
    {
        char_act("You should ask to your rider!", ch);
        return;
    }

    if ((victim = ch->fighting) == NULL)
    {
        if (ch->position == POS_FIGHTING)
            ch->position = POS_STANDING;
        char_act("You aren't fighting anyone.", ch);
        return;
    }

    if (IS_SAMURAI(ch))
    {
        char_act("Your honour doesn't let you flee, try dishonoring yourself.", ch);
        return;
    }

    if (ch->religion == RELIGION_SLIDER)
    {
        act_say(ch, "My honour is my life!", NULL);
    }

    if (!IS_NPC(ch))
        WAIT_STATE(ch, 4);
    was_in = ch->in_room;
    if (IS_AFFECTED(ch, AFF_WEB))
        max_att /= 3;

    if (IS_RAFFECTED(ch->in_room, RAFF_PREVENT))
        max_att -= 1;

    if (IS_NPC(ch) || number_range(0, ch->daze) == 0)
    {
        for (attempt = 0; attempt < max_att; attempt++)
        {
            EXIT_DATA *pexit;
            int door;

            door = number_door();
            if ((pexit = was_in->exit[door]) == 0
                || pexit->to_room.r == NULL
                || (IS_SET(pexit->exit_info, EX_CLOSED)
                && (!IS_AFFECTED(ch, AFF_PASS_DOOR)
                || IS_SET(pexit->exit_info,EX_NOPASS))
                && !IS_TRUSTED(ch,ANGEL))
                || (IS_SET(pexit->exit_info , EX_NOFLEE))
                || (IS_NPC(ch)
                && IS_SET(pexit->to_room.r->room_flags, ROOM_NOMOB)))
                continue;

            move_char(ch, door, FALSE);
            if ((now_in = ch->in_room) == was_in)
                continue;

            ch->in_room = was_in;
            act("$n has fled!", ch, NULL, NULL, TO_ROOM);
            ch->in_room = now_in;

            if (!IS_NPC(ch))
            {
                char_act("You fled from combat!", ch);
                if (ch->level < LEVEL_HERO)
                {
                    int xp_lose_when_flee = 10;
                    act_puts("You lose {M$j{x experience points..",  ch, (const void*) xp_lose_when_flee, NULL, TO_CHAR, POS_DEAD);
                    gain_exp(ch, -xp_lose_when_flee);
                }
            }
            else
                ch->last_fought = NULL;

            stop_fighting(ch, TRUE);
            return;
        }
    }

    char_act("PANIC! You couldn't escape!", ch);
    return;
}

DO_FUN(do_sla)
{
    char_act("If you want to SLAY, spell it out.", ch);
    return;
}

DO_FUN(do_slay)
{
    CHAR_DATA *victim;
    char arg[MAX_INPUT_LENGTH];

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("Slay whom?", ch);
        return;
    }

    if ((victim = get_char_room(ch, arg)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (ch == victim)
    {
        char_act("Suicide is a mortal sin.", ch);
        return;
    }

    if (!IS_IMMORTAL(ch) && !IS_NPC(victim))
    {
        char_act("You failed.", ch);
        return;
    }

    if (IS_IMMORTAL(victim))
    {
        char_act("You failed.", ch);
        return;
    }

    act("You slay $gN{him} in cold blood!", ch, NULL, victim, TO_CHAR);
    act("$n slays you in cold blood!", ch, NULL, victim, TO_VICT);
    act("$n slays $N in cold blood!", ch, NULL, victim, TO_NOTVICT);
    raw_kill(ch, victim);
}

/*
 * Check for obj dodge.
 */
bool check_obj_dodge(CHAR_DATA *ch, CHAR_DATA *victim, OBJ_DATA *obj, int bonus)
{
    int chance;

    if (!IS_AWAKE(victim) || MOUNTED(victim))
        return FALSE;

    if (!IS_NPC(victim) && IS_IMMORTAL(victim))
    {
        act("You catch $p that had been shot to you.",  ch, obj, victim, TO_VICT);
        act("$N catches $p that had been shot to $gN{him}.", ch, obj, victim, TO_CHAR);
        act("$n catches $p that had been shot to $gn{him}.", victim, obj, ch, TO_NOTVICT);
        obj_to_char(obj, victim);
        return TRUE;
    }

    if (IS_NPC(victim))
        chance  = UMIN(30, LVL(victim));
    else
    {
        chance  = get_skill(victim, gsn_dodge) / 2;
        chance  += (get_skill(victim, gsn_jammer) / 5);
        /* chance for high dex. */
        chance += 2 * (get_curr_stat(victim, STAT_DEX) - 20);
        if (victim->class == CLASS_NINJA)
            chance = chance *3/2;
        if (victim->class == CLASS_WARRIOR)
            chance = chance * 13/10;
        else if (IS_SAMURAI(ch))
            chance = chance * 6/5;
        if (victim->class == CLASS_THIEF)
            chance = chance * 11/10;
        if (is_affected(victim, sn_lookup("combat mind")))
            chance = chance * 4 / 3;

    }

    chance -= (bonus - 90);
    chance /= 2;
    if (number_percent() >= chance)
        return FALSE;

    act("You dodge $p that had been shot to you.",   ch, obj, victim, TO_VICT);
    act("$N dodges $p that had been shot to $gN{him}.", ch, obj, victim, TO_CHAR);
    act("$n dodges $p that had been shot to $gn{him}.",  victim, obj, ch, TO_NOTVICT);
    obj_to_room(obj, victim->in_room);
    check_improve(victim, gsn_dodge, TRUE, 6);

    return TRUE;
}

DO_FUN(do_dishonor)
{
    ROOM_INDEX_DATA *was_in;
    ROOM_INDEX_DATA *now_in;
    AFFECT_DATA af;
    int attempt, max_att = 6;

    if (RIDDEN(ch))
    {
        char_act("You should ask to your rider!", ch);
        return;
    }

    if (!IS_SAMURAI(ch)
    || is_affected(ch, gsn_dishonor))
    {
        char_act("Which honor?", ch);
        return;
    }

    if (ch->fighting == NULL)
    {
        if (ch->position == POS_FIGHTING)
            ch->position = POS_STANDING;
        char_act("You aren't fighting anyone.", ch);
        return;
    }

    WAIT_STATE(ch, 4);

    was_in = ch->in_room;
    if (IS_AFFECTED(ch, AFF_WEB))
        max_att /= 3;

    if (IS_RAFFECTED(ch->in_room, RAFF_PREVENT))
        max_att -= 1;

    if (number_range(0, ch->daze) == 0)
    {
        for (attempt = 0; attempt < max_att; attempt++)
        {
            EXIT_DATA *pexit;
            int door;

            door = number_door();
            if ((pexit = was_in->exit[door]) == 0
            || pexit->to_room.r == NULL
            || (IS_SET(pexit->exit_info, EX_CLOSED)
            && (!IS_AFFECTED(ch, AFF_PASS_DOOR)
            || IS_SET(pexit->exit_info,EX_NOPASS))
            && !IS_TRUSTED(ch,ANGEL))
            || IS_SET(pexit->exit_info, EX_NOFLEE))
                continue;

            move_char(ch, door, FALSE);
            if ((now_in = ch->in_room) == was_in)
                continue;

            ch->in_room = was_in;
            act("$n has dishonored $gn{himself}!", ch, NULL, NULL, TO_ROOM);
            ch->in_room = now_in;

            if (!IS_NPC(ch))
            {
                char_act("You dishonored yourself and flee from combat.", ch);
                if (ch->level <= LEVEL_HERO)
                {
                    act_puts("You lose {M$j{z $qj{exps}.",
                        ch, (const void *) (ch->level * 10), NULL, TO_CHAR, POS_DEAD);
                    gain_exp(ch, -(ch->level * 10));

                    af.where = TO_AFFECTS;
                    af.type = gsn_dishonor;
                    af.duration = -1;
                    af.level = ch->level;
                    af.location = APPLY_CHA;
                    af.modifier = -10;
                    af.bitvector = 0;
                    affect_to_char(ch, &af);

                    af.where = TO_RESIST;
                    af.location = APPLY_NONE;
                    af.modifier = -40;
                    af.bitvector = DAM_CHARM;
                    affect_to_char(ch, &af);

                    af.location = APPLY_NONE;
                    af.modifier = -40;
                    af.bitvector = DAM_MENTAL;
                    affect_to_char(ch, &af);
                }
            } else
                ch->last_fought = NULL;

            stop_fighting(ch, TRUE);
            if (MOUNTED(ch))
                do_dismount(ch,str_empty);
            return;
        }
    }
    char_act("Fortunately, you do not manage to dishonor yourself.", ch);
    return;
}

DO_FUN(do_surrender)
{
    CHAR_DATA *mob;

    if ((mob = ch->fighting) == NULL)
    {
        char_act("But you're not fighting!", ch);
        return;
    }

    if (!IS_NPC(mob)
    && !IS_SET(ch->in_room->room_flags, ROOM_BATTLE_ARENA))
    {
        char_act("You can surrender only on {WBattle Arena{z!", ch);
        return;
    }

    act("You surrender to $N!", ch, NULL, mob, TO_CHAR);
    act("$n surrenders to you!", ch, NULL, mob, TO_VICT);
    act("$n tries to surrender to $N!", ch, NULL, mob, TO_NOTVICT);

    WAIT_STATE(ch, 1 * PULSE_VIOLENCE);

    if (!IS_NPC(ch) && IS_NPC(mob)
    && (!HAS_TRIGGER_MOB(mob, TRIG_SURR)
    || !p_percent_trigger(mob, NULL, NULL, ch, NULL, NULL, TRIG_SURR)))
    {
        act("$N seems to ignore your cowardly act!", ch, NULL, mob, TO_CHAR);
        multi_hit(mob, ch, TYPE_UNDEFINED);
    } else
    {
        stop_fighting(ch, TRUE);
    }
}

#ifdef OLD_VERSION
//
// inflict damage from hit
//
bool damage (CHAR_DATA * ch,        // source of attack
             CHAR_DATA * victim,    // destination of attack
             int dam,               // damage to inflict (originally)
             int dt,                // type of damage
             int dam_type,
             int dam_flags)         // special flags
{
    bool immune = FALSE ;
    int  dam2, loc, dam_mod ;

    OBJ_DATA  * shield ;
    OBJ_DATA  * weapon ;
    clan_t * clan   ;

    // check for possible problems
    if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim))
        return FALSE ;
    if (dt > 0 && dt < TYPE_HIT)
    {
        if (check_absorb(ch, victim, dt, TRUE))
            return FALSE;
        if (check_spellbane(ch, victim, dt))
            return FALSE;
    }
    if (victim != ch)
    {
        // religion Bast
        if (victim->religion == RELIGION_BAST
        && (get_eq_char (victim, WEAR_TATTOO) != NULL)
        && dam_type == DAM_FIRE && number_percent() < 20
        && !check_galka(ch))
        {
            act_puts(" $N  {C {z      !",  ch, NULL, victim, TO_CHAR, POS_DEAD);
            act("   {C {z     !",  ch, NULL, victim, TO_VICT);
            act(" $N  {C {z   $n   !", ch, NULL, victim, TO_NOTVICT);
            return FALSE ;
        }

        // certain attacks are forbidden
        // most other attacks are returned

        if (victim->position > POS_STUNNED)
        {
            if (victim->fighting == NULL)
            {
                set_fighting (victim, ch);

                // mob trigger on kill
                if (IS_NPC(victim) && HAS_TRIGGER_MOB (victim, TRIG_KILL))
                    p_percent_trigger (victim, NULL, NULL, ch, NULL, NULL, TRIG_KILL);
            }

            // check for possible problems
            if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim))
                return FALSE ;

            if (victim->timer <= 4) victim->position = POS_FIGHTING ;

            if (ch->fighting == NULL) set_fighting (ch, victim);

            // if victim is charmed, ch might attack victim's master
            // with probability 1/8

            if (IS_NPC (ch)
            && IS_NPC (victim)
            && IS_AFFECTED (victim, AFF_CHARM)
            && victim->master != NULL
            && victim->master->in_room == ch->in_room
            && ch->fighting != victim->master
            && number_bits (7) == 0)
            //&& !IS_AFFECTED(ch, AFF_BLIND) // Welesh: to discuss
            {
                stop_fighting (ch, FALSE);
                multi_hit     (ch, victim->master, TYPE_UNDEFINED);
                return FALSE ;
            }
        }

        // more charm and group stuff
        // todo: add friendly fire check
        if (victim->master == ch
            && (!IS_NPC(victim)
                || !IS_AFFECTED(victim, AFF_CHARM)))
            stop_follower (victim);

        if (MOUNTED (victim) == ch || RIDDEN (victim) == ch)
            victim->riding = ch->riding = 0 ;
    }

    // no one in combat can hide, be invis or camoed
    do_visible (ch,     str_empty);
    do_visible (victim, str_empty);

    // no more calm
    if (IS_AFFECTED (victim, AFF_CALM))
        REMOVE_BIT (victim->affected_by, AFF_CALM);

    // derive location of the weapon
    loc = IS_SET (dam_flags, DAMF_SECOND) ? WEAR_SECOND_WIELD : WEAR_WIELD ;

    //
    // check for parry, dodge and other stuff
    //
    if (ch != victim && check_mirror_image(ch, victim))
        return FALSE;
    if (dt >= TYPE_HIT && ch != victim)
    {
        // clan chaos mirrors
        if (is_affected (victim, gsn_mirror)
        && IS_NPC(victim))
        {
            act("$n shatters into tiny fragments of glass.", victim, NULL, NULL, TO_ROOM);
            extract_char (victim, TRUE);
            return FALSE ;
        }

        // dodge
        if (check_dodge (ch, victim)) return FALSE ;

        // feint
        if (is_affected (ch, gsn_feint))
        {
            act(" $n   .", ch, NULL, NULL, TO_ROOM | ACT_VERBOSE);
            act("     .",  ch, NULL, NULL, TO_CHAR | ACT_VERBOSE);
            if (number_percent() < 20)
                affect_strip (ch, gsn_feint);
            return FALSE ;
        }

        if (check_stand_off (ch, victim)) return FALSE ;

        // parry
        if (check_parry (ch, victim, loc))
        {
            // riposte/restrike stuff
            check_riposte (victim, ch, dam);

            // check for possible problems
            if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim))
                return FALSE ;

            check_restrike (victim, ch);
            return FALSE ;
        }

        // tiger's snout - inquisitors skill
        check_tigers_snout (victim, ch);

        // check for possible problems
        if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim))
            return FALSE ;

        // hand block - primary ninja's skill
        if (check_hand_block (ch, victim))      return FALSE ;

        if (check_block      (ch, victim, loc)) return FALSE ;
        if (check_blink      (ch, victim))      return FALSE ;
        if (check_shield     (ch, victim))      return FALSE ;
        if (check_stoneskin  (ch, victim))      return FALSE ;
        if (check_towershield(ch, victim))      return FALSE ; // shamans' stuff

        affect_strip (victim, gsn_bash)  ;
        affect_strip (victim, gsn_throw) ;
        affect_strip (victim, gsn_trip)  ;
    }

    // backstab can be blocked by shield
    if (dt == gsn_backstab && check_shield (ch, victim)) return FALSE ;

    // check for possible problems
    if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim))
        return FALSE ;

    // check for critical strike
    if (dam > 0 && dt >= TYPE_HIT && ch != victim)
    {
        if ((dam2 = critical_strike (ch, victim, dam)) != 0) dam = dam2 ;
    }

    //
    // immune/resist/vuln stuff
    //

    resists_modify(&dam, check_immune(victim, dam_type), TRUE);

    weapon = get_eq_char (ch, WEAR_WIELD);

    // material checks
    if (weapon != NULL && ch->fighting && dam > 0
    && weapon->pIndexData->item_type == ITEM_WEAPON
    && dam_type == attack_table[weapon->value[3]].damage)
    {
        if (check_material(weapon, "silver"))
            resists_modify(&dam, check_immune(ch->fighting, DAM_SILVER), TRUE);
        else if (check_material(weapon, "iron")
        || check_material(weapon, "steel"))
            resists_modify(&dam, check_immune(ch->fighting, DAM_IRON), TRUE);
        else if (check_material(weapon, "wood"))
            resists_modify(&dam, check_immune(ch->fighting, DAM_WOOD), TRUE);
    }

    // special check for immune
    if (is_immune(victim, dam_type))
    {
        dam = 0;
        immune = TRUE;
    }

    //
    // damage modifiers (from this point we can only decrease damage)
    //

    dam_mod = 0 ; // how much we must subtract from the initial damage

    if (dam > 0)
    {
        // fire shield check
        if ((shield = get_eq_char (victim, WEAR_ABOUT)) != NULL &&
            shield->pIndexData->vnum == OBJ_VNUM_FIRE_SHIELD    &&
            dt >= TYPE_HIT                                      &&
            ch != victim                                        &&
            number_bits (1) == 0)
        {
            int dam_sh = number_range (dam / 16, dam / 4);

            // type of shield
            if (shield->ed != NULL
            && strstr (mlstr_mval(shield->ed->description), "cold") != NULL)
            {
                act("$n   ,   .",
                    ch, NULL, victim, TO_VICT | ACT_VERBOSE);

                act("   ,   $N.",
                    ch, NULL, victim, TO_CHAR | ACT_VERBOSE);

                damage (victim, ch, dam_sh, gsn_fire_shield, DAM_COLD, TRUE);
            }
            else
            {
                act("$n   ,   .",
                    ch, NULL, victim, TO_VICT | ACT_VERBOSE);

                act("   ,   $N.",
                    ch, NULL, victim, TO_CHAR | ACT_VERBOSE);

                damage (victim, ch, dam_sh, gsn_fire_shield, DAM_FIRE, TRUE);
            }
        }

        if (is_affected(victim, gsn_thornsaura)
        && dt >= TYPE_HIT
        && ch != victim
        && number_bits (1) == 0)
        {
            int dam_ta = number_range (dam / 10, dam / 2);

            if (IS_NPC(ch)) dam_ta *= 2;

            act("Your thorn's aura hits $n!",
                ch, NULL, victim, TO_VICT | ACT_VERBOSE);

            act("$N's thorn's aura hits you.",
                ch, NULL, victim, TO_CHAR | ACT_VERBOSE);

            damage (victim, ch, dam_ta, gsn_thornsaura, DAM_PIERCE, TRUE);

            check_improve(ch, gsn_thornsaura, TRUE, 1);
        }

        if (is_affected(victim, gsn_immolation)
        && dt >= TYPE_HIT
        && ch != victim)
        {
            int dam_im = number_range (dam / 2, dam * 6 / 5);

            if (!IS_NPC(ch)) dam_im /= 2;

            if (victim->mana < dam_im / 2)
            {
                affect_strip(victim, gsn_immolation);
                char_act("Immolation aura leaves you.", victim);
                act("Immolation aura leaves $N.", ch, NULL, victim, TO_CHAR);
            } else
            {
                act("Your immolation burns $n!",
                    ch, NULL, victim, TO_VICT | ACT_VERBOSE);
                act("$N's immolation burns you.",
                    ch, NULL, victim, TO_CHAR | ACT_VERBOSE);
                damage (victim, ch, IS_NPC(ch) ? dam_im*2 : dam_im,
                    gsn_immolation, DAM_FIRE, TRUE);
                victim->mana -= dam_im / 2;
            }
            check_improve(ch, gsn_immolation, TRUE, 1);
        }

        clan = CLAN (victim->clan);

        // only one of the sanctuary or black shroud can affect
        // but not for clan that hates magic (Inquisitors), since
        // they have 'resistance' skill that is checked below
        // They always reduce weapon damage (even raided)
        // and reduce magical, when affected by proper sn.

        if (number_percent () < get_skill (ch, gsn_weapon_use) / 3
        && dt > TYPE_HIT && ch != victim && IS_NPC(victim))
        {
            check_improve (ch, gsn_weapon_use, TRUE, 3);

            act("You use weapon at maximum!",
                ch, NULL, NULL, TO_CHAR | ACT_VERBOSE);
            act("$n uses weapon at maximum!",
                ch, NULL, victim, TO_VICT | ACT_VERBOSE);
            act("$n uses weapon at maximum!",
                ch, NULL, victim, TO_NOTVICT | ACT_VERBOSE);
        } else
        {
            check_improve (ch, gsn_weapon_use, FALSE, 3);

            if (!clan || !IS_SET (clan->flags, CLAN_HATE_MAGIC))
            {
                if (IS_AFFECTED (victim, AFF_SANCTUARY)
                || IS_AFFECTED (victim, AFF_BLACK_SHROUD))
                    dam_mod += dam / 2 ;
                else
                    if (IS_AFFECTED (victim, AFF_PROTECTION))
                    dam_mod += dam * 2 / 5 ;
            } else
            {
                // only resistance     40%
                // only forcecage      40%
                // both                50%
                if (dam_type <= 3 || IS_AFFECTED (victim, AFF_RESISTANCE))
                {
                    dam_mod +=  dam * 2 / 5 ;
                    if (IS_AFFECTED (victim, AFF_PROTECTION)) // psionics
                       dam_mod += dam / 10;
                } else
                {
                    if (IS_AFFECTED (victim, AFF_PROTECTION)) //forcecage
                        dam_mod += dam * 2 / 5;
                }
            }
        }

        // extra protection to Wanted members of Chaos clan.
        if (is_affected(victim, sn_lookup("aura of chaos"))
        && IS_SET (victim->plr_flags, PLR_WANTED))
            dam_mod += dam / 5 ;

        if (IS_AFFECTED (victim, AFF_PROTECT_EVIL) && IS_EVIL (ch))
        {
            // neutral can't use protection in the full manner
            if (IS_NEUTRAL (victim)) dam_mod += dam / 10 ;
            else                     dam_mod += dam /  5 ;
        }

        if (IS_AFFECTED (victim, AFF_PROTECT_GOOD) && IS_GOOD (ch))
        {
            // neutral can't use protection in the full manner
            if (IS_NEUTRAL (victim)) dam_mod += dam / 10 ;
            else                     dam_mod += dam /  5 ;
        }

        if (is_affected (victim, gsn_protection_heat) && (dam_type == DAM_FIRE))
            dam_mod += dam / 5 ;

        if (is_affected (victim, gsn_protection_cold) && (dam_type == DAM_COLD))
            dam_mod += dam / 5 ;

        // field check...
        if (is_affected (victim, gsn_field)
        && dt < TYPE_HIT && ch != victim)
        {
            act("Your field works!",
                victim, NULL, NULL, TO_CHAR | ACT_VERBOSE);
            act("$n's field works!",
                victim, NULL, ch, TO_VICT | ACT_VERBOSE);
            act("$n's field works!",
                victim, NULL, ch, TO_NOTVICT | ACT_VERBOSE);

            check_improve (ch, gsn_field, TRUE, 3);

            switch (number_range (0, 2))
            {
            case 0: dam_mod += dam / 6 ; break ;
            case 1: dam_mod += dam / 5 ; break ;
            case 2: dam_mod += dam / 4 ; break ;
            }
        }

        // aplly modifier
        dam -= dam_mod ;
        if (dam < 0) dam = 0 ;
    }

    // check for possible problems
    if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim))
        return FALSE ;

    // GM : psi_att
    if (!IS_NPC(ch) && HAS_SKILL(ch, gsn_psionics)
    && ch->psi_att != -1 && dam > 10)
    {
        char_printf(ch, "adam = %d, ", dam);
        if (ch->psi_att == gsn_mental_trance)
        {
            if (dt < TYPE_HIT)
            {
                dam += dam;
                char_printf(ch, "M ");
            } else
            {
                dam += dam / 6;
                char_printf(ch, "P ");
            }
        }
        if (ch->psi_att == gsn_attack_aura)
        {
            if (dt < TYPE_HIT)
            {
                dam += dam / 4;
                char_printf(ch, "M ");
            } else
            {
                dam += dam / 4;
                char_printf(ch, "P ");
            }
        }
        if (ch->psi_att == gsn_martial_trance)
        {
            if (dt < TYPE_HIT)
            {
                dam += dam / 6;
                char_printf(ch, "M ");
            } else
            {
                dam += dam;
                char_printf(ch, "P ");
            }
        }
        char_printf(ch, "adam = %d : ", dam);
    }

    // GM : psi_def
    if (!IS_NPC(victim) && HAS_SKILL(victim, gsn_psionics)
    && victim->psi_def != -1 && dam > 10)
    {
        char_printf(victim, "ddam = %d, ", dam);
        if (victim->psi_def == gsn_power_shift)
        {
            if (dt < TYPE_HIT)
            {
                dam = dam * 60 / 100;
                char_printf(ch, "M ");
            } else
            {
                dam = dam * 20 / 100;
                char_printf(ch, "P ");
            }
        }
        if (victim->psi_def == gsn_defence_aura)
        {
            if (dt < TYPE_HIT)
            {
                dam = dam * 40 / 100;
                char_printf(ch, "M ");
            } else
            {
                dam = dam * 40 / 100;
                char_printf(ch, "P ");
            }
        }
        if (victim->psi_def == gsn_subjective_reality)
        {
            if (dt < TYPE_HIT)
            {
                dam = dam * 20 / 100;
                char_printf(ch, "M ");
            } else
            {
                dam = dam * 60 / 100;
                char_printf(ch, "P ");
            }
        }
        char_printf(victim, "ddam = %d : ", dam);
    }

    // max damage from player to player for normal hit
    if (dt >= TYPE_HIT && !IS_NPC(ch) && !IS_NPC(victim))
        dam = URANGE (0, dam, 2000);

    if (!IS_NPC(ch))
    {
        /* Damage reduction */
        if (dam > 50)
            dam = (dam - 50) * 3 / 4 + 50;

        if (dam > 150)
            dam = (dam - 150) * 3 / 4 + 150;
    }

    // show damage message
    if (IS_SET (dam_flags, DAMF_SHOW))
        dam_message (ch, victim, dam, dt, immune, dam_type);

    if (dam == 0) return FALSE ;

    if (dt >= TYPE_HIT && ch != victim)
        check_eq_damage (ch, victim, loc);

    // hurt the victim
    // inform the victim of his new state

    // Mana shield
    if (is_affected (victim, sn_lookup ("mana shield")))
    {
        act("Your mana shield devours damage!",
            victim, NULL, NULL, TO_CHAR);
        act("$n's mana shield devours damage!",
            victim, NULL, ch, TO_ROOM);
        victim->mana -= dam * 8;
        if (victim->mana <= 0)
        {
            victim->hit += victim->mana;
            victim->mana = 0;

            // shield off when no mana left
            char_act("Your mystical shield fades away.", victim);
            act("$n's mystical shield fades away.",
                victim, NULL, NULL, TO_ROOM);

            affect_strip (victim, sn_lookup ("mana shield"));
        }
    }
    else
    victim->hit -= dam ;

    // do not kill immortals completely
    if (IS_IMMORTAL (victim) && victim->hit < 1) victim->hit = 1 ;

    update_pos (victim);

    // samurai stuff
    if (!IS_NPC (ch) && get_skill (ch, gsn_fury) > 0) check_fury (victim);

    // message based on position
    switch (victim->position)
    {
    case POS_MORTAL:
        if (dam_type == DAM_HUNGER || dam_type == DAM_THIRST) break ;

        act("$n is mortally wounded, and will die soon, if not aided.", victim, NULL, NULL, TO_ROOM);
        char_act("You are mortally wounded, and will die soon, if not aided.", victim);
        break ;

    case POS_INCAP:
        if (dam_type == DAM_HUNGER || dam_type == DAM_THIRST) break ;

        act("$n is incapacitated and will slowly die, if not aided.", victim, NULL, NULL, TO_ROOM);
        char_act("You are incapacitated and will slowly die, if not aided.", victim);
        break ;

    case POS_STUNNED:
        if (dam_type == DAM_HUNGER || dam_type == DAM_THIRST) break ;

        act("$n is stunned, but will probably recover.", victim, NULL, NULL, TO_ROOM);
        char_act("You are stunned, but will probably recover.", victim);
        break ;

    case POS_DEAD:

        act("$n is DEAD!!", victim, 0, 0, TO_ROOM);
        char_act("You have been KILLED!!\n", victim);
        break ;

    default:
        if (dam_type == DAM_HUNGER || dam_type == DAM_THIRST) break ;

        if (dam > victim->max_hit / 4)
            char_act("That really did HURT!", victim);

        if (victim->hit < victim->max_hit / 4)
            char_act("You sure are BLEEDING!", victim);

        break ;
    }

    // sleep spells and extremely wounded folks
    if (!IS_AWAKE(victim)) stop_fighting (victim, FALSE);

    // payoff for killing things
    if (victim->position == POS_DEAD)
    {
        handle_death (ch, victim);
        return TRUE ;
    }

    if (victim == ch) return TRUE ;

    // autoflee/autorecall for disconnected ppl
    if (!IS_NPC(victim) && victim->desc == NULL)
    {
        if (number_range (0, victim->wait) == 0)
        {
            if (victim->level < 10) do_recall (victim, str_empty);
            else                    do_flee   (victim, str_empty);
            return TRUE ;
        }
    }

    // wimp out?
    if (IS_NPC (victim) && dam > 0 && victim->wait < PULSE_VIOLENCE / 2)
    {
        flag64_t act = victim->pIndexData->act ;

        if ((IS_SET (act, ACT_WIMPY)
        && number_bits (2) == 0
        && victim->hit < victim->max_hit / 5)

        || (IS_AFFECTED (victim, AFF_CHARM)
        && victim->master != NULL
        && victim->master->in_room != victim->in_room)

        || (IS_AFFECTED (victim, AFF_FEAR)
        && !IS_SET(act, ACT_NOTRACK)))
        {
            do_flee (victim, str_empty);
            victim->last_fought = NULL ;
        }
    }

    if (!IS_NPC (victim) && victim->hit > 0
    && !IS_SET (victim->in_room->room_flags, ROOM_BATTLE_ARENA)
    && ((victim->hit <= victim->wimpy && !IS_SAMURAI(victim))
    || IS_AFFECTED (victim, AFF_FEAR))
    && !IS_RAFFECTED(victim->in_room, RAFF_PREVENT)
    && (victim->wait < PULSE_VIOLENCE / 2)
    && !victim->daze)
        do_flee (victim, str_empty);

    return TRUE ;
}

//
// do single hit
//
void one_hit (CHAR_DATA * ch,       // source of attack
              CHAR_DATA * victim,   // desitation of attack
              int dt,               // damage type
              int loc)              // location of the item used in attack
{
    OBJ_DATA * wield, * wield2, * armor ;

    int victim_ac, thac0, thac0_00, thac0_32 ;
    int dam, dam_type, dam_flags, group, dam_mod, dr ;
    int sn, sn2, sk, sk2, chance ;

    bool result   = FALSE,
    already_hit   = FALSE,
    instant_bonus = FALSE ;

    sn    = -1 ;
    group = 0  ;

    // Just in case
    if (victim == ch     ||
        ch     == NULL   ||
        victim == NULL   ||
        JUST_KILLED (ch) ||
        JUST_KILLED (victim)) return ;

    // can't beat a dead char!
    // guard against weird room-leavings.
    //ch->position are necessary.
    if (victim->position == POS_DEAD ||
            ch->position == POS_DEAD ||
            ch->in_room  != victim->in_room) return ;

    // there are two basic groups of attacks
    if (dt == gsn_backstab       ||
        dt == gsn_dual_backstab  ||
        dt == gsn_ambush         ||
        dt == gsn_assassinate    ||
        dt == gsn_charge         ||
        dt == gsn_charge_set     ||
        dt == gsn_vampiric_bite  ||
        dt == gsn_cleave         ||
        dt == gsn_circle         ||
        dt == gsn_iaitsu)
        group = 1 ;

    if (dt == gsn_flurry         ||
        dt == gsn_cross_slice    ||
        dt == gsn_pincer         ||
        dt == gsn_bleed          ||
        dt == gsn_undercut       ||
        dt == gsn_drumming_maces ||
        dt == gsn_restrike       ||
        dt == gsn_boneshatter    ||
        dt == gsn_choke)
        group = 2 ;

    // special charge set check
    // if victim is not fighting and is affected by charge set
    // then he can possibly stop your attack by charging you back
    // however it must be awaken and must see his opponent and
    // must be mounted to use spear/lance/polearm

    //If character hit of victim by charge set or
    //   assassinate or cleave or backstab or dual_backstab
    //   or iaitsu then character can't using charge set
    if (is_affected (victim, gsn_charge_set) &&
        victim->fighting == NULL &&
        dt != gsn_charge_set     &&
        dt != gsn_assassinate    &&
        dt != gsn_backstab       &&
        dt != gsn_cleave         &&
        dt != gsn_dual_backstab  &&
        dt != gsn_iaitsu         &&
        can_see (victim, ch)     &&
        (victim->position == POS_SITTING ||
         victim->position == POS_STANDING))
    {
        // get item victim is wielding
        // only primary wielded spear/lance/polearm can be used

        wield = get_eq_char (victim, WEAR_WIELD);

        // must wield spear/lance/polearm
        if (wield != NULL &&
            (wield->value[0] == WEAPON_SPEAR   ||
             wield->value[0] == WEAPON_POLEARM ||
             wield->value[0] == WEAPON_LANCE))
        {
            // calculate chance
            chance = get_skill (victim, gsn_charge_set) * 8 / 10 ;

            if (number_percent() < chance)
            {
                act("$n      "
                    "  $gn{} !",  victim, NULL, ch, TO_VICT);

                act("       $N.",
                    victim, NULL, ch, TO_CHAR);

                // inflict damage
                one_hit (victim, ch, gsn_charge_set, WEAR_WIELD);
                check_improve (victim, gsn_charge_set, TRUE, 3);
                return ;
            } else
            {
                act("   $N  ,  .",
                    victim, NULL, ch, TO_CHAR);

                check_improve (victim, gsn_charge_set, FALSE, 1);
            }
        }
    }

    //
    // start checking for missing the target
    //

    // figure out the type of damage message
    // based on the item specified in loc argument
    wield     = get_eq_char  (ch, loc);
    dam_type  = get_dam_type (ch, wield, &dt);

    if (!IS_NPC(ch) && wield == NULL)
    {
        if (ch->style == STYLE_TIGER)
            dam_type = DAM_SLASH;
        else if (ch->style == STYLE_COBRA)
            dam_type = DAM_PIERCE;
    }

    dam_flags = DAMF_SHOW ;
    if (loc == WEAR_SECOND_WIELD) dam_flags |= DAMF_SECOND ;

    // get the weapon skill
    sn = get_weapon_sn    (wield)  ;
    sk = get_weapon_skill (ch, sn);

    if (is_affected(ch, sn_lookup("combat mind")))
    {
        sk = sk * 11 / 10;
        if (sn == gsn_hand_to_hand
        && is_affected(ch, sn_lookup("mind focusing")))
            sk = sk * 12 / 11;
    }

    if (sn == gsn_bow
    && !IS_OBJ_STAT(wield, ITEM_INDESTRUCTABLE)
    && loc == WEAR_WIELD)
    {
        if ((wield->condition -= 1) < 1)
        {
            act("The $P{x breaks into pieces.", ch, NULL, wield, TO_CHAR);
            act("$n's $P{x breaks into pieces.", ch, NULL, wield, TO_ROOM);
            extract_obj (wield);
            return ;
        }
    }

    // calculate to-hit-armor-class-0 versus armor

    if (IS_NPC (ch))
    {
        // non-pc mobile processing

        flag64_t act = ch->pIndexData->act ;

        thac0_00 = 20 ;
        thac0_32 = -4 ; // basically as good as thief

        // modify to-hit-armor-class based on real mobile act

        if (IS_SET (act, ACT_WARRIOR)) thac0_32 = -10 ;
        else
            if (IS_SET (act, ACT_THIEF))   thac0_32 = -4  ;
        else
            if (IS_SET (act, ACT_CLERIC))  thac0_32 = 2   ;
        else
            if (IS_SET (act, ACT_MAGE))    thac0_32 = 6   ;
    }
    else
    {
        // pc character processing
        // read thac from class data

        class_t * cl ;
        if ((cl = class_lookup (ch->class)) == NULL) return ;

        thac0_00 = cl->thac0_00 ;
        thac0_32 = cl->thac0_32 ;
    }

    // interpolate thac from 32 level to the real level of mobile
    thac0  = interpolate (LVL (ch), thac0_00, thac0_32);

    // modifiers due to hit roll and strength
    thac0 -= str_app[get_curr_stat(ch, STAT_STR)].tohit ;
    thac0 -= ch->hitroll / 3 ;

    // get type of AC to use to block the attack
    switch (dam_type)
    {
    case DAM_PIERCE: victim_ac = GET_AC (victim,AC_PIERCE) ; break ;
    case DAM_BASH:   victim_ac = GET_AC (victim,AC_BASH)   ; break ;
    case DAM_SLASH:  victim_ac = GET_AC (victim,AC_SLASH)  ; break ;
    default:         victim_ac = GET_AC (victim,AC_EXOTIC) ; break ;
    }

    // chance to miss (always between 5% and 55% except for special skills)
    chance = 0 ;

    // if attacker can't see victim
    if (!can_see (ch, victim))
    {
        // check if he is skilled in blind fighting
        // and then increase chance slightly, otherwise there is 20% of miss
        // always

        if ((sk2 = get_skill (ch, gsn_blind_fighting))
        && number_percent() < sk2)
        {
            chance += number_range (0, 20);
            check_improve (ch, gsn_blind_fighting, TRUE, 16);
        }
        else chance += 20 ;
    }

    // modify due to position
    if (victim->position < POS_FIGHTING) chance -= 6 ;
    if (victim->position < POS_RESTING)  chance -= 10 ;

    // modify chance due to AC
    // i do not really understand what is going on here :) (c) Illinar

    if (victim_ac > -100)
    {
        chance -= (victim_ac + 100) / 10 ;
        victim_ac = -100 ;
    }

    if (thac0 > -5)
    {
        chance += thac0 + 5 ;
        thac0 = -5 ;
    }

    thac0     = -thac0 ;
    victim_ac = -victim_ac ;
    sk2       = victim_ac / thac0 ;

    chance += sk2;
    while (sk2 > 4)
    {
        sk2    /= 2   ;
        chance += sk2 ;
    }

    // modify chance due to luck
    chance += get_curr_stat (victim, STAT_LCK) - get_curr_stat (ch, STAT_LCK);
    chance  = URANGE (5 , chance, 55);

    // extra armor checking
    armor = get_eq_char (victim, WEAR_BODY);

    // armor use skill (at most 20% extra to chance)
    if ((sk2 = get_skill (victim, gsn_armor_use)) != 0 && armor != NULL)
    {
        chance += sk2 * armor->level /
                  (5 * ((wield == NULL) ? UMAX(10, LVL (ch)) :
                        UMAX(10, wield->level)));
    }

    // for special kinds of attacks (see above) chance to miss is smaller
    if (group == 1) chance /= 4 ;
    if (group == 2) chance /= 2 ;

    // the moment of excitement
    if (number_percent () < chance && ch != victim)
    {
        if (armor != NULL && number_percent () < (40 + armor->level / 3))
        {
            act("$n  $gn{}   !",  ch, NULL, victim, TO_VICT | ACT_VERBOSE);
            act("  $gn{}   $c1{$N!}",    ch, NULL, victim, TO_CHAR | ACT_VERBOSE);

            check_improve   (victim, gsn_armor_use, TRUE, 10);
            check_eq_damage (ch, victim, loc);

            dam_flags = FALSE ;
        } else
            check_improve   (victim, gsn_armor_use, FALSE, 10);


        // call to damage to display miss message
        damage (ch, victim, 0, dt, dam_type, dam_flags);
        return ;
    }

    //
    // instant kill skills goes here (assassinate, vorpal, ...)
    //

    // special iaitsu attack
    if (dt == gsn_iaitsu && wield != NULL && !IS_IMMORTAL (victim)
    && !is_affected(ch, gsn_iaitsu))
    {
        AFFECT_DATA af;
        af.where     = TO_AFFECTS;
        af.type      = gsn_iaitsu;
        af.duration  = number_fuzzy(1);
        af.level     = ch->level;
        af.bitvector = 0;
        af.location  = APPLY_NONE;
        af.modifier  = 0;
        affect_to_char (ch, &af);

        // chance of iaitsu instant kill. change by your taste
        chance = 5;

        if (IS_PUMPED (ch))
            chance -= 5;

        if (IS_NPC(victim))
            chance += 20;

        if (IS_AFFECTED (victim, AFF_CHARM))
            chance += 10;

        if (wield->value[0] != WEAPON_SWORD)
            chance = 0;
        else if (IS_WEAPON_STAT (wield, WEAPON_KATANA))
            chance += 5;

        chance = URANGE (3, chance + (LVL (ch) - LVL (victim)) * 2, 10);

        if (number_percent () < chance * get_skill (ch, gsn_iaitsu) / 100)
        {
            check_improve (ch, gsn_iaitsu, TRUE, 1);

            act_puts("  $N !",
                ch, NULL, victim, TO_CHAR, POS_RESTING);
            act_puts("$n   !",
                ch, NULL, victim, TO_VICT, POS_RESTING);
            act_puts("$n   $N!",
                ch, NULL, victim, TO_NOTVICT, POS_RESTING);
            char_act("You have been KILLED!!", victim);
            act("$n is DEAD!!", victim, NULL, NULL, TO_ROOM);

            WAIT_STATE (ch, 2);
            victim->position = POS_DEAD ;
            handle_death (ch, victim);
            return;
        }
        else
        {
            check_improve (ch, gsn_iaitsu, FALSE, 1);
            instant_bonus = TRUE ;
        }
    }

    // special cleave attack
    if (dt == gsn_cleave && wield != NULL && !IS_IMMORTAL (victim))
    {
        // basic chance (upto 15%)
        chance = URANGE(2, 5 + LVL(ch) - LVL(victim), 10) + // level bonus
                 (wield->value[0] == WEAPON_AXE) ? 2 : 0  + // axe bonus
                 (get_curr_stat (ch, STAT_STR) - 21) / 2  + // str bonus
                 is_spec (ch, SPEC_AXE);                    // spec bonus

        // extra bonus (upto 10%)
        if (number_percent() < 50 && IS_NPC(victim))
            chance += number_percent () / 10 ;

        if (IS_NPC(victim))
            chance *= 2;

        if (number_percent() < chance)
        {
            check_improve (ch, gsn_cleave, TRUE, 1);

            act_puts("Your cleave chops $N IN HALF!",
                ch, NULL, victim, TO_CHAR, POS_RESTING);
            act_puts("$n's cleave chops you IN HALF!",
                ch, NULL, victim, TO_VICT, POS_RESTING);
            act_puts("$n's cleave chops $N IN HALF!",
                ch, NULL, victim, TO_NOTVICT, POS_RESTING);
            char_act("You have been KILLED!!", victim);
            act("$n is DEAD!!", victim, NULL, NULL, TO_ROOM);

            WAIT_STATE (ch, 2 * PULSE_VIOLENCE);

            victim->position = POS_DEAD ;
            handle_death   (ch, victim);
            return ;
        }
        else
        {
            check_improve (ch, gsn_cleave, FALSE, 1);
            instant_bonus = TRUE ;
        }
    }

    // assasinate
    if (dt == gsn_assassinate)
    {
        // chance can be maximum 40% on PC
        chance = URANGE (2, 10 + (LVL(ch) - LVL(victim)) * 2, 40);

        // and maximum 80% on NPC
        if (IS_NPC(victim))
            chance *= 2;

        if (number_percent() < chance && !IS_IMMORTAL(victim))
        {
            check_improve (ch, gsn_assassinate, TRUE, 1);

            act_puts("You {R+++ASSASSINATE+++{x $N!",
                ch, NULL, victim, TO_CHAR, POS_RESTING);
            act_puts("$n {R+++ASSASSINATES+++{x $N!",
                ch, NULL, victim, TO_NOTVICT, POS_RESTING);
            act_puts("$n {R+++ASSASSINATES+++{x you!",
                ch, NULL, victim, TO_VICT, POS_DEAD);
            char_act("You have been KILLED!!", victim);
            act("$n is DEAD!!", victim, NULL, victim, TO_ROOM);

            victim->position = POS_DEAD;
            handle_death (ch, victim);
            return;
        } else
        {
            check_improve (ch, gsn_assassinate, FALSE, 1);
            instant_bonus = TRUE ;
        }
    }

    // vorpal and special weapons
    if (wield != NULL           && // must wield weapon
        !IS_IMMORTAL   (victim) && // can't kill immortal
        !IS_CLAN_GUARD (victim) && // and clan guards as well
        !IS_SET (victim->abilities, EA_IMMUN_VORPAL) && // charmies with this ability

        // vorpal or special weapon
        (is_spec (ch, sn)                      ||
         IS_WEAPON_STAT (wield, WEAPON_VORPAL) ||
         (dt < TYPE_HIT && IS_OBJ_STAT (wield, ITEM_DEATH))))
    {
        char buf [256], buf2 [256] ;

        // chance to kill depends on weapon skill and strength
        // basic value is around 200
        chance  = sk + get_curr_stat (ch, STAT_STR) * 4 ;
        chance += (LVL (ch) - LVL (victim)) * 2 ;

        // chance is larger for vorpal weapons
        chance += IS_WEAPON_STAT (wield, WEAPON_VORPAL) ? 100 : 0;

        // make chance smaller
        chance /= 30 ;

        // for player victim chance is smaller
        if (!IS_NPC (victim)) chance /= 3 ;

        // modifiers and damage messages for different kinds of weapons
        switch (wield->value[0])
        {
        case WEAPON_MACE:
            strnzcpy(buf, sizeof(buf),  "$p   $n ,   !");
            strnzcpy(buf2, sizeof(buf2), "$p    !     ,  -?");

            if (dt == gsn_drumming_maces) chance *= 2 ;
            break ;

        case WEAPON_FLAIL:
        case WEAPON_WHIP:
            strnzcpy(buf, sizeof(buf),  "$p   $n    !     $n   - .");
            strnzcpy(buf2, sizeof(buf2), "$p       !     ,  -?");

            if (dt == gsn_choke) chance *= 3 ;
            break ;

        case WEAPON_DAGGER:
            strnzcpy(buf, sizeof(buf),  "$p  $n       ! $n    .");
            strnzcpy(buf2, sizeof(buf2), "$p         !    .");

            if (dt == gsn_circle) chance *= 3 ;
            break ;

        case WEAPON_SPEAR:
        case WEAPON_LANCE:
            strnzcpy(buf, sizeof(buf),  "$p  $n ! $n     .");
            strnzcpy(buf2, sizeof(buf2), "$p   ! ,  .");

            if (dt == gsn_charge)     chance *= 3 ;
            if (dt == gsn_charge_set) chance *= 3 ;
            break ;

        default:
            strnzcpy(buf, sizeof(buf),  "$p         $n  !");
            strnzcpy(buf2, sizeof(buf2), "$p         !     ,  -?");

            if (dt == gsn_iaitsu)      chance *= 4 ;
            if (dt == gsn_cleave)      chance *= 3 ;
            if (dt == gsn_cross_slice) chance *= 2 ;
            break ;
        }

        if (number_range (1, 40000) < chance)
        {
            act(buf,  victim, wield, NULL, TO_ROOM);
            act(buf2, victim, wield, NULL, TO_CHAR);

            act("$n is DEAD!!", victim, NULL, NULL, TO_ROOM);
            char_act("You have been KILLED!!", victim);

            victim->position = POS_DEAD ;
            handle_death   (ch, victim);
            return ;
        }
    }

    //
    // start damage calculations and hit the victim
    //

    if (IS_NPC (ch) && wield == NULL)
    {
        // default damage calculation for mobile
        dam = dice (ch->damage [DICE_NUMBER], ch->damage [DICE_TYPE]);

        // todo - normalize damage depending on mobile level to avoid
        // extremely large damage from NPC
    } else
    {
        // improvement for weapon skill
        if (sn != -1) check_improve (ch, sn, TRUE, 5);

        if (wield != NULL)
        {
            //
            // damage by weapon
            //

            // if this weapon is wielded in the second hand
            // damage is slightly smaller
            if (loc == WEAR_SECOND_WIELD) sk = sk * 4/5 ;
            else if ((get_eq_char (ch, WEAR_SHIELD) == NULL) &&
                    (wield->value[0] != WEAPON_LANCE))
            {
                // if attacker does not wear shield
                // damage is slightly bigger
                if (loc == WEAR_WIELD)
                {
                    sk = sk * 105 / 100 ;

                    // katana and two-handed weapons can do more damage
                    // if it is the only weapon wielded
                    // or it two of two handed weapon

                    wield2 = get_eq_char(ch, WEAR_SECOND_WIELD);

                    if (((IS_WEAPON_STAT (wield, WEAPON_TWO_HANDS)
                    || IS_WEAPON_STAT (wield, WEAPON_KATANA))
                    && (get_eq_char (ch, WEAR_SECOND_WIELD) == NULL))
                    || (IS_WEAPON_STAT (wield, WEAPON_TWO_HANDS)
                    && wield2 && IS_WEAPON_STAT (wield2, WEAPON_TWO_HANDS)))
                    {
                        sk = sk * 130 / 100 ;

                        // additional damage if left hand is empty
                        if (get_eq_char (ch, WEAR_HOLD) == NULL)
                            sk = sk * 110 / 100 ;
                    }
                }
            }

            // base damage from average of the weapon
            dam = dice (wield->value[1], wield->value[2]) * sk / 100 ;

            // sharp weapons can do extra damage
            // multiplier 2 -- 2.9

            if (IS_WEAPON_STAT (wield, WEAPON_SHARP))
            {
                int percent = number_percent ();

                if (percent <= (sk / 8)) dam *= 2 ;
                if (percent <= (sk / 6)) dam += dam * percent / 100 ;
                if (percent <= (sk / 4)) dam += dam * percent / 100 ;
            }

            // extra damage for holy weapon against evil character

            if (IS_WEAPON_STAT (wield, WEAPON_HOLY) &&
                IS_GOOD (ch)     &&
                IS_EVIL (victim) &&
                number_percent () < 30)
            {
                act("$n's flesh is burned with the holy aura of $p.",
                    victim, wield, NULL, TO_ROOM | ACT_VERBOSE);
                act_puts("Your flesh is burned with the holy aura of $p.",
                    victim, wield, NULL, TO_CHAR | ACT_VERBOSE, POS_RESTING);

                dam += dam * 11 / 10 ;
            }

            // lightsaber spec
            if (wield->value[0] == WEAPON_LIGHTSABER
            && (number_range(0, 300) < get_skill(ch, sn_lookup("saberoffense"))))
            {
                dam = dam * 12 / 10 ;
                check_improve(ch, sn_lookup("saberoffense"), TRUE, 1);
            } else
                check_improve(ch, sn_lookup("saberoffense"), FALSE, 1);


            // decrease damage if character is not specialized in that weapon
            if (!is_spec (ch, sn)) dam = dam * 10 / 11 ;
            else                   dam = dam * 11 / 10 ;
        }
        else
        {
            //
            // damage by hands
            //
            dam = number_range (150 + 6 * sk, LVL(ch) * sk) / 225 ;

            // extra damage for Druid and Beastmaster w/o weapon
            if (number_percent () < get_skill (ch, gsn_beast_power))
            {
                dam = dam * 2 ;
                check_improve (ch, gsn_beast_power, TRUE, 6);
                if (number_percent () < LVL(ch))
                {
                    if (number_percent () < 60)
                    {
                        dam = dam * 2 ;
                    }
                    else if (number_percent () < 40)
                    {
                        dam = dam * 4 ;
                    }
                    else if (number_percent () < 20)
                    {
                        dam = dam * 6 ;
                        DAZE_STATE (victim, PULSE_VIOLENCE * 1);
                    }
                    else
                        check_improve (ch, gsn_beast_power, FALSE, 1);
                }
            }
            // extra damage for ninja's
            if (number_percent () < (get_skill (ch, gsn_kung_fu) / 4))
            {
                dam = dam * 7 / 3 ;
                check_improve (ch, gsn_kung_fu, TRUE, 6);
            }
            else if (number_percent () < (get_skill (ch, gsn_ninjitsu)))
            {
                dam = dam * 2 ;
                check_improve (ch, gsn_ninjitsu, TRUE, 6);
            }
        }
    }

    // bonus due to damroll
    dr = GET_DAMROLL (ch);
    if (IS_NPC(ch) && IS_SET(ch->pIndexData->act, ACT_RECEIVE_LEVEL) && 
        (!IS_NPC(victim) || (IS_NPC(victim) && IS_SET(victim->pIndexData->act, ACT_CLAN_GUARD))))
        dr /= 5;

    dam += dr * sk / 100 ;

    //
    // bonuses
    //

    dam_mod = 0 ;

    // strength bonus (around -5% +12% bonus)
    dam_mod += dam * (get_curr_stat (ch, STAT_STR) - 20) / 40 ;

    // enhanced damage bonus (upto +25% bonus)
    if ((sk2 = get_skill (ch, gsn_enhanced_damage))
    && number_percent () <= sk2)
    {
        dam_mod += dam * sk2 / 400 ;
        check_improve (ch, gsn_enhanced_damage, TRUE, 6);
    }

    //
    // specializations for weapons and weapon clan skills
    //

    if (wield != NULL && sn != gsn_bow && sn != gsn_arrow)
    {
        // mastering axe
        // some warriors can also learn mastering in axe which enables them
        // to hit more powerful with axes

        if (!already_hit && sn == gsn_axe
        && (sk2 = get_skill (ch, gsn_mastering_axe)) > 1
        && is_specialized (ch, SPEC_AXE))
        {
            if (number_percent() <= (sk2 / 2))
            {
                act("$n   ,   !",
                    ch, NULL, victim, TO_VICT | ACT_VERBOSE);
                act("   ,  $N !",
                    ch, NULL, victim, TO_CHAR | ACT_VERBOSE);
                act("$n   ,  $N !",
                    ch, NULL, victim, TO_NOTVICT | ACT_VERBOSE);

                if (ch->class != CLASS_WARRIOR)
                    dam_mod    += dam / 4;
                else
                    dam_mod    += dam;
                already_hit = TRUE;

                check_improve (ch, gsn_mastering_axe, TRUE, 1);
            } else
                check_improve (ch, gsn_mastering_axe, FALSE, 1);
        }

        // mastering weapon
        // warrior (and only they) can master themselves in different
        // weapons, using the weapon warrior is specialized he can inflict
        // more damage

        if (!already_hit
        && (sk2 = get_skill (ch, gsn_mastering_weapon)) > 1
        && is_spec (ch, sn))
        {
            chance = number_percent ();

            // when skill is badly practiced all damages
            // can be lesser, however even for good practiced skill
            // there is a chance of bad strike, but a small one

            if (chance > sk2 || chance < (sk2 / 10))
            {
                act("    !",
                    ch, NULL, NULL, TO_CHAR | ACT_VERBOSE);
                act("$n    !",
                    ch, NULL, victim, TO_VICT | ACT_VERBOSE);
                act("$n    !",
                    ch, NULL, victim, TO_NOTVICT | ACT_VERBOSE);

                dam_mod    -= dam / 5 ;
                already_hit = TRUE ;

                check_improve (ch, gsn_mastering_weapon, TRUE, 1);
            }
            else if (chance < (sk2 / 2))
            {
                act("    !",
                    ch, NULL, NULL, TO_CHAR | ACT_VERBOSE);
                act("$n    !",
                    ch, NULL, victim, TO_VICT | ACT_VERBOSE);
                act("$n    !",
                    ch, NULL, victim, TO_NOTVICT | ACT_VERBOSE);

                dam_mod    += dam ;
                already_hit = TRUE ;

                check_improve (ch, gsn_mastering_weapon, TRUE, 1);
            }
            else
                check_improve (ch, gsn_mastering_weapon, FALSE, 1);
        }

        // mastering sword (kendo) for katana
        // only samurais can study mastering sword

        if (!already_hit && sn == gsn_sword
        && (sk2 = get_skill (ch, gsn_mastering_sword)) > 1
        && is_specialized (ch, SPEC_SWORD))
        {
            OBJ_DATA * katana ;

            // must wear katana in the right hand

            katana = get_eq_char (ch, WEAR_WIELD);

            // check that katana is really katana and belongs to the
            // character that is using it

            if (katana && IS_WEAPON_STAT (katana, WEAPON_KATANA)
            && katana->ed != NULL
            && strstr (mlstr_mval (katana->ed->description), ch->name))
            {
                AFFECT_DATA * paf ;

                // upgrade katana (need around 1000 hits)
                if (number_percent () < 25
                && (katana->cost = ++katana->cost % 250) == 0)
                {
                    int old_mod ;

                    for (paf = katana->affected ; paf != NULL ; paf = paf->next)
                    {
                        // upgrade hitroll
                        if (paf->location == APPLY_HITROLL)
                        {
                            old_mod = paf->modifier ;
                            paf->modifier = UMIN (paf->modifier + 1,
                                                  LVL(ch) / 3);

                            ch->hitroll += paf->modifier - old_mod ;
                        } else if (paf->location == APPLY_DAMROLL)
                        {
                            // upgrade damroll
                            old_mod = paf->modifier ;
                            paf->modifier = UMIN (paf->modifier + 1,
                                                  LVL(ch) / 3);

                            ch->damroll += paf->modifier - old_mod ;
                        }
                    }

                    act("$n's katana glows blue.", ch, NULL, NULL, TO_ROOM);
                    char_act("Your katana glows blue.", ch);
                }
            }

            if (number_percent () < (sk2 / 3))
            {
                act("   !", ch, NULL, NULL, TO_CHAR | ACT_VERBOSE);
                act("$n   !", ch, NULL, victim, TO_VICT | ACT_VERBOSE);
                act("$n   !",ch, NULL, victim, TO_NOTVICT | ACT_VERBOSE);

                dam_mod    += dam / 2 ;
                already_hit = TRUE ;

                check_improve (ch, gsn_mastering_sword, TRUE, 6);
            } else
                check_improve (ch, gsn_mastering_sword, FALSE, 6);
        }

        // holyrage (clan skill of JediKnights)
        // can be used along with mastering bonuses

        if ((sk2 = get_skill (ch, gsn_holyrage)) > 1)
        {
            if (number_percent () <= (sk2 / 4))
            {
                act("$n      !",
                    ch, NULL, victim, TO_VICT | ACT_VERBOSE);
                act("      !",
                    ch, NULL, victim, TO_CHAR | ACT_VERBOSE);
                act("$n      !",
                    ch, NULL, victim, TO_NOTVICT | ACT_VERBOSE);

                dam_mod += dam / 2 ;
                check_improve (ch, gsn_holyrage, TRUE, 4);
            } else
                check_improve (ch, gsn_holyrage, FALSE, 4);
        }

        // Roar skill
        if ((sk2 = get_skill (ch, gsn_roar)) > 1)
        {
            if (number_percent () <= (sk2 / 2))
            {
                dam_mod += dam / 2 ;
                if (IS_SET(ch->form, FORM_WOLF))
                {
                    act("$n     !", ch, NULL, victim, TO_VICT | ACT_VERBOSE);
                    act("     !", ch, NULL, victim, TO_CHAR | ACT_VERBOSE);
                    act("$n     !", ch, NULL, victim, TO_NOTVICT | ACT_VERBOSE);
                    dam_mod += dam / 4 ;
                } else if (IS_SET(ch->form, FORM_BEAR))
                {
                    act("$n     !", ch, NULL, victim, TO_VICT | ACT_VERBOSE);
                    act("     !", ch, NULL, victim, TO_CHAR | ACT_VERBOSE);
                    act("$n     !", ch, NULL, victim, TO_NOTVICT | ACT_VERBOSE);
                    dam_mod += dam / 4 ;
                } else
                {
                    act("$n     !", ch, NULL, victim, TO_VICT | ACT_VERBOSE);
                    act("     !", ch, NULL, victim, TO_CHAR | ACT_VERBOSE);
                    act("$n     !", ch, NULL, victim, TO_NOTVICT | ACT_VERBOSE);
                }
                check_improve (ch, gsn_roar, TRUE, 4);
            }
            else
                check_improve (ch, gsn_roar, FALSE, 4);
        }
    }

    // increase damage if victim is sleeping or resting
    if (!IS_AWAKE (victim))                     dam_mod += dam / 2 ;
    else if (victim->position < POS_FIGHTING)   dam_mod += dam / 4 ;

    // special base damages (from special kinds of attacks)
    if (wield != NULL)
    {
        if (dt == gsn_ambush)           dam += LVL (ch) * dam / 8  ;
        if (dt == gsn_circle)           dam += LVL (ch) * dam / 30 ;
        if (dt == gsn_backstab)         dam += LVL (ch) * dam / 6  ;
        if (dt == gsn_dual_backstab)    dam += LVL (ch) * dam / 10 ;
        if (dt == gsn_charge)           dam += LVL (ch) * dam / 6  ;
        if (dt == gsn_cleave)           dam += LVL (ch) * dam / 8  ;
        if (dt == gsn_charge_set)       dam += LVL (ch) * dam / 25 ;
        if (dt == gsn_iaitsu)
        {
            if (IS_NPC(victim))
                                        dam += LVL (ch) * dam / 15 ;
            else
                                        dam += LVL (ch) * dam / 30 ;
        }
    }

    // increased damage for vampiric bite
    if (dt == gsn_vampiric_bite && IS_SET(ch->form, FORM_VAMPIRE))
        dam += LVL (ch) * dam / 15 ;

    // bonus for instant skills
    if (instant_bonus) dam_mod += dam / 2 ;

    // outraging fishing
    if ((sk2 = get_skill (ch, gsn_outraging_fishing)) > 0)
    {
        if (is_name ("fish", victim->name))
        {
            if(number_percent () < sk2 + 2)
            {
                dam_mod += dam * number_range (1, 4) ;
                check_improve (ch, gsn_outraging_fishing, TRUE, 3);
            }
            else
                check_improve (ch, gsn_outraging_fishing, FALSE, 3);
        }
    }

    // do not use deathblow/wolfpower for special attacks
    if (group == 0)
    {
        if ((sk2 = get_skill (ch, gsn_deathblow)) > 1)
        {
            if (number_percent () < (sk2 / 3)
            && IS_NPC (victim))
            {
                act("You deliver a blow of deadly force!",  ch, NULL, NULL, TO_CHAR | ACT_VERBOSE);
                act("$n delivers a blow of deadly force!",  ch, NULL, NULL, TO_ROOM | ACT_VERBOSE);

                dam_mod += dam * number_range (1, 2);

                if (IS_AFFECTED (victim, AFF_CHARM))
                    dam_mod += dam * number_range (1, 3);

                check_improve (ch, gsn_deathblow, TRUE, 1);
            }
            else
                check_improve (ch, gsn_deathblow, FALSE, 3);
        }

        if ((sk2 = get_skill (ch, gsn_surmounting_blow)) > 1)
        {
            if (number_percent () < (sk2 / 2))
            {
                act("   !", ch, NULL, NULL, TO_CHAR | ACT_VERBOSE);
                act("$n   !",  ch, NULL, NULL, TO_ROOM | ACT_VERBOSE);

                dam_mod += dam * number_range (1, 2);

                if (IS_NPC (victim) && number_bits (1) == 0)
                    dam_mod += dam * number_range (2, 4);

                if (IS_NPC (victim) && IS_AFFECTED (victim, AFF_CHARM))
                    dam_mod += dam * number_range (2, 4);

                check_improve (ch, gsn_surmounting_blow, TRUE, 1);
            }
            else
                check_improve (ch, gsn_surmounting_blow, FALSE, 3);
        }

        // shamans' tattoes
        sk2 = sn_lookup ("hammer of heaven");
        if (check_tattoo (ch, sk2))
        {
            if (number_percent () < (get_skill (ch, sk2) / 3))
            {
                act("{CBright blue{x hammer on $n's tattoo grows.", ch, NULL, NULL, TO_ROOM | ACT_VERBOSE);
                act("{CBright blue{x hammer on your tattoo grows.", ch, NULL, NULL, TO_CHAR | ACT_VERBOSE);

                dam_mod += dam/10;
                if (IS_NPC (victim) && number_bits (1) == 0)
                    dam_mod += dam/2;
                check_improve (ch, sk2, TRUE, 1);
            }
            else
                check_improve (ch, sk2, FALSE, 3);
        }

        sk2 = sn_lookup ("curved dagger");
        if (check_tattoo (ch, sk2))
        {
            if (number_percent () < (get_skill (ch, sk2) / 2))
            {
                act("{DCurv{We{Dd{x dagger from $n's tattoo strikes $N.", ch, NULL, victim, TO_NOTVICT | ACT_VERBOSE);
                act("{DCurv{We{Dd{x dagger from your tattoo strikes $N.", ch, NULL, victim, TO_CHAR | ACT_VERBOSE);
                act("{DCurv{We{Dd{x dagger from $n's tattoo strikes you.", ch, NULL, victim, TO_VICT | ACT_VERBOSE);

                dam_mod += dam;
                if (IS_NPC (victim) && number_bits (1) == 0)
                    dam_mod += dam * 2;
                check_improve (ch, sk2, TRUE, 1);
            }
            else
                check_improve (ch, sk2, FALSE, 3);
        }
    }

    // modifiers based on classes (currently for samurais only)
    if (IS_SAMURAI(ch))
    {
        if (IS_NPC(victim))
        {
            if (IS_AFFECTED(victim, AFF_CHARM))
                dam_mod += dam * ch->level / 91;
            else
                dam_mod += dam * ch->level / 273;
        }
        else
            dam_mod += dam * ch->level / 455;
    }

    // apply modifier
    dam += dam_mod ;

    // prevent bugs with zero damage
    if (dam <= 0) dam = 1 ;

    // counter check
    // victim can possibly reverse the attack, some types of
    // attacks are harder to counter
    // to counter an attack one must not fight right now, must
    // be awaken and see the opponent

    // basic chance is around 25%
    chance = get_skill (victim, gsn_counter) / 4 ;

    // harder to counter if adrenaline is rushed
    if (IS_PUMPED (victim)) chance -= 10 ;

    if (group == 2) chance -= 5 ; // harder to counter those attacks

    if (IS_SAMURAI(ch))
        chance += 30 ;

    if (dt == gsn_ambush        ||
        dt == gsn_assassinate   ||
        dt == gsn_charge_set    ||
        dt == gsn_vampiric_bite ||
        dt == gsn_cleave        ||
        dt == gsn_circle        ||
        dt == gsn_iaitsu)
        chance  = 0 ; // impossible to counter those attacks

    if (!IS_NPC (victim)         && // no counter for NPC
        victim->fighting == NULL && // must NOT fight
        can_see (victim, ch)     && // must see the opponent

        // must be in proper position (not sleeping)
        (victim->position == POS_SITTING ||
         victim->position == POS_STANDING))
    {
        if (number_percent () < chance)
        {
            act("$N turns your attack against you!", ch, NULL, victim, TO_CHAR);
            act("You turn $n's attack against $gn{him}!", ch, NULL, victim, TO_VICT);
            act("$N turns $n's attack against $gn{him}!", ch, NULL, victim, TO_NOTVICT);

            // counter attack
            damage (victim, ch, dam, dt, dam_type, dam_flags);

            check_improve (victim, gsn_counter, TRUE, 2);

            // set fighting state
            if (ch->fighting == NULL)     ch->fighting = victim ;
            if (victim->fighting == NULL) victim->fighting = ch ;

            return;
        } else
            check_improve (victim, gsn_counter, FALSE, 1);
    }


    //
    // actual damage goes from here
    //
    result = damage (ch, victim, dam, dt, dam_type, dam_flags);


    // another check for possible problems
    if (!ch || JUST_KILLED (ch)) return ;

    // vampiric bite gives hp to ch from victim
    if (dt == gsn_vampiric_bite)
    {
        int hit_ga = UMIN ((dam / 2), victim->max_hit);

        ch->hit += hit_ga ;
        ch->hit  = UMIN (ch->hit, 2 * ch->max_hit);

        update_pos (ch);
        char_act("Your health increases as you suck your victim's blood.", ch);
    }

    // another check for possible problems
    if (!victim || JUST_KILLED(victim)) return;

    if (!result || ch->fighting != victim) return ;

    //
    // post damage processing
    //

    // set stun state to the victim
    if (wield == NULL
        && (sk2 = get_skill (ch, gsn_kung_fu)) > 1
        && number_percent() < sk2 / 8 + LVL(ch) - LVL(victim)
        && !IS_AFFECTED (victim, AFF_WEAK_STUN | AFF_STUN))
    {
        SET_BIT (victim->affected_by, AFF_WEAK_STUN);

        act_puts("You hit $N with a stunning force!",
            ch, NULL, victim, TO_CHAR, POS_RESTING);
        act_puts("$n hits you with a stunning force!",
            ch, NULL, victim, TO_VICT, POS_RESTING);
        act_puts("$n hits $N with a stunning force!",
            ch, NULL, victim, TO_NOTVICT, POS_RESTING);
        check_improve (ch, gsn_kung_fu, TRUE, 6);
    }

    // another check for possible problems
    if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim)) return ;

    // shamans' tattoo 'yellow bat'
    sn2 = sn_lookup("yellow bat");
    if (check_tattoo(ch, sn2) && number_percent() < get_skill(ch, sn2) / 5)
    {
        dam = number_range (20, LVL(ch) + 20);
        if (IS_NPC(victim))
            dam *= 3;

        act("{YYellow{x {Dbat{x on your tattoo flaps its wings and you feel it drains energy from $N.", ch, NULL, victim, TO_CHAR | ACT_VERBOSE);
        act("{YYellow{x {Dbat{x on n's tattoo flaps its wings and you feel you lose your energy.", ch, NULL, victim, TO_VICT | ACT_VERBOSE);
        act("{YYellow{x {Dbat{x on n's tattoo flaps its wings.", ch, NULL, victim, TO_NOTVICT | ACT_VERBOSE);

        damage (ch, victim, dam, 0, DAM_NEGATIVE, DAMF_NONE);
        victim->mana = UMAX(0, victim->mana - dam);

        ch->hit  += dam/2;
        ch->mana += dam/4;

        update_pos (ch);
    }

    // next features are only for weapons
    if (wield == NULL) return ;

    // deadly weapon
    if (IS_OBJ_STAT (wield, ITEM_DEATH))
    {
        //dam = number_range (3, wield->level / 4 + 4);
        dam = number_range (3, wield->level / 2 + 4);

        act("The evil power of $p torments $n.",
            victim, wield, NULL, TO_ROOM | ACT_VERBOSE);
        act("The evil power of $p torments you.",
            victim, wield, NULL, TO_CHAR | ACT_VERBOSE);

        damage (ch, victim, dam, 0, DAM_NEGATIVE, FALSE);
    }

    // another check for possible problems
    if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim)) return ;

    // weapon song
    if (IS_OBJ_STAT (wield, ITEM_SINGING))
    {
        //dam = number_range (3, wield->level / 4 + 4);
        dam = number_range (3, wield->level / 2 + 4);

        act("$p ϣ !!\n$n, ,  !",
            victim, wield, NULL, TO_ROOM | ACT_VERBOSE);
        act("$p ϣ !!\n  !",
            victim, wield, NULL, TO_CHAR | ACT_VERBOSE);

        damage(ch, victim, dam, 0, DAM_SOUND, FALSE);
    }

    // another check for possible problems
    if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim)) return ;

    // poisoned weapon
    if (IS_WEAPON_STAT (wield, WEAPON_POISON))
    {
        int level ;
        AFFECT_DATA *poison, af ;

        // determine the level of affect
        if ((poison = affect_find (wield->affected, gsn_poison)) == NULL)
            level = wield->level ;
        else
            level = poison->level ;

        if (!saves_spell (level / 2, victim, DAM_POISON))
        {
            char_act("You feel poison coursing through your veins.", victim);
            act("$n is poisoned by the venom on $p.",
                victim, wield, NULL, TO_ROOM | ACT_VERBOSE);

            af.where     = TO_AFFECTS    ;
            af.type      = gsn_poison    ;
            af.level     = level * 3 / 4 ;
            af.duration  = level / 2     ;
            af.location  = APPLY_STR     ;
            af.modifier  = -1            ;
            af.bitvector = AFF_POISON    ;

            affect_join (victim, &af);
        }

        // weaken the poison if it's temporary
        if (poison != NULL && number_percent() < 40)
        {
            poison->level    = UMAX(0, poison->level - 2);
            poison->duration = UMAX(0, poison->duration - 1);

            if (poison->level == 0 || poison->duration == 0)
                act("The poison on $p has worn off.", ch, wield, NULL, TO_CHAR);
        }
    }

    // another check for possible problems
    if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim)) return ;

    // vampiric weapon
    if (IS_WEAPON_STAT (wield, WEAPON_VAMPIRIC))
    {
        //dam = number_range (1, wield->level / 5 + 1);
        dam = number_range (1, wield->level / 3 + 1);

        act("$p draws life from $n.", victim, wield, NULL, TO_ROOM | ACT_VERBOSE);
        act("You feel $p drawing your life away.", victim, wield, NULL, TO_CHAR | ACT_VERBOSE);

        damage (ch, victim, dam, 0, DAM_NEGATIVE, DAMF_NONE);

        ch->hit += dam/2 ;
        update_pos (ch)  ;
    }

    // another check for possible problems
    if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim)) return ;

    // flaming weapon
    if (IS_WEAPON_STAT (wield, WEAPON_FLAMING))
    {
        //dam = number_range (1, wield->level / 4 + 1);
        dam = number_range (1, wield->level / 2 + 1);

        act("$n is burned by $p.", victim, wield, NULL, TO_ROOM | ACT_VERBOSE);
        act("$p sears your flesh.", victim, wield, NULL, TO_CHAR | ACT_VERBOSE);

        fire_effect (victim, wield->level / 2, dam, TARGET_CHAR);
        damage (ch, victim, dam, 0, DAM_FIRE, DAMF_NONE);
    }

    // another check for possible problems
    if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim)) return ;

    // frost weapon
    if (IS_WEAPON_STAT (wield, WEAPON_FROST))
    {
        //dam = number_range (1, wield->level / 6 + 2);
        dam = number_range (1, wield->level / 4 + 2);

        act("$p freezes $n.", victim, wield, NULL, TO_ROOM | ACT_VERBOSE);
        act("The cold touch of $p surrounds you with ice.", victim, wield, NULL, TO_CHAR | ACT_VERBOSE);

        cold_effect (victim, wield->level / 2, dam, TARGET_CHAR);
        damage (ch, victim, dam, 0, DAM_COLD, DAMF_NONE);
    }

    // another check for possible problems
    if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim)) return ;

    // shocking weapon
    if (IS_WEAPON_STAT (wield, WEAPON_SHOCKING))
    {
        dam = number_range (1, wield->level / 5 + 2);

        act("$n is struck by lightning from $p.", victim, wield, NULL, TO_ROOM | ACT_VERBOSE);
        act("You are shocked by $p.",  victim, wield, NULL, TO_CHAR | ACT_VERBOSE);

        shock_effect (victim, wield->level / 2, dam, TARGET_CHAR);
        damage (ch, victim, dam, 0, DAM_LIGHTNING, DAMF_NONE);
    }

    // another check for possible problems
    if (!ch || !victim || JUST_KILLED (ch) || JUST_KILLED (victim)) return ;

    if (IS_WEAPON_STAT (wield, WEAPON_RADIATION))
    {
        int chance_to_detect;
        dam = number_range (1, wield->level / 5 + 2);

        chance_to_detect = IS_AFFECTED (victim, AFF_DETECT_MAGIC) ? 20 : 5 ;

        if (number_percent () < chance_to_detect)
        {
            act("  -   $p.", victim, wield, NULL, TO_CHAR | ACT_VERBOSE);
        }

        radiation_effect  (victim, wield->level, TARGET_CHAR);
        damage (ch, victim, dam, 0, DAM_LIGHTNING, DAMF_NONE);
    }
}
#endif
