/* $Id: flag.h,v 1.666 2004/09/20 10:49:48 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/************************************************************************************
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 *                                                                                  *
 *  This code was written by Jason Dinkel and inspired by Russ Taylor,              *
 *  and has been used here for OLC - OLC would not be what it is without            *
 *  all the previous coders who released their source code.                         *
 *                                                                                  *
 ************************************************************************************/

#ifndef _FLAG_H_
#define _FLAG_H_

enum 
{
    TABLE_BITVAL,	/* table contains bit values */
    TABLE_INTVAL	/* table contains integer values */
};

struct flag_t
{
    const char *        name;
    flag64_t            bit;
    bool                settable;
    const char *        legend;
};

const flag_t       *    flag_lookup	(const flag_t *flag64_table, const char* name);
flag64_t                flag_value	(const flag_t *flag64_table, const char *argument);
const char         *    flag_string	(const flag_t *flag64_table, flag64_t bits);

void        show_flags_buf      (BUFFER *output, const flag_t *flag64_table);
void        show_flags          (CHAR_DATA *ch, const flag_t *flag64_table);
const char *flag_dump           (const flag_t *flag64_table, int value);

#endif

