/* $Id: force.c,v 1.666 2004/09/20 10:49:48 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "merc.h"
#include "fight.h"
#include "quest.h"
#include "rating.h"
#include "fight.h"
#include "cyborg.h"
#include "skills.h"
#include "update.h"
#include "psionics.h"

extern bool check_grounding (CHAR_DATA *ch);
extern bool check_spellbane(CHAR_DATA *ch, CHAR_DATA *victim, int sn);
extern bool check_trust(CHAR_DATA *ch, CHAR_DATA *victim);

bool dispel1      (int level, CHAR_DATA *ch, int sn);

extern const char *target_name;


/*

Idea's from GrayMage for Jedi.

[   79] [===]=========== [   80] a lightsaber     [   81] a lightsaber [   83] a lightsaber  [90] dress   [   99] a lightsaber

#define OBJ_VNUM_R_LIGHTSABER   79
#define OBJ_VNUM_B_LIGHTSABER   80
#define OBJ_VNUM_G_LIGHTSABER   81
#define OBJ_VNUM_M_LIGHTSABER   83
#define OBJ_VNUM_W_LIGHTSABER   90
#define OBJ_VNUM_Y_LIGHTSABER   99


Padawan -  ... !   ,   .
Jedi
Jedi Knight
Jedi Master

gsn_lightsaber ...  gsn_sword .

  :

saberthrow -  ...   .      ...
saberoffense -   -   ...
saberdefense -  ...   -,   ...

Attack Kata - ...  ...
Ground Stab -     ...    ,     ... :)
Rolling Stab -    ...      ...   ...   ... .

Pull Slash -   -  (pull)       ݣ .
Lunge Attack -   ...  pull slash  cartwheel
Cartwheel -    ...     ...

    .   -   ...      .
              .

*/

// GM: Force Pull -  .      -.   .
// Pull Slash -   -  (pull)    .
SPELL_FUN(spell_force_pull)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;
    int chance = 0;
    int nhits, dam;
    OBJ_DATA * wield;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (victim == ch->fighting)
    {
        char_act("You don't need to pull him!", ch);
        return;
    }

    // force pull damage
    dam = number_range(level*12, level*18);

    if (saves_spell(level, victim, DAM_MAGIC))
        dam /= 2;

    damage(ch, victim, dam, sn, DAM_MAGIC, TRUE);

    if (JUST_KILLED(victim) || victim == ch)
        return;

    // pull slash chance and damage
    wield = get_eq_char (ch, WEAR_WIELD);

    chance = get_skill(ch, gsn_pull_slash);

    chance += get_skill(ch, gsn_lightsaber) / 10;
    chance += (LVL (ch) - LVL (victim)) * 4 ;
    chance += (get_curr_stat(ch, STAT_LCK) - get_curr_stat(victim, STAT_LCK)) * 2 ;
    
    level += level / 10;

    if (saves_spell(level, victim, DAM_MAGIC))
        chance /= 2;

    if (IS_NPC(victim))
        chance *= 2;

    // pull chance
    if (number_percent() < chance) 
    {
        ch->fighting = victim;

        act("$n force pull $N!", ch, NULL, victim, TO_NOTVICT);
        act("You force pull $N!", ch, NULL, victim, TO_CHAR);
        act("$n force pull you!", ch, NULL, victim, TO_VICT);

        // pull slash
        if (!is_affected(ch, gsn_pull_slash)
        && wield && wield->value[0] == WEAPON_LIGHTSABER)
        {
            af.where     = TO_AFFECTS;
            af.type      = gsn_pull_slash;
            af.level     = level;
            af.duration  = 0;
            af.location  = 0;
            af.modifier  = 0;
            af.bitvector = 0;
            affect_to_char(ch, &af);

            nhits = UMAX(1, LVL(ch) / 18);

            while (nhits--)
            {
                char_act("Pull Slash -  ! ?", ch);
                one_hit(ch, ch->fighting, TYPE_UNDEFINED, WEAR_WIELD);
            }

            check_improve(ch, gsn_pull_slash, TRUE, 4);
        } else
        {
            check_improve(ch, gsn_pull_slash, FALSE, 8);
        }
    }
    return;
}

// GM: force push - ...  ,  ...    
//      .. :)
SPELL_FUN(spell_force_push)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    AFFECT_DATA af;
    int door;
    EXIT_DATA *pexit;

    if ((door = check_exit(target_name)) == -1) 
    {
        char_act("What direction (west south east north down up)?.", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("You are too tired for force push.", ch);
        return;
    }

    //  ,  , ...
    if (IS_SET(ch->in_room->room_flags, ROOM_BATTLE_ARENA))
    {
        char_act("You can't use force push here.", ch);
        return;
    }

    if ((pexit = ch->in_room->exit[door])
    && IS_SET(pexit->exit_info, EX_ISDOOR))
    {
        if (IS_SET(pexit->exit_info, EX_CLOSED))
        {
            char_act("The door is closed.", ch);
            return;
        }
        if (IS_SET(pexit->exit_info, EX_LOCKED))
        {
            char_act("The door is locked.", ch);
            return;
        }
    }

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe(ch, vch)
        || IS_IMMORTAL(vch)
        || IS_RAFFECTED(vch->in_room, RAFF_ESPIRIT)
        || (IS_NPC(vch) && IS_SET(vch->pIndexData->act, ACT_NOTRACK))
        || (!IS_NPC(vch) && vch->desc == NULL)
        || is_same_group(ch, vch)
        || vch == ch)
            continue;

        if (IS_AFFECTED(vch, AFF_WEB))
        {
            act_puts("You attempt to push $n, but the webs hold $gn{him} in place.",
                vch, NULL, ch, TO_VICT, POS_DEAD);
            act_puts("$N attempts to push $n, but fails as the webs hold $n in place.",
                vch, NULL, ch, TO_NOTVICT, POS_RESTING);
            continue;
        }
        if (number_percent() > 26 && !IS_IMMORTAL(ch))
        {
            do_yell(vch, "Die! Jedy!");
            agent_net_printf(vch, ch, ANET_ATTACK);
            one_hit(vch, ch, TYPE_HIT, WEAR_WIELD);
            continue;
        }

        if (check_spellbane(ch, vch, sn))
            continue;
    
            // 
        act("You push $N to $t.", ch, dir_name[door], vch, TO_CHAR | ACT_TRANS);
        act("$n pushes you to $t.", ch, dir_name[door], vch, TO_VICT | ACT_TRANS);
        act("$n pushes $N to $t.", ch, dir_name[door], vch, TO_NOTVICT | ACT_TRANS);
        move_char(vch, door, FALSE);
    
    }

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 2;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    af.bitvector    = 0;
    affect_to_char(ch, &af);
}

// GM: Force Jump - ...  ? AFF_FLY ???
SPELL_FUN(spell_force_jump)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_FLYING)
    || is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("But you in force jump already.", ch);
        else
            act("But $N force jump already!", ch, NULL, victim, TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 10;
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = AFF_FLYING;
    affect_to_char(victim, &af);

    char_act("You are ready for force jump.", victim);
    act("$n getting ready for force jump.", victim, NULL, NULL, TO_ROOM);
}

// GM: force speed - ... ... ... ... AFF_HASTE ???
SPELL_FUN(spell_force_speed)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_SLOW))
    {
        if (IS_AFFECTED(victim, AFF_HASTE))
            level *= 2;
        dispel1(level, victim, gsn_slow);
    }
    if (IS_AFFECTED(victim, AFF_HASTE))
    {
        if (victim == ch)
            char_act("     !", ch);
        else
            act("$N    ,   .",
                ch, NULL, victim, TO_CHAR);
        return;
    }

    if (!check_trust(ch, victim) && saves_spell(level, victim, DAM_MAGIC))
    {
        if (victim != ch)
            char_act("  .", ch);
        act("You feel yourself boosted for a moment.",
            victim, NULL, NULL, TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    if (victim == ch)
      af.duration  = level / 4;
    else
      af.duration  = level / 6;
    af.location  = APPLY_DEX;
    af.modifier  = UMAX(2, level / 12);
    af.bitvector = AFF_HASTE;
    affect_to_char(victim, &af);
    char_act("    !", victim);
    act("$n    .",victim,NULL,NULL,TO_ROOM);
    if (ch != victim)
        char_act("Ok.", ch);
    return;

}

// GM: force grip -   ԣ -     - !
SPELL_FUN(spell_force_grip)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;
    AFFECT_DATA af;
    AFFECT_DATA af2;

    level = level + level / 4;

    if (IS_UNDEAD(victim) || IS_CYBORG(victim))
    {
        act("Force grip will not work on $N!", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("It is impossible to use this force so frequently!", ch);
        return;
    }

    // GM :     .
    if (IS_CLAN_GUARD (victim) || IS_IMMORTAL(victim))
    {
        char_act("Something prompts you, that it will fail!", ch);
        return;
    }

    if (!IS_AFFECTED(victim, AFF_SUFFOCATE))
    {
        if (saves_spell(level, victim, DAM_NEGATIVE))
        {
            dam = number_range(level*12, level*18);

            if (saves_spell(level, victim, DAM_MAGIC))
                dam /= 2;

            damage(ch, victim, dam, sn, DAM_MAGIC, TRUE);
        } else
        {
            af.where     = TO_AFFECTS;
            af.type      = sn;
            af.level     = level * 3/4;
            af.duration  = 3 + level / 30;
            af.location  = APPLY_NONE;
            af.modifier  = 0; 
            af.bitvector = AFF_SUFFOCATE;
            affect_join(victim, &af);

            act("You cannot breathe.",
                victim, NULL, NULL, TO_CHAR);
            act("$n tries to breathe, but cannot.", 
                victim, NULL, NULL, TO_ROOM);
            return;
        }
    } else
    {
        if (IS_AFFECTED(victim, AFF_SLEEP))
        {
            act("$N already for a long time without consciousness!", 
                ch, NULL, victim, TO_CHAR);
            return;
        }
/*       ...
        if (is_affected (victim, gsn_insomnia))
        {
            dispel1(level, victim, gsn_insomnia);
            if (is_affected (victim, gsn_insomnia))
            {
                act("But $N cannot lose consciousness.", ch, NULL, victim, TO_CHAR);
                return;
            }
        }   
*/
        if (victim->fighting)
        {
            char_act("It is rather difficult to lull the one who battles.", ch);
            return;
        }

        af2.where     = TO_AFFECTS;
        af2.type      = gsn_sleep;
        af2.level     = level;
        af2.duration  = 2;
        af2.location  = APPLY_NONE;
        af2.modifier  = 0;
        af2.bitvector = AFF_SLEEP;
        affect_join(victim, &af2);

        if (IS_AWAKE(victim))
        {
            char_act("From lack of oxygen you lose consciousness .", victim);
            act("From lack of oxygen $n loses consciousness.", victim, NULL, NULL, TO_ROOM);
            victim->position = POS_SLEEPING;
        }

        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = 4;
        af.location  = 0;
        af.modifier  = 0;
        af.bitvector = 0;
        affect_to_char(ch, &af);

    }
    return;
}

// GM: force lightning -   ...   ,    
//     -  ޣ? :) -   !
SPELL_FUN(spell_force_lightning)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = number_range(level*12, level*18);

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe(ch, vch)
        || IS_IMMORTAL(vch)
        || vch == ch)
            continue;

        if (ch == vch->fighting || is_same_group(ch, vch->fighting))
        {
            if (check_grounding(vch))
                continue;

            if (check_spellbane(ch, vch, sn))
                continue;
    
            if (saves_spell(level, vch, DAM_LIGHTNING))
            {
                shock_effect(vch, level / 2, dam / 4, TARGET_CHAR);
                damage(ch, vch, dam / 2, sn, DAM_LIGHTNING, TRUE);
            } else
            {
                shock_effect(vch, level, dam, TARGET_CHAR);
                damage(ch, vch, dam, sn, DAM_LIGHTNING, TRUE);
            }
        }
    }
}

// GM: force sense - ...    .
//   .      ,  .
SPELL_FUN(spell_force_sense)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        char_act("Force sense allready with you.",ch);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (5 + level / 3);
    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = AFF_DETECT_EVIL;
    affect_to_char(victim, &af);

    af.bitvector = AFF_DETECT_GOOD;
    affect_to_char(victim, &af);

    af.bitvector = AFF_DETECT_MAGIC;
    affect_to_char(victim, &af);

    af.bitvector = AFF_DETECT_UNDEAD;
    affect_to_char(victim, &af);

/* GM :   -...  ...
    if (number_percent() < (get_skill(ch, gsn_XXX))) 
    {
        check_improve(ch, gsn_XXX, TRUE, 4);
        af.bitvector = AFF_DETECT_LIFE;
        affect_to_char(victim, &af);
        af.bitvector = AFF_DETECT_HIDDEN;
        affect_to_char(victim, &af);
        af.bitvector = AFF_DETECT_IMP_INVIS;
        affect_to_char(victim, &af);
    }
*/

    char_act("Force sense feels you.", victim);

    if (ch != victim)
        char_act("Ok.", ch);
    return;
}

SPELL_FUN(spell_laserweapon)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    int sword_vnum;
    OBJ_DATA *sword;

    if (obj->pIndexData->vnum != OBJ_VNUM_R_GEMS
    && obj->pIndexData->vnum != OBJ_VNUM_B_GEMS
    && obj->pIndexData->vnum != OBJ_VNUM_G_GEMS
    && obj->pIndexData->vnum != OBJ_VNUM_M_GEMS
    && obj->pIndexData->vnum != OBJ_VNUM_W_GEMS
    && obj->pIndexData->vnum != OBJ_VNUM_Y_GEMS)
    {
        char_act("You must have unique gems for this.", ch);
        return;
    } 

    sword_vnum = 0;

    if (obj->pIndexData->vnum == OBJ_VNUM_R_GEMS)
        sword_vnum = OBJ_VNUM_R_LIGHTSABER;
    if (obj->pIndexData->vnum == OBJ_VNUM_B_GEMS)
        sword_vnum = OBJ_VNUM_B_LIGHTSABER;
    if (obj->pIndexData->vnum == OBJ_VNUM_G_GEMS)
        sword_vnum = OBJ_VNUM_G_LIGHTSABER;
    if (obj->pIndexData->vnum == OBJ_VNUM_M_GEMS)
        sword_vnum = OBJ_VNUM_M_LIGHTSABER;
    if (obj->pIndexData->vnum == OBJ_VNUM_W_GEMS)
        sword_vnum = OBJ_VNUM_W_LIGHTSABER;
    if (obj->pIndexData->vnum == OBJ_VNUM_Y_GEMS)
        sword_vnum = OBJ_VNUM_Y_LIGHTSABER;

    sword = create_obj(get_obj_index(sword_vnum), level);
    sword->cost     = 0;
    sword->value[1] = 3 + ch->level / 10;
    sword->value[2] = 4 + ch->level / 15;
    sword->owner    = str_dup(ch->name);
    sword->level    = ch->level;

    if (IS_GOOD(ch))
        SET_BIT(sword->extra_flags,(ITEM_ANTI_NEUTRAL | ITEM_ANTI_EVIL));
    else if (IS_NEUTRAL(ch))
        SET_BIT(sword->extra_flags,(ITEM_ANTI_GOOD | ITEM_ANTI_EVIL));
    else if (IS_EVIL(ch))
        SET_BIT(sword->extra_flags,(ITEM_ANTI_NEUTRAL | ITEM_ANTI_GOOD));

    act("Your $p disappears.", ch, obj, NULL, TO_CHAR);
    obj_from_char(obj);
    obj_to_char(sword, ch);

    act("You have successfully made $p!", ch, sword, NULL, TO_CHAR);
    act("$n have successfully made $p!", ch, sword, NULL, TO_ROOM);
}
