/* $Id: gambling.c,v 1.666 2004/09/20 10:49:48 shrike Exp $                           */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/************************************************************************************
 *   . .   ,  .                  *
 *   Ideas by: Aseroth, Shrike, code by: Aseroth.                                   *
 ************************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "merc.h"
#include "log.h"
#include "gambling.h"

#define MAX_STR_DEBUG_CONST MAX_STRING_LENGTH

CardDesc DeckDescription[54] = 
{
    { "separator",         "spr",     "" },
    { " {D{x",    "{DS2{x",  "" },
    { " {D{x",    "{DS3{x",  "" },
    { "ף {D{x",  "{DS4{x",  "" },
    { "ԣ {D{x",   "{DS5{x",  "" },
    { "ԣ {D{x",  "{DS6{x",  "" },
    { "ͣ {D{x",   "{DS7{x",  "" },
    { "ͣ {D{x", "{DS8{x",  "" },
    { " {D{x",   "{DS9{x",  "" },
    { " {D{x",   "{DS10{x", "" },    
    { " {D{x",     "{DSJ{x",  "" },
    { " {D{x",      "{DSQ{x",  "" },
    { " {D{x",    "{DSK{x",  "" },
    { " {D{x,",      "{DSA{x",  "" },

    { " {R{x",    "{RH2{x",  "" },
    { " {R{x",    "{RH3{x",  "" },
    { "ף {R{x",  "{RH4{x",  "" },
    { "ԣ {R{x",   "{RH5{x",  "" },
    { "ԣ {R{x",  "{RH6{x",  "" },
    { "ͣ {R{x",   "{RH7{x",  "" },
    { "ͣ {R{x", "{RH8{x",  "" },
    { " {R{x",   "{RH9{x",  "" },
    { " {R{x",   "{RH10{x", "" },    
    { " {R{x",     "{RHJ{x",  "" },
    { " {R{x",      "{RHQ{x",  "" },
    { " {R{x",    "{RHK{x",  "" },
    { " {R{x,",      "{RHA{x",  "" },

    { " {M{x",    "{MD2{x",  "" },
    { " {M{x",    "{MD3{x",  "" },
    { "ף {M{x",  "{MD4{x",  "" },
    { "ԣ {M{x",   "{MD5{x",  "" },
    { "ԣ {M{x",  "{MD6{x",  "" },
    { "ͣ {M{x",   "{MD7{x",  "" },
    { "ͣ {M{x", "{MD8{x",  "" },
    { " {M{x",   "{MD9{x",  "" },
    { " {M{x",   "{MD10{x", "" },    
    { " {M{x",     "{MDJ{x",  "" },
    { " {M{x",      "{MDQ{x",  "" },
    { " {M{x",    "{MDK{x",  "" },
    { " {M{x,",      "{MDA{x",  "" },

    { " {x{x",    "{xC2{x",  "" },
    { " {x{x",    "{xC3{x",  "" },
    { "ף {x{x",  "{xC4{x",  "" },
    { "ԣ {x{x",   "{xC5{x",  "" },
    { "ԣ {x{x",  "{xC6{x",  "" },
    { "ͣ {x{x",   "{xC7{x",  "" },
    { "ͣ {x{x", "{xC8{x",  "" },
    { " {x{x",   "{xC9{x",  "" },
    { " {x{x",   "{xC10{x", "" },    
    { " {x{x",     "{xCJ{x",  "" },
    { " {x{x",      "{xCQ{x",  "" },
    { " {x{x",    "{xCK{x",  "" },
    { " {x{x,",      "{xCA{x",  "" }
};


CardDeck* CreateDeck(int DeckType)
{
    CardDeck* cd;
    cd = malloc(sizeof(CardDeck));

    cd->capacity = INITIAL_DECK_SIZE;
    cd->content = malloc(sizeof(cards)*cd->capacity);
    cd->count = 0;

    cd->visible = TRUE;
   
    cd->DeckType = DeckType;
    cd->DeckID = 0;

    FillDeckByCards(cd);
    return cd;
}
    
    
CardHand* CreateHand(CardDeck* deck)
{
    CardHand* ch;
    ch = malloc(sizeof(CardHand));

    ch->capacity = INITIAL_HAND_SIZE;
    ch->content = malloc(sizeof(cards)*ch->capacity);
    ch->count = 0;

    ch->DeckID = deck->DeckID;
 
    return ch;
}  

CardTable* CreateTable(CardDeck* deck)
{
    CardTable* ct;
    ct = malloc(sizeof(CardTable));
   
    ct->capacity = INITIAL_TABLE_SIZE;
    ct->content = malloc(sizeof(TableCard)*ct->capacity);
    ct->count = 0;
    
    ct->DeckID = deck->DeckID;

    return ct;
}

/*
// Transfer operations.
// 0 -- succesfull
// 1 -- non-matching deckID
// 2 -- --
// 5 -- memory management error
*/
cards CardFromHand(int card, CardHand* hand)
{
    int j;
    cards c;
    
    //c = NULL; 
    c = '\0';

    if (card >= hand->count) 
    {
        log("CARDS: CardFromHand invalid index");
        return c;
    }

    c = hand->content[card];

            // shifting all cards one position left
            for (j = card; j < hand->count-1; j++)
            {
                hand->content[j] = hand->content[j+1];
            }
            --(hand->count);

  
    return c;
}

void CardToHand(cards card, CardHand* hand)
{
    if (hand->count == hand->capacity)
    {
        log("CARDS: lazy fucking immortales, realloc memory in CardToHand!");
        return;
    }
    hand->content[hand->count] = card;
    ++(hand->count);

    return;
}      

TableCard CardFromTable(int card, CardTable* table)
{
    int j;
    TableCard tc;

    if (card >= table->count) 
    {
        log("CARDS: CardFromTable: invalid index");
        return tc;
    }
 
    tc = table->content[card];
    // shifting all cards one position left
    for (j = card; j < table->count-1; j++)
    {
        table->content[j] = table->content[j+1];
    }
    --(table->count);

    return tc;
}

void CardToTable(TableCard card, int pos, CardTable* table)
{
    int i;

    if (table->count == table->capacity)
    {
        log("CARDS: lazy fucking immortales, realloc memory in CardToTable!");
        return;
    }

    if (pos > table->count)
    {
        log("CARDS: CardToTable: invalid index");
        return;
    }

    ++(table->count);
    for (i = table->count-1; i > pos; i--)
    {
        table->content[i] = table->content[i-1];
    }
    table->content[pos] = card;

    return;
}


void CardToDeck(cards card, int position, CardDeck* deck)
{
    int i;

    if (deck->count == deck->capacity)
    {
        log("CARDS: lazy fucking immortales, realloc memory in CardToTable!");
        return;
    }

    ++(deck->count);
    for (i = deck->count-1; i > position; i--)
    {
        deck->content[i] = deck->content[i-1];
    }

    deck->content[position] = card;
    return;
}

cards CardFromDeck(int card, CardDeck* deck)
{
    int j;
    cards rc;
    
    //rc = NULL;
    rc = '\0';

    if (card >= deck->count) 
    {
        log("CARDS: CardFromDeck: invalid index");
        return rc;
    }

    if (deck->count == 0) 
    {
        log("CARDS: CardFromDeck: invalid call when count == 0");
        return rc;
    }


    rc = deck->content[card];
    --(deck->count);   
    if (deck->count == 0) 
        return rc;

    // shifting all cards one position left
    for (j = card; j < deck->count; j++)
    {
        deck->content[j] = deck->content[j+1];
    }
   
    return rc;
}


void FillDeckByCards(CardDeck* cd)
{
    int i;

    switch(cd->DeckType)
    {
        case 0:         // cheating, yea, it is!
        {
            for (i = 1; i < 53; i++)
                CardToDeck((cards)i, cd->count, cd);
            break;
        }
    }
}

void CardCover(int hc, int tc, CardTable* table, CardHand* hand, int orient)
{
    TableCard ctt;  // card to table

    ctt.card =  CardFromHand(hc, hand);;
    ctt.visible = TRUE;
    ctt.position = orient;
    
    CardToTable(ctt, tc+1, table);
    return;
}

void CardLayFromHand(int hc, CardHand* hand, int pos,  CardTable* table, 
             bool vis, int orient)
{
    TableCard tc;


    tc.visible = vis;
    tc.position = orient;

    //   
    tc.card = 0;
    CardToTable(tc, pos, table);
    
    tc.card = hand->content[hc];
    CardFromHand(hc, hand);    
    CardToTable(tc, pos, table);

    return;
};

void CardLayFromDeck(int dc, CardDeck* deck, int pos,  CardTable* table, 
             bool vis, int orient)
{
    TableCard tc;


    tc.visible = vis;
    tc.position = orient;

    //   
    tc.card = 0;
    CardToTable(tc, pos, table);
    
    tc.card = CardFromDeck(dc, deck);    
    CardToTable(tc, pos+1, table);

    return;
};


// format operations
void VisualiseDeck(CardDeck* deck, BUFFER* buf)
{
    int i;
    char buffer[MAX_STR_DEBUG_CONST] = "\0";
    char cardName[MAX_STR_DEBUG_CONST] = "\0";

    for (i = 0; i < deck->count; i++)
    {
        strnzcat(buffer, sizeof(buffer), " ");
        VisualiseCard(deck->content[i], 1, 0, cardName, sizeof(cardName));
        strnzcat(buffer, sizeof(buffer), cardName);
    }
    strnzcat(buffer, sizeof(buffer), "\n");
    buf_add(buf, buffer);
 
    return;
}

void VisualiseHand(CardHand* hand, BUFFER* buf)
{
    int i;
    char buffer[MAX_STR_DEBUG_CONST] = "\0";
    char cardName[MAX_STR_DEBUG_CONST] = "\0";

    for (i = 0; i < hand->count; i++)
    {
        strnzcat(buffer, sizeof(buffer), " ");
        VisualiseCard(hand->content[i], 1, 0, cardName, sizeof(cardName));
        strnzcat(buffer, sizeof(buffer), cardName);
    }
    strnzcat(buffer, sizeof(buffer), "\n");
    buf_add(buf, buffer);
    return;
}

void VisualiseTable(CardTable* table, BUFFER* buf)
{
    int i;
    char buffer[MAX_STR_DEBUG_CONST] = "\0";
    char cardName[MAX_STR_DEBUG_CONST] = "\0";

    for (i = 0; i < table->count; i++)
    {
        if ((table->content[i].card) == 0)
        {
            strnzcat(buffer, sizeof(buffer), "\n");
            buf_add(buf, buffer);
            sprintf(buffer,str_empty);
            continue;
        }

        VisualiseCard(table->content[i].card, 1, 0, cardName, sizeof(cardName));
        strnzcat(buffer, sizeof(buffer), cardName);
        strnzcat(buffer, sizeof(buffer), " ");
    }

    return;
}


void VisualiseCard(cards card, int key, int DeckType, char* buf, int max)
{
    switch(key)
    {
        case 0: 
        {
            snprintf(buf, max, "%s", DeckDescription[(int)card].longName);
            break;
        }
        case 1: 
        {
            snprintf(buf, max, "%s", DeckDescription[(int)card].shortName);
            break;
        }
        case 2:
        {
            snprintf(buf, max, "%s", DeckDescription[(int)card].graphics);
            break;
        }
    }
    return;
}
