/*   $Id: gambling.h,v 1.666 2004/09/20 10:49:48 shrike Exp $                        */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/************************************************************************************
 *   . .   ,  .                  *
 *   Ideas by: Aseroth, Shrike, code by: Aseroth.                                   *
 ************************************************************************************/

#ifndef GAMBLING_H
#define GAMBLING_H

#define MAX_DECK_CARDS 127  // maximum cards in da deck (hardcoded limit)

#define MAX_HAND_CARDS 54   // i wouldn't mess with the memory management. NOW
#define MAX_TABLE_CARDS 54*2

#define INITIAL_DECK_SIZE   MAX_HAND_CARDS
#define INITIAL_TABLE_SIZE  MAX_HAND_CARDS
#define INITIAL_HAND_SIZE   MAX_HAND_CARDS

#define DECK_TYPES_COUNT 1

struct sCardDesc
{
    char* longName;
    char* shortName;
    char* graphics;
};
typedef struct sCardDesc CardDesc;
    

/*
#define SUITS_COUNT 4
char* suits[SUITS_COUNT] =
{
  "spade",
  "heart",
  "diamond",
  "club"
}
*/

typedef char cards;

struct sCardHand
{
  cards* content;
  int capacity;
  int count;

  int DeckID;
};
typedef struct sCardHand CardHand;

struct sCardDeck
{
  cards* content;      
  int capacity;
  int count;

  bool visible;

  int DeckType;
  int DeckID;
};
typedef struct sCardDeck CardDeck;

struct sTableCards
{
  cards card;
  bool visible;

  // 0 -- normal, 1 -- covers last card, 2 -- lays across last
  int position; 
};
typedef struct sTableCards TableCard;

struct sCardTable
{
  TableCard* content;
  int count;
  int capacity;

  int DeckID;
};
typedef struct sCardTable CardTable;

CardDeck* CreateDeck(int DeckType);
CardHand* CreateHand(CardDeck* deck);
CardTable* CreateTable(CardDeck* deck);

void DisposeDeck(CardDeck* deck);
void DisposeHand(CardHand* hand);
void DisposeTable(CardTable* table);

// lowest level card operations
cards CardFromHand(int card, CardHand* hand);
void CardToHand(cards card, CardHand* hand);

TableCard CardFromTable(int card, CardTable* table);
void CardToTable(TableCard card, int pos, CardTable* table);

void CardToDeck(cards card, int position, CardDeck* deck);
cards CardFromDeck(int card, CardDeck* deck);

// Transfer operations (mid-level card op)
// 0 -- succesfull
// 1 -- card not found
// 2 -- card not accessible
// 3 -- invalid deck
// 5 -- memory management error

// this logic gottabemov'd to the command parsing level, not card management
//int TransferTable2Hand(cards card, CardTable table, CardHand hand);
//int TransferDeck2Hand(cards card, CardDeck deck, CardHand hand);
void CardCover(int hc, int tc, CardTable* table, CardHand* hand, int orient);
void CardLayFromHand(int hc, CardHand* hand, int pos,  CardTable* table, 
             bool vis, int orient);
void CardLayFromDeck(int dc, CardDeck* deck, int pos,  CardTable* table, 
             bool vis, int orient);

// query operations
bool CardInHand(cards card, CardHand hand);
bool CardInDeck(cards card, CardDeck deck);

// 0 -- present, can take, 1 -- not present, 2 -- not visible
int CardOnTable(cards card, CardTable table);

// format operations
void VisualiseDeck(CardDeck* deck, BUFFER* buf);
void VisualiseHand(CardHand* hand, BUFFER* buf);
void VisualiseTable(CardTable* table, BUFFER* buf);


void VisualiseCard(cards card, int key, int DeckType, char* buf, int max);

// fill da deck
void FillDeckByCards(CardDeck* cd);

CardTable* pct;
CardHand* pch;
CardDeck* pcd;

#endif
