/* $Id: gquest.h,v 1.666 2004/09/20 10:49:48 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/* Part of this code is based on WoM's (World of Merlin) code */

#ifndef __SRC_GQUEST_H
#define __SRC_GQUEST_H

#include "typedef.h"

typedef struct gq_questdata GQ_QUESTDATA ;
typedef struct gq_questplr  GQ_QUESTPLR  ;
typedef struct gq_master    GQ_MASTER    ;
typedef struct gq_cmd       GQ_CMD       ;

// ----------------------------------------------------------------------
// GQ data for single quest
// ----------------------------------------------------------------------
struct gq_questdata
{
    GQ_QUESTDATA* next         ; // next in chain

    int*          mobs         ; // mobile vnums
    int*          rooms        ; // room mobile was last seen
    int*          count        ; // count for each mobile

    int           level_min    ; // minimal level for participant
    int           level_max    ; // maximal level for participant
    int           ticks_left   ; // ticks left for the quest
    int           ticks_total  ; // total time for the quest
    int           ticks_start  ; // ticks to start the quest
    int           mob_count    ; // mobiles count (size of arrays)
    int           mob_total    ; // mobiles total
    int           plr_count    ; // number of players
    int           type         ; // quest type (0 - room, 1 - area)

    GQ_QUESTPLR*  plr          ; // list of players
} ;

// ----------------------------------------------------------------------
// GQ data for single quest participant
// ----------------------------------------------------------------------
struct gq_questplr
{
    GQ_QUESTPLR*  next         ; // next in chain
    GQ_QUESTDATA* quest        ; // ptr to the quest data
    char*         name         ; // name of the player
    int           killed_total ; // number of total killed mobiles
    int*          killed_count ; // count killed
    int           complete     ; // ticks to complete
} ;

// ----------------------------------------------------------------------
// master structure to track GQ information
// ----------------------------------------------------------------------
struct gq_master
{
    GQ_QUESTDATA* quests       ; // currently active quest
    int           enable       ; // enable/disable indicator
    int           ticks_next   ; // ticks to the next autoquest
} ;

// ----------------------------------------------------------------------
// command table
// ----------------------------------------------------------------------
struct gq_cmd
{
    char*        name         ; // command name
    int          flags        ; // command flags
    int          min_pos      ; // minimal position to use
    DO_FUN*      fun          ; // command function
} ;

#define GQCMD_IMMONLY       (A) // immortals only
#define GQCMD_RUNONLY       (B) // participants only

// ----------------------------------------------------------------------
// functions
// ----------------------------------------------------------------------
GQ_QUESTDATA* gq_generate   (int, int, int) ;
GQ_QUESTPLR*  gq_newplayer  (GQ_QUESTDATA*, CHAR_DATA*) ;
void          gq_freequest  (GQ_QUESTDATA*) ;
void          gq_freeplr    (GQ_QUESTPLR*)  ;
void          gq_showinfo   (GQ_QUESTDATA*, const char*, ...) ;
GQ_QUESTPLR*  gq_findplr    (CHAR_DATA*)    ;
GQ_QUESTDATA* gq_findquest  (CHAR_DATA*)    ;
CHAR_DATA*    gq_findchar   (const char*)   ;
bool          is_gquest_mob (CHAR_DATA*)    ;
void          gq_mobdeath   (CHAR_DATA*, CHAR_DATA*) ;
void          gq_update     () ;
void          gq_givebonus  (CHAR_DATA*, bool) ;
int           gq_count      ();

DECLARE_DO_FUN (do_gquest)   ;
DECLARE_DO_FUN (gq_join)     ;
DECLARE_DO_FUN (gq_cancel)   ;
DECLARE_DO_FUN (gq_list)     ;
DECLARE_DO_FUN (gq_info)     ;
DECLARE_DO_FUN (gq_progress) ;
DECLARE_DO_FUN (gq_complete) ;
DECLARE_DO_FUN (gq_talk)     ;
DECLARE_DO_FUN (gq_status)   ;
DECLARE_DO_FUN (gq_start)    ;
DECLARE_DO_FUN (gq_stop)     ;
DECLARE_DO_FUN (gq_enable)   ;
DECLARE_DO_FUN (gq_disable)  ;

#endif
