/* $Id: grep.h,v 1.666 2004/09/20 10:49:48 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/************************************************************************************
 *  (c) 2004 by Shrike aka Sauron                                                   *
 ************************************************************************************/



#ifndef __GREP_H
#define __GREP_H

#include "typedef.h"
#include "conquer.h"

#define SORT_INVALID -1
#define SORT_NONE     0
#define SORT_LEVEL    1
#define SORT_SVS      2
#define SORT_HR       3
#define SORT_DR       4
#define SORT_AVE      5
#define SORT_SAF      6
#define SORT_AC       7
#define SORT_ALEVEL   8
#define SORT_VNUM     9

#define SORT_INT     10
#define SORT_STR     11
#define SORT_DEX     12
#define SORT_WIS     13
#define SORT_CON     14
#define SORT_CHA     15
#define SORT_LCK     16

#define SORT_HP      17
#define SORT_MANA    18
#define SORT_MOVE    19

#define SORT_V0      20
#define SORT_V1      21
#define SORT_V2      22
#define SORT_V3      23
#define SORT_V4      24

#define RSORT_V0     30
#define RSORT_V1     31
#define RSORT_V2     32
#define RSORT_V3     33
#define RSORT_V4     34


typedef struct mgrep_mob_t      mgrep_mob_t;
typedef struct ogrep_obj_t      ogrep_obj_t;
typedef struct rgrep_room_t     rgrep_room_t;


// ----------------------------------------------------------------------
// structures for mobs
// ----------------------------------------------------------------------

struct mgrep_mob_t
{
     const char        *name;
     int               vnum;
     int               level;
     //SPEC_FUN *        spec_fun;
     //SHOP_DATA *       pShop;
     int               mptrig;
     //int               mptrig_types;
     //int               fvnum;
     //int               group;
     //int               count;
     //int               killed;
     mlstring *        short_descr;
     flag64_t          affected_by;
     int               alignment;
     int               hitroll;
     int               hit[3];
     int               mana[3];
     int               damage[3];
     int               ac[4];
     int               dam_type;
     flag64_t          act;
     flag64_t          off_flags;
     flag64_t          immunes;          /* immunities */
     sh_int            resists[MAX_DAM]; /* resistances/vulnerabilities */
     //flag64_t          start_pos;
     //flag64_t          default_pos;
     flag64_t          sex;
     int               race;
     int               wealth;
     flag64_t          form;
     flag64_t          parts;
     int               pcnt;
     int               size;
     //const char *      material;
     flag64_t          practicer;
     int               clan;
     int               invis_level;    /* mobinvis level */
     mlstring *        listen_data; 
};

// ----------------------------------------------------------------------
// structures for all object classes
// ----------------------------------------------------------------------

struct ogrep_obj_t
{
     const char   *name;
     int           vnum;
     int           item_type;
     int           level;
     int           limit;
     int           wear_flags;
     int           hr;
     int           dr;
     int           svs;
     int           saf;
     int           hp;
     int           mana;
     int           move;
     int           dice_number;
     int           dice_type;
     int           ave;
     int           stat_str;
     int           stat_int;
     int           stat_wis;
     int           stat_dex;
     int           stat_con;
     int           stat_cha;
     int           stat_lck;
     
     int           opcods;
     int           objprogs;
     
     int           apply_level;
      
     int           ac;
     int           v0;
     int           v1;
     int           v2;
     int           v3;
     int           v4;
     
     const char   *material;

};

// ----------------------------------------------------------------------
// structures for room
// ----------------------------------------------------------------------


struct rgrep_room_t
{
    const char *        name;
    const char *        owner;
    int                 clan;
    int                 vnum;
    flag64_t            room_flags;
    int                 light;
    flag64_t            sector_type;
    int                 heal_rate;
    int                 mana_rate;
    AFFECT_DATA *       affected;
    int                 affected_by;
    int                 space;
    MPTRIG *            rprogs;        /* Room olc */
    long                rprog_flags;
    sh_int              rprog_delay;

    ext_flag_t          progtypes;
    
};

typedef struct grep_sortmode GREP_SORTMODE;

#define SORT_ARMOR       (A)
#define SORT_WEAPON      (B)
#define SORT_PILL        (C)

#define SORT_MOB         (aa)
#define SORT_ROOM        (bb)

struct grep_sortmode
{
    char        *name          ; // command name
    int          sort_value    ;
    int          sort_mode     ;
};

#if defined _OBJ_GREP
static GREP_SORTMODE    grep_sortmode [] =
{
    { "int",             SORT_INT,           SORT_WEAPON | SORT_ARMOR   },
    { "str",             SORT_STR,           SORT_WEAPON | SORT_ARMOR   },
    { "dex",             SORT_DEX,           SORT_WEAPON | SORT_ARMOR   },
    { "wis",             SORT_WIS,           SORT_WEAPON | SORT_ARMOR   },
    { "con",             SORT_CON,           SORT_WEAPON | SORT_ARMOR   },
    { "cha",             SORT_CHA,           SORT_WEAPON | SORT_ARMOR   },
    { "lck",             SORT_LCK,           SORT_WEAPON | SORT_ARMOR   },
    
    { "hp",              SORT_HP,            SORT_WEAPON | SORT_ARMOR   },
    { "mana",            SORT_MANA,          SORT_WEAPON | SORT_ARMOR   },
    { "move",            SORT_MOVE,          SORT_WEAPON | SORT_ARMOR   },
    
    { "level",           SORT_LEVEL,         SORT_WEAPON | SORT_ARMOR |SORT_PILL  },
    { "svs",             SORT_SVS,           SORT_WEAPON | SORT_ARMOR   },
    { "hr",              SORT_HR,            SORT_WEAPON | SORT_ARMOR   },
    { "dr",              SORT_DR,            SORT_WEAPON | SORT_ARMOR   },
    { "ave",             SORT_AVE,           SORT_WEAPON | SORT_ARMOR   },
    { "saf",             SORT_SAF,           SORT_WEAPON | SORT_ARMOR   },
    
    { "pierce",          SORT_V0,            SORT_ARMOR    },
    { "bash",            SORT_V1,            SORT_ARMOR    },
    { "slash",           SORT_V2,            SORT_ARMOR    },
    { "exotic",          SORT_V3,            SORT_ARMOR    },
    
    { "slevel",          SORT_V0,            SORT_PILL    },
    { "spell1",          SORT_V1,            SORT_PILL    },
    { "spell2",          SORT_V2,            SORT_PILL    },
    { "spell3",          SORT_V3,            SORT_PILL    },
    { "spell4",          SORT_V4,            SORT_PILL    },
    
    { "vnum",            SORT_VNUM,          SORT_MOB | SORT_ROOM },
    
    { NULL }
};
#endif

/*
#define ITEM_LIGHT          1
#define ITEM_STAFF          4
#define ITEM_TREASURE       8    // no extra data
#define ITEM_CLOTHING       11   // no extra data
#define ITEM_FURNITURE      12
#define ITEM_TRASH          13   // no extra data
#define ITEM_CONTAINER      15
#define ITEM_DRINK_CON      17
#define ITEM_KEY            18   // no extra data
#define ITEM_FOOD           19
#define ITEM_MONEY          20
#define ITEM_BOAT           22   // no extra data
#define ITEM_CORPSE_NPC     23   // no extra data
#define ITEM_CORPSE_PC      24   // no extra data
#define ITEM_FOUNTAIN       25
#define ITEM_PROTECT        27   // no extra data
#define ITEM_MAP            28   // no extra data
#define ITEM_WARP_STONE     30   // no extra data
#define ITEM_ROOM_KEY       31   // no extra data
#define ITEM_GEM            32   // no extra data
#define ITEM_JEWELRY        33   // no extra data
#define ITEM_JUKEBOX        34   // no extra data
#define ITEM_TATTOO         35   // no extra data
#define ITEM_POLE           36
#define ITEM_SCABBARD       37
#define ITEM_SLOT_MACHINE   39 
#define ITEM_RIDDLE         40
#define ITEM_RALTAR         41
*/

// ----------------------------------------------------------------------
// functions
// ----------------------------------------------------------------------

DECLARE_DO_FUN (do_ogrep)       ;
DECLARE_DO_FUN (ogrep_weapons)  ; // ITEM_WEAPON         5
DECLARE_DO_FUN (ogrep_armor)    ; // ITEM_ARMOR          9
DECLARE_DO_FUN (ogrep_pill)     ;
DECLARE_DO_FUN (ogrep_help)     ;

DECLARE_DO_FUN (do_mgrep)       ;
DECLARE_DO_FUN (mgrep_level)    ; 
DECLARE_DO_FUN (mgrep_area)     ;
DECLARE_DO_FUN (mgrep_name)     ;
DECLARE_DO_FUN (mgrep_act)      ;
DECLARE_DO_FUN (mgrep_off)      ;
DECLARE_DO_FUN (mgrep_affected) ;
DECLARE_DO_FUN (mgrep_immunes)  ;
DECLARE_DO_FUN (mgrep_help)     ;
DECLARE_DO_FUN (mgrep_shop)     ;

// room 

void rgrep_help    ( CHAR_DATA *ch, const char *arg ); 
void rgrep_sector  ( CHAR_DATA *ch, const char *arg ); 
void rgrep_flag    ( CHAR_DATA *ch, const char *arg ); 
void rgrep_reset   ( CHAR_DATA *ch, const char *arg ); 

void ogrep_help       ( CHAR_DATA *ch, const char *arg ); 
void ogrep_weapons    ( CHAR_DATA *ch, const char *arg ); 
void ogrep_armor      ( CHAR_DATA *ch, const char *arg ); 
void ogrep_pill       ( CHAR_DATA *ch, const char *arg ); 
void ogrep_wear       ( CHAR_DATA *ch, const char *arg ); 
void ogrep_portal     ( CHAR_DATA *ch, const char *arg ); 
void ogrep_window     ( CHAR_DATA *ch, const char *arg ); 
void ogrep_potion     ( CHAR_DATA *ch, const char *arg );
void ogrep_scroll     ( CHAR_DATA *ch, const char *arg );
void ogrep_material   ( CHAR_DATA *ch, const char *arg );

void mgrep_help       ( CHAR_DATA *ch, const char *arg );
void mgrep_level      ( CHAR_DATA *ch, const char *arg );
void mgrep_area       ( CHAR_DATA *ch, const char *arg );
void mgrep_name       ( CHAR_DATA *ch, const char *arg );
void mgrep_act        ( CHAR_DATA *ch, const char *arg );
void mgrep_off        ( CHAR_DATA *ch, const char *arg );
void mgrep_affected   ( CHAR_DATA *ch, const char *arg );
void mgrep_immunes    ( CHAR_DATA *ch, const char *arg );
void mgrep_shop       ( CHAR_DATA *ch, const char *arg );
void mgrep_race       ( CHAR_DATA *ch, const char *arg );

int    get_sort_mode (const char* argument, int mode);
void   sort_show     (CHAR_DATA *ch, int mode);
char * percent_color (int value, int max_value);

#endif
