/* $Id: healer.c,v 1.666 2004/09/20 10:49:48 shrike Exp $                            */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

 /************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/


#include <sys/types.h>
#if !defined (WIN32)
#include <sys/time.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "merc.h"

DECLARE_DO_FUN( do_say  );

DO_FUN(do_heal)
{
    CHAR_DATA *mob;
    char arg[MAX_INPUT_LENGTH];
    int sn;
    uint cost;
    SPELL_FUN *spell;
    char *words;
    OBJ_DATA *obj;
    bool found = FALSE;

    /* check for healer */
    for (mob = ch->in_room->people; mob; mob = mob->next_in_room)
        if (IS_NPC(mob) && IS_SET(mob->pIndexData->act, ACT_HEALER)
        && (!mob->clan || mob->clan == ch->clan))
            break;

    if (mob == NULL)
    {
        char_act("     .", ch);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (HAS_SKILL(ch, gsn_spellbane))
    {
//        if (mob->clan != ch->clan)
        if (ch->clan == mob->clan
        || (CLAN(ch->clan)->diplomacy[mob->clan] == DIP_ALLY
        && CLAN(mob->clan)->diplomacy[ch->clan] == DIP_ALLY))
        {
            cost = 0;
        } else
        {
            char_act("     !", ch);
            return;
        }

        if (arg[0] == '\0')
        {
            act("$N,    ,    :",
                ch, NULL, mob, TO_CHAR);
            char_act("{g-------------------------------------------------------{x", ch);
            char_act("  blind      {g:{x           {g|{x  {R20  {Y{x", ch);
            char_act("  disease    {g:{x           {g|{x  {R30  {Y{x", ch);
            char_act("  poison     {g:{x        {g|{x  {R20  {Y{x", ch);
            char_act("  uncurse    {g:{x            {g|{x  {R25  {Y{x", ch);
            char_act("{g-------------------------------------------------------{x", ch);
            char_act("  {Cheal <>{x  .", ch);
            return;
        }

        else if (!str_prefix(arg,"blindness"))
        {
            sn    = gsn_blindness;
            cost  = 2000;
        } else if (!str_prefix(arg,"disease"))
        {
            sn    = gsn_plague;
            cost = 3000;
        } else if (!str_prefix(arg,"poison"))
        {
            sn    = gsn_poison;
            cost  = 2000;
        } else if (!str_prefix(arg, "uncurse"))
        {
            sn    = gsn_curse;
            cost  = 2500;
        } else
        {
            act("$N     .   '{Cheal{x'  .",
                ch, NULL, mob, TO_CHAR);
            return;
        }

        if (cost > (ch->gold * 100 + ch->silver))
        {
            act("    .", ch, NULL, mob, TO_CHAR);
            return;
        }

        if (!is_affected(ch, sn) && sn != gsn_curse)
        {
            act("    .", ch, NULL, mob, TO_CHAR);
            return;
        }

        deduct_cost(ch, cost);
        WAIT_STATE(ch, 5 * PULSE_VIOLENCE);

        act("      $N  .",
            ch, NULL, mob, TO_CHAR);
        act("      $N  $n",
            ch, NULL, mob, TO_ROOM);

        if (sn == gsn_curse)
        {
            if (check_dispel(mob->level, ch, gsn_curse))
            {
                char_act("     .", ch);
                act("$n  .\n",ch,NULL,NULL,TO_ROOM);
                affect_strip(ch, sn);
            }
            for (obj = ch->carrying; (obj != NULL && !found); obj = obj->next_content)
            {
                if ((IS_OBJ_STAT(obj, ITEM_NODROP) || IS_OBJ_STAT(obj, ITEM_NOREMOVE)) && !IS_OBJ_STAT(obj, ITEM_NOUNCURSE))
                {   /* attempt to remove curse */
                    if (!saves_dispel(mob->level, obj->level, 0))
                    {
                        found = TRUE;
                        REMOVE_BIT(obj->extra_flags, ITEM_NODROP);
                        REMOVE_BIT(obj->extra_flags, ITEM_NOREMOVE);
                        act("$p  {C {x.", ch, obj, NULL, TO_CHAR);
                        act("$p   $n  {C {x.", ch, obj, NULL, TO_ROOM);
                    }
                }
            }
        } else
            affect_strip(ch, sn);
        return;
    }

    if (arg[0] == '\0') {
        /* display price list */
    act("{G{x   :",ch,NULL,mob,TO_CHAR);
    char_act("{g-------------------------------------------------------{x", ch);
    char_act("  refresh    {g:{x          {g|{x  {R 1 {Y{x", ch);
    char_act("  light      {g:{x        {g|{x  {R 1 {Y{x", ch);
    char_act("  serious    {g:{x     {g|{x  {R 5 {Y{x", ch);
    char_act("  critic     {g:{x       {g|{x  {R10 {Y{x", ch);
    char_act("  heal       {g:{x   {g|{x  {R20 {Y{x", ch);
    char_act("  master heal{g:{x        {g|{x  {R50 {Y{x", ch);
    char_act("  disease    {g:{x           {g|{x  {R 5 {Y{x", ch);
    char_act("  poison     {g:{x        {g|{x  {R 5 {Y{x", ch);
    char_act("  blind      {g:{x           {g|{x  {R10 {Y{x", ch);
    char_act("  uncurse    {g:{x            {g|{x  {R20 {Y{x", ch);
    char_act("  mana       {g:{x     {g|{x  {R 5 {Y{x", ch);
    char_act("  energize   {g:{x  300 . {g|{x  {R50 {Y{x", ch);
    char_act("  bless      {g:{x     {g|{x  {R50 {Y{x", ch);
    char_act("  frenzy     {g:{x          {g|{x {R100 {Y{x", ch);
    char_act("  restore    {g:{x    {g|{x {R500 {Y{x", ch);
    char_act("{g-------------------------------------------------------{x", ch);
        char_act("  {Cheal <>{x  .", ch);
    return;
    }

    if (!str_prefix(arg,"light"))
    {
        spell = spell_cure_light;
        sn    = sn_lookup("cure light");
        words = " ";
        cost  = 100;
    }

    else if (!str_prefix(arg,"serious"))
    {
    spell = spell_cure_serious;
    sn    = sn_lookup("cure serious");
    words = " ";
    cost  = 500;
    }

    else if (!str_prefix(arg,"critical"))
    {
    spell = spell_cure_critical;
    sn    = sn_lookup("cure critical");
    words = " ";
    cost  = 1000;
    }

    else if (!str_prefix(arg,"heal"))
    {
    spell = spell_heal;
    sn = sn_lookup("heal");
    words = "";
    cost  = 2000;
    }

    else if (!str_prefix(arg,"blindness"))
    {
    spell = spell_cure_blindness;
    sn    = sn_lookup("cure blindness");
        words = " ";
        cost  = 1000;
    }

    else if (!str_prefix(arg,"disease"))
    {
    spell = spell_cure_disease;
    sn    = sn_lookup("cure disease");
    words = " ";
    cost = 500;
    }

    else if (!str_prefix(arg,"poison"))
    {
    spell = spell_cure_poison;
    sn    = sn_lookup("cure poison");
    words = " ";
    cost  = 500;
    }

    else if (!str_prefix(arg,"uncurse") || !str_prefix(arg,"curse"))
    {
    spell = spell_remove_curse;
    sn    = sn_lookup("remove curse");
    words = " ";
    cost  = 2000;
    }

    else if (!str_prefix(arg,"mana"))
    {
        spell = NULL;
        sn = -3;
        words = "";
        cost = 500;
    }

    else if (!str_prefix(arg,"refresh") || !str_prefix(arg,"moves"))
    {
    spell =  spell_refresh;
    sn    = sn_lookup("refresh");
    words = "";
    cost  = 100;
    }

    else if (!str_prefix(arg,"master"))
    {
    spell =  spell_master_healing;
    sn    = sn_lookup("master healing");
    words = " ";
    cost  = 5000;
    }

    else if (!str_prefix(arg,"energize"))
    {
    spell =  NULL;
    sn    = -2;
    words = "";
    cost  = 5000;
    }

    else if (!str_prefix(arg,"restore"))
    {
    spell =  NULL;
    sn    = -4;
    words = " ";
    cost  = 50000;
    }

    else if (!str_prefix(arg,"bless"))
    {

    spell =  NULL;
    sn    = -5;
    words = "";
    cost  = 5000;
    }

    else if (!str_prefix(arg,"frenzy"))
    {

    spell =  NULL;
    sn    = -6;
    words = "";
    cost  = 10000;
    }

    else
    {
    act("{G{x    .   '{Cheal{x'  .",
        ch,NULL,mob,TO_CHAR);
    return;
    }

/*
    GM :
     .    -???
    cost = cost - (get_skill(ch, gsn_haggle));
*/

    if (cost < 100)
        cost = 100;

    if (cost > (ch->gold * 100 + ch->silver))
    {
        act("    .",ch,NULL,mob,TO_CHAR);
        return;
    }

    WAIT_STATE(ch,PULSE_VIOLENCE);

    deduct_cost(ch, cost);

    act("$n   '$t'.", mob, words, NULL, TO_ROOM);
    if (sn == -2)
    {
        ch->mana += 300;
        ch->mana = UMIN(ch->mana,ch->max_mana);
        char_act("     .", ch);
    }
    if (sn == -3)
    {
        ch->mana += dice(5,10) + mob->level / 4;
        ch->mana = UMIN(ch->mana,ch->max_mana);
        char_act("     .", ch);
    }

    if (sn == -4)
    {
        ch->hit = ch->max_hit;
        ch->mana = ch->max_mana;
        ch->move = ch->max_move;
        char_act("     !!!.", ch);
    }

    if (sn == -5)
    {
        if (IS_CYBORG(ch))
        {
            spell = spell_cyber_bless;
            sn    = sn_lookup("cyber bless");
        } else
        {
            spell = spell_bless;
            sn    = sn_lookup("bless");
        }
        spell(sn,LVL(ch),mob,ch,TARGET_CHAR);
    }

    if (sn == -6)
    {
        spell = spell_frenzy;
        sn    = sn_lookup("frenzy");
        spell(sn,LVL(ch),mob,ch,TARGET_CHAR);
    }

    if (sn < 0)
        return;

    spell(sn,mob->level,mob,ch,TARGET_CHAR);
}
