/* $Id: immortal.c,v 1.666 2004/09/20 10:49:49 shrike Exp $                             */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "merc.h"
#include "immortal.h"


varr immortals  = {sizeof (immortal_t), 4};

immortal_t *immortal_new()
{
        immortal_t * immortal;

        immortal                      = varr_enew (&immortals);
        immortal->name                = str_empty;
        immortal->level               = 92;
        immortal->realname            = str_empty;
        immortal->comment             = str_empty;
        immortal->phone               = str_empty;
        immortal->phone_time_access   = str_empty;
        immortal->phone_sec_level     = 92;
        immortal->email               = str_empty;
        immortal->email_sec_level     = 92;
        immortal->icq                 = str_empty;
        immortal->icq_sec_level       = 92;
        immortal->birthday            = str_empty;
        
        return immortal ;
}

void immortal_free(immortal_t *immortal)
{
    free_string(immortal->name);
    free_string(immortal->realname);
    free_string(immortal->comment);
    free_string(immortal->phone);
    free_string(immortal->phone_time_access);
    free_string(immortal->email);
    free_string(immortal->icq);
    free_string(immortal->birthday);

    free(immortal);
}

int immnumber_lookup(const char * name)
{
    int immrn;

    if (IS_NULLSTR(name))
                return -1;

        for (immrn = 0; immrn < immortals.nused; immrn++)
                if (!str_cmp(name, IMM(immrn)->name))
                        return immrn;

        return -1;
}

const char * immortal_name(int immrn)
{
      if ((immrn < 0) || (immrn > immortals.nused -1 ))
              return "None";
      else
              return IMM(immrn)->name; 
}
