/* $Id: immortal.h,v 1.666 2004/09/20 10:49:49 shrike Exp $                             */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#ifndef _IMMORTAL_H_
#define _IMMORTAL_H_

typedef struct immortal_t immortal_t;

extern varr     immortals;

struct immortal_t
{
    const char * name;
    const char * realname;
    const char * comment;
    int          level;
    const char * phone;
    const char * phone_time_access;
    int          phone_sec_level;
    const char * email;
    int          email_sec_level;
    const char * icq;
    int          icq_sec_level;
    const char * birthday;
};

immortal_t *    immortal_new    (void);
void            immortal_free   (immortal_t*);

#define IMM(immrn)              ((immortal_t*) VARR_GET(&immortals, immrn))
#define immortal_lookup(immrn)  ((immortal_t*) varr_get(&immortals, immrn))

int immnumber_lookup (const char * name);
const char * immortal_name(int immrn);

#endif
