/* $Id: interp.c,v 1.666 2004/09/20 10:49:49 shrike Exp $                           */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/


#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

#include "merc.h"
#include "olc/olc.h"
#include "db/dofun.h"
#include "db/cmd.h"
#include "db/socials.h"
#include "cyborg.h"
#include "crash.h"

// #undef IMMORTALS_LOGS
#define IMMORTALS_LOGS
void interpret_social(social_t *soc, CHAR_DATA *ch, const char *argument);
void substitute_system_alias(const char *argument, char *buf, size_t len);

/*
 * Log-all switch.
 */
bool                fLogAll     = FALSE;

#ifdef IMMORTALS_LOGS
/*
 * immortals log file
 */
FILE                *imm_log;
#endif

FILE                *snoop_log;

/*
 * Command table.
 */
DO_FUN(do_readext);
DO_FUN(do_setext);

DO_FUN(interpret)
{
    interpret_raw(ch, argument, FALSE);
}

int is_alpha(unsigned char c)
{
    if (isalpha(c) || c == 163 || c == 179 || c > 191)
    return TRUE;
    else
    return FALSE;
}

/*
 * The main entry point for executing commands.
 * Can be recursively called from 'at', 'order', 'force'.
 */
void interpret_raw(CHAR_DATA *ch, const char *arg, bool is_order)
{
    char         command[MAX_INPUT_LENGTH];
    char         buf[MAX_STRING_LENGTH];
    const char *logline;
    const char *argument;
    int         i;
    command_t  *cmd = NULL;
    bool        found;
    social_t   *soc = NULL;
    int         min_pos;
    flag64_t    cmd_flags;

    /*
     * Strip leading spaces.
     */
    while (isspace(*arg))
        arg++;

    if (arg[0] == '\0')
        return;

    // Update the crash save info.
    crash_set_last_char( ch->name );
    crash_set_last_cmd( arg );

    substitute_system_alias(arg, buf, sizeof(buf));

    argument = buf;
    logline = str_dup(argument);

    /*
     * Grab the command word.
     * Special parsing so ' can be a command,
     * also no spaces needed after punctuation.
     */
#ifdef IMMORTALS_LOGS
    if (IS_IMMORTAL(ch))
    {
        if ((imm_log = dfopen(GODS_PATH, IMMLOG_FILE, "a+")) == NULL)
            bug("cannot open imm_log_file", 0);
        else
        {
            fprintf(imm_log, "%s [%s] %s\n", strtime(time(NULL)), ch->name, argument);
            fclose(imm_log);
        }
    }
#endif
    if (IS_SET(muddy_mode, MUDDY_GAME_LOCK) && !IS_IMMORTAL(ch))
    {
         char_act("{RGame now locked{x.", ch);
         return;
    }

    if (IS_SET(ch->comm, COMM_AUTOSNOOP))
    {
         if ((snoop_log = dfopen("snoop", ch->name , "a+")) == NULL)
         {
              log_printf("[*****] BUG: unable to open autosnoop file: %s/%s","snoop", ch->name);
         }
         else
         {
            fprintf(snoop_log, "[%s] %s\n", strtime(time(NULL)), argument);
            fclose(snoop_log);
         }

    }

    argument = one_argument(argument, command, sizeof(command));

    /*
     * Look for command in command table.
     */
    found = FALSE;
    for (i = 0; i < commands.nused; i++)
    {
        cmd = COMMAND(i);

        if (str_cmp(command, cmd->name))
            continue;
        /*
         * Implement freeze command.
         */
        if (!IS_NPC(ch) &&  IS_SET(ch->plr_flags, PLR_FREEZE) &&  !IS_SET(cmd->flags, COMMAND_FROZEN_OK))
        {
            act_puts("You're totally frozen until $t!", ch, strtime(ch->pcdata->freeze), NULL, TO_CHAR, POS_DEAD);
            return;
        }


        if (IS_SET(cmd->flags, COMMAND_DISABLED))
        {
            char_act("Sorry, this command is temporarily disabled.", ch);
            return;
        }

        /*Implementing SOUL stance for demons*/

        if (!IS_NPC(ch)  && IS_SET(ch->plr_flags, PLR_SOUL)  && cmd->name != "resoul")
        {
            char_act("     !     !", ch);
            return;
        }

        if (IS_NPC(ch)  && (ch->pIndexData->vnum == MOB_VNUM_SOUL) && !IS_SET(cmd->flags, COMMAND_SOUL))
        {
            char_act("    ,     !", ch);
            return;
        }

        if (cmd->level >= LEVEL_IMMORTAL)
        {
            if (IS_NPC(ch))
                continue;

            if (ch->level < IMPLEMENTOR  &&  !is_name(cmd->name, ch->pcdata->granted))
                continue;

        }
        else if (cmd->level > ch->level)
            continue;

        if (is_order)
        {
            if (IS_SET(cmd->flags, COMMAND_NOORDER)
            ||  cmd->level >= LEVEL_IMMORTAL)
                return;

            if (is_order && !IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM) && ch->wait > 0)
            {
                do_say(ch, "Don't spam me. Wait for ending previous command.");
                return;
            }

            if (IS_NPC(ch)  &&  IS_SET(cmd->flags, COMMAND_CHARM_PC_OK))
                return;
        } else
        {
            bool can_cast_under_charm = IS_NPC(ch)
            && (IS_SET(ch->pIndexData->act, ACT_RECEIVE_LEVEL | ACT_WANDERER)
            || ch->pIndexData->vnum == MOB_VNUM_ICE_DRAGON
            || ch->pIndexData->vnum == MOB_VNUM_FIRE_DRAGON);

            if (IS_AFFECTED(ch, AFF_CHARM)
            && !IS_SET(cmd->flags, COMMAND_CHARMED_OK)
            && cmd->level < LEVEL_IMMORTAL
            && !IS_IMMORTAL(ch) && !can_cast_under_charm)
            {
                char_act("First ask your beloved master!", ch);
                return;
            }
        }

        if (IS_AFFECTED(ch, AFF_STUN)  && !IS_SET(cmd->flags, COMMAND_KEEP_HIDE))
        {
            char_act("You are STUNNED to do that.", ch);
            return;
        }

        found = TRUE;
        break;
    }

    /*
     * Log and snoop.
     */
    if (found)
        if (IS_SET(cmd->log, LOG_NEVER) || ch->level == MAX_LEVEL)
            logline = str_empty;

    if (((!IS_NPC(ch) && IS_SET(ch->plr_flags, PLR_LOG))
    || fLogAll
    || (found && IS_SET(cmd->log, LOG_ALWAYS))) && !IS_NULLSTR(logline)
    && logline[0] != '\n')
    {
        char logline2[2*MAX_INPUT_LENGTH];
        int i=0, j=0;
        while(logline[i] != '\0' && logline [i] != '\n')
        {
            if ((logline2[i+j] = logline[i]) == '$')
            {
                j++;
                logline2[i+j] = '$';
            }
            i++;
        }
        logline2[i+j] = '\0';
        log_printf("Log %s: %s", ch->name, logline);
        wiznet("Log $N: $t", ch, logline, WIZ_SECURE, 0, ch->level);
    }

    if (ch->desc != NULL && ch->desc->snoop_by != NULL)
    {
        write_to_buffer(ch->desc->snoop_by, "# ", 2);
        write_to_buffer(ch->desc->snoop_by, logline, 0);
        write_to_buffer(ch->desc->snoop_by, "\n\r", 2);
    }

    if (!found)
    {
        /*
         * Look for command in socials table.
         */
        if ((soc = social_lookup(command, str_prefix)) != NULL)
            found = TRUE;
#ifdef  IMC
        else if (imc_command_hook(ch, command, argument))
            return;
#endif
#ifdef I3
        else if (I3_command_hook(ch, command, argument))
            return;
#endif
        if (!found)
        {
            char_act("Huh?", ch);
            return;
        }

        if (!IS_NPC(ch) && IS_SET(ch->comm, COMM_NOEMOTE))
        {
            char_act("You are anti-social!", ch);
            return;
        }

        min_pos = soc->min_pos;
        cmd_flags = 0;
    } else
    {
        min_pos = cmd->position;
        cmd_flags = cmd->flags;
    }

    if (!IS_NPC(ch))
    {
       /* Come out of hiding for most commands */
       if (IS_AFFECTED(ch, AFF_HIDE | AFF_FADE | AFF_TRAP)   && !IS_SET(cmd->flags, COMMAND_KEEP_HIDE))
       {
           REMOVE_BIT(ch->affected_by, AFF_HIDE | AFF_FADE | AFF_TRAP);
           char_act("You step out of shadows.", ch);
           act("$n steps out of shadows.", ch, NULL, NULL, TO_ROOM);
       }

        if (IS_AFFECTED(ch, AFF_IMP_INVIS)   && min_pos == POS_FIGHTING)
        {
            affect_bit_strip(ch, TO_AFFECTS, AFF_IMP_INVIS);
            char_act("You fade into existence.", ch);
            act("$n fades into existence.",
            ch, NULL, NULL, TO_ROOM);
        }

        if (IS_AFFECTED(ch, AFF_EARTHFADE)   && (min_pos == POS_FIGHTING))
        {
            affect_bit_strip(ch, TO_AFFECTS, AFF_EARTHFADE);
            WAIT_STATE(ch, PULSE_VIOLENCE * 2);
            act("You fade to your neutral form.", ch, NULL, NULL, TO_CHAR);
            act("Earth forms $n in front of you.", ch, NULL, NULL, TO_ROOM);
        }
    }

    /*
     * Character not in position for command?
     */
    if (ch->position < min_pos)
    {
        switch(ch->position)
        {
            case POS_DEAD:
                char_act("Lie still; You are DEAD.", ch);
                break;

            case POS_MORTAL:
            case POS_INCAP:
                char_act("You are hurt far too bad for that.", ch);
                break;

            case POS_STUNNED:
                char_act("You are too stunned to do that.", ch);
                break;

            case POS_SLEEPING:
                char_act("In your dreams, or what?", ch);
                break;

            case POS_RESTING:
                char_act("Nah... You feel too relaxed...", ch);
                break;

            case POS_SITTING:
                char_act("Better stand up first.", ch);
                break;

            case POS_FIGHTING:
                char_act("No way!  You are still fighting!", ch);
                break;
        }
        return;
    }

    if (soc)
    {
        if (!IS_NPC(ch)  &&  IS_SET(ch->plr_flags, PLR_FREEZE))
        {
            act_puts("You're totally frozen until $t!", ch, strtime(ch->pcdata->freeze), NULL, TO_CHAR, POS_DEAD);
            return;
        }

        interpret_social(soc, ch, argument);
        return;
    }

    /*
     * Dispatch the command.
     */
    if (cmd->do_fun != NULL)
       cmd->do_fun(ch, argument);//FIXME
    else
       log_printf("*** BUG ***: inrpret_raw: empty function in command %s.", cmd->name);

    tail_chain();
}

void interpret_social(social_t *soc, CHAR_DATA *ch, const char *argument)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    ROOM_INDEX_DATA *victim_room;
    DESCRIPTOR_DATA *d;

    one_argument(argument, arg, sizeof(arg));

    if (soc->level > 0)
    {
        if (!IS_IMMORTAL(ch) && ch->level < soc->level)
        {
            act("Your level less than need for this social." , ch, NULL, NULL, TO_CHAR);
            return;
        }
    }

    if (soc->age > 0)
    {
        if (!IS_IMMORTAL(ch) && get_age(ch) < soc->age)
        {
            act("Your are very young for this social." , ch, NULL, NULL, TO_CHAR);
            return;
        }
    }

    if (arg[0] == '\0')
    {
        act(soc->noarg_char, ch, NULL, NULL, TO_CHAR);
        act(soc->noarg_room, ch, NULL, NULL, TO_ROOM | ACT_TOBUF | ACT_NOTWIT);
        return;
    }

    if (!str_cmp(arg,"all") || !str_cmp(argument, ""))
    {
        if (!IS_IMMORTAL(ch))
        {
            act("Your can't use socials on all players." , ch, NULL, NULL, TO_CHAR);
            return;
        }

        for (d = descriptor_list; d != NULL; d = d->next)
        {
           if(d->connected == CON_PLAYING)
               if(str_cmp(d->character->name,ch->name))
                      act(soc->all_char, ch, NULL, d->character, TO_VICT | ACT_TOBUF);

        }

        act(soc->all_room, ch, NULL, NULL, TO_ROOM | ACT_TOBUF | ACT_NOTWIT);
        act(soc->all_self, ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((victim = get_char_world(ch, arg)) == NULL ||  (IS_NPC(victim) && victim->in_room != ch->in_room))
    {
        act(soc->notfound_char, ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (victim == ch)
    {
        act(soc->self_char, ch, NULL, victim, TO_CHAR);
        act(soc->self_room, ch, NULL, victim, TO_ROOM | ACT_TOBUF | ACT_NOTWIT);
        return;
    }

    victim_room = victim->in_room;
    victim->in_room = ch->in_room;

    act(soc->found_char,    ch, NULL, victim, TO_CHAR);
    act(soc->found_vict,    ch, NULL, victim, TO_VICT | ACT_TOBUF | ACT_NOTWIT);
    act(soc->found_notvict, ch, NULL, victim, TO_NOTVICT | ACT_TOBUF | ACT_NOTWIT);

    victim->in_room = victim_room;

    if (!IS_NPC(ch) && IS_NPC(victim) &&  !IS_AFFECTED(victim, AFF_CHARM) &&  IS_AWAKE(victim) && !victim->desc)
    {
        switch (number_bits(4))
        {
            case 0:

            case 1: case 2: case 3: case 4:
            case 5: case 6: case 7: case 8:
                act(soc->found_char, victim, NULL, ch, TO_CHAR);
                act(soc->found_vict, victim, NULL, ch, TO_VICT | ACT_TOBUF);
                act(soc->found_notvict, victim, NULL, ch, TO_NOTVICT | ACT_TOBUF | ACT_NOTWIT);
                break;

            case 9: case 10: case 11: case 12:
                act("$n slaps $N.", victim, NULL, ch, TO_NOTVICT | ACT_TOBUF | ACT_NOTWIT);
                act("You slap $N.", victim, NULL, ch, TO_CHAR);
                act("$n slaps you.", victim, NULL, ch, TO_VICT | ACT_TOBUF);
                break;
        }
    }
}

/*
 * Return true if an argument is completely numeric.
 */
bool is_number(const char *argument)
{
    if (IS_NULLSTR(argument))
            return FALSE;

    if (*argument == '+' || *argument == '-')
            argument++;

    for (; *argument != '\0'; argument++)
    {
            if (!isdigit(*argument))
                return FALSE;
    }

    return TRUE;
}

static uint x_argument(const char *argument, char c, char *arg, size_t len)
{
    char *p;
    char *q;
    int number;

    if (IS_NULLSTR(argument))
    {
        arg[0] = '\0';
        return 0;
    }

    p = strchr(argument, c);
    if (p == NULL) {
        strnzcpy(arg, len, argument);
        return 1;
    }

    number = strtoul(argument, &q, 0);
    if (q == p)
        argument = p+1;
    else
        number = 1;
    strnzcpy(arg, len, argument);
    return number;
}

/*
 * Given a string like 14.foo, return 14 and 'foo'
 */
uint number_argument(const char *argument, char *arg, size_t len)
{
    return x_argument(argument, '.', arg, len);
}

/*
 * Given a string like 14*foo, return 14 and 'foo'
 */
uint mult_argument(const char *argument, char *arg, size_t len)
{
    return x_argument(argument, '*', arg, len);
}

/*
 * Pick off one argument from a string and return the rest.
 * Understands quotes.
 */
const char *one_argument(const char *argument, char *arg_first, size_t len)
{
    return first_arg(argument, arg_first, len, TRUE);
}

/*****************************************************************************
 Name:      first_arg
 Purpose:   Pick off one argument from a string and return the rest.
        Understands quotes, if fCase then arg_first will be lowercased
 Called by: string_add(string.c)
 ****************************************************************************/
const char *first_arg(const char *argument, char *arg_first, size_t len, bool fCase)
{
    char *q;
    char cEnd = '\0';

    if (IS_NULLSTR(argument))
    {
        arg_first[0] = '\0';
        return argument;
    }

/* skip leading spaces */
    while (isspace(*argument))
        argument++;

/* check quotes */
    if (*argument == '\'' || *argument == '"')
            cEnd = *argument++;

    for (q = arg_first; *argument && q - arg_first + 1 < len; argument++)
    {
        if ((!cEnd && isspace(*argument)) || *argument == cEnd)
        {
            argument++;
            break;
        }
        *q++ = fCase ? LOWER(*argument) : *argument;
    }
    *q = '\0';

    while (isspace(*argument))
        argument++;

    return argument;
}

/*
 * Contributed by Alander.
 */
DO_FUN(do_commands)
{
    command_t * cmd;
    alias_t   * alias;
    int       col, i, j;
    BUFFER   * output;

    if (argument[0] == '\0')
    {
        col = 0;
        for (i = 0; i < commands.nused; i++) 
        {
            cmd = COMMAND(i);
            if (cmd->level < LEVEL_HERO
                &&  cmd->level <= ch->level
                &&  !IS_SET(cmd->flags, COMMAND_HIDDEN)) 
            {
                act_puts("$FL16{$t}", ch, cmd->name, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
                if (++col % 5 == 0)
                    char_act(str_empty, ch);
            }
        }

        if (col % 5 != 0)
            char_act(str_empty, ch);
    }
    else if (!str_cmp(argument, "all"))
    {
        output = buf_new(ch->lang);
        for (i = 0; i < commands.nused; i++) 
        {
            cmd = COMMAND(i);

            if ((cmd->level > ch->level || IS_SET(cmd->flags, COMMAND_HIDDEN)) 
                && !IS_IMMORTAL(ch))
                continue;

            buf_printf (output, "Command: [%s], Aliases: [", cmd->name);
            for (j = 0; j < aliases.nused; j++) 
            {
                alias = ALIAS(j);
                if (alias->command == cmd)
                    buf_printf (output, " %s", alias->name);
            }
            buf_add (output, " ]\n");
        }
        page_to_char (buf_string (output), ch);
        buf_free (output);
        return;
    }
    else
    {
        bool out_cmd; 
        output = buf_new(ch->lang);
        for (i = 0; i < aliases.nused; i++) 
        {
            cmd = ALIAS(i)->command;
            out_cmd = TRUE;

            if ((cmd->level > ch->level || IS_SET(cmd->flags, COMMAND_HIDDEN)) 
                && !IS_IMMORTAL(ch))
                continue;

            if (str_prefix(argument, ALIAS(i)->name))
                continue;

            for (j = 0; j < aliases.nused; j++) 
            {
                alias = ALIAS(j);
                if (alias->command == cmd)
                {
                    if (out_cmd)
                    {
                        buf_printf (output, "Command: [%s], Aliases: [", cmd->name);
                        out_cmd = FALSE;
                    }
                    buf_printf (output, " %s", alias->name);
                }
            }
            if (!out_cmd)
                buf_add (output, " ]\n");
        }
        page_to_char (buf_string (output), ch);
        buf_free (output);
        return;
    }
}

DO_FUN(do_wizhelp)
{
    command_t *cmd;
    int col, i;

    if (IS_NPC(ch))
    {
        char_act("Huh?", ch);
        return;
    }

    col = 0;
    for (i = 0; i < commands.nused; i++)
    {
        cmd = COMMAND(i);
        if (cmd->level < LEVEL_IMMORTAL)
            continue;

        if (ch->level < IMPLEMENTOR  &&  !is_name(cmd->name, ch->pcdata->granted))
            continue;

        act_puts("$FL16{$t}", ch, cmd->name, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (++col % 5 == 0)
            char_act(str_empty, ch);
    }

    if (col % 5 != 0)
        char_act(str_empty, ch);
}

/*********** alias.c **************/

/* does aliasing and other fun stuff */
void substitute_alias(DESCRIPTOR_DATA *d, const char *argument)
{
    CHAR_DATA *ch;
    char buf[MAX_STRING_LENGTH];
    char prefix[MAX_INPUT_LENGTH];
    char name[MAX_INPUT_LENGTH];
    const char *point;
    int i;

    ch = d->original ? d->original : d->character;

    if (!ch)
        return;

    /* check for prefix */
    if (ch->prefix[0] != '\0' && str_prefix("prefix",argument))
    {
        if (strlen(ch->prefix) + strlen(argument) > MAX_INPUT_LENGTH)
            char_act("Line to long, prefix not processed.", ch);
        else
        {
            snprintf(prefix, sizeof(prefix),"%s %s",ch->prefix,argument);
            argument = prefix;
        }
    }

    if (!str_prefix("alias", argument)
    ||  !str_prefix("unalias", argument)
    ||  !str_prefix("prefix", argument)) {
        interpret(d->character, argument);
        return;
    }

    strnzcpy(buf, sizeof(buf), argument);

    if (!IS_NPC(ch))
    for (i = 0; i < MAX_ALIAS; i++)  /* go through the aliases */
    {
        if (ch->pcdata->alias[i] == NULL)
            break;

        if (!str_prefix(ch->pcdata->alias[i], argument))
        {
            if (!is_alpha(argument[0]) && !isdigit(argument[0]))
            {
                name[0] = argument[0];
                name[1] = '\0';
                point = argument+1;
                while (isspace(*point))
                    point++;
            }
            else
                point = one_argument(argument, name, sizeof(name));
            if (!strcmp(ch->pcdata->alias[i], name))
            {
                buf[0] = '\0';
                strnzcat(buf, sizeof(buf), ch->pcdata->alias_sub[i]);
                if (point[0] != '\0') {
                    strnzcat(buf, sizeof(buf), " ");
                    strnzcat(buf, sizeof(buf), point);
                }
                break;
            }
        }
    }

    interpret(d->character, buf);
}


void substitute_system_alias(const char *argument, char *buf, size_t len)
{
    char name[MAX_INPUT_LENGTH];
    const char *point;
    alias_t *alias;
    int i;

    if (!is_alpha(argument[0]) && !isdigit(argument[0]))
    {
        name[0] = argument[0];
        name[1] = '\0';
        point = argument + 1;
        while (isspace(*point))
            point++;
    }
    else
        point = one_argument(argument, name, sizeof(name));

    strnzcpy(buf, len, argument);
    for (i = 0; i < aliases.nused; i++)
    {
        alias = ALIAS(i);

        if (str_prefix(name, alias->name))
            continue;

        if (alias->command == NULL)
        {
            log_printf("** BUG **:interp.c: substitute_system_alias: not such command for alias %s", argument);
            break;
        }

        strnzcpy(buf, len, alias->command->name);
        if (!IS_NULLSTR(alias->prefix))
    {
       strnzcat(buf, len, " ");
       strnzcat(buf, len, alias->prefix);
        }
        if (point[0] != '\0')
        {
            strnzcat(buf, len, " ");
            strnzcat(buf, len, point);
        }
    if (!IS_NULLSTR(alias->suffix))
        {
           strnzcat(buf, len, " ");
       strnzcat(buf, len, alias->suffix);
        }
        break;
    }

}

DO_FUN(do_alia)
{
    char_act("I'm sorry, alias must be entered in full.", ch);
    return;
}

DO_FUN(do_alias)
{
    CHAR_DATA *rch;
    char arg[MAX_INPUT_LENGTH];
    int pos;

    if (ch->desc == NULL)
        rch = ch;
    else
        rch = ch->desc->original ? ch->desc->original : ch;

    if (IS_NPC(rch))
        return;

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        if (rch->pcdata->alias[0] == NULL)
        {
            char_act("You have no aliases defined.", ch);
            return;
        }
        char_act("Your current aliases are:", ch);

        for (pos = 0; pos < MAX_ALIAS; pos++)
        {
            if (rch->pcdata->alias[pos] == NULL
            ||  rch->pcdata->alias_sub[pos] == NULL)
                break;
            act_puts("    $t:  $T", ch, rch->pcdata->alias[pos], rch->pcdata->alias_sub[pos], TO_CHAR, POS_DEAD);
        }
        return;
    }

    if (!str_prefix("una",arg) || !str_cmp("alias",arg))
    {
        char_act("Sorry, that word is reserved.", ch);
        return;
    }

    if (argument[0] == '\0')
    {
        for (pos = 0; pos < MAX_ALIAS; pos++)
        {
            if (rch->pcdata->alias[pos] == NULL
            ||  rch->pcdata->alias_sub[pos] == NULL)
                break;

            if (!str_cmp(arg,rch->pcdata->alias[pos]))
            {
                act_puts("$t aliases to '$T'.", ch, rch->pcdata->alias[pos], rch->pcdata->alias_sub[pos], TO_CHAR, POS_DEAD );
                return;
            }
        }

        char_act("That alias is not defined.", ch);
        return;
    }

    if (!str_prefix(argument,"delete") || !str_prefix(argument,"prefix"))
    {
        char_act("That shall not be done!", ch);
        return;
    }

    for (pos = 0; pos < MAX_ALIAS; pos++)
    {
        if (rch->pcdata->alias[pos] == NULL)
            break;

        if (!str_cmp(arg,rch->pcdata->alias[pos])) /* redefine an alias */
        {
            free_string(rch->pcdata->alias_sub[pos]);
            rch->pcdata->alias_sub[pos] = str_dup(argument);
            act_puts("$t is now realiased to '$T'.", ch, arg, argument, TO_CHAR, POS_DEAD);
            return;
        }
     }

    if (pos >= MAX_ALIAS)
    {
        char_act("Sorry, you have reached the alias limit.", ch);
        return;
    }

     /* make a new alias */
     rch->pcdata->alias[pos]        = str_dup(arg);
     rch->pcdata->alias_sub[pos]    = str_dup(argument);
     act_puts("$t is now aliased to '$T'.", ch, arg, argument, TO_CHAR, POS_DEAD);
}


DO_FUN(do_unalias)
{
    CHAR_DATA *rch;
    char arg[MAX_INPUT_LENGTH];
    int pos;
    bool found = FALSE;

    if (ch->desc == NULL)
    rch = ch;
    else
    rch = ch->desc->original ? ch->desc->original : ch;

    if (IS_NPC(rch))
    return;

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg == '\0')
    {
    char_act("Unalias what?", ch);
    return;
    }

    for (pos = 0; pos < MAX_ALIAS; pos++)
    {
    if (rch->pcdata->alias[pos] == NULL)
        break;

    if (found)
    {
        rch->pcdata->alias[pos-1]       = rch->pcdata->alias[pos];
        rch->pcdata->alias_sub[pos-1]   = rch->pcdata->alias_sub[pos];
        rch->pcdata->alias[pos]     = NULL;
        rch->pcdata->alias_sub[pos]     = NULL;
        continue;
    }

    if(!strcmp(arg,rch->pcdata->alias[pos]))
    {
        char_act("Alias removed.", ch);
        free_string(rch->pcdata->alias[pos]);
        free_string(rch->pcdata->alias_sub[pos]);
        rch->pcdata->alias[pos] = NULL;
        rch->pcdata->alias_sub[pos] = NULL;
        found = TRUE;
    }
    }

    if (!found)
    char_act("No alias of that name to remove.", ch);
}

DO_FUN(do_readext)
{
   act_puts("Flags set: $t", ch, ext_format_flags(ch->ext_flags), NULL, TO_CHAR, POS_DEAD);
}

DO_FUN(do_setext)
{
   ext_read_flags(argument, ch->ext_flags);
}
