/* $Id: keyring.h,v 1.666 2004/09/20 10:49:49 shrike Exp $                            */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/



#ifndef _KEYRING_H_
#define _KEYRING_H_

#define KEYRING_OK                   0
#define KEYRING_NO_KEYRING           1
#define KEYRING_NO_KEY               2
#define KEYRING_NO_REMKEY            3
#define KEYRING_INVALID_KEYRING      4
#define KEYRING_INVALID_KEY          5
#define KEYRING_INVALID_NAME         6
#define KEYRING_KEY_DUP              7
#define KEYRING_MAX_REACHED          8
#define KEYRING_CURSED               9


typedef struct  key_data                KEY_DATA;

struct key_data
{
    KEY_DATA *          next;
    bool                valid;
    OBJ_INDEX_DATA *    index;
};


KEY_DATA * new_key            args((void                                            ));
OBJ_DATA * find_keyring       args((CHAR_DATA * ch                                  ));
int        remove_key         args((CHAR_DATA * ch, OBJ_DATA * keyring, char * name ));
int        add_key            args((OBJ_DATA * keyring, OBJ_DATA * key              ));
void       free_key           args((KEY_DATA * key                                  ));
void       list_keys          args((CHAR_DATA * ch, OBJ_DATA * keyring              ));
void       load_keyring       args((FILE * fp, OBJ_DATA * obj                       ));
void       save_keyring       args((FILE * fp, OBJ_DATA * obj                       ));



#endif
