/* $Id: limited.c,v 1.666 2004/09/20 10:49:49 shrike Exp $                           */


/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "merc.h"

void limits_strip (CHAR_DATA * ch)
{
    OBJ_DATA * obj ;
    int        lim   = 1 ;
    bool       found = FALSE ;

    if (IS_NPC(ch)) return;

    if (!ch->pcdata)  return;

    if (ch->pcdata->limit_timer != 0)
    {
        log_printf ("Limits_strip: called for %s with positive timer.", ch->name) ;
    }

    // loop through all object carried by the character
    for (obj = ch->carrying ; obj != NULL ; obj = obj->next_content)
    {
        // do not touch non-limited objects
        if ((lim = obj->pIndexData->limit) == -1) continue ;

        if (lim == 0)
        {
            bug ("Limits_strip: obj [%d] limited by 0 is in the game!", obj->pIndexData->vnum) ;
            continue ;
        }

        found = TRUE ;

        // probability to extract limited object
        if (number_bits (lim) == 1)
        {
            extract_obj (obj) ;

            // increase timer a bit depending on the limited_by number
            ch->pcdata->limit_timer += (TPH * 2) / lim ;
        }
    }

    // if there was not limit on character (if all limits were cut)
    if (!found) ch->pcdata->limit_timer = LTIMER_DEFAULT ;
}
