/* $Id: log.c,v 1.666 2004/09/20 10:49:49 shrike Exp $                                */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <time.h>

#include "typedef.h"
#include "const.h"
#include "log.h"
#include "util.h"

#ifdef SUNOS
#       include "compat/compat.h"
#endif
#ifdef WIN32
#       include <string.h>
#       define vsnprintf        _vsnprintf
#endif

/*
 * Writes a string to the log.
 */
void log_printf(const char *format, ...)
{
#if defined(WIN32)
        FILE *logfile;
#endif
        time_t current_time;
        char buf[MAX_STRING_LENGTH];
        va_list ap;

        va_start(ap, format);
        vsnprintf(buf, sizeof(buf), format, ap);
        va_end(ap);

        time(&current_time);
        fprintf(stderr, "%s :: %s\n", strtime(current_time), buf);

#if defined (WIN32)
        /* Also add to logfile */
        logfile = fopen ("muddy.log", "a+b");
        if (logfile!=NULL)
        {
                fprintf(logfile, "%s :: %s\n", strtime(current_time), buf);
                fclose (logfile);
        }
#endif
}

void bug_printf(const char *format, ...)
{
    FILE    *debug_log;
    time_t   current_time;
    char     buf[MAX_STRING_LENGTH];
    va_list  ap;
    
    va_start (ap, format);
    vsnprintf(buf, sizeof(buf), format, ap);
    va_end(ap);
    
    time(&current_time);
    
    debug_log = dfopen(LOG_PATH, DEBUG_FILE, "a+b");
    
    if (debug_log !=NULL)
    {
            fprintf(debug_log, "%s :: %s\n", strtime(current_time), buf);
            fclose (debug_log);
    } else
    {
            log_printf("[*****] BUG: unable to open debug file: %s/%s", LOG_PATH, DEBUG_FILE);
    }
}

// TODO:    : date ckan->name char->name operations count char_current_status clan_current_status 
void clanbank_log(CHAR_DATA *ch, int clan, const char *format, ...)
{
    FILE    *clanbank_log;
    time_t   current_time;
    char     buf[MAX_STRING_LENGTH];
    va_list  ap;
    
    va_start (ap, format);
    vsnprintf(buf, sizeof(buf), format, ap);
    va_end(ap);
    
    time(&current_time);
    
    clanbank_log = dfopen(GODS_PATH, CLANBANKLOG_FILE, "a+b");
    
    if (clanbank_log !=NULL)
    {
            fprintf(clanbank_log, "%s :: %s\n", strtime(current_time), buf);
            fclose (clanbank_log);
    } else
    {
            log_printf("[*****] BUG: unable to open clanbank_log file: %s/%s", LOG_PATH, CLANBANKLOG_FILE);
    }
}

void log_channels (const char *format, ...)
{
    FILE *logfile;
    time_t current_time;
    char buf[MAX_STRING_LENGTH];
    va_list ap;
    
    va_start(ap, format);
    vsnprintf(buf, sizeof(buf), format, ap);
    va_end(ap);
    
    time(&current_time);
    logfile = fopen (get_channels_log_file(current_time), "a+b");
    if (logfile!=NULL)
    {
            fprintf(logfile, "%s :: %s\n", strtime(current_time), buf);
            fclose (logfile);
    } else
    {
            log("Error. Could not open channels.log.");
    }
}
/*
 * Reports a bug.
 */
void bug(const char *str, int param)
{
        char buf[MAX_STRING_LENGTH];
        char buf2[MAX_STRING_LENGTH];
        
        snprintf(buf2, sizeof(buf2), "%s %d", str, param);
        snprintf(buf, sizeof(buf), "[*****] BUG: %s", buf2);
        log(buf);
}

