/* $Id: magic.c,v 1.666 2004/09/20 10:49:49 shrike Exp $                            */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 /************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "merc.h"
#include "fight.h"
#include "quest.h"
#include "gquest.h"
#include "rating.h"
#include "fight.h"
#include "cyborg.h"
#include "skills.h"
#include "update.h"
#include "conquer.h"
#include "psionics.h"
#include "war.h"
#include "wanderers.h"
#include "shamans.h"

extern bool check_grounding (CHAR_DATA *ch);
extern bool check_galka     (CHAR_DATA *ch);
extern bool check_dodge     (CHAR_DATA *ch, CHAR_DATA *victim);
extern bool war_can_charm (CHAR_DATA * ch, CHAR_DATA * victim);
extern bool does_not_affect_spell_level (CHAR_DATA * mob);
extern bool check_altar_negation (CHAR_DATA * ch); 
extern bool check_altar_immobility (CHAR_DATA * ch, ROOM_INDEX_DATA * where); 

DECLARE_DO_FUN(do_yell      );
DECLARE_DO_FUN(do_look      );
DECLARE_DO_FUN(do_stand     );
DECLARE_DO_FUN(do_track     );

void agent_net_printf(CHAR_DATA *ch, CHAR_DATA *victim, int);

bool dispel_parser(CHAR_DATA *victim, AFFECT_DATA *paf);
bool dispel       (int level, CHAR_DATA *ch);
bool dispel1      (int level, CHAR_DATA *ch, int sn);
bool dispel2      (int level, CHAR_DATA *ch, flag64_t aff);
        

/*
 * for casting different rooms
 * returned value is the range
 */
int allowed_other(CHAR_DATA *ch, int sn)
{
    if (IS_SET(SKILL(sn)->flags, SKILL_RANGE))
        return ch->level / 20 + 1;
    return 0;
}

/*
 * The kludgy globasl are for spells who want more stuff from command line.
 */
const char *target_name;
const char *extra_arguments;

/*
 *  * check_trust - check if victim allow ch to cast SPELL_QUESTIONABLE spell
 *   */
bool check_trust(CHAR_DATA *ch, CHAR_DATA *victim)
{
    if (ch == victim)
        return TRUE;
            
    if (IS_NPC(victim))
    {
        if (is_same_group(ch, victim))
            return TRUE;
        if (victim->clan && (victim->clan == ch->clan
        || CLAN(victim->clan)->diplomacy[ch->clan] == DIP_ALLY))
            return TRUE;
        if (IS_GOOD(ch) && IS_GOOD(victim))
            return TRUE;
        return FALSE;
    }
                
    if (IS_SET(victim->pcdata->trust, TRUST_ALL))
        return TRUE;
                    
    if (IS_SET(victim->pcdata->trust, TRUST_ALIGN)
    && ch->alignment == victim->alignment)
        return TRUE;

    return (IS_SET(victim->pcdata->trust, TRUST_GROUP) 
        && is_same_group(ch, victim))
        || (ch->clan && IS_SET(victim->pcdata->trust, TRUST_CLAN) 
        && (ch->clan == victim->clan 
        || (CLAN(ch->clan)->diplomacy[victim->clan] == DIP_ALLY 
        && CLAN(victim->clan)->diplomacy[ch->clan] == DIP_ALLY)));
}

bool can_cast(CHAR_DATA *ch, CHAR_DATA *victim)
{
    if (ch == NULL || victim == NULL)
        return FALSE;

    if (ch->in_war && victim->in_war && (ch->in_war == victim->in_war)
    && (ch->war_status == PS_ALIVE))
        return TRUE;

    if (IS_SET(ch->comm, PLR_PEACE))
    {
        if ((!IS_NPC(victim) && !IS_SET(victim->comm, PLR_PEACE))
        || (IS_NPC(victim) && victim->master && !IS_NPC(victim->master) 
        && !IS_SET(victim->master->comm, PLR_PEACE)))
        {
            act("Your energy does not reach $N.", ch, NULL, victim, TO_CHAR); 
            return FALSE;
        }
    }
    return TRUE;
}

void make_spellbane(CHAR_DATA *ch, CHAR_DATA *victim, int mult)
{
    if (ch == victim) 
    {
        char_act("Your spellbane has deflected the spell!", ch);
        act("$N's spellbane has deflected the spell!", ch, NULL, ch, TO_ROOM);
        damage(ch, ch, mult * ch->level, gsn_spellbane, DAM_NEGATIVE, TRUE);
    } else 
    {
        act_puts("$N deflects your spell!", ch, NULL, victim, TO_CHAR, POS_DEAD);
        act("You deflect $n's spell!", ch, NULL, victim, TO_VICT);
        act("$N deflects $n's spell!", ch, NULL, victim, TO_NOTVICT);
        if (!is_safe(ch, victim)) 
        {
            damage(victim, ch, mult * victim->level, gsn_spellbane, 
                            DAM_NEGATIVE, TRUE);
            check_improve(victim, gsn_spellbane, TRUE, 1);
        }
    }   
    return;
}
/*
 * spellbane checker for do_cast, do_cast_obj
 */
bool check_spellbane_org(CHAR_DATA *ch, CHAR_DATA *victim, int sn, int bane_chance, int mult)
{
    if (!IS_MAGIC(sn))
        return FALSE;

    if (!IS_AFFECTED(victim, AFF_SPELLBANE)
    || (number_percent() >= bane_chance)) 
        return FALSE;

    make_spellbane(ch, victim, mult);
    return TRUE;
}
/*
 * spellbane checker for other places missed in do_cast, do_cast_obj
 */
bool check_spellbane(CHAR_DATA *ch, CHAR_DATA *victim, int sn)
{
    skill_t *sk; 
    if (IS_IMMORTAL(ch))
        return FALSE;
    if (!IS_AFFECTED(victim, AFF_SPELLBANE)
    || (number_percent() >= get_skill(victim, gsn_spellbane) * 2 / 3)) 
        return FALSE;
    sk = SKILL(sn);
    if (sk->type != TYPE_SPELL 
    && sk->type != TYPE_MIRACLE 
    && sk->type != TYPE_PROGRAM)
        return FALSE;
    if (!IS_SET(sk->flags, SKILL_AREA_ATTACK))
        return FALSE;
    if (IS_SET(sk->group, GROUP_HEALING | GROUP_PROTECTIVE |
                         GROUP_ENHANCEMENT | GROUP_CURATIVE))
        return FALSE;
    make_spellbane(ch, victim, 3);
    return TRUE;
}

bool check_absorb(CHAR_DATA *ch, CHAR_DATA *victim, int sn, bool distant)
{
    skill_t *sk;
    if ((ch == victim) 
    || !IS_AFFECTED(victim, AFF_ABSORB)
    || (number_percent() >= get_skill(victim, gsn_absorb) * 2/3))
        return FALSE;
    sk = SKILL(sn);
    if (sk->type != TYPE_SPELL)
        return FALSE;
    if (distant && !IS_SET(sk->flags, SKILL_AREA_ATTACK))
        return FALSE;   
    act("Your $t fails to pass $N's energy field!",
        ch, flag_string(skill_types, sk->type), victim, TO_CHAR | ACT_TRANS);
    act("You absorb $n's $t!",
        ch, flag_string(skill_types, sk->type), victim, TO_VICT | ACT_TRANS);
    act("$N absorbs $n's $t!",
        ch, flag_string(skill_types, sk->type), victim, TO_NOTVICT | ACT_TRANS);
    check_improve(victim, gsn_absorb, TRUE, 1);
    if (distant || IS_NPC(ch))
        victim->mana += sk->min_mana;
    return TRUE;
}

bool check_components(CHAR_DATA *ch, int sn, int chance)
{
    skill_t *spell;
    spell = SKILL(sn);

    if (IS_SET(ch->comm, COMM_NOCAST) 
    && !IS_SKILL(sn) && !IS_ABILITY(sn) && !IS_LANGUAGE(sn))
    {
        char_printf(ch, "The gods have deprived you of the ability to cast spells.\n");
        return FALSE;
    }

    if (ch->position < spell->min_pos) 
    {
        char_act("You cannot concentrate.", ch);
        return FALSE;
    }

    if (ch->in_room 
    && (IS_SET(ch->in_room->room_flags, ROOM_BATTLE_ARENA) 
    || (ch->in_war && ch->war_status == PS_ALIVE))
    && IS_SET(spell->flags, SKILL_NOARENA))
    {
        char_act("You can't use it at the battle arena.", ch);
        return FALSE;
    }

    if (is_affected(ch, gsn_shielding) && IS_SPELL(sn)) 
    {
        char_act("You're trying to reach for the Absolute Lore but something blocks you.", ch);
        return FALSE;
    }
                            
    if (is_affected(ch, gsn_garble) && IS_SET(spell->flags, SKILL_VERBAL)) 
    {
        char_act("Your lips counter to your will say rubbish.", ch);
        return FALSE;
    }

    if (is_affected(ch, gsn_deafen) && IS_SET(spell->flags, SKILL_VERBAL)) 
    {
        char_act("It seems your incantations are not precise.", ch);
        if (!IS_NPC(ch))
        {
            ch->mana -= mana_cost(ch, sn) / 2;
            ch->mana = UMAX(ch->mana, 0);
        }
        WAIT_STATE(ch, spell->beats / 2);
        return FALSE;
    }

    if (IS_AFFECTED(ch, AFF_WEB) && IS_SET(spell->flags, SKILL_GEST)) 
    {
        if (number_percent() >= 30)
        {
            char_act("You are moving too clumsily in the web.", ch);
            if (!IS_NPC(ch))
            {
                ch->mana -= mana_cost(ch, sn) / 2;
                ch->mana = UMAX(ch->mana, 0);
            }
            WAIT_STATE(ch, spell->beats / 2);
            return FALSE;
        }
    }

    if (IS_AFFECTED(ch, AFF_FEAR) && IS_SET(spell->flags, SKILL_MENTAL)) 
    {
        char_act("You are too scared for this.", ch);
        return FALSE;
    }

    if (HAS_SKILL(ch, gsn_vampire)
    && !IS_SET(ch->form, FORM_VAMPIRE)
    && !IS_SET(spell->flags, SKILL_CLAN)
    && (IS_MAGIC(sn) || IS_SET(spell->flags, SKILL_VAMPIRE))
    && (sn != gsn_vampire))
    {
        act("You can use this $t only in vampiric form!",
              ch, flag_string(skill_types, spell->type), NULL, TO_CHAR | ACT_TRANS);
        return FALSE;
    }

    if (HAS_SKILL(ch, gsn_spellbane) && IS_MAGIC(sn)) 
    {
        char_act("You the Furious Warrior, instead of the magician shameful!", ch);
        return FALSE;
    }

    if ((ch->level < LEVEL_IMMORTAL) 
    && IS_SET(ch->in_room->room_flags, ROOM_NOMAGIC)
    && !IS_NONMAGIC(sn)
    && !HAS_SKILL(ch, gsn_spellbane))
    {
        act("Seems, your $ts are powerless here.", 
            ch, flag_string(skill_types, spell->type), NULL, TO_CHAR | ACT_TRANS);
        act("Seems, $n's $ts are powerless here.",
            ch, flag_string(skill_types, spell->type), NULL, TO_ROOM | ACT_TRANS);
        return FALSE;
    }
    
    if (!IS_NPC(ch))
    {
        if ((ch->level < LEVEL_IMMORTAL) && IS_CLAN_SKILL(spell)) 
        {
            chance = get_clan_max_percent(ch, sn, chance);

            // here we call check_altar_negation second time
            // bad thing, but.. let it be
            if (chance == 0) 
            {
                if (check_altar_negation (ch))
                    char_act ("An altar of {mnegation{x blocks your clan power!", ch);
                else
                    char_act("All over again return a clan item.", ch);
                return FALSE;
            }
        }
    }

    if (chance == 0) {
        switch(spell->type) 
        {
            case TYPE_SPELL:
                char_act("You do not know such spell.", ch);
                break;
            case TYPE_MIRACLE:
                char_act("You cannot ask Gods about such miracle.", ch);
                break;
            case TYPE_POWER:
                char_act("You cannot concentrate on such ability.", ch);
                break;
            case TYPE_ABILITY:
                char_act("You do not possess such ability.", ch);
                break;
            case TYPE_SONG:
                char_act("You cannot sing it.", ch);
                break;
            case TYPE_PROGRAM:
                char_act("At you it is not established such program.", ch);
                break;
            case TYPE_LANGUAGE:
                char_act("You do not know such language.", ch);
                break;
            default:
                char_act("You are not familiar with the given ability.", ch);
        }
        return FALSE;
    }

    if (spell->spell_fun == NULL
    && !IS_SKILL(sn) && !IS_ABILITY(sn) && !IS_LANGUAGE(sn)) 
    {
        act("This $t can't be used in that way. Look at {Chelp $T{x.", 
            ch, flag_string(skill_types, spell->type), 
                spell->name, TO_CHAR | ACT_TRANS);
        return FALSE;
    }
    
    return TRUE;
}

bool target_ioga(CHAR_DATA *ch, int sn, int * ptarget, void **pvo, int *poff, int *pdoor)
{
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    void* vo;
    char targetname[MAX_STRING_LENGTH];
    char tmp[MAX_STRING_LENGTH];
    char *p;
    int target, range;
    skill_t *spell;
    
    /*
     * Locate targets.
     */
    victim      = NULL;
    obj         = NULL;
    vo          = NULL;
    target      = TARGET_NONE;

    one_argument(target_name, tmp, sizeof(tmp));
    if (!str_cmp(tmp, "at"))
        target_name = one_argument(target_name, tmp, sizeof(tmp));

    strnzcpy(targetname, sizeof(targetname), target_name);
    if ((p = strchr(targetname, ':')) != NULL)
    {
        *p = '\0';
        extra_arguments = p+1;
    } else
        extra_arguments = str_empty;

    spell = SKILL(sn);

    switch (spell->target) 
    {
    default:
        bug("Do_cast: bad target for sn %d.", sn);
        return FALSE;

    case TAR_IGNORE:
        break;

    case TAR_CHAR_OFFENSIVE:
        if (targetname[0] == '\0') 
        {
            if ((victim = ch->fighting) == NULL || victim->in_room != ch->in_room) 
            {
                act("Use $t at whom?", 
                    ch, flag_string(skill_types, spell->type), NULL, TO_CHAR);
                return FALSE;
            }
        } else 
        {
            if ((range = allowed_other(ch, sn)) > 0) 
            {
                if (!(victim = get_char_spell(ch, targetname, pdoor, range)))
                    return FALSE;
                
                if (IS_NPC(victim)
                &&  victim->in_room != ch->in_room) 
                {
                    if (room_is_private(ch->in_room)) 
                    {
                        act("You can't use this $t in private realms.", 
                            ch, flag_string(skill_types, spell->type), NULL, TO_CHAR); 
                        return FALSE;
                    }
                    
                    if (IS_SET(victim->pIndexData->act, ACT_NOTRACK)
                    && !IS_AFFECTED(victim, AFF_CHARM))
                    {
                        act_puts("You can't use this $t at $N so far away.", 
                            ch, flag_string(skill_types, spell->type), victim, TO_CHAR, POS_DEAD); 
                        return FALSE;
                    }
                }
            } else if (!(victim = get_char_room(ch, targetname))) 
            {
                char_act("They aren't here.", ch); 
                return FALSE;
            }
        }

        vo = (void *) victim;
        target = TARGET_CHAR;

        break;

    case TAR_CHAR_DEFENSIVE:
        if (targetname[0] == '\0')
            victim = ch;
        else if ((victim = get_char_room(ch, targetname)) == NULL) 
        {
            char_act("They aren't here.", ch); 
            return FALSE;
        }

        vo = (void *) victim;
        target = TARGET_CHAR;
        break;

    case TAR_CHAR_SELF:
        if (targetname[0] == '\0')
            victim = ch;
        else 
        {
            if ((victim = get_char_room(ch, targetname)) == NULL
            || (!IS_NPC(ch) && victim != ch)) 
            {
                act("You can't use this $t on others.", 
                    ch, flag_string(skill_types, spell->type), NULL, TO_CHAR);
                char_act("They aren't here.", ch); 
                return FALSE;
            }
        }

        vo = (void *) victim;
        target = TARGET_CHAR;
        break;

    case TAR_OBJ_INV:
        if (targetname[0] == '\0') 
        {
            act("What is the target?", 
                            ch, NULL, NULL, TO_CHAR); 
            return FALSE;
        }

        if ((obj = get_obj_carry(ch, targetname)) == NULL) 
        {
            act("At you it is not present.", 
                    ch, NULL, NULL, TO_CHAR); 
            return FALSE;
        }

        vo = (void *) obj;
        target = TARGET_OBJ;
        break;

    case TAR_OBJ_CHAR_OFF:
        if (targetname[0] == '\0') {
            if ((victim = ch->fighting) == NULL) 
            {
                act("What or whom is the target?",
                      ch, NULL, NULL, TO_CHAR); 
                return FALSE;
            }
            target = TARGET_CHAR;
        } else if ((victim = get_char_room(ch, targetname)))
            target = TARGET_CHAR;

        if (target == TARGET_CHAR) 
        {
            if (IS_AFFECTED(ch, AFF_CHARM)
            && ch->master == victim) 
            {
                act("You cannot make it on the Master.", ch, NULL, NULL, TO_CHAR);
                return FALSE;
            }
            vo = (void *) victim;
        } else if ((obj = get_obj_here(ch, targetname))) 
        {
            vo = (void *) obj;
            target = TARGET_OBJ;
        } else 
        {
            act("You do not see it here.", ch, NULL, NULL, TO_CHAR); 
            return FALSE;
        }
        break;

    case TAR_OBJ_CHAR_DEF:
        if (targetname[0] == '\0') 
        {
            vo = (void *) ch;
            target = TARGET_CHAR;
        } else if ((victim = get_char_room(ch, targetname))) 
        {
            vo = (void *) victim;
            target = TARGET_CHAR;
        } else if ((obj = get_obj_carry(ch, targetname))) 
        {
            vo = (void *) obj;
            target = TARGET_OBJ;
        } else 
        {
            act("You do not see it here.", 
                            ch, NULL, NULL, TO_CHAR); 
            return FALSE;
        }
        break;
    }

    say_spell(ch, sn);

    if (!victim)
        victim = ch;
    
    switch (target) 
    {
        case TARGET_CHAR:
            vo = (void *) victim;
            switch (spell->target) 
            {   
                case TAR_CHAR_DEFENSIVE:
                case TAR_OBJ_CHAR_DEF:
                    if (IS_SET(spell->flags, SKILL_QUESTIONABLE)
                    && !check_trust(ch, victim)) 
                    {
                         act("$N do not trust you enough for this $t.", 
                            ch, flag_string(skill_types, spell->type), 
                                victim, TO_CHAR);
                         return FALSE;
                    }
                    break;
                                                
                case TAR_CHAR_OFFENSIVE:
                case TAR_OBJ_CHAR_OFF:
                    *poff = TRUE;
                    if (IS_SET(spell->flags, SKILL_QUESTIONABLE))
                        *poff = !check_trust(ch, victim);
                    if (*poff)
                    {
                        if (is_safe(ch, victim))
                            return FALSE;
                     
                        if (!IS_NPC(ch)
                        && !IS_NPC(victim)
                        && victim != ch
                        && ch->fighting != victim
                        && victim->fighting != ch
                        && !IS_AFFECTED(victim, AFF_CHARM))
                        {
                            act_yell(victim, "Die $i, you nasty dog!", ch, NULL);
                            agent_net_printf(victim, ch, ANET_ATTACK);
                        }
                        break;
                    }
            }
            break;

        case TARGET_OBJ:
            vo = (void*) obj;
            break;
    }
    *ptarget = target;
    *pvo = vo;
    return TRUE;
}

// Procedure for detecting skill/spell levels.
// Not used for psionic powers and most (auto)skills, actually.
int spell_level(CHAR_DATA *ch, int sn, bool offensive)
{
    OBJ_DATA    *staff;
    skill_t     *spell;
    CHAR_DATA   *gch;
    AFFECT_DATA *paf;
    int slevel, clevel, chance;

    if ((spell = SKILL(sn)) == NULL)
        return 0;

    if (IS_NPC(ch))
        return ch->level + 1 + ch->level/40;

    if (!IS_MAGIC(sn))
        slevel = LVL(ch);
    else if (is_class_mage(ch))
        slevel = LVL(ch) - UMAX(0,(ch->level / 20));
    else
        slevel = LVL(ch) - UMAX(5,(ch->level / 10));

    if (IS_CLAN_SKILL(spell)) slevel = LVL(ch);

    if (IS_SPELL(sn) && (chance = get_skill(ch, gsn_spell_craft))) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            check_improve(ch, gsn_spell_craft, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_spell_craft, FALSE, 1);
    }

    if (IS_MIRACLE(sn) && (chance = get_skill(ch, gsn_faith))) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            check_improve(ch, gsn_faith, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_faith, FALSE, 1);
    }

    if (IS_PROGRAM(sn) && (chance = get_skill(ch, gsn_computers))) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            check_improve(ch, gsn_computers, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_computers, FALSE, 1);
    }

    if (IS_SONG(sn) && (chance = get_skill(ch, gsn_singing))) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            check_improve(ch, gsn_singing, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_singing, FALSE, 1);
    }

    // Ok, now different improvements
    if (IS_SET(spell->group, GROUP_MALADICTIONS)
    && (chance = get_skill(ch, gsn_improved_maladiction))) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            slevel += chance/50;
            check_improve(ch, gsn_improved_maladiction, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_improved_maladiction, FALSE, 1);
    }

    if ((chance = get_skill(ch, gsn_improved_necromancy))
    && IS_SET(spell->group, GROUP_NECROMANCY)) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            slevel += chance/50;
            check_improve(ch, gsn_improved_necromancy, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_improved_necromancy, FALSE, 1);
    }

    if ((chance = get_skill(ch, gsn_improved_beguiling))
    && IS_SET(spell->group, GROUP_BEGUILING)) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            slevel += chance/50;
            check_improve(ch, gsn_improved_beguiling, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_improved_beguiling, FALSE, 1);
    }

    if ((chance = get_skill(ch, gsn_improved_combat))
    && IS_SET(spell->group, GROUP_COMBAT)) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            slevel += chance/20;
            check_improve(ch, gsn_improved_combat, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_improved_combat, FALSE, 1);
    }

    if ((chance = get_skill(ch, gsn_improved_attack))
    && IS_SET(spell->group, GROUP_ATTACK)) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            slevel += chance/10;
            check_improve(ch, gsn_improved_attack, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_improved_attack, FALSE, 1);
    }

    if ((chance = get_skill(ch, gsn_improved_benediction))
    && IS_SET(spell->group, GROUP_BENEDICTIONS)) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            slevel += chance/10;
            check_improve(ch, gsn_improved_benediction, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_improved_benediction, FALSE, 1);
    }

    if ((chance = get_skill(ch, gsn_improved_protective))
    && IS_SET(spell->group, GROUP_PROTECTIVE)) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            slevel += chance/10;
            check_improve(ch, gsn_improved_protective, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_improved_protective, FALSE, 1);
    }

    if ((chance = get_skill(ch, gsn_improved_summoning))
    && IS_SET(spell->group, GROUP_SUMMONING)) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            slevel += chance / 10;
            check_improve(ch, gsn_improved_summoning, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_improved_summoning, FALSE, 1);
    }

    if ((chance = get_skill(ch, gsn_improved_curative))
    && IS_SET(spell->group, GROUP_HEALING)) 
    {
        if (number_percent() < chance) 
        {
            slevel = UMAX(slevel, LVL(ch));
            slevel += chance / 10;
            slevel += LVL(ch);
            check_improve(ch, gsn_improved_curative, TRUE, 1);
        } 
        else
            check_improve(ch, gsn_improved_curative, FALSE, 1);
    }

    if (IS_SPELL(sn) && (number_percent() < get_skill(ch, gsn_mastering_spell))
    && IS_SET(spell->group, GROUP_HEALING | GROUP_PROTECTIVE 
        | GROUP_ENHANCEMENT | GROUP_CURATIVE))
    {
        slevel += number_range(3, 4);
        check_improve(ch, gsn_mastering_spell, TRUE, 1);
    }

    if (is_class_mage(ch))
    {
        if (IS_MIRACLE(sn))
        {
            slevel += UMAX(0, get_curr_stat(ch, STAT_WIS) - 21);
            slevel += UMAX(0, get_curr_stat(ch, STAT_INT) - 21)/2;
        } 
        else if (IS_SPELL(sn))
        {
            slevel += UMAX(0, get_curr_stat(ch, STAT_INT) - 21);
            slevel += UMAX(0, get_curr_stat(ch, STAT_WIS) - 21)/2;
        } 
        else if (IS_PROGRAM(sn))
        {
            slevel += (UMAX(0, get_curr_stat(ch, STAT_INT)-21) +
                       UMAX(0, get_curr_stat(ch, STAT_WIS)-21)) * 3/4;
        }
    }

    if (IS_SONG(sn))
        slevel += UMAX(0, get_curr_stat(ch, STAT_CHA)) * 3/2;
    if (IS_POWER(sn))
        slevel += (UMAX(0, get_curr_stat(ch, STAT_INT)-21) +
                    UMAX(0,get_curr_stat(ch, STAT_WIS)-21) +
                    UMAX(0,get_curr_stat(ch, STAT_CON)-21)) / 2;


// - ,  classes/ 
    if (!IS_CLAN_SKILL(spell) && IS_MAGIC(sn)
    && (((ch->class == CLASS_CLERIC) /*&& IS_MIRACLE(sn)*/) 
    || ((ch->class == CLASS_PRIEST) /*&& IS_MIRACLE(sn)*/)
    || ((ch->class == CLASS_OCCULTIST) /*&& IS_MIRACLE(sn)*/)
    || ((ch->class == CLASS_ENGINEER) /*&& IS_PROGRAM(sn)*/)) )
    {
        if (offensive)
            slevel = number_range(slevel, slevel + slevel/10);
        else
            slevel = number_range(slevel, UMAX(100, slevel + 20));
    }

    if (slevel < 1)
        slevel = 1;

    // GM : Applying spellaffect as extra levels for spells
    for (paf = ch->affected;paf; paf = paf->next)
        if (paf->location == APPLY_SPELL_AFFECT)
            slevel += paf->modifier;

    // GM : Applying Bonus for Magic Room
    if (IS_SET(ch->in_room->room_flags, ROOM_MAGIC) && IS_SPELL(sn))
        slevel += 2;

    // GM : Applying Bonus for Staves and Wands
    if ((staff = get_eq_char(ch, WEAR_HOLD))
    && (staff->pIndexData->item_type == ITEM_STAFF
    || staff->pIndexData->item_type == ITEM_WAND))
    {
        if (staff->value[3] == sn)
        {
            if (is_class_warrior(ch)) // GM: Real Mages have a real bonus
                slevel += number_range(2, 2 + staff->value[0] / 25);
            else
                slevel += staff->value[0] / 25 + 2;
        } else
        {
            if (is_class_warrior(ch)) // GM: Real Mages have a real bonus
                slevel += number_range(1, 1 + staff->level / 45);
            else
                slevel += staff->level / 45 + 1;
        }

        if (staff->pIndexData->vnum == OBJ_VNUM_WAND_EMPOWERED
        || staff->pIndexData->vnum == OBJ_VNUM_STAFF_EMPOWERED)
        {
            if (is_class_warrior(ch)) // GM: Real Mages have a real bonus
                slevel += number_range(1, 1 + staff->level / 45);
            else
                slevel += staff->level / 45 + 1;
        }
    }

    // GM : Better casting without charmies
    clevel = 0;

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (is_same_group(gch, ch) 
        && IS_AFFECTED(gch, AFF_CHARM)
        && (gch->master == ch))
        {
            if (does_not_affect_spell_level (gch))
                continue;
            clevel++;
        }
    }
    slevel -= number_range(clevel / 2,clevel * 2);

    if (altar_works (ch, ALTAR_MAGIC_POS))
    {
        char_act ("You feel a stream of energy and your magic becomes stronger!", ch);
        slevel += number_range (1,2); 
    }

    slevel = UMAX(1, slevel);
    
    return slevel;
}

int spellbane_chance(CHAR_DATA *ch, CHAR_DATA *victim, skill_t *spell)
{
    int bane_chance = 100;
    if (spell->target == TAR_CHAR_OFFENSIVE)
        bane_chance = get_skill(victim, gsn_spellbane); 
    if (IS_SET(spell->group, GROUP_COMBAT | GROUP_ATTACK))
        bane_chance -= 20;
    if (spell->type == TYPE_SPELL)
        bane_chance -= (get_skill(ch, gsn_mastering_spell) / 20);
    if (IS_SET(spell->group, GROUP_HEALING | GROUP_PROTECTIVE |
                         GROUP_ENHANCEMENT | GROUP_CURATIVE))
        bane_chance = 120; //   :))
    return bane_chance;
}

void do_cast_org(CHAR_DATA *ch, const char *argument, int type)
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    void *vo;
    int mana = 0;
    int sn = -1;
    int target;
    int door;
    bool cast_far = FALSE;
    bool offensive = FALSE;
    int slevel;
    int chance = 0;
    int spell_power = 0;
    skill_t *spell; 
    pcskill_t *ps; 
    OBJ_DATA * wield;

    target_name = one_argument(argument, arg2, sizeof(arg2));

    if (arg2[0] == '\0') 
    {
        char_act("To make that, how, where?", ch);
        return;
    }

    substitute_skill_alias(arg2, arg1, sizeof(arg1));

    if (IS_NPC(ch)) 
    {
        if (!str_cmp(arg1, "nowait")) 
        {
            target_name = one_argument(target_name, arg1, sizeof(arg1));
            if (ch->wait)
                ch->wait = 0;
        } else if (ch->wait) 
        {
//          log_printf("%s: wait state %d", ch->name, ch->wait);
            return;
        }
        sn = sn_lookup(arg1);
        chance = get_skill(ch, sn);
    } else 
    {
        spell_power = mult_argument(arg1, arg1, sizeof(arg1));

        if (spell_power < 2)
            spell_power = 0;

        if ((ps = skill_vlookup_type(&ch->pcdata->learned, arg1, type))
        &&  skill_level(ch, sn = ps->sn) <= ch->level)
            chance = ps->percent;
    }

    if (sn < 0 || (spell = SKILL(sn)) == NULL)
    {
        act("No such $t, or skill of any other type.",
                ch, flag_string(skill_types, type), NULL, TO_CHAR | ACT_TRANS);
        return;
    }

    if (IS_RITUAL (sn)) 
    {
        do_perform (ch, argument);
        return;
    }

    if (IS_TATTOO (sn))
    {
        do_activate (ch, argument);
        return;
    }

    if (IS_POWER(sn) && HAS_SKILL(ch, gsn_psionics))
    {
        do_concentrate(ch, argument);
        return;
    }

    if (!IS_SPELL(sn) && !IS_PROGRAM(sn))
        spell_power = 0;

    if (IS_SET(ch->form, FORM_BEAR | FORM_WOLF)
    && !IS_NONMAGIC(sn) 
    && number_percent() > get_skill(ch, gsn_body_control))
    {
        WAIT_STATE(ch, spell->beats / 4); // GM :     .
        check_improve(ch, gsn_body_control, FALSE, 20);
        char_act("The animal inside does not allow you to concentrate.", ch);
        return;
    }
    check_improve(ch, gsn_body_control, TRUE, 4);

//  if(IS_NPC(ch) || type < 0)
        type = spell->type;
    
    if(spell->type != type)
    {
        act_puts3("'$t' is a $T, not a $U.",
                ch,
                spell->name,
                flag_string(skill_types, spell->type),
                flag_string(skill_types, type), 
                TO_CHAR | ACT_TRANS, POS_DEAD);
        return;
    }

    if (!check_components(ch, sn, chance))
        return;

    if (!IS_NPC(ch)) 
    {
        if (number_percent() < get_skill(ch, gsn_mastering_spell))
            mana = mana_cost(ch, sn) + 640 * spell_power;
        else
            mana = mana_cost(ch, sn) + 1000 * spell_power;

        if (ch->mana < mana) 
        {
            char_act("You have not enough mana.", ch);
            return;
        }
    } 

    if (!target_ioga(ch, sn, &target, &vo, &offensive, &door))
    {
        WAIT_STATE(ch, MISSING_TARGET_DELAY);           
        return;
    }
    victim = NULL;
    if (target == TARGET_CHAR)
    {
        victim = (CHAR_DATA *) vo;
        cast_far = victim->in_room != ch->in_room;
        if (victim->in_room 
        && (IS_SET(victim->in_room->room_flags, ROOM_BATTLE_ARENA) 
        || (victim->in_war && victim->war_status == PS_ALIVE ))
        && IS_SET(spell->flags, SKILL_NOARENA))
        {
            char_act("You can't use it versus people at the battle arena.", ch);
            return;
        }
    }

    if ((!IS_NPC(ch)) && (ch->pcdata)
    && (spell->target == TAR_CHAR_DEFENSIVE
    || spell->target == TAR_CHAR_SELF
    || spell->target == TAR_OBJ_CHAR_DEF))
    {
        if (IS_SET(ch->pcdata->wishes, WISH_SPELLUP2))
            WAIT_STATE(ch, spell->beats / 4);
        else if (IS_SET(ch->pcdata->wishes, WISH_SPELLUP1))
            WAIT_STATE(ch, spell->beats / 2);
        else
            WAIT_STATE(ch, spell->beats);
    }
    else if ((!IS_NPC(ch))
    && (ch->pcdata)
    && (victim != NULL)
    && (victim->in_room == ch->in_room)
    && offensive
    && IS_SET(spell->group, GROUP_COMBAT | GROUP_ATTACK))
    {
        if (IS_AFFECTED(ch, AFF_HASTE))
        {
            WAIT_STATE(ch, spell->beats / 2);
        } else if (IS_AFFECTED(ch, AFF_SLOW))
        {
            WAIT_STATE(ch, spell->beats * 2);
        } else
            WAIT_STATE(ch, spell->beats);
    }
    else if (HAS_SKILL(ch, gsn_improved_curative)
    && IS_SET(spell->group, GROUP_HEALING | GROUP_CURATIVE))
        WAIT_STATE(ch, spell->beats / 2);
    else
        WAIT_STATE(ch, spell->beats);

    if (target == TARGET_CHAR && victim->religion == RELIGION_KEMM
    && (IS_SPELL(sn) || IS_MIRACLE(sn))
    && (NULL != get_eq_char(victim, WEAR_TATTOO))
    && victim != ch
    && number_percent() < 10)
    {
        if (!check_galka(ch))
        {
            act_puts("$N's tattoo glows {Ggreen{z and $gN{he} reject your spell!",
                ch, NULL, victim, TO_CHAR, POS_DEAD);
            act("Your tattoo glows {Ggreen{z and your reject $n's spell!",
                ch, NULL, victim, TO_VICT);
            act("$N's tattoo glows {Ggreen{z and $gN{he} reject $n's spell!",
                ch, NULL, victim, TO_NOTVICT);
            return;
        }
    }
    // GM: lightsaber chance - lightsaber defence mode.
    if (target == TARGET_CHAR
    && victim != ch)
    {
        wield = get_eq_char (victim, WEAR_WIELD);

        if (wield && wield->value[0] == WEAPON_LIGHTSABER
        && (number_range(0, 300) < get_skill(ch, sn_lookup("saberdefense"))))
        {
            act_puts("$N's lightsword glows and $gN(he) absorbs your spell!",
                ch, NULL, victim, TO_CHAR, POS_DEAD);
            act("Your lightsword glows and you absorb $n's spell!",
                ch, NULL, victim, TO_VICT);
            act("$N's lightsword glows and $gN(he) absorbs $n's spell!",
                ch, NULL, victim, TO_NOTVICT);
            victim->mana += mana;
            victim->mana = UMIN(victim->mana, victim->max_mana);
            check_improve(ch, sn_lookup("saberdefense"), TRUE, 1);
            return;
        } else
            check_improve(ch, sn_lookup("saberdefense"), FALSE, 1);
    }
    // GM: cast control aka spell power
    if (spell_power > 0)
    {
        int sp_chance = 100;
        sp_chance -= spell_power * 20;
        if (IS_SPELL(sn))
        {
            sp_chance += (get_skill(ch, gsn_mastering_spell) / 10);
            sp_chance += (get_skill(ch, gsn_cast_control) / 2);
            check_improve(ch, gsn_cast_control, TRUE, 1);           
        }
        if (IS_POWER(sn))
        {
            sp_chance += (get_skill(ch, gsn_psionics) * 2 / 5);
            check_improve(ch, gsn_psionics, TRUE, 1);
        }
        if (IS_PROGRAM(sn))
        {
            sp_chance += get_skill(ch, gsn_optimization) / 2;
            check_improve(ch, gsn_optimization, TRUE, 1);
        }
        if (number_percent() > sp_chance && !IS_IMMORTAL(ch))
        {
            act("$t of $n out of control!",
                        ch, 
                        IS_SPELL(sn) ? "Magic" : "Power", 
                        NULL, TO_ROOM);
            act("$t out of control!", 
                        ch, 
                        IS_SPELL(sn) ? "Your magic" : "Your power", 
                        NULL, TO_CHAR);
            ch->mana = 0;
            WAIT_STATE(ch, spell->beats * 2);
            return;
        }
    }

    if (ch->daze >= 16) 
       chance = URANGE(0, chance, 10); 
    else if (ch->daze >=  8) 
       chance = URANGE(0, chance, 25); 
    else if (ch->daze >=  4) 
       chance = URANGE(0, chance, 50);

    if (number_percent() > chance)
    {
        switch(type)
        {
            case TYPE_SPELL:
                act("Your magic power betrays you.",
                    ch, NULL, NULL, TO_CHAR);
                break;
            case TYPE_POWER:
                act("Your concentration is broken.",
                    ch, NULL, NULL, TO_CHAR);
                break;
            case TYPE_MIRACLE:
                act("Your faith betrays you.",
                    ch, NULL, NULL, TO_CHAR);
                break;
            case TYPE_SONG:
                act("You fail to perform a singing skill.",
                    ch, NULL, NULL, TO_CHAR);
                break;
            case TYPE_PROGRAM:
                act("Unexpected error found... Program aborted.",
                    ch, NULL, NULL, TO_CHAR);
                break;
            default:
                act("You failed to use a $t.",
                    ch, flag_string(skill_types, spell->type), NULL, TO_CHAR);
        }
        if (type != TYPE_SKILL)
            check_improve(ch, sn, FALSE, 1);
        ch->mana -= mana / 2;
        if (cast_far) 
            cast_far = FALSE;
    } 
    else 
    {
        slevel = spell_level(ch, sn, offensive) + spell_power;

        if (victim)
        {
            if (!can_cast(ch, victim))
                return;
            if (check_spellbane_org(ch, victim, sn, spellbane_chance(ch, victim, spell), 3))
                return;
            if (check_absorb(ch, victim, sn, FALSE))
            {
                ch->mana -= mana;
                victim->mana += mana;
                return;
            } 
        }

        ch->mana -= mana;
        if (spell->spell_fun != NULL)
        {
            spell->spell_fun(sn, slevel, ch, vo, target);
            check_improve(ch, sn, TRUE, 1);
        } else if (spell->do_fun != NULL)
        {
            spell->do_fun(ch, target_name);
        }
    }
    
    if (target != TARGET_CHAR || JUST_KILLED(ch) || JUST_KILLED(victim))
        return;

    if (cast_far && door != -1)
    {
        path_to_track(ch, victim, door);
        return;
    }

    if (offensive && victim != ch && victim->master != ch
    && victim->fighting == NULL && IS_AWAKE(victim)
    && victim->in_room == ch->in_room)
        multi_hit(victim, ch, TYPE_UNDEFINED);
}

DO_FUN(do_universal_cast)
{
    do_cast_org(ch, argument, -1);
}

DO_FUN(do_cast)
{
    do_cast_org(ch, argument, TYPE_SPELL);
}

DO_FUN(do_pray)
{
    char arg[MAX_INPUT_LENGTH];
    one_argument(argument, arg, sizeof(arg));
    if(!str_cmp(arg,"for") || !str_cmp(arg,""))
        argument = one_argument(argument, arg, sizeof(arg));
    do_cast_org(ch, argument, TYPE_MIRACLE);
}

DO_FUN(do_sing)
{
    do_cast_org(ch, argument, TYPE_SONG);
}

DO_FUN(do_execute)
{
    do_cast_org(ch, argument, TYPE_PROGRAM);
}

DO_FUN(do_use)
{
   do_cast_org(ch, argument, TYPE_ABILITY);
}

DO_FUN(do_do)
{
   do_cast_org(ch, argument, TYPE_SKILL);
}

/*
 * Cast spells at targets using a magical object.
 */
void obj_cast_spell(int sn, int level, CHAR_DATA *ch, CHAR_DATA *victim, OBJ_DATA *obj)
{
    void *vo;
    int target = TARGET_NONE;
    skill_t *spell;
    int bane_chance;
    bool offensive = FALSE;

    if (sn <= 0
    || (spell = skill_lookup(sn)) == NULL
    || spell->spell_fun == NULL)
        return;

    bane_chance = 100;
    switch (spell->target)
    {
    default:
        bug("Obj_cast_spell: bad target for sn %d.", sn);
        return;

    case TAR_IGNORE:
        vo = NULL;
        break;

    case TAR_CHAR_OFFENSIVE:
        if (victim == NULL)
            victim = ch->fighting;
        if (victim == NULL)
        {
            char_act("You can't do this.", ch);
            return;
        }
        if (is_safe(ch, victim))
        {
            char_act("Something wrong...", ch);
            return;
        }
        vo = (void *) victim;
        target = TARGET_CHAR;
        bane_chance = get_skill(victim, gsn_spellbane) - 20;
        break;

    case TAR_CHAR_DEFENSIVE:
    case TAR_CHAR_SELF:
        if (victim == NULL)
            victim = ch;
        vo = (void *) victim;
        target = TARGET_CHAR;
        break;

    case TAR_OBJ_INV:
        if (obj == NULL)
        {
            char_act("You can't do this.", ch);
            return;
        }
        vo = (void *) obj;
        target = TARGET_OBJ;
        break;

    case TAR_OBJ_CHAR_OFF:
        if (victim == NULL && obj == NULL)
        {
            if (ch->fighting != NULL)
                victim = ch->fighting;
            else {
                char_act("You can't do this.", ch);
                return;
            }
        }

        if (victim)
        {
            if (is_safe(ch, victim))
            {
                char_act("Something wrong...", ch);
                return;
            }

            vo = (void *) victim;
            target = TARGET_CHAR;
        }
        else {
            vo = (void *) obj;
            target = TARGET_OBJ;
        }
        break;

    case TAR_OBJ_CHAR_DEF:
        if (victim == NULL && obj == NULL)
        {
            vo = (void *) ch;
            target = TARGET_CHAR;
        }
        else if (victim != NULL)
        {
            vo = (void *) victim;
            target = TARGET_CHAR;
        }
        else {
            vo = (void *) obj;
            target = TARGET_OBJ;
        }
        break;
    }

    if (victim == NULL)
        victim = ch;

    switch (target) 
    {
        case TARGET_CHAR:
            vo = (void *) victim;
            switch (spell->target) 
            {   
                case TAR_CHAR_DEFENSIVE:
                case TAR_OBJ_CHAR_DEF:
                    if (IS_SET(spell->flags, SKILL_QUESTIONABLE)
                    && !check_trust(ch, victim))
                    {
                         act("$N do not trust you enough for this $t.", 
                             ch, flag_string(skill_types, spell->type), 
                             victim, TO_CHAR);
                         return;
                    }
                    break;
                                                
                case TAR_CHAR_OFFENSIVE:
                case TAR_OBJ_CHAR_OFF:
                    offensive = TRUE;
                    if (IS_SET(spell->flags, SKILL_QUESTIONABLE))
                        offensive = !check_trust(ch, victim);
                    if (offensive)
                    {
                        if (is_safe(ch, victim))
                            return;
                     
                        if (!IS_NPC(ch)
                        && !IS_NPC(victim)
                        &&  victim != ch
                        &&  ch->fighting != victim
                        &&  victim->fighting != ch
                        &&  !IS_AFFECTED(victim, AFF_CHARM))
                        {
                            act_yell(victim, "Die $i, you nasty dog!", ch, NULL);
                            agent_net_printf(victim, ch, ANET_ATTACK);
                        }
                        break;
                    }
            }
            break;

        case TARGET_OBJ:
            vo = (void*) obj;
            break;
    }

    if (victim == ch)
        bane_chance = 100;

    if (check_spellbane_org(ch, victim, sn, bane_chance, 20))
        return;
    if (check_absorb(ch, victim, sn, TRUE))
        return; 

    if (victim->religion == RELIGION_KEMM
    &&  victim != ch
    &&  number_percent() < 15)
    {
        act_puts("$N's tattoo glows {Ggreen{z and $gN{he} reject your spell!",
            ch, NULL, victim, TO_CHAR, POS_DEAD);
        act("Your tattoo glows {Ggreen{z and your reject $n's spell!",
            ch, NULL, victim, TO_VICT);
        act("$N's tattoo glows {Ggreen{z and $gN{he} reject $n's spell!",
            ch, NULL, victim, TO_NOTVICT);
        return;
    }

    if (target == TARGET_OBJ && ((OBJ_DATA*) vo)->extracted)
        return;

    if (IS_AFFECTED(victim, AFF_SPELLBANE)
    && victim == ch)
        return;

    target_name = str_empty;
    spell->spell_fun(sn, level, ch, vo, target);

    if (target != TARGET_CHAR || JUST_KILLED(victim) || JUST_KILLED(ch))
        return;

    if (offensive && victim != ch && victim->master != ch
    && victim->fighting == NULL && IS_AWAKE(victim)) 
        multi_hit(victim, ch, TYPE_UNDEFINED);     
}

/* --------------- Spell functions --------------- */

SPELL_FUN(spell_deadly_cloud)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    int dam,hp_dam,dice_dam,hpch;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("Imposible, You can poison someone!", ch);
        return;
    }
    act("$n summons Death Cloud from the deep of Hell!", ch, NULL, NULL, TO_ROOM);
    act("You summon Death Cloud!", ch, NULL, NULL, TO_CHAR);

    hpch = UMAX(16, ch->hit);
    hp_dam = number_range(hpch / 15 + 1, 8);
    dice_dam = dice(level, 12);
    dam = UMAX(hp_dam + dice_dam/10, dice_dam + hp_dam/10);
    poison_effect(ch->in_room, level, dam, TARGET_ROOM);
    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe_spell(ch, vch, TRUE)
        || (IS_NPC(ch) && IS_NPC(vch)
        && (ch->fighting == vch || vch->fighting == ch)))
            continue;
        if (saves_spell(level, vch, DAM_POISON))
        {
            poison_effect(vch, level/2, dam/4, TARGET_CHAR);
            damage(ch, vch, dam/2, sn, DAM_POISON, TRUE);
        } else
        {
            poison_effect(vch, level, dam, TARGET_CHAR);
            damage(ch, vch, dam, sn, DAM_POISON, TRUE);
        }
    }
}

SPELL_FUN(spell_acid_blast)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam, chance = 200;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    chance -= (level - LVL(victim));
    chance -= get_skill(ch, gsn_cast_control);
//    chance -= get_skill(ch, gsn_mastering_spell) / 10;

    if (number_range(1, chance) == 1 
        && victim->level < (level + (level / 4))
        && !IS_CLAN_GUARD(victim)
        && !IS_IMMORTAL(victim)
        && IS_NPC(victim)
        && !IS_SET(victim->abilities, EA_IMMUN_INSTANT))
    {
        act("Your acid blast criticaly hits $N in a head!",
            ch, NULL, victim, TO_CHAR);
        act("$n's acid blast criticaly hits $N in a head!",
            ch, NULL, victim, TO_NOTVICT);
        act("$n's acid blast criticaly hits your in a head!",
            ch, NULL, victim, TO_VICT);
//        char_act("You {Rdead{x fall to the ground.", victim); GM : It is NPC...
        victim->position = POS_DEAD;
        handle_death(ch, victim);
        return;
    }

    dam = number_range(level*14, level*18);
//  dam = dice(level, 18);
    if (saves_spell(level, victim, DAM_ACID))
        dam /= 2;
    damage(ch, victim, dam, sn,DAM_ACID,TRUE);
    
    acid_effect(victim, level/2, dam/2, TARGET_CHAR);
    return;
}


SPELL_FUN(spell_armor)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("You already have magical armor.", ch);
        else
            act("$N already has magical armor.", ch, NULL, victim, TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = 7 + level / 6;
    af.modifier  = -1 * UMAX(20, 10 + level / 4); /* af.modifier  = -20;*/
    af.location  = APPLY_AC;
    af.bitvector = 0;
    affect_to_char(victim, &af);
    char_act("You sense how something defence you.", victim);
    if (ch != victim)
        act("$N now under you magical defence.", ch, NULL, victim, TO_CHAR);
    return;
}

SPELL_FUN(spell_bless)
{
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    AFFECT_DATA af;
    int duration;

    /* deal with the object case first */
    if (target == TARGET_OBJ)
    {
        obj = (OBJ_DATA *) vo;
        if (IS_OBJ_STAT(obj,ITEM_BLESS))
        {
            act("$p already has blessing.",ch,obj,NULL,TO_CHAR);
            return;
        }

        if (IS_OBJ_STAT(obj,ITEM_EVIL))
        {
            AFFECT_DATA *paf;

            paf = affect_find(obj->affected,gsn_curse);
            if (!saves_dispel(level,paf != NULL ? paf->level : obj->level,0))
            {
                if (paf != NULL)
                    affect_remove_obj(obj,paf);
                act("$p glows {CLight blue{x.",ch,obj,NULL,TO_ALL);
                REMOVE_BIT(obj->extra_flags,ITEM_EVIL);
                return;
            } else
            {
                act("{rEvil{x in $p is too powerfull to overcome it.",
                    ch,obj,NULL,TO_CHAR);
                return;
            }
        }

        duration = (2 * level) / 3;
        if (IS_NPC(ch))
            duration *= 10;

        af.where        = TO_OBJECT;
        af.type         = sn;
        af.level        = level;
        af.duration     = duration;
        af.location     = APPLY_SAVES;
        af.modifier     = -1;
        af.bitvector    = ITEM_BLESS;
        affect_to_obj(obj,&af);

        act("$p is surrounded by {Wholy aura{x.",ch,obj,NULL,TO_ALL);
        return;
    }

    /* character target */
    victim = (CHAR_DATA *) vo;


    if (victim->position == POS_FIGHTING || is_affected(victim, sn))
    {
        if (victim == ch)
          char_act("You already are blessed.", ch);
        else
          act("$N already has divine blessing.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (IS_CYBORG(victim))
    {
        char_act("You cannot bless a cyborg!", ch);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (6 + level / 2);
    af.location  = APPLY_HITROLL;
    af.modifier  = level / 8;
    af.bitvector = 0;
    affect_to_char(victim, &af);

    af.location  = APPLY_SAVING_SPELL;
    af.modifier  = -10;
    affect_to_char(victim, &af);
    char_act("You feel as you blessing is granted!", victim);
    if (ch != victim)
        act("You grant $N the blessing.", ch, NULL, victim, TO_CHAR);
    return;
}

SPELL_FUN(spell_blindness)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_AFFECTED(victim, AFF_BLIND))
    {
      if (ch == victim)
        char_act("That do you achieve? You in fact are already blind!", ch);
      else
        act("$N it is already blind!", ch, NULL, victim, TO_CHAR);

      return;
    }

    if (saves_spell(level, victim, DAM_MAGIC) || IS_UNDEAD(victim))
    {
        char_act("It is impossible to you.", ch);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.location  = APPLY_HITROLL;
    af.modifier  = 0 - number_fuzzy(level/3);
    af.duration  = UMAX(3, level/18);
    af.bitvector = AFF_BLIND;
    affect_to_char(victim, &af);

    char_act("You have blinded!", victim);
    act("$n has blinded!", victim, NULL, NULL, TO_ROOM);
    return;
}

SPELL_FUN(spell_burning_hands)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = number_range(level, level * 3) + 35;

    if (saves_spell(level, victim,DAM_FIRE))
        dam /= 2;
    else
        fire_effect(victim, level, dam * 3, TARGET_CHAR);

    damage(ch, victim, dam, sn, DAM_FIRE,TRUE);
    return;
}

SPELL_FUN(spell_call_lightning)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (!IS_OUTSIDE(ch)) 
    {
        char_act("You need to leave outside.", ch);
        return;
    }

    if (weather_info.sky < SKY_RAINING) 
    {
        char_act("You will need bad weather.", ch);
        return;
    }

    dam = dice(level, 12);

    char_act("The lightning from the sky hits you!", ch);
    act("$n causes a lightning from the sky which hits $gn{his}!", 
                    ch, NULL, NULL, TO_ROOM);

    for (vch = char_list; vch != NULL; vch = vch_next) 
    {
        vch_next = vch->next;

        if (vch->in_room == NULL)
            continue;

        if (vch->in_room == ch->in_room) 
        {
            if (is_safe_spell(ch, vch, TRUE))
                continue;

            if (check_grounding(vch))
                continue;
        
            damage(ch, vch, saves_spell(level, vch, DAM_LIGHTNING) ? dam / 2 : dam,
                sn, DAM_LIGHTNING, TRUE);
            continue;
        }

        if (vch->in_room->area == ch->in_room->area
        && IS_OUTSIDE(vch)
        && IS_AWAKE(vch))
            char_act("In the sky lightnings sparkle.", vch);
    }
}

/* RT calm spell stops all fighting in the room */
SPELL_FUN(spell_calm)
{
    CHAR_DATA *vch;
    int mlevel = 0;
    int count = 0;
    int high_level = 0;
    int chance;
    AFFECT_DATA af;

    /* get sum of all mobile levels in the room */
    for (vch = ch->in_room->people; vch != NULL; vch = vch->next_in_room)
    {
        if (vch->position == POS_FIGHTING)
        {
            count++;
            if (IS_NPC(vch))
                mlevel += vch->level;
            else
                mlevel += vch->level / 2;
            high_level = UMAX(high_level,vch->level);
        }
    }

    /* compute chance of stopping combat */
    chance = 4 * level - high_level + 2 * count;

    if (IS_IMMORTAL(ch)) /* always works */
        mlevel = 0;

    if (number_range(0, chance) >= mlevel) 
    { /* hard to stop large fights */
        for (vch = ch->in_room->people; vch; vch = vch->next_in_room) 
        {
            if (is_immune(vch, DAM_MAGIC) || IS_UNDEAD(vch))
                continue;

            if (is_safe_spell(ch, vch, TRUE))
                continue;

            if (check_spellbane(ch, vch, sn))
                continue;

            if (IS_AFFECTED(vch, AFF_CALM | AFF_BERSERK)
            || is_affected(vch, gsn_frenzy))
                continue; 

            char_act("The strange calmness covers you.", vch);

            if (vch->fighting || vch->position == POS_FIGHTING)
                stop_fighting(vch, FALSE);

            af.where        = TO_AFFECTS;
            af.type         = sn;
            af.level        = level;
            af.duration     = level/4;
            af.location     = APPLY_HITROLL;
            if (!IS_NPC(vch))
                af.modifier = -1 * vch->level / 2;
            else
                af.modifier = -1 * vch->level / 4;
            af.bitvector    = AFF_CALM;
            affect_to_char(vch, &af);

            af.location     = APPLY_DAMROLL;
            affect_to_char(vch, &af);
        }
    }
}

SPELL_FUN(spell_cause_light)
{
    CHAR_DATA * victim = (CHAR_DATA *) vo;
    AFFECT_DATA *af, paf;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (ch == victim)
    {
        act("You won't do it.", ch, NULL, NULL, TO_CHAR);
        return;         
    }

    dam = level * get_skill(ch, sn) / 100 + dice(2,8);

    for (af = victim->affected; af; af = af->next)
    {
        if (af->type == gsn_cause_critical)
        {
            act("$n is bleeding critically.", victim, NULL, ch, TO_ROOM);
            act("You are bleeding critically.", ch, NULL, victim, TO_VICT); 
            victim->hit = UMAX(-1, victim->hit - dam);
            update_pos(victim);
            return;
        }
        else if (af->type ==  gsn_cause_serious)
        {
            act("$n is bleeding seriously.", victim, NULL, ch, TO_ROOM);
            act("You are bleeding seriously.", ch, NULL, victim, TO_VICT);
            victim->hit = UMAX(-1, victim->hit - dam);
            update_pos(victim);
            return;
        }
        else if (af->type == gsn_cause_light)
            break;
    }

    if (af == NULL)
    {
        act("$n's wounds start to bleed lightly.",
                        victim, NULL, ch, TO_ROOM);
        act("Your wounds start to bleed lightly.",
                        ch, NULL, victim, TO_VICT);
        paf.where        = TO_AFFECTS;
        paf.type         = gsn_cause_light;
        paf.level        = level;
        paf.duration     = -1;
        paf.location     = APPLY_HIT;
        paf.modifier     = - dam;
        paf.bitvector    = 0;
        affect_to_char (victim, &paf);
        update_pos(victim);
        return;
    }

    if ((dam - af->modifier) < victim->max_hit * 3/17)
    {
        act("$n's wounds continue to bleed lightly.",
                        victim, NULL, ch, TO_ROOM);
        act("Your wounds continue to bleed lightly.",
                        ch, NULL, victim, TO_VICT);
        paf.where        = TO_AFFECTS;
        paf.type         = gsn_cause_light;
        paf.level        = level;
        paf.duration     = -1;
        paf.location     = APPLY_HIT;
        paf.modifier     = - dam;
        paf.bitvector    = 0;
        affect_join (victim, &paf);
        update_pos(victim);
        return;
    }

    dam -= af->modifier;
    affect_remove(victim, af);
    act("$n's wounds start to bleed seriously.",
                      victim, NULL, ch, TO_ROOM);
    act("Your wounds start to bleed seriously.",
                      ch, NULL, victim, TO_VICT);

    paf.where       = TO_AFFECTS;
    paf.type         = gsn_cause_serious;
    paf.level        = level;
    paf.duration     = -1;
    paf.location     = APPLY_HIT;
    paf.modifier     = - dam;
    paf.bitvector    = 0;
    affect_to_char (victim, &paf);
    victim->hit = UMAX(victim->hit, -1);
    update_pos(victim);
    return;
}

SPELL_FUN(spell_cause_serious)
{
    CHAR_DATA * victim = (CHAR_DATA *) vo;
    AFFECT_DATA *af, paf;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (ch == victim)
    {
        act("You won't do it.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    dam = level * get_skill(ch, sn) / 67 + dice(3,8);

    for (af = victim->affected; af; af = af->next)
    {
        if (af->type == gsn_cause_critical)
        {
            act("$n is bleeding critically.", victim, NULL, ch, TO_ROOM);
            act("You are bleeding critically.", ch, NULL, victim, TO_VICT);
            victim->hit = UMAX(-1, victim->hit - dam);
            update_pos(victim);
            return;
        }
        else if (af->type ==  gsn_cause_serious)
            break;
        else if (af->type == gsn_cause_light)
        {
            spell_cause_light(gsn_cause_light, level, ch, vo, target);
            return;
        }
    }

    if (af == NULL)
    {
        spell_cause_light(gsn_cause_light, level, ch, vo, target);
        return;
    }

    if ((dam - af->modifier) < victim->max_hit /2)
    {
        act("$n's wounds continue to bleed seriously.",
                        victim, NULL, ch, TO_ROOM);
        act("Your wounds continue to bleed seriously.",
                        ch, NULL, victim, TO_VICT);
        paf.where        = TO_AFFECTS;
        paf.type         = gsn_cause_serious;
        paf.level        = level;
        paf.duration     = -1;
        paf.location     = APPLY_HIT;
        paf.modifier     = - dam;
        paf.bitvector    = 0;
        affect_join (victim, &paf);
        update_pos(victim);
        return;
    }

    dam -= af->modifier;
    affect_remove(victim, af);

    act("$n's wounds start to bleed critically.",
                      victim, NULL, ch, TO_ROOM);
    act("Your wounds start to bleed critically.",
                      ch, NULL, victim, TO_VICT);
    paf.where       = TO_AFFECTS;
    paf.type         = gsn_cause_critical;
    paf.level        = level;
    paf.duration     = -1;
    paf.location     = APPLY_HIT;
    paf.modifier     = - dam;
    paf.bitvector    = 0;
    affect_to_char (victim, &paf);
    victim->hit = UMAX(-1, victim->hit);
    update_pos(victim);
    return;
}

SPELL_FUN(spell_cause_critical)
{
    CHAR_DATA * victim = (CHAR_DATA *) vo;
    AFFECT_DATA *af, paf;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (ch == victim)
    {
        act("You won't do it.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    dam = level * get_skill(ch, sn) / 50 + dice(4,8);

    for (af = victim->affected; af; af = af->next)
    {
        if (af->type == gsn_cause_critical)
            break;
        else if (af->type ==  gsn_cause_serious)
        {
            spell_cause_serious(gsn_cause_serious, level, ch, vo, target);
            return;
        } else if (af->type == gsn_cause_light)
        {
            spell_cause_light(gsn_cause_light, level, ch, vo, target);
            return;
        }
    }

    if (af == NULL)
    {
        spell_cause_light(gsn_cause_light, level, ch, vo, target);
        return;
    }

    if ((dam - af->modifier) < victim->max_hit)
    {
        act("$n's wounds continue to bleed critically.",
                        victim, NULL, ch, TO_ROOM);
        act("Your wounds continue to bleed critically.",
                        ch, NULL, victim, TO_VICT);
        paf.where        = TO_AFFECTS;
        paf.type         = gsn_cause_critical;
        paf.level        = level;
        paf.duration     = -1;
        paf.location     = APPLY_HIT;
        paf.modifier     = - dam;
        paf.bitvector    = 0;
        affect_join (victim, &paf);
        update_pos(victim);
        return;
    }
    act("$n is harmed very bad.",
                      victim, NULL, ch, TO_ROOM);
    act("You are harmed very bad.",
                      ch, NULL, victim, TO_VICT);

    victim->hit = UMAX(-1, victim->hit - dam);
    update_pos(victim);
    return;
}

SPELL_FUN(spell_chain_lightning)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    CHAR_DATA *vch,*last_vict,*next_vict;
    bool found;
    int dam;

    /* first strike */

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    act("The electric spark is broken from fingers $n and gets in $N.",
        ch, NULL, victim, TO_ROOM);
    act("The electric spark is broken from your fingers and gets in $N.",
        ch, NULL, victim, TO_CHAR);
    act("The electric spark is broken from fingers $n and gets in you!",
        ch, NULL, victim, TO_VICT);

    dam = dice(level,6);
    if (!check_grounding(victim))
    {
        if (saves_spell(level, victim, DAM_LIGHTNING))
            dam /= 3;
        damage(ch, victim, dam, sn, DAM_LIGHTNING, TRUE);
        level -= 4;   /* decrement damage */
    }
    
    last_vict = victim; 

    /* new targets */
    while (level > 0)
    {
        found = FALSE;
        for (vch = ch->in_room->people; vch; vch = next_vict)
        {
            next_vict = vch->next_in_room;

            if (vch == last_vict)
                continue;

            if (is_safe_spell(ch, vch, TRUE))
            {
                act("The electric spark passes through a $n's body.",
                    ch, NULL, NULL, TO_ROOM | ACT_VERBOSE);
                act("The electric spark passes through your body.",
                    ch, NULL, NULL, TO_CHAR | ACT_VERBOSE);
                continue;
            } 

            last_vict = vch;
            act("The high electricity shakes $n!",
                vch, NULL, NULL, TO_ROOM | ACT_VERBOSE);
            act("The high electricity shakes you!",
                vch, NULL, NULL, TO_CHAR | ACT_VERBOSE);
            dam = dice(level,6);
            
            if (!check_grounding(vch))
            {
                if (saves_spell(level, vch, DAM_LIGHTNING))
                    dam /= 3;
                damage(ch, vch, dam, sn, DAM_LIGHTNING, TRUE);
                level -= 4;  /* decrement damage */
                found = TRUE;
            }
        }   /* end target searching loop */

        if (found)
            continue;

/* no target found, hit the caster */
        if (ch == NULL)
            return;

        if (last_vict == ch)
        { /* no double hits */
            act("The electric spark leaves in the ground.",
                ch, NULL, NULL, TO_ROOM);
            act("The electric spark leaves through your body in the ground.",
                ch, NULL, NULL, TO_CHAR);
            return;
        }

        last_vict = ch;
        act("The electric spark hits $n... Ops!", ch, NULL, NULL, TO_ROOM);
        char_act("You are struck with own electric spark!", ch);
        dam = dice(level,6);
        if (!check_grounding(ch))
        {
            if (saves_spell(level, ch, DAM_LIGHTNING))
                dam /= 3;
            damage(ch, ch, dam, sn, DAM_LIGHTNING, TRUE);
            level -= 4;  /* decrement damage */
        }
    } /* now go back and find more targets */
}

SPELL_FUN(spell_enlarge)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("You are already enlarged.", ch);
        else
            act("It is impossible to enlarge $N even more strongly.", ch, NULL, victim, TO_CHAR);
        return;
    }
    if (is_affected(victim, gsn_shrink))
    {
        if (!dispel1(level, victim, gsn_shrink))
            act("You failed to enlarge $N.", ch, NULL, victim, TO_CHAR);
        return;
    }
    if (is_affected(victim, gsn_polymorph))
    {
        if (victim == ch)
            char_act("You have already changed yourself.", ch);
        else
            act("$N has already changed $gN{himself}.", ch, NULL, victim, TO_CHAR);
        return ;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 12;
    af.location  = APPLY_SIZE;
    af.modifier  = UMAX(1, level / 30);
    af.bitvector = 0;
    affect_to_char(victim, &af);

    act("$n unexpectedly enlarges in sizes!", victim, NULL, NULL, TO_ROOM);
    act("You unexpectedly enlarge!", victim, NULL, NULL, TO_CHAR);
}

SPELL_FUN(spell_shrink)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("You are already shrinked.", ch);
        else
            act("It is impossible to shrink $N even more strongly.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (is_affected(victim, gsn_enlarge))
    {
        if (!dispel1(level, victim, gsn_enlarge))
            act("You failed to shrink $N.", ch, NULL, victim, TO_CHAR);
        return;
    }
    if (is_affected(victim, gsn_polymorph))
    {
        if (victim == ch)
            char_act("You have already changed yourself.", ch);
        else
            act("$N has already changed $gN{himself}.", ch, NULL, victim, TO_CHAR);
        return ;
    }
    
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 12;
    af.location  = APPLY_SIZE;
    af.modifier  = - UMAX(1, level / 30);
    af.bitvector = 0;
    affect_to_char(victim, &af);

    act("$n unexpectedly shrinkes in sizes!", victim, NULL, NULL, TO_ROOM);
    act("You unexpectedly shrink!", victim, NULL, NULL, TO_CHAR);
}

SPELL_FUN(spell_healing_light)
{
    AFFECT_DATA af,af2;
    
    if (IS_UNDEAD(ch)) 
    {
        act("To you even to think about such it is disgusting.", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    if (is_affected_room(ch->in_room, sn))
    {
        char_act("This room has already been cured by the {WLight{x.", ch);
        return;
    }

    af.where     = TO_ROOM_CONST;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 25;
    af.location  = APPLY_ROOM_HEAL;
    af.modifier  = level;
    af.bitvector = 0;
    affect_to_room(ch->in_room, &af);

    af2.where     = TO_AFFECTS;
    af2.type      = sn;
    af2.level     = level;
    af2.duration  = level / 10;
    af2.modifier  = 0;
    af2.location  = APPLY_NONE;
    af2.bitvector = 0;
    affect_to_char(ch, &af2);
    char_act("The room is filled by the {WLight{x.", ch);
    act("The room is filled by the {WLight{x which radiates by $n.",
        ch, NULL, NULL, TO_ROOM);
}

/* 
 * Types are the following:
 * 
 * -1       manacles
 *  0       charm person
 *  1       attract other
 *  2       control undead
 *  3       control cyborg
 *  4       control animal
 *  5       mind control
 *  6       fascinate // GM : BattleMages' stuff
 *
 */

bool charm_parser(int type, int sn, int level, CHAR_DATA *ch, void *vo, int target)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;
    race_t *r;
    int chance, duration = 0;

    //  Common stupidity checks
    if (is_gquest_mob(victim))
    {
        char_act("On this creation hunting is declared. Just kill it.", ch);
        return FALSE; 
    }

    if (IS_AFFECTED(ch, AFF_CHARM))
    {
        char_act("Your now charmed", ch);
        return FALSE;
    }

    if (count_charmed(ch) && IS_NPC(victim))
        return FALSE;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return FALSE;
    }

    if (victim == ch) 
    {
        char_act("You again become yourself!", ch);
        return FALSE;
    }

    if (!can_see(victim, ch)) 
    {
        act("Your charm has no borders, but $N cannot estimate it.", ch, NULL, victim, TO_CHAR);
        return FALSE;
    }
        
    if (victim->fighting) 
    {
        act("All attention of $N is absorbed by fight.", ch, NULL, victim, TO_CHAR);
        return FALSE;
    }

    if (victim->position == POS_SLEEPING) 
    {
        char_act("How do you want to charm sleeping one?!", ch);
        return FALSE;
    }

    if (!war_can_charm (ch, victim))
        return FALSE;

    if (!IS_IMMORTAL(ch))
    {
        if ((get_eq_char(ch, WEAR_BODY) == NULL
        || get_eq_char(ch, WEAR_HEAD) == NULL
        || get_eq_char(ch, WEAR_LEGS) == NULL
        || get_eq_char(ch, WEAR_FEET) == NULL
        || get_eq_char(ch, WEAR_HANDS) == NULL
        || get_eq_char(ch, WEAR_ARMS) == NULL
        || get_eq_char(ch, WEAR_ABOUT) == NULL
        || get_eq_char(ch, WEAR_WAIST) == NULL)
        && !IS_NPC(victim))
        {
            char_act("{REQ check failed!!!{x", ch);
            WAIT_STATE(ch, 10 * PULSE_VIOLENCE);
            return FALSE;
        }
    }
    if (IS_AFFECTED(victim, AFF_CHARM)
    || is_safe(ch, victim)
    || is_immune(victim, DAM_CHARM)
    || (IS_NPC(victim) && victim->pIndexData->pShop != NULL))
        return FALSE;

    r = race_lookup(ORG_RACE(victim));
    
//  Ok, now personalised by sn's checks.
    if (type >= 0)
    {
        if ((type == 1) && (ch->sex == victim->sex)) 
        {
            act("Try chances with representatives of other sex!", 
                ch, NULL, victim, TO_CHAR);
            return FALSE;
        }
        if ((type == 2) && !IS_UNDEAD(victim)) 
        {
            act("$N it is not similar on an undead.",  ch, NULL, victim, TO_CHAR);
            return FALSE;
        }
        if ((type != 2) && IS_UNDEAD(victim)) 
        {
            act("To undeads your charms are indifferent.", ch, NULL, victim, TO_CHAR);
            return FALSE;
        }
        if ((type == 3) && !IS_CYBORG(victim)) 
        {
            act("$N   .",  ch, NULL, victim, TO_CHAR);
            return FALSE;
        }
    //  "  "  GrayMage   . /sg
    /*
        if ((type != 3) && IS_CYBORG(victim)) {
            act("To cybernetic organisms your charms are indifferent.",
                            ch, NULL, victim, TO_CHAR);
            return FALSE;
        }
    */
        if ((type == 4) && (r && r->pcdata) && !IS_SET(victim->form, FORM_WOLF|FORM_BEAR)) 
        {
            act("Can, you will try it on monsters?",  ch, NULL, victim, TO_CHAR);
            return FALSE;
        }
        if (((type == 0) || (type == 1)) && !(r && r->pcdata)) 
        {
            act("$N is the disgusting monster. You does not contribute to zoophilia.", ch, NULL, victim, TO_CHAR);
            return FALSE;
        } 
    }

    chance = get_skill(ch, sn);
    chance /= 3;
    chance += (level - LVL(victim));
    chance += (get_curr_stat(ch, STAT_LCK) - 
                    get_curr_stat(victim, STAT_LCK)) * 2;

    if ((type == 0) || (type == 1) || (type == 6))
    {
        chance += URANGE(0, (get_curr_stat(ch, STAT_INT)-20)*4, 20);
        chance += (get_curr_stat(ch, STAT_CHA) - 
                        get_curr_stat(victim, STAT_CHA)) * 2;   
    } 
    else if (type == 2)
    {
        chance += URANGE(0, (get_curr_stat(ch, STAT_INT)-20)*4, 20);
        chance += get_skill(ch, gsn_improved_necromancy)/10;
    } 
    else if (type == 3)
    {
        chance += URANGE(0, (get_curr_stat(ch, STAT_INT)-20)*3, 15);    
        chance += URANGE(0, (get_curr_stat(ch, STAT_WIS)-20)*3, 15);
    } 
    else if (type == 4)
    {
        chance += (get_curr_stat(ch, STAT_CHA) - 20) * 5;
        chance += (level - LVL(victim)) * 2;
        chance += (get_curr_stat(ch,STAT_INT) - 
                        get_curr_stat(victim,STAT_INT)) * 5;
    } 
    else if (type == 5)
    {
        chance += URANGE(0, (get_curr_stat(ch, STAT_WIS)-20)*4, 20);
        chance += UMAX(0,(get_curr_stat(ch, STAT_INT) -
                                    get_curr_stat(victim, STAT_WIS)) * 2);
    }

/*
    if (type == 5 ? !psychic_contest(ch, victim, sn) : 
            saves_spell(level, victim, DAM_CHARM))
        chance /= 10;
*/
    if (saves_spell(level, victim, DAM_CHARM))
        chance /= 15;

    if (IS_NPC(victim)) 
    {
        if (level > LVL(victim))
            chance = 85;
        else if ((level + level / 20) < LVL(victim))
            chance = 0;
    }
    else 
        chance = URANGE(2, chance, 40);

    resists_modify(&chance, check_immune(victim, DAM_CHARM), TRUE);

    if (type == 6 && IS_NPC(victim))
        chance = 0;

    if (chance == 0)
    {
        act("     $N.", ch, NULL, victim, TO_CHAR);
        return FALSE;
    }

    if (number_percent() < get_skill(ch, gsn_mastering_charm)  && !IS_NPC (victim))
        duration = -2;
    else if (!IS_NPC(victim))
        duration = level / 15 + 1;
    else
        duration = level * 2;
    
    if (number_percent() < chance)
    {
        if (victim->master)
            stop_follower(victim);
        add_follower(victim, ch);
        victim->leader = ch;

        af.where    = TO_AFFECTS;
        af.type     = sn;
        af.level    = level;
        af.duration = duration;
        af.location = 0;
        af.modifier = 0;
        af.bitvector    = AFF_CHARM;
        affect_to_char(victim, &af);

        act("Is $n soo beutifull?", ch, NULL, victim, TO_VICT);
        
        if (IS_NPC(victim))
            victim->long_descr = mlstr_addstr(victim->short_descr,"\n");

/* 
 * Types are the following:
 * 
 * -1       manacles
 *  0       charm person
 *  1       attract other
 *  2       control undead
 *  3       control cyborg
 *  4       control animal
 *  5       mind control
 *  6       fascinate // GM : BattleMage's staff...
 *
 */

        if (ch != victim)
        {
//            if (type == 0)
// GM : TODO Add more msg for each type!

                act("$N looks at you with love in eyes.", 
                    ch, NULL, victim, TO_CHAR);
        }
                
        return TRUE;
    } else 
    {
        act("You failed to charm $N.", ch, NULL, victim, TO_CHAR);
        return FALSE;
    }
}

SPELL_FUN(spell_charm_person)
{
    charm_parser(0, sn, level, ch, vo, target);
}

SPELL_FUN(spell_attract_other)
{
    charm_parser(1, sn, level, ch, vo, target);
}

SPELL_FUN(spell_control_undead)
{
    charm_parser(2, sn, level, ch, vo, target);
}

SPELL_FUN(spell_control_cyborg)
{
    charm_parser(3, sn, level, ch, vo, target);
}

SPELL_FUN(spell_control_animal)
{
    charm_parser(4, sn, level, ch, vo, target);
}

// By GrayMage
SPELL_FUN(spell_mind_control)
{
/*
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int psp;
    psp = 2 * psionic_level(victim);
    if (ch->psp < psp)
    {
        act("You need $j psi power $qj{points} to dominate $gN{him}.", 
    ch, (const void *) psp, victim, TO_CHAR);
     return;
    }
    ch->psp -= psp;
*/
    charm_parser(5, sn, level, ch, vo, target);
}

SPELL_FUN(spell_fascinate)
{
    charm_parser(6, sn, level, ch, vo, target);
}

SPELL_FUN(spell_manacles)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (!IS_SET(victim->plr_flags, PLR_WANTED))
    {
        act("But $N now not wanted.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (!is_affected(victim, sn))
    {
        AFFECT_DATA af;

        af.where          = TO_AFFECTS;
        af.type               = sn;
        af.level              = level;
        af.duration           = 5 + level/5;
        af.bitvector          = 0;

        af.modifier           = 0 - (get_curr_stat(victim, STAT_DEX)-4);
        af.location           = APPLY_DEX;
        affect_to_char(victim, &af);

        af.modifier           = -level/4;
        af.location           = APPLY_HITROLL;
        affect_to_char(victim, &af);


        af.modifier           = -level/2;
        af.location           = APPLY_DAMROLL;
        affect_to_char(victim, &af);
    }

    charm_parser(-1, sn, level+20, ch, vo, TARGET_CHAR);
}

SPELL_FUN(spell_chill_touch)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = number_range(level, level*7) + 10;

    if (check_dodge(ch, victim))
    {
        level = level - level /10;
        dam = dam - dam / 3;
    }

    if (!saves_spell(level, victim, DAM_COLD)) 
    {
        if (!is_affected(victim, sn)) 
        {
            act("$n turns blue and shivers.", victim, NULL, NULL, TO_ROOM);
            af.where     = TO_AFFECTS;
            af.type      = sn;
            af.level     = number_range(level/2, 3*level/4);
            af.duration  = level/15;
            af.location  = APPLY_STR;
            af.modifier  = - number_range(10,20);
            af.bitvector = 0;
            affect_join(victim, &af);
        }
    } else
        dam = dam - dam / 3;

    damage(ch, victim, dam, sn, DAM_COLD, TRUE);
}

SPELL_FUN(spell_colour_spray)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = number_range(level*2, level*5) + 40;

    if (saves_spell(level, victim, DAM_LIGHT))
        dam /= 2;
    else
        spell_blindness(sn, 2*level/3, ch, (void *) victim, TARGET_CHAR);

    damage(ch, victim, dam, sn, DAM_LIGHT, TRUE);
}

SPELL_FUN(spell_continual_light)
{
    OBJ_DATA *light;

    if (target_name[0] != '\0')  /* do a glow on some object */
    {
        light = get_obj_carry(ch, target_name);

        if (light == NULL)
        {
            char_act("You do not see it here.", ch);
            return;
        }

        if (IS_OBJ_STAT(light, ITEM_GLOW))
        {
            act("$p already shines.", ch, light, NULL, TO_CHAR);
            return;
        }

        SET_BIT(light->extra_flags, ITEM_GLOW);
        act("$p begins shines.", ch, light, NULL, TO_ALL);
        return;
    }

    light = create_obj(get_obj_index(OBJ_VNUM_LIGHT_BALL), 0);
    obj_to_room(light, ch->in_room);
    act("$n creates shining $p.", ch, light, NULL, TO_ROOM);
    act("You create shining $p.", ch, light, NULL, TO_CHAR);
    return;
}

SPELL_FUN(spell_create_food)
{
    OBJ_DATA *mushroom;

    mushroom = create_obj(get_obj_index(OBJ_VNUM_MUSHROOM), 0);
    mushroom->value[0] = (ch->level < 50) ? (level / 2) : (level / 3);
    mushroom->value[1] = (ch->level < 50) ? level : level * 2 / 3;
    if (number_percent() < 5)
        mushroom->value[3] = 1;
    obj_to_room(mushroom, ch->in_room);
    act("Suddenly before you grows $p.", ch, mushroom, NULL, TO_ROOM);
    act("Suddenly before you grows $p.", ch, mushroom, NULL, TO_CHAR);
    return;
}

SPELL_FUN(spell_create_rose)
{
    OBJ_DATA *rose;

    if (strlen(target_name) > 200)
    {
       char_act("You can read through all this?", ch);
       return;
    }

    if (target_name[0] == '\0') 
    {
        char_act("Do you want to create what rose?", ch);
        return;
    }

    rose = create_named_obj(get_obj_index(OBJ_VNUM_ROSE), 0,
                   target_name);
    rose->ed = ed_new2(rose->pIndexData->ed, target_name);

    act("$n creates $p.", ch, rose, NULL, TO_ROOM);
    act("You create $p.", ch, rose, NULL, TO_CHAR);
    obj_to_char(rose, ch);
}

SPELL_FUN(spell_create_spring)
{
    OBJ_DATA *spring;

    spring = create_obj(get_obj_index(OBJ_VNUM_SPRING), 0);
    spring->timer = level;
    obj_to_room(spring, ch->in_room);
    act("Suddenly from the ground begins spring $p.", ch, spring, NULL, TO_ROOM);
    act("Suddenly from the ground begins spring $p.", ch, spring, NULL, TO_CHAR);
    return;
}

SPELL_FUN(spell_create_water)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    int water;

    if (obj->pIndexData->item_type != ITEM_DRINK_CON) 
    {
        char_act("This container cannot comprise water.", ch);
        return;
    }

    if (obj->value[2] != LIQ_WATER && obj->value[1] != 0) 
    {
        char_act("This filled with other liquid.", ch);
        return;
    }

    water = UMIN(level * (weather_info.sky >= SKY_RAINING ? 4 : 2),
             obj->value[0] - obj->value[1]);

    if (water > 0) 
    {
        obj->value[2] = LIQ_WATER;
        obj->value[1] += water;

        if (!is_name("water", obj->name)) 
        {
            const char *p = obj->name;
            obj->name = str_printf("%s %s", obj->name, "water");
            free_string(p);
        }

        act("$p it is filled.", ch, obj, NULL, TO_CHAR);
    }
}

SPELL_FUN(spell_cure_light)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA *af, paf;
    int heal;

    heal = dice(1, 8) + level / 4 + 5;
    
    if(CAN_HEAL(ch, victim)) 
    {
        if (IS_CYBORG(victim) && ch != victim) 
        {
            char_act("It it is difficult to cure.", ch);
            heal /= 2;
        }
        victim->hit = UMIN(victim->hit + heal, victim->max_hit);
        update_pos(victim);
        char_act("You feel better!", victim);
        if (ch != victim)
            char_act("Ok.", ch);
    }
    else if(!is_safe(ch,victim))
    {
        damage(ch, victim, heal, sn, DAM_LIGHT, TRUE);
        return;
    }
    
    for (af = victim->affected; af; af = af->next)
    {
        if (af->type == gsn_cause_critical)
        {
            act("Alas this miracle can't cure critical wounds of $N.",
                            ch, NULL, victim, TO_CHAR);
            return;
        }
        if (af->type == gsn_cause_serious)
        {
            act("Alas this miracle can't cure serious wounds of $N.",
                            ch, NULL, victim, TO_CHAR);
            return;
        }
        if (af->type == gsn_cause_light)
            break;
    }
    
    if (af == NULL) 
        return;

    heal = level * get_skill(ch, sn) / 100 + dice(2,8);

    if (heal + af->modifier >= 0)
    {
        act("Your wounds stopped bleeding.",
                        ch, NULL, victim, TO_VICT);
        act("$n's wounds stopped bleeding.",
                        victim, NULL, ch, TO_ROOM);
        affect_remove(victim, af);
        return;
    }
    else
    {
        act("$n's wounds continue to bleed lightly.", 
                        victim, NULL, ch, TO_ROOM);
        act("Your wounds continue to bleed lightly.",
                        ch, NULL, victim, TO_VICT);
        paf.where        = TO_AFFECTS;
        paf.type         = gsn_cause_light;
        paf.level        = level;
        paf.duration     = -1;
        paf.location     = APPLY_HIT;
        paf.modifier     = heal;
        paf.bitvector    = 0;
        affect_join (victim, &paf);
        update_pos(victim);
        return;
    }
    return;
}

SPELL_FUN(spell_cure_serious)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA *af, paf;   
    int heal;

    heal = dice(2, 8) + level / 3 + 10 ;
    if(CAN_HEAL(ch, victim)) {
        if (IS_CYBORG(victim) && ch != victim) {
            char_act("It it is difficult to cure.", ch);
            heal /= 2;
        }
        victim->hit = UMIN(victim->hit + heal, victim->max_hit);
        update_pos(victim);
        char_act("You feel better!", victim);
        if (ch != victim)
            char_act("Ok.", ch);
    }
    else if(!is_safe(ch,victim))
    {
        damage(ch, victim, heal, sn, DAM_LIGHT, TRUE);
        return;
    }

    for (af = victim->affected; af; af = af->next)
    {
        if (af->type == gsn_cause_critical)
        {
            act("Alas this miracle can't cure critical wounds of $N.",
                            ch, NULL, victim, TO_CHAR);
            return;
        }
        if (af->type == gsn_cause_serious)
        {
            heal = level * get_skill(ch, sn) / 67 + dice(3,8);
            break;
        }
        if (af->type == gsn_cause_light)
        {
            spell_cure_light(sn, level, ch, vo, target);
            return;
        }
    }
    
    if (af == NULL) 
        return;
    
    if ( (-heal - af->modifier) < victim->max_hit * 3/17)
    {
        heal += af->modifier;
        affect_remove(victim, af);
        if (heal >= 0)
        {
            act("Your wounds stopped bleeding.",
                            ch, NULL, victim, TO_VICT);
            act("$n's wounds stopped bleeding.",
                            victim, NULL, ch, TO_ROOM);
            return;
        }
        act("Your wounds stopped bleeding so seriously.",
                        ch, NULL, victim, TO_VICT);
        act("$n's wounds stopped bleeding so seriously.",
                        victim, NULL, ch, TO_ROOM);
        paf.where        = TO_AFFECTS;
        paf.type         = gsn_cause_light;
        paf.level        = level;
        paf.duration     = -1;
        paf.location     = APPLY_HIT;
        paf.modifier     = heal;
        paf.bitvector    = 0;
        affect_join (victim, &paf);
        update_pos(victim); 
        return;
    }
    else
    {
        act("$n's wounds continue to bleed seriously.", 
                        victim, NULL, ch, TO_ROOM);
        act("Your wounds continue to bleed seriously.",
                        ch, NULL, victim, TO_VICT);
        paf.where        = TO_AFFECTS;
        paf.type         = gsn_cause_serious;
        paf.level        = level;
        paf.duration     = -1;
        paf.location     = APPLY_HIT;
        paf.modifier     = heal;
        paf.bitvector    = 0;
        affect_join (victim, &paf);
        update_pos(victim);
        return;
    }
    return;
}

SPELL_FUN(spell_cure_critical)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA *af, paf;       
    int heal;
    
    heal = dice(3, 8) + level / 2 ;

    if(CAN_HEAL(ch,victim)) {
        if (IS_CYBORG(victim) && ch != victim) {
            char_act("It it is difficult to cure.", ch);
            heal /= 2;
        }
        victim->hit = UMIN(victim->hit + heal, victim->max_hit);
        update_pos(victim);
        char_act("You feel better!", victim);
        if (ch != victim)
            char_act("Ok.", ch);
    }
    else if(!is_safe(ch, victim))
    {
        damage(ch, victim, heal, sn, DAM_LIGHT, TRUE); 
        return;
    }
    
    for (af = victim->affected; af; af = af->next)
    {
        if (af->type == gsn_cause_critical)
        {
            heal = level * get_skill(ch, sn) / 50 + dice(4,8);
            break;
        }
        if (af->type == gsn_cause_serious)
        {
            spell_cure_serious(sn, level, ch, vo, target);
            return;
        }
        if (af->type == gsn_cause_light)
        {
            spell_cure_light(sn, level, ch, vo, target);
            return;
        }
    }
    
    if (af == NULL) 
        return;
    
    if ( (-heal - af->modifier) < victim->max_hit / 2)
    {
        heal += af->modifier;
        affect_remove(victim, af);
        if (heal >= 0)
        {
            act("Your wounds stopped bleeding.",
                            ch, NULL, victim, TO_VICT);
            act("$n's wounds stopped bleeding.",
                            victim, NULL, ch, TO_ROOM);
            return;
        }
        act("Your wounds stopped bleeding so critically.",
                        ch, NULL, victim, TO_VICT);
        act("$n's wounds stopped bleeding so critically.",
                        victim, NULL, ch, TO_ROOM);
        paf.where        = TO_AFFECTS;
        paf.type         = gsn_cause_serious;
        paf.level        = level;
        paf.duration     = -1;
        paf.location     = APPLY_HIT;
        paf.modifier     = heal;
        paf.bitvector    = 0;
        affect_join (victim, &paf);
        update_pos(victim); 
        return;
    }
    else
    {
        act("$n's wounds continue to bleed critically.", 
                        victim, NULL, ch, TO_ROOM);
        act("Your wounds continue to bleed critically.",
                        ch, NULL, victim, TO_VICT);
        paf.where        = TO_AFFECTS;
        paf.type         = gsn_cause_critical;
        paf.level        = level;
        paf.duration     = -1;
        paf.location     = APPLY_HIT;
        paf.modifier     = heal;
        paf.bitvector    = 0;
        affect_join (victim, &paf);
        update_pos(victim);
        return;
    }
    return;
}

SPELL_FUN(spell_curse)
{
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    AFFECT_DATA af;

    /* deal with the object case first */

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (target == TARGET_OBJ)
    {
        obj = (OBJ_DATA *) vo;
        if (IS_OBJ_STAT(obj, ITEM_EVIL))
        {
            act("$p it is already filled with {DEvil{x.", ch, obj, NULL, TO_CHAR);
            return;
        }

        if (IS_OBJ_STAT(obj, ITEM_BLESS))
        {
            AFFECT_DATA *paf;

            paf = affect_find(obj->affected,sn_lookup("bless"));
            if (!saves_dispel(level,paf != NULL ? paf->level : obj->level,0))
            {
                if (paf != NULL)
                    affect_remove_obj(obj,paf);
                act("$p shrouds with the {Rred aura{x.", ch, obj, NULL, TO_ALL);
                REMOVE_BIT(obj->extra_flags,ITEM_BLESS);
                return;
            } else
            {
                act("{WHoly aura{x around $p is too powerful to clean her.",
                    ch, obj, NULL, TO_CHAR);
                return;
            }
        }

        af.where        = TO_OBJECT;
        af.type         = sn;
        af.level        = level;
        af.duration     = (8 + level / 5);
        af.location     = APPLY_SAVES;
        af.modifier     = +1;
        af.bitvector    = ITEM_EVIL;
        affect_to_obj(obj,&af);

        act("$p flashes with {Rred{x aura.",ch,obj,NULL,TO_ALL);
        return;
    }

    /* character curses */
    victim = (CHAR_DATA *) vo;

    if (IS_AFFECTED(victim, AFF_CURSE))
    {
        if (ch == victim)
            char_act("Sadomazo? You already feel uncomfortably!", ch);
        else
            act("$N already looks uncomfortably!", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (saves_spell(level, victim, DAM_NEGATIVE))
    {
        char_act("Your spell has not passed!", ch);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (8 + level / 10);
    af.location  = APPLY_HITROLL;
    af.modifier  = -1 * (level / 8);
    af.bitvector = AFF_CURSE;
    affect_to_char(victim, &af);

    af.location  = APPLY_SAVING_SPELL;
    af.modifier  = 10;
    affect_to_char(victim, &af);

    char_act("You feel uncomfortably.", victim);
    if (ch != victim)
        act("$N looks uncomfortably.",ch,NULL,victim,TO_CHAR);
    return;
}


/* RT replacement demonfire spell */

SPELL_FUN(spell_demonfire)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (!IS_NPC(ch) && !IS_EVIL(ch))
    {
        victim = ch;
        char_act("{rDemons of the Hell{x have turned back against you!", ch);
    }

    if (victim != ch)
    {
        act("$n sends {rDemons of the Hell{x on $N!",
            ch,NULL,victim,TO_ROOM);
        act("$n sends to you {rDemons of the Hell{x!",
            ch,NULL,victim,TO_VICT);
        char_act("You cause {rDemons of the Hell{x!", ch);
    }
    dam = dice(level, 12);
    if (saves_spell(level, victim,DAM_NEGATIVE))
        dam /= 2;
    spell_curse(gsn_curse, 3 * level / 4, ch, (void *) victim, TARGET_CHAR);
    damage(ch, victim, dam, sn, DAM_NEGATIVE ,TRUE);
}

/* added by chronos */
SPELL_FUN(spell_bluefire)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (!IS_NPC(ch) && !IS_NEUTRAL(ch))
    {
        victim = ch;
        char_act("Yours {BBlue Fire{x of {gEarth{x burns you!", ch);
    }

    if (victim != ch)
    {
        act("$n causes {BBlue Fire{x of {gEarth{x to bring down it on $N!",
            ch,NULL,victim,TO_ROOM);
        act("$n burns you by {BBlue Fire{x of {gEarth{x!",
            ch,NULL,victim,TO_VICT);
        char_act("You cause spirits {BBlue Fire{x!", ch);
    }

    dam = dice(level, 12);
    if (saves_spell(level, victim,DAM_FIRE))
        dam /= 2;
    damage(ch, victim, dam, sn, DAM_FIRE ,TRUE);
}

SPELL_FUN(spell_detect_evil)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_DETECT_EVIL))
    {
        if (victim == ch)
          char_act("You already feel {rEvil{x.", ch);
        else
          act("$N already feels {rEvil{x.",ch,NULL,victim,TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (5 + level / 3);
    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = AFF_DETECT_EVIL;
    affect_to_char(victim, &af);
    char_act("In your eyes flash {Rred{x sparkles.", victim);
    if (ch != victim)
        char_act("Ok.", ch);
    return;
}


SPELL_FUN(spell_detect_good)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_DETECT_GOOD))
    {
        if (victim == ch)
          char_act("You already feel {WGoodness{x.", ch);
        else
          act("$N already feels {WGoodness{x.",ch,NULL,victim,TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (5 + level / 3);
    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = AFF_DETECT_GOOD;
    affect_to_char(victim, &af);
    char_act("In your eyes flash {Wwhite{x sparkles.", victim);
    if (ch != victim)
        char_act("Ok.", ch);
    return;
}

SPELL_FUN(spell_detect_hidden)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_DETECT_HIDDEN)) {
        if (victim == ch)
            char_act("     .", ch);
        else
            act("$N     .",
                ch, NULL, victim, TO_CHAR);
        return;
    }

    af.where    = TO_AFFECTS;
    af.type     = sn;
    af.level    = level;
    af.duration = (5 + level / 3);
    af.location = APPLY_NONE;
    af.modifier = 0;
    af.bitvector    = AFF_DETECT_HIDDEN;
    affect_to_char(victim, &af);
    char_act("  .", victim);
    if (ch != victim)
        char_act("Ok.", ch);
}

SPELL_FUN(spell_detect_fade)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_DETECT_FADE)) {
        if (victim == ch)
            char_act("     .", ch);
        else
            act("$N     .",
                ch, NULL, victim, TO_CHAR);
        return;
    }

    af.where    = TO_AFFECTS;
    af.type     = sn;
    af.level    = level;
    af.duration = 5;
    af.location = APPLY_NONE;
    af.modifier = 0;
    af.bitvector    = AFF_DETECT_FADE;
    affect_to_char(victim, &af);
    char_act("  .", victim);
    if (ch != victim)
        char_act("Ok.", ch);
}

SPELL_FUN(spell_detect_invis)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_DETECT_INVIS))
    {
        if (victim == ch)
          char_act("   .", ch);
        else
          act("$N   .",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (5 + level / 2);
    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = AFF_DETECT_INVIS;
    affect_to_char(victim, &af);
    char_act("    .", victim);
    if (ch != victim)
        char_act("Ok.", ch);
    return;
}



SPELL_FUN(spell_detect_magic)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_DETECT_MAGIC))
    {
        if (victim == ch)
          char_act("    .", ch);
        else
          act("$N    .",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (5 + level / 3);
    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = AFF_DETECT_MAGIC;
    affect_to_char(victim, &af);
    char_act("You vision of magic is becoming better.", victim);
    if (ch != victim)
        char_act("Ok.", ch);
    return;
}



SPELL_FUN(spell_detect_poison)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;

    if (obj->pIndexData->item_type == ITEM_DRINK_CON || obj->pIndexData->item_type == ITEM_FOOD)
    {
        if (obj->value[3] != 0)
            char_act("You feel the smell of poison!", ch);
        else
            char_act("You don't feel the smell of poison.", ch);
    }
    else
    {
        char_act("It's not poisoned.", ch);
    }

    return;
}

/* Various dispels */
/* modified for enhanced use */

bool dispel_parser(CHAR_DATA *victim, AFFECT_DATA *paf)
{
    AFFECT_DATA *af, *af_next;  
    bool found = FALSE;
    skill_t *sk;
     
    for (af = victim->affected; af != NULL; af = af_next) {
        af_next = af->next;
        if ((paf->type != -1) && (paf->type != af->type))
            continue;
        if ((paf->where != -1) && 
            (!IS_SET(af->bitvector, paf->bitvector) || 
             (af->where != paf->where)))
            continue;
        if ((sk = skill_lookup(af->type)) == NULL)
            continue;
        if (sk->type != TYPE_SPELL 
            && sk->type != TYPE_MIRACLE 
            && sk->type != TYPE_PROGRAM)
        {
            if (paf->type == -1 && paf->where == -1)
                continue;
        }
        if (IS_SET(sk->flags, SKILL_NODISPEL))
        {   
            if (paf->where == -1 && paf->type == -1)
                continue;
        }

        if (!saves_dispel(paf->level, af->level, af->duration)) {
            dispel_message(victim, af->type, TRUE);
            if (paf->type != -1 || paf->where != -1)
                affect_strip(victim, af->type);
            else
                affect_remove(victim, af);
            found = TRUE;
        } 
        else
            af->level--;
    }
    return found;
}

bool dispel(int level, CHAR_DATA *ch)
{
    AFFECT_DATA af;
    af.level = level;
    af.type = -1;
    af.where = -1;
    af.bitvector = 0;
    return dispel_parser(ch, &af);
}

bool dispel1(int level, CHAR_DATA *ch, int sn)
{
    AFFECT_DATA af;
    af.level = level;
    af.type = sn;
    af.where = -1;
    af.bitvector = 0;
    return dispel_parser(ch, &af);
}

bool dispel2(int level, CHAR_DATA *ch, flag64_t aff)
{
    AFFECT_DATA af;
    af.level = level;
    af.type = -1;
    af.where = TO_AFFECTS;
    af.bitvector = aff;
    return dispel_parser(ch, &af);
}

SPELL_FUN(spell_abort)
{
    char arg[MAX_STRING_LENGTH];
    int spell_sn, bonus = 0;
    one_argument(target_name, arg, sizeof(arg));
    if (!str_cmp(target_name, "telepathic attack"))
    {
        ch->psi_att = -1;
        return;
    }
    if (!str_cmp(target_name, "telepathic defense"))
    {
        ch->psi_def = -1;
        return;
    }
    if (!str_cmp(target_name, "contacts"))
    {
        free_contacts(ch);
        return;
    }
    if (!str_cmp(arg, "contact"))
    {
        int i;
        target_name = one_argument(target_name, arg, sizeof(arg));
        for (i = 0; i < MAX_CONTACTS; i++)
        {
            if (ch->contact[i] == NULL)
                continue;
            if (is_name(ch->contact[i]->name, target_name))
                ch->contact[i] = NULL;
        }
    }
    if ((spell_sn = sn_lookup(target_name)) < 0)
    {
        act("But what is '$t'?", ch, target_name, NULL, TO_CHAR);
        return;
    }
    if (IS_POWER(spell_sn))
        bonus = 5;
    else if (IS_SONG(spell_sn) || IS_SKILL(spell_sn))
        bonus = 3;
    else if (IS_SPELL(spell_sn) || IS_PROGRAM(spell_sn))
        bonus = 2;
    else if (IS_MIRACLE(spell_sn))
        bonus = 1;
    dispel1(level + bonus, ch, spell_sn);
}

// By GrayMage
SPELL_FUN(spell_purify)
{
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    OBJ_DATA *obj_lose, *obj_next;
    AFFECT_DATA af;
    int mana = 0;
    bool nopurify = FALSE;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        act("You too scare to do this!", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (target == TARGET_OBJ)
    {
        obj = (OBJ_DATA *) vo;

        if (!IS_OBJ_STAT(obj, ITEM_MAGIC))
            nopurify = TRUE;

        if (IS_OBJ_STAT(obj, ITEM_NOPURGE)
        || IS_OBJ_STAT(obj, ITEM_BURN_PROOF)
        || IS_OBJ_STAT(obj, ITEM_QUEST)
        || IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE)
        || obj->level > level * 3 / 2
        || obj->pIndexData->limit != -1
        || check_material(obj, "unique"))
            nopurify = TRUE;

        if (nopurify)
        {
            act("You cant't purify $p.", ch, obj, NULL, TO_CHAR);
            return;
        }

        if (IS_AFFECTED(ch, AFF_SLOW))
        {
            if (IS_AFFECTED(ch, AFF_HASTE))
                level *= 2;
            dispel1(level, ch, gsn_slow);
        }
        if (!is_affected(ch, sn))
        {
            af.where     = TO_AFFECTS;
            af.type      = sn;
            af.level     = level;
            af.duration  = level / 3;
            af.location  = APPLY_DEX;
            af.modifier  = UMAX(2, level / 12);
            af.bitvector = AFF_HASTE;
            affect_to_char(ch, &af);
        } else
        {
            if (obj->level > ch->level)
                mana = obj->level + ((obj->level-ch->level)*10);
            else
                mana = obj->level;
            mana += LVL(ch) / 2;
            ch->mana = UMIN(ch->mana + mana, ch->max_mana);
        }
        act("$p disappears in purify.", ch, obj, NULL, TO_CHAR);
        obj_from_char(obj);
        extract_obj (obj);
        return;
    }

    victim = (CHAR_DATA *) vo;

    if (!IS_NPC(victim))
        level += LVL(ch) - LVL(victim);
    else
    {
        if (IS_AFFECTED(victim, AFF_CHARM))
            level += 2;
        else
            level += 4;
    }

    if (is_class_mage(victim))
        level += 4;

    // GM: change for ninja and thief in clan Inquisistors
    damage(ch, victim, 0, sn, DAM_NONE, FALSE);

    if (saves_spell(level, victim, DAM_MAGIC))
    {
        char_act("      .", victim);
        char_act("You failed.", ch);
        return;
    }
            
    if (dispel(level, victim))
        char_act("Ok.", ch);
    else
        char_act("You failed.", ch);

    for (obj_lose = victim->carrying; obj_lose != NULL; obj_lose = obj_next)
    {
        obj_next = obj_lose->next_content;

        if (!IS_OBJ_STAT(obj_lose, ITEM_MAGIC)
        || IS_OBJ_STAT(obj_lose, ITEM_NOPURGE)
        || IS_OBJ_STAT(obj_lose, ITEM_BURN_PROOF)
        || IS_OBJ_STAT(obj_lose, ITEM_QUEST)
        || IS_OBJ_STAT(obj_lose, ITEM_INDESTRUCTABLE)
        || obj_lose->level > level * 3 / 2
        || obj_lose->pIndexData->limit != -1
        || check_material(obj_lose, "unique")
        || saves_spell(level, victim, DAM_MAGIC)
        || number_percent () < 20)
            continue;

        act("$p disappears in purify.", ch, obj_lose, NULL, TO_ALL);
        extract_obj(obj_lose);
        break;
    }

    return;
}

SPELL_FUN(spell_dispel_magic)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (IS_AFFECTED(ch, AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (saves_spell(level, victim, DAM_MAGIC))
    {
        char_act("You feel strong influence of foreign magic.", victim);
        char_act("You failed.", ch);
        return;
    }

    if (dispel(level, victim))
        char_act("Ok.", ch);
    else
        char_act("Spell is failed.", ch);
        return;
}

SPELL_FUN(spell_cancellation)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    level += 2;

    if (dispel(level, victim))
        char_act("Ok.", ch);
    else
        char_act("Spell is failed.", ch);
}

SPELL_FUN(spell_dispel_evil)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;
    bool found = FALSE, align = TRUE;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (!IS_NPC(ch) && IS_EVIL(ch))
        victim = ch;
    else
        align = !IS_NEUTRAL(ch) ||
                    (number_percent() < get_skill(ch, gsn_faith));

    if (victim->hit > 4 * level)
      dam = dice(level, 6);
    else
      dam = UMAX(victim->hit, dice(level,6));

    if (!align)
        dam = dice(level, 4);

    if (IS_AFFECTED(victim, AFF_BLACK_SHROUD))
    {
        found = TRUE;
        if (align)
            dam *= 2;
        else
            dam = dam * 3/2;
    }
    if (IS_AFFECTED(victim, AFF_PROTECT_GOOD))
    {
        found = TRUE;
        if (align)
            dam = dam * 3/2;
        else
            dam = dam * 5/4;
    }
    if (IS_AFFECTED(victim, AFF_SANCTUARY))
    {
        if (align)
            dam *= 2;
        else
            dam = dam * 3/2;
    }

    if (saves_spell(level, victim, DAM_HOLY))
        dam /= 2;
    else if (found || IS_EVIL(victim))
    {
        dispel2(level, victim, AFF_BLACK_SHROUD |
                               AFF_PROTECT_GOOD |
                               AFF_SANCTUARY);
    }

    if (IS_GOOD(victim) && !found)
    {
        act("The gods protect $N.",
                        ch, NULL, victim, TO_ROOM);
        return;
    }

    if (IS_NEUTRAL(victim) && !found)
    {
        act("$N looks not sensitive to this.",
                        ch, NULL, victim, TO_CHAR);
        return;
    }

    damage(ch, victim, dam, sn, DAM_HOLY ,TRUE);
}

SPELL_FUN(spell_dispel_good)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;
    bool found = FALSE, align = TRUE;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (!IS_NPC(ch) && IS_GOOD(ch))
        victim = ch;
    else
        align = !IS_NEUTRAL(ch) ||
                    (number_percent() < get_skill(ch, gsn_faith));

    if (victim->hit > 4 * level)
      dam = dice(level, 6);
    else
      dam = UMAX(victim->hit, dice(level,6));

    if (!align)
        dam = dice(level, 4);

    if (IS_AFFECTED(victim, AFF_PROTECT_EVIL))
    {
        found = TRUE;
        if (align)
            dam = dam * 3/2;
        else
            dam = dam * 5/4;
    }
    if (IS_AFFECTED(victim, AFF_SANCTUARY))
    {
        if(!IS_EVIL(victim) || found)
        {
            found = TRUE;
            if (align)
                dam *= 2;
            else
                dam = dam * 3/2;
        }
    }

    if (saves_spell(level, victim, DAM_NEGATIVE))
        dam /= 2;
    else if (found)
        dispel2(level, victim, AFF_SANCTUARY | AFF_PROTECT_EVIL);


    if (IS_EVIL(victim) && !found)
    {
        act("$N is under {DEvil Forces{x protection.",
                        ch, NULL, victim, TO_ROOM);
        return;
    }

    if (IS_NEUTRAL(victim) && !found)
    {
        act("$N looks not sensitive to this.",
                        ch, NULL, victim, TO_CHAR);
        return;
    }

    damage(ch, victim, dam, sn, DAM_NEGATIVE , TRUE);
}

/* curative, more dispels */

SPELL_FUN(spell_cure_blindness)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (!IS_AFFECTED(victim, AFF_BLIND))
    {
        if (victim == ch)
          char_act("     .", ch);
        else
          act("$N   .",ch,NULL,victim,TO_CHAR);
        return;
    }

    if (dispel2(level, victim, AFF_BLIND))
    {
        char_act("    !", victim);
        act("$n   .",victim,NULL,NULL,TO_ROOM);
    }
    else
        char_act("The miracle is not happened.", ch);
}

/* RT added to cure plague */
SPELL_FUN(spell_cure_disease)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (!IS_AFFECTED(victim, AFF_PLAGUE))
    {
        if (victim == ch)
          char_act("You isn't ill.", ch);
        else
          act("$N isn't ill.",ch,NULL,victim,TO_CHAR);
        return;
    }

    if (dispel2(level, victim, AFF_PLAGUE))
    {
        char_act("Your illness is gone.", victim);
        act("Illness, which was worry  $n, is gone.",victim,NULL,NULL,TO_ROOM);
    }
    else
        char_act("The miracle is not happened.", ch);
}

SPELL_FUN(spell_cure_poison)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (!IS_AFFECTED(victim, AFF_POISON))
    {
        if (victim == ch)
          char_act("  $gn{}.", ch);
        else
          act(" ,  $N .",ch,NULL,victim,TO_CHAR);
        return;
    }

    if (dispel2(level, victim, AFF_POISON))
    {
        char_act("Warm wave is pass through your body.", victim);
        act("$n   .",victim,NULL,NULL,TO_ROOM);
    }
    else
        char_act("The miracle is not happened.", ch);
}

SPELL_FUN(spell_remove_fear)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (!IS_AFFECTED(victim, AFF_FEAR))
    {
        if (victim == ch)
          char_act("Your don't fear very much.", ch);
        else
          act("$N doesn't looks fear very much.", 
                          ch, NULL, victim, TO_CHAR);
        return;
    }

    if (dispel2(level, victim, AFF_FEAR))
    {
        char_act("You feel yourself more brave.", victim);
        act("$n   $gn{} .",victim,NULL,NULL,TO_ROOM);
    }
    else 
        char_act("You failed.", ch);
}

SPELL_FUN(spell_remove_curse)
{
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    bool found = FALSE;

    /* do object cases first */
    if (target == TARGET_OBJ)
    {
        obj = (OBJ_DATA *) vo;

        if (IS_OBJ_STAT(obj, ITEM_NODROP) || IS_OBJ_STAT(obj, ITEM_NOREMOVE))
        {
            if (!IS_OBJ_STAT(obj, ITEM_NOUNCURSE)
            && !saves_dispel(level + 2, obj->level, 0))
            {
                REMOVE_BIT(obj->extra_flags, ITEM_NODROP);
                REMOVE_BIT(obj->extra_flags, ITEM_NOREMOVE);
                act("$p glows blue.", ch, obj, NULL, TO_ALL);
                return;
            }

            act("You can't overcome the {REvil{x contained in $p, it's too strong!", 
                ch, obj, NULL, TO_CHAR);
            return;
        } else 
        {
            char_act("Nothing happing...", ch);
            return;
        }
    }

    /* characters */
    victim = (CHAR_DATA *) vo;
    if (IS_AFFECTED(victim, AFF_CURSE))
    {
        if (dispel2(level, victim, AFF_CURSE))
        {
            char_act("     .", victim);
            act("$n  .",
                            victim, NULL, NULL, TO_ROOM);
        }
        else
            act("The miracle is not happened.", ch, NULL, NULL, TO_CHAR);
        return;
    }

   for (obj = victim->carrying; (obj != NULL && !found); obj = obj->next_content)
   {
        if ((IS_OBJ_STAT(obj, ITEM_NODROP) || IS_OBJ_STAT(obj, ITEM_NOREMOVE))
        && !IS_OBJ_STAT(obj, ITEM_NOUNCURSE))
        {   /* attempt to remove curse */
            if (!saves_dispel(level, obj->level, 0))
            {
                found = TRUE;
                REMOVE_BIT(obj->extra_flags,ITEM_NODROP);
                REMOVE_BIT(obj->extra_flags,ITEM_NOREMOVE);
                act("$p glows {CLight blue{x.", victim, obj, NULL, TO_CHAR);
                act("$p   $n  {C {x.", victim, obj, NULL, TO_ROOM);
            }
         }
    }
}


SPELL_FUN(spell_earthquake)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    char_act("Earth is shake and shiver, you can't stand on it!", ch);
    act("$n makes earth shake and shiver, it's hardly to stay on it.", ch, NULL, NULL, TO_ROOM);

    for (vch = char_list; vch != NULL; vch = vch_next) {
        vch_next    = vch->next;

        if (vch->in_room == NULL)
            continue;

        if (vch->in_room == ch->in_room) {
            if (is_safe_spell(ch, vch, TRUE))
                continue;

            if (IS_AFFECTED(vch,AFF_FLYING))
                damage(ch, vch, 0, sn, DAM_BASH, TRUE);
            else
                damage(ch, vch, level * vch->size / 10,
                    sn,DAM_BASH,TRUE);
            continue;
        }

        if (vch->in_room->area == ch->in_room->area)
            char_act("Earth is shake and shiver.", vch);
    }
}

/*
 * Drain XP, MANA, HP.
 * Caster gains HP.
 */
SPELL_FUN(spell_energy_drain)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (saves_spell(level, victim,DAM_NEGATIVE))
    {
        char_act("Your feel yourself drained.", victim);
        act("You failed to drain energy from $N.", ch, NULL, victim, TO_CHAR);
        return;
    }


    if (victim->level <= 2)
    {
        dam      = ch->hit + 1;
    }
    else
    {
        gain_exp(victim, 0 - number_range(level/5, 3 * level / 5));
        victim->mana    /= 2;
        victim->move    /= 2;
        dam      = dice(1, level);
        ch->hit     += dam;
    }

    char_act("You feel your energy drain away!", victim);
    char_act("Oh! It's cool, rulezzz...", ch);
    damage(ch, victim, dam, sn, DAM_NEGATIVE, TRUE);
}

SPELL_FUN(spell_hellfire)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    damage(ch, victim, dice(level, 7), sn, DAM_FIRE, TRUE);
}

SPELL_FUN(spell_iceball)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    int dam;
    int movedam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level , 12);
    movedam     = number_range(ch->level, 2 * ch->level);

    for (vch = ch->in_room->people; vch; vch = vch_next) {
        vch_next = vch->next_in_room;

        if (is_safe_spell(ch, vch, TRUE))
            continue;

        if (saves_spell(level, vch, DAM_COLD))
            dam /= 2;
        vch->move -= UMIN(vch->move, movedam);
        damage(ch, vch, dam, sn, DAM_COLD, TRUE);
    }
}


SPELL_FUN(spell_fireball)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    CHAR_DATA *vch, *next_vict;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

        fire_effect(victim->in_room, level, dice(level, 7), TARGET_ROOM);
    
    for (vch = victim->in_room->people; vch != NULL; vch = next_vict) {
        next_vict = vch->next_in_room;

        if (is_safe_spell(ch, vch, TRUE)
        || (IS_NPC(vch)
                    && IS_NPC(ch)
            && ch->fighting != vch)
        || (IS_NPC(vch)
            && vch->in_room != ch->in_room
            && IS_SET(vch->pIndexData->act, ACT_NOTRACK)))
                continue;

        if (vch == victim)
            dam = dice(level, 15);
        else {
                    dam = dice(level, 9);
            if (IS_NPC(vch) && vch->position != POS_DEAD
            &&  vch->in_room != ch->in_room) {
                vch->last_fought = ch;
                do_track(vch, str_empty);
                        }
                }
        
        if (saves_spell(level, vch, DAM_FIRE))
            dam /= 2;
        else 
            fire_effect(victim,UMAX(1, level-6),dam/2,TARGET_CHAR);
        damage(ch, vch, dam, sn, DAM_FIRE ,TRUE);
    }
}

SPELL_FUN(spell_fireproof)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    AFFECT_DATA af;

    if (IS_OBJ_STAT(obj,ITEM_BURN_PROOF))
    {
        act("$p is already protected from fire.",ch,obj,NULL,TO_CHAR);
        return;
    }

    af.where     = TO_OBJECT;
    af.type      = sn;
    af.level     = level;
    af.duration  = number_fuzzy(level / 4);
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = ITEM_BURN_PROOF;

    affect_to_obj(obj,&af);

    act("You protect $p from fire.",ch,obj,NULL,TO_CHAR);
    act("$p covered with fireproof layer.",ch,obj,NULL,TO_ROOM);
}

SPELL_FUN(spell_flamestrike)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level, 10);
    if (!saves_spell(level, victim,DAM_FIRE)) {
        fire_effect(victim,level/2,dam/4,TARGET_CHAR);
    }
    if (saves_spell(level, victim,DAM_FIRE))
        dam /= 2;
    damage(ch, victim, dam, sn, DAM_FIRE ,TRUE);
}

SPELL_FUN(spell_faerie_fire)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_AFFECTED(victim, AFF_FAERIE_FIRE))
    {
      if (ch == victim)
        char_act("{MPink aura{x is already surround you.",ch);
      else
        act("{MPink aura{x is already surround $N.",ch,NULL,victim,TO_CHAR);

      return;
    }

    if (saves_spell(level, victim, DAM_MAGIC))
    {
      char_act("Your spell has not passed!", ch);
      return;
    };

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = 10 + level / 5;
    af.location  = APPLY_AC;
    af.modifier  = 2 * level;
    af.bitvector = AFF_FAERIE_FIRE;
    affect_to_char(victim, &af);
    char_act("You are surrounded by {Mpink aura{x.", victim);
    act("$n is surrounded by {Mpink aura{x.", victim, NULL, NULL, TO_ROOM);
}

SPELL_FUN(spell_faerie_fog)
{
    CHAR_DATA *ich;

    act("$n   {R {x.", ch, NULL, NULL, TO_ROOM);
    char_act("   {R {x.", ch);

    for (ich = ch->in_room->people; ich != NULL; ich = ich->next_in_room) {
        if (ich->invis_level > 0)
            continue;

        if (ich == ch || saves_spell(level, ich, DAM_MAGIC))
            continue;

        affect_bit_strip(ich, TO_AFFECTS, 
                        AFF_INVIS | AFF_IMP_INVIS | AFF_EARTHFADE);
        REMOVE_BIT(ich->affected_by, AFF_HIDE | AFF_FADE | AFF_TRAP |
                         AFF_CAMOUFLAGE | AFF_INVIS |
                         AFF_IMP_INVIS | AFF_EARTHFADE);

        act("$n !", ich, NULL, NULL, TO_ROOM);
        char_act(" !", ich);
    }
}

SPELL_FUN(spell_floating_disc)
{
    OBJ_DATA *disc, *floating;
    AFFECT_DATA af;

    floating = get_eq_char(ch,WEAR_FLOAT);
    if (floating != NULL && IS_OBJ_STAT(floating,ITEM_NOREMOVE))
    {
        act("You cannot remove $p.",ch,floating,NULL,TO_CHAR);
        return;
    }

    disc = create_obj(get_obj_index(OBJ_VNUM_DISC), 0);
    disc->value[0]  = ch->level * 10; /* 10 pounds per level capacity */
    disc->value[3]  = ch->level * 5; /* 5 pounds per level max per item */
//    disc->timer     = ch->level * 2;
    disc->owner = str_dup(ch->name);

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = -1;
    af.location  = APPLY_HIT;
    af.modifier  = 3*level/2 + 50;
    af.bitvector = 0;
    affect_to_obj(disc, &af);

    act("$n creates a {Dblack{x floating disk.",ch,NULL,NULL,TO_ROOM);
    char_act("You create a {Dblack{x floating disk.", ch);
    obj_to_char(disc,ch);
    wear_obj(ch,disc,TRUE);
    return;
}

SPELL_FUN(spell_fly)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_FLYING)
    ||  is_affected(victim, sn))
    {
        if (victim == ch)
          char_act("But you are already in flight.", ch);//T
        else
          act("But $N is already flying!",ch,NULL,victim,TO_CHAR); //T
        return;
    }

        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = level + 3;
        af.location  = 0;
        af.modifier  = 0;
        af.bitvector = AFF_FLYING;
        affect_to_char(victim, &af);

    char_act("You are slowly flying up into the sky.", victim);//T
    act("$n slowly flying up.", victim, NULL, NULL, TO_ROOM); //T
}

/* RT clerical berserking spell */
SPELL_FUN(spell_frenzy)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

//    if (is_affected(victim,sn) || IS_AFFECTED(victim,AFF_BERSERK))
    if (is_affected(victim,sn))
    {
        if (victim == ch)
          char_act("You already in fury!", ch);
        else
          act("$N already in fury!",ch,NULL,victim,TO_CHAR);
        return;
    }

    if (is_affected(victim,sn_lookup("calm")))
    {
        if (victim == ch)
          char_act("Why to you it would not will be just a rest a little?", ch);
        else
          act("Not similarly, that $N wants to battle further.", ch,NULL,victim,TO_CHAR);
        return;
    }

    if ((IS_GOOD(ch) && !IS_GOOD(victim))
    || (IS_NEUTRAL(ch) && !IS_NEUTRAL(victim))
    || (IS_EVIL(ch) && !IS_EVIL(victim)))
    {
        act("$N is not pleasant to your God.",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 3;
    af.modifier  = level / 6;
    af.bitvector = 0;

    af.location  = APPLY_HITROLL;
    affect_to_char(victim,&af);

    af.location  = APPLY_DAMROLL;
    affect_to_char(victim,&af);

    af.modifier  = 10 * (level / 12);
    af.location  = APPLY_AC;
    affect_to_char(victim,&af);

    char_act("You filled with divine power!", victim);
    act("$n wildly looks on the parties!",victim,NULL,NULL,TO_ROOM);
}




SPELL_FUN(spell_giant_strength)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
          char_act("You cannot become even stronger!", ch);
        else
          act("$N cannot become even stronger.",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (10 + level / 3);
    af.location  = APPLY_STR;
    af.modifier  = UMAX(2,level / 10);
    af.bitvector = 0;
    affect_to_char(victim, &af);
    char_act("Your muscles are filled with strength of Titans!", victim);
    act("Muscles $n are filled with strength of Titans!",victim,NULL,NULL,TO_ROOM);
    return;
}

SPELL_FUN(spell_harm)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (ch == victim)
    {
        act("You won't do it.", ch, NULL, NULL, TO_CHAR);
        return;         
    }

    dam = level * get_skill(ch, sn) / 120 + dice(5,9);
    
    if (is_affected(victim, gsn_cause_critical))
    {   
        dam *= 4;
        act("You harm $N critically.",
                        ch, NULL, victim, TO_CHAR);
    }
    else if (is_affected(victim, gsn_cause_serious))
    {
        dam *= 3;
        act("You harm $N seriously.",
                        ch, NULL, victim, TO_CHAR);
    }
    else if (is_affected(victim, gsn_cause_light))
    {
        dam *= 2;
        act("You harm $N lightly.",
                        ch, NULL, victim, TO_CHAR);
    }
    
    if (saves_spell(level, victim, DAM_HARM))
        dam = dam * 2/3;

    act("$n harms you with $gn{his} powers.",
                    ch, NULL, victim, TO_VICT);
    victim->hit = UMAX(-1, victim->hit - dam);
    update_pos(victim);
    return;
}

/* RT haste spell */

SPELL_FUN(spell_haste)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_SLOW))
    {
        if (IS_AFFECTED(victim, AFF_HASTE))
            level *= 2;
        dispel1(level, victim, gsn_slow);
    }
    if (IS_AFFECTED(victim, AFF_HASTE))
    {
        if (victim == ch)
            char_act("You cannot move even faster!", ch);
        else
            act("$N already moves so quickly as far as it is possible.",
                ch, NULL, victim, TO_CHAR);
        return;
    }

    if (!check_trust(ch, victim) && saves_spell(level,victim,DAM_MAGIC))
    {
        if (victim != ch)
            char_act("Nothing happing.", ch);
        act("You feel yourself boosted for a moment.",
            victim, NULL, NULL, TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    if (victim == ch)
      af.duration  = level/3;
    else
      af.duration  = level/4;
    af.location  = APPLY_DEX;
    af.modifier  = UMAX(2,level / 12);
    af.bitvector = AFF_HASTE;
    affect_to_char(victim, &af);
    char_act("You start to move much faster!", victim);
    act("$n starts to move much faster.",victim,NULL,NULL,TO_ROOM);
    if (ch != victim)
        char_act("Ok.", ch);
    return;
}

SPELL_FUN(spell_heal)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    if(CAN_HEAL(ch, victim)) {
        if (IS_CYBORG(victim) && ch != victim) {
            char_act("It it is difficult to cure.", ch);
        victim->hit = (UMIN(victim->hit + 50 + level / 10, victim->max_hit));
        update_pos(victim);
        }
        else {
            victim->hit = UMIN(victim->hit + 100 + level / 10, victim->max_hit);
            update_pos(victim);
        }
        char_act("Covers your body warmly.", victim);
        if (ch != victim)
            char_act("Ok.", ch);
    }
    else if (!is_safe(ch,victim))
        damage(ch, victim, 100+level/10, sn, DAM_LIGHT, TRUE);
    return;
}

SPELL_FUN(spell_heat_metal)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    OBJ_DATA *obj_lose, *obj_next;
    int dam = 0;
    bool fail = TRUE;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

   if (!saves_spell(level + 2,victim,DAM_FIRE)
   &&  !is_immune(victim, DAM_FIRE))
   {
        for (obj_lose = victim->carrying; obj_lose != NULL; obj_lose = obj_next)
        {
            obj_next = obj_lose->next_content;

                if (number_range(1,2 * level) > obj_lose->level
                && !saves_spell(level,victim,DAM_FIRE)
                && is_metal(obj_lose)
                && !IS_OBJ_STAT(obj_lose,ITEM_BURN_PROOF))
                {
                    switch (obj_lose->pIndexData->item_type)
                    {
                    case ITEM_ARMOR:
                        if (obj_lose->wear_loc != -1) /* remove the item */
                        {
                            if (can_drop_obj(victim,obj_lose)
                            && (obj_lose->weight / 10) < number_range(1,2 * get_curr_stat(victim,STAT_DEX))
                            && remove_obj(victim, obj_lose->wear_loc, TRUE))
                            {
                                dam += (number_range(1,obj_lose->level) / 3);
                // War_stuff : added
                                if ((victim->in_room 
                                        && IS_SET(victim->in_room->room_flags, ROOM_BATTLE_ARENA))
                                    ||  (victim->in_war && victim->war_status == PS_ALIVE))
                // end-added
                                {
                                    act("$n screams and removes $p!",
                                        victim,obj_lose,NULL,TO_ROOM);
                                    act("You remove from yourself $p, before it burn you!",
                                        victim,obj_lose,NULL,TO_CHAR);
                                    unequip_char(victim, obj_lose);
                                } else
                                {
                                    act("$n screams and drops $p on the ground!",
                                        victim,obj_lose,NULL,TO_ROOM);
                                    act("You remove from yourself $p and throw on the ground, before it burn you!",
                                        victim,obj_lose,NULL,TO_CHAR);
                                    obj_from_char(obj_lose);
                                    obj_to_room(obj_lose, victim->in_room);
                                }
                                fail = FALSE;
                            } else /* stuck on the body! ouch! */
                            {
                                act("Your skin is burnt by $p!",
                                    victim,obj_lose,NULL,TO_CHAR);
                                dam += (number_range(1,2 * obj_lose->level));
                                fail = FALSE;
                            }
                        } else /* drop it if we can */
                        {
                            // War_stuff : added
                            if ((can_drop_obj(victim,obj_lose)
                                    && victim->in_room
                                    && !IS_SET(victim->in_room->room_flags, ROOM_BATTLE_ARENA))
                                || (victim->in_war && victim->war_status == PS_ALIVE))

                            // end-added
                            {
                                dam += (number_range(1,obj_lose->level) / 3);
                                act("$n screams and drops $p on the ground!",
                                    victim,obj_lose,NULL,TO_ROOM);
                                act("You remove from yourself $p and throw on the ground, before it burn you!",
                                    victim,obj_lose,NULL,TO_CHAR);
                                obj_from_char(obj_lose);
                                obj_to_room(obj_lose, victim->in_room);
                                fail = FALSE;
                            } else /* cannot drop */
                            {
                                act("Your skin is burnt from a touch to $p!",
                                    victim,obj_lose,NULL,TO_CHAR);
                                dam += number_range(1,obj_lose->level);
                                fail = TRUE;
                            }
                        }
                    break;
                    case ITEM_WEAPON:
                        if (obj_lose->wear_loc != -1) /* try to drop it */
                        {
                            if (IS_WEAPON_STAT(obj_lose,WEAPON_FLAMING))
                            continue;

                            if (can_drop_obj(victim,obj_lose)
                            && remove_obj(victim,obj_lose->wear_loc,TRUE))
                            {
                                dam += 1;
                            // War_stuff : added
                            if ((victim->in_room 
                                && IS_SET(victim->in_room->room_flags, ROOM_BATTLE_ARENA))
                            || (victim->in_war && victim->war_status == PS_ALIVE))
                            // end-added
                            {
                                act("$n burns by $p!",
                                    victim,obj_lose,NULL,TO_ROOM);
                                char_act("You remove the {R heated {x weapon!", victim);
//                                unequip_char(victim, obj_lose);
                            } else
                            {
                                act("$n burns by $p and throws it on the ground!",
                                    victim,obj_lose,NULL,TO_ROOM);
                                char_act("You throw the {Rheated{x weapon on the ground!", victim);
                                obj_from_char(obj_lose);
                                obj_to_room(obj_lose, victim->in_room);
                            }

                            fail = FALSE;
                        } else /* YOWCH! */
                        {
                            char_act("Your weapon chars your flesh!", victim);
                            dam += number_range(1,2 * obj_lose->level);
                            fail = TRUE;
                        }
                    } else /* drop it if we can */
                    {
                        // War_stuff : added
                        if ((can_drop_obj(victim,obj_lose)
                        && victim->in_room
                        && !IS_SET(victim->in_room->room_flags, ROOM_BATTLE_ARENA))
                        || (victim->in_war && victim->war_status == PS_ALIVE))
                        // end-added
                        {
                            dam += (number_range(1,obj_lose->level) / 3);

                            act("$n drops heated $p on the ground!",
                                victim,obj_lose,NULL,TO_ROOM);
                            act("You throw heated $p before it will burn you!",
                                victim,obj_lose,NULL,TO_CHAR);
                            obj_from_char(obj_lose);
                            obj_to_room(obj_lose, victim->in_room);
                            fail = FALSE;
                        } else /* cannot drop */
                        {
                            act("Your skin chars from contact with $p!",
                                victim,obj_lose,NULL,TO_CHAR);
                            dam += number_range(1,obj_lose->level) ;
                            fail = TRUE;
                        }
                    }
                    break;
                }
            }
        }
    }

    if (fail)
    {
        char_act("Your spell has not made due effect.", ch);
        char_act("You feel as you throws in hot.", victim);
    } else /* damage! */
    {
        if (saves_spell(level,victim,DAM_FIRE))
            dam = 3 * dam / 4;
        damage(ch,victim,dam,sn,DAM_FIRE,TRUE);
    }
}

SPELL_FUN(spell_holy_word)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    int dam;
    int sn_bless, sn_curse;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if ((sn_bless = sn_lookup("bless")) < 0
    || (sn_curse = sn_lookup("curse")) < 0)
        return;

    act("$n    !", ch, NULL, NULL, TO_ROOM);
    char_act("    !", ch);

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next) {
        vch_next = vch->next_in_room;

        if (check_spellbane(ch, vch, sn))
            continue;

        if (HAS_SKILL(vch, gsn_spellbane))
            continue;

        if ((IS_GOOD(ch) && IS_GOOD(vch)) 
        || (IS_EVIL(ch) && IS_EVIL(vch)) 
        || (IS_NEUTRAL(ch) && IS_NEUTRAL(vch))) 
        {
            char_act("    .", vch);
            spell_frenzy(gsn_frenzy, level, ch, vch, TARGET_CHAR);
            spell_bless(sn_bless, level, ch, vch, TARGET_CHAR);
            continue;
        }

        if (is_safe_spell(ch, vch, TRUE))
            continue;

        if ((IS_GOOD(ch) && IS_EVIL(vch))
        || (IS_EVIL(ch) && IS_GOOD(vch))) 
        {
            spell_curse(sn_curse, level, ch, vch, TARGET_CHAR);
            char_act("You are struck down!", vch);
            dam = dice(level, 6);
            damage(ch, vch, dam, sn, DAM_ENERGY, TRUE);
            continue;
        }

        if (IS_NEUTRAL(ch)) 
        {
            spell_curse(sn_curse, level - 10, ch, vch, TARGET_CHAR);
            char_act("You are struck down!", vch);
            dam = dice(level, 4);
            damage(ch, vch, dam, sn, DAM_ENERGY, TRUE);
        }
    }

    char_act("   .", ch);
    gain_exp(ch, -5);
}

SPELL_FUN(spell_identify)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    BUFFER *output;

    output = buf_new(ch->lang);
    format_obj(output, obj, IS_SET(ch->comm2, COMM2_RUSSKILLS));
    if (!IS_SET(obj->extra_flags, ITEM_ENCHANTED))
        format_obj_affects(output, obj->pIndexData->affected,
                   FOA_F_NODURATION | FOA_F_NOAFFECTS);
    format_obj_affects(output, obj->affected, FOA_F_NOAFFECTS);
    page_to_char(buf_string(output), ch);
    buf_free(output);
}

SPELL_FUN(spell_invisibility)
{
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    AFFECT_DATA af;

    /* object invisibility */
    if (target == TARGET_OBJ)
    {
        obj = (OBJ_DATA *) vo;

        if (IS_OBJ_STAT(obj,ITEM_INVIS))
        {
            act("$p  .",ch,obj,NULL,TO_CHAR);
            return;
        }

        af.where    = TO_OBJECT;
        af.type     = sn;
        af.level    = level;
        af.duration = level / 4 + 12;
        af.location = APPLY_NONE;
        af.modifier = 0;
        af.bitvector    = ITEM_INVIS;
        affect_to_obj(obj,&af);

        act("$p fades out of sight.",ch,obj,NULL,TO_ALL);
        return;
    }

    /* character invisibility */
    victim = (CHAR_DATA *) vo;

    if (IS_AFFECTED(victim, AFF_INVIS))
        return;

    act("$n  .", victim, NULL, NULL, TO_ROOM);

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (level / 8 + 10);
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_INVIS;
    affect_to_char(victim, &af);
    char_act("  .", victim);
    return;
}

SPELL_FUN(spell_know_alignment)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        if (victim == ch)
            char_act("You already know alignment.", ch);
        else
            act("$N already know alignment.", ch, NULL, victim, TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (5 + level / 3);
    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = AFF_DETECT_EVIL;
    affect_to_char(victim, &af);

    af.bitvector = AFF_DETECT_GOOD;
    affect_to_char(victim, &af);

    char_act("Now you know alignment.", victim);

    if (ch != victim)
        char_act("Ok.", ch);
    return;

/*    CHAR_DATA *victim = (CHAR_DATA *) vo;
    char *msg;

    if (IS_GOOD(victim)) 
        msg = "$N  ,  .";
    else if (IS_NEUTRAL(victim)) 
        msg = "$N     {R{x,   {W{x.";
    else 
        msg = "$N  {R{x!";

    act(msg, ch, NULL, victim, TO_CHAR);

    if (IS_NPC(victim))
        return;

    if (victim->ethos == ETHOS_LAWFUL)        
        msg = "$N  .";
    else if (victim->ethos == ETHOS_NEUTRAL)   
        msg = "$N  .";
    else if (victim->ethos == ETHOS_CHAOTIC)   
        msg = "$N    .";
    else 
        msg = "$N      .";
    act(msg, ch, NULL, victim, TO_CHAR);
*/
}

SPELL_FUN(spell_lightning_bolt)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (check_grounding(victim))
        return;

    dam = dice(level,4) + 15;
    if (saves_spell(level, victim,DAM_LIGHTNING))
        dam /= 2;
    damage(ch, victim, dam, sn, DAM_LIGHTNING ,TRUE);
}

SPELL_FUN(spell_locate_object)
{
    BUFFER *buffer = NULL;
    OBJ_INDEX_DATA *obj_index;
    OBJ_DATA *obj;
    OBJ_DATA *in_obj;
    int number = 0, max_found;
    CHAR_DATA *victim;
    number = 0;
    max_found = IS_IMMORTAL(ch) ? 200 : 2 * level;

    if ((obj_index = get_remembered_obj_index(ch, target_name)) == NULL)
    {
        char_act("You don't remember such thing.", ch);
    }

    for (obj = object_list; obj != NULL; obj = obj->next) {
        if (!can_see_obj(ch, obj) 
        ||  (obj_index != NULL && obj->pIndexData != obj_index)
        ||  (obj_index == NULL && !is_name(target_name, obj->name))
        ||  IS_OBJ_STAT(obj, ITEM_NOLOCATE)
        ||  number_percent() > 2 * level
        ||  level < obj->level)
            continue;

        if (buffer == NULL)
            buffer = buf_new(-1);
        number++;

        for (in_obj = obj; in_obj->in_obj != NULL;
                        in_obj = in_obj->in_obj)
            ;

        if (in_obj->carried_by != NULL
        &&  can_see(ch,in_obj->carried_by))
            buf_printf(buffer, "     %s\n",
            fix_short(PERS(in_obj->carried_by, ch)));
        else
        {
            if (IS_IMMORTAL(ch) && in_obj->in_room != NULL)
            buf_printf(buffer, "     %s [Room %d]\n",
                mlstr_cval(in_obj->in_room->name, ch),
                in_obj->in_room->vnum);
            else
             {if ((in_obj->in_room != NULL) || ((victim = in_obj->carried_by) && IS_NPC(victim)))
                buf_printf(buffer, "    %s\n",
                in_obj->in_room == NULL ?
                GETMSG("somewhere", ch->lang) :
                mlstr_cval(in_obj->in_room->name, ch));
             }
        }

        if (number >= max_found)
            break;
    }

    if (buffer == NULL)
        char_act("          .", ch);
    else {
        page_to_char(buf_string(buffer),ch);
        buf_free(buffer);
    }
}

SPELL_FUN(spell_magic_missile)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;
    int nmissiles;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(victim, gsn_protective_shield) && number_percent() < 50)  
    {
        act("  $N    !",
            ch, NULL, victim, TO_CHAR);
        act("     ,  $N!",
            victim, NULL, ch, TO_CHAR);
        return;
    }


    nmissiles = UMAX(1, level/16 + 1);
    while (nmissiles--) 
    {
        dam = number_range(level, 3*level/2) + 10;

        if (saves_spell(level, victim, DAM_ENERGY))
            dam /= 2;
        damage(ch, victim, dam, sn, DAM_ENERGY ,TRUE);
        if (JUST_KILLED(victim)) return;
        if (number_percent() > nmissiles*40) return;
    }
    return;

}

SPELL_FUN(spell_mass_healing)
{
    CHAR_DATA *gch;
    int heal_num, refresh_num;

    heal_num = sn_lookup("heal");
    refresh_num = sn_lookup("refresh");

    for (gch = ch->in_room->people; gch != NULL; gch = gch->next_in_room)
        if ((IS_NPC(ch) && IS_NPC(gch))
        || (!IS_NPC(ch) && !IS_NPC(gch))) 
        {
            if (IS_CYBORG(gch)) 
            {
                char_act("  .", ch);
                continue;
            }
            if (check_spellbane(ch, gch, sn))
                continue;

            spell_heal(heal_num, level, ch, (void *) gch,
                TARGET_CHAR);
            spell_refresh(refresh_num, level, ch, (void *) gch,
                TARGET_CHAR);
        }
}

SPELL_FUN(spell_mass_invis)
{
    AFFECT_DATA af;
    CHAR_DATA *gch;

    for (gch = ch->in_room->people; gch != NULL; gch = gch->next_in_room)
    {
        if (!is_same_group(gch, ch) || IS_AFFECTED(gch, AFF_INVIS))
            continue;

        if (check_spellbane(ch, gch, sn))
            continue;
    
        act("$n  .", gch, NULL, NULL, TO_ROOM);
        char_act("  .", gch);

        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level/2;
        af.duration  = 24;
        af.location  = APPLY_NONE;
        af.modifier  = 0;
        af.bitvector = AFF_INVIS;
        affect_to_char(gch, &af);
    }
    char_act("Ok.", ch);

    return;
}

SPELL_FUN(spell_pass_door)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_PASS_DOOR))
    {
        if (victim == ch)
          char_act("     !", ch);
        else
          act("$N     .",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = number_fuzzy(level / 4);
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_PASS_DOOR;
    affect_to_char(victim, &af);
    act(" $n  .", victim, NULL, NULL, TO_ROOM);
    char_act("   .", victim);
    return;
}

/* RT plague spell, very nasty */

SPELL_FUN(spell_plague)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (saves_spell(level,victim,DAM_DISEASE) || IS_UNDEAD(victim))
    {
        if (ch == victim)
            char_act("   ,    .", ch);
        else
            act("$N   .",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level * 3/4;
    af.duration  = (10 + level / 10);
    af.location  = APPLY_STR;
    af.modifier  = -10;
    af.bitvector = AFF_PLAGUE;
    affect_join(victim,&af);

    char_act("    ,         .", victim);
    act("$n    ,        $gn{} .",
        victim,NULL,NULL,TO_ROOM);
}

SPELL_FUN(spell_poison)
{
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    AFFECT_DATA af;


    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (target == TARGET_OBJ)
    {
        obj = (OBJ_DATA *) vo;

        if (obj->pIndexData->item_type == ITEM_FOOD || obj->pIndexData->item_type == ITEM_DRINK_CON)
        {
            if (IS_OBJ_STAT(obj,ITEM_BLESS) || IS_OBJ_STAT(obj,ITEM_BURN_PROOF))
            {
                act("     $p.",ch,obj,NULL,TO_CHAR);
                return;
            }
            obj->value[3] = 1;
            act("$p   .",ch,obj,NULL,TO_ALL);
            return;
        }

        if (obj->pIndexData->item_type == ITEM_WEAPON)
        {
            if (IS_WEAPON_STAT(obj,WEAPON_FLAMING)
            ||  IS_WEAPON_STAT(obj,WEAPON_FROST)
            ||  IS_WEAPON_STAT(obj,WEAPON_VAMPIRIC)
            ||  IS_WEAPON_STAT(obj,WEAPON_SHOCKING)
            ||  IS_WEAPON_STAT(obj,WEAPON_RADIATION)
            ||  IS_WEAPON_STAT(obj,WEAPON_HOLY)
            ||  IS_OBJ_STAT(obj,ITEM_BLESS) || IS_OBJ_STAT(obj,ITEM_BURN_PROOF))
            {
                act("    $p.",ch,obj,NULL,TO_CHAR);
                return;
            }

            if (IS_WEAPON_STAT(obj,WEAPON_POISON))
            {
                act("$p    .",ch,obj,NULL,TO_CHAR);
                return;
            }

            af.where     = TO_WEAPON;
            af.type  = sn;
            af.level     = level / 2;
            af.duration  = level/8;
            af.location  = 0;
            af.modifier  = 0;
            af.bitvector = WEAPON_POISON;
            affect_to_obj(obj,&af);

            act("$p   .",ch,obj,NULL,TO_ALL);
            return;
        }

        act("    $p.",ch,obj,NULL,TO_CHAR);
        return;
    }

    victim = (CHAR_DATA *) vo;

    if (saves_spell(level, victim, DAM_POISON))
    {
        act("$N   {G{z,    .",ch,NULL,victim,TO_CHAR);
        char_act("   ,    .", victim);
        return;
    }

    if (!IS_AFFECTED(victim, AFF_POISON))
    {
        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = (10 + level / 10);
        af.location  = APPLY_STR;
        af.modifier  = -5;
        af.bitvector = AFF_POISON;
        affect_join(victim, &af);
        char_act("    !", victim);
        act(" $N   .",ch,NULL,victim,TO_CHAR);
    } else 
    {
        act(" $N   ,  ң.",ch,NULL,victim,TO_CHAR);
    }
    return;
}

SPELL_FUN(spell_protection_evil)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_PROTECT_EVIL)
    ||   IS_AFFECTED(victim, AFF_PROTECT_GOOD))
    {
        if (victim == ch)
          char_act("  $gn{}.", ch);
        else
          act("$N  $gN{}.",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (10 + level / 5);
    af.location  = APPLY_SAVING_SPELL;
    af.modifier  = -5;
    af.bitvector = AFF_PROTECT_EVIL;
    affect_to_char(victim, &af);
    char_act("    {W {x!", victim);
    if (ch != victim)
        act("$N   $gN{}  {R{x.",ch,NULL,victim,TO_CHAR);
    return;
}

SPELL_FUN(spell_protection_good)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_PROTECT_GOOD)
    ||   IS_AFFECTED(victim, AFF_PROTECT_EVIL))
    {
        if (victim == ch)
          char_act("  $gn{}.", ch);
        else
          act("$N  $gN{}.",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (10 + level / 5);
    af.location  = APPLY_SAVING_SPELL;
    af.modifier  = -5;
    af.bitvector = AFF_PROTECT_GOOD;
    affect_to_char(victim, &af);
    char_act("    {R {x!", victim);
    if (ch != victim)
        act(" $N $gN{}  {W {x.",ch,NULL,victim,TO_CHAR);
    return;
}

SPELL_FUN(spell_ray_of_truth)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam, align, mod;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (!IS_GOOD(ch))
    {
        victim = ch;
        char_act("   !", ch);
    }

    if (victim != ch)
    {
        act("$n raises the hand and from it beats {Wflashing ray of light{x!",
            ch,NULL,NULL,TO_ROOM);
        char_act("You raise the hand and from it beats {Wflashing ray of light{x!", ch);
    }

    if (victim->alignment > 0)
    {
        act("On $n it does not operate.",victim,NULL,victim,TO_ROOM);
        char_act("Light cannot harm to you!", victim);
        return;
    }


    align = (ch->alignment == 0) ? 75 : 100;
    mod = URANGE (0, ch->alignment - victim->alignment, 2000);
    align *= mod;
    dam = align * dice(level, 9)  / 100000;
    if (saves_spell(level, victim, DAM_HOLY))
        dam /= 2;
    spell_blindness(sn, 3 * level / 4, ch, vo, TARGET_CHAR);
    damage(ch, victim, dam, sn, DAM_HOLY ,TRUE);
}


SPELL_FUN(spell_recharge)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    int chance, percent;

    if (obj->pIndexData->item_type != ITEM_WAND && obj->pIndexData->item_type != ITEM_STAFF)
    {
        char_act("This subject is not rechargable.", ch);
        return;
    }

    if (obj->value[3] >= 3 * level / 2)
    {
        char_act("It is not enough your knowledge for this purpose.", ch);
        return;
    }

    if (obj->value[1] == 0)
    {
        char_act("This subject once already recharged.", ch);
        return;
    }

    chance = 40 + 2 * level;

    chance -= obj->value[3]; /* harder to do high-level spells */
    chance -= (obj->value[1] - obj->value[2]) *
              (obj->value[1] - obj->value[2]);

    chance = UMAX(level/2,chance);

    percent = number_percent();

    if (percent < chance / 2)
    {
        act("$p flashes soft light.",ch,obj,NULL,TO_CHAR);
        act("$p flashes soft light.",ch,obj,NULL,TO_ROOM);
        obj->value[2] = UMAX(obj->value[1],obj->value[2]);
        obj->value[1] = 0;
        return;
    }

    else if (percent <= chance)
    {
        int chargeback,chargemax;

        act("$p flashes soft light.",ch,obj,NULL,TO_CHAR);
        act("$p flashes soft light.",ch,obj,NULL,TO_CHAR);

        chargemax = obj->value[1] - obj->value[2];

        if (chargemax > 0)
            chargeback = UMAX(1,chargemax * percent / 100);
        else
            chargeback = 0;

        obj->value[2] += chargeback;
        obj->value[1] = 0;
        return;
    }

    else if (percent <= UMIN(95, 3 * chance / 2))
    {
        char_act("Nothing happing.", ch);
        if (obj->value[1] > 1)
            obj->value[1]--;
        return;
    }

    else /* whoops! */
    {
        act("$p brightly flashes and blows up!",ch,obj,NULL,TO_CHAR);
        act("$p brightly flashes and blows up!",ch,obj,NULL,TO_ROOM);
        extract_obj(obj);
    }
}

SPELL_FUN(spell_refresh)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    victim->move = UMIN(victim->move + level, victim->max_move);
    if (victim->max_move == victim->move)
        char_act("You feel inflow of forces!", victim);
    else
        char_act("You feel inflow of forces!", victim);
    if (ch != victim)
        char_act("Ok.", ch);
    return;
}

SPELL_FUN(spell_sanctuary)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_SANCTUARY))
    {
        if (victim == ch)
            char_act("The {WWhite Aura{x already surrounds you.", ch);
        else
            act("The {WWhite Aura{x already surrounds $N.",ch,NULL,victim,TO_CHAR);
        return;
    }

    if (IS_AFFECTED(victim, AFF_BLACK_SHROUD))
    {
        if (victim == ch)
            char_act("The {DBlack Aura{x already surrounds you.", ch);
        else
            act("The {DBlack Aura{x already surrounds $N.",
                ch, NULL, victim, TO_CHAR);
        return;
    }

    if(IS_UNDEAD(victim))
    {
        if(!is_safe(ch, victim))
            damage(ch, victim, 2*level, sn, DAM_LIGHT, TRUE);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 6;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_SANCTUARY;
    affect_to_char(victim, &af);
    act("$n is surrounded by the {WWhite Aura{x.", victim, NULL, NULL, TO_ROOM);
    char_act("You are surrounded by the {WWhite Aura{x.", victim);
    return;
}

SPELL_FUN(spell_black_shroud)
{
    CHAR_DATA *victim = (CHAR_DATA*) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_SANCTUARY))
    {
        if (victim==ch)
            char_act("The {WWhite Aura{x already surrounds you.", ch);
        else
            act("The {WWhite Aura{x already surrounds $N.", ch, NULL, victim,TO_CHAR);
        return;
    }

    if (!IS_EVIL(ch))
    {
        char_act("Gods are angry!", ch);
        damage(ch, ch, dice(level, IS_GOOD(ch)?2:1), TYPE_HIT, DAM_HOLY, TRUE);
        return;
    }

    if (!IS_EVIL(victim))
    {
        act("    $N!", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (IS_AFFECTED(victim, AFF_BLACK_SHROUD))
    {
        if (victim==ch)
            char_act("  $gn{}.", ch);
        else
            act("$N  $gN{}.", ch, NULL, victim, TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level/6;
    af.location  = APPLY_SAVING_SPELL;
    af.modifier  = -5;
    af.bitvector = AFF_BLACK_SHROUD;
    affect_to_char(victim, &af);
    act("$n is surrounded by the {DBlack Aura{x.", victim, NULL, NULL, TO_ROOM);
    char_act("You are surrounded by the {DBlack Aura{x!", victim);
    return;
}

SPELL_FUN(spell_shield)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("The magic shield already surrounds you.", ch);
        else
            act("$N it is already surrounded with a magic shield.",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = 2 + level/10;
    af.location  = APPLY_AC;
    af.modifier  = - level/3;
    af.bitvector = 0;
    affect_to_char(victim, &af);
    act("$n it is surrounded by protective aura.", victim, NULL, NULL, TO_ROOM);
    char_act("Around of you there is a protective aura.", victim);
    return;
}

SPELL_FUN(spell_shocking_grasp)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = number_range(level, level*3) + 25;

    if (saves_spell(level, victim,DAM_LIGHTNING))
        dam /= 2;
    else
        shock_effect(victim, level, dam*3, TARGET_CHAR);

    damage(ch, victim, dam, sn, DAM_LIGHTNING ,TRUE);
}

SPELL_FUN(spell_sleep)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    level += level / 10;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_AFFECTED(victim, AFF_SLEEP))
    {
      act("$N already for a long time sees the seventh dream!",ch,NULL,victim,TO_CHAR);
      return;
    }

    if (IS_UNDEAD(victim))
    {
        act("$N is undead and cannot be lulled!", ch, NULL, victim, TO_CHAR);
        return;

    }

    if (!IS_NPC(victim) && (level < victim->level))
    {
        char_act("Something prompts you, that it will fail!", ch);
        return;
    }

    if (is_affected (victim, gsn_insomnia))
    {
        act("But $N cannot fall asleep.", ch, NULL, victim, TO_CHAR);
        return;
    }   

    if (victim->fighting)
    {
        char_act("It is rather difficult to lull the one who battles.", ch);
        return;
    }

    if (saves_spell(level, victim, DAM_CHARM)
    ||  number_bits(1) == 0)
    {
        char_act("Your spell has not passed!", ch);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    //af.duration  = 1 + level/15;
    af.duration  = IS_SET (muddy_mode, MUDDY_RANDOM_SLEEP) ? 
                 number_range (0, 1 + level/15) :  // new value
                 1 + level/15;                     // old value
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_SLEEP;
    affect_join(victim, &af);

    if (IS_AWAKE(victim))
    {
        char_act("You inevitably drives in dream..... Hrrrrrrrrr.... Psssssssss....", victim);
        act("Suddenly $n falls asleep.", victim, NULL, NULL, TO_ROOM);
        victim->position = POS_SLEEPING;
    }
    return;
}

SPELL_FUN(spell_slow)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (check_tattoo (victim, sn_lookup("sandglass")))
    {
        if (ch != victim)
        {
            act ("It seems that sandglass on $N's skin turns over!", ch, NULL, victim, TO_NOTVICT);
            act ("It seems that sandglass on your skin turns over!", ch, NULL, victim, TO_VICT);
        }
        else
        {
            act ("It seems that sandglass on $n's skin turns over!", ch, NULL, NULL, TO_ROOM);
            act ("It seems that sandglass on your skin turns over!", ch, NULL, NULL, TO_CHAR);
        }
        return;
    }

    if (IS_AFFECTED(victim, AFF_HASTE))
    {
        if (IS_AFFECTED(victim, AFF_SLOW))
            level *= 2;
        dispel1(level, victim, gsn_haste);
    }
    if (is_affected(victim, sn) || IS_AFFECTED(victim,AFF_SLOW))
    {
        if (victim == ch)
          char_act("You cannot move even more slowly!", ch);
        else
          act("$N cannot move even more slowly.",
              ch,NULL,victim,TO_CHAR);
        return;
    }

    if (!check_trust(ch, victim) && saves_spell(level, victim, DAM_MAGIC))
    {
        if (victim != ch)
            char_act("Nothing happing.", ch);
        char_act("For an instant you have felt terrible drowsiness.", victim);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (4 + level / 12);
    af.location  = APPLY_DEX;
    af.modifier  = - UMAX(2,level / 12);
    af.bitvector = AFF_SLOW;
    affect_to_char(victim, &af);
    char_act("Your movements are  s l o w i n g...", victim);
    act("$n starts to move more slowly.",victim,NULL,NULL,TO_ROOM);
    return;
} 

SPELL_FUN(spell_stone_skin)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            affect_strip(victim, sn);
        else
        {
            act("$N is already as hard as can be.", ch, NULL, victim, TO_CHAR);
            return;
        }
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (10 + level / 5);
    af.location  = APPLY_AC;
    af.modifier  = -1 * UMAX(40,20 + level / 2);  /*af.modifier=-40;*/
    af.bitvector = 0;
    affect_to_char(victim, &af);
    act("$n's skin turns to stone.", victim, NULL, NULL, TO_ROOM);
    char_act("Your skin turns to stone.", victim);
    return;
}

bool check_stoneskin(CHAR_DATA *ch, CHAR_DATA *victim)
{
    AFFECT_DATA *paf     ;
    AFFECT_DATA *paf_next;
    AFFECT_DATA *paf_new ;
    int mod = 1 ;
    int modifier;
   
    if (!is_affected(victim, sn_lookup("stone skin")) 
    || number_percent() / 2 < get_skill(victim, sn_lookup("stone skin")) 
        + get_curr_stat(victim, STAT_LCK))
        return FALSE;
   
    for ( paf = victim->affected; paf != NULL; paf = paf_next )
    {   
         paf_next = paf->next;
         if (paf->type != sn_lookup("stone skin"))
             continue;
        if (paf->location != APPLY_AC)
             continue;
        break;
    }
   
    mod      = paf->modifier;
    modifier = LVL(ch)/5    ; /*Modifier AC changing of stone skin*/
                              /*victim->affected->modifier += modifier;*/
    if (mod < -modifier)
    {
        paf_new  = aff_new();
        *paf_new = *paf     ;
        paf_new->modifier = modifier;
        paf_new->duration = 0       ;
        affect_join(victim, paf_new);
        act("$n's stone skin cracks under the blows!", victim, NULL, NULL, TO_ROOM);      
        act("Your stone skin cracks under the blows!", victim, NULL, NULL, TO_CHAR);
        aff_free(paf_new);
    } else
    {
        affect_strip(victim, sn_lookup("stone skin"));
        act("$n's stone skin shatters!", victim, NULL, NULL, TO_ROOM);
        act("Your stone skin shatters from the blows!", victim, NULL, NULL, TO_CHAR);
    }
    return TRUE;
}

SPELL_FUN(spell_ventriloquate)
{
    char speaker[MAX_INPUT_LENGTH];
    const char *msg, *msg_saved;
    void *arg2;
    CHAR_DATA *vch;
    CHAR_DATA *char_speaker;
    bool saved;
    bool found_char = FALSE;

    target_name = one_argument(target_name, speaker, sizeof(speaker));
    if ((char_speaker = get_char_room(ch, speaker)) != NULL)
    {
        found_char = TRUE;
        msg = "$N says: '{G$t{x'.";
        msg_saved = "Someone forces $N to say: '{G$t{x'.";
        arg2 = char_speaker;
    }
    else
    {
        msg = "$T says: '{G$t{x'.";
        msg_saved = "Someone forces $T to say: '{G$t{x'.";
        arg2 = speaker;
    }

    for (vch = ch->in_room->people; vch != NULL; vch = vch->next_in_room)
    {
        if (is_name(speaker, vch->name))
            continue;
        saved = saves_spell(level,vch,DAM_MAGIC);
        if (saved)
            act(msg_saved, vch, target_name, arg2, TO_CHAR);
        else
            act(msg, vch, target_name, arg2, TO_CHAR);
    }

    return;
}



SPELL_FUN(spell_weaken)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            act("You so are already weakened!",
                            ch, NULL, NULL, TO_CHAR);
        else
            act("$N already looks weakened.",
                            ch, NULL, victim, TO_CHAR);
        return;
    }

    if (saves_spell(level,victim,DAM_MAGIC)
    ||  is_immune(victim, DAM_MAGIC))
    {
        if (victim != ch)
            act("Nothing happing.",
                            ch, NULL, NULL, TO_CHAR);
        act("For an instant you have felt some weakness.",
                        victim, NULL, NULL, TO_CHAR);
        return;
    }


    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (4 + level / 12);
    af.location  = APPLY_STR;
    af.modifier  = -1 * (2 + level / 12);
    af.bitvector = 0;
    affect_to_char(victim, &af);
    act("You weaken.",
                    victim, NULL, NULL, TO_CHAR);
    act("$n weakens.",
                    victim, NULL, NULL, TO_ROOM);
    return;
} 


/*
 * Draconian spells.
 */
SPELL_FUN(spell_acid_breath)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam,hp_dam,dice_dam,hpch;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    act("$n spits by {Gacid{x in $N.",ch,NULL,victim,TO_NOTVICT);
    act("$n spits in you a stream of {Gacid{x!",ch,NULL,victim,TO_VICT);
    act("You spit by {Gacid{x in $N.",ch,NULL,victim,TO_CHAR);

    hpch = UMAX(12,ch->level*15);
    hp_dam = number_range(hpch/11 + 1, hpch/6);
    dice_dam = dice(level,16);

    dam = UMAX(hp_dam + dice_dam/10,dice_dam + hp_dam/10);

    if (saves_spell(level,victim,DAM_ACID))
    {
        acid_effect(victim,level/2,dam/4,TARGET_CHAR);
        damage(ch,victim,dam/2,sn,DAM_ACID,TRUE);
    }
    else
    {
        acid_effect(victim,level,dam,TARGET_CHAR);
        damage(ch,victim,dam,sn,DAM_ACID,TRUE);
    }
}

SPELL_FUN(spell_fire_breath)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    CHAR_DATA *vch, *vch_next;
    int dam,hp_dam,dice_dam;
    int hpch;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    act("$n exhales a jet of {Rflashing flame{x.",ch,NULL,victim,TO_NOTVICT);
    act("$n exhales in your party a jet of {Rflashing flame{x!",ch,NULL,victim,TO_VICT);
    act("You exhale a jet of {Rflashing flame{x!.",ch,NULL,NULL,TO_CHAR);

    hpch = UMAX(10, ch->level*15);
    hp_dam  = number_range(hpch/9+1, hpch/5);
    dice_dam = dice(level,20);

    dam = UMAX(hp_dam + dice_dam /10, dice_dam + hp_dam / 10);
    fire_effect(victim->in_room,level,dam/2,TARGET_ROOM);

    for (vch = victim->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe_spell(ch,vch,TRUE)
        ||  (IS_NPC(vch) && IS_NPC(ch)
        &&  (ch->fighting != vch /*|| vch->fighting != ch */)))
            continue;

        if (vch == victim) /* full damage */
        {
            if (saves_spell(level,vch,DAM_FIRE))
            {
            fire_effect(vch,level/2,dam/4,TARGET_CHAR);
            damage(ch,vch,dam/2,sn,DAM_FIRE,TRUE);
            }
            else
            {
            fire_effect(vch,level,dam,TARGET_CHAR);
            damage(ch,vch,dam,sn,DAM_FIRE,TRUE);
            }
        }
        else /* partial damage */
        {
            if (saves_spell(level - 2,vch,DAM_FIRE))
            {
            fire_effect(vch,level/4,dam/8,TARGET_CHAR);
            damage(ch,vch,dam/4,sn,DAM_FIRE,TRUE);
            }
            else
            {
            fire_effect(vch,level/2,dam/4,TARGET_CHAR);
            damage(ch,vch,dam/2,sn,DAM_FIRE,TRUE);
            }
        }
    }
}

SPELL_FUN(spell_frost_breath)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    CHAR_DATA *vch, *vch_next;
    int dam,hp_dam,dice_dam, hpch;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    act("$n exhales a cloud of {Bfreezing air{x!",ch,NULL,victim,TO_NOTVICT);
    act("$n exhales in your party a cloud of {Bfreezing air{x!",
        ch,NULL,victim,TO_VICT);
    act("You exhale a jet of {Bfreezing air{x.",ch,NULL,NULL,TO_CHAR);

    hpch = UMAX(12,ch->level*15);
    hp_dam = number_range(hpch/11 + 1, hpch/6);
    dice_dam = dice(level,16);

    dam = UMAX(hp_dam + dice_dam/10,dice_dam + hp_dam/10);
    cold_effect(victim->in_room,level,dam/2,TARGET_ROOM);

    for (vch = victim->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe_spell(ch,vch,TRUE)
        ||  (IS_NPC(vch) && IS_NPC(ch)
        &&   (ch->fighting != vch /*|| vch->fighting != ch*/)))
            continue;

        if (vch == victim) /* full damage */
        {
            if (saves_spell(level,vch,DAM_COLD))
            {
            cold_effect(vch,level/2,dam/4,TARGET_CHAR);
            damage(ch,vch,dam/2,sn,DAM_COLD,TRUE);
            }
            else
            {
            cold_effect(vch,level,dam,TARGET_CHAR);
            damage(ch,vch,dam,sn,DAM_COLD,TRUE);
            }
        }
        else
        {
            if (saves_spell(level - 2,vch,DAM_COLD))
            {
            cold_effect(vch,level/4,dam/8,TARGET_CHAR);
            damage(ch,vch,dam/4,sn,DAM_COLD,TRUE);
            }
            else
            {
            cold_effect(vch,level/2,dam/4,TARGET_CHAR);
            damage(ch,vch,dam/2,sn,DAM_COLD,TRUE);
            }
        }
    }
}


SPELL_FUN(spell_gas_breath)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    int dam,hp_dam,dice_dam,hpch;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    act("$n exhales a cloud of {cpoison gas{x!",ch,NULL,NULL,TO_ROOM);
    act("You exhale a cloud of {cpoison gas{x.",ch,NULL,NULL,TO_CHAR);

    hpch = UMAX(16,ch->level*15);
    hp_dam = number_range(hpch/15+1,8);
    dice_dam = dice(level,12);

    dam = UMAX(hp_dam + dice_dam/10,dice_dam + hp_dam/10);
    poison_effect(ch->in_room,level,dam,TARGET_ROOM);

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    { 
        vch_next = vch->next_in_room;

        if (is_safe_spell(ch,vch,TRUE)
        ||  (IS_NPC(ch) && IS_NPC(vch)
        &&   (ch->fighting == vch || vch->fighting == ch)))
            continue;

        if (saves_spell(level,vch,DAM_POISON))
        {
            poison_effect(vch,level/2,dam/4,TARGET_CHAR);
            damage(ch,vch,dam/2,sn,DAM_POISON,TRUE);
        }
        else
        {
            poison_effect(vch,level,dam,TARGET_CHAR);
            damage(ch,vch,dam,sn,DAM_POISON,TRUE);
        }
    }
}

SPELL_FUN(spell_lightning_breath)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam,hp_dam,dice_dam,hpch;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    act("$n exhales a {Wflashing lightning{x aside $N!",ch,NULL,victim,TO_NOTVICT);
    act("$n exhales in you a {Wflashing lightning{x!",ch,NULL,victim,TO_VICT);
    act("You exhale a {Wflashing lightning{x aside $N!",ch,NULL,victim,TO_CHAR);

    hpch = UMAX(10,ch->level*15);
    hp_dam = number_range(hpch/9+1,hpch/5);
    dice_dam = dice(level,20);

    dam = UMAX(hp_dam + dice_dam/10,dice_dam + hp_dam/10);

    if (check_grounding(victim))
        return;
    
    if (saves_spell(level,victim,DAM_LIGHTNING))
    {
        shock_effect(victim,level/2,dam/4,TARGET_CHAR);
        damage(ch,victim,dam/2,sn,DAM_LIGHTNING,TRUE);
    }
    else
    {
        shock_effect(victim,level,dam,TARGET_CHAR);
        damage(ch,victim,dam,sn,DAM_LIGHTNING,TRUE);
    }
}

/*
 * Spells for mega1.are from Glop/Erkenbrand.
 */
SPELL_FUN(spell_general_purpose)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = number_range(25, 100);
    if (saves_spell(level, victim, DAM_PIERCE))
        dam /= 2;
    damage(ch, victim, dam, sn, DAM_PIERCE ,TRUE);
}

SPELL_FUN(spell_high_explosive)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = number_range(level/2, level) + 15;
    if (saves_spell(level, victim, DAM_PIERCE))
        dam /= 2;
    damage(ch, victim, dam, sn, DAM_PIERCE ,TRUE);
}

SPELL_FUN(spell_find_object)
{
    BUFFER *buffer = NULL;
    OBJ_INDEX_DATA *obj_index;
    OBJ_DATA *obj;
    OBJ_DATA *in_obj;
    int number = 0, max_found;

    number = 0;
    max_found = IS_IMMORTAL(ch) ? 200 : 2 * level;

    if ((obj_index = get_remembered_obj_index(ch, target_name)) == NULL)
    {
        char_act("You don't remember such thing.", ch);
    }

    for (obj = object_list; obj != NULL; obj = obj->next)
    {
        if (!can_see_obj(ch, obj) 
        || (obj_index != NULL && obj->pIndexData != obj_index)
        || (obj_index == NULL && !is_name(target_name, obj->name))
        || IS_OBJ_STAT(obj, ITEM_NOFIND)
        || number_percent() > 2 * level)
            continue;

        if (buffer == NULL)
            buffer = buf_new(-1);
        number++;

        for (in_obj = obj; in_obj->in_obj != NULL;
                        in_obj = in_obj->in_obj)
            ;

        if (in_obj->carried_by != NULL
        && can_see(ch, in_obj->carried_by))
            buf_printf(buffer, "     %s\n",
                fix_short(PERS(in_obj->carried_by, ch)));
        else
        {
            if (IS_IMMORTAL(ch) && in_obj->in_room != NULL)
                buf_printf(buffer, "     %s [ %d]\n",
                    mlstr_cval(in_obj->in_room->name, ch),
                    in_obj->in_room->vnum);
            else
                buf_printf(buffer, "     %s\n",
                    in_obj->in_room == NULL ?
                    "" :
                    mlstr_cval(in_obj->in_room->name, ch));
        }
        if (number >= max_found)
            break;
    }

    if (buffer == NULL)
        char_act("Anything such it is not found neither in the Haven or on the Earth.", ch);
    else
    {
        page_to_char(buf_string(buffer),ch);
        buf_free(buffer);
    }
}

SPELL_FUN(spell_lightning_shield)
{
    AFFECT_DATA af,af2;

        if (IS_SET(ch->in_room->room_flags, ROOM_LAW)) {
                char_act("Mystical force protects a room.", ch);
                return;
        }

    if (is_affected_room(ch->in_room, sn))
    {
        char_act("The room is already protected by lightnings.", ch);
        return;
    }

    if (is_affected(ch,sn))
    {
        char_act("It is impossible to use this spell frequently too.", ch);
        return;
    }

    af.where     = TO_ROOM_AFFECTS;
    af.type      = sn;
    af.level     = ch->level;
    af.duration  = level / 40;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = RAFF_LSHIELD;
    affect_to_room(ch->in_room, &af);

    af2.where     = TO_AFFECTS;
    af2.type      = sn;
    af2.level    = ch->level;
    af2.duration  = level / 15;
    af2.modifier  = 0;
    af2.location  = APPLY_NONE;
    af2.bitvector = 0;
    affect_to_char(ch, &af2);

    ch->in_room->owner = str_dup(ch->name);
    char_act("Then that there in a room lightnings start to arise.", ch);
    act("In a room lightnings which are created with a spell $n start to appear.",ch,NULL,NULL,TO_ROOM);
    return;
}

SPELL_FUN(spell_shocking_trap)
{
    AFFECT_DATA af,af2;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

        if (IS_SET(ch->in_room->room_flags, ROOM_LAW)) {
                char_act("Mystical force protects a room.", ch);
                return;
        }

    if (is_affected_room(ch->in_room, sn))
    {
        char_act("In this room the trap creating shock waves is already established.", ch);
        return;
    }

    if (is_affected(ch,sn))
    {
        char_act("It is impossible to use this spell frequently too.", ch);
        return;
    }

    af.where     = TO_ROOM_AFFECTS;
    af.type      = sn;
    af.level     = ch->level;
    af.duration  = level / 20;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = RAFF_SHOCKING;
    affect_to_room(ch->in_room, &af);

    af2.where     = TO_AFFECTS;
    af2.type      = sn;
    af2.level    = level;
    af2.duration  = ch->level / 15;
    af2.modifier  = 0;
    af2.location  = APPLY_NONE;
    af2.bitvector = 0;
    affect_to_char(ch, &af2);
    char_act("On a room the blast wave is carried by.", ch);
    act("On a room shock waves which are created with a spell $n are carried by.",ch,NULL,NULL,TO_ROOM);
    return;
}

SPELL_FUN(spell_acid_arrow)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = number_range(level*6, level*8);
    if (saves_spell(level, victim, DAM_ACID))
        dam /= 2;
    acid_effect(victim, UMAX(1, level-2), dam/2, TARGET_CHAR);
    damage(ch, victim, dam, sn,DAM_ACID,TRUE);
}


/* energy spells */
SPELL_FUN(spell_etheral_fist)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level, 12);
    if (saves_spell(level, victim, DAM_ENERGY))
        dam /= 2;
    act("From the {DDARKNESS{x huge, hardly tangible fist is condensed and rams $N, leaving $gN{him} in the stunned condition!"
            ,ch,NULL,victim,TO_NOTVICT);
    damage(ch, victim, dam, sn,DAM_ENERGY,TRUE);
}

SPELL_FUN(spell_spectral_furor)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level, 8);
    if (saves_spell(level, victim, DAM_ENERGY))
        dam /= 2;
    act("Itself {Bcosmic matter{x with fury addresses against $N!",
            ch,NULL,victim,TO_NOTVICT);
    damage(ch, victim, dam, sn,DAM_ENERGY,TRUE);
}

SPELL_FUN(spell_disruption)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level, 9);
    if (saves_spell(level, victim, DAM_ENERGY))
        dam /= 2;
    act("Unreal energy covers $N, putting under doubt $gN{his} the further existence.",
            ch,NULL,victim,TO_NOTVICT);
    damage(ch, victim, dam, sn,DAM_ENERGY,TRUE);
}


SPELL_FUN(spell_sonic_resonance)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level, 11);
    if (saves_spell(level, victim, DAM_SOUND))
        dam /= 2;
    else
        sound_effect(victim, level/2, dam/2, TARGET_CHAR);
    act("The stream of kinetic energy directs to $N forcing $gN{him} to resound.",
            ch,NULL,victim,TO_NOTVICT);
    damage(ch, victim, dam, sn,DAM_SOUND,TRUE);
}

/* acid */
SPELL_FUN(spell_sulfurus_spray)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level, 7);
    if (saves_spell(level, victim, DAM_ACID))
        dam /= 2;
    act("The smelly stream of hot sulfur a rain spills on a $N's head." ,
            ch,NULL,victim,TO_NOTVICT);
    damage(ch, victim, dam, sn,DAM_ACID,TRUE);
    acid_effect(victim, level/2, dam/2, TARGET_CHAR);
}

SPELL_FUN(spell_caustic_font)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level, 9);
    if (saves_spell(level, victim, DAM_ACID))
        dam /= 2;
    act("The fountain of a caustic liquid suddenly starts to beat directly from under $N's legs. Terrible smell which is distributed from $gN{his} a dying off skin it is awful!",
            ch,NULL,victim,TO_NOTVICT);
    damage(ch, victim, dam, sn,DAM_ACID,TRUE);
    acid_effect(victim, level/2, dam/2, TARGET_CHAR);
}

SPELL_FUN(spell_acetum_primus)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level, 8);
    if (saves_spell(level, victim, DAM_ACID))
        dam /= 2;
    act("A cloak of primal acid enshrouds $N, sparks form as it consumes all it touches. ",
            ch,NULL,victim,TO_NOTVICT);
    damage(ch, victim, dam, sn,DAM_ACID,TRUE);
    acid_effect(victim, level/2, dam/2, TARGET_CHAR);
}

/*  Electrical  */

SPELL_FUN(spell_galvanic_whip)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level, 10);
    if (saves_spell(level, victim, DAM_LIGHTNING))
        dam /= 2;
    else
        shock_effect(victim, level/2, dam/2, TARGET_CHAR);
    act("$n conjures with the ionized particles whip and severely whips it on $N.",
            ch,NULL,victim,TO_NOTVICT);
    damage(ch, victim, dam, sn, DAM_LIGHTNING, TRUE);
}

SPELL_FUN(spell_magnetic_trust)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level, 8);
    if (saves_spell(level, victim, DAM_LIGHTNING))
        dam /= 2;
    act("Invisible streams of energy move around of you, forcing your hair to rise on end!",
            ch,NULL,victim,TO_NOTVICT);
    damage(ch, victim, dam, sn,DAM_LIGHTNING,TRUE);
}

SPELL_FUN(spell_quantum_spike)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = number_range(level*7, level*9);
    if (saves_spell(level, victim, DAM_LIGHTNING))
        dam /= 2;
    act("$N breaks up to set of isolated parts then painfully gathers again.",
            ch,NULL,victim,TO_NOTVICT);
    damage(ch, victim, dam, sn,DAM_LIGHTNING,TRUE);
}

/* negative */
SPELL_FUN(spell_hand_of_undead)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (saves_spell(level, victim, DAM_NEGATIVE)) {
        char_act("For a short instant you feel a terrible cold.", victim);
        char_act("Hand of undead misses your victim.", victim);
        return;
    }

    if (IS_UNDEAD(victim)) {
         char_act("{DHand of Undead{x cannot do much harm to your victim!", ch);
         return;
    }

    if (victim->level <= 2)
        dam      = ch->hit + 1;
    else {
        dam = dice(level, 10);
        victim->mana    /= 2;
        victim->move    /= 2;
        ch->hit     += dam / 2;
    }

    char_act("You feel as your vital force decreases!", victim);
    act("$N it is seized incomprehensible {DHand of Undead{x!",
            ch,NULL,victim,TO_NOTVICT);
    damage(ch, victim, dam, sn,DAM_NEGATIVE,TRUE);
}

/*
 * Transportations
 */ 

/* travel via astral plains */
SPELL_FUN(spell_astral_walk)
{
    CHAR_DATA *victim, *vch, *vch_next;
    //bool gate_pet;

    victim = get_char_world(ch, target_name);

    if (victim == NULL)
    {
        char_act("You failed.", ch);
        return;
    }

    if (ch->in_room->area->planet != victim->in_room->area->planet)
    {
        char_act("You need known star transportation for this.", ch);
        return;
    }

    if(is_gquest_mob (victim))
    {
        char_act("On this creation hunting is declared. You cannot move to it.", ch);
        return;
    }

    if (victim->level >= level + 3
    ||  !can_gate(ch, victim)) {
        char_act("You failed.", ch);
        return;
    }

    /*if (ch->pet != NULL && ch->in_room == ch->pet->in_room)
        gate_pet = TRUE;
    else
        gate_pet = FALSE;*/

    for (vch = ch->in_room->people; vch; vch = vch_next)
    {
        vch_next = vch->next_in_room;
        if (IS_SET (vch->abilities, EA_GATE_WITH) && (vch->master == ch))
            //&& (vch != ch->pet)) // see gate_pet
        {
            act("$n disappears in {Wflashing light{x!",vch,NULL,NULL,TO_ROOM);
            act("You move through {BAstrall Domain{x directly to $N!", vch, NULL, victim, TO_CHAR);
            char_from_room (vch);
            char_to_room (vch,victim->in_room);
            act("$n appears from {Wflashing light{x!",vch,NULL,NULL,TO_ROOM);
        }
    }

    act("$n disappears in {Wflashing light{x!",ch,NULL,NULL,TO_ROOM);
    act("You move through {BAstrall Domain{x directly to $N!", ch, NULL, victim, TO_CHAR);
    char_from_room(ch);
    char_to_room(ch,victim->in_room);

    act("$n appears from {Wflashing light{x!",ch,NULL,NULL,TO_ROOM);
    do_look(ch,"auto");

    /*if (gate_pet) 
    {
        act("$n disappears in {Wflashing light{x!",ch->pet,NULL,NULL,TO_ROOM);
        act("You move through {BAstrall Domain{x directly to $N!", ch, NULL, victim, TO_CHAR);
        char_from_room(ch->pet);
        char_to_room(ch->pet,victim->in_room);
        act("$n appears in a flash of light!",ch->pet,NULL,NULL,TO_ROOM);
        do_look(ch->pet,"auto");
    }*/
}

/*
 * the same transportation
 */

SPELL_FUN(spell_gate)
{
    CHAR_DATA *victim, *vch, *vch_next;
    //bool gate_pet;

    victim = get_char_world(ch, target_name);
    if (victim == NULL)
    {
        char_act("You failed.", ch);
        return;
    }

    if (ch->in_room->area->planet != victim->in_room->area->planet)
    {
        char_act("You need known star transportation for this.", ch);
        return;
    }

    if(is_gquest_mob (victim))
    {
        char_act("On this creation hunting is declared. You cannot move to it.", ch);
        return;
    }

    if (victim->level >= level + 3
    ||  !can_gate(ch, victim)) {
        char_act("You failed.", ch);
        return;
    }


/*    if (ch->pet != NULL && ch->in_room == ch->pet->in_room)
        gate_pet = TRUE;
    else
        gate_pet = FALSE;*/

    for (vch = ch->in_room->people; vch; vch = vch_next)
    {
        vch_next = vch->next_in_room;
        if (IS_SET (vch->abilities, EA_GATE_WITH) && (vch->master == ch))
            //&& (vch != ch->pet)) // see gate_pet
        {
            act("$n does a step in magic gate and disappears.", vch, NULL, NULL, TO_ROOM);
            char_act("You do a step in magic gate and disappear.", vch);
            char_from_room (vch);
            char_to_room (vch,victim->in_room);
            act("$n appears from magic gate.", vch, NULL, NULL, TO_ROOM);
        }
    }

    act("$n does a step in magic gate and disappears.", ch, NULL, NULL, TO_ROOM);
    char_act("You do a step in magic gate and disappear.", ch);
    char_from_room(ch);
    char_to_room(ch, victim->in_room);

    act("$n appears from magic gate.", ch, NULL, NULL, TO_ROOM);
    do_look(ch, "auto");

/*    if (gate_pet)
    {
        if (ch->pet->position != POS_STANDING)
            do_stand(ch->pet, str_empty);

        act("$n does a step in magic gate and disappears.", ch->pet, NULL, NULL, TO_ROOM);
        char_act("You do a step in magic gate and disappear.", ch->pet);
        char_from_room(ch->pet);
        char_to_room(ch->pet, victim->in_room);
        act("$n appears from magic gate.",
            ch->pet, NULL, NULL, TO_ROOM);
        do_look(ch->pet, "auto");
    }*/
}

/* vampire version astral walk */
SPELL_FUN(spell_mist_walk)
{
    CHAR_DATA *victim, *vch, *vch_next;


        victim = get_char_world(ch, target_name);
    if (victim == NULL)
    {
        char_act("You failed.", ch);
        return;
    }

    if (ch->in_room->area->planet != victim->in_room->area->planet)
    {
        char_act("You need known star transportation for this.", ch);
        return;
    }

    if(is_gquest_mob (victim))
    {
        char_act("On this creation hunting is declared. You cannot move to it.", ch);
        return;
    }


    if (victim->level >= level - 5
    ||  saves_spell(level, victim, DAM_MAGIC)
    ||  !can_gate(ch, victim)) {
        char_act("You failed.", ch);
        return;
    }

    for (vch = ch->in_room->people; vch; vch = vch_next)
    {
        vch_next = vch->next_in_room;
        if (IS_SET (vch->abilities, EA_GATE_WITH) && (vch->master == ch))
        {
            act("$n turns to a little cloud of a luminous fog and disappears!",vch,NULL,NULL,TO_ROOM);
            char_act("You turn in a little cloud of a luminous fog and move to the purpose.", vch);
            char_from_room (vch);
            char_to_room (vch,victim->in_room);
            act("The cloud of a luminous fog shrouds you, then dissipates to find out $n!", vch, NULL, NULL, TO_ROOM);
        }
    }

    act("$n turns to a little cloud of a luminous fog and disappears!",ch,NULL,NULL,TO_ROOM);
    char_act("You turn in a little cloud of a luminous fog and move to the purpose.", ch);

    char_from_room(ch);
    char_to_room(ch,victim->in_room);

    act("The cloud of a luminous fog shrouds you, then dissipates to find out $n!", ch, NULL, NULL, TO_ROOM);
    do_look(ch,"auto");

}

/*  Cleric version of astra_walk  */
SPELL_FUN(spell_solar_flight)
{
    ROOM_INDEX_DATA *room;
    CHAR_DATA * vch, *vch_next;

    if  (time_info.hour > 18 || time_info.hour < 8)
    {
         char_act("The sunlight is necessary for this purpose for you.", ch);
         return;
    }

    room = get_remembered_room_index(ch, target_name);

    if (room == NULL)
    {
        char_act("You failed.", ch);
        return;
    }

    if (ch->in_room->area->planet != room->area->planet)
    {
        char_act("You need known star transportation for this.", ch);
        return;
    }

    if (!can_see_room (ch, room) 
    || IS_SET (ch->in_room->room_flags, ROOM_SAFE | ROOM_NORECALL | ROOM_PEACE | ROOM_NOSUMMON) 
    || IS_SET (room->room_flags, ROOM_SAFE | ROOM_NORECALL | ROOM_PEACE | ROOM_NOSUMMON) 
    || IS_SET (room->area->flags, AREA_UNDER_CONSTRUCTION) 
    || room_is_private (room) 
    || IS_RAFFECTED (ch->in_room, RAFF_ESPIRIT))
    {
        char_act("You failed.", ch);
        return;
    }

    // GQ stuff
    if (IS_SET (room->area->flags, AREA_GQACTIVE))
    {
        GQ_QUESTPLR* plr = gq_findplr (ch) ;
        if (plr != NULL && plr->killed_total >= 0)
        {
            char_act("You failed.", ch);
            return;
        }
    }

    for (vch = ch->in_room->people; vch; vch = vch_next)
    {
        vch_next = vch->next_in_room;
        if (IS_SET (vch->abilities, EA_GATE_WITH) && vch->master == ch)
        {
            act ("$n disappears into {Wdazzling flash of light{x!",vch,NULL,NULL,TO_ROOM);
            char_act ("You dissolve in a blinding flash of light!", vch);
            char_from_room (vch);
            char_to_room (vch, room);
            act ("$n appears from {Wdazzling flashes of light{x!",vch,NULL,NULL,TO_ROOM);
        }
    }

    act("$n disappears into {Wdazzling flash of light{x!", ch, NULL, NULL, TO_ROOM);
    char_act("You dissolve in a blinding flash of light!", ch);

    char_from_room(ch);
    char_to_room(ch, room);

    act("$n appears from {Wdazzling flashes of light{x!", ch, NULL, NULL, TO_ROOM);
    do_look(ch, "auto");
}

SPELL_FUN(spell_star_gate)
{
    CHAR_DATA *victim, *vch, *vch_next;

    victim = get_char_world(ch, target_name);

    if (victim == NULL)
    {
        char_act("You failed.", ch);
        return;
    }

    if (ch->in_room->area->planet != victim->in_room->area->planet)
    {
        char_act("You need known star transportation for this.", ch);
        return;
    }

    if(is_gquest_mob (victim))
    {
        char_act("On this creation hunting is declared. You cannot move to it.", ch);
        return;
    }


    if (victim->level >= level + 3
    ||  saves_spell(level, victim, DAM_MAGIC)
    ||  !can_gate(ch, victim)) 
    {
        char_act("You failed.", ch);
        return;
    }

    act("$n raises to the sky on a multi-coloured column of light also disappears in shivering air.",ch,NULL,NULL,TO_ROOM);
    char_act("You are raised to the sky on a multi-coloured column of light and disappear in shivering air.", ch);

    for (vch = ch->in_room->people; vch; vch = vch_next)
    {
        vch_next = vch->next_in_room;
        if (IS_SET (vch->abilities, EA_GATE_WITH) && vch->master == ch)
        {
            act ("$n raises to the sky on a multi-coloured column of light also disappears in shivering air.",vch,NULL,NULL,TO_ROOM);
            char_act ("You are raised to the sky on a multi-coloured column of light and disappear in shivering air.", vch);
            char_from_room (vch);
            char_to_room (vch,victim->in_room);
            act ("$n appears in a multi-coloured column of light.",vch,NULL,NULL,TO_ROOM);
        }
    }

    char_from_room(ch);
    char_to_room(ch,victim->in_room);

    act("$n appears in a multi-coloured column of light.",ch,NULL,NULL,TO_ROOM);
    do_look(ch,"auto");
}

SPELL_FUN(spell_tesseract)
{
    CHAR_DATA *victim;
    CHAR_DATA *wch;
    CHAR_DATA *vch_next;
    bool gate_pet;

    victim = get_char_world(ch, target_name);

    if (victim == NULL)
    {
        char_act("You failed.", ch);
        return;
    }

    if (ch->in_room->area->planet != victim->in_room->area->planet)
    {
        char_act("You need known star transportation for this.", ch);
        return;
    }

    if(is_gquest_mob (victim))
    {
        char_act("On this creation hunting is declared. You cannot move to it.", ch);
        return;
    }

    if (!can_gate(ch, victim)) 
    {
        char_act("You failed.", ch);
        return;
    }

    if (ch->pet != NULL && ch->in_room == ch->pet->in_room)
        gate_pet = TRUE;
    else
        gate_pet = FALSE;

    for (wch = ch->in_room->people; wch != NULL; wch = vch_next)
    {
        vch_next = wch->next_in_room;
        if (wch != ch && is_same_group(wch, ch))
        {
            if (IS_NPC(wch) && !IS_AFFECTED(wch, AFF_CHARM))
                continue;
            act("$n says what that strange words, "
                "and after short, nauseous rolling you start to feel\n"
                "as space and time change around of you!",
                    ch, NULL, wch, TO_VICT);
            char_from_room(wch);
            char_to_room(wch, victim->in_room);
            act("$n suddenly appears here, as if from air.",
                wch, NULL, NULL, TO_ROOM);
            do_look(wch, "auto");
        }
    }

    act("Sudden flash of light, and here already $n and $gn{his} friends disappear!",
        ch, NULL, NULL, TO_ROOM);
    char_act("As soon as you say treasured words, time and space start to blur. You feel as space and time change around of you while you remain in a motionless condition.", ch);
    char_from_room(ch);
    char_to_room(ch, victim->in_room);

    act("$n suddenly appears here, as if from air.", ch, NULL, NULL, TO_ROOM);
    do_look(ch,"auto");

    if (gate_pet) 
    {
        char_act("You feel that time and space vary around of you.", ch->pet);
        char_from_room(ch->pet);
        char_to_room(ch->pet, victim->in_room);
        act("$n suddenly appears here, as if from air.", ch->pet, NULL, NULL, TO_ROOM);
        do_look(ch->pet,"auto");
    }
}

SPELL_FUN(spell_portal)
{
    CHAR_DATA *victim;
    OBJ_DATA *portal, *stone;

    victim = get_char_world(ch, target_name);
    if (victim == NULL)
    {
        char_act("  .", ch);
        return;
    }

    if (ch->in_room->area->planet != victim->in_room->area->planet)
    {
        char_act("You need known star transportation for this.", ch);
        return;
    }

    if (is_gquest_mob (victim))
    {
        char_act("On this creation hunting is declared. You cannot move to it.", ch);
        return;
    }

    if (victim->level >= level + 3
    || saves_spell(level, victim, DAM_NONE)
    || !can_gate(ch, victim)) 
    {
        char_act("  .", ch);
        return;
    }

    stone = get_eq_char(ch,WEAR_HOLD);
    if (!IS_IMMORTAL(ch)
    && (stone == NULL || stone->pIndexData->item_type != ITEM_WARP_STONE))
    {
        char_act("This spell does not work without a magic Warp Stone.(.", ch);
        return;
    }

    if (stone != NULL && stone->pIndexData->item_type == ITEM_WARP_STONE)
    {
        act("You take away energy $p.",ch,stone,NULL,TO_CHAR);
        act("The Warp Stone flashes bright, {Rr{ra{Wi{Rn{rb{Yo{yw{x sparks and disappears with an easy clap!",ch,stone,NULL,TO_CHAR);
        extract_obj(stone);
    }

    portal = create_obj(get_obj_index(OBJ_VNUM_PORTAL),0);
    portal->timer = 2 + level / 25;
    portal->value[3] = victim->in_room->vnum;

    obj_to_room(portal,ch->in_room);

    act("Suddenly, it is direct from the ground the portal rises. ", ch, portal, NULL, TO_ROOM);
    act("Directly before you the portal opens.", ch, portal, NULL, TO_CHAR);
}

SPELL_FUN(spell_nexus)
{
    CHAR_DATA *victim;
    OBJ_DATA *portal, *stone;
    ROOM_INDEX_DATA *to_room, *from_room;

    from_room = ch->in_room;

    victim = get_char_world(ch, target_name);
    if (victim == NULL)
    {
        char_act("  .", ch);
        return;
    }

    if (ch->in_room->area->planet != victim->in_room->area->planet)
    {
        char_act("You need known star transportation for this.", ch);
        return;
    }

    if (is_gquest_mob (victim))
    {
        char_act("On this creation hunting is declared. You cannot move to it.", ch);
        return;
    }

    if (victim->level >= level + 3
    || !can_see_room(ch, from_room)
    || saves_spell(level, victim, DAM_NONE)
    || !can_gate(ch, victim)) 
    {
        char_act("  .", ch);
        return;
    }

    to_room = victim->in_room;

    stone = get_eq_char(ch,WEAR_HOLD);
    if (!IS_IMMORTAL(ch)
    && (stone == NULL || stone->pIndexData->item_type != ITEM_WARP_STONE)) 
    {
        char_act("For this spell you need a magic Warp Stone.", ch);
        return;
    }

    if (stone != NULL && stone->pIndexData->item_type == ITEM_WARP_STONE) 
    {
        act("You take away energy of Warp Stone.",ch,stone,NULL,TO_CHAR);
        act("The Warp Stone flashes bright, {Rr{ra{Wi{Rn{rb{Yo{yw{x sparks and disappears with an easy clap!",ch,stone,NULL,TO_CHAR);
        extract_obj(stone);
    }

    /* portal one */
    portal = create_obj(get_obj_index(OBJ_VNUM_PORTAL),0);
    portal->timer = 1 + level / 10;
    portal->value[3] = to_room->vnum;

    obj_to_room(portal,from_room);

    act("Suddenly, it is direct from the ground the magic portal grows.",ch,portal,NULL,TO_ROOM);
    act("Directly before you the magic portal conducting somewhere opens....",ch,portal,NULL,TO_CHAR);

    /* no second portal if rooms are the same */
    if (to_room == from_room)
        return;

    /* portal two */
    portal = create_obj(get_obj_index(OBJ_VNUM_PORTAL),0);
    portal->timer = 1 + level/10;
    portal->value[3] = from_room->vnum;

    obj_to_room(portal,to_room);

    if (to_room->people != NULL) 
    {
        act("Directly the magic portal grows from the ground.",
            to_room->people, portal, NULL, TO_ROOM);
        act("Directly the magic portal grows from the ground.",
            to_room->people, portal, NULL, TO_CHAR);
    }
}

SPELL_FUN(spell_summon)
{
    bool failed = FALSE;
    CHAR_DATA *victim;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    victim = get_char_world(ch, target_name);

    if (victim == NULL)
    {
        char_act("You failed.", ch);
        return;
    }

    if (ch->in_room->area->planet != victim->in_room->area->planet)
    {
        char_act("You need known star transportation for this.", ch);
        return;
    }

    if (is_gquest_mob (victim))
    {
        char_act("On this creation hunting is declared. You cannot move it to yourself.", ch);
        return;
    }

    if (victim->in_room == NULL)
    {
        char_act("You failed.", ch);
        return;
    }

    if (victim == ch
    ||  victim->level >= level + 3
    ||  victim->fighting != NULL
    ||  !can_see_room(ch, victim->in_room)
    ||  !can_see_room(victim, ch->in_room)
    ||  IS_SET(ch->in_room->room_flags, ROOM_SAFE | ROOM_NORECALL |
                        ROOM_PEACE | ROOM_NOSUMMON)
    ||  IS_SET(victim->in_room->room_flags, ROOM_SAFE | ROOM_NORECALL |
                        ROOM_PEACE | ROOM_NOSUMMON)
    ||  IS_SET(victim->in_room->area->flags, AREA_UNDER_CONSTRUCTION)
    ||  IS_RAFFECTED(victim->in_room, RAFF_ESPIRIT)
    ||  IS_RAFFECTED(victim->in_room, RAFF_PREVENT)
    ||  (ch->in_room->sector_type == SECT_AIR
    && !IS_AFFECTED(victim, AFF_FLYING))
    ||  room_is_private(ch->in_room)
    ||  is_immune(victim, DAM_SUMMON)
    ||  (ch->in_room->exit[0] == NULL &&
         ch->in_room->exit[1] == NULL &&
         ch->in_room->exit[2] == NULL &&
         ch->in_room->exit[3] == NULL &&
         ch->in_room->exit[4] == NULL &&
         ch->in_room->exit[5] == NULL))
        failed = TRUE;
    else if (IS_NPC(victim))
    {
        if (victim->pIndexData->pShop != NULL
        ||  saves_spell(level, victim, DAM_SUMMON)
        ||  IS_SET(victim->pIndexData->act, ACT_AGGRESSIVE)
        ||  IS_SET(ch->in_room->room_flags, ROOM_NOMOB))
            failed = TRUE;
    }
    else
    {
        if (victim->level > LEVEL_HERO
        || ((!in_PK(ch, victim)
        || saves_spell(level, victim, DAM_SUMMON)
        || ch->in_room->area != victim->in_room->area)
        && IS_SET(victim->plr_flags, PLR_NOSUMMON))
        || guild_check(victim, ch->in_room) < 0)
            failed = TRUE;
    }

    if (!check_war_move (victim, ch->in_room, TRUE))
        failed = TRUE;

    if ((check_altar_immobility (ch, ch->in_room) || check_altar_immobility (ch, victim->in_room))
        && ch->clan && (ch->clan != victim->clan))
    {
        char_act ("Altar of {rimmobility{x blocks transportation.", ch);
        failed = TRUE;
    }

    if (failed)
    {
        char_act("You failed.", ch);
        WAIT_STATE(ch, 2 * PULSE_VIOLENCE);
        if (victim->pcdata)
            if (IS_SET(victim->pcdata->wishes, WISH_SHOWSCRY))
                char_act("Something lifts you a little!", victim);
        return;
    }

    if (IS_NPC(victim) && victim->in_mind == NULL)
    {
        char buf[MAX_INPUT_LENGTH];
        snprintf(buf, sizeof(buf),"%d",victim->in_room->vnum);
        victim->in_mind = str_dup(buf);
    }

    act("$n disappears suddenly.", victim, NULL, NULL, TO_ROOM);
    char_from_room(victim);
    char_to_room(victim, ch->in_room);
    act("Suddenly near to you appears $n!", victim, NULL, NULL, TO_ROOM);
    act("$n calls you!", ch, NULL, victim, TO_VICT);
    do_look(victim, "auto");
}

SPELL_FUN(spell_teleport)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    ROOM_INDEX_DATA *pRoomIndex;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (victim->in_room == NULL
    || IS_SET(victim->in_room->room_flags, ROOM_NORECALL)
    || (victim != ch && is_immune(victim, DAM_SUMMON))
    || (!IS_NPC(ch) && victim->fighting != NULL)
    || IS_RAFFECTED(victim->in_room, RAFF_ESPIRIT)
    || IS_RAFFECTED(victim->in_room, RAFF_PREVENT)
    || (victim != ch
    && (saves_spell(level - 5, victim, DAM_MAGIC))))
    {
        char_act("   .", ch);
        return;
    }

    pRoomIndex = get_random_room(victim);

    if (IS_SET(pRoomIndex->room_flags, ROOM_NORECALL)
    || IS_SET(pRoomIndex->room_flags, ROOM_NOSUMMON))
    {
        char_act("opps.....", victim);
        return;
    }

    if (ch->in_room->area->planet != pRoomIndex->area->planet)
    {
       char_act("You need known star transportation for this.", victim);
       return;
    }

    if (!check_war_move (ch, pRoomIndex, FALSE))
        return;

    if (victim != ch)
        char_act("You have been teleported!", victim);

    act("$n !", victim, NULL, NULL, TO_ROOM);
    char_from_room(victim);
    char_to_room(victim, pRoomIndex);
    act("$n is slowly shown in space.", victim, NULL, NULL, TO_ROOM);
    do_look(victim, "auto");
}

SPELL_FUN(spell_bamf)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    ROOM_INDEX_DATA* pRoomIndex;
    AREA_DATA *pArea;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (victim == NULL || victim->in_room == NULL
    || saves_spell(level, victim, DAM_MAGIC))
    {
        act("You failed.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    pArea = victim->in_room->area;

    for (;;)
    {
        pRoomIndex = get_room_index(number_range(pArea->min_vnum, pArea->max_vnum));
        if (pRoomIndex
        && can_see_room(victim, pRoomIndex)
        && !room_is_private(pRoomIndex)
        && !IS_SET(pRoomIndex->room_flags, ROOM_SAFE | ROOM_PEACE))
            break;
    }

    if (victim != ch)
        char_act("You have been teleported!", victim);

    act("$n .", victim, NULL, NULL, TO_ROOM);
    char_from_room(victim);
    char_to_room(victim, pRoomIndex);
    act("$n is slowly shown in space.", victim, NULL, NULL, TO_ROOM);
    do_look(victim, "auto");
}

/* RT recall spell is back */

SPELL_FUN(spell_word_of_recall)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo, *vch, *vch_next;
    ROOM_INDEX_DATA *location;

    if (IS_SAMURAI(ch) && (ch->fighting) && (victim == NULL))
    {
        char_act("Your honor does not allow you to escape from a battlefield!.", ch);
        return;
    }

    if (victim != NULL)
    {
        if  ((victim->fighting) && IS_SAMURAI(victim))
        {
            char_act("You cannot say this spell on valorously battling Samurai!.", ch);
            return;
        }
    }

    if (IS_NPC(victim))
        return;

    location = get_recall(victim);

    if (location == NULL)
    {
        char_act("You were finally lost.", victim);
        return;
    }

    if (victim->desc != NULL && IS_PUMPED(victim))
    {
        char_act("You are too pumped to pray now.", victim);
        return;
    }

    if (victim->in_room->area->planet != location->area->planet)
    {
        char_act("You need known star transportation for this.", victim);
        return;
    }

    if (!check_war_move (victim, location, FALSE))
        return;

    act("$n prays for moving!", victim, NULL, NULL, TO_ROOM);

    if (IS_SET(victim->in_room->room_flags, ROOM_NORECALL)
    ||  IS_AFFECTED(victim, AFF_CURSE)
    ||  IS_RAFFECTED(victim->in_room, RAFF_ESPIRIT)
    ||  IS_RAFFECTED(victim->in_room, RAFF_CURSE)) 
    {
        char_act("  .", victim);
        return;
    }

    if (victim->fighting) 
    {
        if (victim == ch)
            gain_exp(victim, 0 - (victim->level + 25));
        stop_fighting(victim, TRUE);
    }

    for (vch = victim->in_room->people; vch; vch = vch_next)
    {
        vch_next = vch->next_in_room;
        if (IS_SET (vch->abilities, EA_GATE_WITH) && (vch->master == victim))
        {
            act("$n disappears in {Wflashing light{x!",vch,NULL,NULL,TO_ROOM);
            char_from_room (vch);
            char_to_room (vch,location);
            act("$n appears from {Wflashing light{x!",vch,NULL,NULL,TO_ROOM);
        }
    }
    victim->move /= 2;
    act("$n suddenly disappears.", victim, NULL, NULL, TO_ROOM);
    char_from_room(victim);
    char_to_room(victim, location);
    act("Suddenly in a room appears $n!", victim, NULL, NULL, TO_ROOM);
    do_look(victim, "auto");
}



/*
 * End transportations
 */

SPELL_FUN(spell_corruption)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_AFFECTED(victim,AFF_CORRUPTION))
    {
         act("$N already rotted.\n",ch,NULL,victim,TO_CHAR);
         return;
    }

    if (saves_spell(level, victim, DAM_NEGATIVE) || IS_UNDEAD(victim)) 
    {
        if (ch == victim)
            char_act("  ,    .", ch);
        else
            act("$N looks not subject to decomposition.",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level * 3/4;
    af.duration  = (10 + level / 5);
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_CORRUPTION;
    affect_join(victim,&af);

    char_act("You yell from a pain while your body decays.", victim);
    act("$n yells from a pain while $gn{his} body begins to decay.",
        victim, NULL, NULL, TO_ROOM);
}

SPELL_FUN(spell_hurricane)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    int dam, dice_dam, wait = 3;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    act("$n asks God of Storms about the help.",ch,NULL,NULL,TO_NOTVICT);
    act("You ask God Storms to help you.",ch,NULL,NULL,TO_CHAR);

    dice_dam = dice(level, 12);

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe_spell(ch,vch,TRUE)
        || (IS_NPC(ch) && IS_NPC(vch) 
        && (ch->fighting == vch || vch->fighting == ch)))
            continue;
        if (is_safe(ch, vch))
              continue;
        if (!IS_NPC(ch) && vch != ch 
        && ch->fighting != vch && vch->fighting != ch 
        && (IS_SET(vch->affected_by,AFF_CHARM) || !IS_NPC(vch)))
        {
            if (!can_see(vch, ch))
                do_yell(vch, "Help someone is attacking me!");
            else
                act_yell(vch, "Die, $i, you sorcerous dog!", ch, NULL); 
        }

        dam = dice_dam;

        if (IS_AFFECTED(vch, AFF_FLYING)) 
        {
            dam *= 2;
            if (saves_spell(level, vch, DAM_MAGIC))
                wait = 1;
            DAZE_STATE(vch, PULSE_VIOLENCE * wait);
            char_act("The strong wind prevents you to move.", vch);
            act("The strong wind prevents $n to move.",
                vch, NULL, NULL, TO_ROOM);
        }

        if (vch->size <= SIZE_TINY_MAX)   
            dam = dam * 15/10;
        else if (vch->size <= SIZE_SMALL_MAX)  
            dam = dam * 13/10;
        else if (vch->size <= SIZE_MEDIUM_MAX) 
            dam = dam * 10/10;
        else if (vch->size <= SIZE_LARGE_MAX)  
            dam = dam * 9/10;
        else if (vch->size <= SIZE_HUGE_MAX)   
            dam = dam * 7/10;
        else if (vch->size <= SIZE_GIANT_MAX)  
            dam = dam * 5/10;   
        else 
            dam = dam * 4/10;

        if (saves_spell(level, vch, DAM_MAGIC))
            damage(ch, vch, dam/2, sn, DAM_MAGIC, TRUE);
        else
            damage(ch, vch, dam, sn, DAM_MAGIC, TRUE);
    }
    return;
}

SPELL_FUN(spell_detect_undead)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_DETECT_UNDEAD))
    {
        if (victim == ch)
          char_act("You already feel to undead.", ch);
        else
          act("$N already feels to undead.",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (5 + level / 3);
    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = AFF_DETECT_UNDEAD;
    affect_to_char(victim, &af);
    char_act("You feel in the eyes easy tinkling.", victim);
    if (ch != victim)
        char_act("Ok.", ch);
    return;
}

SPELL_FUN(spell_take_revenge)
{
    OBJ_DATA *obj;
    OBJ_DATA *in_obj;
    ROOM_INDEX_DATA *room = NULL;
    clan_t *clan;
    bool found = FALSE;
    AFFECT_DATA af;


    if ((clan = clan_lookup(ch->clan)) == NULL) {
        char_act("Huh?", ch);
        return;
    }

    for (obj = object_list; obj != NULL; obj = obj->next)
    {
        if (obj->pIndexData->vnum != OBJ_VNUM_CORPSE_PC
        || !is_name(ch->name, mlstr_mval(obj->short_descr)))
            continue;

        found = TRUE;
        for (in_obj = obj; in_obj->in_obj; in_obj = in_obj->in_obj)
            ;

        if (in_obj->carried_by != NULL)
            room = NULL;
//          room = in_obj->carried_by->in_room;
        else
            room = in_obj->in_room;
        break;
    }

    if (!found || room == NULL) 
    {
        if ((room = get_room_index(clan->recall_vnum)) == NULL
        || is_affected(ch, sn)) 
        { 
            char_act("You are finally lost...", ch);
            return;
        }
    }

    if (room == get_room_index(clan->recall_vnum) 
    && IS_SET(ch->in_room->room_flags, ROOM_NORECALL)
    && IS_AFFECTED(ch, AFF_CURSE)
    && IS_RAFFECTED(ch->in_room, RAFF_CURSE))
    {
        char_act("You are finally lost.", ch);
        return;
    }                                                        

    if ((IS_SET(room->room_flags, ROOM_NORECALL)
    && (room != get_room_index(clan->recall_vnum)))
    || IS_RAFFECTED(room, RAFF_CURSE)
    || IS_RAFFECTED(room, RAFF_ESPIRIT)
    || IS_RAFFECTED(room, RAFF_PREVENT)
    || IS_RAFFECTED(ch->in_room, RAFF_ESPIRIT))
    {
        char_act("You were lost.", ch);
        return;
    }                                                        

    if (ch->desc && IS_PUMPED(ch))
    {
        char_act("You should calm down.", ch);
        return;
    }

    char_from_room(ch);
    char_to_room(ch, room);
    do_look(ch,"auto");

    if (room == get_room_index(clan->recall_vnum))
    {
        af.where        = TO_AFFECTS;
        af.type         = sn;
        af.level        = level;
        af.duration     = number_range (12, 24);
        af.location     = APPLY_NONE;
        af.modifier     = 0;
        af.bitvector    = 0;
        affect_to_char(ch, &af);
    }
    return;
}

