/* $Id: magic2.c,v 1.666 2004/09/20 10:49:49 shrike Exp $                           */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 /************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/


#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "merc.h"
#include "fight.h"
#include "quest.h"
#include "gquest.h"
#include "rating.h"
#include "fight.h"
#include "cyborg.h"
#include "skills.h"
#include "conquer.h"
#include "wanderers.h"

/* command procedures needed */
DECLARE_DO_FUN(do_scan2     );
DECLARE_DO_FUN(do_look      );
DECLARE_DO_FUN(do_yell      );
DECLARE_DO_FUN(do_say       );
DECLARE_DO_FUN(do_murder    );
DECLARE_DO_FUN(do_kill      );
DECLARE_DO_FUN(do_wear      );

int find_door   (CHAR_DATA *ch, char *arg);

extern bool check_spellbane(CHAR_DATA *ch, CHAR_DATA *victim, int sn);
extern const char *target_name;
extern int levelup_pet_count (CHAR_DATA * ch);

bool check_disintegrate(CHAR_DATA *ch, OBJ_DATA *obj, int level, int sn, CHAR_DATA *victim)
{
    int chance;

    chance = get_skill(ch, sn);
    chance /= 4;
    if (IS_OBJ_STAT(obj, ITEM_NOPURGE)
    || IS_OBJ_STAT(obj, ITEM_QUEST)
    || IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE)
    || obj->wear_loc == WEAR_TATTOO
    || obj->wear_loc == WEAR_CLANMARK 
    || obj->level > level * 3 / 2
    || obj->pIndexData->limit != -1
    || check_material(obj, "unique"))
    {
        if (victim == NULL)
            act("You can't disintegrate $p.", ch, obj, NULL, TO_CHAR);
        return FALSE;
    }

    if (IS_OBJ_STAT(obj, ITEM_BURN_PROOF))
       chance /= 2;
    if (IS_OBJ_STAT(obj, ITEM_BLESS))
       chance -= 25;

    chance += (level - obj->level);

    if (number_percent() >= chance)
    {
        if (victim == NULL)
            act("$p resists your attempts to disintegrate it.",
                ch, obj, NULL, TO_CHAR);
        return FALSE;
    }      
    
    act("You dissolve $p into atoms.", ch, obj, victim, TO_CHAR);
    if (victim != NULL)
    {
        act("$n dissolves your $p into atoms.", ch, obj, victim, TO_VICT);  
        act("$n dissolves $N's $p into atoms.", ch, obj, victim, TO_ROOM);  
    }
    extract_obj_raw(obj, X_F_NORECURSE);
    return TRUE;
}

SPELL_FUN(spell_disintegrate)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    OBJ_DATA *obj, *obj_next;
    OBJ_DATA *tattoo, *clanmark;
    ROOM_INDEX_DATA *pRoom;
    int dam=0;
    bool instant_decay;

    if (target == TARGET_OBJ)
    {
        obj = (OBJ_DATA *) vo;
        check_disintegrate(ch, obj, level, sn, NULL);
        return;
    }

    if (IS_IMMORTAL(victim))
        return;

    if ((tattoo = get_eq_char(victim, WEAR_TATTOO)) != NULL)
        obj_from_char(tattoo);

    if ((clanmark = get_eq_char(victim, WEAR_CLANMARK)) != NULL)
        obj_from_char(clanmark);

    // check for disintegration of victim's equipment
    for (obj = victim->carrying; obj != NULL; obj = obj_next)
    {
        obj_next = obj->next_content;
        if (!saves_spell(level, victim, DAM_ENERGY)
        && number_bits(9) == 0)
            check_disintegrate(ch, obj, level, sn, victim);
        if (victim == NULL || JUST_KILLED(victim))
            return;
    }

    // check for victim's disintegration
    if ((saves_spell(level, victim, DAM_ENERGY)
    || number_bits(3) != 0
    || IS_CLAN_GUARD(victim)
    || IS_SET(victim->abilities, EA_IMMUN_INSTANT))
    && !IS_IMMORTAL(ch))
    {
        dam = dice(level, 24) ;
        damage(ch, victim, dam, sn, DAM_ENERGY, TRUE);
        if (tattoo != NULL)
        {
            obj_to_char(tattoo, victim);
            equip_char(victim, tattoo, WEAR_TATTOO);
        }
        if (clanmark != NULL)
        {
            obj_to_char(clanmark, victim);
            equip_char(victim, clanmark, WEAR_CLANMARK);
        }
        return;
    }

    pRoom = victim->in_room;
    if (pRoom == NULL)
        pRoom = ch->in_room;

    // ok, so now, when we know, that victim will die
    // let's disintegrate more of it's equipment
    for (obj = victim->carrying; obj != NULL; obj = obj_next)
    {
        obj_next = obj->next_content;
        if (!(check_disintegrate(ch, obj, level, sn, victim)))
        {
             obj_from_char(obj);
             obj_to_room(obj, pRoom);
        }
        if (victim == NULL || JUST_KILLED(victim))
            return;
    }

    act(" {W {R{x,    $N #><# {W{x #><# !", victim, NULL, ch, TO_CHAR);
    act(" {W {R{x,    $n #><# {W{x #><# $c6{$N!}", ch, NULL, victim, TO_NOTVICT);
    act(" {W {R{x,    , #><# {W{x #><# $c6{$N!}", ch, NULL, victim, TO_CHAR);
    char_act(".    .", victim);

    act("   $N   !", ch, NULL, victim, TO_CHAR);
    act("   $N   !", ch, NULL, victim, TO_ROOM);

    char_act("           .", victim);
    char_act("       ,         !", victim);

    instant_decay = IS_SET(victim->form, FORM_INSTANT_DECAY);
    SET_BIT(victim->form, FORM_INSTANT_DECAY);

    victim->position = POS_DEAD;
    handle_death(ch, victim);

    if (tattoo != NULL)
    {
        obj_to_char(tattoo, victim);
        equip_char(victim, tattoo, WEAR_TATTOO);
    }
    if (clanmark != NULL)
    {
        obj_to_char(clanmark, victim);
        equip_char(victim, clanmark, WEAR_CLANMARK);
    }

    // maybe victim is still alive (obj_prog)
    if (victim == NULL || JUST_KILLED(victim))
       return;
    if (!instant_decay)
        REMOVE_BIT(victim->form, FORM_INSTANT_DECAY);
}

SPELL_FUN(spell_bark_skin)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            affect_strip(victim, sn);
        else
        {
            act("$N is already as hard as can be.", ch, NULL, victim, TO_CHAR);
            return;
        }
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 6;
    af.location  = APPLY_AC;
    af.modifier  = -(level * 1.5);
    af.bitvector = AFF_PROTECTION;
    affect_to_char(victim, &af);
    act("$n's skin becomes covered in bark.", victim, NULL, NULL, TO_ROOM);
    char_act("Your skin becomes covered in bark.", victim);
}

SPELL_FUN(spell_ranger_staff)
{
    OBJ_DATA *staff;
    AFFECT_DATA tohit;
    AFFECT_DATA todam;

    staff = create_obj(get_obj_index(OBJ_VNUM_RANGER_STAFF),level);
    char_act("You create ranger staff!", ch);
    act("$n creates ranger staff!",ch,NULL,NULL,TO_ROOM);

    staff->value[1] = 4 + level / 10;
    staff->value[2] = 4 + level / 12;

    tohit.where             = TO_OBJECT;
    tohit.type              = sn;
    tohit.level             = ch->level;
    tohit.duration          = -1;
    tohit.location          = APPLY_HITROLL;
    tohit.modifier          = 2 + level/5;
    tohit.bitvector         = 0;
    affect_to_obj(staff,&tohit);

    todam.where             = TO_OBJECT;
    todam.type              = sn;
    todam.level             = ch->level;
    todam.duration          = -1;
    todam.location          = APPLY_DAMROLL;
    todam.modifier          = 2 + level/5;
    todam.bitvector         = 0;
    affect_to_obj(staff,&todam);

//    staff->timer = level;
    staff->timer = UMAX(level, 45);
    staff->level = ch->level;
    staff->owner = str_dup(ch->name);

    obj_to_char(staff,ch);
}

SPELL_FUN(spell_transform)
{
    AFFECT_DATA af;
    char arg[MAX_INPUT_LENGTH];
    int bonus, max;

    if (is_affected(ch,sn))
    {
        act("     !", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    if (!str_cmp(target_name, "mana to health"))
    {
        max = UMIN(IS_NPC(ch) ? ch->max_mana : ch->pcdata->perm_mana, level * 20);
        max = UMIN(max, ch->max_mana);
        bonus = max;
    }
    else if (!str_cmp(target_name, "health to mana"))
    {
        max = UMIN(IS_NPC(ch) ? ch->max_hit : ch->pcdata->perm_hit, level * 20);
        max = UMIN(max, ch->max_hit - 1);
        bonus = - max; 
    }
    else
    {
        bonus = atoi(target_name);
        if (bonus == 0)
        {
            act("It's stupid.", ch, NULL, NULL, TO_CHAR);
            return;
        }
        if (bonus > 0)
        {
            max = UMIN(IS_NPC(ch) ? ch->max_mana : ch->pcdata->perm_mana, level * 20);
            max = UMIN(max, ch->max_mana);
        }
        else
        {
            max = UMIN(IS_NPC(ch) ? ch->max_hit : ch->pcdata->perm_hit, level * 20);
            max = UMIN(max, ch->max_hit - 1);
        }
        if (bonus > 0 && bonus > max)
        {
            snprintf(arg, sizeof(arg), "%d", max);
            act("You can transform only up to $t mana to health.",
                        ch, arg, NULL, TO_CHAR);
            return;
        }
        if (bonus < 0 && bonus < -max)
        {
            snprintf(arg, sizeof(arg), "%d", max);    
            act("You can transform only up to $t health to mana.",
                        ch, arg, NULL, TO_CHAR);
            return;
        }
    }
    
    ch->hit += bonus;
    ch->mana -= bonus;

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = level / 3;;
    af.location     = APPLY_HIT;
    af.modifier     = bonus;
    af.bitvector    = 0;
    affect_to_char(ch, &af);

    af.location     = APPLY_MANA;
    af.modifier     = -bonus;
    affect_to_char(ch, &af);

    af.location  = APPLY_SAVING_SPELL;
    af.modifier  = -10;
    affect_to_char(ch, &af);

    if (bonus > 0)
        act("  ,      .",
            ch, NULL, NULL, TO_CHAR);
    else
        act("  ,      .",
            ch, NULL, NULL, TO_CHAR);
}

SPELL_FUN(spell_demon_summon)
{
    CHAR_DATA *gch;
    CHAR_DATA *demon;
    AFFECT_DATA af;
    int i;

    if (is_affected(ch,sn))
    {
        char_act("You can't find enough power to summon another demon right now.", ch);
        return;
    }

    char_act("  .", ch);
    act("$n  .",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch
        && gch->pIndexData->vnum == MOB_VNUM_DEMON)
        {
            char_act("       !", ch);
            return;
        }
    }

    demon = create_mob(get_mob_index(MOB_VNUM_DEMON));

    for (i=0;i < MAX_STATS; i++)
    {
      demon->perm_stat[i] = ch->perm_stat[i];
    }

    demon->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : URANGE(ch->pcdata->perm_hit,ch->hit,30000);
    demon->hit = demon->max_hit;
    demon->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    demon->mana = demon->max_mana;
    demon->level = ch->level;
    for (i=0; i < 3; i++)
    demon->armor[i] = interpolate(demon->level,100,-100);
    demon->armor[3] = interpolate(demon->level,100,0);
    demon->gold = 0;
    demon->timer = 0;
    demon->damage[DICE_NUMBER] = number_range(level/15, level/10);
    demon->damage[DICE_TYPE] = number_range(level/3, level/2);
    demon->damage[DICE_BONUS] = number_range(level/8, level/6);

    char_to_room(demon,ch->in_room);
    char_act(" ,           !", ch);
    act(" ,           !",ch,NULL,NULL,TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type               = sn;
    af.level              = level;
    af.duration           = 4;
    af.bitvector          = 0;
    af.modifier           = 0;
    af.location           = APPLY_NONE;
    affect_to_char(ch, &af);

    if (JUST_KILLED(demon))
        return;

    if (number_percent() < 40)
    {
      if (can_see(demon, ch))
        do_say(demon, "    ?!");
      else
        do_say(demon, "   ?!");
      do_murder(demon, ch->name);
    }
    else {
    SET_BIT(demon->affected_by, AFF_CHARM);
    demon->master = demon->leader = ch;
    }

}

SPELL_FUN(spell_scourge)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (ch->level < 40)
        dam = dice(level, 6);
    else if (ch->level < 65)
        dam = dice(level, 9);
    else
        dam = dice(level, 12);

    for (vch = ch->in_room->people; vch; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe_spell(ch, vch, TRUE)
        || is_affected(vch, sn))   /* XXX ??? */
            continue;

        if (check_spellbane(ch, vch, sn))
            continue;

        if (number_percent() < level)
            spell_poison(gsn_poison, level, ch, vch, TARGET_CHAR);

        if (number_percent() < level)
            spell_blindness(gsn_blindness,level,ch,vch, TARGET_CHAR);

        if (number_percent() < level)
            spell_weaken(gsn_weaken, level, ch, vch, TARGET_CHAR);

        if (saves_spell(level,vch, DAM_FIRE))
            dam /= 2;
        damage(ch, vch, dam, sn, DAM_FIRE, TRUE);
    }
}


SPELL_FUN(spell_shield_of_ruler)
{
    int shield_vnum;
    OBJ_DATA *shield;
    AFFECT_DATA af;

    if (level >= 71)
        shield_vnum = OBJ_VNUM_RULER_SHIELD4;
    else if (level >= 51)
        shield_vnum = OBJ_VNUM_RULER_SHIELD3;
    else if (level >= 31)
        shield_vnum = OBJ_VNUM_RULER_SHIELD2;
    else
        shield_vnum = OBJ_VNUM_RULER_SHIELD1;

    shield = create_obj(get_obj_index(shield_vnum), ch->level);
    shield->timer = level;
    shield->cost  = 0;
    obj_to_char(shield, ch);

    af.where    = TO_OBJECT;
    af.type     = sn;
    af.level    = level;
    af.duration = -1;
    af.modifier = level / 8;
    af.bitvector    = 0;

    af.location = APPLY_HITROLL;
    affect_to_obj(shield, &af);

    af.location = APPLY_DAMROLL;
    affect_to_obj(shield, &af);

    af.modifier = -level/2;
    af.location = APPLY_AC;
    affect_to_obj(shield, &af);

    af.modifier = UMAX(1, level / 30);
    af.location = APPLY_CHA;
    affect_to_obj(shield, &af);

    act("You create $p!", ch, shield, NULL, TO_CHAR);
    act("$n creates $p!", ch, shield, NULL, TO_ROOM);
}

SPELL_FUN(spell_guard_call)
{
    CHAR_DATA *gch;
    CHAR_DATA *guard;
    CHAR_DATA *guard2;
    AFFECT_DATA af;
    int i;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(ch,sn))
    {
        char_act("          .", ch);
        return;
    }

    do_yell(ch, "! !");

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch)
        {
            do_say(gch, "?      ?");
            return;
        }
    }

    guard = create_mob(get_mob_index(MOB_VNUM_SPECIAL_GUARD));

    for (i=0;i < MAX_STATS; i++)
    guard->perm_stat[i] = ch->perm_stat[i];

    guard->max_hit      = 2*ch->max_hit;
    guard->hit          = guard->max_hit;
    guard->max_mana     = ch->max_mana;
    guard->mana         = guard->max_mana;
    guard->alignment    = ch->alignment;
    guard->level        = LVL(ch);
    for (i=0; i < 3; i++)
    guard->armor[i] = interpolate(guard->level,100,-200);
    guard->armor[3] = interpolate(guard->level,100,-100);
    guard->sex          = ch->sex;
    guard->gold         = 0;
    guard->timer        = 0;

    guard->damage[DICE_NUMBER]  = number_range(level/18, level/14);
    guard->damage[DICE_TYPE]    = number_range(level/4, level/3);
    guard->damage[DICE_BONUS]   = number_range(level/10, level/8);

    guard2 = create_mob(guard->pIndexData);
    clone_mob(guard, guard2);

    SET_BIT(guard->affected_by, AFF_CHARM);
    SET_BIT(guard2->affected_by, AFF_CHARM);
    guard->master = guard2->master = ch;
    guard->leader = guard2->leader = ch;

    char_to_room(guard,ch->in_room);
    char_to_room(guard2,ch->in_room);
    char_act("      !", ch);
    act("      $n!",
        ch, NULL, NULL, TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 12;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

}

SPELL_FUN(spell_ghostdragon)
{
    CHAR_DATA *gch;
    CHAR_DATA *walker;
//    OBJ_DATA *rifle;
//    OBJ_DATA *plate;
    AFFECT_DATA af;
//    AFFECT_DATA af,tohit,todam;
    int i;
    int trooper_count;

    static const int stats[MAX_STATS] = { 23, 17, 15, 20, 20, 19, 14, };
        
    if (is_affected(ch,sn))
    {
        char_act("  ...  ...   ...", ch);
        return;
    }
/*
    if (count_charmed(ch))
        return;
*/
    char_act("  .", ch);
    act("$n  .",ch,NULL,NULL,TO_ROOM);

    trooper_count=0;
    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch
        && gch->pIndexData->vnum == MOB_VNUM_GHOSTDRAGON)
            trooper_count++;
    }
    if (trooper_count >= 2)
    {
        char_act("?   ԣ  !", ch);
        return;
    }

    walker = create_mob(get_mob_index(MOB_VNUM_GHOSTDRAGON));

    for (i=0; i < MAX_STATS; i++)
    walker->mod_stat[i] = walker->perm_stat[i] = stats[i];

    walker->level = LVL(ch) + 1;
    walker->hit = walker->max_hit = walker->level * 100;
    walker->mana = walker->max_mana = walker->level * 2;
    for (i=0; i <= 3; i++)
    walker->armor[i] = -walker->level * 2;

    walker->gold = 0;
    walker->timer = 0;
    walker->damage[DICE_NUMBER] = number_range(3, 5);
    walker->damage[DICE_TYPE]   = number_range(level/12, level/10);
    walker->damage[DICE_BONUS]  = 0;

    walker->hitroll = walker->level/3;
    walker->damroll = walker->level/2 + 5;

    char_to_room(walker,ch->in_room);
    char_act("  .", ch);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 6;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

/*    rifle = create_obj(get_obj_index(OBJ_VNUM_LASER_RIFLE), 0);

    tohit.where     = TO_OBJECT;
    tohit.type      = sn;
    tohit.level     = walker->level;
    tohit.duration  = -1;
    tohit.location  = APPLY_HITROLL;
    tohit.modifier  = walker->level/5;
    tohit.bitvector = 0;
    affect_to_obj(rifle,&tohit);

    todam.where     = TO_OBJECT;
    todam.type      = sn;
    todam.level     = walker->level;
    todam.duration  = -1;
    todam.location  = APPLY_DAMROLL;
    todam.modifier  = walker->level - 10;
    todam.bitvector = 0;
    affect_to_obj(rifle,&todam);

    rifle->level = walker->level;
    obj_to_char(rifle, walker);
    doprintf(interpret, walker, "wield rifle");

    plate = create_obj(get_obj_index(OBJ_VNUM_IMPERIAL_PLATE), 0);
    plate->level = walker->level;
    tohit.where     = TO_OBJECT;
    tohit.type      = sn;
    tohit.level     = walker->level;
    tohit.duration  = -1;
    tohit.location  = APPLY_DAMROLL;
    tohit.modifier  = UMAX(1, (walker->level-50)/4);
    tohit.bitvector = 0;
    affect_to_obj(plate,&tohit);

    obj_to_char(plate, walker);
    doprintf(interpret, walker, "wear plate");
*/
    char_act("     .", ch);
    act("    $c2{$n}!", ch, NULL, NULL, TO_ROOM);

    SET_BIT(walker->affected_by, AFF_CHARM);
    walker->master = walker->leader = ch;
}

SPELL_FUN(spell_eyes_of_intrigue)
{
    CHAR_DATA *victim;
    ROOM_INDEX_DATA *ori_room;
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        char_act("    !", ch);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = IS_IMMORTAL(ch) ? 0 : 4;
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = 0;
    affect_to_char(ch, &af);

    if ((victim = get_char_world(ch, target_name)) == NULL)
    {
        char_act("       .", ch);
        return;
    }

    if (victim->pcdata)
        if (IS_SET(victim->pcdata->wishes, WISH_SHOWSCRY))
            char_act("  -  !", victim);

    if (saves_spell(level, victim, DAM_NONE)
    || is_affected(victim, gsn_stealth))
    {
        char_act("       .", ch);
        return;
    }

    if (ch==victim)
        do_look(ch, str_empty);
    else
    {
        if (!IS_NPC(ch))
            SET_BIT(ch->plr_flags, PLR_GHOST);
        ori_room = ch->in_room;
        char_from_room(ch);
        char_to_room(ch, victim->in_room);
        do_look(ch, str_empty);
        char_from_room(ch);
        char_to_room(ch, ori_room);
        if (!IS_NPC(ch))
            REMOVE_BIT(ch->plr_flags, PLR_GHOST);
    }
}

SPELL_FUN(spell_nightfall)
{
    CHAR_DATA *vch;
    OBJ_DATA  *obj;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("      ,   .",
            ch);
        return;
    }

    for (vch = ch->in_room->people; vch; vch = vch->next_in_room)
    {
        if (is_same_group(ch, vch))
            continue;

        for (obj = vch->carrying; obj; obj = obj->next_content)
        {
            if (obj->pIndexData->item_type != ITEM_LIGHT
            || obj->value[2] == 0
            || saves_spell(level, vch, DAM_ENERGY))
                continue;

            if ((obj->timer > 0)
            || (obj->pIndexData->limit != -1))
                continue;

            act("$p   !", ch, obj, NULL, TO_ALL);
            obj->value[2] = 0;

            if (obj->wear_loc == WEAR_LIGHT
            && ch->in_room->light > 0)
                ch->in_room->light--;
        }
    }

    for (obj = ch->in_room->contents; obj; obj = obj->next_content)
    {
        if (obj->pIndexData->item_type != ITEM_LIGHT
        ||  obj->value[2] == 0)
            continue;

        if ((obj->timer > 0)
        || (obj->pIndexData->limit != -1))
            continue;

        act("$p   !", ch, obj, NULL, TO_ALL);
        obj->value[2] = 0;
    }

    af.where    = TO_AFFECTS;
    af.type     = sn;
    af.level    = level;
    af.duration = 2;
    af.modifier = 0;
    af.location = APPLY_NONE;
    af.bitvector    = 0;
    affect_to_char(ch, &af);
}

SPELL_FUN(spell_garble)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (ch == victim)
    {
        char_act("  ?", ch);
        return;
    }

    if (is_affected(victim,sn))
    {
        act(" $N  .", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (is_safe_nomessage(ch,victim))
    {
        char_act("      .", ch);
        return;
    }

    if (saves_spell(level, victim, DAM_MENTAL))
        return;

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = level/20;
    af.modifier     = 0;
    af.location     = 0;
    af.bitvector    = 0;
    affect_to_char(victim,&af);

    act("   $N!", ch, NULL, victim, TO_CHAR);
    char_act("      .", victim);
}

SPELL_FUN(spell_kassandra)
{
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        char_act("    .", ch);
        return;
    }

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 5;
    af.location     = 0;
    af.modifier     = 0;
    af.bitvector    = 0;
    affect_to_char(ch, &af);
    ch->hit = UMIN(ch->hit + 150, ch->max_hit);
    update_pos(ch);
    char_act("   .", ch);
    act(" $n   .", ch, NULL, NULL, TO_ROOM);
    return;
}

SPELL_FUN(spell_sebat)
{
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        char_act("    !",ch);
        return;
    }
    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = level;
    af.location     = APPLY_AC;
    af.modifier     = -30;
    af.bitvector    = 0;
    affect_to_char(ch, &af);
    act("$n   .", ch, NULL, NULL, TO_ROOM);
    char_act("   .", ch);
    return;
}

SPELL_FUN(spell_matandra)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        char_act("    .", ch);
        return;
    }
    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 5;
    af.location     = 0;
    af.modifier     = 0;
    af.bitvector    = 0;
    affect_to_char(ch, &af);
    dam = dice(level, 7);

    damage(ch, victim, dam, sn, DAM_HOLY, TRUE);
}

SPELL_FUN(spell_chaos_blade)
{
    OBJ_DATA *blade;
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        char_act("       !", ch);
        return;
    }

    blade = create_obj(get_obj_index(OBJ_VNUM_CHAOS_BLADE), level);
    char_act("You create a Chaos Blade!", ch);
    act("$n creates a Chaos Blade!",ch,NULL,NULL,TO_ROOM);

    blade->timer    = level * 2;
    blade->value[1] = ch->level / 6;
    blade->level    = ch->level;

    af.where        = TO_OBJECT;
    af.type         = sn;
    af.level        = level;
    af.duration     = -1;
    af.modifier     = level / 7;
    af.bitvector    = 0;

    af.location     = APPLY_HITROLL;
    affect_to_obj(blade,&af);

    af.location     = APPLY_DAMROLL;
    affect_to_obj(blade,&af);

    obj_to_char(blade,ch);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = ch->level;
    af.duration     = ch->level;
    af.modifier     = 0;
    af.bitvector    = 0;
    af.location     = 0;

    affect_to_char(ch, &af);
}

SPELL_FUN(spell_tattoo)
{
    OBJ_DATA *tattoo;
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int i;

    if (IS_NPC(victim))
    {
        act("$N    !", ch, NULL, victim, TO_CHAR);
        return;
    }

    for (i = 0; i <= religions.nused; i++)
    {
        if (!str_cmp(ch->name, RELIGION(i)->name))
        {
            tattoo = get_eq_char(victim, WEAR_TATTOO);
            if (tattoo != NULL)
            {
                act(" $c1{$N}   !     .",
                    ch, NULL, victim, TO_CHAR);
                act("$n       .",
                    ch, NULL, victim, TO_VICT);
                act("$n   $N    .",
                    ch, NULL, victim, TO_NOTVICT);
                return;
            } else
            {
                tattoo = create_obj(get_obj_index(RELIGION(i)->tattoo_vnum), 0);
                act("    $c1{$N}  $p!",
                    ch, tattoo, victim, TO_CHAR);
                act("$n    $c1{$N}  $p!",
                    ch, tattoo, victim, TO_NOTVICT);
                act("$n      $p!",
                    ch, tattoo, victim, TO_VICT);

                obj_to_char(tattoo,victim);
                equip_char(victim, tattoo, WEAR_TATTOO);
                victim->religion = i;
                return;
            }
        }
    }
    char_act("     .", ch);
    return;
}

SPELL_FUN(spell_remove_tattoo)
{
    OBJ_DATA *tattoo;
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    tattoo = get_eq_char(victim, WEAR_TATTOO);
    if (tattoo != NULL)
    {
        extract_obj(tattoo);
        act("  ,     $c4{$n}.",
            ch, NULL, victim, TO_VICT);
        act("     $N.",
            ch, NULL, victim, TO_CHAR);
        act(" $N     $c5{$n}.",
            ch, NULL, victim, TO_NOTVICT);
        victim->religion = 0;
    }
    else
        act(" $N    .", ch, NULL, victim, TO_CHAR);
}

SPELL_FUN(spell_wrath)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (!IS_NPC(ch) && IS_EVIL(ch))
        victim = ch;

    if (IS_GOOD(victim))
    {
        act("The gods protected $N.", ch, NULL, victim, TO_ROOM);
        return;
    }

    if (IS_NEUTRAL(victim))
    {
        act("$N    .", ch, NULL, victim, TO_CHAR);
        return;
    }

    dam = dice(level, 12);

    if (saves_spell(level, victim, DAM_HOLY))
        dam /= 2;
    damage(ch, victim, dam, sn, DAM_HOLY, TRUE);
    if (JUST_KILLED(victim))
        return;

    if (IS_AFFECTED(victim, AFF_CURSE)
    || saves_spell(level, victim, DAM_HOLY))
        return;

    af.where        = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 5;
    af.location  = APPLY_HITROLL;
    af.modifier  = -1 * (level / 3);
    af.bitvector = AFF_CURSE;
    affect_to_char(victim, &af);

    af.location  = APPLY_SAVING_SPELL;
    af.modifier  = 10;
    affect_to_char(victim, &af);

    char_act("  .", victim);
    if (ch != victim)
        act("$N  .",ch,NULL,victim,TO_CHAR);
}

SPELL_FUN(spell_stalker)
{
    CHAR_DATA *victim;
    CHAR_DATA *stalker;
    AFFECT_DATA af;
    int i;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if ((victim = get_char_world(ch, target_name)) == NULL
    || victim == ch || victim->in_room == NULL
    || IS_NPC(victim) || !IS_SET(victim->plr_flags, PLR_WANTED))
    {
        char_act("  .", ch);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("     .", ch);
        return;
    }

    if (IS_IMMORTAL(ch)
    || ch->pcdata->clan_status == CLAN_LEADER
    || ch->pcdata->clan_status == CLAN_SECOND
    || ch->pcdata->clan_status == CLAN_ELITE
    || ch->pcdata->clan_status == CLAN_VETERAN)
    {
        char_act("  .", ch);
        act("$n  .",ch,NULL,NULL,TO_ROOM);
    
        stalker = create_mob(get_mob_index(MOB_VNUM_STALKER));
    
        af.where        = TO_AFFECTS;
        af.type         = sn;
        af.level        = level;
        af.duration     = IS_IMMORTAL(ch) ? 0 : 5;;
        af.bitvector    = 0;
        af.modifier     = 0;
        af.location     = APPLY_NONE;
        affect_to_char(ch, &af);
    
        for (i=0;i < MAX_STATS; i++)
        {
            stalker->perm_stat[i] = victim->perm_stat[i];
        }
    
        stalker->max_hit = UMIN(30000, 8 * victim->max_hit);
        stalker->hit = stalker->max_hit;
        stalker->max_mana = victim->max_mana;
        stalker->mana = stalker->max_mana;
        stalker->level = victim->level + (level - ch->level) + victim->level / 2;
    
        stalker->damage[DICE_NUMBER] =
            number_range(victim->level/10, victim->level/8);
        stalker->damage[DICE_TYPE] =
            number_range(victim->level/4, victim->level/3);
        stalker->damage[DICE_BONUS] =
            number_range(victim->level, victim->level * 2);
    
        for (i=0; i < 3; i++)
            stalker->armor[i] = interpolate(stalker->level,100,-100);
        stalker->armor[3] = interpolate(stalker->level,100,0);
        stalker->gold = 0;
        stalker->invis_level = LEVEL_HERO + 1;
        stalker->affected_by |= (AFF_DETECT_IMP_INVIS | AFF_DETECT_FADE |
            AFF_DETECT_INVIS | AFF_DETECT_HIDDEN | AFF_DARK_VISION);
    
        char_to_room(stalker,victim->in_room);
        stalker->last_fought = victim;
        char_act("    !", victim);
        act("    $n!",victim,NULL,NULL,TO_ROOM);
        char_act("   . ( ,   !)", ch);
    
        log_printf("%s    %s", ch->name, victim->name);
    } else
    {
        act("   ,     $N.",
            ch, NULL, victim, TO_CHAR);
        return;
    }
}

SPELL_FUN(spell_brew)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    OBJ_DATA *potion;
    OBJ_DATA *vial;
    int spell;

    if (obj->pIndexData->item_type != ITEM_TRASH
    && obj->pIndexData->item_type != ITEM_TREASURE
    && obj->pIndexData->item_type != ITEM_KEY)
    {
        char_act("    .", ch);
        return;
    }

    if (obj->wear_loc != -1)
    {
        char_act("   .", ch);
        return;
    }

    for(vial=ch->carrying; vial != NULL; vial=vial->next_content)
        if (vial->pIndexData->vnum == OBJ_VNUM_POTION_VIAL)
            break;
    if (vial == NULL)
    {
        char_act("       .", ch);
        return;
    }

    if (number_percent() < (30 - get_curr_stat (ch, STAT_LCK)))
    {
        char_act("        .", ch);
        extract_obj(obj);
        return;
    }

    if (obj->pIndexData->item_type == ITEM_TRASH)
        potion = create_obj(get_obj_index(OBJ_VNUM_POTION_SILVER), level);
    else if (obj->pIndexData->item_type == ITEM_TREASURE)
        potion = create_obj(get_obj_index(OBJ_VNUM_POTION_GOLDEN), level);
    else
        potion = create_obj(get_obj_index(OBJ_VNUM_POTION_SWIRLING), level);

    spell = 0;

    potion->value[0] = level + level/5;

     switch (obj->pIndexData->item_type)
     {
     case ITEM_TREASURE:
        switch(number_bits(2))
        {
        case 0:
            spell = sn_lookup("cure poison");
            break;
        case 1:
            spell = sn_lookup("heal");
            break;
        case 2:
            spell = sn_lookup("restore mana");
            break;
        case 3:
            spell = sn_lookup("cure disease");
            break;
        };
        break;
    case ITEM_TRASH:
        switch(number_bits(2))
        {
        case 0:
            spell = sn_lookup("bark skin");
            break;
        case 1:
            spell = sn_lookup("enlarge");
            break;
        case 2:
            spell = gsn_frenzy;
            break;
        case 3:
            spell = sn_lookup("bless");
            break;
        };
        break;
    case ITEM_KEY:
        switch (number_bits(2))
        {
        case 0:
            spell = sn_lookup("pass door");
            break;
        case 1:
            spell = sn_lookup("detect hidden");
            break;
        case 2:
            spell = sn_lookup("acute vision");
            break;
        case 3:
            spell = sn_lookup("improved detect");
            break;
        }
    }
    
    potion->value[1] = spell;
    potion->level = ch->level;
    extract_obj(obj);
    act("  $p   !", ch, potion, NULL, TO_CHAR);
    act("$n  $p   !", ch, potion, NULL, TO_ROOM);

    obj_to_char(potion, ch);
    extract_obj(vial);
}

SPELL_FUN(spell_shadowlife)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    CHAR_DATA *shadow;
    AFFECT_DATA af;
    int i;

    if (IS_NPC(victim))
    {
        char_act(",     ?!?", ch);
        return;
    }

    if (is_safe(ch,victim))
        return;

    if (is_affected(ch,sn))
    {
        char_act("      {D{x.", ch);
        return;
    }

    act("     $N!", ch, NULL, victim, TO_CHAR);
    act("$n     $N!", ch, NULL, victim, TO_NOTVICT);
    act("$n   !", ch, NULL, victim, TO_VICT);

    shadow = create_named_mob(get_mob_index(MOB_VNUM_SHADOW),
                     IS_NPC(victim) ?
                     mlstr_mval(victim->short_descr) :
                     victim->name);
    for (i=0;i < MAX_STATS; i++)
        shadow->perm_stat[i] = ch->perm_stat[i];

    shadow->max_hit = (3 * ch->max_hit) / 4;
    shadow->hit = shadow->max_hit;
    shadow->max_mana = (3 * ch->max_mana) / 4;
    shadow->mana = shadow->max_mana;
    shadow->alignment = ch->alignment;
    shadow->level = ch->level;
    for (i=0; i < 3; i++)
        shadow->armor[i] = interpolate(shadow->level,100,-100);
    shadow->armor[3] = interpolate(shadow->level,100,0);
    shadow->sex = victim->sex;
    shadow->gold = 0;

    char_to_room(shadow,ch->in_room);

    do_murder(shadow, victim->name);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 24;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);
}

SPELL_FUN(spell_ruler_badge)
{
    OBJ_DATA *badge;
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    OBJ_DATA *obj_next;
    AFFECT_DATA af;

    if (get_eq_char(ch, WEAR_NECK_1) != NULL) 
    {
        char_act("     .", ch);
        return;
    }

    for (badge = ch->carrying; badge != NULL; badge = obj_next)
    {
        obj_next = badge->next_content;
        if (badge->pIndexData->vnum == OBJ_VNUM_DEPUTY_BADGE
        || badge->pIndexData->vnum == OBJ_VNUM_RULER_BADGE)
        {
            act("$p disappears.",ch, badge, NULL, TO_CHAR);
            obj_from_char(badge);
            extract_obj(badge);
            continue;
        }
    }

    badge = create_obj(get_obj_index(OBJ_VNUM_RULER_BADGE),level);

    af.where        = TO_OBJECT;
    af.type         = sn;
    af.level        = level;
    af.duration     = -1;
    af.modifier     = level*2;
    af.bitvector    = 0;

    af.location     = APPLY_HIT;
    affect_to_obj(badge,&af);

    af.location     = APPLY_MANA;
    affect_to_obj(badge,&af);

    af.modifier     = - 5;
    af.location     = APPLY_SAVING_SPELL;
    affect_to_obj(badge, &af);

    af.where        = TO_OBJECT;
    af.type         = sn;
    af.level        = level;
    af.duration     = -1;
    af.modifier     = level / 5;
    af.bitvector    = 0;

    af.location     = APPLY_HITROLL;
    affect_to_obj(badge,&af);

    af.location     = APPLY_DAMROLL;
    affect_to_obj(badge,&af);

    badge->timer = level*2;
    act("   !",ch, NULL, NULL, TO_CHAR);
    act("$n   !", ch, NULL, NULL, TO_ROOM);

    obj_to_char(badge,victim);
    if (get_eq_char(ch, WEAR_NECK_1) == NULL)
        equip_char(ch, badge, WEAR_NECK_1);
    else
    {
        char_act("      .", ch);
        return;
    }

}

SPELL_FUN(spell_remove_badge)
{
    OBJ_DATA *badge;
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    OBJ_DATA *obj_next;

    badge = 0;

    for (badge = victim->carrying; badge != NULL; badge = obj_next)
    {
        obj_next = badge->next_content;
        if (badge->pIndexData->vnum == OBJ_VNUM_DEPUTY_BADGE
        || badge->pIndexData->vnum == OBJ_VNUM_RULER_BADGE)
        {
            act("Your $p disappears.",ch, badge, NULL, TO_CHAR);
            act("$n's $p disappears.", ch, badge, NULL, TO_ROOM);

            obj_from_char(badge);
            extract_obj(badge);
            continue;
        }
    }
    return;
}

SPELL_FUN(spell_golden_aura)
{
    AFFECT_DATA af;
    CHAR_DATA *vch = vo;

    for (vch = ch->in_room->people; vch != NULL; vch = vch->next_in_room)
    {
        if (!is_same_group(vch, ch))
            continue;
        if (check_spellbane(ch, vch, sn))
            continue;
        
        if (is_affected(vch, AFF_PROTECT_GOOD))
        {
            if (vch == ch)
                act("You are already protected by {REvil Force{x.",
                                ch, NULL, vch, TO_CHAR);
            else
                act("$N is protected by {REvil Force{x.",
                                ch, NULL, vch, TO_CHAR);
            continue;
        }
        
        if (is_affected(vch, sn) || IS_AFFECTED(vch, AFF_PROTECT_EVIL))
        {
            if (vch == ch)
                char_act("{Y {x   .", ch);
            else
                act("$N     {Y {x.",
                        ch, NULL, vch, TO_CHAR);
            continue;
        }

        af.where      = TO_AFFECTS;
        af.type      = sn;
        af.level   = level;
        af.duration  = 6 + level;
        af.modifier  = 0;
        af.location  = APPLY_NONE;
        af.bitvector = AFF_PROTECT_EVIL;
        affect_to_char(vch, &af);

        af.modifier = level/8;
        af.location = APPLY_HITROLL;
        af.bitvector = 0;
        affect_to_char(vch, &af);

        af.modifier = -10;
        af.location = APPLY_SAVING_SPELL;
        affect_to_char(vch, &af);

        char_act("   {Y {x  .", vch);
        if (ch != vch)
            act("{Y {x  $N.",
                            ch, NULL, vch, TO_CHAR);
    }
}

SPELL_FUN(spell_knightcape)
{
    int plate_vnum;
    OBJ_DATA *plate;
    AFFECT_DATA af;

    plate_vnum = OBJ_VNUM_PLATE;

    plate = create_obj(get_obj_index(plate_vnum), level + 5);
    plate->timer    = 2 * level;
    plate->cost     = 0;
    plate->level    = ch->level;
    plate->owner    = str_dup(ch->name);

    af.where        = TO_OBJECT;
    af.type         = sn;
    af.level        = level;
    af.duration     = -1;
    af.modifier     = level / 4;
    af.bitvector    = 0;

    af.location     = APPLY_HITROLL;
    affect_to_obj(plate,&af);

    af.modifier     = level / 9;
    af.location     = APPLY_DAMROLL;
    affect_to_obj(plate,&af);

    af.modifier     = level;
    af.location     = APPLY_HIT;
    affect_to_obj(plate, &af);

    af.modifier     = level * 2;
    af.location     = APPLY_MANA;
    affect_to_obj(plate, &af);

    af.modifier     = level;
    af.location     = APPLY_MOVE;
    affect_to_obj(plate, &af);

    af.modifier     = 2;
    af.location     = APPLY_STR;
    affect_to_obj(plate, &af);

    af.modifier     = 2;
    af.location     = APPLY_DEX;
    affect_to_obj(plate, &af);

    af.modifier     = 2;
    af.location     = APPLY_SIZE;
    affect_to_obj(plate, &af);

    af.modifier     = - 10;
    af.location     = APPLY_SAVING_SPELL;
    affect_to_obj(plate, &af);

    obj_to_char(plate, ch);

    act("You create $p!", ch, plate, NULL, TO_CHAR);
    act("$n creates $p!", ch, plate, NULL, TO_ROOM);
}

SPELL_FUN(spell_robot)
{
    CHAR_DATA *gch;
    CHAR_DATA *robot;
    AFFECT_DATA af;
    int i;

    if (is_affected(ch,sn))
    {
        char_act("      .", ch);
        return;
    }

    char_act("  .", ch);
    act("$n  .",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch
        && gch->pIndexData->vnum == MOB_VNUM_ROBOT)
        {
            char_act("   !", ch);
            return;
        }
    }

    robot = create_mob(get_mob_index(MOB_VNUM_ROBOT));

    robot->mod_stat[STAT_STR] = robot->perm_stat[STAT_STR] = 14;
    robot->mod_stat[STAT_INT] = robot->perm_stat[STAT_INT] = 22;
    robot->mod_stat[STAT_WIS] = robot->perm_stat[STAT_WIS] = 24;
    robot->mod_stat[STAT_DEX] = robot->perm_stat[STAT_DEX] = 18;
    robot->mod_stat[STAT_CON] = robot->perm_stat[STAT_CON] = 21;
    robot->mod_stat[STAT_CHA] = robot->perm_stat[STAT_CHA] = 16;
    robot->mod_stat[STAT_LCK] = robot->perm_stat[STAT_LCK] = 11;

    robot->size = 4;

    robot->level = ch->level + 3;
    robot->max_hit = robot->level*28 + 3000;
    robot->hit = robot->max_hit;
    robot->max_mana = robot->level*2 + 200;
    robot->mana = robot->max_mana;
    for (i=0; i < 3; i++)
    robot->armor[i] = -4 * robot->level;
    robot->armor[3] = -3 * robot->level;
    robot->saving_throw = - robot->level/2;
    robot->gold = 0;

    robot->damage[DICE_NUMBER] = 5;
    robot->damage[DICE_TYPE] = robot->level/12;
    robot->damage[DICE_BONUS] = 0;

    robot->hitroll = robot->level/2 + 10;
    robot->damroll = robot->level/2 + 25;

    char_to_room(robot,ch->in_room);
    char_act("    !", ch);
    act("    ,   !",
        ch, NULL, NULL, TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 36;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(robot->affected_by, AFF_CHARM);
    robot->master = robot->leader = ch;
}

SPELL_FUN(spell_entangle)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (ch->in_room->sector_type == SECT_INSIDE
    || ch->in_room->sector_type == SECT_CITY
    || ch->in_room->sector_type == SECT_DESERT
    || ch->in_room->sector_type == SECT_AIR)
    {
        char_act("   .", ch);
        return;
    }

    dam = number_range(level, 4 * level);
    if (saves_spell(level, victim, DAM_PIERCE))
        dam /= 2;

    damage(ch, victim, ch->level, gsn_entangle, DAM_PIERCE, TRUE);
    if (JUST_KILLED(victim))
        return;

    act("    $n!",
        victim, NULL, NULL, TO_ROOM);
    act("    ,   !",
        victim, NULL, NULL, TO_CHAR);

    if (saves_spell(level + 2, victim, DAM_PIERCE))
        victim->move -= victim->move / 10;
    else
        victim->move -= victim->move / 3;

    if (!is_affected(victim, gsn_entangle))
    {
        AFFECT_DATA todex;

        todex.type      = gsn_entangle;
        todex.level     = level;
        todex.duration  = level / 10;
        todex.location  = APPLY_DEX;
        todex.modifier  = -5;
        todex.bitvector = 0;
        affect_to_char(victim, &todex);
    }
}

SPELL_FUN(spell_holy_armor)
{
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        char_act("  $gn{}   .", ch);
        return;
    }

    af.where    = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level;
    af.location  = APPLY_AC;
    af.modifier  = - UMAX(10, 10 * (level / 5));
    af.bitvector = 0;
    affect_to_char(ch, &af);

    af.modifier = level/8;
    af.location = APPLY_HITROLL;
    af.bitvector = 0;
    affect_to_char(ch, &af);

    af.modifier = -10;
    af.location = APPLY_SAVING_SPELL;
    affect_to_char(ch, &af);

    act("$n $gn{}   .",ch,NULL,NULL,TO_ROOM);
    char_act(" $gn{}   .", ch);

}

SPELL_FUN(spell_love_potion)
{
    AFFECT_DATA af;

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 50;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

    char_act("       !!!", ch);
}

SPELL_FUN(spell_protective_shield) 
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("    .", ch);
        else
            act("    $N.", ch, NULL, victim, TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = number_fuzzy(level / 30) + 3;
    af.location  = APPLY_AC;
    af.modifier  = 20;
    af.bitvector = 0;
    affect_to_char(victim, &af);
    act("$n   .", victim, NULL, NULL, TO_ROOM);
    char_act("   .", victim);
    return;
}

SPELL_FUN(spell_deafen)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }
/*
    if (ch == victim) {
    char_act(" ?", ch);
    return;
    }
*/
    if (is_affected(victim,sn))
    {
        act("$N  .",ch,NULL,victim,TO_CHAR);
        return;
    }

    if (is_safe_nomessage(ch,victim))
    {
        char_act("     .", ch);
        return;
    }

    if (saves_spell(level, victim, DAM_NONE))
        return;

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 10;
    af.modifier     = 0;
    af.location     = 0;
    af.bitvector    = 0;
    affect_to_char(victim,&af);

    act("  $N!", ch, NULL, victim, TO_CHAR);
    char_act("      ...    !", victim);
}

SPELL_FUN(spell_disperse)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    ROOM_INDEX_DATA *pRoomIndex;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("    .", ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_NORECALL))
    {
        char_act("      .", ch);
        return;
    }

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe(ch, vch)
        || IS_IMMORTAL(vch)
        || IS_RAFFECTED(vch->in_room, RAFF_ESPIRIT)
        || vch == ch)
            continue;

        if (number_percent() > 26 && !IS_IMMORTAL(ch))
        {
            do_yell(vch, "   !");
            agent_net_printf(vch, ch, ANET_ATTACK);
            one_hit(vch, ch, TYPE_HIT, WEAR_WIELD);
            continue;
        }

        if (check_spellbane(ch, vch, sn))
            continue;
    
        if (((IS_NPC(vch)
        && !IS_SET(vch->pIndexData->act, ACT_AGGRESSIVE))
        || !IS_NPC(vch))
        && !is_immune(vch, DAM_SUMMON))
        {
            for (; ;)
            {
                pRoomIndex = get_room_index(number_range(0, 65535));
                if (pRoomIndex != NULL
                && can_see_room(ch, pRoomIndex)
                && !room_is_private(pRoomIndex)
                && !IS_SET(pRoomIndex->area->flags, AREA_UNDER_CONSTRUCTION)
                && !IS_SET(pRoomIndex->room_flags, ROOM_NORECALL)
                && guild_check(vch, pRoomIndex) >= 0)
                    break;
            }

            char_act("   !", vch);
            act("$n disappears suddenly.", vch, NULL, NULL, TO_ROOM);
            char_from_room(vch);
            char_to_room(vch, pRoomIndex);
            act("$n    .", vch, NULL, NULL, TO_ROOM);
            do_look(vch, "auto");
        }
    }
    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 2;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    af.bitvector    = 0;
    affect_to_char(ch, &af);
}

SPELL_FUN(spell_honor_shield)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("     !.", ch);
        else
            char_act("      .", ch);
        return;
    }

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 24;
    af.modifier     = -30;
    af.location     = APPLY_AC;
    af.bitvector    = 0;
    affect_to_char(victim, &af);

    spell_remove_curse(sn_lookup("remove curse"), level, ch, victim, TARGET_CHAR);
    spell_bless(sn_lookup("bless"), level, ch, victim, TARGET_CHAR);

    char_act("   !.", victim);
    act(" $n  $gn{}.", victim, NULL, NULL, TO_ROOM);
}

SPELL_FUN(spell_acute_vision)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_ACUTE_VISION))
    {
        if (victim == ch)
            char_act("      ! ", ch);
        else
            act("$N    .",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = (5 + level / 3);
    af.location     = APPLY_NONE;
    af.modifier     = 0;
    af.bitvector    = AFF_ACUTE_VISION;
    affect_to_char(victim, &af);
    char_act("    !", victim);
    if (ch != victim)
        char_act("Ok.", ch);
    return;
}

SPELL_FUN(spell_dragons_breath)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    CHAR_DATA *vch, *vch_next;
    int dam,hp_dam,dice_dam;
    int hpch;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    act("     !", ch, NULL, NULL, TO_CHAR);
    act("$n    !", ch, NULL, victim, TO_NOTVICT);
    act("  $n  !", ch, NULL, victim, TO_VICT);
    act("    !", ch, NULL, NULL, TO_CHAR);

    hpch = UMAX(10, ch->level * 15);
    hp_dam = number_range(hpch / 9 + 1, hpch / 5);
    dice_dam = dice(level, 20);

    dam = UMAX(hp_dam + dice_dam / 5, dice_dam + hp_dam / 5);

    switch(dice(1, 5)) 
    {
    case 1:
        fire_effect(victim->in_room, level, dam/2, TARGET_ROOM);

        for (vch = victim->in_room->people; vch; vch = vch_next) 
        {
            vch_next = vch->next_in_room;

            if (is_safe_spell(ch, vch, TRUE)
            || (IS_NPC(vch) && IS_NPC(ch) 
            && (ch->fighting != vch || vch->fighting != ch)))
                continue;

        if (vch == victim) 
        { /* full damage */
            if (saves_spell(level, vch, DAM_FIRE))
            {
                fire_effect(vch, level/2, dam/4, TARGET_CHAR);
                damage(ch, vch, dam/2, sn, DAM_FIRE, TRUE);
            } else
            {
                fire_effect(vch, level, dam, TARGET_CHAR);
                damage(ch, vch, dam, sn, DAM_FIRE, TRUE);
            }
        } else /* partial damage */
        {
            if (saves_spell(level - 2,vch,DAM_FIRE))
            {
                fire_effect(vch, level/4, dam/8, TARGET_CHAR);
                damage(ch, vch, dam/4, sn, DAM_FIRE, TRUE);
            } else
            {
                fire_effect(vch, level/2, dam/4, TARGET_CHAR);
                damage(ch, vch, dam/2, sn, DAM_FIRE, TRUE);
            }
        }
    }
    break;

    case 2:
        if (saves_spell(level, victim, DAM_ACID)) 
        {
            acid_effect(victim, level/2, dam/4, TARGET_CHAR);
            damage(ch, victim, dam/2, sn, DAM_ACID,TRUE);
        } else 
        {
            acid_effect(victim, level, dam, TARGET_CHAR);
            damage(ch, victim, dam, sn, DAM_ACID,TRUE);
        }
        break;

    case 3:
        cold_effect(victim->in_room, level, dam/2, TARGET_ROOM);

        for (vch = victim->in_room->people; vch; vch = vch_next) 
        {
            vch_next = vch->next_in_room;

            if (is_safe_spell(ch, vch, TRUE)
            || (IS_NPC(vch) && IS_NPC(ch) 
            && (ch->fighting != vch || vch->fighting != ch)))
                continue;

        if (vch == victim) /* full damage */
        {
            if (saves_spell(level, vch, DAM_COLD))
            {
                cold_effect(vch, level/2, dam/4, TARGET_CHAR);
                damage(ch, vch, dam/2, sn, DAM_COLD, TRUE);
            } else
            {
                cold_effect(vch, level, dam, TARGET_CHAR);
                damage(ch, vch, dam, sn, DAM_COLD, TRUE);
            }
        } else
        {
            if (saves_spell(level - 2,vch,DAM_COLD))
            {
                cold_effect(vch, level/4, dam/8, TARGET_CHAR);
                damage(ch, vch, dam/4, sn, DAM_COLD, TRUE);
            } else
            {
                cold_effect(vch, level/2, dam/4, TARGET_CHAR);
                damage(ch, vch, dam/2, sn, DAM_COLD, TRUE);
            }
        }
    }
    break;
    case 4:
        poison_effect(ch->in_room, level, dam, TARGET_ROOM);

        for (vch = ch->in_room->people; vch; vch = vch_next) 
        {
            vch_next = vch->next_in_room;

            if (is_safe_spell(ch,vch,TRUE)
            || (IS_NPC(ch) && IS_NPC(vch)
            && (ch->fighting == vch || vch->fighting == ch)))
                continue;

            if (saves_spell(level, vch, DAM_POISON))
            {
                poison_effect(vch, level/2, dam/4, TARGET_CHAR);
                damage(ch, vch, dam/2, sn, DAM_POISON, TRUE);
            } else
            {
                poison_effect(vch, level, dam, TARGET_CHAR);
                damage(ch, vch, dam, sn, DAM_POISON, TRUE);
            }
        }
    break;
    case 5:
        if (saves_spell(level, victim, DAM_LIGHTNING)) 
        {
            shock_effect(victim, level/2, dam/4, TARGET_CHAR);
            damage(ch, victim, dam/2, sn, DAM_LIGHTNING, TRUE);
        } else 
        {
            shock_effect(victim, level, dam, TARGET_CHAR);
            damage(ch, victim, dam, sn, DAM_LIGHTNING, TRUE);
        }
        break;
    }
}

SPELL_FUN(spell_sand_storm)
 {
    CHAR_DATA *vch, *vch_next;
    int dam, hp_dam, dice_dam;
    int hpch;

    if ((ch->in_room->sector_type == SECT_AIR)
    || (ch->in_room->sector_type == SECT_WATER_SWIM)
    || (ch->in_room->sector_type == SECT_WATER_NOSWIM))
    {
        char_act("   ,  .  .", ch);
        ch->wait = 0;
        return;
    }

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    act("$n   .",ch,NULL,NULL,TO_ROOM);
    act("  {y !!!!!!!{x",ch,NULL,NULL,TO_CHAR);

    hpch = UMAX(10, ch->hit);
    hp_dam  = number_range(hpch/9+1, hpch/5);
    dice_dam = dice(level,20);

    dam = UMAX(hp_dam + dice_dam /10, dice_dam + hp_dam / 10);
    sand_effect(ch->in_room,level,dam/2,TARGET_ROOM);

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe_spell(ch,vch,TRUE)
        || (IS_NPC(vch) && IS_NPC(ch)
        && (ch->fighting != vch /*|| vch->fighting != ch*/)))
            continue;

        if (saves_spell(level, vch, DAM_COLD))
        {
            sand_effect(vch, level/2, dam/4, TARGET_CHAR);
            damage(ch, vch, dam/2, sn, DAM_COLD, TRUE);
        } else
        {
            sand_effect(vch, level, dam, TARGET_CHAR);
            damage(ch, vch, dam, sn, DAM_COLD, TRUE);
        }
    }
}

SPELL_FUN(spell_scream)
{
    CHAR_DATA *vch, *vch_next;
    int dam=0, hp_dam, dice_dam;
    int hpch;

    act("$n ,   !.", ch, NULL, NULL, TO_ROOM);
    act(" ,   !", ch, NULL, NULL, TO_CHAR);

    hpch = UMAX(300, ch->hit);
    hp_dam  = number_range(hpch / 9 + 1, hpch / 5);
    // GM : was - 20
    dice_dam = dice(level, 50);
    dam = UMAX(hp_dam + dice_dam / 10 , dice_dam + hp_dam / 10);

    scream_effect(ch->in_room, level, dam / 2, TARGET_ROOM);

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;
    
        if (is_safe_spell(ch, vch, TRUE))
            continue;

        if (check_spellbane(ch, vch, sn))
            continue;

        if (saves_spell(level, vch, DAM_SOUND))
        {
            scream_effect(vch, level / 2, dam / 4, TARGET_CHAR);
            if (vch->fighting)
                stop_fighting(vch , TRUE);
        } else
        {
            scream_effect(vch, level, dam, TARGET_CHAR);
            if (vch->fighting)  
                stop_fighting(vch , TRUE);
        }
    }
}

SPELL_FUN(spell_animate_dead)
{
    CHAR_DATA *victim;
    CHAR_DATA *undead;
    OBJ_DATA *obj, *obj2, *next;
    MOB_INDEX_DATA *pMobIndex, *pMobIndex2;
    AFFECT_DATA af;
    const char *p;
    int i;
    int chance;
    int u_level;

    /* deal with the object case first */
    if (target == TARGET_OBJ) 
    {
        obj = (OBJ_DATA *) vo;

        if (!(obj->pIndexData->item_type == ITEM_CORPSE_NPC
        || obj->pIndexData->item_type == ITEM_CORPSE_PC)) 
        {
            char_act("    !", ch);
            return;
        }

        if (is_affected(ch, sn)) 
        {
            char_act("            .", ch);
            return;
        }

        if (count_charmed(ch))
            return;

        if (ch->in_room != NULL
        &&  IS_SET(ch->in_room->room_flags, ROOM_NOMOB)) 
        {
            char_act("     .", ch);
            return;
        }

        if (!can_loot(ch, obj)) 
        {
            char_act("You can't do it.", ch);
            return;
        }

        if (IS_SET(ch->in_room->room_flags,
               ROOM_SAFE | ROOM_PEACE | ROOM_PRIVATE | ROOM_SOLITARY)) 
        {
            char_act("    .", ch);
            return;
        }

        chance = URANGE(5, get_skill(ch, sn)+(level-obj->level)*7, 95);
        if (number_percent() > chance) 
        {
            char_act("        .", ch);
            act("$n   $p,       .",
                ch, obj, NULL, TO_ROOM);
            for (obj2 = obj->contains; obj2; obj2 = next) 
            {
                next = obj2->next_content;
                obj_from_obj(obj2);
                obj_to_room(obj2, ch->in_room);
            }
            extract_obj(obj);
            return;
        }

        p = mlstr_mval(obj->short_descr);
        if (!str_prefix(" ", p))
            p += strlen(" ");

        if (!str_prefix("  ", p))
            p += strlen("  ");

        if (!str_prefix("the corpse of ", p))
            p += strlen("the corpse of ");

        if (!str_prefix("the undead body of ", p))
            p += strlen("the undead body of ");

        pMobIndex = get_mob_index(MOB_VNUM_UNDEAD);
        u_level = UMIN (obj->level, level+((obj->level-level)/3)*2);

        if ((obj->pIndexData->item_type != ITEM_CORPSE_NPC) 
            || number_percent() >= get_skill(ch,gsn_improved_necromancy))
        {
            undead = create_named_mob(pMobIndex, p);
            for (i = 0; i < MAX_STATS; i++)
                undead->perm_stat[i] = UMIN(25, 15+obj->level/10);
            undead->max_hit = dice(20,u_level*2)+u_level*20;
            undead->hit = undead->max_hit;
            undead->max_mana = dice(u_level,10)+100;
            undead->mana = undead->max_mana;
            for (i = 0; i < 3; i++)
                undead->armor[i] = interpolate(undead->level,100,-100);
            undead->armor[3] = interpolate(undead->level, 50, -200);
            undead->sex = ch->sex;
            undead->damage[DICE_NUMBER] = 11;
            undead->damage[DICE_TYPE]   = 5;
            undead->damage[DICE_BONUS]  = u_level/2 +10;
        } 
        else 
        {
            pMobIndex2 = get_mob_index(obj->value[2]);
            if (IS_SET(pMobIndex2->immunes, IMM_MAGIC | IMM_CHARM)
                || IS_SET(pMobIndex2->act, ACT_CLAN_GUARD | ACT_TRAIN     | ACT_PRACTICE | 
                                           ACT_QUESTOR    | ACT_HEALER    | ACT_GAIN |
                                           ACT_CHANGER    | ACT_REPAIRMAN | ACT_FORGER | ACT_RECEIVE_LEVEL))
            {
                act("$p is unaffected by your dark magic.", ch, obj, NULL, TO_CHAR);
                return;
            }
            undead = create_mob_org(pMobIndex2, (B));
            undead->short_descr    = mlstr_printf(pMobIndex->short_descr, p);
            undead->long_descr     = mlstr_printf(pMobIndex->long_descr, p);
            undead->description    = mlstr_printf(pMobIndex->description, p);
            SET_BIT(undead->abilities, EA_SAVE);
        }           

        REMOVE_BIT(undead->affected_by, AFF_SANCTUARY);
        REMOVE_BIT(undead->immunes, IMM_MAGIC | IMM_WEAPON);
        SET_BIT(undead->form, FORM_UNDEAD); 
        undead->alignment = -1000;
        undead->level = u_level;
        undead->gold = 0;
        undead->silver = 0;

        SET_BIT(undead->affected_by, AFF_CHARM);        
        undead->master = ch;
        undead->leader = ch;

        free_string(undead->name);
        undead->name = str_dup(pMobIndex->name);
        undead->name = str_printf(undead->name, obj->owner);

        char_to_room(undead, ch->in_room);
        for (obj2 = obj->contains; obj2; obj2 = next) 
        {
            next = obj2->next_content;
            obj_from_obj(obj2);
            if(!IS_SET(obj2->pIndexData->extra_flags, ITEM_QUEST))
                obj_to_char(obj2, undead);
            else
                obj_to_room(obj2, ch->in_room);
        }

        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = ch->level;
        af.duration  = (ch->level / 10);
        af.modifier  = 0;
        af.bitvector = 0;
        af.location  = APPLY_NONE;
        affect_to_char(ch, &af);

        char_act("    -  ۣ!", ch);
        act("    , $n  $c3{$p}!", 
            ch, obj, NULL, TO_ROOM);

        act_puts("$N   ,        ,  $gn{} $gN{} !", 
            ch, NULL, undead, TO_CHAR, POS_DEAD);

        if (!JUST_KILLED(undead))
            do_wear(undead, "all");

        extract_obj(obj);
        return;
    }

    victim = (CHAR_DATA *) vo;

    if (victim == ch) 
    {
        char_act("    !!", ch);
        return;
    }

    char_act("   !!", ch);
    return;
}

SPELL_FUN(spell_enhanced_armor)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("     .", ch);
        else
            act("$N     .",ch,NULL,victim,TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = 24;
    af.modifier  = -60;
    af.location  = APPLY_AC;
    af.bitvector = 0;
    affect_to_char(victim, &af);
    char_act("   $gn{}   .", victim);
    if (ch != victim)
        act("$N $gN{}  .", ch, NULL, victim, TO_CHAR);
    return;
}

SPELL_FUN(spell_meld_into_stone)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("     .", ch);
        else
            act(" $c1{$N}    .",ch,NULL, victim,TO_CHAR);
        return;
    }
    af.where    = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 10;
    af.location  = APPLY_AC;
    af.modifier  = -100;
    af.bitvector = 0;
    affect_to_char(victim, &af);
    act(" $c1{$n}   .", victim, NULL, NULL, TO_ROOM);
    char_act("    .", victim);
    return;
}

SPELL_FUN(spell_web)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (saves_spell (level, victim, DAM_MAGIC))
    {
        act("You failed to muffle $N in your web.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("    .", ch);
        else
            act("$N    .",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.type      = sn;
    af.level     = level;
    af.duration  = 1;
    af.location  = APPLY_HITROLL;
    af.modifier  = -1 * (level / 6);
    af.where     = TO_AFFECTS;
    af.bitvector = AFF_WEB;
    affect_to_char(victim, &af);

    af.location  = APPLY_DEX;
    af.modifier  = -2;
    affect_to_char(victim, &af);

    af.location  = APPLY_DAMROLL;
    af.modifier  = -1 * (level / 6);
    affect_to_char(victim, &af);
    char_act("   ,   !", victim);
    if (ch != victim)
        act("  $N ,   !", ch, NULL, victim, TO_CHAR);
    return;
}

SPELL_FUN(spell_group_defense)
{
    CHAR_DATA *gch;
    AFFECT_DATA af;
    int shield_sn, armor_sn;

    shield_sn = sn_lookup("shield");
    armor_sn = sn_lookup("armor");

    for(gch=ch->in_room->people; gch != NULL; gch=gch->next_in_room)
    {
        if (!is_same_group(gch, ch))
            continue;
        
        if (check_spellbane(ch, gch, sn))
            continue;
    
        if (is_affected(gch, armor_sn))
        {
            if(gch == ch)
                char_act("   .", ch);
            else
                act("$N    .", ch, NULL, gch, TO_CHAR);
            continue;
        }

        af.type      = armor_sn;
        af.level     = level;
        af.duration  = level;
        af.location  = APPLY_AC;
        af.modifier  = -1 * UMAX(20,10 + level / 4);
        af.bitvector = 0;
        affect_to_char(gch, &af);

        char_act("   -  .", gch);
        if(ch != gch)
            act("$N     .",
                ch, NULL, gch, TO_CHAR);

        if (!is_same_group(gch, ch))
            continue;
        if (is_affected(gch, shield_sn))
        {
            if(gch == ch)
                char_act("    .", ch);
            else
                act("    $N.", ch, NULL, gch, TO_CHAR);
            continue;
        }

        af.type      = shield_sn;
        af.level     = level;
        af.duration  = level;
        af.location  = APPLY_AC;
        af.modifier  = - level/3;
        af.bitvector = 0;
        affect_to_char(gch, &af);

        char_act("   .", gch);
        if(ch != gch)
            act("$N   .",
                ch, NULL, gch, TO_CHAR);
    }
}

SPELL_FUN(spell_inspire)
{
    CHAR_DATA *gch;
    AFFECT_DATA af;
    int bless_sn;

    bless_sn = sn_lookup("bless");

    for(gch=ch->in_room->people; gch != NULL; gch=gch->next_in_room)
    {
        if(!is_same_group(gch, ch))
            continue;
        
        if (check_spellbane(ch, gch, sn))
            continue;

        if (is_affected(gch, bless_sn))
        {
            if(gch == ch)
                char_act("    .", ch);
            else
                act("$N   .", ch, NULL, gch, TO_CHAR);
            continue;
        }

        if (IS_CYBORG(gch))
        {
            act("$N ,     $gN{}.", ch, NULL, gch, TO_CHAR);
            continue;
        }

        af.type      = bless_sn;
        af.level     = level;
        af.duration  = 6 + level;
        af.location  = APPLY_HITROLL;
        af.modifier  = level/12;
        af.bitvector = 0;
        affect_to_char(gch, &af);

        af.location  = APPLY_SAVING_SPELL;
        af.modifier  = -10;
        affect_to_char(gch, &af);

        char_act("  !", gch);
        if(ch != gch)
            act("  $N  !",
                ch, NULL, gch, TO_CHAR);
    }
}

SPELL_FUN(spell_mass_sanctuary)
{
    CHAR_DATA *gch;
    AFFECT_DATA af;
    int sanc_sn;

    sanc_sn = sn_lookup("sanctuary");

    for (gch=ch->in_room->people; gch != NULL; gch=gch->next_in_room)
    {
        if (!is_same_group(gch, ch))
            continue;

        if (check_spellbane(ch, gch, sn))
            continue;
    
        if (HAS_SKILL(gch, gsn_spellbane))
            continue;

        if (IS_AFFECTED(gch, AFF_SANCTUARY)) 
        {
            if(gch == ch)
                char_act("   {W {x.", ch);
            else
                act("{W {x   $N.", ch, NULL, gch, TO_CHAR);
            continue;
        }

        if (IS_AFFECTED(gch, AFF_BLACK_SHROUD)) 
        {
            if (gch == ch)
                char_act("   {D {x!", ch);
            else
                act("{D {x   $n!\n", ch, NULL, gch, TO_CHAR);
                    continue;
        }

        af.where     = TO_AFFECTS;
        af.type      = sanc_sn;
        af.level     = level;
        af.duration  = number_fuzzy(level/6);
        af.location  = APPLY_NONE;
        af.modifier  = 0;
        af.bitvector = AFF_SANCTUARY;
        affect_to_char(gch, &af);

        char_act("  {W {x.", gch);
        if(ch != gch)
            act("$N  {W {x.",
                ch, NULL, gch, TO_CHAR);
    }
}

SPELL_FUN(spell_mend)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    int result,skill;

    if (obj->condition > 99)
    {
        char_act("     .", ch);
        return;
    }

    if (obj->wear_loc != -1)
    {
        char_act("   .", ch);
        return;
    }

    skill = get_skill(ch,gsn_mend) / 2;
    result = number_percent () + skill;

    if (IS_OBJ_STAT(obj,ITEM_GLOW))
        result -= 5;
    if (IS_OBJ_STAT(obj,ITEM_MAGIC))
        result += 5;

    if (result >= 50)
    {
        act("$p       .   !",
            ch, obj, NULL, TO_CHAR);
        act("$p       .",
            ch, obj, NULL, TO_ROOM);
        obj->condition += result;
        obj->condition = UMIN(obj->condition , 100);
        return;
    }

    else if (result >=10)
    {
        char_act("  .", ch);
        return;
    } else
    {
        act("$p  ...  !", ch, obj, NULL, TO_CHAR);
        act("$p  ...  !", ch, obj, NULL, TO_ROOM);
        extract_obj(obj);
        return;
    }
}

SPELL_FUN(spell_shielding)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (saves_spell(level, victim, DAM_NONE)) 
    {
        act("$N  ,    .",
            ch, NULL, victim, TO_CHAR);
        char_act("    ,    .", victim);
        return;
    }

    if (is_affected(victim, sn)) 
    {
        af.type         = sn;
        af.level        = level;
        af.duration     = level / 20;
        af.location     = APPLY_NONE;
        af.modifier     = 0;
        af.bitvector    = 0;
        affect_to_char(victim, &af);
        act("  $N .", ch, NULL, victim, TO_CHAR);
        char_act("       .", victim);
        return;
    }

    af.type         = sn;
    af.level        = level;
    af.duration     = level / 15;
    af.location     = APPLY_NONE;
    af.modifier     = 0;
    af.bitvector    = 0;
    affect_join(victim, &af);

    char_act("       -.", victim);
    act("  $N,     .", ch, NULL, victim, TO_CHAR);
}

SPELL_FUN(spell_link)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int random, tmpmana;

    tmpmana = ch->mana;
    ch->mana = 0;
    ch->move /= 2;
    random = number_range (tmpmana/2, tmpmana);
    victim->mana = victim->mana + random;
}

SPELL_FUN(spell_power_word_kill)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_SET(victim->abilities, EA_IMMUN_INSTANT))
    {
        act("Your spell can't harm $N.", ch, NULL, victim, TO_CHAR);
        return;
    }

    act_puts(" {D{x,    ,  $N.", 
        ch, NULL, victim, TO_CHAR, POS_RESTING);
    act_puts(" {D{x,    $n,  $N.", 
        ch, NULL, victim, TO_NOTVICT, POS_RESTING);
    act_puts(" {D{x,    $N,  .", 
        victim, NULL, ch, TO_CHAR, POS_RESTING);

    if (saves_spell(level, victim, DAM_NEGATIVE)
    || number_bits(1) == 0
    || IS_IMMORTAL(victim)
    || IS_CLAN_GUARD(victim)) 
    {
        dam = dice(level , 24);
        damage(ch, victim , dam , sn, DAM_NEGATIVE, TRUE);
        return;
    }

    char_act("{R !{x", victim);
    act("$N  !\n", ch, NULL, victim, TO_CHAR);
    act("$N  !\n", ch, NULL, victim, TO_ROOM);

    victim->position = POS_DEAD;
    handle_death(ch, victim);

    return;
}

SPELL_FUN(spell_eyed_sword)
{
    OBJ_DATA *eyed;

    eyed        = create_named_obj(get_obj_index(OBJ_VNUM_EYED_SWORD), 0, ch->name);
    eyed->owner = str_dup(ch->name);
    eyed->altar = get_altar(ch);
    eyed->level = ch->level;
    eyed->ed    = ed_new2(eyed->pIndexData->ed, ch->name);
    eyed->value[2] = (ch->level / 10) + 3;
    eyed->level = ch->level;
    eyed->cost  = 0;
    obj_to_char(eyed, ch);
    char_act("  ,  !", ch);
    char_act(" ,        !", ch);
    return;
}

SPELL_FUN(spell_lion_help)
{
    CHAR_DATA *lion;
    CHAR_DATA *victim;
    AFFECT_DATA af;
    char arg[MAX_INPUT_LENGTH];
    int i;

    target_name = one_argument(target_name, arg, sizeof(arg));
    if (arg[0] == '\0') 
    {
        char_act("   ?", ch);
        return;
    }

    if ((victim = get_char_area(ch, arg)) == NULL) 
    {
        char_act("      .", ch);
        return;
    }

    if (is_safe_nomessage(ch, victim)) 
    {
        char_act("The gods protected your victim.", ch);
        return;
    }

    char_act("   .", ch);
    act("$n   .", ch, NULL, NULL, TO_ROOM);

    if (is_affected(ch, sn)) 
    {
        char_act("          .", ch);
        return;
    }

    if (ch->in_room != NULL
    && IS_SET(ch->in_room->room_flags, ROOM_NOMOB)) 
    {
        char_act("   .", ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags,
           ROOM_SAFE | ROOM_PEACE | ROOM_PRIVATE | ROOM_SOLITARY)
    ||  (ch->in_room->exit[0] == NULL &&
         ch->in_room->exit[1] == NULL &&
         ch->in_room->exit[2] == NULL &&
         ch->in_room->exit[3] == NULL &&
         ch->in_room->exit[4] == NULL &&
         ch->in_room->exit[5] == NULL)
    ||  (ch->in_room->sector_type != SECT_FIELD &&
         ch->in_room->sector_type != SECT_FOREST &&
         ch->in_room->sector_type != SECT_MOUNTAIN &&
         ch->in_room->sector_type != SECT_HILLS)) 
    {
        char_act("    .", ch);
        return;
    }

    lion = create_mob(get_mob_index(MOB_VNUM_HUNTER));

    for (i=0;i < MAX_STATS; i++)
        lion->perm_stat[i] = UMIN(25,2 * ch->perm_stat[i]);

    lion->max_hit =  UMIN(30000,ch->max_hit * 1.2);
    lion->hit = lion->max_hit;
    lion->max_mana = ch->max_mana;
    lion->mana = lion->max_mana;
    lion->alignment = ch->alignment;
    lion->level = UMIN(100,ch->level);
    for (i=0; i < 3; i++)
    lion->armor[i] = interpolate(lion->level,100,-100);
    lion->armor[3] = interpolate(lion->level,100,0);
    lion->sex = ch->sex;
    lion->gold = 0;
    lion->damage[DICE_NUMBER] = number_range(level/15, level/10);
    lion->damage[DICE_TYPE] = number_range(level/3, level/2);
    lion->damage[DICE_BONUS] = number_range(level/8, level/6);

    char_to_room(lion, ch->in_room);

    char_act("     !", ch);
    act("     $n!",
        ch, NULL, NULL, TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = ch->level;
    af.duration     = 24;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);
    lion->hunting = victim;
    if (!JUST_KILLED(lion))
        return;
    hunt_victim(lion);
}

SPELL_FUN(spell_magic_jar)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    OBJ_DATA *vial;
    OBJ_DATA *fire;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (victim == ch)
    {
        char_act("     .", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("  - NPC(. 'help NPC')   !.", ch);
        return;
    }

    if IS_SET(victim->plr_flags, PLR_NOSOUL) 
    {
        char_act("    .", ch);
        return;
    }

    if (IS_IMMORTAL(victim))
        return;

    if (saves_spell(level ,victim, DAM_MENTAL))
    {
        char_act("  .", ch);
        return;
    }

    for(vial=ch->carrying; vial != NULL; vial=vial->next_content)
        if (vial->pIndexData->vnum == OBJ_VNUM_POTION_VIAL)
            break;

    if ( vial == NULL)  
    {
        char_act("        ,    Σ   .", ch);
        return;
    }
    extract_obj(vial);

    fire    = create_named_obj(get_obj_index(OBJ_VNUM_MAGIC_JAR), 0, victim->name);
    fire->owner = str_dup(ch->name);
    fire->altar = get_altar(ch);
    fire->level = ch->level;

    fire->ed = ed_new2(fire->pIndexData->ed, victim->name);

    fire->level = ch->level;
    fire->cost = 0;
    obj_to_char(fire , ch);
    SET_BIT(victim->plr_flags, PLR_NOSOUL);
    act("   $N   .", ch, NULL, victim, TO_CHAR);
}

DO_FUN(do_flee);

SPELL_FUN(turn_spell)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam, align;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_EVIL(ch)) 
    {
        victim = ch;
        char_act("   !", ch);
    }

    if (victim != ch) 
    {
        act("$n   ,       !",
            ch, NULL, NULL, TO_ROOM);
        char_act("          !", ch);
    }

    if (IS_GOOD(victim) || IS_NEUTRAL(victim)) 
    {
        act("    $n.",
            victim, NULL, victim, TO_ROOM);
        char_act("      .", victim);
        return;
    }

    dam = dice(level, 10);
    if (saves_spell(level, victim, DAM_HOLY))
        dam /= 2;

    align = victim->alignment;
    align -= 350;

    if (align < -1000)
        align = -1000 + (align + 1000) / 3;

    dam = (dam * align * align) / 1000000;
    damage(ch, victim, dam, sn, DAM_HOLY, TRUE);
    if (!JUST_KILLED(victim))
        do_flee(victim, str_empty);
}

SPELL_FUN(spell_turn)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(ch, sn)) 
    {
        char_act("     .", ch);
        return;
    } 

    af.where    = TO_AFFECTS;
    af.type     = sn;
    af.level    = level;
    af.duration = 5;
    af.modifier = 0;
    af.location = 0;
    af.bitvector    = 0;
    affect_to_char(ch, &af);

    for (vch = ch->in_room->people; vch; vch = vch_next) 
    {
        vch_next = vch->next_in_room;

        if (is_safe_spell(ch, vch, TRUE))
            continue;
        turn_spell(sn, ch->level, ch, vch, target);
    }
}

SPELL_FUN(spell_fear)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_UNDEAD(victim))
    {
        act("$N       $gN{}!",
                ch,NULL,victim,TO_CHAR);
        return;
    }

    if (IS_SAMURAI(victim))
    {
        char_act("    .", ch);
        return;
    }

    if (IS_AFFECTED(victim, AFF_FEAR) || saves_spell(level, victim, DAM_MAGIC))
    return;

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 10;
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = AFF_FEAR;
    affect_to_char(victim, &af);
    char_act("     .", victim);
    act("$n    .",victim,NULL,NULL,TO_ROOM);
    return;
}

SPELL_FUN(spell_protection_heat)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, gsn_protection_heat))
    {
        if (victim == ch)
            char_act("  $gn{}  .", ch);
        else
            act("$N  $gN{}  .",ch,NULL,victim,TO_CHAR);
        return;
    }

    if (is_affected(victim, gsn_protection_cold))
    {
        if (victim == ch)
            char_act("  $gn{}  .", ch);
        else
            act("$N  gN{}  .",ch,NULL,victim,TO_CHAR);
        return;
    }

    if (is_affected(victim, gsn_fire_shield))
    {
        if (victim == ch)
            char_act("   {R {x.", ch);
        else
            act("$N   {R {x.",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = gsn_protection_heat;
    af.level     = level;
    af.duration  = 24;
    af.location  = APPLY_SAVING_SPELL;
    af.modifier  = -5;
    af.bitvector = 0;
    affect_to_char(victim, &af);
    char_act("       .", victim);
    if (ch != victim)
        act(" $N   .", ch, NULL, victim, TO_CHAR);
    return;
}

SPELL_FUN(spell_protection_cold)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, gsn_protection_cold))
    {
        if (victim == ch)
            char_act("  $gn{}  .", ch);
        else
            act("$N  $gN{}  .",ch,NULL,victim,TO_CHAR);
        return;
    }

    if (is_affected(victim, gsn_protection_heat))
    {
        if (victim == ch)
            char_act("  $gn{}  .", ch);
        else
            act("$N  $gN{}  .",ch,NULL,victim,TO_CHAR);
        return;
    }

    if (is_affected(victim, gsn_fire_shield))
    {
        if (victim == ch)
            char_act("   {R {x.", ch);
        else
            act("$N   {R {x.",ch,NULL,victim,TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = gsn_protection_cold;
    af.level     = level;
    af.duration  = 24;
    af.location  = APPLY_SAVING_SPELL;
    af.modifier  = -5;
    af.bitvector = 0;
    affect_to_char(victim, &af);
    char_act(" ,      .", victim);
    if (ch != victim)
        act(" $N   .",ch,NULL,victim,TO_CHAR);
    return;
}

SPELL_FUN(spell_witch_curse)
{
    AFFECT_DATA af;
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(victim, gsn_witch_curse)) 
    {
        char_act("Already.", ch);
        return;
    }

    if (IS_SET(victim->abilities, EA_IMMUN_INSTANT))
    {
        act("Your spell can't harm $N.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (saves_spell(level, victim, DAM_NEGATIVE))
        return;

    if (IS_IMMORTAL(victim)
    || IS_CLAN_GUARD(victim)) 
    {
        damage(ch, victim, dice(level, 8), sn, DAM_NEGATIVE, TRUE);
        return;
    }

    ch->hit -= (2 * level);

    af.where        = TO_AFFECTS;
    af.type         = gsn_witch_curse;
    af.level        = level;
    af.duration     = 24;
    af.location     = APPLY_HIT;
    af.modifier     = - level;
    af.bitvector    = 0;
    affect_to_char(victim, &af);

//  damage(ch, victim, 0, sn, DAM_NONE, FALSE);

    act("$n     .", victim, NULL, NULL, TO_ROOM);
    act("      .", victim, NULL, NULL, TO_CHAR);
}

SPELL_FUN(spell_knock)
{
    char arg[MAX_INPUT_LENGTH];
    int chance=0;
    int door;
    const   int rev_dir     []      =
    {
        2, 3, 0, 1, 5, 4
    };

    target_name = one_argument(target_name, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("      ?", ch);
        return;
    }

    if (ch->fighting)
    {
        char_act("   .", ch);
        return;
    }

    if ((door = find_door(ch, arg)) >= 0)
    {
        ROOM_INDEX_DATA *to_room;
        EXIT_DATA *pexit;
        EXIT_DATA *pexit_rev;

        pexit = ch->in_room->exit[door];
        if (!IS_SET(pexit->exit_info, EX_CLOSED))
        {
            char_act("It's already open.", ch); 
            return; 
        }
        if (!IS_SET(pexit->exit_info, EX_LOCKED))
        { 
            char_act("  .", ch); 
            return; 
        }
        if (IS_SET(pexit->exit_info, EX_NOPASS))
        { 
            char_act("A mystical shield protects exit.", ch);
            return; 
        }
        chance = get_curr_stat(ch, STAT_LCK) + get_skill(ch,sn);

        act("    $d,   $d!",
            ch,NULL,pexit->keyword,TO_CHAR);
        act("$n    $d,   $d!",
            ch,NULL,pexit->keyword,TO_ROOM);

        if (room_dark(ch->in_room))
            chance /= 2;

        /* now the attack */
        if (number_percent() < chance)
        {
            REMOVE_BIT(pexit->exit_info, EX_LOCKED);
            REMOVE_BIT(pexit->exit_info, EX_CLOSED);
            act("$n    $d   .", ch, NULL,
                pexit->keyword, TO_ROOM);
            char_act("   .", ch);

        /* open the other side */
            if ((to_room = pexit->to_room.r) != NULL
            && (pexit_rev = to_room->exit[rev_dir[door]]) != NULL
            && pexit_rev->to_room.r == ch->in_room)
            {
                CHAR_DATA *rch;
    
                REMOVE_BIT(pexit_rev->exit_info, EX_CLOSED);
                REMOVE_BIT(pexit_rev->exit_info, EX_LOCKED);
                for (rch = to_room->people; rch != NULL; rch = rch->next_in_room)
                act("The $d opens.", rch, NULL, pexit_rev->keyword, TO_CHAR);
            }
        } else
        {
            act("You can't knock the $d!",
                ch,NULL,pexit->keyword,TO_CHAR);
            act(" $n    $d.",
                ch,NULL,pexit->keyword,TO_ROOM);
        }
        return;
    }
    char_act("  .", ch);
}

SPELL_FUN(spell_magic_resistance)
{
    AFFECT_DATA af;

    if (!is_affected(ch, sn))
    {
        char_act("    .", ch);

        af.where        = TO_RESIST;
        af.type         = sn;
        af.duration     = level / 10;
        af.level        = ch->level;
        af.bitvector    = DAM_MAGIC;
        af.location     = APPLY_NONE;
        af.modifier     = 20;
        affect_to_char(ch, &af);
    } else
        char_act("     .", ch);
    return;
}

SPELL_FUN(spell_hallucination)
{
    char_act("That spell is under construction.", ch);
    return;
}

SPELL_FUN(spell_wolf_call)
{
    CHAR_DATA *gch;
    CHAR_DATA *demon;
    CHAR_DATA *demon2;
    AFFECT_DATA af;
    int i;

    if (is_affected(ch,sn))
    {
        char_act("         .", ch);
        return;
    }

    char_act("   .", ch);
    act("$n  .",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM)
        && gch->master == ch && gch->pIndexData->vnum == MOB_VNUM_WOLF)
        {
            char_act("    !", ch);
            return;
        }
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM)
        && gch->master == ch && gch->pIndexData->vnum == MOB_VNUM_BEAR)
        {
            char_act("    !", ch);
            return;
        }
    }

    if (ch->in_room != NULL
    && IS_SET(ch->in_room->room_flags, ROOM_NOMOB))
    {
        char_act("   .", ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_SAFE | ROOM_PEACE |
                                        ROOM_PRIVATE | ROOM_SOLITARY)
    || (ch->in_room->exit[0] == NULL && ch->in_room->exit[1] == NULL
    && ch->in_room->exit[2] == NULL && ch->in_room->exit[3] == NULL
    && ch->in_room->exit[4] == NULL && ch->in_room->exit[5] == NULL)
    || (ch->in_room->sector_type != SECT_FIELD
    && ch->in_room->sector_type != SECT_FOREST
    && ch->in_room->sector_type != SECT_MOUNTAIN
    && ch->in_room->sector_type != SECT_HILLS))
    {
            act("  ,    .",
                ch, NULL, NULL, TO_CHAR);
            return;
    }

    demon = create_mob(get_mob_index(MOB_VNUM_WOLF));

    for (i=0;i < MAX_STATS; i++)
    {
        demon->perm_stat[i] = ch->perm_stat[i];
    }

    demon->max_hit = LVL(ch) * 300;
    demon->hit = demon->max_hit;
    demon->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    demon->mana = demon->max_mana;
    demon->level = ch->level;
    for (i=0; i < 3; i++)
        demon->armor[i] = interpolate(demon->level,100,-100);
    demon->armor[3] = interpolate(demon->level,100,0);
    demon->gold = 0;
    demon->timer = 0;
    demon->damage[DICE_NUMBER] = number_range(level/15, level/10);
    demon->damage[DICE_TYPE] = number_range(level/3, level/2);
    demon->damage[DICE_BONUS] = number_range(level/8, level/6);

    char_act("   .", ch);
    act("    .",ch,NULL,NULL,TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 24;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(demon->affected_by, AFF_CHARM);
    demon->master = ch;
    demon->leader = ch;
    char_to_room(demon, ch->in_room);

    if (!is_class_mage(ch))
    {
        demon2 = create_mob(demon->pIndexData);
        clone_mob(demon, demon2);
        SET_BIT(demon2->affected_by, AFF_CHARM);
        demon2->master = ch;
        demon2->leader = ch;
        char_to_room(demon2, ch->in_room);
    }
}

SPELL_FUN(spell_bear_call)
{
    CHAR_DATA *gch;
    CHAR_DATA *demon;
    CHAR_DATA *demon2;
    AFFECT_DATA af;
    int i;

    if (is_affected(ch,sn))
    {
        char_act("         .", ch);
        return;
    }

    char_act("   .", ch);
    act("$n  .",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM)
        && gch->master == ch && gch->pIndexData->vnum == MOB_VNUM_BEAR)
        {
            char_act("    !", ch);
            return;
        }
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM)
        && gch->master == ch && gch->pIndexData->vnum == MOB_VNUM_WOLF)
        {
            char_act("    !", ch);
            return;
        }
    }

    if (ch->in_room != NULL
    && IS_SET(ch->in_room->room_flags, ROOM_NOMOB))
    {
        char_act("   .", ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_SAFE | ROOM_PEACE |
                                        ROOM_PRIVATE | ROOM_SOLITARY)
    || (ch->in_room->exit[0] == NULL && ch->in_room->exit[1] == NULL
    && ch->in_room->exit[2] == NULL && ch->in_room->exit[3] == NULL
    && ch->in_room->exit[4] == NULL && ch->in_room->exit[5] == NULL)
    || (ch->in_room->sector_type != SECT_FIELD
    && ch->in_room->sector_type != SECT_FOREST
    && ch->in_room->sector_type != SECT_MOUNTAIN
    && ch->in_room->sector_type != SECT_HILLS))
    {
            act("  ,    .",
                ch, NULL, NULL, TO_CHAR);
            return;
    }

    demon = create_mob(get_mob_index(MOB_VNUM_BEAR));

    for (i=0;i < MAX_STATS; i++)
    {
        demon->perm_stat[i] = ch->perm_stat[i];
    }

    demon->max_hit = LVL(ch) * 300;
    demon->hit = demon->max_hit;
    demon->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    demon->mana = demon->max_mana;
    demon->level = ch->level;
    for (i=0; i < 3; i++)
        demon->armor[i] = interpolate(demon->level,100,-100);
    demon->armor[3] = interpolate(demon->level,100,0);
    demon->gold = 0;
    demon->timer = 0;
    demon->damage[DICE_NUMBER] = number_range(level/15, level/10);
    demon->damage[DICE_TYPE] = number_range(level/3, level/2);
    demon->damage[DICE_BONUS] = number_range(level/8, level/6);

    char_act("   .", ch);
    act("    .",ch,NULL,NULL,TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 24;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(demon->affected_by, AFF_CHARM);
    demon->master = ch;
    demon->leader = ch;
    char_to_room(demon, ch->in_room);

    if (!is_class_mage(ch))
    {
        demon2 = create_mob(demon->pIndexData);
        clone_mob(demon, demon2);
        SET_BIT(demon2->affected_by, AFF_CHARM);
        demon2->master = ch;
        demon2->leader = ch;
        char_to_room(demon2, ch->in_room);
    }
}

SPELL_FUN(spell_vampiric_blast)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level, 12);
    if (saves_spell(level, victim, DAM_ACID))
        dam /= 2;
    damage(ch, victim, dam, sn,DAM_ACID,TRUE);
    return;
}

SPELL_FUN(spell_mind_light)
{
    AFFECT_DATA af,af2;

    if (is_affected_room(ch->in_room, sn))
    {
        char_act("    .", ch);
        return;
    }

    if (is_affected(ch, sn)) 
    {
        char_act("     !", ch);
        return;
    }

    af.where     = TO_ROOM_CONST;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 30;
    af.location  = APPLY_ROOM_MANA;
    af.modifier  = level;
    af.bitvector = 0;
    affect_to_room(ch->in_room, &af);

    af2.where     = TO_AFFECTS;
    af2.type      = sn;
    af2.level     = level;
    af2.duration  = level / 10;
    af2.modifier  = 0;
    af2.location  = APPLY_NONE;
    af2.bitvector = 0;
    affect_to_char(ch, &af2);
    char_act("   .", ch);
    act("    $n.",ch,NULL,NULL,TO_ROOM);
    return;
}

SPELL_FUN(spell_insanity)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("This spell can cast on PC's only (HELP PC).", ch);
        return;
    }

    if (IS_AFFECTED(victim, AFF_BLOODTHIRST) || saves_spell(level, victim, DAM_MAGIC))
        return;

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 10;
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = AFF_BLOODTHIRST;
    affect_to_char(victim, &af);
    char_act("You are aggressive as a vampire in thirst.", victim);
    act("$n looks with red eyes.",victim,NULL,NULL,TO_ROOM);
    return;
}

SPELL_FUN(spell_power_stun)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(victim,sn) || saves_spell(level, victim,DAM_MAGIC))
    return;

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = 1;
    af.location  = APPLY_DEX;
    af.modifier  = - 3;
    af.bitvector = AFF_STUN;
    affect_to_char(victim, &af);
    char_act(" .", victim);
    act_puts("$n .", victim, NULL, NULL, TO_ROOM, POS_SLEEPING);
    return;
}

SPELL_FUN(spell_improved_invis)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_IMP_INVIS))
        return;

    act("$n   .", victim, NULL, NULL, TO_ROOM);

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 10 ;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_IMP_INVIS;
    affect_to_char(victim, &af);
    char_act("   .", victim);
    return;
}

SPELL_FUN(spell_improved_detect)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_DETECT_IMP_INVIS))
    {
        if (victim == ch)
            char_act("    .", ch);
        else
            act("$N    .",ch,NULL,victim,TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (5 + level / 3);
    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = AFF_DETECT_IMP_INVIS;
    affect_to_char(victim, &af);

    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = AFF_DETECT_INVIS;
    affect_to_char(victim, &af);

    char_act("     .", victim);
    if (ch != victim)
        char_act("Ok.", ch);
    return;
}

SPELL_FUN(spell_severity_force)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = dice(level, 11);

    if (saves_spell(level, victim, DAM_MAGIC))
        dam /= 2;

    act("     $c1{$N}!", ch, NULL, victim, TO_CHAR);
    act("$n     !.", ch, NULL, victim, TO_VICT);
    damage(ch, victim, dam, sn, DAM_NONE, TRUE);
}

SPELL_FUN(spell_randomizer)
{
    AFFECT_DATA af,af2;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("      .", ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_LAW))
    {
        char_act("     .", ch);
        return;
    }
    if (is_affected_room(ch->in_room, sn))
    {
        char_act("      .", ch);
        return;
    }

    if (number_bits(1) == 0)
    {
        char_act("    ,   .", ch);
        af2.where     = TO_AFFECTS;
        af2.type      = sn;
        af2.level     = ch->level;
        af2.duration  = level / 10;
        af2.modifier  = 0;
        af2.location  = APPLY_NONE;
        af2.bitvector = 0;
        affect_to_char(ch, &af2);
        return;
    }

    af.where     = TO_ROOM_AFFECTS;
    af.type      = sn;
    af.level     = ch->level;
    af.duration  = level / 15;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = RAFF_RANDOMIZER;
    affect_to_room(ch->in_room, &af);

    af2.where     = TO_AFFECTS;
    af2.type      = sn;
    af2.level     = ch->level;
    af2.duration  = level / 5;
    af2.modifier  = 0;
    af2.location  = APPLY_NONE;
    af2.bitvector = 0;
    affect_to_char(ch, &af2);
    char_act("    !", ch);
    char_act("      .", ch);
    ch->hit -= UMIN(200, ch->hit/2);
    act("      .", ch, NULL, NULL, TO_ROOM);
    return;
}

SPELL_FUN(spell_bless_weapon)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    AFFECT_DATA af;
    int chance;

    if (obj->pIndexData->item_type != ITEM_WEAPON)
    {
        char_act("  .", ch);
        return;
    }

    if (obj->wear_loc != -1)
    {
        char_act("   .", ch);
        return;
    }

    if (IS_WEAPON_STAT(obj,WEAPON_VAMPIRIC)
    || IS_OBJ_STAT(obj, ITEM_EVIL)
    || IS_OBJ_STAT(obj, ITEM_ANTI_GOOD))
    {
        act("    $p.", ch, obj, NULL, TO_CHAR);
        return;
    }

    if (IS_WEAPON_STAT(obj, WEAPON_HOLY))
    {
        act("$p     .", ch, obj, NULL, TO_CHAR);
        return;
    }

     chance = get_skill(ch, sn);
     if (IS_WEAPON_STAT(obj,WEAPON_FLAMING))
        chance -= 20;
     if (IS_WEAPON_STAT(obj,WEAPON_FROST))
        chance -= 20;
     if (IS_WEAPON_STAT(obj,WEAPON_SHOCKING))
        chance -= 20;
     if (IS_WEAPON_STAT(obj,WEAPON_SHARP))
        chance -= 15;
     if (IS_WEAPON_STAT(obj,WEAPON_VORPAL))
        chance -= 15;
     chance = URANGE(5, chance, 100);

     if (number_percent() >= chance)
     {
        act("     $p.", ch, obj, NULL, TO_CHAR);
        return;
     }

    af.where        = TO_WEAPON;
    af.type         = sn;
    af.level        = level / 2;
    af.duration     = level/8;
    af.location     = 0;
    af.modifier     = 0;
    af.bitvector    = WEAPON_HOLY;
    affect_to_obj(obj,&af);

    act("$p    .", ch, obj, NULL, TO_ALL);
    return;
}

SPELL_FUN(spell_resilience)
{
    AFFECT_DATA af;

    if (!is_affected(ch, sn))
    {
        char_act("     .", ch);

        af.where      = TO_RESIST;
        af.type       = sn;
        af.duration   = level / 10;
        af.level      = ch->level;
        af.bitvector  = DAM_ENERGY;
        af.location   = APPLY_NONE;
        af.modifier   = 40;
        affect_to_char(ch, &af);
    } else
        char_act("  $gn{}   .", ch);
    return;
}

SPELL_FUN(spell_superior_heal)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int bonus = 170 + level + dice(1,20);
    if (CAN_HEAL(ch, victim))
    {
        if (IS_CYBORG(victim) && ch != victim)
        {
            char_act("  .", ch);
            victim->hit = (UMIN(victim->hit + bonus / 2, victim->max_hit));
            update_pos(victim);
        } else
        {
            victim->hit = UMIN(victim->hit + bonus, victim->max_hit);
            update_pos(victim);
        }
        char_act("    .", victim);
        if (ch != victim)
            char_act("Ok.", ch);
    }
    else if(!is_safe(ch,victim))
        damage(ch, victim, bonus, sn, DAM_LIGHT, TRUE);
    return;
}

SPELL_FUN(spell_master_healing)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int bonus = 300 + level + dice(1,40);
    if(CAN_HEAL(ch,victim)) 
    {
        if (IS_CYBORG(victim) && ch != victim) 
        {
            char_act("  .", ch);
            victim->hit = (UMIN(victim->hit + bonus*2/3, victim->max_hit));
            update_pos(victim);
        } else 
        {
            victim->hit = UMIN(victim->hit + bonus, victim->max_hit);
            update_pos(victim);
        }
        char_act("    .", victim);
        if (ch != victim)
            char_act("Ok.", ch);
    }
    else if (!is_safe(ch, victim))
        damage(ch, victim, bonus, sn, DAM_LIGHT, TRUE);
        
    return;
}

SPELL_FUN(spell_group_heal)
{
    CHAR_DATA *gch;
    int heal_sn, refresh_sn;

    heal_sn = sn_lookup("master healing");
    refresh_sn = sn_lookup("refresh");

    if (heal_sn < 0 || refresh_sn < 0)
        return;

    for (gch = ch->in_room->people; gch != NULL; gch = gch->next_in_room) 
    {
        if (is_same_group(ch, gch)) 
        {
            if (CAN_HEAL(ch, gch)) 
            {
                spell_heal(heal_sn, level * 2, ch, gch, TARGET_CHAR);
                spell_refresh(refresh_sn, level / 2, ch, gch, TARGET_CHAR);
            } else if (!is_safe(ch,gch))
                damage(ch, gch, 100, sn, DAM_LIGHT, TRUE);
        }
    }
}

SPELL_FUN(spell_restoring_light)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int nsn, mana_add;
    if (!CAN_HEAL(ch,victim))
    {
        mana_add = URANGE(1, ch->mana/2, ch->hit/2);
        ch->mana -= 2*mana_add;
        if (!is_safe(ch, victim))
            damage(ch, victim, mana_add, sn, DAM_LIGHT, TRUE);
        return;
    }
    if (IS_AFFECTED(victim, AFF_BLIND))
    {
        nsn = sn_lookup("cure blindness");
        spell_cure_blindness(nsn,level,ch,(void *)victim,TARGET_CHAR);
    }
    if (IS_AFFECTED(victim, AFF_CURSE))
    {
        nsn = sn_lookup("remove curse");
        spell_remove_curse(nsn,level,ch,(void *)victim,TARGET_CHAR);
    }
    if (IS_AFFECTED(victim, AFF_POISON))
    {
        spell_cure_poison(gsn_cure_poison,level,ch,(void *)victim,TARGET_CHAR);
    }
    if (IS_AFFECTED(victim, AFF_PLAGUE))
    {
        nsn = sn_lookup("cure disease");
        spell_cure_disease(nsn,level,ch,(void *)victim,TARGET_CHAR);
    }

    if (victim->hit != victim->max_hit)
    {
         mana_add = UMIN((victim->max_hit - victim->hit), ch->mana);
         victim->hit = UMIN(victim->hit + mana_add, victim->max_hit);
         ch->mana -= mana_add;
    }
    update_pos(victim);
    char_act("    .", victim);
    if (ch != victim)
        char_act("Ok.", ch);
    return;
}

SPELL_FUN(spell_lesser_golem)
{
    CHAR_DATA *gch;
    CHAR_DATA *golem;
    AFFECT_DATA af;
    int i=0;

    if (is_affected(ch,sn) || count_charmed(ch) || levelup_pet_count (ch) > 0)
    {
        char_act("You can't find enough power to create a one more golem.", ch);
        return;
    }

    char_act("You try to create a lesser golem.", ch);
    act("$n tries to create a lesser golem.", ch, NULL, NULL, TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch 
        && (gch->pIndexData->vnum == MOB_VNUM_LESSER_GOLEM))
        {
            i++;
            if (i > 2)
            {
                char_act("        !", ch);
                return;
            }
        }
    }

    golem = create_mob(get_mob_index(MOB_VNUM_LESSER_GOLEM));

    for (i = 0; i < MAX_STATS; i ++)
       golem->perm_stat[i] = UMIN(25,15 + ch->level/10);

    golem->perm_stat[STAT_STR] += 3;
    golem->perm_stat[STAT_INT] -= 1;
    golem->perm_stat[STAT_CON] += 2;

    golem->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : UMIN((2 * ch->pcdata->perm_hit) + 400,30000);
    golem->hit = golem->max_hit;
    golem->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    golem->mana = golem->max_mana;
    golem->level = ch->level;
    for (i=0; i < 3; i++)
    golem->armor[i] = interpolate(golem->level,100,-100);
    golem->armor[3] = interpolate(golem->level,100,0);
    golem->gold = 0;
    golem->timer = 0;
    golem->damage[DICE_NUMBER] = 3;
    golem->damage[DICE_TYPE] = 10;
    golem->damage[DICE_BONUS] = ch->level / 2;

    char_to_room(golem,ch->in_room);
    char_act("You create lesser golem.", ch);
    act("$n create lesser golem.",ch,NULL,NULL,TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type               = sn;
    af.level              = level;
    af.duration           = 24;
    af.bitvector          = 0;
    af.modifier           = 0;
    af.location           = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(golem->affected_by, AFF_CHARM);
    golem->master = golem->leader = ch;

}

SPELL_FUN(spell_stone_golem)
{
    CHAR_DATA *gch;
    CHAR_DATA *golem;
    AFFECT_DATA af;
    int i=0;

    if (is_affected(ch,sn) || count_charmed(ch) || levelup_pet_count (ch) > 0)
    {
        char_act("You can't find enough power to create a one more golem.", ch);
        return;
    }

    char_act("You try to create a stone golem.", ch);
    act("$n tries to create a stone golem.",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
      if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch &&
      (gch->pIndexData->vnum == MOB_VNUM_STONE_GOLEM))
    {
      i++;
      if (i > 2)
           {
        char_act("         !", ch);
        return;
       }
    }
    }

    golem = create_mob(get_mob_index(MOB_VNUM_STONE_GOLEM));


    for (i = 0; i < MAX_STATS; i ++)
       golem->perm_stat[i] = UMIN(25,15 + ch->level/10);

    golem->perm_stat[STAT_STR] += 3;
    golem->perm_stat[STAT_INT] -= 1;
    golem->perm_stat[STAT_CON] += 2;

    golem->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : UMIN((5 * ch->pcdata->perm_hit) + 2000, 30000);
    golem->hit = golem->max_hit;
    golem->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    golem->mana = golem->max_mana;
    golem->level = ch->level;
    for (i=0; i < 3; i++)
    golem->armor[i] = interpolate(golem->level,100,-100);
    golem->armor[3] = interpolate(golem->level,100,0);
    golem->gold = 0;
    golem->timer = 0;
    golem->damage[DICE_NUMBER] = 8;
    golem->damage[DICE_TYPE] = 4;
    golem->damage[DICE_BONUS] = ch->level / 2;

    char_to_room(golem,ch->in_room);
    char_act("You create stone golem!", ch);
    act("$n creates stone golem!",ch,NULL,NULL,TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type               = sn;
    af.level              = level;
    af.duration           = 24;
    af.bitvector          = 0;
    af.modifier           = 0;
    af.location           = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(golem->affected_by, AFF_CHARM);
    golem->master = golem->leader = ch;

}


SPELL_FUN(spell_iron_golem)
{
    CHAR_DATA *gch;
    CHAR_DATA *golem;
    AFFECT_DATA af;
    int i = 0;

    if (is_affected(ch,sn) || count_charmed(ch))
//  if (is_affected(ch,sn))
    {
      char_act("You can't find enough power to create a one more golem.", ch);
      return;
    }

    char_act("You try to create a iron golem.", ch);
    act("$n tries to create a iron golem.",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
      if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch &&
      (gch->pIndexData->vnum == MOB_VNUM_IRON_GOLEM))
    {
        char_act(" !", ch);
        return;
    }
    }

    golem = create_mob(get_mob_index(MOB_VNUM_IRON_GOLEM));


    for (i = 0; i < MAX_STATS; i ++)
       golem->perm_stat[i] = UMIN(25,15 + ch->level/10);

    golem->perm_stat[STAT_STR] += 3;
    golem->perm_stat[STAT_INT] -= 1;
    golem->perm_stat[STAT_CON] += 2;

    golem->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : UMIN((10 * ch->pcdata->perm_hit) + 1000, 30000);
    golem->hit = golem->max_hit;
    golem->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    golem->mana = golem->max_mana;
    golem->level = ch->level;
    for (i=0; i < 3; i++)
    golem->armor[i] = interpolate(golem->level,100,-100);
    golem->armor[3] = interpolate(golem->level,100,0);
    golem->gold = 0;
    golem->timer = 0;
    golem->damage[DICE_NUMBER] = 11;
    golem->damage[DICE_TYPE] = 5;
    golem->damage[DICE_BONUS] = ch->level / 2 + 10;

    char_to_room(golem,ch->in_room);
    char_act("You create iron golem!", ch);
    act("$n creates iron golem!",ch,NULL,NULL,TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type               = sn;
    af.level              = level;
    af.duration           = 24;
    af.bitvector          = 0;
    af.modifier           = 0;
    af.location           = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(golem->affected_by, AFF_CHARM);
    golem->master = golem->leader = ch;

}


SPELL_FUN(spell_adamantite_golem)
{
    CHAR_DATA *gch;
    CHAR_DATA *golem;
    AFFECT_DATA af;
    int i = 0;

    if (is_affected(ch,sn) || count_charmed(ch))
//  if (is_affected(ch,sn))
    {
      char_act("You can't find enough power to create a one more golem.", ch);
      return;
    }

    char_act("You try to create a adamantite golem.", ch);
    act("$n tries to create a adamantite golem.",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
      if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch &&
      (gch->pIndexData->vnum == MOB_VNUM_ADAMANTITE_GOLEM))
    {
        char_act(" !", ch);
        return;
    }
    }

    golem = create_mob(get_mob_index(MOB_VNUM_ADAMANTITE_GOLEM));


    for (i = 0; i < MAX_STATS; i ++)
       golem->perm_stat[i] = UMIN(25,15 + ch->level/10);

    golem->perm_stat[STAT_STR] += 3;
    golem->perm_stat[STAT_INT] -= 1;
    golem->perm_stat[STAT_CON] += 2;

    golem->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : UMIN((10 * ch->pcdata->perm_hit) + 4000, 30000);
    golem->hit = golem->max_hit;
    golem->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    golem->mana = golem->max_mana;
    golem->level = ch->level;
    for (i=0; i < 3; i++)
    golem->armor[i] = interpolate(golem->level,100,-100);
    golem->armor[3] = interpolate(golem->level,100,0);
    golem->gold = 0;
    golem->timer = 0;
    golem->damage[DICE_NUMBER] = 13;
    golem->damage[DICE_TYPE] = 9;
    golem->damage[DICE_BONUS] = ch->level / 2 + 10;

    char_to_room(golem,ch->in_room);
    char_act("You create adamantite golem!", ch);
    act("$n creates adamantite golem!",ch,NULL,NULL,TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type               = sn;
    af.level              = level;
    af.duration           = 24;
    af.bitvector          = 0;
    af.modifier           = 0;
    af.location           = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(golem->affected_by, AFF_CHARM);
    golem->master = golem->leader = ch;

}

SPELL_FUN(spell_diamond_golem)
{
    CHAR_DATA *gch;
    CHAR_DATA *golem;
    AFFECT_DATA af;
    int i = 0;

    if (is_affected(ch,sn) || count_charmed(ch))
//  if (is_affected(ch,sn))
    {
      char_act("You can't find enough power to create a one more golem.", ch);
      return;
    }

    char_act("You try to create a dimond golem.", ch);
    act("$n tries to create a dimond golem.",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
      if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch &&
      (gch->pIndexData->vnum == MOB_VNUM_DIAMOND_GOLEM))
    {
        char_act(" !", ch);
        return;
    }
    }

    golem = create_mob(get_mob_index(MOB_VNUM_DIAMOND_GOLEM));


    for (i = 0; i < MAX_STATS; i ++)
       golem->perm_stat[i] = UMIN(25,15 + ch->level/10);

    golem->perm_stat[STAT_STR] += 3;
    golem->perm_stat[STAT_INT] -= 1;
    golem->perm_stat[STAT_CON] += 2;

    golem->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : UMIN((10 * ch->pcdata->perm_hit) + 4000, 30000);
    golem->hit = golem->max_hit;
    golem->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    golem->mana = golem->max_mana;
    golem->level = LVL(ch);
    for (i=0; i < 3; i++)
    golem->armor[i] = interpolate(golem->level,100,-100);
    golem->armor[3] = interpolate(golem->level,100,0);
    golem->gold = 0;
    golem->timer = 0;
    golem->damage[DICE_NUMBER] = 13;
    golem->damage[DICE_TYPE] = 9;
    golem->damage[DICE_BONUS] = LVL(ch) / 2 + 10;

    char_to_room(golem,ch->in_room);
    char_act("You create dimond golem!", ch);
    act("$n creates dimond golem!",ch,NULL,NULL,TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type               = sn;
    af.level              = level;
    af.duration           = 32;
    af.bitvector          = 0;
    af.modifier           = 0;
    af.location           = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(golem->affected_by, AFF_CHARM);
    golem->master = golem->leader = ch;

    if (altar_works (ch, ALTAR_SUMMONING_POS))
    {
        char_act ("Twinkling aura surrounds your golem for a second.", ch);
        golem->level += LEVEL_BONUS;
    }
}

SPELL_FUN(spell_sanctify_lands)
{
    if (number_bits(1) == 0)
    {
      char_act("  .", ch);
      return;
    }

    if (IS_RAFFECTED(ch->in_room,RAFF_CURSE))
    {
     affect_strip_room(ch->in_room,gsn_cursed_lands);
     char_act(",      .", ch);
     act(",      .\n",ch,NULL,NULL,TO_ROOM);
        }
    if (IS_RAFFECTED(ch->in_room,RAFF_POISON))
    {
     affect_strip_room(ch->in_room,gsn_deadly_venom);
     char_act("     .", ch);
     act("     .\n",ch,NULL,NULL,TO_ROOM);
    }
    if (IS_RAFFECTED(ch->in_room,RAFF_SLEEP))
    {
     char_act("    .", ch);
     act("    .\n",ch,NULL,NULL,TO_ROOM);
     affect_strip_room(ch->in_room,gsn_mysterious_dream);
    }
    if (IS_RAFFECTED(ch->in_room,RAFF_PLAGUE))
    {
     char_act(",     .", ch);
     act(",     .\n",ch,NULL,NULL,TO_ROOM);
     affect_strip_room(ch->in_room,gsn_black_death);
    }
    if (IS_RAFFECTED(ch->in_room,RAFF_SLOW))
    {
     char_act("  .", ch);
     act("  .\n",ch,NULL,NULL,TO_ROOM);
     affect_strip_room(ch->in_room,gsn_lethargic_mist);
    }
    return;
}


SPELL_FUN(spell_deadly_venom)
{
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_LAW))
    {
      char_act("      .", ch);
      return;
    }
    if (is_affected_room(ch->in_room, sn))
    {
     char_act("     .", ch);
     return;
    }

    af.where     = TO_ROOM_AFFECTS;
    af.type      = sn;
    af.level     = ch->level;
    af.duration  = level / 15;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = RAFF_POISON;
    affect_to_room(ch->in_room, &af);

    char_act("   .", ch);
    act("   .\n",ch,NULL,NULL,TO_ROOM);

}

SPELL_FUN(spell_cursed_lands)
{
    AFFECT_DATA af;

    if (IS_SET(ch->in_room->room_flags, ROOM_LAW))
    {
      char_act("      .", ch);
      return;
    }
    if (is_affected_room(ch->in_room, sn))
    {
     char_act("   .", ch);
     return;
    }

    af.where     = TO_ROOM_AFFECTS;
    af.type      = sn;
    af.level     = ch->level;
    af.duration  = level / 15;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = RAFF_CURSE;
    affect_to_room(ch->in_room, &af);

    char_act("    .", ch);
    act("    .\n",ch,NULL,NULL,TO_ROOM);

}

SPELL_FUN(spell_lethargic_mist)
{
     AFFECT_DATA af;

    if (IS_SET(ch->in_room->room_flags, ROOM_LAW))
    {
      char_act("      .", ch);
      return;
    }
    if (is_affected_room(ch->in_room, sn))
    {
     char_act("     .", ch);
     return;
    }

    af.where     = TO_ROOM_AFFECTS;
    af.type      = sn;
    af.level     = ch->level;
    af.duration  = level / 15;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = RAFF_SLOW;
    affect_to_room(ch->in_room, &af);

    char_act(",   ,   .", ch);
    act(",   ,   .\n",ch,NULL,NULL,TO_ROOM);

}

SPELL_FUN(spell_black_death)
{
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_LAW))
    {
      char_act("      .", ch);
      return;
    }
    if (is_affected_room(ch->in_room, sn))
    {
     char_act("    .", ch);
     return;
    }

    af.where     = TO_ROOM_AFFECTS;
    af.type      = sn;
    af.level     = ch->level;
    af.duration  = level / 15;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = RAFF_PLAGUE;
    affect_to_room(ch->in_room, &af);

    char_act("    .", ch);
    act("    .\n",ch,NULL,NULL,TO_ROOM);

}

SPELL_FUN(spell_mysterious_dream)
{
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_LAW))
    {
      char_act("      .", ch);
      return;
    }
    if (is_affected_room(ch->in_room, sn))
    {
     char_act("     .", ch);
     return;
    }

    af.where     = TO_ROOM_AFFECTS;
    af.type      = sn;
    af.level     = ch->level;
    af.duration  = level / 15;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = RAFF_SLEEP;
    affect_to_room(ch->in_room, &af);

    char_act("       .", ch);
    act("      .\n",ch,NULL,NULL,TO_ROOM);
}

SPELL_FUN(spell_polymorph)
{
    AFFECT_DATA af ;
    int race ;
    race_t * r ;

    if (is_affected(ch, sn))
    {
        char_act("  .", ch);
        return ;
    }

    if (is_affected(ch, gsn_shrink)
    || is_affected(ch, gsn_enlarge))
    {
        char_act("   .", ch);
        return ;
    }

    if (!target_name[0])
    {
        char_act(": cast 'polymorph' <>.", ch);
        return ;
    }

    race = rn_lookup (target_name) ;
    r = RACE (race) ;

    if (!r->pcdata)
    {
        char_act("     .", ch);
        return ;
    }

    if (str_cmp(r->name, "human")
    && str_cmp(r->name, "half-elf")
    && str_cmp(r->name, "dark-elf")
    && str_cmp(r->name, "rockseer")
    && str_cmp(r->name, "dwarf")
    && str_cmp(r->name, "duergar")
    && str_cmp(r->name, "arial")
    && str_cmp(r->name, "gnome")
    && str_cmp(r->name, "satyr")
    && str_cmp(r->name, "felar")
    && str_cmp(r->name, "githyanki")
    && str_cmp(r->name, "githzerai")
    && str_cmp(r->name, "troll")
    && str_cmp(r->name, "lizard")
    && str_cmp(r->name, "hobbit")
    && str_cmp(r->name, "zombie")
    && str_cmp(r->name, "cyborg")
    && str_cmp(r->name, "android")
    && str_cmp(r->name, "skeleton")
    && str_cmp(r->name, "giant")
    && str_cmp(r->name, "orc")
    && str_cmp(r->name, "illithid"))
    {
        char_act(" , , ?", ch);
        return ;
    }
    // nobody can polymorph to alien
    if (!str_cmp(r->name, "alien"))
    {
        char_act("     .", ch);
        return ;
    }
    // nobody can polymorph to mechanical races
    if (!str_cmp(r->name, "cyborg") || !str_cmp(r->name, "android"))
    {
        char_act("       .", ch);
        return ;
    }

    // only necromancers and undeads can polymorph to undead races
    if (!str_cmp(r->name, "skeleton") || !str_cmp(r->name, "zombie"))
    {
        if (ch->class == CLASS_NECROMANCER || IS_UNDEAD(ch))
        {
            if(!IS_UNDEAD(ch) && number_range(1,50) == 1
            && ch->religion != RELIGION_ASTERN)
            {
                act("$n     .", 
                                    ch, NULL, NULL, TO_ROOM);
                act("         ,    ,     .",
                                ch, NULL, NULL, TO_CHAR);
                ch->position = POS_DEAD;
                handle_death(ch, ch);
                return;             
            }
            af.where     = TO_AFFECTS ;
            af.type      = sn ;
            af.level     = level ;
            af.duration  = level/10 ;
            af.location  = APPLY_RACE ;
            af.modifier  = race ;
            af.bitvector = 0 ;
            affect_to_char (ch, &af) ;

            act("$n      $t.",   ch, r->name, NULL, TO_ROOM) ;
            act("      $t.", ch, r->name, NULL, TO_CHAR) ;
            return ;
        }

        char_act("    -  .", ch);
        return ;
    }

    // necromancers and undeads cannot polymorph to live races
    
    if (ch->class == CLASS_NECROMANCER || IS_UNDEAD(ch))
    {
        char_act("     .", ch);
        return ;
    }
    af.where     = TO_AFFECTS ;
    af.type      = sn ;
    af.level     = level ;
    af.duration  = level/10 ;
    af.location  = APPLY_RACE ;
    af.modifier  = race ;
    af.bitvector = 0 ;
    affect_to_char (ch, &af) ;

    act("$n    $t.", ch, r->name, NULL, TO_ROOM) ;
    act("   $t.",   ch, r->name, NULL, TO_CHAR) ;
}

SPELL_FUN(spell_blade_barrier)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    act("     $n   $N.",
    ch,NULL,victim,TO_ROOM);
    act("        $N.",
    ch,NULL,victim,TO_CHAR);
    act("     $n   !",
    ch,NULL,victim,TO_VICT);

    dam = dice(level,5);
//  dam = number_range(level*10, level*18);
    if (saves_spell(level,victim,DAM_PIERCE))
        dam /= 3;
    damage(ch,victim,dam,sn,DAM_PIERCE,TRUE);

    if (number_percent() < 20) return;

    act("    $n  !",victim,NULL,NULL,TO_ROOM);
    dam = dice(level,6);
    if (saves_spell(level,victim,DAM_PIERCE))
        dam /= 3;
    damage(ch,victim,dam,sn,DAM_PIERCE,TRUE);
    act("      !",victim,NULL,NULL,TO_CHAR);

    if (number_percent() < 50) return;

    act("    $n  !",victim,NULL,NULL,TO_ROOM);
    dam = dice(level,7);
    if (saves_spell(level,victim,DAM_PIERCE))
        dam /= 3;
    damage(ch,victim,dam,sn,DAM_PIERCE,TRUE);
    act("      !",victim,NULL,NULL,TO_CHAR);

    if (number_percent() < 80) return;

    act("    $n  !",victim,NULL,NULL,TO_ROOM);
    dam = dice(level,8);
    if (saves_spell(level,victim,DAM_PIERCE))
        dam /= 3;
    damage(ch,victim,dam,sn,DAM_PIERCE,TRUE);
    act("      !",victim,NULL,NULL,TO_CHAR);
}

SPELL_FUN(spell_protection_negative)
{
    AFFECT_DATA af;

    if (!is_affected(ch, sn))
    {
      char_act("     .", ch);

      af.where = TO_IMMUNE;
      af.type = sn;
      af.duration = level / 4;
      af.level = ch->level;
      af.bitvector = IMM_NEGATIVE;
      af.location = APPLY_NONE;
      af.modifier = 0;
      affect_to_char(ch, &af);
    }
    else
      char_act("     .", ch);
 return;
} 

SPELL_FUN(spell_ruler_aura)
{
    AFFECT_DATA af;

    if (!is_affected(ch, sn))
    {
        char_act("        .", ch);

        af.where    = TO_AFFECTS;
        af.type     = sn;
        af.duration     = level / 4;
        af.level    = ch->level;
        af.bitvector    = 0;
        af.location     = APPLY_HIT;
        af.modifier     = 100*(level/90+1);
        affect_to_char(ch, &af);

        af.modifier     = -10;
        af.location     = APPLY_SAVING_SPELL;
        affect_to_char(ch, &af);

    af.where = TO_IMMUNE;
    af.location = APPLY_NONE;
    af.modifier = 0;
    af.bitvector = IMM_CHARM;
    affect_to_char(ch, &af);
    }
    else
        char_act("        .", ch);
    return;
} 

SPELL_FUN(spell_evil_spirit)
{
 AREA_DATA *pArea = ch->in_room->area;
 ROOM_INDEX_DATA *room;
 AFFECT_DATA af,af2;
 int i;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

 if (IS_RAFFECTED(ch->in_room, RAFF_ESPIRIT)
    || is_affected_room(ch->in_room,sn))
    {
     char_act("    .", ch);
     return;
    }

 if (is_affected(ch, sn))
    {
      char_act("       .", ch);
      return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_LAW)
    || IS_SET(ch->in_room->area->flags, AREA_HOMETOWN))
    {
      char_act("        .", ch);
      return;
    }

    af2.where     = TO_AFFECTS;
    af2.type      = sn;
    af2.level     = ch->level;
    af2.duration  = level / 5;
    af2.modifier  = 0;
    af2.location  = APPLY_NONE;
    af2.bitvector = 0;
    affect_to_char(ch, &af2);

    af.where     = TO_ROOM_AFFECTS;
    af.type      = sn;
    af.level     = ch->level;
    af.duration  = level / 10;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = RAFF_ESPIRIT;

    for (i=pArea->min_vnum; i<pArea->max_vnum; i++)
    {
     if ((room = get_room_index(i)) == NULL) continue;
     affect_to_room(room, &af);
     if (room->people)
    act("    .",room->people,NULL,NULL,TO_ALL);
    }

}


SPELL_FUN(spell_assist)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(ch, sn))
      {
    char_act("    .", ch);
    return;
      }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = IS_UNDEAD(ch) ? 0 : level / 50;
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = 0;
    affect_to_char(ch, &af);

    if (IS_CYBORG(victim) && ch != victim) {
        char_act("  .", ch);
    victim->hit += 100 + level * 2;
    update_pos(victim);
    }
    else {
    victim->hit += 100 + level * 5;
    update_pos(victim);
    }
    char_act("   .", victim);
    act(" $n  .", victim, NULL, NULL, TO_ROOM);
    if (ch != victim)
        char_act("Ok.", ch);
    return;
}

SPELL_FUN(spell_aid)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(ch, sn))
      {
    char_act("    .", ch);
    return;
      }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 50;
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = 0;
    affect_to_char(ch, &af);

    if (IS_CYBORG(victim) && ch != victim) {
        char_act("  .", ch);
    victim->hit += level * 2;
    update_pos(victim);
    }
    else {
    victim->hit += level * 5;
    update_pos(victim);
    }
    char_act("    .", victim);
    act(" $n  .", victim, NULL, NULL, TO_ROOM);
    if (ch != victim)
        char_act("Ok.", ch);
    return;
}

SPELL_FUN(spell_summon_shadow)
{
    CHAR_DATA *gch;
    CHAR_DATA *shadow;
    AFFECT_DATA af;
    int i;

    if (is_affected(ch,sn))
    {
      char_act("           .", ch);
      return;
    }

    char_act("  .", ch);
    act("$n   .",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
      if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch &&
      gch->pIndexData->vnum == MOB_VNUM_SUM_SHADOW)
    {
      char_act("      !", ch);
      return;
    }
    }

    shadow = create_mob(get_mob_index(MOB_VNUM_SUM_SHADOW));

    for (i=0;i < MAX_STATS; i++)
    {
      shadow->perm_stat[i] = ch->perm_stat[i];
    }

    shadow->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : URANGE(ch->pcdata->perm_hit,ch->hit,30000);
    shadow->hit = shadow->max_hit;
    shadow->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    shadow->mana = shadow->max_mana;
    shadow->level = ch->level;
    for (i=0; i < 3; i++)
    shadow->armor[i] = interpolate(shadow->level,100,-100);
    shadow->armor[3] = interpolate(shadow->level,100,0);
    shadow->gold = 0;
    shadow->timer = 0;
    shadow->damage[DICE_NUMBER] = number_range(level/15, level/10);
    shadow->damage[DICE_TYPE] = number_range(level/3, level/2);
    shadow->damage[DICE_BONUS] = number_range(level/8, level/6);

    char_to_room(shadow,ch->in_room);
    act(" !",ch,NULL,NULL,TO_ALL);

    af.where        = TO_AFFECTS;
    af.type               = sn;
    af.level              = level;
    af.duration           = 24;
    af.bitvector          = 0;
    af.modifier           = 0;
    af.location           = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(shadow->affected_by, AFF_CHARM);
    shadow->master = shadow->leader = ch;

}





SPELL_FUN(spell_desert_fist)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if ((ch->in_room->sector_type != SECT_HILLS)
    &&  (ch->in_room->sector_type != SECT_MOUNTAIN)
    &&  (ch->in_room->sector_type != SECT_DESERT)) {
        char_act("           .", ch);
        ch->wait = 0;
        return;
    }

    act("         ,    $n.",
        victim, NULL, NULL, TO_ROOM);
    act("         ,    .",
        victim, NULL, NULL, TO_CHAR);
    dam = dice(level, 14);
    sand_effect(victim, level, dam, TARGET_CHAR);
    damage(ch, victim, dam, sn, DAM_MAGIC, TRUE);
}

SPELL_FUN(spell_mirror)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;
    int mirrors, new_mirrors;
    CHAR_DATA *gch;
    CHAR_DATA *tmp_vict;
    int order;

    if (is_affected(ch, sn)) {
        char_act("    !", ch);
        return;
    }

    if (IS_NPC(victim)) {
        char_act("      .", ch);
        return;
    }

    if (ch->clan != victim->clan) {
        act("        .", ch, NULL, victim, TO_CHAR);
        return;
    }

    for (mirrors = 0, gch = char_list; gch; gch = gch->next)
        if (IS_NPC(gch) && is_affected(gch, gsn_mirror)
            &&  is_affected(gch, gsn_doppelganger)
            && gch->doppel == victim)
        {
            mirrors++;
        }

    if (mirrors >= level/10) {
        if (ch == victim)
            char_act("     .", ch);
        else
            act("$N     .",
                ch, NULL, victim, TO_CHAR);
        return;
    }

    if ( ch == victim && is_affected(ch, gsn_doppelganger) )
    {   char_act("  ,       .", ch);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = 3;
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = 0;
    affect_to_char(ch, &af);

    for (tmp_vict = victim; is_affected(tmp_vict, gsn_doppelganger);
         tmp_vict = tmp_vict->doppel);

    order = number_range(0, level/10- mirrors);

    for (new_mirrors = 0; mirrors + new_mirrors < level/10; new_mirrors++) {
        gch = create_mob(get_mob_index(MOB_VNUM_MIRROR_IMAGE));
        free_string(gch->name);
        mlstr_free(gch->short_descr);
        mlstr_free(gch->long_descr);
        mlstr_free(gch->description);
        gch->name = str_dup(tmp_vict->name);
        gch->short_descr = mlstr_new(tmp_vict->name);
        gch->long_descr = mlstr_printf(gch->pIndexData->long_descr,
                           tmp_vict->name,
                           tmp_vict->pcdata->title);
        gch->description = mlstr_dup(tmp_vict->description);
        gch->sex = tmp_vict->sex;

        af.type = gsn_doppelganger;
        af.duration = level;
        affect_to_char(gch, &af);

        af.type = gsn_mirror;
        af.duration = -1;
        affect_to_char(gch,&af);

        gch->max_hit = gch->hit = 1;
        gch->level = 1;
        gch->doppel = victim;
        gch->master = victim;
        char_to_room(gch, victim->in_room);

        if (new_mirrors == order) {
            char_from_room(victim);
            char_to_room(victim, gch->in_room);
            if (JUST_KILLED(victim))
                break;
        }

        if (ch == victim) {
            char_act("     !", ch);
            act("  $c1{$n}   $gn{}!",
                ch, NULL, victim, TO_ROOM);
        }
        else {
            act(" $c1{$n}   $gn{}!", victim, NULL, NULL, TO_ROOM);
            char_act("    !", victim);
        }
    }
}

SPELL_FUN(spell_doppelganger)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (ch == victim || (is_affected(ch, sn) && ch->doppel == victim)) {
        act("    $gN{}.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (IS_NPC(victim)) 
    {
        act("$N        .",
            ch, NULL, victim, TO_CHAR);
        return;
    }

    if (IS_IMMORTAL(victim)) 
    {
        char_act("Yeah, sure. And I'm the Pope.", ch);
        return;
    }

    if (is_affected(ch, gsn_doppelganger) 
            || is_affected(victim, gsn_doppelganger) )
    {   
        char_act(" .", ch);
        return;
    }

    if (saves_spell(level, victim, DAM_CHARM)) 
    {
        char_act("  .", ch);
        return;
    }

    if (victim->class == CLASS_VAMPIRE) {
        char_act("It is impossible.", ch);
        return;
    }

    act("  ,      $N.", 
                    ch, NULL, victim, TO_CHAR);
    act("$n  ,      !", 
                    ch, NULL, victim, TO_VICT);
    act("$n  ,    $N!", 
                    ch, NULL, victim, TO_NOTVICT);

    af.where    = TO_AFFECTS;
    af.type     = sn;
    af.level    = level;
    af.duration = 2 * level / 3;
    af.location = APPLY_NONE;
    af.modifier = 0;
    af.bitvector    = 0;

    affect_to_char(ch, &af);
    ch->doppel = victim;
}

/*Added by Osya*/
SPELL_FUN(spell_hunger_weapon)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    AFFECT_DATA af;
    int chance = get_skill(ch,sn) ;

    if (obj->pIndexData->item_type != ITEM_WEAPON)
    {
        char_act("  .", ch);
        return;
    }

    if (obj->wear_loc != -1)
    {
        char_act("      .", ch);
        return;
    }

    if (obj->pIndexData->item_type == ITEM_WEAPON)
    {
        if (IS_WEAPON_STAT(obj,WEAPON_HOLY)
        ||  IS_OBJ_STAT(obj,ITEM_BLESS)
        || IS_OBJ_STAT(obj, ITEM_ANTI_EVIL))
        {
            act(" !",ch,NULL,NULL,TO_CHAR);
            act(" !",ch,NULL,NULL,TO_ROOM);
            damage(ch, ch, (ch->hit - 1) > 1000? 1000 : (ch->hit - 1), 
                TYPE_HIT, DAM_HOLY, TRUE);
            return;
        }
        if (IS_WEAPON_STAT(obj, WEAPON_FLAMING))    chance /=2;
        if (IS_WEAPON_STAT(obj, WEAPON_FROST))      chance /=2;
        if (IS_WEAPON_STAT(obj, WEAPON_SHARP))      chance /=2;
        if (IS_WEAPON_STAT(obj, WEAPON_VORPAL))     chance /=2;
        if (IS_WEAPON_STAT(obj, WEAPON_SHOCKING))   chance /=2;
        if (IS_WEAPON_STAT(obj, WEAPON_RADIATION))  chance /=2;
        if (IS_OBJ_STAT(obj, ITEM_EVIL))            chance *= 2;
    }
    if (IS_WEAPON_STAT(obj, WEAPON_VAMPIRIC))
    {
        act("$p    !",ch,obj,NULL,TO_CHAR);
        return;
    }
    if (number_percent() < chance )
    {
        af.where        = TO_WEAPON;
        af.type         = sn;
        af.level        = level / 2;
        af.duration     = level/8;
        af.location     = 0;
        af.modifier     = 0;
        af.bitvector    = WEAPON_VAMPIRIC;
        affect_to_obj(obj, &af);
        SET_BIT(obj->extra_flags, (ITEM_ANTI_GOOD | ITEM_ANTI_NEUTRAL));
        act("   $p   !", ch, obj, NULL, TO_CHAR);
    } else
    {
        act("    .", ch, obj, NULL, TO_CHAR);
    }
    return;
}

SPELL_FUN(spell_plasma_web)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (!saves_spell (level, victim, DAM_MAGIC))
        if (!is_affected(victim, sn))
        {

            af.type     = sn;
            af.level    = level;
            af.duration = 1;
            af.location = APPLY_HITROLL;
            af.modifier = -1 * (level / 6);
            af.where    = TO_AFFECTS;
            af.bitvector    = AFF_WEB;
            affect_to_char(victim, &af);

            af.location = APPLY_DEX;
            af.modifier = -2;
            affect_to_char(victim, &af);

            af.location = APPLY_DAMROLL;
            af.modifier = -1 * (level / 6);
            affect_to_char(victim, &af);

            char_act("   {g{G{g{G{g{G{g {G{g{G{g{x!",
                victim);
            if (ch != victim)
                act("$N   {g{G{g{G{g{G{g {G{g{G{g{x!",
                    ch, NULL, victim, TO_CHAR);
        }

    if (!(IS_AFFECTED(victim, AFF_CORRUPTION)
    || saves_spell(level, victim, DAM_NEGATIVE)
    || IS_UNDEAD(victim)))
    {

        af.type      = sn;
        af.level     = level * 3/4;
        af.duration  = 1;
        af.location  = APPLY_NONE;
        af.modifier  = 0;
        af.bitvector = AFF_CORRUPTION;
        af.where     = TO_AFFECTS;
        affect_join(victim,&af);

        char_act("  {g{G{g{G{g{G{g {G{g{G{g{G{g{x    !",
            victim);
        if (ch != victim)
            act("$N  {g{G{g{G{g{G{g {G{g{G{g{G{g{x    !",
                ch, NULL, victim, TO_CHAR);
    }


    dam = dice(level, 16);
    fire_effect(victim, ch->level/2, dam/2, TARGET_CHAR);

    if (saves_spell(level, victim, DAM_FIRE))
        dam /= 2;
    damage(ch, victim, dam, sn, DAM_FIRE, TRUE);
}

/*end*/
SPELL_FUN(spell_create_golem)
{
    OBJ_DATA *part, *obj_next;
    CHAR_DATA *gch;
    CHAR_DATA *golem;
    AFFECT_DATA af;
    int i = 0, level_mob = 0, counter = 0, damage = 0, hitroll = 0, armor = 0, hp = 0;
    bool legs_ok = FALSE, arms_ok = FALSE; 
    int legs_count = 0, arms_count = 0, heads_count = 0, guts_count = 0;
    int hearts_count = 0, brains_count = 0, mod;

    // temporary while we try to balance this stuff - only NO_PK can create golems /Welesh
/*    if (!IS_SET (ch->comm, PLR_PEACE) && !IS_IMMORTAL (ch))
    {
        char_act("Sorry, you can't create a GOLEM now. You are too cruel to carefully control the process.", ch);
        return;
    }*/

    if (is_affected(ch,sn) || count_charmed(ch))
    {
        char_act("You can't find enough power to create a GOLEM.", ch);
        return;
    }

    char_act("You try to create a GOLEM.", ch);
    act("$n tries to create a GOLEM.",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch
        && (gch->pIndexData->vnum == MOB_VNUM_CREATED_GOLEM))
        {
            char_act("No, no, no! You can't create one more golem.", ch);
            return;
        }
    }

    // check for the legs!
    for (part = ch->carrying ; part != NULL ; part = part->next_content)
    {
        if ((ch->level < LEVEL_HERO) && part->level > (LVL (ch) + LVL (ch)/10))
            continue; 
        if (part->pIndexData->vnum == OBJ_VNUM_SLICED_LEG)
            legs_ok = TRUE; 
        else if (part->pIndexData->vnum == OBJ_VNUM_SLICED_ARM)
            arms_ok = TRUE;
    }

    if (!legs_ok)
    {
        char_act("But without legs your golem can't walk.", ch);
        return;
    }

    if (!arms_ok)
        char_act("Small defect: without arms you golem will be bad fighter.", ch);

    // calculate bonuses for the body parts in the inventory
    // WARNING!! Potential overpower /Welesh
    for (part = ch->carrying ; part != NULL ; part = obj_next)
    {
        obj_next = part->next_content;

        // avoid construction of too tough golems from "gifts"
        if ((ch->level < LEVEL_HERO) &&
            (part->level > (LVL (ch) + LVL (ch)/10)))
            continue;

        switch (part->pIndexData->vnum)
        {
        case OBJ_VNUM_SLICED_LEG:
            counter++;
            legs_count++;
            level_mob   += 1 + part->level/5;

            // modification (/mod) depends on parts' count
            mod = UMAX (1, (legs_count+1)/2 );
            damage      += (10  + 10 * part->level / 45) / mod;
            hitroll     += (10  + 10 * part->level / 45) / mod;
            armor       += (10  + part->level) / mod;
            hp          += (100 + part->level * 25) / mod;

            extract_obj(part);
            break;

        case OBJ_VNUM_SLICED_ARM:
            counter++;
            arms_count++;
            level_mob   += 1 + part->level/5;      

            mod = UMAX (1, (arms_count+1)/2 );
            damage      += (10  + 10 * part->level/25) / mod;
            hitroll     += (10  + 10 * part->level/25) / mod;
            armor       += (10  + 3  * part->level) / mod;
            hp          += (100 + part->level * 25) / mod;

            extract_obj(part);
            break;

        case OBJ_VNUM_TORN_HEART:
            counter++;
            hearts_count++;
            level_mob   += 1 + part->level/5;      

            mod = UMAX (1, (hearts_count+1)/2 );
            armor       += (10  + part->level) / mod;
            hp          += (100 + part->level * 32) / mod;

            extract_obj(part);
            break;

        case OBJ_VNUM_SEVERED_HEAD:
            counter++;
            heads_count++;
            level_mob   += 1 + part->level/5;      

            mod = UMAX (1, (heads_count+1)/2 );
            damage      += 5   + (10 * part->level/90) / mod;
            hitroll     += 10  + (10 * part->level/45) / mod;
            armor       += 10  + part->level / mod;
            hp          += 100 + (part->level * 10) / mod;

            extract_obj(part);
            break;

        case OBJ_VNUM_GUTS:
            counter++;
            guts_count++;
            level_mob   += 1 + part->level/5;      

            mod = UMAX (1, (guts_count+1)/2 );
            damage      += (5   + 10 * part->level/45) / mod;
            hp          += (100 + part->level * 25) / mod;

            extract_obj(part);

            break;

        case OBJ_VNUM_BRAINS:
            counter++;
            brains_count++;
            level_mob   += 1 + part->level/5;      

            mod = UMAX (1, (brains_count+1)/2 );
            hitroll     += (10  + 10 * part->level/90) / mod;
            armor       += (10  + 3 * part->level) / mod;
            hp          += (100 + part->level * 10) / mod;

            extract_obj(part);
            break;
        }
    }

    // create golem
    golem = create_mob(get_mob_index(MOB_VNUM_CREATED_GOLEM));

    for (i = 0; i < MAX_STATS; i ++)
       golem->perm_stat[i] = UMIN(25,15 + ch->level/10);

    golem->perm_stat[STAT_STR] += 3;
    golem->perm_stat[STAT_INT] -= 1;
    golem->perm_stat[STAT_CON] += 2;

    golem->max_hit = IS_NPC(ch)? URANGE(ch->max_hit, hp, 30000)
            : UMIN((hp + ch->pcdata->perm_hit * 2)/10, 5000);
    golem->hit = golem->max_hit;
    golem->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana/3;
    golem->mana = golem->max_mana;

    golem->level = UMIN(level_mob, ch->level);

    for (i=0; i < 3; i++)
        golem->armor[i] = interpolate(golem->level,100,-100) - armor;
    golem->armor[3] = interpolate(golem->level,100,0) - armor/2;

    golem->gold     = 0;
    golem->timer    = 0;

    golem->damage[DICE_NUMBER] = 20;
    golem->damage[DICE_TYPE] = damage / 10;
    golem->damage[DICE_BONUS] = golem->level/15;
    golem->damroll = golem->level/15;

    golem->hitroll  = hitroll / 50;

    if (IS_IMMORTAL (ch))
        char_printf (ch, "So golem's stats: level = %d, damage = %dd%d, damroll = %d, hitroll = %d, hp = %d.\n", 
            golem->level, golem->damage[DICE_NUMBER], golem->damage[DICE_TYPE], 
            golem->damroll, golem->hitroll, golem->hit ); 

    // finally
    char_to_room(golem,ch->in_room);

    char_act("You create MECHANICAL GOLEM!", ch);
    act("$n creates MECHANICAL GOLEM!", ch, NULL, NULL, TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 12;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(golem->affected_by, AFF_CHARM);
    golem->master = golem->leader = ch;
    golem->mob_tnl = golem->level * 15;
}

SPELL_FUN(spell_sectoroid)
{
    CHAR_DATA *gch;
    CHAR_DATA *walker;
    AFFECT_DATA af;
    int i;
    int sectoroid_count;

    if (is_affected(ch,sn))
    {
        char_act("         .", ch);
        return;
    }

    char_act("    .", ch);
    act("$n    .", ch, NULL, NULL, TO_ROOM);

    sectoroid_count=0;
    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch
        && gch->pIndexData->vnum == MOB_VNUM_SECTOROID)
            sectoroid_count++;
    }
    if (sectoroid_count > 0)
    {
        char_act("  ,      -.", ch);
        return;
    }

    walker = create_mob(get_mob_index(MOB_VNUM_SECTOROID));

    walker->level = LVL(ch);
    walker->hit = walker->max_hit = walker->level*75;
    walker->mana = walker->max_mana = walker->level*3 + 100;
    for (i=0; i < 3; i++)
    walker->armor[i] = -walker->level * 8;
    walker->armor[3] = -walker->level * 7;
    walker->timer = 0;
    walker->damage[DICE_NUMBER] = number_range(3, 4);
    walker->damage[DICE_TYPE]   = number_range(level/11, level/9);
    walker->damage[DICE_BONUS]  = 0;

    walker->hitroll = walker->level/3;
    walker->damroll = 4*walker->level/3;

    walker->size = 9;

    char_act("    -.", ch);
    act("     -.", ch, NULL, NULL, TO_ROOM);

    char_to_room(walker,ch->in_room);

    af.where              = TO_AFFECTS;
    af.type               = sn;
    af.level              = level;
    af.duration           = level/2;
    af.bitvector          = 0;
    af.modifier           = 0;
    af.location           = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(walker->affected_by, AFF_CHARM);
    walker->master = walker->leader = ch;
}

