/* $Id: magic3.c,v 1.666 2004/09/20 10:49:50 shrike Exp $                           */ 
 
/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/



#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "merc.h"
#include "fight.h"
#include "quest.h"
#include "gquest.h"
#include "rating.h"
#include "fight.h"
#include "update.h"

DECLARE_DO_FUN(do_yell);
DECLARE_DO_FUN(do_say);
DECLARE_DO_FUN(do_murder);
DECLARE_DO_FUN(do_look);
DECLARE_DO_FUN(do_track);
DECLARE_DO_FUN(do_visible);
DECLARE_DO_FUN(do_human);


extern const char *target_name;
extern bool check_recovery(CHAR_DATA *ch, CHAR_DATA *victim);
extern bool check_jammer(CHAR_DATA *ch);
extern bool check_spellbane(CHAR_DATA *ch, CHAR_DATA *victim, int sn);
extern void show_char_to_char_1     (CHAR_DATA *victim, CHAR_DATA *ch);
extern bool dispel1      (int level, CHAR_DATA *ch, int sn);
extern int levelup_pet_count (CHAR_DATA * ch);

SPELL_FUN(spell_holy_cross)
{
    OBJ_DATA *cross;
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        char_act("You already have a Cross!", ch);
        return;
    }

    cross = create_obj(get_obj_index(OBJ_VNUM_PALADIN_CROSS), level);
    char_act("You create a {WHoly{z {YCross{z!", ch);
    act("$n creates a {WHoly{z {YCross{z!", ch, NULL, NULL, TO_ROOM);
    char_act("You feel exhausted.", ch);

    ch->mana = 0;
    ch->move = 0;

    af.where              = TO_OBJECT;
    af.type               = sn;
    af.level              = ch->level;
    af.duration           = -1;
    af.location           = APPLY_HITROLL;
    af.modifier           = 2 + level / 5;
    af.bitvector          = 0;
    affect_to_obj(cross, &af);

    af.location           = APPLY_DAMROLL;
    af.modifier           = 2 + level / 5;
    affect_to_obj(cross, &af);

    af.location           = APPLY_AC;
    af.modifier           = 0 - 2 * level;
    affect_to_obj(cross, &af);

    af.location           = APPLY_SAVING_SPELL;
    af.modifier           = -5;
    affect_to_obj(cross, &af);

    cross->timer = level << 1;
    cross->level = ch->level;
    cross->owner = str_dup(ch->name);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = level;
    af.modifier     = 0;
    af.bitvector    = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

    obj_to_char(cross, ch);
}

SPELL_FUN(spell_unholy_cross)
{
    OBJ_DATA *cross;
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        char_act("You already have a Cross!", ch);
        return;
    }   

    cross = create_obj(get_obj_index(OBJ_VNUM_APALADIN_CROSS), level);
    char_act("You create a {RSatan{z {DCross{z!", ch);
    act("$n creates a {RSatan{z {DCross{z!", ch, NULL, NULL, TO_ROOM);
    char_act("You feel exhausted.", ch);

    ch->mana = 0;
    ch->move = 0;

    af.where              = TO_OBJECT;
    af.type               = sn;
    af.level              = ch->level;
    af.duration           = -1;
    af.location           = APPLY_HITROLL;
    af.modifier           = 2 + level / 5;
    af.bitvector          = 0;
    affect_to_obj(cross, &af);

    af.location           = APPLY_DAMROLL;
    af.modifier           = 2 + level / 5;
    affect_to_obj(cross, &af);

    af.location           = APPLY_AC;
    af.modifier           = 0 - 2 * level;
    affect_to_obj(cross, &af);

    af.location           = APPLY_SAVING_SPELL;
    af.modifier           = -5;
    affect_to_obj(cross, &af);

    cross->timer = level + level / 5;
    cross->level = ch->level;
    cross->owner = str_dup(ch->name);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = level;
    af.modifier     = 0;
    af.bitvector    = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

    obj_to_char(cross, ch);
}

SPELL_FUN(spell_restore_mana)
{
        AFFECT_DATA af;
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        int bonus = 100 + level * 3 + dice(1, 50);

        if (is_affected(ch, sn)) {
            char_act("You can't use this spell so often!", ch);
            return;
        } 

        victim->mana = UMIN(victim->mana + bonus, victim->max_mana);
        update_pos(victim);
        if (victim->mana < victim->max_mana)
                char_act("You feel a surge of magic energy.", victim);
        else
                char_act("Your magic energy is fully restored.", victim); 
        if (ch != victim)
                char_act("Ok.", ch);

        af.where        = TO_AFFECTS;
        af.type         = sn;
        af.level        = level;
        af.duration     = 1;
        af.modifier     = 0;
        af.bitvector    = 0;
        af.location     = APPLY_NONE;
        affect_to_char(ch, &af);

        return;
}

SPELL_FUN(spell_bats_call)
{
        CHAR_DATA *bat;
        AFFECT_DATA af;
        int i, j;

        if (is_affected(ch, sn)) {
            char_act("You can't find enough Power to call more bats.", ch);
            return;
        }

        char_act("You call bats to help you.", ch);
        act("$n calls bats to help $gn{him}.",
                ch, NULL, NULL, TO_ROOM); 

        for (i = 0; i < ch->level / 10; i++) {
                if (count_charmed(ch))
                        break;

                bat = create_mob(get_mob_index(MOB_VNUM_VAMPIRE_BAT));

                bat->max_hit = bat->hit = number_fuzzy(level+10);
            bat->max_mana = bat->mana = 0;
            bat->level = ch->level+10;
                for (j = 0; j < 3; j++)
                    bat->armor[j] = number_fuzzy(50 - level);
            bat->gold = 0;
            bat->timer = level / 5;
                bat->damage[DICE_BONUS] = ch->level / 10;
                bat->damage[DICE_NUMBER] = 1;
                bat->damage[DICE_TYPE] = ch->level / 10;

            char_to_room(bat, ch->in_room);
            SET_BIT(bat->affected_by, AFF_CHARM);
                bat->master = bat->leader = ch;
        }

        af.where    = TO_AFFECTS;
        af.type     = sn;
        af.level    = level;
        af.duration     = level / 5;
        af.bitvector    = 0;
        af.modifier = 0;
        af.location = APPLY_NONE;
        affect_to_char(ch, &af);
}

SPELL_FUN(spell_field)
{
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        AFFECT_DATA af;

        if (is_affected(victim, sn)) {
          if (victim == ch)
                char_act("    .", ch);
          else
                act("$N    .", ch, NULL, victim, TO_CHAR);
          return;
        }

        af.where        = TO_AFFECTS;
        af.type         = sn;
        af.level        = level;
        af.duration     = number_fuzzy(level / 5) + 2;
        af.location     = APPLY_SAVING_SPELL;
        af.bitvector    = 0;
        af.modifier     = -10;
        affect_to_char(victim, &af);

        act("$n   .", victim, NULL, NULL, TO_ROOM);
        char_act("   .", victim);
        return;
}

SPELL_FUN(spell_spiritual_hammer)
{
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

        dam = dice(level, 14);
        if (saves_spell(level, victim, DAM_MENTAL))
                dam /= 2;
        if (!IS_GOOD(victim))
                dam /= 2;

        act(" $N     "
                  " $gN{}  .", ch, NULL, victim, TO_NOTVICT);
        act(" $N     "
                  " $gN{}  .", ch, NULL, victim, TO_CHAR);
        act("      "
                  "   .", ch, NULL, victim, TO_VICT);

        damage(ch, victim, dam, sn, DAM_MENTAL, TRUE);

        return;
}


SPELL_FUN(spell_chaos_combat)
{
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        AFFECT_DATA af;

        if (is_affected(victim, sn) || saves_spell(level, victim, DAM_MENTAL))
                return;

        af.where        = TO_AFFECTS;
        af.type         = sn;
        af.level        = level;
        af.duration     = 1;
        af.location     = APPLY_AC;
        af.bitvector    = 0;
        af.modifier     = LVL(ch) * 5;
        affect_to_char(victim, &af);

    act_puts("$N   .", ch, NULL, victim, TO_CHAR, POS_RESTING);
    act_puts("$N   .", ch, NULL, victim, TO_NOTVICT, POS_RESTING);
    act_puts("     .", victim, NULL, ch, TO_CHAR, POS_RESTING);

        return;
}

// Spells for pwipe
SPELL_FUN(spell_send_stalker)
{
    CHAR_DATA *victim;
    CHAR_DATA *stalker;
    
    if ((victim = get_char_world(ch, target_name)) == NULL
    || victim == ch || victim->in_room == NULL
    || IS_NPC(victim) || victim->level >= ch->level)
    {
        char_act("  .", ch);
        return;
    }
    if (ch->pcdata->security < 8) 
    {
        char_act("  .", ch);
        return;
    }

    char_act("  .", ch);
    act("$n  .",ch,NULL,NULL,TO_ROOM);

    stalker = create_mob(get_mob_index(1250));

    char_to_room(stalker,ch->in_room);
    stalker->hunting = victim;
    char_act("    !", ch);
    act("    $n!", ch, NULL, NULL, TO_ROOM);

    return;

}

SPELL_FUN(spell_banshee_scream)
{
        CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;
        int dam;
    bool svs;
    bool affect = FALSE;

    if (IS_AFFECTED(ch, AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_immune(victim, DAM_MAGIC) || IS_UNDEAD(victim)){
        act("$n    !", ch, NULL, victim, TO_NOTVICT);
        act("    !", ch, NULL, victim, TO_CHAR);
        act("$n    !", ch, NULL, victim, TO_VICT);
        return;
    }

        dam = dice(level, 14);

   svs = saves_spell(level, victim, DAM_SOUND);
       if (svs) dam /= 2;

    svs = (svs || IS_AFFECTED(victim, sn));

    if(!svs) switch(number_range(0,5)) {
    case 0:
//  blind
    if (!IS_AFFECTED(victim, AFF_BLIND)){
        
        act("$n      "
        " $N  .", ch, NULL, victim, TO_NOTVICT);
        act("      "
        " $N  .", ch, NULL, victim, TO_CHAR);
        act("$n      "
        "   .", ch, NULL, victim, TO_VICT);  

        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.location  = APPLY_HITROLL;
        af.modifier  = 0 - number_fuzzy(level/5);
        af.duration  = 3+level / 15;
        af.bitvector = AFF_BLIND;
        affect_to_char(victim, &af);

        affect = TRUE;
    }
        break;
    case 1:
//  corruption
    if (!IS_AFFECTED(victim, AFF_CORRUPTION)){
        
        act("$n      "
        " $N    .", ch, NULL, victim, TO_NOTVICT);
        act("      "
        " $N    .", ch, NULL, victim, TO_CHAR);
        act("$n      "
        "     .", ch, NULL, victim, TO_VICT);

        af.type      = sn;
        af.level     = level * 3/4;
        af.duration  = 1;
        af.location  = APPLY_NONE;
        af.modifier  = 0;
        af.bitvector = AFF_CORRUPTION;
        af.where     = TO_AFFECTS;
        affect_join(victim,&af);

        affect = TRUE;
    }
        break;
    case 2:
    /* weaken */
        act("$n      "
        "$N    .", ch, NULL, victim, TO_NOTVICT);
        act("      "
        "$N    .", ch, NULL, victim, TO_CHAR);
        act("$n      "
        "    .", ch, NULL, victim, TO_VICT);

        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = (4 + level / 12);
        af.location  = APPLY_STR;
        af.modifier  = -1 * (2 + level / 12);
        af.bitvector = 0;
        affect_join(victim, &af);

        affect = TRUE;
        break;
    case 3:
    /* slow */
    if (!IS_AFFECTED(victim, AFF_SLOW)){
        
        act("$n      "
        "$N   .", ch, NULL, victim, TO_NOTVICT);
        act("      "
        "$N   .", ch, NULL, victim, TO_CHAR);
        act("$n      "
        "   .", ch, NULL, victim, TO_VICT);

        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = (4 + level / 12);
        af.location  = APPLY_DEX;
        af.modifier  = - UMAX(2,level / 12);
        af.bitvector = AFF_SLOW;
        affect_to_char(victim, &af);

        affect = TRUE;
    }
        break;
    case 4:
    /* fear */ 
    if (!IS_AFFECTED(victim, AFF_FEAR) && !IS_SAMURAI(victim)){
        
        act("$n      "
        "$N  .", ch, NULL, victim, TO_NOTVICT);
        act("      "
        "$N  .", ch, NULL, victim, TO_CHAR);
        act("$n      "
        "  .", ch, NULL, victim, TO_VICT);

        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = (4 + level / 12);
        af.location  = APPLY_NONE;
        af.modifier  = 0;
        af.bitvector = AFF_FEAR;
        affect_to_char(victim, &af);

        affect = TRUE;
    }
        break;
    case 5:
    /* web */
    if (!IS_AFFECTED(victim, AFF_WEB)){
        
        act("$n      "
        "$N   .", ch, NULL, victim, TO_NOTVICT);
        act("      "
        "$N   .", ch, NULL, victim, TO_CHAR);
        act("$n      "
        "   .", ch, NULL, victim, TO_VICT);

        af.type      = sn;
        af.level     = level;
        af.duration  = 1;
        af.location  = APPLY_HITROLL;
        af.modifier  = -1 * (level / 6);
        af.where     = TO_AFFECTS;
        af.bitvector = AFF_WEB;
        affect_to_char(victim, &af);

        af.location  = APPLY_DEX;
        af.modifier  = -2;
        affect_to_char(victim, &af);

        af.location  = APPLY_DAMROLL;
        af.modifier  = -1 * (level / 6);
        affect_to_char(victim, &af);


        affect = TRUE;
    }
        break;
    }

    if (!affect) {
        act("$n    !", ch, NULL, victim, TO_NOTVICT);
        act("    !", ch, NULL, victim, TO_CHAR);
        act("$n    !", ch, NULL, victim, TO_VICT);
    }

        damage(ch, victim, dam, sn, DAM_SOUND, TRUE);

        return;
}

/*** den@df.ru 02.06.2001 ***/

SPELL_FUN(spell_animation)
{
    OBJ_DATA *obj = (OBJ_DATA *)vo;
    CHAR_DATA *mob, *gch;
    AFFECT_DATA *paf;
    AFFECT_DATA af;
    mlstring *tmp1, *tmp2;
    int i;
    int vnum = 0;
    int aggro = 5;
    int count = 0;
    int dam;

    static const int stats[MAX_STATS] = { 22, 16, 16, 20, 22, 16, 17, };

    static const struct 
    {
        int item_wear;
        int vnum;
    } wear2vnum[] = {
        { ITEM_WEAR_NECK,       MOB_VNUM_ANIMATED_NECK      },
        { ITEM_WEAR_SHIELD,     MOB_VNUM_ANIMATED_SHIELD    },
        { ITEM_WEAR_FLOAT,      MOB_VNUM_ANIMATED_FLOAT     },
        { ITEM_WEAR_HANDS,      MOB_VNUM_ANIMATED_HANDS     },
        { ITEM_WEAR_ARMS,       MOB_VNUM_ANIMATED_ARMS      },
        { ITEM_WEAR_LEGS,       MOB_VNUM_ANIMATED_LEGS      },
        { ITEM_WEAR_FEET,       MOB_VNUM_ANIMATED_FEET      },
        { ITEM_WEAR_PLUG_IN,    MOB_VNUM_ANIMATED_PLUG_IN   },
        { ITEM_WEAR_BODY,       MOB_VNUM_ANIMATED_BODY      },
        { ITEM_WEAR_HEAD,       MOB_VNUM_ANIMATED_HELM      },
        { -1,                   -1                          }
    };

    if (obj->pIndexData->item_type != ITEM_WEAPON
    && obj->pIndexData->item_type != ITEM_ARMOR)
    {
        char_act("You can animate weapons and armor only.", ch);
        return;
    }

    // no more animated grenades!
    // GM :  ...    ... :)
    if (obj->pIndexData->item_type == ITEM_WEAPON
    && obj->value[0] == WEAPON_GRENADE)
    {
        dam = dice(obj->value[1], obj->value[2]);
        dam = number_range(2 * dam, 10 * dam);
        act_puts("$p !", ch, obj, NULL, TO_CHAR, POS_DEAD);
        act_puts("$p !", ch, obj, NULL, TO_ROOM, POS_DEAD);
        extract_obj(obj);
        damage(ch, ch, dam, gsn_grenade, DAM_PIERCE, DAMF_SHOW);
        return;
    }

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch
        && gch->pIndexData->vnum >= MOB_VNUM_ANIMATED_MIN
        && gch->pIndexData->vnum <= MOB_VNUM_ANIMATED_MAX)
            count++;
    }
    
    if (count >= 2 || levelup_pet_count (ch) > 0)
    {
        char_act("You have no power to animate one more object.", ch);
        return;
    }
    if (obj->wear_loc != -1)
    {
        char_act("Get the item first.", ch);
        return;
    }

    if (check_material(obj, "unique")) 
    {
        act_puts("$p is created by Gods, you cannot do anything with it.", 
            ch, obj, NULL, TO_CHAR, POS_RESTING);
            return;
    }
    if (obj->level >= level && (obj->level-level+1)*20 > number_percent()) 
    {
        act_puts("$p won't listen you.", ch,obj,NULL,TO_CHAR,POS_RESTING);
        act_puts("$p won't listen to $n.", ch,obj,NULL,TO_ROOM,POS_RESTING);
        return;
    }

    if (obj->pIndexData->item_type == ITEM_WEAPON)
        vnum = MOB_VNUM_ANIMATED_WEAPON;
    else 
    {
        for (i=0; wear2vnum[i].item_wear != -1; i++)
            if (CAN_WEAR(obj, wear2vnum[i].item_wear)) 
            {
                vnum = wear2vnum[i].vnum;
                break;
            } 
    }
    if (!vnum) vnum = MOB_VNUM_ANIMATED_OTHER;

    mob = create_mob(get_mob_index(vnum));
    free_string(mob->name);
    mlstr_free(mob->short_descr);
    mob->name = str_dup(obj->name);
    mob->short_descr = mlstr_dup(obj->short_descr);

    tmp1 = mlstr_addstr(obj->short_descr, " "); 
    tmp2 = mob->long_descr;
    mob->long_descr = mlstr_addmlstr(tmp1, tmp2);
    mlstr_free(tmp1);
    mlstr_free(tmp2);

    mob->level = obj->level;
    mob->max_hit = mob->max_hit * obj->level + 100;
    mob->max_mana = obj->level * 6;

    for (i=0; i < MAX_STATS; i++)
        mob->perm_stat[i] = stats[i];

    mob->hitroll = obj->level;
    mob->damroll = obj->level;

    mob->damage[0] = 2;
    mob->damage[1] = obj->level / 2;

    for (i=0; i < 4; i++)
        mob->armor[i] = -obj->level * 4;

    if (IS_OBJ_STAT(obj, ITEM_BURN_PROOF))
        mob->resists[DAM_FIRE] += 40;

    if (IS_OBJ_STAT(obj, ITEM_BLESS))
        mob->perm_stat[STAT_LCK] += 3;

    if (IS_OBJ_STAT(obj, ITEM_INVIS)
    || IS_OBJ_STAT(obj, ITEM_DARK)) 
    {
        mob->perm_stat[STAT_INT]++;
        mob->perm_stat[STAT_WIS]++;
    }

    if (IS_OBJ_STAT(obj, ITEM_NOREMOVE)
    || IS_OBJ_STAT(obj, ITEM_NOUNCURSE))
        mob->damroll += 10;

    if (IS_OBJ_STAT(obj, ITEM_SELL_EXTRACT)
    || IS_OBJ_STAT(obj, ITEM_MELT_DROP))
        SET_BIT(mob->affected_by, AFF_PASS_DOOR);

    if (IS_OBJ_STAT(obj, ITEM_NOSAC)
    || IS_OBJ_STAT(obj, ITEM_NOPURGE))
        mob->level++;

    if (IS_OBJ_STAT(obj, ITEM_RADIATION)) 
    {
        mob->perm_stat[STAT_CON] += 2;
        mob->max_hit = 5 * mob->max_hit / 4;
    }

    if (obj->pIndexData->item_type == ITEM_WEAPON ) 
    {

        mob->damage[0] = obj->value[1];
        mob->damage[1] = 3 * obj->value[2];
        mob->dam_type = obj->value[3];

        if (IS_WEAPON_STAT(obj, WEAPON_FLAMING))
            mob->damroll += mob->level / 4;

        if (IS_WEAPON_STAT(obj, WEAPON_FROST))
            mob->dam_type = attack_lookup("chill");

        if (IS_WEAPON_STAT(obj, WEAPON_VAMPIRIC)) 
        {
            aggro += IS_GOOD(ch) ? 80 : 40;
            mob->alignment = -1000;
            SET_BIT(mob->affected_by, AFF_FLYING);
            SET_BIT(mob->immunes, DAM_NEGATIVE);
            mob->dam_type = attack_lookup("drain");
        }

        if (IS_WEAPON_STAT(obj, WEAPON_SHOCKING))
            mob->hitroll += mob->level / 4;

        if (IS_WEAPON_STAT(obj, WEAPON_POISON))
            mob->perm_stat[STAT_STR] += 4;

        if (IS_WEAPON_STAT(obj, WEAPON_SHARP)
        || IS_WEAPON_STAT(obj, WEAPON_VORPAL)) 
        {
            mob->damage[1] = mob->damage[0] * (mob->damage[1]+1);
            mob->damage[0] = 1;
        }

        if (IS_WEAPON_STAT(obj, WEAPON_TWO_HANDS))
            mob->size++;

        if (IS_WEAPON_STAT(obj, WEAPON_RADIATION))
            mob->max_hit += 3000;
    }

    if (!IS_SET(obj->extra_flags, ITEM_ENCHANTED))
        for (paf = obj->pIndexData->affected; paf != NULL; paf = paf->next) 
        {
            if (paf->duration != -1)
                continue;
            af = *paf;
            af.modifier *= 3;
            affect_to_char(mob, &af);
            aggro += 5;
        }
    for (paf = obj->affected; paf != NULL; paf = paf->next) 
    {
        if (paf->duration != -1)
            continue;
        af = *paf;
        af.modifier *= 3;
        affect_to_char(mob, &af);
        aggro += 5;
    }

    act_puts("You force $p to move!", ch, obj, NULL, TO_CHAR, POS_RESTING);
    act_puts("$n forces $p to move!", ch, obj, NULL, TO_ROOM, POS_RESTING);

    mob->hit = mob->max_hit;
    mob->mana = mob->max_mana;

    extract_obj(obj);
    char_to_room(mob, ch->in_room);

    if (aggro < number_percent()) 
    {
        SET_BIT(mob->affected_by, AFF_CHARM);
        mob->master = mob->leader = ch;
        mob->mob_tnl = mob->level * 15;
        //mob->mob_tnl = 1;
    } else 
    {
        act_yell(mob, "   , $i,    !", ch, NULL);
        doprintf(interpret, mob, "murder %s", ch->name);
    }
}

SPELL_FUN(spell_freedom)
{
    CHAR_DATA *slave, *master;
    level += get_curr_stat(ch, STAT_CHA) - 20;
    level += UMAX(0, get_curr_stat(ch, STAT_WIS) - 21);

    for (slave = ch->in_room->people; slave != NULL; slave = slave->next_in_room)
    {
        AFFECT_DATA af;
        if (!IS_AFFECTED(slave, AFF_CHARM))
            continue;
        if (!is_affected(slave, gsn_charm_person))
            continue;
        master = slave->master;
        if (!master)
            master = slave->leader;
        if (master && master->in_room
           && master->in_room == slave->in_room
           && !check_dispel(level, slave, sn_lookup("charm person"))
           && saves_spell(level, master, DAM_NONE))
            continue;

        REMOVE_BIT(slave->affected_by, AFF_CHARM);
        affect_bit_strip(slave, TO_AFFECTS, AFF_CHARM);

        af.where = TO_AFFECTS;
        af.type = sn;
        af.level = level;
        af.duration = 1 + level/30;
        af.location = APPLY_WIS;
        af.modifier = 1;
        af.bitvector = 0;
        affect_to_char(slave, &af);

        af.where = TO_RESIST;
        af.location = APPLY_NONE;
        af.modifier = 80;
        af.bitvector = DAM_CHARM;
        affect_to_char(slave, &af);

        act(" $N      !", ch, NULL, slave, TO_CHAR);
        act("  $n     !", ch, NULL, slave, TO_VICT);
        act("$n   $N        !", ch, NULL, slave, TO_ROOM);
        if(!master || master->in_room != slave->in_room)
            continue;
        act("  $N    !", master, NULL, slave, TO_CHAR);
        act(", $N      $n.", master, NULL, slave, TO_ROOM);
        act(" '' $n   !", master, NULL, slave, TO_VICT);
        multi_hit(slave, master, TYPE_UNDEFINED);
    }
}

SPELL_FUN(spell_mirror_image)
{
    AFFECT_DATA af;
    if (is_affected(ch, sn))
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 15;
    af.location  = 0;
    af.modifier  = 4;
    af.bitvector = 0;
    affect_to_char(ch, &af);
    act("  , , ,...\n   .", ch, NULL, NULL, TO_CHAR);
    act("$n  .", ch, NULL, NULL, TO_ROOM);
    return;
}

bool check_mirror_image(CHAR_DATA *ch, CHAR_DATA *victim)
{
    AFFECT_DATA *af;
    if (!is_affected(victim, gsn_mirror_image))
        return FALSE;
    for (af = victim->affected; af!= NULL; af = af->next)
        if (af->type == gsn_mirror_image)
            break;
    if (af == NULL)
        return FALSE;
    if (number_range(1,af->modifier+1) == 1)
        return FALSE;
    act("     .", victim, ch, NULL, TO_CHAR);
    act("  $n .", victim, ch, NULL, TO_ROOM);
    if (--(af->modifier) < 1)
        affect_strip(victim, gsn_mirror_image);
    return TRUE;
}

SPELL_FUN(spell_dark_ritual)
{
    if (number_percent() < get_skill(ch, sn) * ch->mana / ch->max_mana)
    {   
        ch->hit = ch->max_hit;
        ch->mana = 0;
        act("You prepare a dark ritual successfully.",
                    ch, NULL, NULL, TO_CHAR);
        return;
    }
    ch->mana = 0;
    if (number_percent() < get_skill(ch, sn) * ch->move / ch->max_move)
    {
        ch->hit = ch->max_hit;
        ch->move = 0;
        act("You prepare a dark ritual.",
                    ch, NULL, NULL, TO_CHAR);
        return;
    }
    act("You failed to prepare a dark ritual.",
                    ch, NULL, NULL, TO_CHAR);
    ch->move = 0;
}

/* spells from anatolia 3.0 */

SPELL_FUN(spell_firestream)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    act("$n throws a stream of searing flames.",
                    ch, NULL, victim, TO_NOTVICT);
    act("$n throws a stream of hot flames over you!",
                    ch, NULL, victim, TO_VICT);
    act("You throw a stream of searing flames to $N.",
                    ch, NULL, victim, TO_CHAR);

    dam = dice(level, 8);

    if (saves_spell(level,victim,DAM_FIRE))
    {
        fire_effect(victim,level/2,dam/4,TARGET_CHAR);
        damage(ch,victim,dam/2,sn,DAM_FIRE,TRUE);
    }
    else
    {
        fire_effect(victim,level,dam,TARGET_CHAR);
        damage(ch,victim,dam,sn,DAM_FIRE,TRUE);
    }
    return;
}

SPELL_FUN(spell_frostbolt)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    dam = dice( level, 10 );
    if ( saves_spell( level, victim, DAM_COLD ) )
        dam /= 2;
    damage( ch, victim, dam, sn,DAM_COLD,TRUE);
    return;
}

void summon_elemental(int sn, int level, CHAR_DATA *ch, int vnum)
{
  CHAR_DATA *gch;
  CHAR_DATA *elm;
  AFFECT_DATA af;
  const char *name, *aname;
  int i=0, hp, dn, dt, db;

  switch (vnum)
  {
    case MOB_VNUM_ELM_EARTH: aname = str_dup("an earth");
                              name = str_dup("earth");
                              hp = (2 * ch->pcdata->perm_hit) + 400;
                              dn = 3;
                              dt = 10;
                              db = level/2;
                             break;
    case MOB_VNUM_ELM_AIR:   aname = str_dup("an air");
                              name = str_dup("air");
                              hp = (4 * ch->pcdata->perm_hit) + 1000;
                              dn = 7;
                              dt = 4;
                              db = level/2;
                             break;
    case MOB_VNUM_ELM_WATER: aname = str_dup("a water");
                              name = str_dup("water");
                              hp = (5 * ch->pcdata->perm_hit) + 2000;
                              dn = 8;
                              dt = 4;
                              db = level/2;
                             break;
    case MOB_VNUM_ELM_FIRE:  aname = str_dup("a fire");
                              name = str_dup("fire");
                              hp = (10 * ch->pcdata->perm_hit) + 1000;
                              dn = 11;
                              dt = 5;
                              db = level/2 + 10;
                             break;
    case MOB_VNUM_ELM_LIGHT: aname = str_dup("a lightning");
                              name = str_dup("lightning");
                              hp = (10 * ch->pcdata->perm_hit) + 4000;
                              dn = 13;
                              dt = 9;
                              db = level/2 + 10;
                             break;
    default: return;
  }
  
  if (is_affected(ch,sn))
  {
      act("You lack the power to summon another $t elemental right now.",
                   ch, name, NULL, TO_CHAR);
      return;
  }

  act("You attempt to summon $t elemental.",
                  ch, aname, NULL, TO_CHAR);
  act("$n attempts to summon $t elemental.",
                  ch, aname, NULL, TO_ROOM);

  for (gch = char_list; gch != NULL; gch = gch->next)
    {
      if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch &&
          ( gch->pIndexData->vnum == vnum ) )
        {
          i++;
          if (i > 2)
           {
            act("More $t elementals are more than you can control!",
                            ch, name, NULL, TO_CHAR);
            return;
           }
        }
    }

  if (count_charmed(ch)) return;

  elm = create_mob(get_mob_index(vnum));

  for (i = 0; i < MAX_STATS; i ++)
       elm->perm_stat[i] = UMIN(25, 15 + level/10);

  elm->max_hit = IS_NPC(ch) ? URANGE(ch->max_hit,1 * ch->max_hit,30000)
                : UMIN(hp ,30000);
  elm->hit = elm->max_hit;
  elm->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
  elm->mana = elm->max_mana;
  elm->level = level;
  for (i=0; i < 3; i++)
    elm->armor[i] = interpolate(elm->level,100,-100);
  elm->armor[3] = interpolate(elm->level,100,0);
  elm->gold = 0;
  elm->timer = 0;
  elm->damage[DICE_NUMBER]  = dn;   
  elm->damage[DICE_TYPE]    = dt;
  elm->damage[DICE_BONUS]   = db;

  char_to_room(elm, ch->in_room);
  act("You summoned $t elemental!",
                  ch, aname, NULL, TO_CHAR);
  act("$n summoned $t elemental!",
                  ch, aname, NULL, TO_ROOM);

  af.where              = TO_AFFECTS;
  af.type               = sn;
  af.level              = level; 
  af.duration           = 24;
  af.bitvector          = 0;
  af.modifier           = 0;
  af.location           = APPLY_NONE;
  affect_to_char(ch, &af);  

  SET_BIT(elm->affected_by, AFF_CHARM);
  elm->master = elm->leader = ch;

}


SPELL_FUN(spell_summon_earth_elm)
{
    summon_elemental (sn, level, ch, MOB_VNUM_ELM_EARTH);
} 
SPELL_FUN(spell_summon_air_elm)
{
    summon_elemental (sn, level, ch, MOB_VNUM_ELM_AIR);
} 
SPELL_FUN(spell_summon_water_elm)
{
    summon_elemental (sn, level, ch, MOB_VNUM_ELM_WATER);
} 
SPELL_FUN(spell_summon_fire_elm)
{
    summon_elemental (sn, level, ch, MOB_VNUM_ELM_FIRE);
} 
SPELL_FUN(spell_summon_light_elm)
{
    summon_elemental (sn, level, ch, MOB_VNUM_ELM_LIGHT);
} 

SPELL_FUN(spell_grounding)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if ( is_affected( victim, sn ) )
    {
        if (victim == ch)
            act("You are already at ground potential.",
                            ch, NULL, NULL, TO_CHAR);
        else
            act("$N is already at ground potential.",
                            ch, NULL, victim, TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = 5 + level / 8;
    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = AFF_GROUNDING;
    affect_to_char( victim, &af );
    act("Your body is electrically grounded.", 
                    victim, NULL, NULL, TO_CHAR );
    if ( ch != victim )
    act("$N is grounded by your magic.",
                    ch, NULL, victim, TO_CHAR);
    return;
}

bool check_grounding(CHAR_DATA *ch)
{
    if (IS_AFFECTED(ch, AFF_GROUNDING))
    {
        act("The electricity fizzles at your foes.",
                       ch, NULL, NULL, TO_CHAR);
        act("A lightning bolt fizzles at $n's foes.",
                       ch, NULL, NULL, TO_ROOM);
        return TRUE;
    }
    return FALSE;
}

SPELL_FUN(spell_tsunami)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if ( (ch->in_room->sector_type != SECT_WATER_SWIM)
        && (ch->in_room->sector_type != SECT_WATER_NOSWIM))
    {
        act("You can't reach a water source to create a tsunami.",
                        ch, NULL, NULL, TO_CHAR);
        ch->wait = 0;
        return;
    }

    act("An existing parcel of water rises up and forms a fist and pummels $n.",
                victim, NULL, NULL, TO_ROOM);
    act("An existing parcel of water rises up and forms a fist and pummels you.",
                victim, NULL, NULL, TO_CHAR);
    dam = dice( level , 16 );
    damage(ch, victim, dam, sn, DAM_BASH, TRUE);
}

SPELL_FUN(spell_absorb)
{
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        act("You are already absorbing magic surrounding you.",
                        ch, NULL, NULL, TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = 3 + level / 10;
    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = AFF_ABSORB;
    affect_to_char( ch, &af );
    act("Your body is surrounded by an energy field.", 
                    ch, NULL, NULL, TO_CHAR);
    return;
}

SPELL_FUN(spell_animate_object)
{
  CHAR_DATA *mob;
  OBJ_DATA *obj = (OBJ_DATA *) vo;
  AFFECT_DATA af;
  const char *p;
  int i;
  int dam;

  if (!(obj->pIndexData->item_type == ITEM_WEAPON ||  
         obj->pIndexData->item_type == ITEM_ARMOR))
  {
        act("You can animate only armors and weapons.",
                        ch, NULL, NULL, TO_CHAR);
        return;
  }

    // no more animated grenades!
    if (obj->pIndexData->item_type == ITEM_WEAPON
        &&  obj->value[0] == WEAPON_GRENADE)
    {
        dam = dice(obj->value[1], obj->value[2]);
        dam = number_range(dam, 2 * dam);
        act_puts("$p !",
                  ch, obj, NULL, TO_CHAR, POS_DEAD);
        act_puts("$p !",
                  ch, obj, NULL, TO_ROOM, POS_DEAD);
        extract_obj(obj);
        damage(ch, ch, dam, gsn_grenade, DAM_PIERCE, DAMF_SHOW);
        return;
    }


  if (is_affected(ch, sn))
  {
      act("You cannot summon the strength to handle more animated objects.", 
                      ch, NULL, NULL, TO_CHAR);
      return;
  }

  if ( obj->level > level )
  {
      act("$p is too powerful for you to animate it.", 
                      ch, obj, NULL, TO_CHAR);
      return;
  }

  if (count_charmed(ch)) return;

  if (obj->pIndexData->item_type == ITEM_ARMOR
    && !(CAN_WEAR(obj, ITEM_WEAR_BODY)
    || CAN_WEAR(obj, ITEM_WEAR_HANDS)
    || CAN_WEAR(obj, ITEM_WEAR_SHIELD)) )
  {
      act("You can't animate this type of armor.", 
                      ch, NULL, NULL, TO_CHAR);
      return;
  }

  if (number_percent() > get_skill(ch, sn))
  {
      act("$p violately explodes!", 
                      ch, obj, NULL, TO_CHAR);
      act("$p violately explodes!", 
                      ch, obj, NULL, TO_ROOM);
      extract_obj( obj );
      return;
  }

  p = mlstr_mval(obj->short_descr);

  if (obj->pIndexData->item_type == ITEM_WEAPON)
    mob = create_named_mob(get_mob_index(MOB_VNUM_WEAPON), p);
  else  
    mob = create_named_mob(get_mob_index(MOB_VNUM_ARMOR), p);

  char_to_room( mob, ch->in_room);
  mob->level = obj->level;

  for(i=0; i < MAX_STATS; i++)
    mob->perm_stat[i] = UMIN(25, ch->perm_stat[i]);
  for(i=0; i<3; i++)
    mob->armor[i] = interpolate( mob->level, 100, -100);
  mob->armor[3] = interpolate(mob->level, 100, 0);

  if (obj->pIndexData->item_type == ITEM_WEAPON)
  {
     mob->hit = IS_NPC(ch) ? 100 : 
        UMIN( (25 * mob->level) + 1000, 30000);
     mob->max_hit = mob->hit;
     mob->mana = ch->level * 40;
     mob->max_mana = mob->mana;
     mob->move = ch->level * 40;
     mob->max_move = mob->move;
     mob->timer = 0;
     mob->damage[DICE_NUMBER] = obj->value[1];
     mob->damage[DICE_TYPE] = obj->value[2];
     mob->damage[DICE_BONUS] = number_range(level/10, level/8);
  }

  if (obj->pIndexData->item_type == ITEM_ARMOR)
  {
     mob->hit = IS_NPC(ch) ? 100:
        UMIN( (100 * mob->level) + 2000, 30000);
     mob->max_hit = mob->hit;
     mob->mana = ch->level * 40;
     mob->max_mana = mob->mana;
     mob->move = ch->level * 40;
     mob->max_move = mob->move;
     mob->timer = 0;
     mob->damage[DICE_NUMBER] = number_range(level/15, level/12);
     mob->damage[DICE_TYPE] = number_range(level/3, level/2);
     mob->damage[DICE_BONUS] = number_range(level/10, level/8);
  }
  mob->sex = ch->sex;
  mob->gold = 0;
  mob->master = mob->leader = ch;
  SET_BIT(mob->affected_by, AFF_CHARM);
  
  af.where  = TO_AFFECTS;
  af.type   = sn;
  af.level  = ch->level;
  af.duration   = 1 + (obj->level / 30);
  af.modifier   = 0;
  af.location   = APPLY_NONE;
  af.bitvector  = 0;
  affect_to_char(ch, &af);
 
  act("You give life to $p with your power!", 
                  ch, obj, NULL, TO_CHAR);
  act("$n gives life to $p with $gn{his} power!", 
                  ch, obj, NULL, TO_ROOM);
  
  extract_obj( obj );
    return;
}

SPELL_FUN(spell_windwall)
{
    CHAR_DATA *vch, *vch_next;
    int dam, dice_dam;

    act("$n raise a wall of wind striking everyone.",
                    ch, NULL, NULL, TO_ROOM);
    act("You raise a wall of wind.",
                    ch, NULL, NULL, TO_CHAR);

    dice_dam = dice(level, 12);

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe_spell(ch,vch,TRUE)
            ||  (IS_NPC(ch) && IS_NPC(vch) 
            &&   (ch->fighting == vch || vch->fighting == ch)))
            continue;
        if (is_safe(ch, vch))
              continue;
        if (!IS_NPC(ch) && vch != ch &&
             ch->fighting != vch && vch->fighting != ch &&
              (IS_SET(vch->affected_by,AFF_CHARM) || !IS_NPC(vch)))
        {
            if (!can_see(vch, ch))
                do_yell(vch, "Help someone is attacking me!");
            else
                act_yell(vch, "Die, $i, you sorcerous dog!", ch, NULL); 
        }

        dam = dice_dam;

        if (IS_AFFECTED(vch, AFF_FLYING)) dam *= 2;

             if (vch->size >= SIZE_GIANT_MIN)   
            dam = dam * 15/10;
        else if (vch->size >= SIZE_HUGE_MIN)  
            dam = dam * 13/10;
        else if (vch->size >= SIZE_LARGE_MIN) 
            dam = dam * 10/10;
        else if (vch->size >= SIZE_MEDIUM_MIN)  
            dam = dam * 9/10;
        else if (vch->size >= SIZE_SMALL_MIN)   
            dam = dam * 7/10;
        else if (vch->size >= SIZE_TINY_MIN)  
            dam = dam * 5/10;   
        else 
            dam = dam * 4/10;

        if (saves_spell(level,vch,DAM_MAGIC))
            damage(ch,vch,dam/2,sn,DAM_MAGIC,TRUE);
        else
            damage(ch,vch,dam,sn,DAM_MAGIC,TRUE);
    }
    return;
}

SPELL_FUN(spell_earthfade)
{
    AFFECT_DATA af;

    if (IS_AFFECTED(ch, AFF_EARTHFADE))
        return;

    if (ch->in_room->sector_type == SECT_AIR
    || ch->in_room->sector_type == SECT_WATER_SWIM
    || ch->in_room->sector_type == SECT_WATER_NOSWIM )
    {
        act("You cannot reach the earth to fade.", 
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_PUMPED(ch))
    {
        act("You can't fade to earth while pumped.",
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (RIDDEN(ch))
    {
        act("You can't fade to earth while ridden.",
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (MOUNTED(ch)) 
    {
        act("You can't fade to earth while mounted.", 
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    act("You fade into earth.", 
                    ch, NULL, NULL, TO_CHAR );
    act("$n fades into earth.", 
                    ch, NULL, NULL, TO_ROOM );

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (level / 8 + 1);
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_EARTHFADE;
    affect_to_char( ch, &af );
    return;
}

SPELL_FUN(spell_earthmaw)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    act("You tremble the earth underneath the $N.",
                    ch, NULL, victim, TO_CHAR);
    act("$n trembles the earth underneath you!.", 
                    ch, NULL, victim, TO_VICT);
    if (IS_AFFECTED(victim, AFF_FLYING))
        dam = 0;
    else 
        dam = dice( level , 16 );
    damage(ch, victim, dam, sn, DAM_BASH, TRUE);
    return;
}

SPELL_FUN(spell_drain)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    AFFECT_DATA *paf;
    int drain;

    if (!IS_SET(obj->extra_flags,ITEM_MAGIC))
    {
        act("That item is not magical.",
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    switch (obj->pIndexData->item_type)
    {
        default:            drain = 1;              break;
        case ITEM_ARMOR:    drain = obj->value[3];  break;
        case ITEM_TREASURE: drain = 4;              break;
        case ITEM_POTION:   drain = 8;              break;
        case ITEM_SCROLL:
        case ITEM_STAFF:
        case ITEM_WAND:     drain = 12;             break;
        case ITEM_WEAPON:   drain = obj->value[1] + obj->value[2] / 2; 
                                                    break;
        case ITEM_LIGHT:    if (obj->value[2] == -1)     
                                drain = 10;
                            else 
                                drain = 4;
                                                    break;
    }

    for (paf = obj->affected; paf != NULL; paf = paf->next)
    drain += 5;

    drain *= dice(2,5);
    drain += obj->level / 2;

    if (number_percent() > get_skill(ch, sn))
    {
        act("$p evaporates!",
                        ch, obj, NULL, TO_ROOM);
        act("$p evaporates, but you fail to channel the energy.",
                        ch, obj, NULL, TO_CHAR);
    }
    else
    {
        act("$p evaporates as $n drains its energy!",
                        ch, obj, NULL, TO_ROOM);
        act("$p evaporates as you drain its energy!",
                        ch, obj, NULL, TO_CHAR);
        ch->mana = UMIN(ch->mana + drain, ch->max_mana);
    }
    extract_obj(obj);
    return; 
}

SPELL_FUN(spell_soften)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
        return;

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = 5 + level / 10;
    af.location  = APPLY_AC;
    af.modifier  = 4 * level;
    af.bitvector = AFF_FAERIE_FIRE;
    affect_to_char( victim, &af );

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (10 + level / 5);
    af.location  = APPLY_SAVING_SPELL;
    af.modifier  = -1;
    af.bitvector = 0;
    affect_to_char( victim, &af );

    act("Your skin starts to wrinkle.", 
                    victim, NULL, NULL, TO_CHAR);
    act("$n skin starts to wrinkle.", 
                    victim, NULL, NULL, TO_ROOM);
    return;
} 

SPELL_FUN(spell_fumble)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    OBJ_DATA *obj;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            act("You can't be more fumble!",
                        ch, NULL, victim, TO_CHAR);
        else
            act("$N can't get any more fumble than that.",
                        ch, NULL, victim, TO_CHAR);
        return;
    }

    if (saves_spell(level,victim,DAM_MAGIC)
    ||  is_immune(victim, DAM_MAGIC))
    {
        if (victim != ch)
            act("Nothing seemed to happen.",
                            ch, NULL, NULL, TO_CHAR);
        act("You feel momentarily lethargic.",
                    victim, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_AFFECTED(victim, AFF_HASTE))
    {
        if (check_dispel(level, victim, gsn_haste))
            act("$n is moving less quickly.",
                        victim, NULL, NULL, TO_ROOM);
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (4 + level / 12);
    af.location  = APPLY_DEX;
    af.modifier  = - UMAX(2,level / 6);
    af.bitvector = 0;
    affect_to_char( victim, &af );

    if ((obj = get_eq_char(victim, WEAR_SECOND_WIELD)) != NULL)
    {
        if (can_drop_obj(victim,obj)
            &&  remove_obj(victim, WEAR_SECOND_WIELD, TRUE))
        {
            act("$n cannot carry $p anymore and drops it.", 
                          victim, obj, NULL, TO_ROOM);
            act("You cannot carry your dual weapon anymore and drop it!", 
                          victim, obj, NULL, TO_CHAR);
            obj_from_char(obj);
            obj_to_room(obj,victim->in_room);
        }
    }
    if ((obj = get_eq_char(victim, WEAR_WIELD)) != NULL)
    {
        if (can_drop_obj(victim,obj)
            &&  remove_obj(victim, WEAR_WIELD, TRUE))
        {
            act("$n cannot carry $p anymore and drops it.", 
                          victim, obj, NULL, TO_ROOM);
            act("You cannot carry your weapon anymore and drop it!", 
                          victim, obj, NULL, TO_ROOM);
            obj_from_char(obj);
            obj_to_room(obj,victim->in_room);
        }
    }

    WAIT_STATE(victim, PULSE_VIOLENCE);
    act("You feel yourself very  f u m b l e...", 
                    victim, NULL, NULL, TO_CHAR );
    act("$n starts to move in a fumble way.",
                    victim, NULL, NULL, TO_ROOM);
    return;
}

SPELL_FUN(spell_light_arrow)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    dam = dice( level, 12 );
    if ( saves_spell( level, victim, DAM_HOLY ) )
        dam /= 2;
    damage( ch, victim, dam, sn,DAM_HOLY,TRUE);
    return;
} 

SPELL_FUN(spell_hydroblast)
 {
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if ( (ch->in_room->sector_type != SECT_WATER_SWIM)
    && (ch->in_room->sector_type != SECT_WATER_NOSWIM)
    && (weather_info.sky != SKY_RAINING || !IS_OUTSIDE(ch)) )
    {
        act("You couldn't reach any water molecule here.",
                        ch, NULL, NULL, TO_CHAR);
        ch->wait = 0;
        return;
    }

    act("The water molecules around $n comes together and forms a fist.",
        ch, NULL, NULL, TO_ROOM);
    act("The water molecules around you comes together and forms a fist.",
        ch, NULL, NULL, TO_CHAR);
    dam = dice( level , 14 );
    damage(ch, victim, dam, sn, DAM_BASH, TRUE);
}

SPELL_FUN(spell_sword_of_justice)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (!IS_NPC(victim) && IS_SET(victim->plr_flags, PLR_WANTED))
        dam = dice(level, 30);
    else    
        dam = dice(level, 18);

    if (saves_spell(level, victim, DAM_MENTAL))
        dam /= 2;

    do_yell(ch, "The Sword of Justice!");
    act("The sword of justice appears and strikes $N!", ch, NULL, victim, TO_ALL);

    damage(ch, victim, dam, sn, DAM_MENTAL, TRUE);
}

SPELL_FUN(spell_guard_dogs) 
{
    CHAR_DATA *gch, *dog, *dog2;
    AFFECT_DATA af;
    int i;

    if (is_affected(ch,sn))
    {
        act("You lack the power to summon another dog right now.",
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    act("You attempt to summon a dog.",
                      ch, NULL, NULL, TO_CHAR);
    act("$n attempts to summon a dog.",
                      ch, NULL, NULL, TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch &&
                gch->pIndexData->vnum == MOB_VNUM_DOG)
        {
            act("Two dogs are more than you can control!",
                            ch, NULL, NULL, TO_CHAR);
            return;
        }
    }

  if (count_charmed(ch)) return;

  dog = create_mob( get_mob_index(MOB_VNUM_DOG) );

  for (i=0;i < MAX_STATS; i++)
    {
      dog->perm_stat[i] = ch->perm_stat[i];
    }

  dog->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : URANGE(ch->pcdata->perm_hit,ch->hit,30000);
  dog->hit = dog->max_hit;
  dog->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
  dog->mana = dog->max_mana;
  dog->level = ch->level;
  for (i=0; i < 3; i++)
    dog->armor[i] = interpolate(dog->level,100,-100);
  dog->armor[3] = interpolate(dog->level,100,0);
  dog->gold = 0;
  dog->timer = 0;
  dog->damage[DICE_NUMBER] = number_range(level/15, level/12);   
  dog->damage[DICE_TYPE] = number_range(level/3, level/2);
  dog->damage[DICE_BONUS] = number_range(level/10, level/8);

  dog2 = create_mob(dog->pIndexData);
  clone_mob(dog,dog2);
  
  SET_BIT(dog->affected_by, AFF_CHARM);
  SET_BIT(dog2->affected_by, AFF_CHARM);
  dog->master = dog2->master = ch;
  dog->leader = dog2->leader = ch;

  char_to_room(dog,ch->in_room);
  char_to_room(dog2,ch->in_room);
  act("Two dogs arrive and bows before you!",
                  ch, NULL, NULL, TO_CHAR);
  act("Two dogs arrive from somewhere and bows!",
                  ch, NULL, NULL, TO_ROOM);

  af.where      = TO_AFFECTS;
  af.type               = sn;
  af.level              = level; 
  af.duration           = 24;
  af.bitvector          = 0;
  af.modifier           = 0;
  af.location           = APPLY_NONE;
  affect_to_char(ch, &af);  

}

SPELL_FUN(spell_eyes_of_tiger)
{
    CHAR_DATA *victim;
    ROOM_INDEX_DATA *ori_room;

    if ( (victim = get_char_world(ch, target_name)) == NULL)
    {
        act("Your tiger eyes cannot see such a player.",
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!HAS_SKILL(victim, sn_lookup("hunt")))
    {
        act("Your tiger eyes sees only hunters!",
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((victim->level > ch->level + 7) 
    || saves_spell((ch->level + 9), victim, DAM_NONE))
    {
        act("Your tiger eyes cannot see that player.",
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (ch==victim)
      do_look( ch, "auto" );
    else {
      ori_room = ch->in_room;
      char_from_room( ch );
      char_to_room( ch, victim->in_room );
      do_look( ch, "auto" );
      char_from_room( ch );
      char_to_room( ch, ori_room );
    }
}

SPELL_FUN(spell_lion_shield) 
{
  OBJ_DATA *shield;
  AFFECT_DATA af;

  shield = create_obj( get_obj_index(OBJ_VNUM_LION_SHIELD), level );
  shield->timer = level;
  shield->level = ch->level;
  shield->cost  = 0;
  obj_to_char(shield, ch);
  
  af.where        = TO_OBJECT;
  af.type         = sn;
  af.level        = level;
  af.duration     = -1;
  af.modifier     = level / 8;
  af.bitvector    = 0;

  af.location     = APPLY_HITROLL;
  affect_to_obj(shield,&af);

  af.location     = APPLY_DAMROLL;
  affect_to_obj(shield,&af);

  
  af.where        = TO_OBJECT;
  af.type         = sn;
  af.level        = level;
  af.duration     = -1;
  af.modifier     = -(level * 2) / 3;
  af.bitvector    = 0;
  af.location     = APPLY_AC;
  affect_to_obj(shield,&af);

  af.where        = TO_OBJECT;
  af.type         = sn;
  af.level        = level;
  af.duration     = -1;
  af.modifier     = UMAX(1,level /  30);
  af.bitvector    = 0;
  af.location     = APPLY_CHA;
  affect_to_obj(shield,&af);

  af.where        = TO_OBJECT;
  af.type         = sn;
  af.level        = level;
  af.duration     = -1;
  af.modifier     = -level/9;
  af.bitvector    = 0;
  af.location     = APPLY_SAVING_SPELL;
  affect_to_obj(shield,&af);

  act("You create $p!",
                  ch, shield, NULL, TO_CHAR);
  act("$n creates $p!",
                  ch, shield, NULL, TO_ROOM);
}
  
SPELL_FUN(spell_prevent)
{
    AFFECT_DATA af,af2;

    if (is_affected_room(ch->in_room, sn))
    {
        act("This room has already been prevented from revenges!",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("It is impossible use prevent so often!", ch);
        return;
    }

    af.where     = TO_ROOM_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = 6;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = RAFF_PREVENT;
    affect_to_room(ch->in_room, &af);

    af2.where     = TO_AFFECTS;
    af2.type      = sn;
    af2.level     = level;
    af2.duration  = 9;
    af2.modifier  = 0;
    af2.location  = APPLY_NONE;
    af2.bitvector = 0;
    affect_to_char(ch, &af2);
    act( "The room is now protected from revenges and escapes!",
        ch, NULL, NULL, TO_CHAR);
    act("The room starts to be filled with $n's prevention.",
        ch, NULL, NULL, TO_ROOM);
    return;
}

SPELL_FUN(spell_chromatic_orb)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    dam = number_range(level * 2, level * 5) + 40;
    if (saves_spell(level, victim, DAM_LIGHT))
        dam /= 2;

    if (number_percent() < get_skill(ch, sn) * 7 / 10)
    {
        if (IS_NPC(victim)) level = level * 2;

        spell_blindness(sn_lookup("blindness"),
            (level - 10), ch, vo, TARGET_CHAR);

        spell_slow(sn_lookup("slow"),
            (level - 10), ch, vo, TARGET_CHAR);
    }
    damage(ch, victim, dam, sn, DAM_LIGHT, TRUE);
    return;
}

SPELL_FUN(spell_suffocate)  
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_SUFFOCATE))
    {
         act("$N already cannot breathe.",
                         ch, NULL, victim, TO_CHAR);
         return;
    }

    if (saves_spell(level,victim,DAM_NEGATIVE) || IS_UNDEAD(victim))
    {
        if (ch == victim)
          act("You feel momentarily ill, but it passes.",
                          ch, NULL, victim, TO_CHAR);
        else
          act("$N seems to be unaffected.",
                          ch, NULL, victim, TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level * 3/4;
    af.duration  = 3 + level / 30;
    af.location  = APPLY_NONE;
    af.modifier  = 0; 
    af.bitvector = AFF_SUFFOCATE;
    affect_join(victim,&af);

    act("You cannot breathe.",
                    victim, NULL, NULL, TO_CHAR);
    act("$n tries to breathe, but cannot.", 
                    victim, NULL, NULL, TO_ROOM);
    return;
}

SPELL_FUN(spell_soul_bind)  
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (ch->pet != NULL)
    {
        act("Your soul is already binded to someone else.", 
                    ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!IS_NPC(victim) 
        || !(IS_AFFECTED(victim, AFF_CHARM) && victim->master == ch))
    {
        act("You cannot bind that soul to you.", 
                    ch, NULL, NULL, TO_CHAR);
        return;
    }

    victim->leader = ch;
    ch->pet = victim;

    act("You bind $N's soul to yourself.", 
                  ch, NULL, victim, TO_CHAR);
    act("$n binds $N's soul to $gn{himself}.", 
                  ch, NULL, victim, TO_ROOM);
    return;
}


SPELL_FUN(spell_iron_body)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_PROTECTION))
    {
        if (is_affected(victim, sn))
        {
            if (victim == ch)
                act("Your skin is already as hard as iron.",
                            ch, NULL, NULL, TO_CHAR);
            else
                act("$N's skin is already as hard as iron.",
                            ch, NULL, victim, TO_CHAR);
        }
        else
        {
            if (victim == ch)
                act("You already have another protection around you.",
                            ch, NULL, NULL, TO_CHAR);
            else
                act("$N already has another protection around $gN{himself}.",
                            ch, NULL, victim, TO_CHAR);
        }
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 6;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_PROTECTION;
    affect_to_char( victim, &af );
    act("$n skin is now as hard as iron.", 
                    victim, NULL, NULL, TO_ROOM );
    act("Your skin is now as hard as iron.", 
                    victim, NULL, NULL, TO_CHAR );
    return;
}

SPELL_FUN(spell_elemental_sphere)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_PROTECTION))
    {
        if (is_affected(victim, sn))
        {
            if (victim == ch)
                act("An elemental sphere is already protecting you.",
                        ch, NULL, NULL, TO_CHAR);
            else
                act("An elemental sphere is already protecting $N.",
                        ch, NULL, victim, TO_CHAR);
        }
        else
        {
            if (victim == ch)
                act("You already have another protection around you.",
                            ch, NULL, NULL, TO_CHAR);
            else
                act("$N already has another protection around $gN{himself}.",
                            ch, NULL, victim, TO_CHAR);
        }
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 6;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_PROTECTION;
    affect_to_char( victim, &af );
    act( "$n uses all elemental powers to build a sphere around $gn{himself}.", 
                    victim, NULL, NULL, TO_ROOM );
    act( "You use all elemental powers to build a sphere around you.", 
                    victim, NULL, NULL, TO_CHAR );
    return;
}


SPELL_FUN(spell_aura_of_chaos)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (ch->clan != victim->clan)
    {
        act("You may only use this spell on fellow clan members.",
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (is_affected(victim, sn ))
    {
        if (victim == ch)
            act("You are already protected by gods of chaos.",
                            ch, NULL, NULL, TO_CHAR);
        else
            act("$N is already protected by aura of chaos.",
                      ch, NULL, victim, TO_CHAR);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = 24;
    af.modifier  = 0;
    af.location  = 0;
    af.bitvector = 0;
    affect_to_char( victim, &af );
    act("You feel the gods of chaos protect you.", 
                    victim, NULL, NULL, TO_CHAR);
    if ( ch != victim )
        act("An aura appears around $N.",
                        ch, NULL, victim, TO_CHAR);
    return;
}

SPELL_FUN(spell_mark_tree)
{
    char arg [MAX_INPUT_LENGTH] ;
    int number;

    one_argument(target_name, arg, sizeof(arg)) ;

    if (arg[0] == '\0' || !(is_number (arg)))
    {
        char_act ("You must specify a number.", ch) ;
        return;
    }

    number = atoi (arg) - 1;
    if (number < 0 || number >= MAX_TREES)
    {
        char_printf(ch, "Number must be between 1 and %d.\n", MAX_TREES);
        return; 
    }

    // check if we've already cast mark tree
    if (ch->marked_tree[number] != 0)
    {
        ch->marked_tree[number] = 0;
        char_act("You wipe the memory of previous tree from your mind.", ch);
        return;
    }

    // don't allow in no_recall or safe zones
    if (IS_SET(ch->in_room->room_flags, ROOM_NORECALL)
    || IS_SET(ch->in_room->room_flags, ROOM_SAFE))
    {
        char_act("You can't seem to fix this spot in your mind.", ch);
        return;
    }

    // The sector must be forest
    if (ch->in_room->sector_type != SECT_FOREST)
    {
        char_act("You look around for a nearby tree in vain.", ch);
        return;
    }

    // otherwise, store current location
    ch->marked_tree[number] = ch->in_room->vnum;
    char_act("You fix the location of this tree in your mind.", ch);
    return;
}

SPELL_FUN(spell_tree_transport)
{
    ROOM_INDEX_DATA *dest;
    CHAR_DATA   *rch;
    CHAR_DATA   *wch;
    CHAR_DATA   *vch_next;
    bool gate_pet;
    int count;

    char arg [MAX_INPUT_LENGTH] ;
    int number;

    one_argument(target_name, arg, sizeof(arg)) ;

    if (arg[0] == '\0' || !(is_number (arg)))
    {
        char_act ("You must specify a number.", ch) ;
        return;
    }

    number = atoi (arg) - 1;
    if (number < 0 || number >= MAX_TREES)
    {
        char_printf(ch, "Number must be between 1 and %d.\n", MAX_TREES);
        return; 
    }

    // must have already cast mark tree
    if ( ch->marked_tree[number] == 0 )
    {
        char_act( "You can't remember any trees to travel to.", ch );
        return;
    }
        
    if ((dest = get_room_index(ch->marked_tree[number])) == NULL 
    || !can_see_room(ch, dest))
    {
        char_act( "You sense nothingness where there was...", ch );
        return;
    }

    // don't allow in no_recall or safe zones
    if (IS_SET(dest->room_flags, ROOM_SAFE) 
    || IS_SET(dest->room_flags, ROOM_NORECALL))
    {
        char_act( "Transportation failed.", ch );
        return;
    }

    // The sector can't be industrial
    if (ch->in_room->sector_type == SECT_INSIDE
    || ch->in_room->sector_type == SECT_CITY)
    {
        char_act( "You look around for a nearby tree in vain.", ch );
        return;
    }

    // don't allow if the stored room is private
    if (IS_SET(dest->room_flags, ROOM_PRIVATE))
    {
        count = 0;
        for (rch = dest->people; rch != NULL; rch = rch->next_in_room)
            count++;

        if (count > 1)
        {
            char_act( "That room's too crowded already.", ch );
            return;
        }
    }

    if (dest->area->clan
    && dest->area->clan != ch->clan)
    {
        char_act( "Transportation failed.", ch );
        return;
    }

    if (!check_war_move (ch, dest, FALSE))
        return;

    // otherwise, gate character and possibly pet 
    // !!! may be, should transport lions etc with char
    if (ch->pet != NULL && ch->in_room == ch->pet->in_room)
        gate_pet = TRUE;
    else
        gate_pet = FALSE;

    // Allow gate w Forest Giant
    for (wch = ch->in_room->people; wch != NULL; wch = vch_next)
    {
        vch_next = wch->next_in_room;
        if (wch != ch && is_same_group(wch, ch))
        {
            if (IS_NPC(wch) && IS_AFFECTED(wch,AFF_CHARM) && wch->master == ch
            && (wch->pIndexData->vnum == MOB_VNUM_FOREST_GIANT
            || wch->pIndexData->vnum == MOB_VNUM_BEAR
            || wch->pIndexData->vnum == MOB_VNUM_WOLF))
            {
                char_from_room(wch);
                char_to_room(wch, dest);
            }
        }
    }

    // do the gate
    act_puts("$n steps into a tree and vanishes.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    char_act( "You step into a tree and vanish.", ch );
    char_from_room( ch );

    char_to_room( ch, dest );
    act_puts("$n has stepped out of a tree.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    do_look( ch, "auto" );

    if (gate_pet)
    {
        act( "$n steps into a tree and vanishes.", ch->pet, NULL, NULL, TO_ROOM );
        //char_act( "You step into a tree and vanish.\n", ch->pet );
        char_from_room( ch->pet );
        char_to_room( ch->pet, ch->in_room );
        act("$n has stepped out of a tree.", ch->pet, NULL, NULL, TO_ROOM);
        do_look( ch->pet, "auto" );
    }
    return;
}

SPELL_FUN(spell_hand_of_vengeance)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;
/* TODO: check need for clans
    if (clan_down(ch,CLAN_ENFORCER))
        return;
*/
    if (!IS_SET(victim->plr_flags,PLR_WANTED))
    {
        act("A huge clenched fist appears above $n but fades without striking.",victim,0,0,TO_ROOM);
        char_act("A huge clenched fist appears above you but fades without striking.",victim);
        char_act("The Immortal of Enforcer frowns upon the abuse of this power.",ch);
        return;
    }
    
    dam = dice(level,6) + dice(level,5);
    act("A huge clenched fist appears above $n and strikes down.",victim,0,0,TO_ROOM);
    char_act("A huge clenched fist appears above you and strikes down.",victim);
    if (saves_spell(level,victim,DAM_BASH))
            dam /= 2;
    
    if (number_range(0,3) == 0)
    {
        act("The blow hammers $n to the ground with savage force!",victim,0,0,TO_ROOM);
        char_act("The blow hammers you to the ground with savage force!",victim);
        dam += dice(level,4);
        WAIT_STATE(victim, 24);
    }
    
    damage(ch,victim,dam,sn,DAM_BASH,TRUE);
    
    return;
}

#define MOB_VNUM_BONES           13725

//void spell_flame_scorch(int sn, int level, CHAR_DATA *ch,void *vo,int target)
SPELL_FUN(spell_flame_scorch)
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    int dam, tmp_dam;

    act("$n strafes the room in a crossfire of searing blue-green fire!",ch,0,0,TO_ROOM);

    dam = dice(ch->level, 12);

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;
        
        if (is_safe(vch,ch))    continue;
        
        if (vch == ch)  continue;
        
        if (IS_NPC(vch) && vch->pIndexData->vnum == MOB_VNUM_BONES)
        {
            act("$n explodes into bits of shattered bone!",vch,0,0,TO_ROOM);
            extract_char(vch,TRUE);
        }
        else
        {
          if (saves_spell(level,vch,DAM_ENERGY))
               tmp_dam = dam/2;
          else 
               tmp_dam = dam;
          
          if (saves_spell(level +5, vch,DAM_ENERGY))
               tmp_dam  -= 50;
          
          damage(ch,vch,tmp_dam,sn,DAM_ENERGY,TRUE);
        }
    }

    return;
}

CHAR_DATA * create_standard_mob (CHAR_DATA * ch, int vnum, int slevel)
{
    MOB_INDEX_DATA * ind;
    CHAR_DATA      * mob;
    int              i;

    ind = get_mob_index(vnum);
    if (ind == NULL)
    {
        bug ("create_standard_mob: mob index doesn't exist", vnum);
        return NULL;
    }
    
    mob = create_mob (ind);

    for (i=0; i < MAX_STATS; i++)
    {
        mob->perm_stat[i] = ch->perm_stat[i];
    }

    mob->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : URANGE(ch->pcdata->perm_hit,ch->hit,30000);
    mob->hit = mob->max_hit;
    mob->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    mob->mana = mob->max_mana;
    mob->level = ch->level;
    mob->alignment = ch->alignment;
    mob->mob_tnl = 1600;

    for (i=0; i < 3; i++)
        mob->armor[i] = interpolate(mob->level,100,-100);
    mob->armor[3] = interpolate(mob->level,100,0);

    mob->gold = 0;
    mob->timer = 0;

    mob->damage[DICE_NUMBER] = number_range(slevel/15, slevel/10);
    mob->damage[DICE_TYPE] = number_range(slevel/3, slevel/2);
    mob->damage[DICE_BONUS] = number_range(slevel/8, slevel/2);
    mob->damroll = mob->damage[DICE_BONUS];

    char_to_room (mob,ch->in_room);
    SET_BIT(mob->affected_by, AFF_CHARM);
    mob->master = mob->leader = ch;

    return mob;
}

SPELL_FUN(spell_angel)
{
    CHAR_DATA   * gch;
    AFFECT_DATA   af;

    if (is_affected(ch,sn))
    {
        char_act("You feel too exhausted to pray one more time.", ch);
        return;
    }

    char_act("You ask the {CHEAVENS{x to send an {cangel{x to this world filled of sins.", ch);
    act("$n asks the {CHEAVENS{x to send an {cangel{x to this world filled of sins.",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch &&
            (gch->pIndexData->vnum == MOB_VNUM_ANGEL || gch->pIndexData->vnum == MOB_VNUM_ARCHON))
        {
            char_act("But the emissary of the Gods was already sent to you!", ch);
            return;
        }
    }

    if (create_standard_mob (ch, MOB_VNUM_ANGEL, level) == NULL)
        return;

    act ("An {Cangel{x was sent to bring the {Ygood{x to the Earth!", ch, NULL, NULL, TO_ALL);

    af.where              = TO_AFFECTS;
    af.type               = sn;
    af.level              = level;
    af.duration           = 24;
    af.bitvector          = 0;
    af.modifier           = 0;
    af.location           = APPLY_NONE;
    affect_to_char (ch, &af);
}

SPELL_FUN(spell_devil)
{
    CHAR_DATA      * gch;
    AFFECT_DATA      af;
    OBJ_DATA       * heart;

    if (is_affected (ch,sn))
    {
        char_act ("You feel too exhausted to pray one more time.", ch);
        return;
    }

    for (heart = ch->carrying ; heart != NULL ; heart = heart->next_content)
    {
        if (heart->pIndexData->vnum == OBJ_VNUM_TORN_HEART && heart->level >= ch->level)
            break; 
    }

    if (heart == NULL)
    {
        char_act("Proper ritual requires a torn heart of a powerful beast.", ch);
        return;
    }

    char_act ("You ask the {RDEMONS OF HELL{x to send a {rdevil{x to this world infested by the good.", ch);
    act ("$n asks the {RDEMONS OF HELL{x to send  a {rdevil{x to this world infested by the good.",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch &&
            (gch->pIndexData->vnum == MOB_VNUM_DEVIL || gch->pIndexData->vnum == MOB_VNUM_ARCHON))
        {
            char_act("But the emissary of the Gods was already sent to you!", ch);
            return;
        }
    }

    if (create_standard_mob (ch, MOB_VNUM_DEVIL, level) == NULL)
        return;

    act ("You use the heart filled by the POWER to call to the demons.",ch,heart,NULL,TO_CHAR);
    act ("$n uses the heart filled by the POWER to call to the demons.",ch,heart,NULL,TO_ROOM);
    extract_obj (heart);

    act ("A powerful {Rdevil{x was sent to bring the {rpain{x to the Earth!", ch, NULL, NULL, TO_ALL);

    af.where              = TO_AFFECTS;
    af.type               = sn;
    af.level              = level;
    af.duration           = 24;
    af.bitvector          = 0;
    af.modifier           = 0;
    af.location           = APPLY_NONE;
    affect_to_char (ch, &af);
}

SPELL_FUN(spell_squire)
{
    CHAR_DATA      * gch, *squire;
    AFFECT_DATA      af;

    if (is_affected (ch,sn))
    {
        char_act ("You feel too exhausted to sing one more time.", ch);
        return;
    }

    if (ch->in_room && ch->in_room->sector_type != SECT_CITY)
    {
        char_act ("But there are too few people here. Try to sing in the city.", ch);
        return;
    }


    char_act ("You start to sing a song about epic battle against evil.", ch);
    act ("$n starts to sing a song about epic battle against evil.",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch &&
            (gch->pIndexData->vnum == MOB_VNUM_SQUIRE))
        {
            char_act("But you already have a squire.", ch);
            return;
        }
    }

    if ((squire = create_standard_mob (ch, MOB_VNUM_SQUIRE, level)) == NULL)
        return;

    // Yes. He must be younger
    squire->level = ch->level - ch->level / 10;

    act ("Young man attracted by your song is ready to follow you!", ch, NULL, NULL, TO_CHAR);
    act ("Young man attracted by $n's song is ready to follow $gn{him}!", ch, NULL, NULL, TO_ROOM);

    af.where              = TO_AFFECTS;
    af.type               = sn;
    af.level              = level;
    af.duration           = 24;
    af.bitvector          = 0;
    af.modifier           = 0;
    af.location           = APPLY_NONE;
    affect_to_char (ch, &af);
}

SPELL_FUN(spell_mana_shield)
{
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        char_act("Your mystical shield fades away.", ch);
        affect_strip (ch, sn);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 10;
    af.location  = APPLY_SAVING_SPELL;
    af.modifier  = 5;
    af.bitvector = 0;
    affect_to_char(ch, &af);

    ch->mana -= ch->mana / 4;
    char_act("You use your mana to build mystical shield.", ch);
    return;
}

SPELL_FUN (spell_chaos_flare)
{
    CHAR_DATA  * victim = (CHAR_DATA *) vo;
    AFFECT_DATA  af;
    int          rnum;

    if (is_affected (victim, sn))
    {
        if (victim == ch)
	        char_act ("You are already touched by chaos.", ch);
        else
	        act ("$N's skin is already touched by chaos.", ch, NULL, victim,
	             TO_CHAR);
        return;
    }

    af.where = TO_AFFECTS;
    af.type = sn;
    af.level = level;
    af.duration = level / 3;

    rnum = number_percent ();

    if (rnum <= 5)
    {
        af.modifier = -30 - level / 5;
        af.location = APPLY_AC;
        af.bitvector = 0;
        affect_to_char (victim, &af);

        char_act ("Glinting scales form over your skin!", victim);
        if (ch != victim)
            act ("$N's skin is suddenly covered with metallic scales.", ch,
	            NULL, victim, TO_NOTVICT);
        return;
    }

    if (rnum <= 15)
    {
        af.modifier = level / 20;
        af.location = APPLY_DAMROLL;
        af.bitvector = 0;
        affect_to_char (victim, &af);

        char_act ("Sharp spikes jut out of your skin!", victim);
        if (ch != victim)
	        act ("$N's skin is suddenly covered with jagged spikes.", ch, NULL,
	            victim, TO_NOTVICT);
        return;
    }

    if (rnum <= 25)
    {
        af.modifier = level / 20;
        af.location = APPLY_HITROLL;
        af.bitvector = 0;
        affect_to_char (victim, &af);

        char_act ("Your eyes gleam.", victim);
        if (ch != victim)
	        act ("$N's eyes gleam.", ch, NULL, victim, TO_NOTVICT);
        return;
    }

    if (rnum <= 35)
    {
        af.modifier = level * 2;
        af.location = APPLY_MOVE;
        af.bitvector = 0;
        affect_to_char (victim, &af);

        char_act ("You suddenly grow an extra set of legs!", victim);
        if (ch != victim)
	    act ("$N suddenly grows an extra set of legs! Yipes!", ch, NULL,
	        victim, TO_NOTVICT);
        return;
    }

    if (rnum <= 45)
    {
        af.modifier = level / 20;
        af.location = APPLY_CON;
        af.bitvector = 0;
        affect_to_char (victim, &af);

        char_act ("You grow much tougher!", victim);
        if (ch != victim)
	        act ("$N seems much tougher all of a sudden.", ch, NULL, victim,
	            TO_NOTVICT);
        return;
    }

    if (rnum <= 50)
    {
        af.modifier = level / 4;
        af.location = APPLY_DAMROLL;
        af.bitvector = 0;
        affect_to_char (victim, &af);

        char_act ("{YA blaze of light surrounds you!{x", victim);
        if (ch != victim)
	        act ("{YA blazing halo surrounds $N!{x", ch, NULL, victim, TO_NOTVICT);
        return;
    }

    if (rnum <= 65)
    {
        af.modifier = 1 - level / 20;
        af.location = APPLY_DEX;
        af.bitvector = 0;
        affect_to_char (victim, &af);

        char_act ("One of your arms suddenly turns into a flipper.", victim);
        if (ch != victim)
	        act ("One of $N's arms turns into a.. dolphin flipper.", ch, NULL,
	            victim, TO_NOTVICT);
        return;
    }

    if (rnum <= 75)
    {
        af.modifier = 1 - level / 20;
        af.location = APPLY_INT;
        af.bitvector = 0;
        affect_to_char (victim, &af);

        char_act ("Me say wah? You suddenly feel very stoopid.", victim);
        if (ch != victim)
	        act ("$N is suddenly looking very stupid.", ch, NULL, victim,
	            TO_NOTVICT);
        return;
    }

    if (rnum <= 85)
    {
        af.modifier = level * 3;
        af.location = APPLY_HIT;
        af.bitvector = 0;
        affect_to_char (victim, &af);

        char_act ("You grow two sizes bigger!", victim);
        if (ch != victim)
	        act ("$N suddenly gets bigger.. and bigger.. and bigger.", ch,
	            NULL, victim, TO_NOTVICT);
        return;
    }

    if (rnum <= 95)
    {
        af.modifier = 1 + level * 2;
        af.location = APPLY_AC;
        af.bitvector = 0;
        affect_to_char (victim, &af);

        char_act ("You suddenly feel quite vulnerable. They're all out to get you!", victim);
        if (ch != victim)
	        act ("$N looks might paranoid all of a sudden.", ch, NULL, victim,
	            TO_NOTVICT);
        return;
    }

    if (rnum <= 100)
    {
        af.modifier = 1 - level;
        af.location = APPLY_DAMROLL;
        af.bitvector = 0;
        affect_to_char (victim, &af);
        
        char_act ("{cAck! You turn into an oozing gelatinous blob!", victim);
        if (ch != victim)
	        act ("{c$N's been turned into a green oozing blob!{x", ch, NULL,
	            victim, TO_NOTVICT);

        return;
    }
    return;
}

SPELL_FUN(spell_wander)
{
}

SPELL_FUN(spell_dark_armor)
{
    AFFECT_DATA af;

    if (!is_affected(ch, sn))
    {
        char_act("{Ddark{x aura surrounds you.", ch);
        act("{Ddark{x aura surrounds $n.", ch, NULL, NULL, TO_ROOM);

        af.where      = TO_RESIST;
        af.type       = sn;
        af.duration   = level / 10;
        af.level      = ch->level;
        af.bitvector  = DAM_HOLY;
        af.location   = APPLY_NONE;
        af.modifier   = 30;
        affect_to_char(ch, &af);
    } 
    else
        char_act("You are already surrounded by {Ddark{x aura.", ch);
    return;

}
