/* $Id: magic4.c,v 1.666 2004/09/20 10:49:50 shrike Exp $                           */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "merc.h"
#include "fight.h"
#include "quest.h"
#include "gquest.h"
#include "rating.h"
#include "fight.h"
#include "update.h"

SPELL_FUN(spell_acid_rain)
/* void spell_acid_rain( int sn, int level, CHAR_DATA *ch, void *vo,int target ) */
{
     CHAR_DATA *victim = (CHAR_DATA *) vo;
     int        dam,i;
     
     if (IS_AFFECTED(ch,AFF_FEAR))
     {
        char_act("You too scare to do this!", ch);
        return;
     }
             
     i=8;
          
     while (i > 0)
     {
          dam = number_range(level,8);
          if (saves_spell(level, victim, DAM_ACID))
             dam /= 2;
          if (victim->in_room == ch->in_room)
          {
               act("{R {G{g{G{g{G{g{G{g{G{g {B {g $n   $N!{x",ch,NULL,victim,TO_ROOM);
               act("{R {G{g{G{g{G{g{G{g{G{g {B {g  $N!{x",ch,NULL,victim,TO_CHAR); 
               damage( ch, victim, dam, sn, DAM_ACID,TRUE );
          }
          i--;
     }
     
     return;
}

void spell_prismatic_spray(int sn, int level, CHAR_DATA *ch, void *vo, int target ) 
{ 
     CHAR_DATA *victim = (CHAR_DATA *) vo; 
     int dam; 

     char_act( "        {R{Y{G{B{C{R{Y{G{B{G{Y{R {Y{R{Y{R{C{x.", ch ); 
     act( "$n  {R{Y{G{B{C{R{Y{G{B{G{Y{R {Y{R{Y{R{C{x   ", ch, NULL, NULL, TO_ROOM ); 
/*
     if (( ch->fighting == NULL ) && (!IS_NPC( ch )) && ( !IS_NPC( victim ) ))
     {
          ch->attacker = TRUE; 
          victim->attacker = FALSE; 
     }
*/
     dam = dice(70 + 20, 15); 

     spell_blindness(sn_lookup("blindness"), level,ch,(void *) victim,TARGET_CHAR); 
     damage( ch, victim, dam, sn, DAM_LIGHT,TRUE ); 

     dam = dice(70 + 20, 15); 

     spell_weaken(sn_lookup("weaken"), level,ch,(void *) victim,TARGET_CHAR); 
     damage( ch, victim, dam, sn, DAM_NEGATIVE,TRUE ); 

     dam = dice(70 + 20, 15); 

     cold_effect(victim,level,dam,TARGET_CHAR); 
     damage( ch, victim, dam, sn, DAM_COLD,TRUE ); 

     dam = dice(65 + 20, 15); 

     fire_effect(victim,level,dam,TARGET_CHAR); 
     damage( ch, victim, dam, sn, DAM_FIRE,TRUE ); 

     dam = dice(70 + 20, 15); 

     spell_poison(sn_lookup("poison"), level,ch,(void *) victim,TARGET_CHAR); 
     damage( ch, victim, dam, sn, DAM_POISON,TRUE ); 

     dam = dice(70 + 20, 15); 

     acid_effect(victim,level,dam,TARGET_CHAR); 
     damage( ch, victim, dam, sn, DAM_ACID,TRUE ); 

     dam = dice(70 + 20, 15); 

     shock_effect(victim,level,dam,TARGET_CHAR); 
     damage( ch, victim, dam, sn, DAM_LIGHTNING,TRUE ); 
     
     return; 
}

void spell_creeping_doom( int sn, int level, CHAR_DATA *ch, void *vo,int target )
{
     CHAR_DATA *vch;
     CHAR_DATA *vch_next;
     int dam;

     if (IS_SET(ch->in_room->room_flags, ROOM_NOMAGIC))
     {
          char_act( "   .", ch);
          return;
     }

     char_act( "   {G{x!", ch );
     act( "$n   {G{x!", ch, NULL, NULL, TO_ROOM );

     dam = dice(650 + 20, 15);
     // plague_effect( ch->in_room, level, dam, TARGET_ROOM );

     for (vch = char_list; vch != NULL; vch = vch_next)
     {
          vch_next    = vch->next;
          
          if (vch->in_room == NULL)
               continue;
          
          if (vch->in_room == ch->in_room)
          {
               if (vch != ch && !is_safe_spell(ch,vch,TRUE))
               {
/*                  if (( ch->fighting == NULL)  && (!IS_NPC(ch)) && (!IS_NPC( vch )))
                    {
                         ch->attacker = TRUE;
                         vch->attacker = FALSE;
                    }
*/
                    if (is_same_group(vch,ch))
                    {
                         continue;
                    }

                    if (saves_spell( level, vch, DAM_ENERGY ))
                    {
                          // plague_effect( vch, level/2, dam/4, TARGET_CHAR); //TODO: need added plague_effect
                         damage( ch, vch, dam, sn, DAM_ENERGY, TRUE ); 
                    } else
                    {
                         // plague_effect(vch, level, dam, TARGET_CHAR); 
                         damage(ch, vch, dam, sn, DAM_ENERGY, TRUE); 
                    }
               }
               
               continue;
          }

          if (vch->in_room->area == ch->in_room->area)
          char_act( "       .", vch );
     }
     
     return;
}

void spell_fire_storm(int sn, int level, CHAR_DATA *ch, void *vo, int target )
{
     CHAR_DATA *victim = (CHAR_DATA *) vo;
     int dam;

     char_act( "You call down a storm of fire!", ch );
     act( "$n calls down a storm of fire!", ch, NULL, NULL, TO_ROOM );
/*
     if (( ch->fighting == NULL)  && (!IS_NPC( ch )) && ( !IS_NPC( victim )))
     {
          ch->attacker = TRUE;
          victim->attacker = FALSE;
     }
*/
     dam = dice(240 + 20, 20);

     spell_plague(sn_lookup("plague"), level,ch,(void *) victim,TARGET_CHAR);
     damage( ch, victim, dam, sn, DAM_FIRE,TRUE );

     dam = dice(225 + 20, 20);

     spell_plague(sn_lookup("plague"), level,ch,(void *) victim,TARGET_CHAR);
     damage( ch, victim, dam, sn, DAM_FIRE,TRUE );

     dam = dice(215 + 20, 20);

     damage( ch, victim, dam, sn, DAM_FIRE,TRUE );

     dam = dice(210 + 20, 20);

     damage( ch, victim, dam, sn, DAM_FIRE,TRUE );
     return;
}

void spell_moon_blade(int sn, int level, CHAR_DATA *ch, void *vo, int target )
{
     CHAR_DATA *victim = (CHAR_DATA *) vo;
     int dam;

     char_act( "You call upon the power of the moon!", ch );
/*
     if (( ch->fighting == NULL) && (!IS_NPC(ch)) && (!IS_NPC( victim )))
     {
          ch->attacker = TRUE;
          victim->attacker = FALSE;
     }
*/
     dam = dice(120 + 20, 20);

     spell_slow(sn_lookup("slow"), level,ch,(void *) victim,TARGET_CHAR);
     damage( ch, victim, dam, sn, DAM_HOLY,TRUE );

     dam = dice(120 + 20, 20);

     spell_blindness(sn_lookup("blindness"), level,ch,(void *) victim,TARGET_CHAR);
     damage( ch, victim, dam, sn, DAM_ENERGY,TRUE );
     return;
}

void spell_whirlwind(int sn, int level, CHAR_DATA *ch, void *vo, int target )
{
     CHAR_DATA *victim = (CHAR_DATA *) vo;
     int dam;
     int chance;

     chance = number_range( 1, 100);

     char_act( "    {C {x!", ch );
     act( "$n  {C {x!", ch, NULL, NULL, TO_ROOM );
/*
     if ((ch->fighting == NULL) && (!IS_NPC(ch)) && (!IS_NPC(victim)))
     {
          ch->attacker = TRUE;
          victim->attacker = FALSE;
     }
*/
     dam = dice(90 + 20, 20);

     spell_blindness(sn_lookup("blindness"), level,ch,(void *) victim,TARGET_CHAR);
     damage( ch, victim, dam, sn, DAM_SOUND,TRUE );

     if (chance > 25)
     {
               return;
     }
     dam = dice(110 + 20, 20);

     damage( ch, victim, dam, sn, DAM_SOUND,TRUE );
     char_act( "     .", victim );
     
     //  victim->stunned = 3;
     
     return;
}

void spell_thunder_staff( int sn, int level, CHAR_DATA *ch, void *vo,int target )
{
     CHAR_DATA *vch;
     CHAR_DATA *vch_next;
     int dam;

     if (IS_SET(ch->in_room->room_flags, ROOM_NOMAGIC))
     {
               char_act( "Your magic fizzles and dies.", ch);
               return;
     }

     char_act( "You call forth lightning from the heavens!", ch );
     act( "$n calls forth lightning from the heavens!", ch, NULL, NULL, TO_ROOM );

     dam = dice(195 + 20, 20);
     shock_effect( ch->in_room, level, dam, TARGET_ROOM );

     for (vch = char_list; vch != NULL; vch = vch_next)
     {
          vch_next    = vch->next;
          if (vch->in_room == NULL)
               continue;
          if (vch->in_room == ch->in_room)
          {
               if (vch != ch && !is_safe_spell(ch,vch,TRUE))
               {
                    if (is_same_group(vch,ch))
                    {
                         continue;
                    }
                    
                    if (saves_spell( level, vch, DAM_LIGHTNING ))
                    {
                              shock_effect( vch, level/2, dam/4, TARGET_CHAR );
                              damage( ch, vch, dam, sn, DAM_LIGHTNING, TRUE ); // damage_old in original
                    } else
                    {
                              shock_effect( vch, level, dam, TARGET_CHAR );
                              damage( ch, vch, dam, sn, DAM_LIGHTNING, TRUE ); // damage_old in original
                    }
               }
          }
     }
     return;
}

void spell_shadow_shield( int sn, int level, CHAR_DATA *ch, void *vo, int 
                                                  target ) 
{ 
     CHAR_DATA *victim = (CHAR_DATA *) vo; 
     AFFECT_DATA af; 

     if (is_affected( victim, sn ))
     {
          if (victim == ch)
               char_act("You are already protected.",ch);
          else
               act("$N is already protected.",ch,NULL,victim,TO_CHAR); 
          return; 
     }

     af.where     = TO_IMMUNE; 
     af.type      = sn; 
     af.level     = level; 
     af.duration  = 2; 
     af.location  = APPLY_NONE; 
     af.modifier  = 0; 
     af.bitvector = IMM_NEGATIVE; 
     affect_to_char( victim, &af ); 
     act( "$n is surrounded by shifting shadows.", victim, NULL, NULL, TO_ROOM ); 
     char_act( "You become surrounded by shifting shadows.", victim); 
     return; 
} 

void spell_dark_gift( int sn, int level, CHAR_DATA *ch, void *vo, int target) 
{ 
     CHAR_DATA *victim = (CHAR_DATA *) vo; 
     AFFECT_DATA af; 

     if (is_affected( victim, sn ))
     {
          if (victim == ch)
               char_act("You are already affected by the dark gift.",ch);
          else
               act("$N is already gifted.",ch,NULL,victim,TO_CHAR); 
          return; 

     }
     af.where     = TO_AFFECTS; 
     af.type      = sn; 
     af.level     = level; 
     af.duration  = 12; 
     af.bitvector = 0; 

     af.location  = APPLY_DAMROLL; 
     af.modifier  = level / 4; 
     affect_to_char( victim, &af ); 

     af.location  = APPLY_HITROLL; 
     af.modifier  = level / 4; 
     affect_to_char( victim, &af ); 


     af.location  = APPLY_AC; 
     af.modifier  = 0 - level; 
     affect_to_char( victim, &af ); 

     char_act( "You beg the dark powers to protect you.", victim ); 
     if (ch != victim)
          act("$N is protected by the dark powers.",ch,NULL,victim,TO_CHAR);

     char_act("The dark powers take there toll on you.",ch); 
     ch->hit -= 300; 

     return; 
} 

void spell_blade_bless( int sn, int level, CHAR_DATA *ch, void *vo,int target) 
{ 
     OBJ_DATA *obj; 
     AFFECT_DATA af; 

     if (IS_SET(ch->in_room->room_flags, ROOM_NOMAGIC))
     {
          char_act( "Your magic fizzles and dies.", ch); 
          return; 
     }

     if (target == TARGET_OBJ)
     {
     obj = (OBJ_DATA *) vo; 
     if (IS_OBJ_STAT(obj,ITEM_BLESS))
     {
          act("$p is already blessed.",ch,obj,NULL,TO_CHAR); 
          return; 
     }

     if (IS_OBJ_STAT(obj,ITEM_EVIL))
     {
          AFFECT_DATA *paf; 

          paf = affect_find(obj->affected,gsn_curse); 
          if (!saves_dispel(level,paf != NULL ? paf->level : obj->level,0))
          {
               if (paf != NULL)
                    affect_remove_obj(obj,paf);
               act("$p glows soft gold.",ch,obj,NULL,TO_ALL); 
               REMOVE_BIT(obj->extra_flags,ITEM_EVIL); 
               return; 
          } else
          {
               act("The evil of $p resists your blessings.", ch,obj,NULL,TO_CHAR); 
               return; 
          } 
          }

          af.where    = TO_OBJECT; 
          af.type       = sn; 
          af.level    = level; 
          af.duration    = 25; 
          af.bitvector    = ITEM_BLESS; 

          af.location    = APPLY_HITROLL; 
          af.modifier    = 20; 
          affect_to_obj(obj,&af); 

          af.location    = APPLY_DAMROLL; 
          af.modifier    = 20; 
          affect_to_obj(obj,&af); 

          act("$p glows a brilliant gold!",ch,obj,NULL,TO_ALL); 
          return; 
     }
}

void spell_revitalize( int sn, int level, CHAR_DATA *ch, void *vo, int target )
{
     CHAR_DATA *victim = (CHAR_DATA *) vo;


     if (ch->fighting != NULL)
     {
          char_act("You are too occupied to revitalize anyone.",ch);
          return;
     }

     if (victim->fighting != NULL)
     {
          char_act("You cannot revitalize someone in combat!",ch);
          return;
     }

     if (victim->hit >= victim->max_hit)
     {
          char_act("That would be pointless..",ch);
          return;
     }

     char_act( "Godly essence flows through your body knitting your wounds!", victim );
     char_act( "You call divine power to heal!",ch);

     affect_strip(victim,gsn_plague);
     affect_strip(victim,gsn_poison);
     affect_strip(victim,gsn_weaken);
     affect_strip(victim,gsn_blindness);
     affect_strip(victim,gsn_sleep);
     affect_strip(victim,gsn_curse);

     victim->hit        = victim->max_hit;
     victim->move       = victim->max_move;
     update_pos(victim);

     return;
}

void spell_natures_fury(int sn, int level, CHAR_DATA *ch, void *vo, int target )
{
     CHAR_DATA *victim = (CHAR_DATA *) vo;
     int dam;

     char_act( "You call upon the fury of the elements!", ch );
     act( "$n calls upon the fury of the elements!", ch, NULL, NULL, TO_ROOM );
/*
     if (( ch->fighting == NULL )  && ( !IS_NPC( ch ) ) && ( !IS_NPC( victim ) ))
     {
     ch->attacker = TRUE;
     victim->attacker = FALSE;

     }
*/
     dam = dice(225 + 20, 20);
     fire_effect(victim,level,dam,TARGET_CHAR);
     damage( ch, victim, dam, sn, DAM_FIRE,TRUE );

     dam = dice(225 + 20, 20);
     shock_effect(victim,level,dam,TARGET_CHAR);
     damage( ch, victim, dam, sn, DAM_LIGHTNING,TRUE );

     dam = dice(225 + 20, 20);
     cold_effect(victim,level,dam,TARGET_CHAR);
     damage( ch, victim, dam, sn, DAM_COLD,TRUE );

     dam = dice(225 + 20, 20);

     damage( ch, victim, dam, sn, DAM_BASH,TRUE );
     return;
}

void spell_natures_boon( int sn, int level, CHAR_DATA *ch, void *vo, int target )
{
     CHAR_DATA *victim = (CHAR_DATA *) vo;
     AFFECT_DATA af;

     if (is_affected( victim, sn ))
     {
          if (victim == ch)
               char_act("You are already gifted by nature.",ch);
          else
               act("$N is already protected.",ch,NULL,victim,TO_CHAR);
          return;
     }

     af.where     = TO_RESIST;
     af.type      = sn;
     af.level     = level;
     af.duration  = 6;     

     af.location  = APPLY_NONE;
     af.modifier  = 0;
     af.bitvector = RES_FIRE;
     affect_to_char( victim, &af );

     af.location  = APPLY_SAVES;
     af.modifier  = 0 - level / 6;
     affect_to_char( victim, &af );

     af.location  = APPLY_NONE;
     af.modifier  = 0;
     af.bitvector = RES_LIGHTNING;
     affect_to_char( victim, &af );
     
     act( "$n calls upon natures essence to protect them.", victim, NULL, NULL, TO_ROOM );
     char_act( "You beg for natures protection.", victim );
     
     return;
}

void spell_mind_shatter( int sn, int level, CHAR_DATA *ch, void *vo, int target )
{
     CHAR_DATA *victim = (CHAR_DATA *) vo;
     AFFECT_DATA af;

     if (is_affected( victim, sn ))
     {
          if (victim == ch)
               char_act("Your mind is already broken.",ch);
          else
               act("$N is already reeling.",ch,NULL,victim,TO_CHAR);
          return;

     }
     af.where     = TO_RESIST;
     af.type      = sn;
     af.level     = level;
     af.duration  = 1;
     af.location  = APPLY_NONE;
     af.modifier  = 0;     
     af.bitvector = DAM_MAGIC;
     affect_to_char( victim, &af );

     af.where     = TO_RESIST;
     af.type      = sn;
     af.level     = level;
     af.duration  = 1;
     af.location  = APPLY_NONE;
     af.modifier  = 0;
     af.bitvector = DAM_BASH;
     affect_to_char( victim, &af );

     af.where     = TO_AFFECTS;
     af.type      = sn;
     af.level     = level;
     af.duration  = 1;
     af.location  = APPLY_SAVING_SPELL;
     af.modifier  = 25;
     af.bitvector = 0;
     affect_to_char( victim, &af );

     af.where     = TO_AFFECTS;
     af.type      = sn;
     af.level     = level;
     af.duration  = 1;
     af.location  = APPLY_AC;
     af.modifier  = 100;
     af.bitvector = 0;
     affect_to_char( victim, &af );

     char_act( "Your mind begins to tear apart!.", victim );
     if (ch != victim)
          act("$N's mind begins to tear apart!",ch,NULL,victim,TO_CHAR);
     return;
}
/*
void spell_holy_mace(int sn,int level,CHAR_DATA *ch,void *vo,int target)
{
        OBJ_DATA *mace;
        AFFECT_DATA *pAf;

        // Make the mace, and have it decay after time 

        mace = create_object( get_obj_index( OBJ_VNUM_MACE ), 0 );
        mace->timer = level / 3;

        // Add the hitroll based on level 
        pAf             =   new_affect();
        pAf->location   =   APPLY_HITROLL;
        pAf->modifier   =   (ch->level / 5);
        pAf->where            =   TO_OBJECT;
        pAf->type       =   -1;
        pAf->duration   =   -1;
        pAf->bitvector  =   0;
        pAf->level      =        mace->level;
        pAf->next       =   mace->affected;
        mace->affected  =   pAf;
        mace->level     =   level;

        // Now for the level based damage roll 
        pAf             =   new_affect();
        pAf->location   =   APPLY_DAMROLL;
        pAf->modifier   =   (ch->level / 5);
        pAf->where            =   TO_OBJECT;
        pAf->type       =   -1;
        pAf->duration   =   -1;
        pAf->bitvector  =   0;
        pAf->level      =        mace->level;
        pAf->next       =   mace->affected;
        mace->affected  =   pAf;
        mace->level     =   level;

        // Now for the Hitpoints of the weapon 
        pAf             =   new_affect();
        pAf->location   =   APPLY_HIT;
        pAf->modifier   =   (ch->level * 2);
        pAf->where            =   TO_OBJECT;
        pAf->type       =   -1;
        pAf->duration   =   -1;
        pAf->bitvector  =   0;
        pAf->level      =        mace->level;
        pAf->next       =   mace->affected;
        mace->affected  =   pAf;
        mace->level     =   level;

        // Now for the weapons mana bonus 
        pAf             =   new_affect();
        pAf->location   =   APPLY_MANA;
        pAf->modifier   =   (ch->level * 2);
        pAf->where            =   TO_OBJECT;
        pAf->type       =   -1;
        pAf->duration   =   -1;
        pAf->bitvector  =   0;
        pAf->level      =        mace->level;
        pAf->next       =   mace->affected;
        mace->affected  =   pAf;
        mace->level     =   level;

        // Now add the damage dice of the weapon, this created a weapon average 120 at hero 
        mace->value[1] = level / 5 - 5;
        mace->value[2] = level / 5 - 5;
        obj_to_char(mace, ch);
   
        // Now drain the caster of Hp and mana 

        char_act("You attempt to form a holy mace.",ch);
        char_act("You feel weak, perhaps you should rest.",ch);
        act( "$n constructs a divine weapon.", ch, mace, NULL, TO_ROOM );
        ch->hit   *= .75;
        ch->move  *= .50;
        return;
}
*/

/*
void spell_fear( int sn, int level, CHAR_DATA *ch, void *vo,int target )
{
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        AFFECT_DATA af;

        if ( is_affected( victim, sn ) )
        {
                char_act( "You failed.", ch );
        return;
        }

        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = 2;
        af.location  = APPLY_HITROLL;
        af.modifier  = -1 * (level / 10);
        af.bitvector = 0;
        affect_to_char(victim, &af);
        
        af.location  = APPLY_DAMROLL;
        af.modifier  = -1 * (level/10);
        affect_to_char( victim, &af );
        char_act( "You are {6overcome{0 with {5fear{0.", victim );
        act("$n looks {6scared{0 and {5cowers{0 in terror.",victim,NULL,NULL,TO_ROOM);
        do_flee( victim, "" );   
        return;
}
*/
/*
void spell_divine_protection( int sn, int level, CHAR_DATA *ch, void *vo, int target )
{
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        AFFECT_DATA af;

        if ( is_affected( victim, sn ) )
        {
        if (victim == ch)
          char_act("You are already protected.",ch);
        else
          act("$N is already protected.",ch,NULL,victim,TO_CHAR);
        return;

        }
        af.where         = TO_AFFECTS;
        af.type      = sn;
        af.level         = level;
        af.duration  = 7;     
        af.bitvector = AFF_DIVINE_PROTECTION;

        af.location  = APPLY_DAMROLL;
        af.modifier  = level / 7;
        affect_to_char( victim, &af );

        af.location  = APPLY_HITROLL;
        af.modifier  = level / 7;
        affect_to_char( victim, &af );

        af.location  = APPLY_SAVES;
        af.modifier  = 0 - level / 7;
        affect_to_char( victim, &af );

        af.location  = APPLY_AC;
        af.modifier  = 0 - level;
        affect_to_char( victim, &af );

        char_act( "The very essense of the gods protects you!", victim );
        if ( ch != victim )
        act("$N is protected by your gods.",ch,NULL,victim,TO_CHAR);
        return;
}
*/

/* Spell from dystopia MUD */


// void spell_godbless( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) ) return;
//     af.type      = sn;
//     af.duration  = 150;
//     af.location  = APPLY_HITROLL;
//     af.modifier  = 150;
//     af.bitvector = 0;
//     affect_to_char( victim, &af );
// 
//     af.location  = APPLY_SAVING_SPELL;
//     af.modifier  = 0 - 150;
//     affect_to_char( victim, &af );
// 
//     af.location  = APPLY_DAMROLL;
//     af.modifier  = 150;
//     affect_to_char( victim, &af );
//     act( "$n is filled with God's Blessing.", victim, NULL, NULL, TO_ROOM );
//     send_to_char( "You are filled with God's Blessing.\n\r", victim );
//     return;
// }

// void spell_spew( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//     CHAR_DATA *vch;
//     CHAR_DATA *vch_next;
//     int dam;
//  
//     for ( vch = ch->in_room->people; vch != NULL; vch = vch_next )
//     {
//               vch_next = vch->next_in_room;
//         if (vch->trust>6) continue;
//         if (IS_NPC(vch)) dam=250*level;
//         if (!IS_NPC(vch)) dam=100*level;
//         if (is_safe(ch,vch)==TRUE) break;
//         damage( ch, vch, dam, sn );
//       
//     }
//     return;
// }

// void spell_infirmity( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( IS_AFFECTED(victim, AFF_INFIRMITY) )
// {
//         act("A look of concentration passes over $n's face.",ch,NULL,NULL,TO_ROOM);
//         send_to_char("A look of concentration passes over your face.\n\r",ch);
//         send_to_char("They are already weak.\n\r",ch);
//            return;
// } 
//     af.type      = sn;
//     af.duration  = level;
//     af.location  = APPLY_DEX;
//     af.modifier  = 0 - level;
//     af.bitvector = AFF_INFIRMITY;
//     affect_to_char( victim, &af );
// 
//     af.type      = sn;
//     af.duration  = level;
//     af.location  = APPLY_STR;
//     af.modifier  = 0 - level;
//     af.bitvector = AFF_INFIRMITY;
//     affect_to_char( victim, &af );
// 
//     af.type      = sn;
//     af.duration  = level;
//     af.location  = APPLY_WIS;
//     af.modifier  = 0 - level;
//     af.bitvector = AFF_INFIRMITY;
//     affect_to_char( victim, &af );
// 
//     af.type      = sn;
//     af.duration  = level;
//     af.location  = APPLY_CON;
//     af.modifier  = 0 - level;
//     af.bitvector = AFF_INFIRMITY;
//     affect_to_char( victim, &af );
// 
//     af.type      = sn;
//     af.duration  = level;
//     af.location  = APPLY_INT;
//     af.modifier  = 0 - level;
//     af.bitvector = AFF_INFIRMITY;
//     affect_to_char( victim, &af );
// 
//     af.type      = sn;
//     af.duration  = level;
//     af.location  = APPLY_DAMROLL;
//     af.modifier  = 0 - level;
//     af.bitvector = AFF_INFIRMITY;
//     affect_to_char( victim, &af );
// 
//     af.type      = sn;
//     af.duration  = level;
//     af.location  = APPLY_HITROLL;
//     af.modifier  = 0 - level;
//     af.bitvector = AFF_INFIRMITY;
//     affect_to_char( victim, &af );
//     send_to_char("A look of concentration passes over your face.\n\r",ch);
//     act("A look of concentration passes over $n's face.",ch,NULL,NULL,TO_ROOM);
//     send_to_char( "You feel weaker.\n\r", victim );
//     send_to_char( "You feel slower.\n\r", victim );
//     send_to_char( "You feel less healthy.\n\r", victim );
//     act( "$n looks weaker.", victim, NULL, NULL, TO_ROOM );
//     act( "$n looks slower.", victim, NULL, NULL, TO_ROOM );
//     act( "$n looks less healthy.",victim,NULL,NULL, TO_ROOM);
//     return;
// }


/*
 * Spell for mega1.are from Glop/Erkenbrand.
 */

// void spell_general_purpose( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 25, 100 );
//     if ( saves_spell( level, victim ) )
//         dam /= 2;
//     damage( ch, victim, dam, sn );
//     return;
// }

/*
 * Spell for mega1.are from Glop/Erkenbrand.
 */

// void spell_high_explosive( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
//         return;
//     dam = dice( level, 150 );
//     if ( saves_spell( level, victim ) ) dam *= 0.5;
//     damage( ch, victim, dam, sn );
//     return; 
// }

// void spell_protection( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( IS_AFFECTED(victim, AFF_PROTECT) )
//         return;
//     if (!IS_GOOD(victim))
//     {
//       send_to_char("The spell fails.\n\r",ch);
//       return;
//     }
//     af.type      = sn;
//     af.duration  = 24;
//     af.location  = APPLY_NONE;
//     af.modifier  = 0;
//     af.bitvector = AFF_PROTECT;
//     affect_to_char( victim, &af );
//     send_to_char( "You feel protected.\n\r", victim );
//     if ( ch != victim )
//         send_to_char( "Ok.\n\r", ch );
//     return;
// }



// void spell_soulblade( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//     OBJ_DATA    *obj = (OBJ_DATA *) vo;
//     char buf     [MAX_STRING_LENGTH];
//     char wpnname [MAX_INPUT_LENGTH];
//     int weapontype = 3;
// 
//     obj = create_object( get_obj_index( OBJ_VNUM_SOULBLADE ), 0 );
// 
//     if (ch->wpn[1]  > ch->wpn[weapontype])
//         {weapontype = 1;strcpy(wpnname,"blade");}
//     if (ch->wpn[2]  > ch->wpn[weapontype])
//         {weapontype = 2;strcpy(wpnname,"blade");}
//     if (ch->wpn[4]  > ch->wpn[weapontype])
//         {weapontype = 4;strcpy(wpnname,"whip");}
//     if (ch->wpn[5]  > ch->wpn[weapontype])
//         {weapontype = 5;strcpy(wpnname,"claw");}
//     if (ch->wpn[6]  > ch->wpn[weapontype])
//         {weapontype = 6;strcpy(wpnname,"blaster");}
//     if (ch->wpn[7]  > ch->wpn[weapontype])
//         {weapontype = 7;strcpy(wpnname,"mace");}
//     if (ch->wpn[8]  > ch->wpn[weapontype])
//         {weapontype = 8;strcpy(wpnname,"mace");}
//     if (ch->wpn[9]  > ch->wpn[weapontype])
//         {weapontype = 9;strcpy(wpnname,"grepper");}
//     if (ch->wpn[10] > ch->wpn[weapontype])
//         {weapontype = 10;strcpy(wpnname,"fang");}
//     if (ch->wpn[11] > ch->wpn[weapontype])
//         {weapontype = 11;strcpy(wpnname,"blade");}
//     if (ch->wpn[12] > ch->wpn[weapontype])
//         {weapontype = 12;strcpy(wpnname,"sucker");}
//     if (weapontype == 3) strcpy(wpnname,"blade");
//     /* First we name the weapon */
//     free_string(obj->name);
//     sprintf(buf,"%s soul %s",ch->name,wpnname);
//     obj->name=str_dup(buf);
//     free_string(obj->short_descr);
//     if (IS_NPC(ch)) sprintf(buf,"%s's soul %s",ch->short_descr,wpnname);
//     else sprintf(buf,"%s's soul %s",ch->pcdata->switchname,wpnname);
//     buf[0] = UPPER(buf[0]);
//     obj->short_descr=str_dup(buf);
//     free_string(obj->description);
//     if (IS_NPC(ch)) sprintf(buf,"%s's soul %s is lying here.",ch->short_descr,wpnname);
//     else sprintf(buf,"%s's soul %s is lying here.",ch->name,wpnname);
//     buf[0] = UPPER(buf[0]);
//     obj->description=str_dup(buf);
// 
//     if (IS_NPC(ch)) obj->level = ch->level;
//     else if (ch->spl[2] > 4) obj->level = ch->spl[2]/4;
//     else obj->level = 1;
//     if (obj->level > 60) obj->level = 60;
//     obj->value[0] = 13034;
//     obj->value[1] = 10;
//     obj->value[2] = 20;
//     obj->value[3] = weapontype;
//     if (obj->questmaker != NULL) free_string(obj->questmaker);
//     obj->questmaker = str_dup(ch->name);
//     if (!IS_NPC(ch))
//     {
//         if (obj->questowner != NULL) free_string(obj->questowner);
//         obj->questowner = str_dup(ch->pcdata->switchname);
//     }
//     obj_to_char(obj,ch);
//     act("$p fades into existance in your hand.", ch, obj, NULL, TO_CHAR);
//     act("$p fades into existance in $n's hand.", ch, obj, NULL, TO_ROOM);
//     return;
// }

// void spell_darkblessing( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//     CHAR_DATA  *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) ) return;
// 
//     af.type      = sn;
//     af.duration  = level / 2;
//     af.location  = APPLY_HITROLL;
//     af.modifier  = 1 + level / 14;
//     af.bitvector = 0;
//     affect_to_char( victim, &af );
//     af.location  = APPLY_DAMROLL;
//     af.modifier  = 1 + level / 14;
//     affect_to_char( victim, &af );
// 
//     if ( ch != victim )
//         send_to_char( "Ok.\n\r", ch );
//     act( "$n looks wicked.", victim, NULL, NULL, TO_ROOM );
//     send_to_char( "You feel wicked.\n\r", victim );
//     return;
// }

// void spell_energyflux( int sn, int level, CHAR_DATA *ch, void *vo)
// {
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
// 
//     victim->mana = UMIN( victim->mana + 50, victim->max_mana);
//     update_pos(victim);
//     send_to_char("You feel mana channel into your body.\n\r",victim);
//     return;
// }

// void spell_voodoo( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     OBJ_DATA  *obj;
//     char       buf [MAX_INPUT_LENGTH];
//     char       arg [MAX_INPUT_LENGTH];
//     char     part1 [MAX_INPUT_LENGTH];
//     char     part2 [MAX_INPUT_LENGTH];
//     int       worn;
// 
//     one_argument( target_name, arg );
// 
//     victim = get_char_world( ch, arg );
// 
//     if (ch->practice < 5)
//     {
//         send_to_char( "It costs 5 points of primal energy to create a voodoo doll.\n\r", ch );
//         return;
//     }
// 
//     if ( ( victim = get_char_world( ch, target_name ) ) == NULL )
//     {
//         send_to_char( "Nobody by that name is playing.\n\r", ch );
//         return;
//     }
// 
//     if ( ( obj = get_eq_char( ch, WEAR_WIELD ) ) == NULL )
//     {
//             if ( ( obj = get_eq_char( ch, WEAR_HOLD ) ) == NULL )
//         {
//             send_to_char( "You are not holding any body parts.\n\r", ch );
//             return;
//         }
//         else worn = WEAR_HOLD;
//     }
//     else worn = WEAR_WIELD;
// 
//     if (obj->questmaker != NULL && strlen(obj->questmaker) > 1)
//     {
//         send_to_char( "You cannot use that item.\n\r", ch );
//         return;
//     }
// 
//     if ( IS_NPC(victim) )
//     {
//         send_to_char( "Not on NPC's.\n\r", ch );
//         return;
//     }
// 
//     if      (obj->value[2] == 12) sprintf(part1,"head %s",victim->name);
//     else if (obj->value[2] == 13) sprintf(part1,"heart %s",victim->name);
//     else if (obj->value[2] == 14) sprintf(part1,"arm %s",victim->name);
//     else if (obj->value[2] == 15) sprintf(part1,"leg %s",victim->name);
//     else if (obj->value[2] == 30004) sprintf(part1,"entrails %s",victim->name);
//     else if (obj->value[2] == 30005) sprintf(part1,"brain %s",victim->name);
//     else if (obj->value[2] == 30006) sprintf(part1,"eye eyeball %s",victim->name);
//     else if (obj->value[2] == 30012) sprintf(part1,"face %s",victim->name);
//     else if (obj->value[2] == 30013) sprintf(part1,"windpipe %s",victim->name);
//     else if (obj->value[2] == 30014) sprintf(part1,"cracked head %s",victim->name);
//     else if (obj->value[2] == 30025) sprintf(part1,"ear %s",victim->name);
//     else if (obj->value[2] == 30026) sprintf(part1,"nose %s",victim->name);
//     else if (obj->value[2] == 30027) sprintf(part1,"tooth %s",victim->name);
//     else if (obj->value[2] == 30028) sprintf(part1,"tongue %s",victim->name);
//     else if (obj->value[2] == 30029) sprintf(part1,"hand %s",victim->name);
//     else if (obj->value[2] == 30030) sprintf(part1,"foot %s",victim->name);
//     else if (obj->value[2] == 30031) sprintf(part1,"thumb %s",victim->name);
//     else if (obj->value[2] == 30032) sprintf(part1,"index finger %s",victim->name);
//     else if (obj->value[2] == 30033) sprintf(part1,"middle finger %s",victim->name);
//     else if (obj->value[2] == 30034) sprintf(part1,"ring finger %s",victim->name);
//     else if (obj->value[2] == 30035) sprintf(part1,"little finger %s",victim->name);
//     else if (obj->value[2] == 30036) sprintf(part1,"toe %s",victim->name);
//     else
//     {
//         sprintf(buf,"%s isn't a part of %s!\n\r",obj->name,victim->name);
//         send_to_char( buf, ch );
//         return;
//     }
// 
//     sprintf(part2,obj->name);
// 
//     if ( str_cmp(part1,part2) )
//     {
//         sprintf(buf,"But you are holding %s, not %s!\n\r",obj->short_descr,victim->name);
//         send_to_char( buf, ch );
//         return;
//     }
// 
//     act("$p vanishes from your hand in a puff of smoke.", ch, obj, NULL, TO_CHAR);
//     act("$p vanishes from $n's hand in a puff of smoke.", ch, obj, NULL, TO_ROOM);
//     obj_from_char(obj);
//     extract_obj(obj);
// 
//     obj = create_object( get_obj_index( OBJ_VNUM_VOODOO_DOLL ), 0 );
// 
//     sprintf(buf,"%s voodoo doll",victim->name);
//     free_string(obj->name);
//     obj->name=str_dup(buf);
// 
//     sprintf(buf,"a voodoo doll of %s",victim->name);
//     free_string(obj->short_descr);
//     obj->short_descr=str_dup(buf);
// 
//     sprintf(buf,"A voodoo doll of %s lies here.",victim->name);
//     free_string(obj->description);
//     obj->description=str_dup(buf);
// 
//     obj_to_char(obj,ch);
//     equip_char(ch,obj,worn);
// 
//     act("$p appears in your hand.", ch, obj, NULL, TO_CHAR);
//     act("$p appears in $n's hand.", ch, obj, NULL, TO_ROOM);
// 
//     ch->practice -= 5;
// 
//     return;
// }

/*void spell_chaos_blast( int sn, int level, CHAR_DATA *ch, void *vo )
{
        CHAR_DATA *victim = (CHAR_DATA *) vo;
        int dam;

        if (IS_ITEMAFF(victim, ITEMA_CHAOSSHIELD)) return;
        dam = dice( level, 150 );
        if ( saves_spell( level, victim ) ) dam *= 0.5;
        if (IS_AFFECTED(ch, AFF_SANCTUARY) ) dam *= 0.5;
        if (IS_ITEMAFF(ch, ITEMA_CHAOSSHIELD)) dam *= 0.75;
        if (!IS_NPC(ch)) dam *= 0.5;
        if (IS_NPC(victim) && dam >= victim->hit) dam = victim->hit-1;
        if (dam==0) return;
        damage( ch, victim, dam, sn );
        return;
} */ 
  
// void spell_drowfire( int sn, int level, CHAR_DATA *ch, void *vo) {
//         CHAR_DATA *victim = (CHAR_DATA *) vo;
//         AFFECT_DATA af1;
//         AFFECT_DATA af2;
//         AFFECT_DATA af3;
// 
//         act("You chant some arcane words on $N.",ch,NULL,victim,TO_CHAR);
//         act("$n chants some arcane words on $N.",ch,NULL,victim,TO_NOTVICT);
//         act("$n chants some arcane words on you.",ch,NULL,victim,TO_VICT);
// 
//         if (IS_AFFECTED(victim, AFF_DROWFIRE)) {
//                 send_to_char("They are already affected by drowfire.\n\r",ch);
//                 return;}
//         if (is_safe(ch, victim)) return;
// 
//         af1.type        = sn;
//         af1.location        = APPLY_AC;
//         af1.modifier        = 200;
//         af1.duration        = 2;
//         af1.bitvector        = AFF_DROWFIRE;
//         affect_to_char(victim, &af1);
// 
//         af2.type        = sn;
//         af2.location        = APPLY_STR;
//         af2.modifier        = -2;
//         af2.duration        = 2;
//         af2.bitvector        = AFF_CURSE;
//         affect_to_char(victim, &af2);
// 
//         af3.type        = sn;
//         af3.location        = APPLY_HITROLL;
//         af3.modifier        = -10;
//         af3.duration        = 2;
//         af3.bitvector        = AFF_BLIND;
//         affect_to_char(victim, &af3);
// 
//         send_to_char("You are engulfed in drowfire!\n\r", victim);
//         act("$n is engulfed in drowfire!",victim,NULL,NULL,TO_ROOM);
//         return;
// }

// void spell_resistance( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//     OBJ_DATA *obj = (OBJ_DATA *) vo;
// 
//     if ( obj->chobj != NULL )
//     {
//         send_to_char("Your spell has no affect.\n\r",ch);
//         return;
//     }
//     if ( IS_SET(obj->quest, QUEST_ARTIFACT) )
//     {
//         send_to_char( "Not on artifacts.\n\r", ch );
//         return;
//     }
//     if ( obj->resistance <= 10 )
//     {
//         send_to_char( "You cannot make that item any more resistant.\n\r", ch );
//         return;
//     }
//     obj->resistance = 10;
//     act("$p sparkles for a moment.",ch,obj,NULL,TO_CHAR);
//     act("$p sparkles for a moment.",ch,obj,NULL,TO_ROOM);
//     return;
// }


// void spell_clay( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//   CHAR_DATA *victim = (CHAR_DATA *) vo;
//   AFFECT_DATA af;
// 
//   act("You point your finger at $N and a clay ball flies from your hand!",ch,NULL,victim,TO_CHAR);
//   act("$n points $s finger at $N and a clay ball flies from $s hand!",ch,NULL,victim,TO_NOTVICT);
//   act("$n points $s finger at you and a clay ball flies from $s hand!",ch,NULL,victim,TO_VICT);
//   if (IS_AFFECTED(victim, AFF_WEBBED)) return;
//   if ( saves_spell( level, victim ) && victim->position >= POS_FIGHTING )
//   {
//     send_to_char( "You dodge the clay!\n\r", victim );
//     act("$n dodges your clay ball!",victim,NULL,NULL,TO_ROOM);
//     return;
//   } 
//   af.type      = sn;
//   af.location  = APPLY_AC;
//   af.modifier  = 200;
//   af.duration  = number_range(1,2);
//   af.bitvector = AFF_WEBBED;
//   affect_to_char( victim, &af );
//   send_to_char( "You are coated in a sticky clay ball!\n\r", victim );
//   act("$n is coated in a sticky clay ball!",victim,NULL,NULL,TO_ROOM);
//   return;
// }

// void spell_spiritkiss( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) ) return;
//     af.type      = sn;
//     af.duration  = 2*level;
//     af.location  = APPLY_HITROLL;
//     af.modifier  = level;
//     af.bitvector = 0;
//     affect_to_char( victim, &af );
// 
//     af.type      = sn;
//     af.duration  = 2*level;
//     af.location  = APPLY_DAMROLL;
//     af.modifier  = level;
//     af.bitvector = 0;
//     affect_to_char( victim, &af );
// 
//     af.location  = APPLY_SAVING_SPELL;
//     af.modifier  = 0 - level / 8;
//     affect_to_char( victim, &af );
//     act( "$n is filled with spiritual power.", victim, NULL, NULL, TO_ROOM );
//     send_to_char( "You are blessed by the spirits.\n\r", victim );
//     if ( ch != victim )
//         send_to_char( "Ok.\n\r", ch );
//     return;
// }

// void spell_jailwater( int sn, int level, CHAR_DATA *ch, void *vo )
// {
//    CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int door;
//     ROOM_INDEX_DATA *old_room = ch->in_room;
// 
//     if( victim == NULL ) return;
//     if( victim->in_room == NULL ) return;
// 
//     char_from_room(ch);
//     char_to_room(ch,victim->in_room);
// 
//     for (door = 0 ; door < 4 ; door++)
//     {
//         if (ch->in_room->exit[door] != NULL)
//             make_wall(ch->in_room, door, EX_ICE_WALL);
//     }
// 
//     ch->hit += (ch->hit *3/2);
//        if (ch->hit > ch->max_hit)
//                 ch->hit = ch->max_hit;
// 
//     act("$n calls forth sheets of ice, blocking your path in every direction.", ch, NULL, NULL, TO_ROOM);
//     send_to_char("You call forth sheets of ice to entrap your prey.\n\r", ch);
//     send_to_char("You grin wickedly.\n\r",ch);
//     do_say(ch,"Prepare to die! Muahahahaha.");
//     char_from_room(ch);
//     char_to_room(ch,old_room);
//     
//    return;
// }

// /* from ghost3 */
// 
// 
// /* NEW SPELL GROUPS MAGIC.C (GREMLIN & IRIS) - JAN 05/99 */
// 
// /*Modified by (GREMLIN & IRIS) - June 24/2000  */
// 
// 
// 
// 
// 
// void spell_vapour( int sn, int level, CHAR_DATA *ch, void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) )
//     {
//                 if (victim == ch)
//                 {
//                         send_to_char("You are already cloaked from harm.\n\r",ch);
//                 }
//                 else
//                 {
//                         act("$N is already protected.",ch,NULL,victim,TO_CHAR);
//                 }
//                 return;
//     }
// 
// 
//     af.where     = TO_AFFECTS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = 8 + level;
//     af.location  = APPLY_AC;
//     af.modifier  = -80;
//     af.bitvector = 0;
//     affect_to_char( victim, &af );
//     act( "$n is surrounded by a vapour.", victim, NULL, NULL, TO_ROOM );
//     send_to_char( "You are surrounded by a vapour.\n\r", victim );
//     return;
// }
// 
// 
// 
// void spell_smoke_screen( int sn, int level, CHAR_DATA *ch, void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) )
//     {
//                 if (victim == ch)
//                 {
//                         send_to_char("You are already in a shroud of smoke.\n\r",ch);
//                 }
//                 else
//                 {
//                         act("$N is already protected.",ch,NULL,victim,TO_CHAR);
//                 }
//                 return;
//     }
// 
// 
//     af.where     = TO_AFFECTS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = 8 + level;
//     af.location  = APPLY_AC;
//     af.modifier  = -80;
//     af.bitvector = 0;
//     affect_to_char( victim, &af );
//     act( "$n is surrounded by smoke.", victim, NULL, NULL, TO_ROOM );
//     send_to_char( "You are surrounded by a shroud of smoke.\n\r", victim );
//     return;
// }
// 
// 
// 
// void spell_camouflage( int sn, int level, CHAR_DATA *ch, void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) )
//     {
//                 if (victim == ch)
//                 {
//                         send_to_char("You are already camouflaged. \n\r",ch);
//                 }
//                 else
//                 {
//                         act("$N is already camouflaged." ,ch,NULL,victim,TO_CHAR);
//                 }
//                 return;
//     }
// 
// 
//     af.where     = TO_AFFECTS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = 8 + level;
//     af.location  = APPLY_AC;
//     af.modifier  = -80;
//     af.bitvector = 0;
//     affect_to_char( victim, &af );
//     act( "$n disappears into the surroundings.", victim, NULL, NULL, TO_ROOM );
//     send_to_char( "You disguise yourself and fade into the surroundings.\n\r", victim );
//     return;
// }
// 
// 
// 
// void spell_faith( int sn, int level, CHAR_DATA *ch, void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) )
//     {
//                 if (victim == ch)
//                 {
//                         send_to_char("Your faith is strong enough.\n\r",ch);
//                 }
//                 else
//                 {
//                         act("$N's faith is already strong.",ch,NULL,victim,TO_CHAR);
//                 }
//                 return;
//         }
// 
// 
//     af.where     = TO_AFFECTS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = 8 + level;
//     af.location  = APPLY_AC;
//     af.modifier  = -80;
//     af.bitvector = 0;
//     affect_to_char( victim, &af );
//     act( "$n's faith grows stronger.", victim, NULL, NULL, TO_ROOM );
//     send_to_char( "Your faith grows stronger.\n\r", victim );
//     return;
// }
// 
// 
// 
// void spell_vengeance( int sn, int level, CHAR_DATA *ch, void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) )
//     {
//                 if (victim == ch)
//                 {
//                         send_to_char("You are already filled with vengeance.\n\r",ch);
//                 }
//                 else
//                 {
//                         act("$N is already vengeful.",ch,NULL,victim,TO_CHAR);
//                 }
//                 return;
//     }
// 
//     af.where     = TO_AFFECTS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = 8 + level;
//     af.location  = APPLY_AC;
//     af.modifier  = -80;
//     af.bitvector = 0;
//     affect_to_char( victim, &af );
//     act( "A look of vengeance appears on $n's face.", victim, NULL, NULL, TO_ROOM );
//     send_to_char( "You become vengeful.\n\r", victim );
//     return;
// }
// 
// 
// 
// void spell_smog( int sn, int level, CHAR_DATA *ch, void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) )
//     {
//                 if (victim == ch)
//                 {
//                         send_to_char("You are already surrounded by smog.\n\r",ch);
//                 }
//                 else
//                 {
//                         act("A smog already surrounds $N.",ch,NULL,victim,TO_CHAR);
//                 }
//                 return;
//     }
// 
//     af.where     = TO_AFFECTS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = 8 + level;
//     af.location  = APPLY_AC;
//     af.modifier  = -80;
//     af.bitvector = 0;
//     affect_to_char( victim, &af );
//     act( "A smog envelopes $n.", victim, NULL, NULL, TO_ROOM );
//     send_to_char( "You are enveloped by smog.\n\r", victim );
//     return;
// }
// 
// 
// 
// /* *****************************************************  */
// 
// 
// 
// 
// 
// void spell_waterlog( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) || IS_AFFECTED(victim,AFF_SLOW))
//     {
//                 if (victim == ch)
//                 {
//                         send_to_char("You are already waterlogged!\n\r",ch);
//                 }
//         else
//                 {
//                 act("$N is already waterlogged from head to toe.", ch,NULL,victim,TO_CHAR);
//                 }
//         return;
//     }
// 
//     if (saves_spell(level,victim,DAM_OTHER) || IS_SET(victim->imm_flags,IMM_MAGIC))
//     {
//                 if (victim != ch)
//             send_to_char("Nothing seemed to happen.\n\r",ch);
// 
//         send_to_char("You feel a bit damp.\n\r",victim);
//         return;
//     }
// 
// 
//     if (IS_AFFECTED(victim,AFF_HASTE))
//     {
//         if (!check_dispel(level,victim,skill_lookup("haste")))
//         {
//                     if (victim != ch)
//                     send_to_char("Spell failed.\n\r",ch);
// 
//             send_to_char("You feel a bit damp.\n\r",victim);
//             return;
//         }
//         }
// 
//     if (IS_AFFECTED(victim,AFF_FLYING))
//     {
//         if (!check_dispel(level,victim,skill_lookup("fly")))
//         {
//                     if (victim != ch)
//                     send_to_char("Spell failed.\n\r",ch);
// 
//             send_to_char("You feel a bit damp.\n\r",victim);
//             return;
//                 }
//         }
// 
//         act("$n is waterlogged.",victim,NULL,NULL,TO_ROOM);
// 
//     af.where     = TO_AFFECTS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = level/2;
//     af.location  = APPLY_DEX;
//     af.modifier  = -1 - (level >= 18) - (level >= 25) - (level >= 32);
//     af.bitvector = AFF_SLOW;
//     affect_to_char( victim, &af );
//     send_to_char( "You are suddenly soaked with water.\n\r", victim );
//     act("A wave of water soaks $n.",victim,NULL,NULL,TO_ROOM);
//     return;
// }
// 
// 
// 
// void spell_backdraft( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) || IS_AFFECTED(victim,AFF_SLOW))
//     {
//                 if (victim == ch)
//                 {
//                 send_to_char("You've already been engulfed!\n\r",ch);
//                 }
//         else
//                 {
//                 act("$N is already burning from head to toe.", ch,NULL,victim,TO_CHAR);
//                 }
//         return;
//     }
// 
//     if (saves_spell(level,victim,DAM_OTHER) || IS_SET(victim->imm_flags,IMM_MAGIC))
//     {
//                 if (victim != ch)
//             send_to_char("Nothing seemed to happen.\n\r",ch);
// 
//         send_to_char("You feel very warm.\n\r",victim);
//         return;
//     }
// 
//     if (IS_AFFECTED(victim,AFF_HASTE))
//     {
//         if (!check_dispel(level,victim,skill_lookup("haste")))
//         {
//                     if (victim != ch)
//                     send_to_char("Spell failed.\n\r",ch);
// 
//             send_to_char("You feel very warm.\n\r",victim);
//             return;
//         }
//         }
// 
//     if (IS_AFFECTED(victim,AFF_FLYING))
//     {
//         if (!check_dispel(level,victim,skill_lookup("fly")))
//         {
//                     if (victim != ch)
//                     send_to_char("Spell failed.\n\r",ch);
// 
//             send_to_char("You feel very warm.\n\r",victim);
//             return;
//                 }
// 
//         act("A Backdraft has hit $n.",victim,NULL,NULL,TO_ROOM);
//         return;
//     }
// 
//     af.where     = TO_AFFECTS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = level/2;
//     af.location  = APPLY_DEX;
//     af.modifier  = -1 - (level >= 18) - (level >= 25) - (level >= 32);
//     af.bitvector = AFF_SLOW;
//     affect_to_char( victim, &af );
//     send_to_char( "You are suddenly engulfed by flames and smoke.\n\r", victim );
//     act("A flash of smoke and fire engulfs $n.",victim,NULL,NULL,TO_ROOM);
//     return;
// }
// 
// 
// 
// void spell_downdraft( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) || IS_AFFECTED(victim,AFF_SLOW))
//     {
//         if (victim == ch)
//                 {
//                 send_to_char("You are already waterlogged!\n\r",ch);
//                 }
//         else
//                 {
//                 act("$N is already waterlogged from head to toe.", ch,NULL,victim,TO_CHAR);
//                 }
//         return;
//     }
// 
//     if (saves_spell(level,victim,DAM_OTHER) || IS_SET(victim->imm_flags,IMM_MAGIC))
//     {
//                 if (victim != ch)
//             send_to_char("Nothing seemed to happen.\n\r",ch);
// 
//         send_to_char("You feel a slight breeze.\n\r",victim);
//         return;
//     }
// 
//     if (IS_AFFECTED(victim,AFF_HASTE))
//     {
//         if (!check_dispel(level,victim,skill_lookup("haste")))
//         {
//                     if (victim != ch)
//                     send_to_char("Spell failed.\n\r",ch);
// 
//             send_to_char("You feel a slight breeze.\n\r",victim);
//             return;
//         }
//         }
// 
//     if (IS_AFFECTED(victim,AFF_FLYING))
//     {
//         if (!check_dispel(level,victim,skill_lookup("fly")))
//         {
//                     if (victim != ch)
//                     send_to_char("Spell failed.\n\r",ch);
// 
//             send_to_char("You feel a slight breeze.\n\r",victim);
//             return;
//                 }
//         }
// 
//         act("A downdraft blasts $n to the ground.",victim,NULL,NULL,TO_ROOM);
// 
//     af.where     = TO_AFFECTS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = level/2;
//     af.location  = APPLY_DEX;
//     af.modifier  = -1 - (level >= 18) - (level >= 25) - (level >= 32);
//     af.bitvector = AFF_SLOW;
//     affect_to_char( victim, &af );
//     send_to_char( "You are suddenly blasted to the ground by a downdraft.\n\r", victim );
//     act("A downdraft blasts $n to the ground.",victim,NULL,NULL,TO_ROOM);
//     return;
// }
// 
// 
// 
// void spell_earthbind( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) || IS_AFFECTED(victim,AFF_SLOW))
//     {
//         if (victim == ch)
//                 {
//                 send_to_char("You are already bound to the earth!\n\r",ch);
//                 }
//         else
//                 {
//                 act("The earth has already encompassed $N.", ch,NULL,victim,TO_CHAR);
//                 }
//         return;
//     }
// 
//     if (saves_spell(level,victim,DAM_OTHER) || IS_SET(victim->imm_flags,IMM_MAGIC))
//     {
//                 if (victim != ch)
//             send_to_char("Nothing seemed to happen.\n\r",ch);
// 
//         send_to_char("Your feet are dusty.\n\r",victim);
//         return;
//     }
// 
//     if (IS_AFFECTED(victim,AFF_HASTE))
//     {
//         if (!check_dispel(level,victim,skill_lookup("haste")))
//         {
//                     if (victim != ch)
//                     send_to_char("Spell failed.\n\r",ch);
// 
//             send_to_char("Your feet are dusty.\n\r",victim);
//             return;
//         }
//         }
// 
//     if (IS_AFFECTED(victim,AFF_FLYING))
//     {
//         if (!check_dispel(level,victim,skill_lookup("fly")))
//         {
//                     if (victim != ch)
//                     send_to_char("Spell failed.\n\r",ch);
// 
//             send_to_char("Your feet are dusty.\n\r",victim);
//             return;
//                 }
//         }
// 
//         act("The earth binds $n down.",victim,NULL,NULL,TO_ROOM);
// 
//     af.where     = TO_AFFECTS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = level/2;
//     af.location  = APPLY_DEX;
//     af.modifier  = -1 - (level >= 18) - (level >= 25) - (level >= 32);
//     af.bitvector = AFF_SLOW;
//     affect_to_char( victim, &af );
//     send_to_char( "You are suddenly encompassed by the earth.\n\r", victim );
//     act("The earth suddenly binds $n.",victim,NULL,NULL,TO_ROOM);
//     return;
// }
// 
// 
// 
// void spell_awe ( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) || IS_AFFECTED(victim,AFF_SLOW))
//     {
//         if (victim == ch)
//                 {
//                 send_to_char("You are already overcome with awe!\n\r",ch);
//                 }
//         else
//                 {
//                 act("$N is already in awe of your greatness.", ch,NULL,victim,TO_CHAR);
//                 }
//         return;
//     }
// 
//     if (saves_spell(level,victim,DAM_OTHER) || IS_SET(victim->imm_flags,IMM_MAGIC))
//     {
//                 if (victim != ch)
//             send_to_char("Nothing seemed to happen.\n\r",ch);
// 
//         send_to_char("You feel somewhat humbled.\n\r",victim);
//         return;
//     }
// 
//     if (IS_AFFECTED(victim,AFF_HASTE))
//     {
//         if (!check_dispel(level,victim,skill_lookup("haste")))
//         {
//                     if (victim != ch)
//                     send_to_char("Spell failed.\n\r",ch);
// 
//             send_to_char("You feel somewhat humbled.\n\r",victim);
//             return;
//         }
//         }
// 
//     if (IS_AFFECTED(victim,AFF_FLYING))
//     {
//         if (!check_dispel(level,victim,skill_lookup("fly")))
//         {
//                     if (victim != ch)
//                     send_to_char("Spell failed.\n\r",ch);
// 
//             send_to_char("You feel somewhat humbled.\n\r",victim);
//             return;
//                  }
//         }
// 
//         act("$n is overwhelmed by awe!",victim,NULL,NULL,TO_ROOM);
// 
//     af.where     = TO_AFFECTS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = level/2;
//     af.location  = APPLY_DEX;
//     af.modifier  = -1 - (level >= 18) - (level >= 25) - (level >= 32);
//     af.bitvector = AFF_SLOW;
//     affect_to_char( victim, &af );
//     send_to_char( "You are overcome with awe!\n\r", victim );
//     act("A wave of awe overwhelms $n.",victim,NULL,NULL,TO_ROOM);
//     return;
// }
// 
// 
// 
// void spell_petrify( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( is_affected( victim, sn ) || IS_AFFECTED(victim,AFF_SLOW))
//     {
//         if (victim == ch)
//                 {
//                 send_to_char("You are already petrified!\n\r",ch);
//                 }
//         else
//                 {
//                 act("$N is already petrified from head to toe.", ch,NULL,victim,TO_CHAR);
//                 }
//         return;
//     }
// 
//     if (saves_spell(level,victim,DAM_OTHER) || IS_SET(victim->imm_flags,IMM_MAGIC))
//     {
//                 if (victim != ch)
//             send_to_char("Nothing seemed to happen.\n\r",ch);
// 
//         send_to_char("You feel a bit stiff.\n\r",victim);
//         return;
//     }
// 
//     if (IS_AFFECTED(victim,AFF_HASTE))
//     {
//         if (!check_dispel(level,victim,skill_lookup("haste")))
//         {
//                     if (victim != ch)
//                     send_to_char("Spell failed.\n\r",ch);
// 
//             send_to_char("You feel a bit stiff.\n\r",victim);
//             return;
//         }
//         }
// 
//     if (IS_AFFECTED(victim,AFF_FLYING))
//     {
//         if (!check_dispel(level,victim,skill_lookup("fly")))
//         {
//                     if (victim != ch)
//                     send_to_char("Spell failed.\n\r",ch);
// 
//             send_to_char("You feel a bit stiff.\n\r",victim);
//             return;
//                 }
//         }
// 
//         act("$n is petrified.",victim,NULL,NULL,TO_ROOM);
// 
//     af.where     = TO_AFFECTS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = level/2;
//     af.location  = APPLY_DEX;
//     af.modifier  = -1 - (level >= 18) - (level >= 25) - (level >= 32);
//     af.bitvector = AFF_SLOW;
//     affect_to_char( victim, &af );
//     send_to_char( "You panic and are paralyzed from fright .\n\r", victim );
//     act("A look of shear terror paralyzes $n.",victim,NULL,NULL,TO_ROOM);
//     return;
// }
// 
// 
// 
// /* *****************************************************  */
// 
// 
// 
// void spell_flash_flood (int sn,int level,CHAR_DATA *ch, void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     CHAR_DATA *tmp_vict,*last_vict,*next_vict;
//     bool found;
//     int dam;
// 
//     /* first strike */
//     act("A burst of water spews from $n's hand and washes over $N.", ch,NULL,victim,TO_ROOM);
//     act("A burst of water spews from your hand and washes over $N.", ch,NULL,victim,TO_CHAR);
//     act("A burst of water spews from $n's hand and hits you!", ch,NULL,victim,TO_VICT);
// 
//     dam = dice(level,16);
// 
//     if (saves_spell(level,victim,DAM_BASH))
//                  dam /= 3;
// 
//     damage(ch,victim,dam,sn,DAM_BASH,TRUE);
//     last_vict = victim;
//     level -= 4;   /* decrement damage */
// 
//     /* new targets */
//     while (level > 0)
//     {
//                 found = FALSE;
//                 for (tmp_vict = ch->in_room->people; tmp_vict != NULL; tmp_vict = next_vict)
//                 {
// 
//                         next_vict = tmp_vict->next_in_room;
// 
//                         if (!is_safe_spell(ch,tmp_vict,TRUE) && tmp_vict != last_vict)
//                     {
//                             found = TRUE;
//                                     last_vict = tmp_vict;
//                             act("The wave of water slams into $n!",tmp_vict,NULL,NULL,TO_ROOM);
//                             act("The wave of water slams into you!",tmp_vict,NULL,NULL,TO_CHAR);
//                             dam = dice(level,12);
// 
//                             if (saves_spell(level,tmp_vict,DAM_BASH))
//                                         dam /= 3;
// 
//                             damage(ch,tmp_vict,dam,sn,DAM_BASH,TRUE);
//                             level -= 4;  /* decrement damage */
//                         }
//                 }   /* end target searching loop */
// 
// 
//                 if (!found) /* no target found, hit the caster */
//                 {
//                           if (ch == NULL)
//                          return;
// 
//                           if (last_vict == ch) /* no double hits */
//                           {
//                             act("The wave seems to have subsided.",ch,NULL,NULL,TO_ROOM);
//                             act("The wave of water evaporates before it hits you.",
//                                 ch,NULL,NULL,TO_CHAR);
//                             return;
//                           }
// 
//                           last_vict = ch;
//                           act("The wave slams back into $n... whoops!",ch,NULL,NULL,TO_ROOM);
//                           send_to_char("You are struck by your own wave!\n\r",ch);
//                           dam = dice(level,12);
// 
//                           if (saves_spell(level,ch,DAM_BASH))
//                             dam /= 3;
// 
//                           damage(ch,ch,dam,sn,DAM_BASH,TRUE);
//                           level -= 4;  /* decrement damage */
// 
//                           if (ch == NULL)
//                             return;
//                 }
// 
//     /* now go back and find more targets */
//     }
// 
// }
// 
// 
// 
// void spell_fire_storm (int sn,int level,CHAR_DATA *ch, void *vo,int target)
// 
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     CHAR_DATA *tmp_vict,*last_vict,*next_vict;
//     bool found;
//     int dam;
// 
//     /* first strike */
//     act("Salvos of fire erupt from $n's hand and leaps towards $N.", ch,NULL,victim,TO_ROOM);
//     act("Salvos of fire erupt from your hand and leaps towards $N.", ch,NULL,victim,TO_CHAR);
//     act("A salvo of fire leaps from $n's hand and hits you!", ch,NULL,victim,TO_VICT);
// 
// 
//     dam = dice(level,16);
// 
//     if (saves_spell(level,victim,DAM_FIRE))
//                  dam /= 3;
// 
//     damage(ch,victim,dam,sn,DAM_FIRE,TRUE);
//     last_vict = victim;
//     level -= 4;   /* decrement damage */
// 
//     /* new targets */
//     while (level > 0)
//     {
//         found = FALSE;
//         for (tmp_vict = ch->in_room->people; tmp_vict != NULL; tmp_vict = next_vict)
//         {
//           next_vict = tmp_vict->next_in_room;
// 
//           if (!is_safe_spell(ch,tmp_vict,TRUE) && tmp_vict != last_vict)
//           {
//             found = TRUE;
//             last_vict = tmp_vict;
//             act("The salvo of fire engulfs $n!",tmp_vict,NULL,NULL,TO_ROOM);
//             act("The salvo of fire engulfs you!",tmp_vict,NULL,NULL,TO_CHAR);
//             dam = dice(level,12);
//             if (saves_spell(level,tmp_vict,DAM_FIRE))
//                         dam /= 3;
// 
//             damage(ch,tmp_vict,dam,sn,DAM_FIRE,TRUE);
//             level -= 4;  /* decrement damage */
//           }
//         }   /* end target searching loop */
// 
//         if (!found) /* no target found, hit the caster */
//         {
//           if (ch == NULL)
//                  return;
// 
//           if (last_vict == ch) /* no double hits */
//           {
//             act("The fires seems to have disipated.",ch,NULL,NULL,TO_ROOM);
//             act("The fires disipates before it hits you.",
//                 ch,NULL,NULL,TO_CHAR);
//             return;
//           }
// 
//           last_vict = ch;
//           act("The fire leaps back towards $n... whoops!",ch,NULL,NULL,TO_ROOM);
//           send_to_char("You are struck by your own salvo!\n\r",ch);
//           dam = dice(level,12);
// 
//           if (saves_spell(level,ch,DAM_FIRE))
//             dam /= 3;
// 
//           damage(ch,ch,dam,sn,DAM_FIRE,TRUE);
//           level -= 4;  /* decrement damage */
// 
//           if (ch == NULL)
//             return;
// 
//         }
//     /* now go back and find more targets */
//     }
// }
// 
// 
// 
// void spell_avalanche (int sn,int level,CHAR_DATA *ch, void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     CHAR_DATA *tmp_vict,*last_vict,*next_vict;
//     bool found;
//     int dam;
// 
//     /* first strike */
//     act("$n clenches his fist and snow and ice from above strikes $N.", ch,NULL,victim,TO_ROOM);
//     act("You clench your fist and snow and ice from above strikes $N.", ch,NULL,victim,TO_CHAR);
//     act("$n clenches his fist and starts an avalanche of snow and ice that strikes you!", ch,NULL,victim,TO_VICT);
// 
//     dam = dice(level,16);
// 
//     if (saves_spell(level,victim,DAM_BASH))
//                  dam /= 3;
// 
//     damage(ch,victim,dam,sn,DAM_BASH,TRUE);
//     last_vict = victim;
//     level -= 4;   /* decrement damage */
// 
//     /* new targets */
//     while (level > 0)
//     {
//         found = FALSE;
//         for (tmp_vict = ch->in_room->people; tmp_vict != NULL; tmp_vict = next_vict)
//         {
//           next_vict = tmp_vict->next_in_room;
//           if (!is_safe_spell(ch,tmp_vict,TRUE) && tmp_vict != last_vict)
//           {
//             found = TRUE;
//             last_vict = tmp_vict;
//             act("The cascade of snow and ice slam into $n!",tmp_vict,NULL,NULL,TO_ROOM);
//             act("The cascade of snow and ice slam into you!",tmp_vict,NULL,NULL,TO_CHAR);
//             dam = dice(level,12);
// 
//             if (saves_spell(level,tmp_vict,DAM_BASH))
//                         dam /= 3;
// 
//             damage(ch,tmp_vict,dam,sn,DAM_BASH,TRUE);
//             level -= 4;  /* decrement damage */
//           }
//         }   /* end target searching loop */
// 
//         if (!found) /* no target found, hit the caster */
//         {
//           if (ch == NULL)
//                  return;
// 
//           if (last_vict == ch) /* no double hits */
//           {
//             act("The avalanche seems to have subsided.",ch,NULL,NULL,TO_ROOM);
//             act("The avalanche disperses before it hits you.",
//                 ch,NULL,NULL,TO_CHAR);
//             return;
//           }
// 
//           last_vict = ch;
//           act("The cascade of snow and ice slams back into $n... whoops!",ch,NULL,NULL,TO_ROOM);
//           send_to_char("You are struck by your own avalanche!\n\r",ch);
//           dam = dice(level,12);
// 
//           if (saves_spell(level,ch,DAM_BASH))
//             dam /= 3;
// 
//           damage(ch,ch,dam,sn,DAM_BASH,TRUE);
//           level -= 4;  /* decrement damage */
// 
//           if (ch == NULL)
//             return;
//         }
//     /* now go back and find more targets */
//     }
// }
// 
// 
// 
// void spell_virtuous_blast (int sn,int level,CHAR_DATA *ch, void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     CHAR_DATA *tmp_vict,*last_vict,*next_vict;
//     bool found;
//     int dam;
// 
//     /* first strike */
//     act("A beam of unearthly light erupts from $n's being and sears $N.", ch,NULL,victim,TO_ROOM);
//     act("A beam of unearthly light erupts from your hand and sears $N.", ch,NULL,victim,TO_CHAR);
//     act("A beam of unearthly light erupts from $n's hand and hits you!", ch,NULL,victim,TO_VICT);
//     dam = dice(level,16);
// 
//     if (saves_spell(level,victim,DAM_HOLY))
//                  dam /= 3;
// 
//     damage(ch,victim,dam,sn,DAM_HOLY,TRUE);
//     last_vict = victim;
//     level -= 4;   /* decrement damage */
// 
//     /* new targets */
//     while (level > 0)
//     {
//         found = FALSE;
//         for (tmp_vict = ch->in_room->people; tmp_vict != NULL; tmp_vict = next_vict)
//         {
//           next_vict = tmp_vict->next_in_room;
// 
//           if (!is_safe_spell(ch,tmp_vict,TRUE) && tmp_vict != last_vict)
//           {
//             found = TRUE;
//             last_vict = tmp_vict;
//             act("The beam arcs into $n!",tmp_vict,NULL,NULL,TO_ROOM);
//             act("The arcs into you!",tmp_vict,NULL,NULL,TO_CHAR);
//             dam = dice(level,12);
// 
//             if (saves_spell(level,tmp_vict,DAM_HOLY))
//                         dam /= 3;
// 
//             damage(ch,tmp_vict,dam,sn,DAM_HOLY,TRUE);
//             level -= 4;  /* decrement damage */
//           }
//         }   /* end target searching loop */
// 
//         if (!found) /* no target found, hit the caster */
//         {
//           if (ch == NULL)
//                  return;
// 
//           if (last_vict == ch) /* no double hits */
//           {
//             act("The arc seems to have faded away.",ch,NULL,NULL,TO_ROOM);
//             act("The fades away before it hits you.",
//                 ch,NULL,NULL,TO_CHAR);
//             return;
//           }
// 
//           last_vict = ch;
//           act("The beam arcs back into $n... whoops!",ch,NULL,NULL,TO_ROOM);
//           send_to_char("You are struck by your own beam!\n\r",ch);
//           dam = dice(level,12);
// 
//           if (saves_spell(level,ch,DAM_HOLY))
//             dam /= 3;
// 
//           damage(ch,ch,dam,sn,DAM_HOLY,TRUE);
//           level -= 4;  /* decrement damage */
// 
//           if (ch == NULL)
//             return;
//         }
//     /* now go back and find more targets */
//     }
// }
// 
// 
// 
// void spell_sorrow (int sn,int level,CHAR_DATA *ch, void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     CHAR_DATA *tmp_vict,*last_vict,*next_vict;
//     bool found;
//     int dam;
// 
//     /* first strike */
//     act("A surge of anger and sorrow spews from $n's hand and overcomes $N.", ch,NULL,victim,TO_ROOM);
//     act("A surge of anger and sorrow spews from your hand and overcomes $N.", ch,NULL,victim,TO_CHAR);
//     act("A surge of anger and sorrow spews from $n's hand and hits you!", ch,NULL,victim,TO_VICT);
// 
//     dam = dice(level,16);
// 
//     if (saves_spell(level,victim,DAM_NEGATIVE))
//                  dam /= 3;
// 
//     damage(ch,victim,dam,sn,DAM_NEGATIVE,TRUE);
//     last_vict = victim;
//     level -= 4;   /* decrement damage */
// 
//     /* new targets */
//     while (level > 0)
//     {
//         found = FALSE;
//         for (tmp_vict = ch->in_room->people; tmp_vict != NULL; tmp_vict = next_vict)
//         {
//           next_vict = tmp_vict->next_in_room;
// 
//           if (!is_safe_spell(ch,tmp_vict,TRUE) && tmp_vict != last_vict)
//           {
//             found = TRUE;
//             last_vict = tmp_vict;
//             act("The torrent of anger and sorrow cascades over $n!",tmp_vict,NULL,NULL,TO_ROOM);
//             act("The torrent of anger and sorrow engulfs you!",tmp_vict,NULL,NULL,TO_CHAR);
//             dam = dice(level,12);
// 
//             if (saves_spell(level,tmp_vict,DAM_NEGATIVE))
//                         dam /= 3;
// 
//             damage(ch,tmp_vict,dam,sn,DAM_NEGATIVE,TRUE);
//             level -= 4;  /* decrement damage */
//           }
//         }   /* end target searching loop */
// 
//         if (!found) /* no target found, hit the caster */
//         {
//           if (ch == NULL)
//                  return;
// 
//           if (last_vict == ch) /* no double hits */
//           {
//             act("The ill feeling seems to have disipated.",ch,NULL,NULL,TO_ROOM);
//             act("The ill feeling fades away before it hits you.",
//                 ch,NULL,NULL,TO_CHAR);
//             return;
//           }
// 
//           last_vict = ch;
//           act("The deluge of anger slams back into $n... whoops!",ch,NULL,NULL,TO_ROOM);
//           send_to_char("You are struck by your own anger!\n\r",ch);
//           dam = dice(level,12);
// 
//           if (saves_spell(level,ch,DAM_NEGATIVE))
//             dam /= 3;
// 
//           damage(ch,ch,dam,sn,DAM_NEGATIVE,TRUE);
//             level -= 4;  /* decrement damage */
// 
//           if (ch == NULL)
//             return;
//         }
//     /* now go back and find more targets */
//     }
// }
// 
// 
// 
// void spell_sand_storm (int sn,int level,CHAR_DATA *ch, void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     CHAR_DATA *tmp_vict,*last_vict,*next_vict;
//     bool found;
//     int dam;
// 
//     /* first strike */
//     act("A tempest of sand and dirt bursts from $n's hand and slams into $N.", ch,NULL,victim,TO_ROOM);
//     act("A tempest of sand and dirt bursts from your hand and slams into $N.", ch,NULL,victim,TO_CHAR);
//     act("A tempest of sand and dirt bursts from $n's hand and hits you!", ch,NULL,victim,TO_VICT);
// 
//     dam = dice(level,16);
// 
//     if (saves_spell(level,victim,DAM_BASH))
//                  dam /= 3;
// 
//     damage(ch,victim,dam,sn,DAM_BASH,TRUE);
//     last_vict = victim;
//     level -= 4;   /* decrement damage */
// 
//     /* new targets */
//     while (level > 0)
//     {
//         found = FALSE;
//         for (tmp_vict = ch->in_room->people; tmp_vict != NULL; tmp_vict = next_vict)
//         {
//           next_vict = tmp_vict->next_in_room;
// 
//           if (!is_safe_spell(ch,tmp_vict,TRUE) && tmp_vict != last_vict)
//           {
//             found = TRUE;
//             last_vict = tmp_vict;
//             act("The surge of sand and dirt slam into $n!",tmp_vict,NULL,NULL,TO_ROOM);
//             act("The surge of dirt and sand slams into you!",tmp_vict,NULL,NULL,TO_CHAR);
//             dam = dice(level,12);
// 
//             if (saves_spell(level,tmp_vict,DAM_BASH))
//                         dam /= 3;
// 
//             damage(ch,tmp_vict,dam,sn,DAM_BASH,TRUE);
//             level -= 4;  /* decrement damage */
//           }
//         }   /* end target searching loop */
// 
//         if (!found) /* no target found, hit the caster */
//         {
//           if (ch == NULL)
//                  return;
// 
//           if (last_vict == ch) /* no double hits */
//           {
//             act("The storm seems to have subsided.",ch,NULL,NULL,TO_ROOM);
//             act("The storm subsides.",
//                 ch,NULL,NULL,TO_CHAR);
//             return;
//           }
// 
//           last_vict = ch;
//           act("The sand and dirt slams back into $n... whoops!",ch,NULL,NULL,TO_ROOM);
//           send_to_char("You are struck by your own sand storm!\n\r",ch);
//           dam = dice(level,12);
// 
//           if (saves_spell(level,ch,DAM_BASH))
//             dam /= 3;
// 
//           damage(ch,ch,dam,sn,DAM_BASH,TRUE);
//           level -= 4;  /* decrement damage */
// 
//           if (ch == NULL)
//             return;
//         }
//     /* now go back and find more targets */
//     }
// }
// 
// 
// 
// /* *****************************************************  */
// 
// 
// 
// 
// 
// void spell_tsunami ( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// 
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     static const sh_int dam_each[] =
// 
//     {
//         0,
//         380, 306, 306, 307, 308,               309, 330, 330, 330, 330,
//         330, 330, 340, 360, 330,           336, 340, 346, 360, 366,
//         360, 366, 370, 376, 380,               383, 384, 386, 388, 390,
//     430, 440, 460, 468, 600,           903, 904, 909, 908, 990,
//         993, 974, 989, 999, 1000,              1033, 1034, 1037, 1038, 1090
//     };
// 
//     int dam;
// 
// 
// 
//     level        = UMIN(level, sizeof(dam_each)/sizeof(dam_each[0]) - 1);
//     level        = UMAX(0, level);
//     dam                = number_range( dam_each[level] / 2,  dam_each[level] * 6 );
// 
// 
// 
//     if ( saves_spell( level, victim,DAM_LIGHT) )
//         {
//                 dam /= 2;
//         }
//     else
//         {
//                 spell_blindness(skill_lookup("blindness"), level/2,ch,(void *) victim,TARGET_CHAR);
//         }
// 
// 
//     if ( number_percent() > 98 )
//         {
//                 raw_kill( victim );
//                 group_gain( ch, victim );
//                 return;
//         }
// 
//     damage( ch, victim, dam, sn, DAM_LIGHT,TRUE );
//     return;
// }
// 
// 
// 
// void spell_immolation ( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     static const sh_int dam_each[] =
//     {
//         0,
//          380, 306, 306, 307, 308,               309, 330, 330, 330, 330,
//         330, 330, 340, 360, 330,           336, 340, 346, 360, 366,
//         360, 366, 370, 376, 380,               383, 384, 386, 388, 390,
//     430, 440, 460, 468, 600,           903, 904, 909, 908, 990,
//         993, 974, 989, 999, 1000,              1033, 1034, 1037, 1038, 1090
//     };
// 
//     int dam;
// 
//     level        = UMIN(level, sizeof(dam_each)/sizeof(dam_each[0]) - 1);
//     level        = UMAX(0, level);
//     dam                = number_range( dam_each[level] / 2,  dam_each[level] * 6 );
// 
//     if ( saves_spell( level, victim,DAM_LIGHT) )
//         {
//                 dam /= 2;
//         }
//     else
//         {
//                 spell_blindness(skill_lookup("blindness"), level/2,ch,(void *) victim,TARGET_CHAR);
//         }
// 
//     if ( number_percent() > 98 )
//         {
//                 raw_kill( victim );
//                 group_gain( ch, victim );
//                 return;
//         }
// 
//     damage( ch, victim, dam, sn, DAM_LIGHT,TRUE );
//     return;
// }
// 
// 
// 
// void spell_rock_slide ( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     static const sh_int dam_each[] =
//     {
//         0,
//         380, 306, 306, 307, 308,               309, 330, 330, 330, 330,
//         330, 330, 340, 360, 330,           336, 340, 346, 360, 366,
//         360, 366, 370, 376, 380,               383, 384, 386, 388, 390,
//     430, 440, 460, 468, 600,           903, 904, 909, 908, 990,
//         993, 974, 989, 999, 1000,              1033, 1034, 1037, 1038, 1090
//     };
// 
//     int dam;
// 
//     level        = UMIN(level, sizeof(dam_each)/sizeof(dam_each[0]) - 1);
//     level        = UMAX(0, level);
//     dam                = number_range( dam_each[level] / 2,  dam_each[level] * 6 );
// 
//     if ( saves_spell( level, victim,DAM_LIGHT) )
//         {
//                 dam /= 2;
//         }
//     else
//         {
//                 spell_blindness(skill_lookup("blindness"), level/2,ch,(void *) victim,TARGET_CHAR);
//         }
// 
//         if ( number_percent() > 98 )
//         {
//                 raw_kill( victim );
//                 group_gain( ch, victim );
//                 return;
//         }
// 
//     damage( ch, victim, dam, sn, DAM_LIGHT,TRUE );
//     return;
// }
// 
// 
// 
// void spell_archangel ( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     static const sh_int dam_each[] =
//     {
//         0,
//         380, 306, 306, 307, 308,               309, 330, 330, 330, 330,
//         330, 330, 340, 360, 330,           336, 340, 346, 360, 366,
//         360, 366, 370, 376, 380,               383, 384, 386, 388, 390,
//     430, 440, 460, 468, 600,           903, 904, 909, 908, 990,
//         993, 974, 989, 999, 1000,              1033, 1034, 1037, 1038, 1090
//     };
// 
//     int dam;
// 
//     level        = UMIN(level, sizeof(dam_each)/sizeof(dam_each[0]) - 1);
//     level        = UMAX(0, level);
//     dam                = number_range( dam_each[level] / 2,  dam_each[level] * 6 );
// 
//     if ( saves_spell( level, victim,DAM_LIGHT) )
//         {
//                 dam /= 2;
//         }
//     else
//         {
//                 spell_blindness(skill_lookup("blindness"), level/2,ch,(void *) victim,TARGET_CHAR);
//         }
// 
//     if ( number_percent() > 98 )
//         {
//                 raw_kill( victim );
//                 group_gain( ch, victim );
//                 return;
//         }
// 
//     damage( ch, victim, dam, sn, DAM_LIGHT,TRUE );
//     return;
// }
// 
// 
// 
// void spell_spontaneous_combustion ( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     static const sh_int dam_each[] =
//     {
//          0,
//          380, 306, 306, 307, 308,               309, 330, 330, 330, 330,
//          330, 330, 340, 360, 330,          336, 340, 346, 360, 366,
//          360, 366, 370, 376, 380,               383, 384, 386, 388, 390,
//      430, 440, 460, 468, 600,          903, 904, 909, 908, 990,
//             993, 974, 989, 999, 1000,              1033, 1034, 1037, 1038, 1090
//     };
// 
//     int dam;
// 
//     level        = UMIN(level, sizeof(dam_each)/sizeof(dam_each[0]) - 1);
//     level        = UMAX(0, level);
//     dam                = number_range( dam_each[level] / 2,  dam_each[level] * 6 );
// 
//     if ( saves_spell( level, victim,DAM_LIGHT) )
//         {
//                 dam /= 2;
//         }
//     else
//         {
//                 spell_blindness(skill_lookup("blindness"), level/2,ch,(void *) victim,TARGET_CHAR);
//         }
// 
//     if ( number_percent() > 98 )
//         {
//                 raw_kill( victim );
//                 group_gain( ch, victim );
//                 return;
//         }
// 
//     damage( ch, victim, dam, sn, DAM_LIGHT,TRUE );
//     return;
// }
// 
// 
// 
// void spell_hurricane ( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     static const sh_int dam_each[] =
//     {
//         0,
//         380, 306, 306, 307, 308,               309, 330, 330, 330, 330,
//         330, 330, 340, 360, 330,           336, 340, 346, 360, 366,
//         360, 366, 370, 376, 380,               383, 384, 386, 388, 390,
//     430, 440, 460, 468, 600,           903, 904, 909, 908, 990,
//         993, 974, 989, 999, 1000,              1033, 1034, 1037, 1038, 1090
//     };
// 
//     int dam;
// 
//     level        = UMIN(level, sizeof(dam_each)/sizeof(dam_each[0]) - 1);
//     level        = UMAX(0, level);
//     dam                = number_range( dam_each[level] / 2,  dam_each[level] * 6 );
// 
//     if ( saves_spell( level, victim,DAM_LIGHT) )
//         {
//                 dam /= 2;
//         }
//     else
//         {
//                 spell_blindness(skill_lookup("blindness"), level/2,ch,(void *) victim,TARGET_CHAR);
//         }
// 
//     if ( number_percent() > 98 )
//         {
//                 raw_kill( victim );
//                 group_gain( ch, victim );
//                 return;
//         }
// 
//     damage( ch, victim, dam, sn, DAM_LIGHT,TRUE );
//     return;
// }
// 
// 
// 
// /* *****************************************************  */
// 
// 
// 
// 
// 
// void spell_typhoon (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 290, 920 );
// 
//     if ( saves_spell( level, victim, DAM_PIERCE) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_PIERCE ,TRUE);
//     return;
// 
//     dam = number_range( 135, 200);
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
//     return;
// 
//     dam = number_range( 35, 135 );
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
//     return;
// }
// 
// 
// 
// void spell_magma_blast (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 290, 920 );
// 
//     if ( saves_spell( level, victim, DAM_FIRE) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_FIRE ,TRUE);
//     return;
// 
//     dam = number_range(135, 200 );
//     if ( saves_spell( level, victim, DAM_PIERCE) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_PIERCE ,TRUE);
//     return;
// 
//     dam = number_range( 35, 135 );
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
//     return;
// }
// 
// 
// 
// void spell_sink_hole (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 290, 920 );
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
//     return;
// 
//     dam = number_range(135, 200 );
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
//     return;
// 
//     dam = number_range( 35, 135 );
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
//     return;
// }
// 
// 
// 
// 
// void spell_celestial_light (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 290, 920 );
// 
//     if ( saves_spell( level, victim, DAM_HOLY) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_HOLY ,TRUE);
//     return;
// 
//     dam = number_range( 135, 200 );
// 
//     if ( saves_spell( level, victim, DAM_ENERGY) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_ENERGY ,TRUE);
//     return;
// 
//     dam = number_range( 35, 135 );
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
//     return;
// }
// 
// 
// 
// void spell_malfeasance (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 290, 920 );
// 
//     if ( saves_spell( level, victim, DAM_NEGATIVE) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_NEGATIVE ,TRUE);
//     return;
// 
//     dam = number_range( 135, 200 );
// 
//     if ( saves_spell( level, victim, DAM_ENERGY) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_ENERGY ,TRUE);
//     return;
// 
//     dam = number_range( 35, 135);
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
//     return;
// }
// 
// 
// 
// void spell_gale_blast (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 290, 920 );
// 
//     if ( saves_spell( level, victim, DAM_COLD) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_COLD ,TRUE);
//     return;
// 
//     dam = number_range(  135, 200 );
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
//     return;
// 
//     dam = number_range( 35, 135 );
// 
//     if ( saves_spell( level, victim, DAM_PIERCE) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_PIERCE ,TRUE);
//     return;
// }
// 
// 
// 
// 
// 
// /* *****************************************************  */
// 
// 
// 
// 
// 
// void spell_geyser (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 120, 720 );
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
//     return;
// 
//         dam = number_range( 80, 220 );
// 
//     if ( saves_spell( level, victim, DAM_FIRE) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_FIRE ,TRUE);
//     return;
// }
// 
// 
// 
// 
// void spell_pyre_strike (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 120, 720 );
// 
//     if ( saves_spell( level, victim, DAM_FIRE) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_FIRE ,TRUE);
//     return;
// 
//         dam = number_range( 80, 220 );
// 
//     if ( saves_spell( level, victim, DAM_FIRE) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_FIRE ,TRUE);
//     return;
// }
// 
// 
// 
// void spell_meteor_shower (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 120, 720 );
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
//     return;
// 
//         dam = number_range( 80, 220 );
// 
//     if ( saves_spell( level, victim, DAM_PIERCE) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_PIERCE ,TRUE);
//     return;
// }
// 
// 
// 
// void spell_sanctified_cleansing (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 120, 720 );
// 
//     if ( saves_spell( level, victim, DAM_HOLY) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_HOLY ,TRUE);
//     return;
// 
//         dam = number_range( 80, 220 );
// 
//     if ( saves_spell( level, victim, DAM_ENERGY) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_ENERGY ,TRUE);
//     return;
// }
// 
// 
// 
// void spell_abominable_strike (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 120, 720 );
// 
//     if ( saves_spell( level, victim, DAM_NEGATIVE) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_NEGATIVE ,TRUE);
//     return;
// 
//         dam = number_range( 80, 220 );
// 
//     if ( saves_spell( level, victim, DAM_ENERGY) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_ENERGY ,TRUE);
//     return;
// }
// 
// 
// 
// void spell_vacuum (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = number_range( 120, 720 );
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
//     return;
// 
//         dam = number_range( 80, 220 );
// 
//     if ( saves_spell( level, victim, DAM_COLD) )
//         dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_COLD ,TRUE);
//     return;
// }
// 
// 
// 
// /* *****************************************************  */
// 
// 
// 
// 
// 
// void spell_hail( int sn, int level, CHAR_DATA *ch, void *vo, int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = dice( level, 32 );
// 
//     if ( saves_spell( level, victim, DAM_COLD ) )
//                 dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_COLD, TRUE);
//     return;
// 
//         dam = dice( level, 8 );
// 
//     if ( saves_spell( level, victim, DAM_BASH ) )
//                 dam /= 3;
// 
//     damage( ch, victim, dam, sn, DAM_BASH, TRUE);
//     return;
// }
// 
// 
// 
// void spell_plasma_blast ( int sn, int level, CHAR_DATA *ch, void *vo, int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = dice( level, 32 );
// 
//     if ( saves_spell( level, victim, DAM_FIRE ) )
//                 dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_FIRE, TRUE);
//     return;
// 
//         dam = dice( level, 8 );
// 
//     if ( saves_spell( level, victim, DAM_ACID ) )
//                 dam /= 3;
// 
//     damage( ch, victim, dam, sn, DAM_ACID, TRUE);
//     return;
// }
// 
// 
// 
// void spell_kinetic_blast ( int sn, int level, CHAR_DATA *ch, void *vo, int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = dice( level, 32 );
// 
//     if ( saves_spell( level, victim, DAM_ENERGY ) )
//                 dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_ENERGY, TRUE);
//     return;
// 
//         dam = dice( level, 8 );
// 
//     if ( saves_spell( level, victim, DAM_ENERGY ) )
//                 dam /= 3;
// 
//     damage( ch, victim, dam, sn, DAM_ENERGY, TRUE);
//         return;
// }
// 
// 
// 
// void spell_ablution ( int sn, int level, CHAR_DATA *ch, void *vo, int target )
// {
// 
//         CHAR_DATA *victim = (CHAR_DATA *) vo;
//         int dam;
// 
//     dam = dice( level, 32 );
// 
//     if ( saves_spell( level, victim, DAM_HOLY ) )
//                 dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_HOLY, TRUE);
//     return;
// 
//         dam = dice( level, 8 );
// 
//         if ( saves_spell( level, victim, DAM_ENERGY ) )
//                 dam /= 3;
// 
//     damage( ch, victim, dam, sn, DAM_ENERGY, TRUE);
//     return;
// }
// 
// 
// 
// void spell_surcease ( int sn, int level, CHAR_DATA *ch, void *vo, int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = dice( level, 32 );
// 
//     if ( saves_spell( level, victim, DAM_NEGATIVE ) )
//                 dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_NEGATIVE, TRUE);
//     return;
// 
//         dam = dice( level, 8 );
// 
//     if ( saves_spell( level, victim, DAM_ENERGY ) )
//                 dam /= 3;
// 
//     damage( ch, victim, dam, sn, DAM_ENERGY, TRUE);
//     return;
// }
// 
// 
// 
// void spell_thunder ( int sn, int level, CHAR_DATA *ch, void *vo, int target )
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     int dam;
// 
//     dam = dice( level, 32 );
// 
//     if ( saves_spell( level, victim, DAM_BASH ) )
//                 dam /= 2;
// 
//     damage( ch, victim, dam, sn, DAM_BASH, TRUE);
//     return;
// 
//         dam = dice( level, 8 );
// 
//         if ( saves_spell( level, victim, DAM_LIGHTNING ) )
//                 dam /= 3;
// 
//     damage( ch, victim, dam, sn, DAM_LIGHTNING, TRUE);
//     return;
// }
// 
// 
// 
// /* *****************************************************  */
// 
// 
// 
// 
// 
// 
// 
// void spell_nitrogen_shower ( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// 
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
// 
//     static const sh_int dam_each[] =
// 
//     {
// 
//           0,
// 
//          80, 105, 106, 107, 108,        109, 110, 110, 120, 120,
// 
//         122, 123, 124, 125, 130,        135, 140, 145, 150, 155,
// 
//         160, 165, 170, 175, 180,        182, 184, 186, 188, 190,
// 
//               220, 240, 260, 268, 300,    302, 304, 306, 308, 350,
// 
//         362, 374, 386, 388, 400,        422, 424, 426, 428, 430
// 
//     };
// 
//     int dam;
// 
// 
// 
//     level        = UMIN(level, sizeof(dam_each)/sizeof(dam_each[0]) - 1);
// 
//     level        = UMAX(0, level);
// 
//     dam                = number_range( dam_each[level] / 2, dam_each[level] * 2 );
// 
// 
// 
//     if ( saves_spell( level, victim, DAM_BASH) )
// 
//                 dam /= 2;
// 
// 
// 
//     damage( ch, victim, dam, sn, DAM_BASH ,TRUE);
// 
//     return;
// 
// }
// 
// 
// 
// void spell_flare ( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// 
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
// 
//     static const sh_int dam_each[] =
// 
//     {
// 
//           0,
// 
//          80, 105, 106, 107, 108,        109, 110, 110, 120, 120,
// 
//         122, 123, 124, 125, 130,        135, 140, 145, 150, 155,
// 
//         160, 165, 170, 175, 180,        182, 184, 186, 188, 190,
// 
//               220, 240, 260, 268, 300,    302, 304, 306, 308, 350,
// 
//         362, 374, 386, 388, 400,        422, 424, 426, 428, 430
// 
//     };
// 
//     int dam;
// 
// 
// 
//     level        = UMIN(level, sizeof(dam_each)/sizeof(dam_each[0]) - 1);
// 
//     level        = UMAX(0, level);
// 
//     dam                = number_range( dam_each[level] / 2, dam_each[level] * 2 );
// 
// 
// 
//     if ( saves_spell( level, victim, DAM_FIRE) )
// 
//                 dam /= 2;
// 
// 
// 
//     damage( ch, victim, dam, sn, DAM_FIRE ,TRUE);
// 
//     return;
// 
// }
// 
// 
// 
// void spell_parasite ( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// 
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
// 
//     static const sh_int dam_each[] =
// 
//     {
// 
//           0,
// 
//          80, 105, 106, 107, 108,        109, 110, 110, 120, 120,
// 
//         122, 123, 124, 125, 130,        135, 140, 145, 150, 155,
// 
//         160, 165, 170, 175, 180,        182, 184, 186, 188, 190,
// 
//               220, 240, 260, 268, 300,    302, 304, 306, 308, 350,
// 
//         362, 374, 386, 388, 400,        422, 424, 426, 428, 430
// 
//     };
// 
//     int dam;
// 
// 
// 
//     level        = UMIN(level, sizeof(dam_each)/sizeof(dam_each[0]) - 1);
// 
//     level        = UMAX(0, level);
// 
//     dam                = number_range( dam_each[level] / 2, dam_each[level] * 2 );
// 
// 
// 
//     if ( saves_spell( level, victim, DAM_ACID) )
// 
//                 dam /= 2;
// 
// 
// 
//     damage( ch, victim, dam, sn, DAM_ACID ,TRUE);
// 
//     return;
// 
// }
// 
// 
// 
// void spell_catharsis ( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// 
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
// 
//     static const sh_int dam_each[] =
// 
//     {
// 
//           0,
// 
//          80, 105, 106, 107, 108,        109, 110, 110, 120, 120,
// 
//         122, 123, 124, 125, 130,        135, 140, 145, 150, 155,
// 
//         160, 165, 170, 175, 180,        182, 184, 186, 188, 190,
// 
//               220, 240, 260, 268, 300,    302, 304, 306, 308, 350,
// 
//         362, 374, 386, 388, 400,        422, 424, 426, 428, 430
// 
//     };
// 
//     int dam;
// 
// 
// 
//     level        = UMIN(level, sizeof(dam_each)/sizeof(dam_each[0]) - 1);
// 
//     level        = UMAX(0, level);
// 
//     dam                = number_range( dam_each[level] / 2, dam_each[level] * 2 );
// 
// 
// 
//     if ( saves_spell( level, victim, DAM_ENERGY) )
// 
//                 dam /= 2;
// 
// 
// 
//     damage( ch, victim, dam, sn, DAM_ENERGY ,TRUE);
// 
//     return;
// 
// }
// 
// 
// 
// void spell_ill_begotten( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// 
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
// 
//     static const sh_int dam_each[] =
// 
//     {
// 
//           0,
// 
//          80, 105, 106, 107, 108,        109, 110, 110, 120, 120,
// 
//         122, 123, 124, 125, 130,        135, 140, 145, 150, 155,
// 
//         160, 165, 170, 175, 180,        182, 184, 186, 188, 190,
// 
//               220, 240, 260, 268, 300,    302, 304, 306, 308, 350,
// 
//         362, 374, 386, 388, 400,        422, 424, 426, 428, 430
// 
//     };
// 
//     int dam;
// 
// 
// 
//     level        = UMIN(level, sizeof(dam_each)/sizeof(dam_each[0]) - 1);
// 
//     level        = UMAX(0, level);
// 
//     dam                = number_range( dam_each[level] / 2, dam_each[level] * 2 );
// 
// 
// 
//     if ( saves_spell( level, victim, DAM_ENERGY) )
// 
//                 dam /= 2;
// 
// 
// 
//     damage( ch, victim, dam, sn, DAM_ENERGY ,TRUE);
// 
//     return;
// 
// }
// 
// 
// 
// void spell_sulfur ( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// 
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
// 
//     static const sh_int dam_each[] =
// 
//     {
// 
//           0,
// 
//          80, 105, 106, 107, 108,        109, 110, 110, 120, 120,
// 
//         122, 123, 124, 125, 130,        135, 140, 145, 150, 155,
// 
//         160, 165, 170, 175, 180,        182, 184, 186, 188, 190,
// 
//               220, 240, 260, 268, 300,    302, 304, 306, 308, 350,
// 
//         362, 374, 386, 388, 400,        422, 424, 426, 428, 430
// 
//     };
// 
//     int dam;
// 
// 
// 
//     level        = UMIN(level, sizeof(dam_each)/sizeof(dam_each[0]) - 1);
// 
//     level        = UMAX(0, level);
// 
//     dam                = number_range( dam_each[level] / 2, dam_each[level] * 2 );
// 
// 
// 
//     if ( saves_spell( level, victim, DAM_ACID) )
// 
//                 dam /= 2;
// 
// 
// 
//     damage( ch, victim, dam, sn, DAM_ACID ,TRUE);
// 
//     return;
// 
// }
// 
// 
// 
// /* *****************************************************  */
// 
// 
// 
// 
// 
// void spell_brain_bulge (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// 
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
// 
//     AFFECT_DATA af;
// 
// 
// 
//     if ( is_affected( victim, sn ) )
// 
//     {
// 
//                 if (victim == ch)
// 
//                 {
// 
//                         send_to_char("You are already as intellectual as you can get!\n\r",ch);
// 
//                 }
// 
//                 else
// 
//                 {
// 
//                         act("$N can't get any smarter.",ch,NULL,victim,TO_CHAR);
// 
//                 }
// 
//                 return;
// 
//     }
// 
// 
// 
//     af.where     = TO_AFFECTS;
// 
//     af.type      = sn;
// 
//     af.level         = level;
// 
//     af.duration  = level;
// 
//     af.location  = APPLY_INT;
// 
//     af.modifier  = 1 + (level >= 18) + (level >= 25) + (level >= 32);
// 
//     af.bitvector = 0;
// 
//     affect_to_char( victim, &af );
// 
//     send_to_char( "Your brain bulges with over whelming intelligence!\n\r", victim );
// 
//     act("$n's brain bulges out.",victim,NULL,NULL,TO_ROOM);
// 
//     return;
// 
// }
// 
// 
// 
// void spell_enlightenment(int sn,int level,CHAR_DATA *ch,void *vo,int target)
// 
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
// 
//     AFFECT_DATA af;
// 
// 
// 
//     if ( is_affected( victim, sn ) )
// 
//     {
// 
//                 if (victim == ch)
// 
//                 {
// 
//                         send_to_char("You are insightful enough already!\n\r",ch);
// 
//                 }
// 
//                 else
// 
//                 {
// 
//                         act("$N sagacious already.",ch,NULL,victim,TO_CHAR);
// 
//                 }
// 
//                 return;
// 
//     }
// 
// 
// 
//     af.where     = TO_AFFECTS;
// 
//     af.type      = sn;
// 
//     af.level         = level;
// 
//     af.duration  = level;
// 
//     af.location  = APPLY_WIS;
// 
//     af.modifier  = 1 + (level >= 18) + (level >= 25) + (level >= 32);
// 
//     af.bitvector = 0;
// 
//     affect_to_char( victim, &af );
// 
//     send_to_char( "You become wise beyond your years!\n\r", victim );
// 
//     act("$n appears older and wiser.",victim,NULL,NULL,TO_ROOM);
// 
//     return;
// 
// }
// 
// 
// 
// void spell_vitality  (int sn,int level,CHAR_DATA *ch,void *vo,int target)
// 
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
// 
//     AFFECT_DATA af;
// 
// 
// 
//     if ( is_affected( victim, sn ) )
// 
//     {
// 
//                 if (victim == ch)
// 
//                 {
// 
//                         send_to_char("You have already reached your peak endurance!\n\r",ch);
// 
//                 }
// 
//                 else
// 
//                 {
// 
//                         act("$N has already reached his peak endurance.",ch,NULL,victim,TO_CHAR);
// 
//                 }
// 
//                 return;
// 
//     }
// 
// 
// 
//     af.where     = TO_AFFECTS;
// 
//     af.type      = sn;
// 
//     af.level         = level;
// 
//     af.duration  = level;
// 
//     af.location  = APPLY_CON;
// 
//     af.modifier  = 1 + (level >= 18) + (level >= 25) + (level >= 32);
// 
//     af.bitvector = 0;
// 
//     affect_to_char( victim, &af );
// 
//     send_to_char( "You are affected by a resurgence of energy!\n\r", victim );
// 
//     act("$n has a resurgence of energy.",victim,NULL,NULL,TO_ROOM);
// 
//     return;
// 
// }
// 
// 
// 
// void spell_confusion( int sn, int level, CHAR_DATA *ch, void *vo, int target )
// 
//     { /* target is unused but required for ROM 2.4 compilation, not req'don 2.3 */
// 
//        CHAR_DATA *victim = (CHAR_DATA *) vo;
//        AFFECT_DATA af;
// 
//        if ( IS_AFFECTED( victim, AFF_CONFUSE ) )
//        {
//           if ( victim == ch )
//              send_to_char( "You're already pretty confused.\n\r", ch );
//           else
//              act( "$N is confused enough as it is!", ch, NULL, victim,TO_CHAR );
//           return;
//        }
//        
//        if ( saves_spell( level , victim, DAM_MENTAL) )
//           return;
// 
//        af.type = sn;
//        af.level = level;
//        af.duration = 2 * level;
//        af.location = 0;
//        af.modifier = 0;
//        af.bitvector = AFF_CONFUSE;
//        affect_to_char( victim, &af );
//        send_to_char( "You feel very confused!\n\r", victim );
//        act( "$n looks very dizzy and confused.", victim, NULL, NULL, TO_ROOM );
//        return;
// 
//     }

// /*from rot 1.4 */
// 
// void spell_protection_voodoo(int sn,int level,CHAR_DATA *ch,void *vo,int target)
// {
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if ( IS_AFFECTED(victim, SHD_PROTECT_VOODOO) )
//     {
//         return;
//     }
//     af.where        = TO_SHIELDS;
//     af.type        = sn;
//     af.level        = level;
//     af.duration        = level;
//     af.location        = APPLY_NONE;
//     af.modifier        = 0;
//     af.bitvector = SHD_PROTECT_VOODOO;
//     affect_to_char( victim, &af );
//     return;
// }
// 
// void spell_empower( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
//     OBJ_DATA *object;
//     char buf[MAX_STRING_LENGTH];
//     char *name;
//     int new_sn;
//     int mana;
//     int newmana;
//     int newtarget;
// 
//     if ( ( new_sn = find_spell( ch,target_name ) ) < 0
//     || ( !IS_NPC(ch) && (ch->level < skill_table[new_sn].skill_level[ch->class]
//     ||                   ch->pcdata->learned[new_sn] == 0)))
//     {
//         send_to_char( "What spell do you wish to bind?\n\r", ch );
//         return;
//     }
// 
//     name = skill_table[new_sn].name;
//     if (!strcmp(name, "empower") )
//     {
//         send_to_char( "You failed.\n\r", ch );
//         return;
//     }
//     newtarget = skill_table[new_sn].target;
//     if (ch->level + 2 == skill_table[sn].skill_level[ch->class])
//         mana = 50;
//     else
//             mana = UMAX(
//             skill_table[sn].min_mana,
//             100 / ( 2 + ch->level - skill_table[sn].skill_level[ch->class] ) );
// 
//     if (ch->level + 2 == skill_table[new_sn].skill_level[ch->class])
//         newmana = 50;
//     else
//             newmana = UMAX(
//             skill_table[new_sn].min_mana,
//             100 / ( 2 + ch->level - skill_table[new_sn].skill_level[ch->class] ) );
// 
//     if ( (ch->mana - mana - newmana) < 0)
//     {
//         send_to_char( "You do not have enough mana.\n\r", ch );
//         return;
//     }
//     ch->mana -= newmana;
// 
//     if ((newtarget == TAR_CHAR_DEFENSIVE) || (newtarget == TAR_CHAR_SELF))
//     {
//         object = create_object(get_obj_index(OBJ_VNUM_POTION), 0);
//     }
//     else
//     {
//         object = create_object(get_obj_index(OBJ_VNUM_SCROLL), 0);
//     }
//     object->value[0] = ch->level;
//     object->value[1] = new_sn;
//     object->level = ch->level-5;
// 
//     sprintf( buf, "%s%s", object->short_descr, name);
//     free_string(object->short_descr);
//     object->short_descr = str_dup(buf);
// 
//     if ((newtarget == TAR_CHAR_DEFENSIVE) || (newtarget == TAR_CHAR_SELF))
//     {
//         sprintf( buf, "$n has created a potion of %s!",name);
//         act(buf,ch,object,NULL,TO_ROOM);
//         sprintf( buf, "You create a potion of %s!\n\r",name);
//         send_to_char(buf,ch);
//     }
//     else
//     {
//         sprintf( buf, "$n has created a scroll of %s!",name);
//         act(buf,ch,object,NULL,TO_ROOM);
//         sprintf( buf, "You create a scroll of %s!\n\r",name);
//         send_to_char(buf,ch);
//     }
//     obj_to_char(object,ch);
//     return;
// }
// 
// void spell_resurrect( int sn, int level, CHAR_DATA *ch, void *vo, int target)
// {
//     char buf[MAX_STRING_LENGTH];
//     char arg[MAX_STRING_LENGTH];
//     MOB_INDEX_DATA *pMobIndex;
//     OBJ_DATA *obj;
//     OBJ_DATA *cobj;
//     OBJ_DATA *obj_next;
//     CHAR_DATA *pet;
//     int        length;
// 
//     if ( ( obj = get_obj_here( ch, "corpse" ) ) == NULL )
//     {
//         send_to_char( "There's no corpse here.\n\r", ch );
//         return;
//     }
//     if ( ch->pet != NULL )
//     {
//         send_to_char("You failed.\n\r",ch);
//         return;
//     }
//     pMobIndex = get_mob_index( MOB_VNUM_CORPSE );
//     pet = create_mobile( pMobIndex );
//     if (!IS_SET(pet->act, ACT_PET) ) 
//         SET_BIT(pet->act, ACT_PET);
//     if (!IS_SET(pet->affected_by, AFF_CHARM) ) 
//         SET_BIT(pet->affected_by, AFF_CHARM);
//     pet->comm = COMM_NOTELL|COMM_NOSHOUT|COMM_NOCHANNELS;
//     sprintf( buf, "%s{GThe mark of %s is on it's forehead.{x.\n\r",
//         pet->description, ch->name );
//     free_string( pet->description );
//     pet->description = str_dup( buf );
//     free_string( pet->short_descr );
//     pet->short_descr = str_dup( str_replace(obj->short_descr, "corpse", "zombie") );
//     sprintf( buf, "%s", str_replace(obj->description, "corpse", "zombie") );
//     length = strlen(buf)-12;
//     strncpy( arg, buf, length);
//     arg[length] = '\0';
//     sprintf( buf, "%s standing here.\n\r", arg);
//     free_string( pet->long_descr );
//     pet->long_descr = str_dup( buf );
//     char_to_room( pet, ch->in_room );
//     add_follower( pet, ch );
//     pet->leader = ch;
//     ch->pet = pet;
//     pet->alignment = ch->alignment;
//     pet->level = UMAX(1, UMIN(109, ((ch->level/2)+(obj->level/2))));
//     pet->max_hit = pet->level * 15;
//     pet->hit = pet->max_hit;
//     pet->armor[0] = pet->level/6;
//     pet->armor[1] = pet->level/6;
//     pet->armor[2] = pet->level/6;
//     pet->armor[3] = pet->level/8;
//     for ( cobj = obj->contains; cobj != NULL; cobj = obj_next )
//     {
//         obj_next = cobj->next_content;
//         obj_from_obj( cobj );
//         obj_to_room( cobj, ch->in_room );
//     }
//     extract_obj( obj );
//     sprintf( buf, "%s stands up and starts following you.\n\r", pet->short_descr);
//     send_to_char( buf, ch);
//     sprintf( buf, "%s stands up and starts following $n.", pet->short_descr);
//     act( buf, ch, NULL, NULL, TO_ROOM);
//     return;
// }
// 
// void spell_conjure( int sn, int level, CHAR_DATA *ch, void *vo, int target)
// {
//     char buf[MAX_STRING_LENGTH];
//     MOB_INDEX_DATA *pMobIndex;
//     OBJ_DATA *stone;
//     CHAR_DATA *pet;
//  
//     if (IS_NPC(ch))
//         return;
// 
//     stone = get_eq_char(ch,WEAR_HOLD);
//     if (!IS_IMMORTAL(ch) 
//     &&  (stone == NULL || stone->item_type != ITEM_DEMON_STONE))
//     {
//         send_to_char("You lack the proper component for this spell.\n\r",ch);
//         return;
//     }
// 
//     if ( ch->pet != NULL )
//     {
//         send_to_char("You failed.\n\r",ch);
//         return;
//     }
// 
//     if (stone != NULL && stone->item_type == ITEM_DEMON_STONE)
//     {
//         if (stone->value[0] < 1)
//         {
//             act("You draw upon the power of $p.",ch,stone,NULL,TO_CHAR);
//             act("$n draws upon the power of $p.",ch,stone,NULL,TO_ROOM);
//             act("It flares brightly and explodes into dust.",ch,stone,NULL,TO_CHAR);
//             act("It flares brightly and explodes into dust.",ch,stone,NULL,TO_ROOM);
//             extract_obj( stone );
//             return;
//         }
//     }
// 
//     pMobIndex = get_mob_index( MOB_VNUM_DEMON );
//     pet = create_mobile( pMobIndex );
//     if (!IS_SET(pet->act, ACT_PET) )
//         SET_BIT(pet->act, ACT_PET);
//     if (!IS_SET(pet->affected_by, AFF_CHARM) )
//         SET_BIT(pet->affected_by, AFF_CHARM);
//     pet->comm = COMM_NOTELL|COMM_NOSHOUT|COMM_NOCHANNELS;
//     sprintf( buf, "%s{GThe mark of %s is on it's forehead.{x.\n\r",
//         pet->description, ch->name );
//     free_string( pet->description );
//     pet->description = str_dup( buf );
//     char_to_room( pet, ch->in_room );
//     if (stone != NULL && stone->item_type == ITEM_DEMON_STONE)
//     {
//         stone->value[0] = UMAX(0, stone->value[0]-1);
//         act("You draw upon the power of $p.",ch,stone,NULL,TO_CHAR);
//         act("$n draws upon the power of $p.",ch,stone,NULL,TO_ROOM);
//         act("It flares brightly and $N appears.",ch,stone,pet,TO_CHAR);
//         act("It flares brightly and $N appears.",ch,stone,pet,TO_ROOM);
//     } else
//     {  
//         act("$N suddenly appears in the room.",ch,NULL,pet,TO_CHAR);
//         act("$N suddenly appears in the room.",ch,NULL,pet,TO_ROOM);
//     }
//     add_follower( pet, ch );
//     pet->leader = ch;
//     ch->pet = pet;
//     pet->alignment = ch->alignment;
//     pet->level = ch->level;
//     pet->max_hit = pet->level * 30;
//     pet->hit = pet->max_hit;
//     pet->armor[0] = pet->level/2;
//     pet->armor[1] = pet->level/2;
//     pet->armor[2] = pet->level/2;
//     pet->armor[3] = pet->level/3;
// 
//     return;
// }
// 
// void spell_iceshield( int sn, int level, CHAR_DATA *ch, void *vo, int target)
// {
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if (IS_SHIELDED(victim, SHD_ICE))
//     {
//         if(victim == ch)
//             send_to_char("You are already surrounded by an {Cicy{x shield.\n\r", ch);
//         else
//             act("$N is already surrounded by an {Cicy{x shield.",ch,NULL,victim,TO_CHAR);
//         return;
//     }
// 
//     if (IS_NPC(victim))
//     {
//         send_to_char("You failed.\n\r", ch);
//         return;
//     }
// 
// /*
//     if ( (skill_table[sn].skill_level[victim->class] > LEVEL_HERO)
//         && (victim->level < LEVEL_IMMORTAL) )
//     {
//         send_to_char("You are surrounded by an {Cicy{x shield.\n\r", victim);
//         act("$n is surrounded by an {Cicy{x shield.",victim, NULL,NULL,TO_ROOM);
//         send_to_char("Your {Cicy{x shield quickly melts away.\n\r", victim);
//         act("$n's {Cicy{x shield quickly melts away.",victim, NULL,NULL,TO_ROOM);
//         return;
//     }
// */
// 
//     af.where     = TO_SHIELDS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = level/6;
//     af.location  = APPLY_NONE;
//     af.modifier  = 0;
//     af.bitvector = SHD_ICE;
// 
//    affect_to_char(victim, &af);
//    send_to_char("You are surrounded by an {Cicy{x shield.\n\r", victim);
//    act("$n is surrounded by an {Cicy{x shield.",victim, NULL,NULL,TO_ROOM);
//    return;
// }
// 
// void spell_fireshield(int sn, int level, CHAR_DATA *ch, void *vo, int target)
// {
//    
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if (IS_SHIELDED(victim, SHD_FIRE))
//     {
//         if (victim == ch)
//             send_to_char("You are already surrounded by a {Rfirey{x shield.\r\n", ch);
//         else
//             act("$N is already surrounded by a {Rfiery{x shield.",ch,NULL,victim,TO_CHAR);
//         return;
//     }
// 
//     if (IS_NPC(victim))
//     {
//         send_to_char("You failed.\n\r", ch);
//         return;
//     }
// 
// /*
//     if ( (skill_table[sn].skill_level[victim->class] > LEVEL_HERO)
//         && (victim->level < LEVEL_IMMORTAL) )
//     {
//         send_to_char("You are surrounded by a {Rfiery{x shield.\n\r", victim);
//         act("$n is surrounded by a {Rfiery{x shield.",victim, NULL,NULL,TO_ROOM);
//         send_to_char("Your {Rfirey{x shield gutters out.\n\r", victim);
//         act("$n's {Rfirey{x shield gutters out.",victim, NULL,NULL,TO_ROOM);
//         return;
//     }
// */
// 
//     af.where     = TO_SHIELDS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = level/6;
//     af.location  = APPLY_NONE;
//     af.modifier  = 0;
//     af.bitvector = SHD_FIRE;
// 
//     affect_to_char(victim, &af);
//     send_to_char("You are surrounded by a {Rfiery{x shield.\n\r", victim);
//     act("$n is surrounded by a {Rfiery{x shield.",victim, NULL,NULL,TO_ROOM);
//     return;
// 
// }
// 
// void spell_shockshield(int sn, int level, CHAR_DATA *ch, void *vo, int target)
// {
// 
//     CHAR_DATA *victim = (CHAR_DATA *) vo;
//     AFFECT_DATA af;
// 
//     if (IS_SHIELDED(victim, SHD_SHOCK))
//     {
//         if (victim == ch)
//             send_to_char("You are already surrounded in a {Bcrackling{x shield.\n\r", ch);
//         else
//             act("$N is already surrounded by a {Bcrackling{x shield.",ch, NULL, victim, TO_CHAR);
//         return;
//     }
// 
//     if (IS_NPC(victim))
//     {
//         send_to_char("You failed.\n\r", ch);
//         return;
//     }
// 
// /*
//     if ( (skill_table[sn].skill_level[victim->class] > LEVEL_HERO)
//         && (victim->level < LEVEL_IMMORTAL) )
//     {
//         send_to_char("You are surrounded by a {Bcrackling{x shield.\n\r", victim);
//         act("$n is surrounded by a {Bcrackling{x shield.",victim, NULL,NULL,TO_ROOM);
//         send_to_char("Your {Bcrackling{x shield sizzles and fades.\n\r", victim);
//         act("$n's {Bcrackling{x shield sizzles and fades.",victim, NULL,NULL,TO_ROOM);
//         return;
//     }
// */
// 
//     af.where     = TO_SHIELDS;
//     af.type      = sn;
//     af.level     = level;
//     af.duration  = level/6;
//     af.location  = APPLY_NONE;
//     af.modifier  = 0;
//     af.bitvector = SHD_SHOCK;
// 
//     affect_to_char(victim, &af);
//     send_to_char("You are surrounded by a {Bcrackling{x field.\n\r",victim);
//     act("$n is surrounded by a {Bcrackling{x shield.",victim, NULL,NULL, TO_ROOM);
//     return;
// }
// 
// void spell_voodoo( int sn, int level, CHAR_DATA *ch, void *vo,int target )
// {
//     char name[MAX_INPUT_LENGTH];
//     char buf[MAX_STRING_LENGTH];
//     OBJ_DATA *bpart;
//     OBJ_DATA *doll;
// 
//     bpart = get_eq_char(ch,WEAR_HOLD);
//     if  ((bpart == NULL)
//     ||   (bpart->pIndexData->vnum < 12)
//     ||   (bpart->pIndexData->vnum > 17))
//     {
//         send_to_char("You are not holding a body part.\n\r",ch);
//         return;
//     }
//     if (bpart->value[4] == 0)
//     {
//         send_to_char("This body part is from a mobile.\n\r",ch);
//         return;
//     }
//     one_argument(bpart->name, name);
//     doll = create_object(get_obj_index(OBJ_VNUM_VOODOO), 0);
//     sprintf( buf, doll->short_descr, name );
//     free_string( doll->short_descr );
//     doll->short_descr = str_dup( buf );
//     sprintf( buf, doll->description, name );
//     free_string( doll->description );
//     doll->description = str_dup( buf );
//     sprintf( buf, doll->name, name );
//     free_string( doll->name );
//     doll->name = str_dup( buf );
//     act( "$p morphs into a voodoo doll",ch,bpart,NULL,TO_CHAR);
//     obj_from_char( bpart );
//     obj_to_char(doll,ch);
//     equip_char(ch,doll,WEAR_HOLD);
//     act( "$n has created $p!", ch, doll, NULL, TO_ROOM );
//     return;
// }
