/* $Id: magic_gm.c,v 1.666 2004/09/20 10:49:50 shrike Exp $                          */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "merc.h"
#include "fight.h"
#include "quest.h"
#include "gquest.h"
#include "rating.h"
#include "fight.h"
#include "cyborg.h"
#include "skills.h"
#include "update.h"
#include "psionics.h"
#include "wanderers.h"
#include "conquer.h"

extern const char *target_name;

extern bool check_spellbane(CHAR_DATA *ch, CHAR_DATA *victim, int sn);
extern bool check_dodge    (CHAR_DATA *ch, CHAR_DATA *victim);
extern void group_gain     (CHAR_DATA *ch, CHAR_DATA *victim);

bool dispel1      (int level, CHAR_DATA *ch, int sn);

SPELL_FUN(spell_carrion_swarm)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam, chance = 200;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    chance -= (level - LVL(victim));
    chance -= get_curr_stat(ch, STAT_LCK);
    
    if (number_range(1,chance) == 1 
        && victim->level < (level + (level / 4))
        && !IS_CLAN_GUARD(victim)
        && !IS_IMMORTAL(victim)
        && IS_NPC(victim)
        && !IS_SET(victim->abilities, EA_IMMUN_INSTANT))
    {
        act("Your carrion swarm instantly kills $N{x.",
            ch, NULL, victim, TO_CHAR);
        act("$n's carrion swarm instantly kills $N.",
            ch, NULL, victim, TO_NOTVICT);
        act("$n's carrion swarm instantly kills you.",
            ch, NULL, victim, TO_VICT);
        victim->position = POS_DEAD;
        handle_death(ch, victim);
        return;
    }

    dam = number_range(level*12, level*18);
    if (saves_spell(level, victim, DAM_MAGIC))
        dam /= 2;
    damage(ch, victim, dam, sn, DAM_MAGIC, TRUE);
    
    return;
}

SPELL_FUN(spell_detect_trap)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("     .", ch);
        else
            act("$N     .",
                ch, NULL, victim, TO_CHAR);
        return;
    }

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = number_fuzzy(1);
    af.location     = APPLY_NONE;
    af.modifier     = 0;
    af.bitvector    = AFF_DETECT_TRAP;
    affect_to_char(victim, &af);

    char_act("  .", victim);
    if (ch != victim)
        char_act("Ok.", ch);
}

SPELL_FUN(spell_computer_breath)
{
    CHAR_DATA *gch;
    AFFECT_DATA af;

    char_act("You breath forth an instance that increases CPU speed.", ch);
    act_puts("$n breathes forth an instance that increases CPU speed.", ch, NULL, NULL, TO_ROOM, POS_RESTING);

    for (gch = ch->in_room->people; gch != NULL; gch = gch->next_in_room) 
    {

        if (!IS_CYBORG(gch)) continue;
 
        if (is_affected(gch, gsn_computer_breath)) 
        {
            char_act("Your CPU is already as fast as it can be.", gch);
            continue;
        }

        char_act("Your processor's speed increases!", gch);
        act_puts("$n's CPU speed increases!", gch, NULL, NULL, TO_ROOM, POS_RESTING);

        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = level / 12;
        af.location  = APPLY_LEVEL;
        af.modifier  = 2;
        af.bitvector = 0;
        affect_to_char(gch, &af);
    }
}

SPELL_FUN(spell_plasma_flux)
{
    CHAR_DATA *vch, *vch_next;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    char_act("You direct {Ra wave of a hot plasma{z into the room.", ch);
    act("$n directs {Ra wave of hot plasma{z into the room.", ch, NULL, NULL, TO_ROOM);

    dam = dice(level, 14);
    fire_effect(ch->in_room,level,dam/2,TARGET_ROOM);
    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe_spell(ch,vch,TRUE) || is_same_group(vch, ch))
            continue;

        if (saves_spell(level,vch,DAM_FIRE))
        {
            fire_effect(vch,level/2,dam/4,TARGET_CHAR);
            damage(ch,vch,dam/2,sn,DAM_FIRE,TRUE);
        }
        else
        {
            fire_effect(vch,level,dam,TARGET_CHAR);
            damage(ch,vch,dam,sn,DAM_FIRE,TRUE);
        }
    }
}

SPELL_FUN(spell_vortex)
{
    CHAR_DATA *victim;
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    ROOM_INDEX_DATA *pRoomIndex;
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
      char_act("     .", ch);
      return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_NORECALL))
    {
        char_act("      .", ch);
        return;
    }

        victim = get_char_world(ch, target_name);

    if (victim == NULL)
    {
        char_act("   .", ch);
        return;
    }

    if (ch->in_room->area->planet != victim->in_room->area->planet)
    {
        char_act("You need known star transportation for this.", ch);
        return;
    }

    if(is_gquest_mob (victim))
    {
        char_act("    .      .", ch);
        return;
    }

    if (victim->level >= level + 3
    || saves_spell(level, victim, DAM_MAGIC)
    || IS_RAFFECTED(victim->in_room, RAFF_ESPIRIT)
    || !can_gate(ch, victim))
    {
        char_act("   .", ch);
        return;
    }

    act("$n ,     .",ch, NULL, NULL, TO_ROOM);
    char_act(" ,     .", ch);

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe(ch, vch) || IS_IMMORTAL(vch)
        || vch == ch || (number_percent() > 50))
            continue;

        if (check_spellbane(ch, vch, sn))
            continue;

        if (((IS_NPC(vch) && !IS_SET(vch->pIndexData->act, ACT_AGGRESSIVE))
        || !IS_NPC(vch)) && is_immune(vch, DAM_SUMMON))
        {
            for (; ;)
            {
                pRoomIndex = get_room_index(number_range(0, 65535));
                if (pRoomIndex != NULL
                && can_see_room(ch, pRoomIndex)
                && !room_is_private(pRoomIndex)
                && !IS_SET(pRoomIndex->area->flags, AREA_UNDER_CONSTRUCTION)
                && !IS_SET(pRoomIndex->room_flags, ROOM_NORECALL)
                && guild_check(vch, pRoomIndex) >= 0)
                    break;
            }

            act("   !", vch, NULL, NULL, TO_CHAR);
            act(" $n !", vch, NULL, NULL, TO_ROOM);
            char_from_room(vch);
            char_to_room(vch, pRoomIndex);
            act("$n    .",vch, NULL, NULL, TO_ROOM);
            do_look(vch, "auto");
        }
    }

    char_from_room(ch);
    char_to_room(ch, victim->in_room);

    act("$n    .", ch, NULL, NULL, TO_ROOM);
    do_look(ch,"auto");

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (is_safe(ch, vch) || IS_IMMORTAL(vch)
        || vch == ch || (number_percent() > 26))
            continue;

        if (check_spellbane(ch, vch, sn))
            continue;

        if (((IS_NPC(vch) && !IS_SET(vch->pIndexData->act, ACT_AGGRESSIVE))
        || !IS_NPC(vch)) && is_immune(vch, DAM_SUMMON))
        {
            for (; ;)
            {
                pRoomIndex = get_room_index(number_range(0, 65535));
                if (pRoomIndex != NULL
                && can_see_room(ch, pRoomIndex)
                && !room_is_private(pRoomIndex)
                && !IS_SET(pRoomIndex->area->flags, AREA_UNDER_CONSTRUCTION)
                && !IS_SET(pRoomIndex->room_flags, ROOM_NORECALL)
                && guild_check(vch, pRoomIndex) >= 0)
                    break;
            }

            act("   !", vch, NULL, NULL, TO_CHAR);
            act(" $n !", vch, NULL, NULL, TO_ROOM);
            char_from_room(vch);
            char_to_room(vch, pRoomIndex);
            act("$n    .", vch, NULL, NULL, TO_ROOM);
            do_look(vch, "auto");
        }
    }

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 5;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    af.bitvector    = 0;
    affect_to_char(ch, &af);

}

SPELL_FUN(spell_clan_aura)
{
    AFFECT_DATA af;
    CHAR_DATA *vch = vo;

    for (vch = ch->in_room->people; vch != NULL; vch = vch->next_in_room)
    {
        if (!is_same_group(vch, ch))
            continue;

        if (check_spellbane(ch, vch, sn))
            continue;

        if (IS_MECH(vch))
            continue;

        if (is_affected(vch, sn))
        {
            if (vch == ch)
                char_act("{W {x   .", ch);
            else
                act("$N     {W {x.",
                    ch, NULL, vch, TO_CHAR);
            continue;
        }

        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = 1 + level;

        af.modifier  = -level;
        af.location  = APPLY_AC;
        af.bitvector = 0;
        affect_to_char(vch, &af);

        af.modifier  = level / 4;
        af.location  = APPLY_HITROLL;
        af.bitvector = 0;
        affect_to_char(vch, &af);

        af.modifier  = level / 9;
        af.location  = APPLY_DAMROLL;
        af.bitvector = 0;
        affect_to_char(vch, &af);

        af.where     = TO_AFFECTS;
        af.modifier  = -10;
        af.location  = APPLY_SAVING_SPELL;
        af.bitvector = 0;
        affect_to_char(vch, &af);

        af.where     = TO_AFFECTS;
        af.modifier  = level;
        af.location  = APPLY_HIT;
        af.bitvector = 0;
        affect_to_char(vch, &af);

        af.where     = TO_AFFECTS;
        af.modifier  = level * 2;
        af.location  = APPLY_MANA;
        af.bitvector = 0;
        affect_to_char(vch, &af);

        af.where     = TO_AFFECTS;
        af.modifier  = level;
        af.location  = APPLY_MOVE;
        af.bitvector = 0;
        affect_to_char(vch, &af);

        af.where     = TO_AFFECTS;
        af.modifier  = 2;
        af.location  = APPLY_STR;
        af.bitvector = 0;
        affect_to_char(vch, &af);

        af.where     = TO_AFFECTS;
        af.modifier  = 2;
        af.location  = APPLY_DEX;
        af.bitvector = 0;
        affect_to_char(vch, &af);

        af.where     = TO_AFFECTS;
        af.modifier  = 2;
        af.location  = APPLY_SIZE;
        af.bitvector = 0;
        affect_to_char(vch, &af);
/*
        af.where     = TO_RESIST;
        af.modifier  = 40;
        af.location  = APPLY_NONE;
        af.bitvector = DAM_ENERGY;
        affect_to_char(vch, &af);
*/
        char_act("   {W {x  .", vch);
        if (ch != vch)
            act("{W {x  $N.", ch, NULL, vch, TO_CHAR);
    }
}

SPELL_FUN(spell_fire_shield)
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *fire;
    AFFECT_DATA af;

    target_name = one_argument(target_name, arg, sizeof(arg));
    if (!(!str_cmp(arg,"cold") || !str_cmp(arg,"fire"))) 
    {
        char_act("   .", ch);
        return;
    }

    fire    = create_named_obj(get_obj_index(OBJ_VNUM_FIRE_SHIELD), 0, arg);
    fire->owner = str_dup(ch->name);
    fire->altar = get_altar(ch);
    fire->level = ch->level;
    fire->ed = ed_new2(fire->pIndexData->ed, arg);

    fire->level = ch->level;
    fire->cost = 0;
    fire->timer = 5 * ch->level ;

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = -1;
    af.location  = APPLY_HIT;
    af.modifier  = level * 2;
    af.bitvector = 0;
    affect_to_obj(fire, &af);

    af.modifier     = level * 4;
    af.location  = APPLY_MANA;
    affect_to_obj(fire, &af);

    af.modifier     = level / 20;
    af.location     = APPLY_HITROLL;
    affect_to_obj(fire,&af);

    af.modifier     = level / 20;
    af.location     = APPLY_DAMROLL;
    affect_to_obj(fire,&af);

    af.modifier = - 5;
    af.location = APPLY_SAVING_SPELL;
    affect_to_obj(fire, &af);

    if (IS_GOOD(ch))
        SET_BIT(fire->extra_flags,(ITEM_ANTI_NEUTRAL | ITEM_ANTI_EVIL));
    else if (IS_NEUTRAL(ch))
        SET_BIT(fire->extra_flags,(ITEM_ANTI_GOOD | ITEM_ANTI_EVIL));
    else if (IS_EVIL(ch))
        SET_BIT(fire->extra_flags,(ITEM_ANTI_NEUTRAL | ITEM_ANTI_GOOD));
    obj_to_char(fire, ch);
    char_act("  {W {R{x!", ch);
}

SPELL_FUN(spell_sensors)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        char_act("   .",ch);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = (5 + level / 3);
    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = AFF_DETECT_EVIL;
    affect_to_char(victim, &af);

    af.bitvector = AFF_DETECT_GOOD;
    affect_to_char(victim, &af);

    af.bitvector = AFF_DETECT_INVIS;
    affect_to_char(victim, &af);

    af.bitvector = AFF_DETECT_MAGIC;
    affect_to_char(victim, &af);

    af.bitvector = AFF_DETECT_UNDEAD;
    affect_to_char(victim, &af);

    if (number_percent() < (get_skill(ch, gsn_life_sensor))) 
    {
        check_improve(ch, gsn_life_sensor, TRUE, 4);
        af.bitvector = AFF_DETECT_LIFE;
        affect_to_char(victim, &af);
    }

    if (number_percent() < (get_skill(ch, gsn_stealth_suit)))
    {
        check_improve(ch, gsn_stealth_suit, TRUE, 4);
        af.bitvector = AFF_DETECT_HIDDEN;
        affect_to_char(victim, &af);
    }

    if (number_percent() < (get_skill(ch, gsn_stealth_field))) 
    {
        check_improve(ch, gsn_stealth_field, TRUE, 4);
        af.bitvector = AFF_DETECT_IMP_INVIS;
        affect_to_char(victim, &af);
    }

    char_act("  .", victim);

    if (ch != victim)
        char_act("Ok.", ch);
    return;
}

SPELL_FUN(spell_energy_missiles)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;
    int nmissiles;

    if (IS_AFFECTED(ch,AFF_FEAR)){
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(victim, gsn_protective_shield) && number_percent() < (80 + (get_skill(victim, gsn_jammer)/5)))  {
        check_improve(victim, gsn_jammer, TRUE, 1);
        act("  $N    !",
            ch, NULL, victim, TO_CHAR);
        act("ϣ     ,  $N!",
            victim, NULL, ch, TO_CHAR);
        return;
    }

    nmissiles = UMAX(1, level/15 + (get_skill(ch, gsn_fast_missile_racks)/80));
    while (nmissiles--) 
    {
        check_improve(ch, gsn_mirv, TRUE, 1);
        dam = (number_range(level, 3*level/2) + (get_skill(ch, gsn_mirv)/10));

        if (saves_spell(level, victim, DAM_ENERGY))
            dam /= 2;

        damage(ch, victim, dam, sn, DAM_ENERGY ,TRUE);

        check_improve(ch, gsn_fast_missile_racks, TRUE, 1);
        check_improve(ch, gsn_eccm, TRUE, 1);
        if (JUST_KILLED(victim)) 
            return;
        if (number_percent() > (nmissiles*40+(get_skill(ch, gsn_eccm)/20))) 
            return;
    }
    return;
}

SPELL_FUN(spell_plasma_torpedoes)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;
    int nmissiles;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    nmissiles = UMAX(1, level/18 + (get_skill(ch, gsn_fast_missile_racks)/43));
    if (nmissiles > 10)
        nmissiles = 10;

    while (nmissiles--) 
    {
        check_improve(ch, gsn_mirv, TRUE, 1);
        dam = (number_range(level/2, level*2) + (get_skill(ch, gsn_mirv)));

        if (saves_spell(level, victim, DAM_FIRE))
            dam /= 2;
        else 
        {
            if ((nmissiles == 1) || (nmissiles == 2))
                fire_effect(victim, level, dam*3, TARGET_CHAR);
        }

        if (number_percent() < (get_skill(ch, gsn_overloaded)*2/3))
        {
            dam *= (level/45);
            check_improve(ch, gsn_overloaded, TRUE, 1);
            act("    !",
                ch, NULL, victim, TO_CHAR);
            act("$N    !",
                victim, NULL, ch, TO_CHAR);
        }
        else
            check_improve(ch, gsn_overloaded, FALSE, 1);

        damage(ch, victim, dam, sn, DAM_FIRE ,TRUE);

        if ((number_percent() < (level-LVL(ch)*3)) && (!is_affected(victim, gsn_faerie_fire)))
            spell_faerie_fire(gsn_faerie_fire,level,ch,victim, TARGET_CHAR);

        check_improve(ch, gsn_fast_missile_racks, TRUE, 1);
        check_improve(ch, gsn_eccm, TRUE, 1);
        if (JUST_KILLED(victim)) 
            return;
        if (number_percent() > (nmissiles*40+(get_skill(ch, gsn_eccm)/10))) 
            return;
    }
    return;
}

SPELL_FUN(spell_cloaking_device)
{
    OBJ_DATA *device, *floating;
    AFFECT_DATA af;

    floating = get_eq_char(ch,WEAR_PLUG_IN);
    if (floating != NULL && IS_OBJ_STAT(floating, ITEM_NOREMOVE))
    {
        act("  $p.", ch, floating, NULL, TO_CHAR);
        return;
    }

    device = create_obj(get_obj_index(OBJ_VNUM_DEVICE), 0);
    device->value[0]    = ch->level;
    device->value[1]    = ch->level;
    device->value[2]    = ch->level;
    device->value[3]    = ch->level;
//    device->value[4]    = (15 - (ch->level/10));
//    device->timer       = ch->level * 2;
    device->owner       = str_dup(ch->name);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = -1;
    af.location     = APPLY_HIT;
    af.modifier     = level * 3;
    af.bitvector    = 0;
    affect_to_obj(device, &af);

    af.modifier     = level * 6;
    af.location     = APPLY_MANA;
    affect_to_obj(device, &af);

    af.modifier     = level / 10;
    af.location     = APPLY_HITROLL;
    affect_to_obj(device,&af);

    af.modifier     = level / 10;
    af.location     = APPLY_DAMROLL;
    affect_to_obj(device,&af);

    af.modifier = - 5;
    af.location = APPLY_SAVING_SPELL;
    affect_to_obj(device, &af);

    af.modifier  = 0;
    af.bitvector = AFF_INVIS;
    affect_to_obj(device, &af);

    if (number_percent() < (get_skill(ch, gsn_stealth_suit))) 
    {
        check_improve(ch, gsn_stealth_suit, TRUE, 1);
        af.bitvector = AFF_HIDE;
        affect_to_obj(device, &af);
    }

    if (number_percent() < (get_skill(ch, gsn_stealth_field))) 
    {
        check_improve(ch, gsn_stealth_field, TRUE, 1);
        af.bitvector = AFF_IMP_INVIS;
        affect_to_obj(device, &af);
    }

    act("$n  {D {x.",ch,NULL,NULL,TO_ROOM);
    char_act("  {D {x.", ch);
    obj_to_char(device, ch);
    wear_obj(ch, device, TRUE);
    return;
}

SPELL_FUN(spell_remove_device)
{
    OBJ_DATA *device;
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    OBJ_DATA *obj_next;

    if (IS_AFFECTED(ch, AFF_CHARM))
    {
        damage(ch, ch->master, 0, sn, DAM_NONE, FALSE);
        act("ϣ {D {z     !",
            ch, NULL, victim, TO_CHAR);
        act("$N {D {z     !",
            victim, NULL, ch, TO_CHAR);
        return;
    }

    device = 0;

    for (device = victim->carrying; device != NULL; device = obj_next)
    {
        obj_next = device->next_content;
        if (device->pIndexData->vnum == OBJ_VNUM_DEVICE)
        {
            act("ϣ $p .",ch, device, NULL, TO_CHAR);
            act("$n $p .", ch, device, NULL, TO_ROOM);

            check_improve(ch, gsn_stealth_field, TRUE, 1);
            check_improve(ch, gsn_stealth_suit, TRUE, 1);

            obj_from_char(device);
            extract_obj(device);
            continue;
        }
    }
    return;
}

// Hunters Clan spell
SPELL_FUN(spell_vision)
{
    CHAR_DATA *victim;
    AFFECT_DATA af;

    if (is_affected(ch, sn))
    {
        char_act("It is impossible use vision so often!", ch);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = IS_IMMORTAL(ch) ? 0 : 4;
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = 0;
    affect_to_char(ch, &af);

    if ((victim = get_char_world(ch, target_name)) == NULL)
    {
        char_act("Can't find victim.", ch);
        return;
    }

    if (victim->pcdata)
        if (IS_SET(victim->pcdata->wishes, WISH_SHOWSCRY))
            char_act("  -  !", victim);

    if (saves_spell(level, victim, DAM_NONE)
    || is_affected(victim, gsn_stealth))
    {
        char_act("Can't find victim.", ch);
        return;
    }

    if (ch == victim)
        do_look(ch, str_empty);
    else
    {
        if (!IS_NPC(victim) && victim->pcdata->headprice > 0)
        {
            act_puts("Found in {W$r - $T{x.", 
                ch, victim->in_room, victim->in_room->area->name, TO_CHAR, POS_DEAD);
        } else
        {
            act_puts("Found in {W$r{x.", 
                ch, victim->in_room, NULL, TO_CHAR, POS_DEAD);
        }
    }
}

// , ,   .
SPELL_FUN(spell_battery)
{
    OBJ_DATA *battery;
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    OBJ_DATA *obj_next;
    AFFECT_DATA af;

    if (get_eq_char(ch, WEAR_NECK_1)  != NULL) 
    {
        char_act("     .", ch);
        return;
    }

    for (battery = ch->carrying; battery != NULL; battery = obj_next)
    {
        obj_next = battery->next_content;
        if (battery->pIndexData->vnum == OBJ_VNUM_BATTERY)
        {
            act("$p .",ch, battery, NULL, TO_CHAR);
            obj_from_char(battery);
            extract_obj(battery);
            continue;
        }
    }


    battery = create_obj(get_obj_index(OBJ_VNUM_BATTERY),level);
    battery->value[0]   = ch->level;
    battery->value[1]   = ch->level;
    battery->value[2]   = ch->level;
    battery->value[3]   = ch->level;
    battery->timer      = ch->level * 3;
    battery->cost       = ch->level * 2000;
    battery->value[4]   = ch->level * 20;
    battery->owner      = str_dup(ch->name);
    battery->level      = ch->level;
    battery->weight     = ch->level * 10;

    af.where        = TO_OBJECT;
    af.type         = sn;
    af.level        = level;
    af.duration     = -1;
    af.modifier     = level;
    af.bitvector    = 0;

    af.location     = APPLY_HIT;
    affect_to_obj(battery,&af);

    af.location     = APPLY_MANA;
    affect_to_obj(battery,&af);

    af.where        = TO_OBJECT;
    af.type         = sn;
    af.level        = level;
    af.duration     = -1;
    af.modifier     = level / 8;
    af.bitvector    = 0;

    af.location     = APPLY_HITROLL;
    affect_to_obj(battery,&af);

    af.location     = APPLY_DAMROLL;
    affect_to_obj(battery,&af);


    act("    !",ch, NULL, NULL, TO_CHAR);
    act("$n    !", ch, NULL, NULL, TO_ROOM);

    obj_to_char(battery,victim);
    equip_char(ch, battery, WEAR_NECK_1);
}

SPELL_FUN(spell_cyber_bless)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("  $gn{}.", ch);
        else
            act("$N  $gN{}.",ch,NULL,victim,TO_CHAR);
        return;
    }

    if (!IS_CYBORG(victim))
    {
        char_act("    !", ch);
        return;
    }

    af.where    = TO_AFFECTS;
    af.type     = sn;
    af.level    = level;
    af.duration = 6 + level;
    af.modifier = level/8;
    af.location = APPLY_HITROLL;
    af.bitvector    = 0;
    affect_to_char(victim, &af);

    af.modifier = -10;
    af.location = APPLY_SAVING_SPELL;
    affect_to_char(victim, &af);

    char_act("     !", victim);
    if (ch != victim)
    act("  $c6{$N}!", ch, NULL, victim, TO_CHAR);
    return;
}

SPELL_FUN(spell_stellar_converter)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if  (time_info.hour > 19 || time_info.hour < 5) 
    {
         char_act("     .", ch);
         return;
    }

    if (ch->fighting != NULL) 
    {
        char_act("   .", ch);
        return;
    }

    if (number_range(1,4) == 1 
        && victim->level < (level + (level / 4))
        && !IS_CLAN_GUARD(victim)
        && IS_NPC(victim)
        && !IS_SET(victim->abilities, EA_IMMUN_INSTANT))
    {
        act("    $N   {x.",
            ch, NULL, victim, TO_CHAR);
        act("  $n  $N   .",
            ch, NULL, victim, TO_NOTVICT);
        act("  $n     .",
            ch, NULL, victim, TO_VICT);
        char_act(" {R{x   .", victim);
        victim->position = POS_DEAD;
        handle_death(ch, victim);
        return;
    }

    dam = number_range(level*60, level*80);
    if (IS_NPC(victim))
        dam *= 3;
    if (saves_spell(level, victim, DAM_ENERGY))
        dam /= 2;
    damage(ch, victim, dam, sn, DAM_ENERGY ,TRUE);
    return;
}

SPELL_FUN(spell_death_ray)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;
    int dam, exp;
    bool affect = FALSE;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_UNDEAD(victim) || IS_CYBORG(victim)) 
    {
        act("$N    !", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (IS_AFFECTED(victim, AFF_CURSE) || IS_AFFECTED(ch, AFF_CURSE)) 
    {
        act("     .", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (saves_spell(level, victim, DAM_NEGATIVE)) 
    {
        char_act("   .", victim);
        exp             = number_range(level * 2, level * 4);
        if (!IS_NPC(victim))
            gain_exp(victim, 0 - exp);
        gain_exp(ch, exp);
        dam             = dice(4, level);
        ch->hit         += dam * 2;
        damage(ch, victim, dam, sn, DAM_NEGATIVE, TRUE);
    } else 
    {
        char_act("        !", victim);
        act("     $N.", ch, NULL, victim, TO_CHAR);
        exp             = number_range(level * 4, level * 8);
        if (!IS_NPC(victim))
            gain_exp(victim, 0 - exp);
        gain_exp(ch, exp);
        victim->hit     /= 2;
        victim->mana    /= 4;
        victim->move    /= 10;
        dam             = dice(4, level);
        ch->hit         += dam * 2;
        damage(ch, victim, dam, sn, DAM_NEGATIVE, TRUE);
    }

    if (!IS_AFFECTED(ch, AFF_CURSE))
    {
        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = 1;
        af.location  = APPLY_HITROLL;
        af.modifier  = -1 * (level / 8);
        af.bitvector = AFF_CURSE;
        affect_to_char(ch, &af);

        af.location  = APPLY_SAVING_SPELL;
        af.modifier  = 10;
        af.bitvector = 0;
        affect_to_char(ch, &af);
        affect = TRUE;
    }

    if (!IS_AFFECTED(victim, AFF_CURSE)) 
    {
        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = level / 10;
        af.location  = APPLY_HITROLL;
        af.modifier  = -1 * (level/2);
        af.bitvector = AFF_CURSE;
        affect_to_char(victim, &af);

        af.location  = APPLY_SAVING_SPELL;
        af.modifier  = 10;
        af.bitvector = 0;
        affect_to_char(victim, &af);
        affect = TRUE;
    }
}

SPELL_FUN(spell_research)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    BUFFER *output;

    output = buf_new(ch->lang);
    format_obj(output, obj, IS_SET(ch->comm2, COMM2_RUSSKILLS));
    if (!IS_SET(obj->extra_flags, ITEM_ENCHANTED))
        format_obj_affects(output, obj->pIndexData->affected,
                   FOA_F_NODURATION);
    format_obj_affects(output, obj->affected, 0);
    page_to_char(buf_string(output), ch);
    buf_free(output);

    char_act(str_empty, ch);
    if (obj->pIndexData->item_type == ITEM_DRINK_CON
    || obj->pIndexData->item_type == ITEM_FOOD)
    {
        if (obj->value[3] != 0)
            char_act("    .", ch);
    }

    if (IS_IMMORTAL(ch)) 
    {
        char_act(str_empty, ch);
        char_act("Immortal Info:", ch);
        act_puts("Obj vnum: $j", ch, (const void *) (obj->pIndexData->vnum), NULL, TO_CHAR, POS_DEAD);

        if (!IS_NULLSTR(obj->owner)) 
        {
            act_puts("Owner: [$t]", ch, obj->owner, NULL, TO_CHAR, POS_DEAD);
        }
        act_puts3("Timer: $j Count: $J", ch, (const void *) (obj->timer), NULL, (const void *) (obj->pIndexData->count), TO_CHAR, POS_DEAD);
    }
}

SPELL_FUN(spell_mine)
{
// Don't delete desc stuff... GrayMage
//    char arg1 [MAX_INPUT_LENGTH];
    OBJ_DATA *mine;
    OBJ_DATA *obj;
    AFFECT_DATA af;
/*
    strnzcpy(arg1, sizeof(arg1), target_name);

    if (arg1[0] == '\0')
    {
        char_act("Syntax:", ch);
        char_act("  cast mine <lang> <string>", ch);
        return;
    }
*/
    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_LAW))
    {
        char_act("No mine in LAW zone, plz.", ch);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("One tick - one mine!", ch);
        return;
    }

    for (obj = ch->in_room->contents; obj; obj= obj->next_content)
    {
        if (obj->pIndexData->vnum == OBJ_VNUM_MINE)
        {
            act_puts("You have successfully find $p! Yes!!!", 
                ch, obj, NULL, TO_CHAR, POS_DEAD);
            act_puts("$n have successfully find $p! Yes!!!", 
                ch, obj, NULL, TO_ROOM, POS_DEAD);
            if (number_percent() > get_curr_stat(ch, STAT_LCK) / 2)
                do_get(ch, "mine");
            return;
        }
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = IS_IMMORTAL(ch) ? 0 : 1;
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = 0;
    affect_to_char(ch, &af);

    mine = create_obj(get_obj_index(OBJ_VNUM_MINE), 0);

//    mlstr_edit(&mine->description, arg1);

    mine->level = ch->level;
    if (IS_SET(ch->comm, PLR_PEACE))
        mine->timer = 1;
    else
        mine->timer = ch->level / 5;

    act_puts("You have successfully made $p.", ch, mine, NULL, TO_CHAR, POS_DEAD);
    act_puts("$n have successfully made $p.", ch, mine, NULL, TO_ROOM, POS_DEAD);
    obj_to_room(mine, ch->in_room); 

    return;
}

SPELL_FUN(spell_funpill)
{
// Don't delete desc stuff... GrayMage
//    char arg1 [MAX_INPUT_LENGTH];
    OBJ_DATA *funpill;
    AFFECT_DATA af;
    int spell1, spell2, spell3, spell4;

//    strnzcpy(arg1, sizeof(arg1), target_name);
/*
    if (arg1[0] == '\0')
    {
        char_act("Syntax:", ch);
        char_act("  execute funpill <lang> <string>", ch);
        return;
    }
*/
    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("No more FUN! Wait for right moment, man.", ch);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = IS_IMMORTAL(ch) ? 0 : number_range (1, 5);
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = 0;
    affect_to_char(ch, &af);

    funpill = create_obj(get_obj_index(OBJ_VNUM_FUNPILL), 0);

    spell1 = sn_lookup("cure serious");
    spell2 = sn_lookup("cure critical");
    spell3 = sn_lookup("cure light");
    spell4 = sn_lookup("cure light");

    funpill->value[0] = level;

    switch(number_bits(6))
    {
    case 0:
        spell1 = sn_lookup("shielding");
        break;
    case 1:
        spell1 = sn_lookup("blindness");
        break;
    case 2:
        spell1 = sn_lookup("plague");
        break;
    case 3:
        spell1 = sn_lookup("teleport");
        break;
    case 4:
        spell1 = sn_lookup("poison");
        break;
    }
    switch(number_bits(3))
    {
    case 0:
        spell2 = sn_lookup("witch curse");
        break;
    case 1:
        spell2 = sn_lookup("curse");
        break;
    case 2:
        spell2 = sn_lookup("sleep");
        break;
    }
    switch(number_bits(3))
    {
    case 0:
        spell3 = sn_lookup("heal");
        break;
    case 1:
        spell3 = sn_lookup("restore mana");
        break;
    }
    switch(number_bits(1))
    {
    case 0:
        spell4 = sn_lookup("bark skin");
        break;
    case 1:
        spell4 = sn_lookup("bless");
        break;
    }


    funpill->value[1] = spell1;
    funpill->value[2] = spell2;
    funpill->value[3] = spell3;
    funpill->value[4] = spell4;

    if (IS_SET(ch->comm, PLR_PEACE))
        funpill->timer = 1;
    else
        funpill->timer = ch->level / 2;
    funpill->level = (ch->level-(ch->level/2));

//    mlstr_edit(&funpill->short_descr, arg1);

    act_puts("You have successfully made $p.", ch, funpill, NULL, TO_CHAR, POS_DEAD);
    act_puts("$n have successfully made $p.", ch, funpill, NULL, TO_ROOM, POS_DEAD);
    obj_to_char(funpill,ch);
    return;
}

SPELL_FUN(spell_magic_fear)
{

    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_UNDEAD(victim))
    {
        act("$N       $gN{}!",
            ch,NULL,victim,TO_CHAR);
        return;
    }

    if (victim == ch)
    {
        char_act(" ?   -   !", ch);
        return;
    }

    if (is_affected(victim,gsn_magic_fear))
    {
        act("$N $gN{}    ,  !",
            ch,NULL,victim,TO_CHAR);
        return;
    }

    if (saves_spell(level, victim, DAM_MAGIC))
    {

        af.where        = TO_RESIST;
        af.type         = gsn_magic_fear;
        af.duration     = level / 10;
        af.level        = level;
        af.bitvector    = DAM_MAGIC;
        af.location     = APPLY_NONE;
        af.modifier     = 40;
        affect_to_char(victim, &af);

        act("$N         .",
            victim,NULL,ch,TO_CHAR);
        act("         $n.",
            victim,NULL,ch,TO_VICT);
        act("$N         $n.",
            victim,NULL,ch,TO_NOTVICT);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = gsn_magic_fear;
    af.level     = level;
    af.duration  = level / 10;

    af.location  = APPLY_SAVING_SPELL;
    af.modifier  = 10;
    af.bitvector = 0;
    affect_to_char(victim, &af);

    act("$N       .",victim,NULL,ch,TO_CHAR);
    act("       $n.",victim,NULL,ch,TO_VICT);
    act("$N       $n.",victim,NULL,ch,TO_NOTVICT);

    if (!saves_spell(level, victim, DAM_MAGIC))
    {

    af.where     = TO_RESIST;
    af.location  = APPLY_NONE;
    af.modifier  = -40;
    af.bitvector = DAM_MAGIC;
    affect_to_char(victim, &af);
    act("$N   !",ch,NULL,victim,TO_ROOM);

    return;
    }

    if (!saves_spell(level, victim, DAM_FIRE)) {

    af.where     = TO_RESIST;
    af.location  = APPLY_NONE;
    af.modifier  = -40;
    af.bitvector = DAM_FIRE;
    affect_to_char(victim, &af);
    act("$N   !",ch,NULL,victim,TO_ROOM);
    }

    if (!saves_spell(level, victim, DAM_COLD)) {

    af.where     = TO_RESIST;
    af.location  = APPLY_NONE;
    af.modifier  = -40;
    af.bitvector = DAM_COLD;
    affect_to_char(victim, &af);
    act("$N   !",ch,NULL,victim,TO_ROOM);
    }

    if (!saves_spell(level, victim, DAM_LIGHTNING)) {

    af.where     = TO_RESIST;
    af.location  = APPLY_NONE;
    af.modifier  = -40;
    af.bitvector = DAM_LIGHTNING;
    affect_to_char(victim, &af);
    act("$N   !",ch,NULL,victim,TO_ROOM);
    }

    if (!saves_spell(level, victim, DAM_ACID)) {

    af.where     = TO_RESIST;
    af.location  = APPLY_NONE;
    af.modifier  = -40;
    af.bitvector = DAM_ACID;
    affect_to_char(victim, &af);
    act("$N   !",ch,NULL,victim,TO_ROOM);
    }

    if (!saves_spell(level, victim, DAM_ENERGY)) {

    af.where     = TO_RESIST;
    af.location  = APPLY_NONE;
    af.modifier  = -40;
    af.bitvector = DAM_ENERGY;
    affect_to_char(victim, &af);
    act("$N   !",ch,NULL,victim,TO_ROOM);
    }

    if (!saves_spell(level, victim, DAM_MENTAL)) {

    af.where     = TO_RESIST;
    af.location  = APPLY_NONE;
    af.modifier  = -40;
    af.bitvector = DAM_MENTAL;
    affect_to_char(victim, &af);
    act("$N    !",ch,NULL,victim,TO_ROOM);
    }

    if ((!saves_spell(level, victim, DAM_NEGATIVE)) && !IS_EVIL(victim)) {

    af.where     = TO_RESIST;
    af.location  = APPLY_NONE;
    af.modifier  = -40;
    af.bitvector = DAM_NEGATIVE;
    affect_to_char(victim, &af);
    act("$N    !",ch,NULL,victim,TO_ROOM);
    }

    if ((!saves_spell(level, victim, DAM_HOLY)) && !IS_GOOD(victim)) {

    af.where     = TO_RESIST;
    af.location  = APPLY_NONE;
    af.modifier  = -40;
    af.bitvector = DAM_HOLY;
    affect_to_char(victim, &af);
    act("$N    !",ch,NULL,victim,TO_ROOM);
    }

return;
}

SPELL_FUN(spell_pray_of_death)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_SET(victim->abilities, EA_IMMUN_INSTANT))
    {
        act("You can't harm $N.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (!IS_IMMORTAL(ch))
    {
        if ((get_eq_char(ch, WEAR_BODY) == NULL
        || get_eq_char(ch, WEAR_HEAD) == NULL
        || get_eq_char(ch, WEAR_LEGS) == NULL
        || get_eq_char(ch, WEAR_FEET) == NULL
        || get_eq_char(ch, WEAR_HANDS) == NULL
        || get_eq_char(ch, WEAR_ARMS) == NULL
        || get_eq_char(ch, WEAR_ABOUT) == NULL
        || get_eq_char(ch, WEAR_WAIST) == NULL)
        && !IS_NPC(victim))
        {
            char_act("{REQ check failed!!!{x", ch);
            WAIT_STATE(ch, 10 * PULSE_VIOLENCE);
            return;
        }
    }

    if (level > ch->level + 20)
        level = ch->level + 20;

    level += LVL (ch) - ch->level;

    act_puts("    $N.", ch, NULL, victim, TO_CHAR, POS_RESTING);
    act_puts("$n    $N.", ch, NULL, victim, TO_NOTVICT, POS_RESTING);
    act_puts("$N    .", victim, NULL, ch, TO_CHAR, POS_RESTING);

    if (saves_spell(level, victim, DAM_NEGATIVE)
    || number_bits(2) != 0
    || IS_IMMORTAL(victim)
    || IS_CLAN_GUARD(victim))
    {
        dam = dice(level , 24);
        damage(ch, victim , dam , sn, DAM_NEGATIVE, TRUE);
        return;
    }

    char_act("{R     !{x", victim);
    act("$N  !\n", ch, NULL, victim, TO_CHAR);
    act("$N  !\n", ch, NULL, victim, TO_ROOM);

    //group_gain(ch, victim);
    //raw_kill(ch, victim);
    victim->position = POS_DEAD;
    handle_death(ch, victim);

    return;
}

SPELL_FUN(spell_repair)
{
    CHAR_DATA * victim = (CHAR_DATA *) vo ;
    int bonus = 200 + level + dice (1,20) ;

    if (CAN_HEAL (ch, victim))
    {
        if (!IS_CYBORG (victim))
        {
            char_act("  .", ch);
            victim->hit = UMIN(victim->hit + bonus / 2, victim->max_hit) ;
            update_pos (victim) ;
        } else
        {
            victim->hit = UMIN(victim->hit + bonus, victim->max_hit) ;
            update_pos (victim) ;
        }

        char_act("   !", victim);
        if (ch != victim) 
            char_act("Ok.", ch);
    } else if (!is_safe(ch, victim))
        damage(ch, victim, bonus / 2, sn, DAM_ENERGY, TRUE) ;

    return;
}

SPELL_FUN(spell_light_repair)
{
    CHAR_DATA * victim = (CHAR_DATA *) vo;
    int bonus = 100 + level / 10;

    if (CAN_HEAL (ch, victim))
    {
        if (!IS_CYBORG (victim) && ch != victim)
        {
            char_act("  .", ch);
            victim->hit = UMIN(victim->hit + bonus / 2, victim->max_hit);
            update_pos (victim);
        } else
        {
            victim->hit = UMIN(victim->hit + bonus, victim->max_hit);
            update_pos (victim);
        }
        
        char_act("   .", victim);
        if (ch != victim) 
            char_act("Ok.", ch);
    } else if (!is_safe(ch, victim))
        damage(ch, victim, bonus / 2, sn, DAM_LIGHT, TRUE);

    return ;
}

SPELL_FUN(spell_upgrade_room)
{
    AFFECT_DATA af,af2;

    if (is_affected_room(ch->in_room, sn))
    {
        char_act("   .", ch);
        return;
    }

    if (is_affected(ch, sn)) 
    {
        char_act("   !", ch);
        return;
    }

    af.where     = TO_ROOM_CONST;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 20;
    af.location  = APPLY_ROOM_MANA;
    af.modifier  = level;
    af.bitvector = 0;
    affect_to_room(ch->in_room, &af);

    af.location  = APPLY_ROOM_HEAL;
    af.modifier  = level;
    af.bitvector = 0;
    affect_to_room(ch->in_room, &af);

    af2.where     = TO_AFFECTS;
    af2.type      = sn;
    af2.level     = level;
    af2.duration  = level / 10;
    af2.modifier  = 0;
    af2.location  = APPLY_NONE;
    af2.bitvector = 0;
    affect_to_char(ch, &af2);
    char_act("  .", ch);
    act("$n  .",ch,NULL,NULL,TO_ROOM);
    return;
}

SPELL_FUN(spell_pray_of_life)
{
    OBJ_DATA *angel, *floating;
    AFFECT_DATA af;

    if (IS_UNDEAD(ch)) 
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    floating = get_eq_char(ch, WEAR_LIGHT);
    if (floating != NULL && IS_OBJ_STAT(floating, ITEM_NOREMOVE))
    {
        act("    $p.", ch, floating, NULL, TO_CHAR);
        return;
    }

    angel = create_obj(get_obj_index(OBJ_VNUM_ANGEL), 0);
    angel->value[2]     = -1;
    angel->timer        = ch->level * 2;
    angel->owner        = str_dup(ch->name);

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = -1;
    af.location  = APPLY_HIT;
    af.modifier  = level;
    af.bitvector = 0;
    affect_to_obj(angel, &af);

    af.modifier  = level * 2;
    af.location  = APPLY_MANA;
    affect_to_obj(angel, &af);

    af.modifier = - 5;
    af.location = APPLY_SAVING_SPELL;
    affect_to_obj(angel, &af);

    act("$n  {R{D{x.",ch,NULL,NULL,TO_ROOM);
    char_act("  {R{D{x.", ch);
    obj_to_char(angel, ch);
    wear_obj(ch, angel, TRUE);
    return;
}

SPELL_FUN(spell_death_wave)
{
    EXIT_DATA *pExit;
    ROOM_INDEX_DATA *dest_room;
    CHAR_DATA *vch, *vch_next;
    int number,door,chance,i,dam;
    int range = (ch->level / 30) + 1;
    char arg[MAX_INPUT_LENGTH];

    number = number_argument(target_name, arg, sizeof(arg));
    if ((door = check_exit(arg)) == -1) 
    {
        char_act("What direction (west south east north down up)?.", ch);
        return;
    }
    
    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }
    
    dest_room = ch->in_room;
    
    for (i=0; i < range; i++)
    {
        // dest_room - current room
        for (vch = dest_room->people; vch != NULL; vch = vch_next)
        {
            vch_next = vch->next_in_room;

            if (!IS_NPC(vch)) 
                char_act("   .", vch);

            if (is_safe_spell(ch,vch,TRUE) 
            || (IS_NPC(vch) && vch->in_room != ch->in_room  
            && IS_SET(vch->pIndexData->act, ACT_NOTRACK)))
                continue;
            
            dam = dice(level, 17);
            if (saves_spell(level, vch, DAM_NEGATIVE))
                dam /= 2;
            if (IS_GOOD(vch))
                dam*=1.5;
                        
            damage(ch, vch, dam, sn, DAM_NEGATIVE, TRUE);

            if (!IS_NPC(vch))
            {
                chance = 25;
                chance += (23 - get_curr_stat(vch, STAT_STR)) * 3;
                chance += (22 - get_curr_stat(vch, STAT_DEX)) * 3;
                if (is_affected(vch, gsn_protective_shield))
                    chance /= 2;
                
                if (number_percent() < chance)
                    if (vch->position > POS_RESTING)
                    {
                        char_act("   .", vch);
                        vch->position=POS_RESTING;
                    }
            } else
            {
                if (IS_NPC(vch) && vch->position != POS_DEAD
                && vch->in_room != ch->in_room)
                {
                    vch->last_fought = ch;
                    do_track(vch, str_empty);
                }
            }
        }

        //end direction or closed door
        if ((pExit = dest_room->exit[door]) == NULL
        || (dest_room = pExit->to_room.r) == NULL
        || IS_SET(pExit->exit_info,EX_CLOSED))
            return;
    }
}

SPELL_FUN(spell_detection)
{
    AFFECT_DATA     af;
    int             chance;

    chance = get_skill(ch, sn);

    if (is_affected(ch, sn))
    {
        char_act("    . ", ch);
        return;
    }

    if (number_percent() > chance)
    {
        char_act("   ,      .", ch);
        check_improve(ch, sn, FALSE, 1);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = LVL(ch);
    af.duration  = LVL(ch);
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = 0;
    affect_to_char(ch, &af);
    char_act("  .", ch);
    check_improve(ch, sn, TRUE, 1);
}

SPELL_FUN(spell_defensive_matrix)
{
    AFFECT_DATA af;

    if (is_affected(ch,sn))
    {
      char_act("   !", ch);
      return;
    }

    ch->hit += 250;

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = level / 3;;
    af.location     = APPLY_HIT;
    af.modifier     = 250;
    af.bitvector    = 0;
    affect_to_char(ch, &af);

    char_act("   ϣ .", ch);
}

SPELL_FUN(spell_archon)
{
    CHAR_DATA *gch;
    CHAR_DATA *archon;
    AFFECT_DATA af;
    int i = 0;

    if (is_affected(ch,sn) || count_charmed(ch))
    {
        char_act("     .", ch);
        return;
    }

    char_act("      .", ch);
    act("$n      .", ch, NULL, NULL, TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch 
        && (gch->pIndexData->vnum == MOB_VNUM_ARCHON || gch->pIndexData->vnum == MOB_VNUM_ANGEL || gch->pIndexData->vnum == MOB_VNUM_DEVIL))
        {
            char_act("    !", ch);
            return;
        }
    }

    archon = create_mob(get_mob_index(MOB_VNUM_ARCHON));


    for (i = 0; i < MAX_STATS; i ++)
       archon->perm_stat[i] = UMIN(25,15 + ch->level/10);

    archon->perm_stat[STAT_STR] += 3;
    archon->perm_stat[STAT_INT] -= 1;
    archon->perm_stat[STAT_CON] += 2;

    archon->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : UMIN((10 * ch->pcdata->perm_hit) + 4000, 30000);
    archon->alignment = ch->alignment;
    archon->hit = archon->max_hit;
    archon->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    archon->mana = archon->max_mana;
    archon->level = LVL(ch);
    for (i=0; i < 3; i++)
        archon->armor[i] = interpolate(archon->level,100,-100);
    archon->armor[3] = interpolate(archon->level,100,0);
    archon->gold = 0;
    archon->timer = 0;
    archon->damage[DICE_NUMBER] = 13;
    archon->damage[DICE_TYPE] = 9;
    archon->damage[DICE_BONUS] = level / 2 + 10;

    char_to_room(archon,ch->in_room);
    char_act("   !", ch);
    act(" $n    !",ch,NULL,NULL,TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 32;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(archon->affected_by, AFF_CHARM);
    archon->master = archon->leader = ch;

}

SPELL_FUN(spell_forest_giant)
{
    CHAR_DATA *gch;
    CHAR_DATA *fgiant;
    OBJ_DATA *gift;
    OBJ_INDEX_DATA *pObjIndex;
    AFFECT_DATA af;
    int i = 0, gift_vnum;

    if (is_affected(ch,sn) || count_charmed(ch))
    {
        char_act("     .", ch);
        return;

    }
    if (ch->in_room->sector_type != SECT_FOREST)
    {
        char_act("    ,     ?", ch);
        return;
    }

    char_act("   .", ch);
    act("$n   .", ch, NULL, NULL, TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch
        && (gch->pIndexData->vnum == MOB_VNUM_FOREST_GIANT))
        {
            char_act("      !", ch);
            return;
        }
    }

    fgiant = create_mob(get_mob_index(MOB_VNUM_FOREST_GIANT));

    for (i = 0; i < MAX_STATS; i ++)
       fgiant->perm_stat[i] = UMIN(25,15 + ch->level/10);

    fgiant->perm_stat[STAT_STR] += 3;
    fgiant->perm_stat[STAT_INT] -= 1;
    fgiant->perm_stat[STAT_CON] += 2;

    fgiant->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : UMIN((2 * ch->pcdata->perm_hit) + 4000, 30000);
    fgiant->alignment = ch->alignment;
    fgiant->hit = fgiant->max_hit;
    fgiant->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    fgiant->mana = fgiant->max_mana;
    fgiant->level = LVL(ch);
    for (i=0; i < 3; i++)
        fgiant->armor[i] = interpolate(fgiant->level,100,-100);
    fgiant->armor[3] = interpolate(fgiant->level,100,0);
    fgiant->gold = 0;
    fgiant->timer = 0;
    fgiant->damage[DICE_NUMBER] = 13;
    fgiant->damage[DICE_TYPE] = 9;
    fgiant->damage[DICE_BONUS] = level / 2 + 10;

    char_to_room(fgiant,ch->in_room);
    char_act("     !", ch);
    act("     $n!", ch, NULL, NULL, TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 45;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(fgiant->affected_by, AFF_CHARM);
    fgiant->master = fgiant->leader = ch;

    //      ...
    gift_vnum = OBJ_VNUM_WOOD;
    switch(number_range(0,1))
    {
    case 0:
        gift_vnum = OBJ_VNUM_SKIN;
        break;
    case 1:
        gift_vnum = OBJ_VNUM_WOOD;
        break;
    }

    if (number_percent() + 25 < get_skill(ch, sn))
    {
        pObjIndex = get_obj_index(gift_vnum);
        gift = create_obj(pObjIndex, 0);
        gift->level = ch->level;
        gift->cost = 10 * ch->level;
        act_puts(" Σ $p       .",
            ch, gift, NULL, TO_CHAR, POS_DEAD);
        obj_to_room(gift, ch->in_room);
    }
}

SPELL_FUN(spell_insomnia)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("      ! ...", ch);
        return;
    }

    if (is_affected(victim, sn))
    {
        char_act("     .", ch);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 15;
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = 0;
    affect_to_char(victim, &af);
    char_act("     .", victim);
    act("$n     .",victim,NULL,NULL,TO_ROOM);
    return;
}

SPELL_FUN(spell_drain_blade)
{
    OBJ_DATA * obj = (OBJ_DATA *) vo;
    AFFECT_DATA af;

    if (!IS_NPC(ch)
    && (obj->level > ch->level+10
    || obj->level < ch->level-10))
    {
        char_act("   .", ch);
        return;
    }
   
    if (obj->pIndexData->item_type != ITEM_WEAPON) 
    {
        char_act("You can only cast this spell on weapons.", ch);
        return;
    }

    if (IS_WEAPON_STAT(obj, WEAPON_VAMPIRIC)) 
    {
        char_act("This weapon is already vampiric.", ch);
        return;
    }

    if (IS_OBJ_STAT(obj, ITEM_BLESS)) 
    {
        char_act("This weapon is too blessed.", ch);
        return;
    }

    if (check_material(obj, "unique"))
    {
        act_puts("You can't upgrade $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    if ((obj->timer > 0) 
    || (obj->pIndexData->limit != -1))
    {
        char_act("You can't do this!", ch);
        return;
    }

    af.where    = TO_WEAPON;
    af.type     = sn;
    af.level    = level;
    if (!IS_NPC(ch))
        af.duration = 2 * level / 3;
    else
        af.duration = -1;
    af.location = 0;
    af.modifier = 0;
    af.bitvector = WEAPON_VAMPIRIC;
    affect_to_obj(obj, &af);

    act("$p carried by $n turns dark and vampiric.", ch, obj, NULL, TO_ROOM);
    act("$p carried by you turns dark and vampiric.", ch, obj, NULL, TO_CHAR);
    return;
}

SPELL_FUN(spell_shocking_blade)
{
    OBJ_DATA * obj = (OBJ_DATA *) vo;
    AFFECT_DATA af;

    if (!IS_NPC(ch)
    && (obj->level > ch->level+10
    || obj->level < ch->level-10))
    {
        char_act("   .", ch);
        return;
    }
   
    if (obj->pIndexData->item_type != ITEM_WEAPON) 
    {
        char_act("You can only cast this spell on weapons.", ch);
        return;
    }

    if (IS_WEAPON_STAT(obj,WEAPON_SHOCKING)) 
    {
        char_act("This weapon is already electrical.", ch);
        return;
    }

    if (check_material(obj, "unique"))
    {
        act_puts("You can't upgrade $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    if ((obj->timer > 0) 
    || (obj->pIndexData->limit != -1))
    {
        char_act("You can't do this!", ch);
        return;
    }

    af.where    = TO_WEAPON;
    af.type     = sn;
    af.level    = level;
   if (!IS_NPC(ch))
    af.duration = 2*level/3;
   else
    af.duration = -1;
    af.location = 0;
    af.modifier = 0;
    af.bitvector = WEAPON_SHOCKING;
    affect_to_obj(obj, &af);

    act("$p carried by $n sparks with electricity.", ch, obj, NULL, TO_ROOM);
    act("$p carried by you sparks with electricity.", ch, obj, NULL, TO_CHAR);
    return;
}


SPELL_FUN(spell_flame_blade)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    AFFECT_DATA af;

    if (!IS_NPC(ch)
    && (obj->level > ch->level+10
    || obj->level < ch->level-10))
    {
        char_act("   .", ch);
        return;
    }
   
    if (obj->pIndexData->item_type != ITEM_WEAPON) 
    {
        char_act("You can only cast this spell on weapons.", ch);
        return;
    }

    if (IS_WEAPON_STAT(obj, WEAPON_FLAMING)) 
    {
        char_act("This weapon is already flaming.", ch);
        return;
    }

    if (IS_WEAPON_STAT(obj, WEAPON_FROST)) 
    {
        char_act("This weapon is too frost to handle this magic.", ch);
        return;
    }

    if ((obj->timer > 0) 
    || (obj->pIndexData->limit != -1))
    {
        char_act("You can't do this!", ch);
        return;
    }

    af.where    = TO_WEAPON;
    af.type     = sn;
    af.level    = level;
    if (!IS_NPC(ch))
        af.duration = 2*level/3;
    else
        af.duration = -1;
    af.location = 0;
    af.modifier = 0;
    af.bitvector = WEAPON_FLAMING;
    affect_to_obj(obj, &af);

    act("$p carried by $n gets a fiery aura.", ch, obj, NULL, TO_ROOM);
    act("$p carried by you gets a fiery aura.", ch, obj, NULL, TO_CHAR);
    return;
}

SPELL_FUN(spell_frost_blade)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    AFFECT_DATA af;

    if (!IS_NPC(ch)
    && (obj->level > ch->level+10
    || obj->level < ch->level-10))
    {
        char_act("   .", ch);
        return;
    }
   
    if (obj->pIndexData->item_type != ITEM_WEAPON) 
    {
        char_act("You can only cast this spell on weapons.", ch);
        return;
    }

    if (IS_WEAPON_STAT(obj, WEAPON_FROST)) 
    {
        char_act("This weapon is already frost.", ch);
        return;
    }

    if (IS_WEAPON_STAT(obj, WEAPON_FLAMING)) 
    {
        char_act("This weapon is too cold to handle this magic.", ch);
        return;
    }

    if ((obj->timer > 0) 
    || (obj->pIndexData->limit != -1))
    {
        char_act("You can't do this!", ch);
        return;
    }

    af.where        = TO_WEAPON;
    af.type         = sn;
    af.level        = level;
    if (!IS_NPC(ch))
        af.duration = 2*level/3;
    else
        af.duration = -1;
    af.location     = 0;
    af.modifier     = 0;
    af.bitvector    = WEAPON_FROST;
    affect_to_obj(obj, &af);

    act("$p carried by $n grows wickedly cold.", ch, obj, NULL, TO_ROOM);
    act("$p carried by you grows wickedly cold.", ch, obj, NULL, TO_CHAR);
    return;
}

SPELL_FUN(spell_sharp_blade)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    AFFECT_DATA af;

    if (!IS_NPC(ch)
    && (obj->level > ch->level + 10
    || obj->level < ch->level - 10))
    {
        char_act("   .", ch);
        return;
    }
   
    if (obj->pIndexData->item_type != ITEM_WEAPON) 
    {
        char_act("You can only cast this spell on weapons.", ch);
        return;
    }

    if (IS_WEAPON_STAT(obj, WEAPON_SHARP)) 
    {
        char_act("This weapon is already sharp.", ch);
        return;
    }

    if ((obj->timer > 0) 
    || (obj->pIndexData->limit != -1))
    {
        char_act("You can't do this!", ch);
        return;
    }

    if ((obj->value[0] == WEAPON_MACE) 
    || (obj->value[0] == WEAPON_FLAIL)
    || (obj->value[0] == WEAPON_WHIP)
    || (obj->value[0] == WEAPON_BOW))
    {
        char_act("This weapon unsharpened!", ch);
        return;
    }

    af.where    = TO_WEAPON;
    af.type     = sn;
    af.level    = level;
    if (!IS_NPC(ch))
        af.duration = 2*level/3;
    else
        af.duration = -1;
    af.location = 0;
    af.modifier = 0;
    af.bitvector = WEAPON_SHARP;
    affect_to_obj(obj, &af);

    act("$p carried by $n looks newly honed.", ch, obj, NULL, TO_ROOM);
    act("$p carried by you looks newly honed.", ch, obj, NULL, TO_CHAR);
    return;
}

SPELL_FUN(spell_vorpal_blade)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    AFFECT_DATA af;

    if (!IS_NPC(ch)
    && (obj->level > ch->level+10
    || obj->level < ch->level-10))
    {
        char_act("   .", ch);
        return;
    }
   
    if (obj->pIndexData->item_type != ITEM_WEAPON) 
    {
        char_act("You can only cast this spell on weapons.", ch);
        return ;
    }

    if (IS_WEAPON_STAT(obj, WEAPON_VORPAL)) 
    {
        char_act("This weapon is already vorpal.", ch);
        return;
    }

    if ((obj->timer > 0) 
    || (obj->pIndexData->limit != -1))
    {
        char_act("You can't do this!", ch);
        return;
    }

    af.where    = TO_WEAPON;
    af.type     = sn;
    af.level    = level;
    if (!IS_NPC(ch))
        af.duration = 2*level/3;
    else
        af.duration = -1;
    af.location = 0;
    af.modifier = 0;
    af.bitvector = WEAPON_VORPAL;
    affect_to_obj(obj, &af);

    act("$p carried by $n gleams with magical strength.", ch, obj, NULL, TO_ROOM);
    act("$p carried by you gleams with magical strength.", ch, obj, NULL, TO_CHAR);
    return;
}

SPELL_FUN(spell_call_dragon)
{
    CHAR_DATA *gch;
    CHAR_DATA *dragon;
    int i;

    char_act("  .", ch);
    act("$n  .",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch
        && gch->pIndexData->vnum == MOB_VNUM_DRAGON)
        {
            char_act("       !", ch);
            return;
        }
    }

    dragon = create_mob(get_mob_index(MOB_VNUM_DRAGON));

    for (i=0;i < MAX_STATS; i++)
    {
        dragon->perm_stat[i] = ch->perm_stat[i];
    }

    dragon->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : URANGE(ch->pcdata->perm_hit,ch->hit,30000);
    dragon->hit = dragon->max_hit;
    dragon->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    dragon->mana = dragon->max_mana;
    dragon->level = ch->level;
    for (i=0; i < 3; i++)
    dragon->armor[i] = interpolate(dragon->level,100,-100);
    dragon->armor[3] = interpolate(dragon->level,100,0);
    dragon->gold = 0;
    dragon->timer = 0;
    dragon->damage[DICE_NUMBER] = number_range(level/15, level/10);
    dragon->damage[DICE_TYPE] = number_range(level/3, level/2);
    dragon->damage[DICE_BONUS] = number_range(level/8, level/6);

    char_to_room(dragon, ch->in_room);
    char_act(" ,     !", ch);
    act(" ,     !",ch,NULL,NULL,TO_ROOM);

    if (JUST_KILLED(dragon))
        return;

    if (number_percent() > 80 && !HAS_SKILL(ch, sn))
    {
        if (can_see(dragon, ch))
            do_say(dragon, "  ! !");
        else
            do_say(dragon, "?... !?");
        do_murder(dragon, ch->name);
    } else
    {
        SET_BIT(dragon->affected_by, AFF_CHARM);
        dragon->master = dragon->leader = ch;
    }
}

SPELL_FUN(spell_call_lion)
{
    CHAR_DATA *gch;
    CHAR_DATA *dragon;
    int i;

    char_act("  .", ch);
    act("$n  .",ch,NULL,NULL,TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch
        && gch->pIndexData->vnum == MOB_VNUM_BIG_LION)
        {
            char_act("       !", ch);
            return;
        }
    }

    dragon = create_mob(get_mob_index(MOB_VNUM_BIG_LION));

    for (i=0;i < MAX_STATS; i++)
    {
        dragon->perm_stat[i] = ch->perm_stat[i];
    }

    dragon->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : URANGE(ch->pcdata->perm_hit,ch->hit,30000);
    dragon->hit = dragon->max_hit;
    dragon->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    dragon->mana = dragon->max_mana;
    dragon->level = ch->level;
    for (i=0; i < 3; i++)
    dragon->armor[i] = interpolate(dragon->level,100,-100);
    dragon->armor[3] = interpolate(dragon->level,100,0);
    dragon->gold = 0;
    dragon->timer = 0;
    dragon->damage[DICE_NUMBER] = number_range(level/15, level/10);
    dragon->damage[DICE_TYPE] = number_range(level/3, level/2);
    dragon->damage[DICE_BONUS] = number_range(level/8, level/6);

    char_to_room(dragon, ch->in_room);
    char_act("       .", ch);
    act("     !",ch,NULL,NULL,TO_ROOM);

    if (JUST_KILLED(dragon))
        return;

    if (number_percent() > 80 && !HAS_SKILL(ch, sn))
    {
        if (can_see(dragon, ch))
            do_say(dragon, "  ! !");
        else
            do_say(dragon, "?... !?");
        do_murder(dragon, ch->name);
    } else
    {
        SET_BIT(dragon->affected_by, AFF_CHARM);
        dragon->master = dragon->leader = ch;
    }
}

SPELL_FUN(spell_call_fire_dragon)
{
    CHAR_DATA *gch;
    CHAR_DATA *dragon;
    AFFECT_DATA af;
    int i = 0;

    if (is_affected(ch,sn) || count_charmed(ch))
    {
        char_act("          .", ch);
        return;
    }

    char_act("    .", ch);
    act("$n    .", ch, NULL, NULL, TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch 
        && (gch->pIndexData->vnum == MOB_VNUM_FIRE_DRAGON))
        {
            char_act("     !", ch);
            return;
        }
    }

    dragon = create_mob(get_mob_index(MOB_VNUM_FIRE_DRAGON));

    for (i = 0; i < MAX_STATS; i ++)
       dragon->perm_stat[i] = UMIN(25,15 + ch->level/10);

    dragon->perm_stat[STAT_STR] += 3;
    dragon->perm_stat[STAT_INT] -= 1;
    dragon->perm_stat[STAT_CON] += 2;

    dragon->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : UMIN((10 * ch->pcdata->perm_hit) + 4000, 30000);
    dragon->hit = dragon->max_hit + 50;
    dragon->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    dragon->mana = dragon->max_mana;
    dragon->level = ch->level;
    for (i=0; i < 3; i++)
    dragon->armor[i] = interpolate(dragon->level, 100, -100);
    dragon->armor[3] = interpolate(dragon->level, 100, 0);
    dragon->gold = 0;
    dragon->timer = 0;
    dragon->damage[DICE_NUMBER] = 13;
    dragon->damage[DICE_TYPE] = 9;
    dragon->damage[DICE_BONUS] = ch->level / 2 + 10;

    char_to_room(dragon,ch->in_room);
    char_act("   !", ch);
    act("$n   !", ch, NULL, NULL, TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 24;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(dragon->affected_by, AFF_CHARM);
    dragon->master = dragon->leader = ch;
}

SPELL_FUN(spell_call_ice_dragon)
{
    CHAR_DATA *gch;
    CHAR_DATA *dragon;
    AFFECT_DATA af;
    int i = 0;

    if (is_affected(ch,sn) || count_charmed(ch))
    {
        char_act("          .", ch);
        return;
    }

    char_act("    .", ch);
    act("$n    .", ch, NULL, NULL, TO_ROOM);

    for (gch = char_list; gch != NULL; gch = gch->next)
    {
        if (IS_NPC(gch) && IS_AFFECTED(gch,AFF_CHARM) && gch->master == ch 
        && (gch->pIndexData->vnum == MOB_VNUM_ICE_DRAGON))
        {
            char_act("     !", ch);
            return;
        }
    }

    dragon = create_mob(get_mob_index(MOB_VNUM_ICE_DRAGON));

    for (i = 0; i < MAX_STATS; i ++)
       dragon->perm_stat[i] = UMIN(25,15 + ch->level/10);

    dragon->perm_stat[STAT_STR] += 3;
    dragon->perm_stat[STAT_INT] -= 1;
    dragon->perm_stat[STAT_CON] += 2;

    dragon->max_hit = IS_NPC(ch)? URANGE(ch->max_hit,1 * ch->max_hit,30000)
        : UMIN((10 * ch->pcdata->perm_hit) + 4000, 30000);
    dragon->hit = dragon->max_hit + 50;
    dragon->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
    dragon->mana = dragon->max_mana;
    dragon->level = ch->level;
    for (i=0; i < 3; i++)
    dragon->armor[i] = interpolate(dragon->level, 100, -100);
    dragon->armor[3] = interpolate(dragon->level, 100, 0);
    dragon->gold = 0;
    dragon->timer = 0;
    dragon->damage[DICE_NUMBER] = 13;
    dragon->damage[DICE_TYPE] = 9;
    dragon->damage[DICE_BONUS] = ch->level / 2 + 10;

    char_to_room(dragon,ch->in_room);
    char_act("   !", ch);
    act("$n   !", ch, NULL, NULL, TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = 24;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

    SET_BIT(dragon->affected_by, AFF_CHARM);
    dragon->master = dragon->leader = ch;
}

SPELL_FUN(spell_mass_visibility)
{
    DESCRIPTOR_DATA *d;
    AFFECT_DATA af;
    CHAR_DATA *victim;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("  ()  .", ch);
        return;
    }

    if (!IS_SET(ch->in_room->room_flags, ROOM_LAW)
    || !IS_SET(ch->in_room->area->flags, AREA_HOMETOWN))
    {
        char_act("       .", ch);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 20;
    af.modifier  = 0;
    af.location  = APPLY_NONE;
    af.bitvector = 0;
    affect_to_char(ch, &af);

    for (d = descriptor_list; d; d = d->next) 
    {
        if (d->connected == CON_PLAYING
        && (victim = d->character) != NULL
        && !IS_NPC(victim)
        && victim->in_room != NULL
        && victim->in_room->area == ch->in_room->area)
        {

            do_visible (victim, str_empty) ;

            if (IS_SET(victim->form, FORM_VAMPIRE | FORM_MECH | FORM_DEMON))
                do_human(victim, str_empty);

            WAIT_STATE(victim, 32);
            act("    .", victim, NULL, NULL, TO_ALL);
        }
    }
}

SPELL_FUN(spell_energy_stream)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int sk, wait = 0, dam;
    bool saves;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    saves = saves_spell(level, victim, DAM_ENERGY);

    if (!saves && is_affected(victim, gsn_protective_shield))
    {
        act_puts("Energy stream from your hands reach $N protective shield.", ch, NULL, victim, TO_CHAR, POS_FIGHTING);
        act_puts("Energy stream from $n hands reach your protective shield.", ch, NULL, victim, TO_VICT, POS_FIGHTING);
        act_puts("Energy stream from $n hands reach $N protective shield.", ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);

        if (number_percent() < 30)
        {
            act_puts("Your energy destroy $N protective shield.", ch, NULL, victim, TO_CHAR, POS_FIGHTING);
            act_puts("$n energy destroy your protective shield.", ch, NULL, victim, TO_VICT, POS_FIGHTING);
            act_puts("$n energy destroy $N protective shield.", ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);
            affect_strip(victim, gsn_protective_shield);

            if (number_percent() < 30 && is_affected(victim, gsn_shield))
            {
                act_puts("Your energy destroy $N shield.", ch, NULL, victim, TO_CHAR, POS_FIGHTING);
                act_puts("$n energy destroy your shield.", ch, NULL, victim, TO_VICT, POS_FIGHTING);
                act_puts("$n energy destroy $N shield.", ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);
                affect_strip(victim, gsn_shield);
            }
        }
        return;
    }

    dam = dice(level, 20);

    if (!saves)
    {
        act("$n energy stream underbides you from legs!", ch, NULL, victim, TO_VICT);
        act("Your energy stream underbides $N from legs!", ch, NULL, victim, TO_CHAR);
        act("$n energy stream underbides $N from legs.", ch, NULL, victim, TO_NOTVICT);

        wait = 3;

        if ((sk = (get_skill(victim, gsn_recovery)
        + get_skill(victim, gsn_roll)
        + get_skill(victim, gsn_jammer))) > 0)
        {
            if (number_percent() < sk)
            {
                wait /= 2;
                check_improve(victim, gsn_recovery, TRUE, 1);
                check_improve(victim, gsn_roll, TRUE, 1);
                check_improve(victim, gsn_jammer, TRUE, 1);
            }
        }
            DAZE_STATE(victim, PULSE_VIOLENCE * wait);
            victim->position = POS_RESTING;
            dam /= 2;
    }
    damage(ch, victim, dam, sn, DAM_ENERGY, TRUE);
    if (wait > 0)
    {
        AFFECT_DATA af;

        af.where        = TO_AFFECTS;
        af.type         = gsn_bash;
        af.level        = level;
        af.duration     = 2;
        af.modifier     = LVL(ch);
        af.location     = APPLY_AC;
        af.bitvector    = 0;

        affect_to_char(victim, &af);
    }
}

SPELL_FUN(spell_swearing_stream)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int sk, wait = 0, dam;
    bool saves;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    saves = saves_spell(level, victim, DAM_SOUND);

    if (!saves && is_affected(victim, gsn_protective_shield))
    {
        act_puts("Swearing stream from your hands reach $N protective shield.", ch, NULL, victim, TO_CHAR, POS_FIGHTING);
        act_puts("Swearing stream from $n hands reach your protective shield.", ch, NULL, victim, TO_VICT, POS_FIGHTING);
        act_puts("Swearing stream from $n hands reach $N protective shield.", ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);

        if (number_percent() < 30)
        {
            act_puts("Your outpouring energy destroy $N protective shield.", ch, NULL, victim, TO_CHAR, POS_FIGHTING);
            act_puts("$n outpouring energy destroy your protective shield.", ch, NULL, victim, TO_VICT, POS_FIGHTING);
            act_puts("$n outpouring energy destroy $N protective shield.", ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);
            affect_strip(victim, gsn_protective_shield);

            if (number_percent() < 30 && is_affected(victim, gsn_shield))
            {
                act_puts("Your outpouring energy destroy $N shield.", ch, NULL, victim, TO_CHAR, POS_FIGHTING);
                act_puts("$n outpouring energy destroy your shield.", ch, NULL, victim, TO_VICT, POS_FIGHTING);
                act_puts("$n outpouring energy destroy $N shield.", ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);
                affect_strip(victim, gsn_shield);
            }
        }
        return;
    }

    dam = dice(level, 20);

    if (!saves)
    {
        act("$n swearing stream underbides you from legs!", ch, NULL, victim, TO_VICT);
        act("Your swearing stream underbides $N from legs!", ch, NULL, victim, TO_CHAR);
        act("$n swearing stream underbides $N from legs.", ch, NULL, victim, TO_NOTVICT);

        wait = 3;

        if ((sk = (get_skill(victim, gsn_recovery)
        + get_skill(victim, gsn_roll)
        + get_skill(victim, gsn_jammer))) > 0)
        {
            if (number_percent() < sk)
            {
                wait /= 2;
                check_improve(victim, gsn_recovery, TRUE, 1);
                check_improve(victim, gsn_roll, TRUE, 1);
                check_improve(victim, gsn_jammer, TRUE, 1);
            }
        }
            DAZE_STATE(victim, PULSE_VIOLENCE * wait);
            victim->position = POS_RESTING;
            dam /= 2;
    }
    damage(ch, victim, dam, sn, DAM_SOUND, TRUE);
    if (wait > 0)
    {
        AFFECT_DATA af;

        af.where        = TO_AFFECTS;
        af.type         = gsn_bash;
        af.level        = level;
        af.duration     = 2;
        af.modifier     = LVL(ch);
        af.location     = APPLY_AC;
        af.bitvector    = 0;

        affect_to_char(victim, &af);
    }
}

SPELL_FUN(spell_good_stream)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int sk, wait = 0, dam;
    bool saves;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (IS_GOOD(victim))
    {
        act_puts("It seems that your good energy can't harm $N.", ch, NULL, victim, TO_CHAR, POS_FIGHTING);
        act_puts("It seems that $n's good energy can't harm you.", ch, NULL, victim, TO_VICT, POS_FIGHTING);
        act_puts("It seems that $n's good energy can't harm $N.", ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);
        return;
    }

    if (IS_NPC(victim))
        level += level/25;

    saves = saves_spell(level, victim, DAM_HOLY);

    if (!saves && is_affected(victim, gsn_protective_shield))
    {
        act_puts("Good stream from your hands reaches $N's protective shield.", ch, NULL, victim, TO_CHAR, POS_FIGHTING);
        act_puts("Good stream from $n's hands reaches your protective shield.", ch, NULL, victim, TO_VICT, POS_FIGHTING);
        act_puts("Good stream from $n's hands reaches $N's protective shield.", ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);

        if (number_percent() < 30)
        {
            act_puts("Your good energy destroys $N's protective shield.", ch, NULL, victim, TO_CHAR, POS_FIGHTING);
            act_puts("$n's good energy destroys your protective shield.", ch, NULL, victim, TO_VICT, POS_FIGHTING);
            act_puts("$n's good energy destroys $N's protective shield.", ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);
            affect_strip(victim, gsn_protective_shield);

            if (number_percent() < 30 && is_affected(victim, gsn_shield))
            {
                act_puts("Your good energy destroys $N's shield.", ch, NULL, victim, TO_CHAR, POS_FIGHTING);
                act_puts("$n's good energy destroys your shield.", ch, NULL, victim, TO_VICT, POS_FIGHTING);
                act_puts("$n's good energy destroys $N's shield.", ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);
                affect_strip(victim, gsn_shield);
            }
        }
        return;
    }

    dam = dice(level, 20);
    if (!IS_NPC(victim))
    {
        if (saves)
            dam /= 3;
        else
            dam /= 2;
    }

    if (IS_NEUTRAL(victim))
        dam /= 2;

    if (!saves && (number_percent() < get_skill(ch, sn) / 2))
    {
        act("$n's good stream underbides you from legs!", ch, NULL, victim, TO_VICT);
        act("Your good stream underbides $N from legs!", ch, NULL, victim, TO_CHAR);
        act("$n's good stream underbides $N from legs!", ch, NULL, victim, TO_NOTVICT);

        wait = 3;

        if ((sk = (get_skill(victim, gsn_recovery)
                    + get_skill(victim, gsn_roll)
                    + get_skill(victim, gsn_jammer))) > 0)
        {
            if (number_percent() < sk)
            {
                wait /= 2;
                check_improve(victim, gsn_recovery, TRUE, 1);
                check_improve(victim, gsn_roll, TRUE, 1);
                check_improve(victim, gsn_jammer, TRUE, 1);
            }
        }
        DAZE_STATE(victim, PULSE_VIOLENCE * wait);
        victim->position = POS_RESTING;
        dam *= 2;
    }
    damage(ch, victim, dam, sn, DAM_HOLY, TRUE);
    if (wait > 0)
    {
        AFFECT_DATA af;

        af.where        = TO_AFFECTS;
        af.type         = gsn_bash;
        af.level        = level;
        af.duration     = 2;
        af.modifier     = LVL(ch);
        af.location     = APPLY_AC;
        af.bitvector    = 0;

        affect_to_char(victim, &af);
    }
}

SPELL_FUN(spell_positive_luck)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("    .", ch);
        else
            act("$N    .", ch, NULL, victim, TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 2;
    af.modifier  = 2;
    af.location  = APPLY_LCK;
    af.bitvector = 0;
    affect_to_char(victim, &af);
    char_act("     !", victim);
    if (ch != victim)
        act("$N   $c1{$gN{}}  !",ch,NULL,victim,TO_CHAR);
    return;
}

SPELL_FUN(spell_negative_luck)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("  $gn{}  .", ch);
        else
            act("$N    .", ch, NULL, victim, TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 2;
    af.modifier  = -2;
    af.location  = APPLY_LCK;
    af.bitvector = 0;
    affect_to_char(victim, &af);
    char_act("     !", victim);
    if (ch != victim)
        act("$N   $c1{$gN{}}  !",ch,NULL,victim,TO_CHAR);
    return;
}

SPELL_FUN(spell_positive_morale)
{
/*    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("  $gn{}  .", ch);
        else
            act("$N  $gN{}  .", ch, NULL, victim, TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 2;
    af.modifier  = 2;
    af.location  = APPLY_LCK;
    af.bitvector = 0;
    affect_to_char(victim, &af);
    char_act("     !", victim);
    if (ch != victim)
        act("$N   $c1{$gN{}}  !",ch,NULL,victim,TO_CHAR);
*/
    return;
}

SPELL_FUN(spell_negative_morale)
{
/*    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("  $gn{}  .", ch);
        else
            act("$N    .", ch, NULL, victim, TO_CHAR);
        return;
    }
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 2;
    af.modifier  = -2;
    af.location  = APPLY_LCK;
    af.bitvector = 0;
    affect_to_char(victim, &af);
    char_act("     !", victim);
    if (ch != victim)
        act("$N   $c1{$gN{}}  !",ch,NULL,victim,TO_CHAR);
*/    return;
}

SPELL_FUN(spell_fire_wall)
{
    AFFECT_DATA af, af2;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }
    if (IS_SET(ch->in_room->room_flags, ROOM_LAW)
    || IS_SET(ch->in_room->room_flags, ROOM_PEACE))
    {
        char_act("      .", ch);
        return;
    }
    if (is_affected_room(ch->in_room, sn))
    {
        char_act("     .", ch);
        return;
    }
    if (IS_SET(ch->plr_flags, PLR_GHOST))
    {
        char_act("You return to your normal form.", ch);
        REMOVE_BIT(ch->plr_flags, PLR_GHOST);
    }

    if (is_affected(ch, sn))
        level /= 2;

    af.where     = TO_ROOM_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 15;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = RAFF_FWALL;
    affect_to_room(ch->in_room, &af);

    if (!is_affected(ch, sn))
    {
        af2.where       = TO_AFFECTS;
        af2.type        = sn;
        af2.level       = level;
        af2.duration    = level / 15;
        af2.modifier    = 0;
        af2.location    = APPLY_NONE;
        af2.bitvector   = 0;
        affect_to_char(ch, &af2);
    }

    char_act("    .", ch);
    act("    .\n",ch,NULL,NULL,TO_ROOM);
}

SPELL_FUN(spell_inner_fire)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {  
        affect_strip (victim, sn);
        if (victim == ch)
            char_act("Inner Fire leaves you!", ch);
        else
            act("Inner Fire leaves $N!", ch, NULL, victim, TO_CHAR);
        return;
    }
   
    if ((IS_GOOD(ch) && !IS_GOOD(victim))
    || (IS_NEUTRAL(ch) && !IS_NEUTRAL(victim))
    || (IS_EVIL(ch) && !IS_EVIL(victim)))
    {
        act("You can't light $N's inner fire.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (IS_AFFECTED(victim, AFF_SLOW))
    {
    
        if (IS_AFFECTED(victim, AFF_HASTE))
            level *= 2;
        dispel1(level, victim, gsn_slow);
        return;
    }
   
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 3;
    af.bitvector = 0;

    af.modifier  = level / 3;
    af.location  = APPLY_HITROLL;
    affect_to_char(victim,&af);

    af.modifier  = level / 6;
    af.location  = APPLY_DAMROLL;
    af.bitvector = AFF_HASTE;
    affect_to_char(victim,&af);

    char_act("Inner fire fills you!", victim);
    act("Inner fire fills $n!", victim, NULL, NULL, TO_ROOM);
}

SPELL_FUN(spell_natures_blessing)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        affect_strip (victim, sn);
        if (victim == ch)
            char_act("Natures Blessing leaves you!", ch);
        else
            act("Natures Blessing leaves $N!", ch, NULL, victim, TO_CHAR);
        return;
    }

    if ((IS_GOOD(ch) && !IS_GOOD(victim))
    || (IS_NEUTRAL(ch) && !IS_NEUTRAL(victim))
    || (IS_EVIL(ch) && !IS_EVIL(victim)))
    {
        act("You can't bless $N's nature.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (IS_AFFECTED(victim, AFF_SLOW))
    {
        if (IS_AFFECTED(victim, AFF_HASTE))
            level *= 2;
        dispel1(level, victim, gsn_slow);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 3;
    af.bitvector = 0;

    af.modifier  = level / 3;
    af.location  = APPLY_HITROLL;
    affect_to_char(victim,&af);

    af.modifier  = - level / 3;
    af.location  = APPLY_AC;
    af.bitvector = AFF_HASTE;
    affect_to_char(victim,&af);

    char_act("Natures Blessing fills you!", victim);
    act("Natures Blessing fills $n!", victim, NULL, NULL, TO_ROOM);
}

SPELL_FUN(spell_mana_burn)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int bonus;
    int dam;

    if (!IS_NPC(victim))
        bonus = level;
    else
        bonus = (level + (level / 5));

    bonus += bonus/10;

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    if (saves_spell(bonus, victim, DAM_NEGATIVE))
    {
        char_act("  !", victim);
        act("   $N.", ch, NULL, victim, TO_CHAR);
        dam             = victim->mana / 10;
        victim->mana    = victim->mana - dam;
        damage(ch, victim, dam, sn, DAM_NEGATIVE, TRUE);
    }
    else {
        char_act("   !", victim);
        act("    $N.", ch, NULL, victim, TO_CHAR);
        dam             = victim->mana;
        victim->mana    = 10;
        damage(ch, victim, dam, sn, DAM_NEGATIVE, TRUE);
    }
}

SPELL_FUN(spell_tranquility)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af, af2;

    if (is_affected(ch, sn))
    {
        char_act("    .", ch);
        return;
    }

    af.where     = TO_ROOM_CONST;
    af.type      = sn;
    af.level     = level;
    af.duration  = number_fuzzy(1);
    af.location  = APPLY_ROOM_MANA;
    af.modifier  = level * 10;
    af.bitvector = 0;
    affect_to_room(ch->in_room, &af);

    af.location  = APPLY_ROOM_HEAL;
    af.modifier  = level * 10;
    af.bitvector = 0;
    affect_to_room(ch->in_room, &af);

    af2.where     = TO_AFFECTS;
    af2.type      = sn;
    af2.level     = level;
    af2.duration  = ch->level / 2;
    af2.location  = 0;
    af2.modifier  = 0;
    af2.bitvector = 0;
    affect_to_char(ch, &af2);

    victim->hit = victim->max_hit;
    update_pos(victim);

    char_act("Wave of tranquillity covers your body.", victim);
    act("$n forces all around be tranquillited.", victim, NULL, NULL, TO_ROOM);
    return;
}

SPELL_FUN(spell_demon_skin)
{
    AFFECT_DATA af;
    CHAR_DATA *vch = vo;

    for (vch = ch->in_room->people; vch != NULL; vch = vch->next_in_room)
    {
        if (!is_same_group(vch, ch))
            continue;

        if (check_spellbane(ch, vch, sn))
            continue;

        if (is_affected(vch, sn))
        {
            if (vch == ch)
                char_act("    {R {x.", ch);
            else
                act(" $N   {R {x.",
                    ch, NULL, vch, TO_CHAR);
            continue;
        }

        af.where     = TO_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = 6 + level;
    
        af.modifier  = -level;
        af.location  = APPLY_AC;
        af.bitvector = 0;
        affect_to_char(vch, &af);
    
        af.modifier  = level/8;
        af.location  = APPLY_HITROLL;
        af.bitvector = 0;
        affect_to_char(vch, &af);
    
        af.where     = TO_AFFECTS;
        af.modifier  = -10;
        af.location  = APPLY_SAVING_SPELL;
        af.bitvector = 0;
        affect_to_char(vch, &af);
    
        af.where     = TO_RESIST;
        af.modifier  = 40;
        af.location  = APPLY_NONE;
        af.bitvector = DAM_HOLY;
        affect_to_char(vch, &af);
    
        char_act("   {R {x.", vch);
        if (ch != vch)
            act(" $N  {R {x.",
                ch, NULL, vch, TO_CHAR);
    }
}

SPELL_FUN(spell_disenchant_armor)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    AFFECT_DATA *paf;
    int result, fail;

    if (obj->wear_loc != -1)
    {
        act("The item must be carried to be disenchanted.",
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    /* find the bonuses */
    fail = 75;
    fail -= (level - obj->level) * 5;
    if (IS_SET(obj->extra_flags, ITEM_MAGIC))
    fail += 25;

    fail = URANGE(5,fail,95);

    result = number_percent();

    /* the moment of truth */
    if (result < (fail / 5))  /* item destroyed */
    {
        act("$p flares blindingly... and evaporates!",
                        ch, obj, NULL, TO_CHAR);
        act("$p flares blindingly... and evaporates!",
                        ch, obj, NULL, TO_ROOM);
        extract_obj(obj);
        return;
    }

    if (result > (fail / 2)) /* item disenchanted */
    {
        AFFECT_DATA *paf_next;

        act("$p glows brightly, then fades.",
                        ch, obj, NULL, TO_CHAR);
        act("$p glows brightly, then fades.",
                        ch, obj, NULL, TO_ROOM);
        SET_BIT(obj->extra_flags, ITEM_ENCHANTED);
        /* remove all affects */
        for (paf = obj->affected; paf != NULL; paf = paf_next)
        {
            paf_next = paf->next; 
            aff_free(paf);
        }
        obj->affected = NULL;

        REMOVE_BIT(obj->extra_flags, ITEM_ENCHANTED);

        /* clear some flags */
        REMOVE_BIT(obj->extra_flags, ITEM_GLOW);
        REMOVE_BIT(obj->extra_flags, ITEM_HUM);
        REMOVE_BIT(obj->extra_flags, ITEM_MAGIC);
        REMOVE_BIT(obj->extra_flags, ITEM_INVIS);
        if (!IS_SET(obj->extra_flags, ITEM_NOUNCURSE))
        {
            REMOVE_BIT(obj->extra_flags, ITEM_NODROP);
            REMOVE_BIT(obj->extra_flags, ITEM_NOREMOVE);
        }
        return;
    }

    act("Nothing seemed to happen.",
                    ch, NULL, NULL, TO_CHAR);
    return;
}

SPELL_FUN(spell_disenchant_weapon)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    AFFECT_DATA *paf;
    int result, fail;

    if (obj->pIndexData->item_type != ITEM_WEAPON)
    {
        act("That isn't a weapon.",
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (obj->wear_loc != -1)
    {
        act("The item must be carried to be disenchanted.",
                        ch, NULL, NULL, TO_CHAR);
        return;
    }

    /* find the bonuses */
    fail = 75;
    fail -= (level - obj->level) * 5;
    if (IS_SET(obj->extra_flags, ITEM_MAGIC))
    fail += 25;

    fail = URANGE(5,fail,95);

    result = number_percent();

    /* the moment of truth */
    if (result < (fail / 5))  /* item destroyed */
    {
        act("$p shivers violently and explodes!",
                        ch, obj, NULL, TO_CHAR);
        act("$p shivers violently and explodeds!",
                        ch, obj, NULL, TO_ROOM);
        extract_obj(obj);
        return;
    }

    if (result > (fail / 2)) /* item disenchanted */
    {
        AFFECT_DATA *paf_next;

        act("$p glows brightly, then fades.",
                        ch, obj, NULL, TO_CHAR);
        act("$p glows brightly, then fades.",
                        ch, obj, NULL, TO_ROOM);
        SET_BIT(obj->extra_flags, ITEM_ENCHANTED);
        /* remove all affects */
        for (paf = obj->affected; paf != NULL; paf = paf_next)
        {
            paf_next = paf->next; 
            aff_free(paf);
        }
        obj->affected = NULL;
        REMOVE_BIT(obj->extra_flags, ITEM_ENCHANTED);

        /* clear some flags */
        REMOVE_BIT(obj->extra_flags, ITEM_GLOW);
        REMOVE_BIT(obj->extra_flags, ITEM_HUM);
        REMOVE_BIT(obj->extra_flags, ITEM_MAGIC);
        REMOVE_BIT(obj->extra_flags, ITEM_INVIS);
        if (!IS_SET(obj->extra_flags, ITEM_NOUNCURSE))
        {
            REMOVE_BIT(obj->extra_flags, ITEM_NODROP);
            REMOVE_BIT(obj->extra_flags, ITEM_NOREMOVE);
        }
        return;
    }

    act("Nothing seemed to happen.",
                    ch, NULL, NULL, TO_CHAR);
    return;
}

SPELL_FUN(spell_enchant_armor)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    AFFECT_DATA *paf;
    int result, fail;
    int ac_bonus, added;
    bool ac_found = FALSE;

    return;

    if (obj->pIndexData->item_type != ITEM_ARMOR)
    {
        char_act("  .", ch);
        return;
    }

    if (obj->wear_loc != -1)
    {
        char_act("   ,   .", ch);
        return;
    }

        if (check_material(obj, "unique")) {
        act_puts("    $p.\n", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    /* this means they have no bonus */
    ac_bonus = 0;
    fail = 25;  /* base 25% chance of failure */

    /* find the bonuses */

    if (!IS_SET(obj->extra_flags, ITEM_ENCHANTED))
        for (paf = obj->pIndexData->affected; paf != NULL; paf = paf->next)
        {
            if (paf->location == APPLY_AC)
            {
                ac_bonus = paf->modifier;
            ac_found = TRUE;
                fail += 5 * (ac_bonus * ac_bonus);
        }

            else  /* things get a little harder */
                fail += 20;
        }

    for (paf = obj->affected; paf != NULL; paf = paf->next)
    {
        if (paf->location == APPLY_AC)
    {
            ac_bonus = paf->modifier;
            ac_found = TRUE;
            fail += 5 * (ac_bonus * ac_bonus);
        }

        else /* things get a little harder */
            fail += 20;
    }

    /* apply other modifiers */
    fail -= level;

    if (IS_OBJ_STAT(obj,ITEM_BLESS))
        fail -= 15;
    if (IS_OBJ_STAT(obj,ITEM_GLOW))
        fail -= 5;

    fail = URANGE(5,fail,85);

    result = number_percent();

    /* the moment of truth */
    if (result < (fail / 5))  /* item destroyed */
    {
        act("$p   ...  !",ch,obj,NULL,TO_CHAR);
        act("$p   ...  !",ch,obj,NULL,TO_ROOM);
        extract_obj(obj);
        return;
    }

    if (result < (fail / 3)) /* item disenchanted */
    {
        AFFECT_DATA *paf_next;

        act("$p  ,  ... !",ch,obj,NULL,TO_CHAR);
        act("$p  ,  ... !",ch,obj,NULL,TO_ROOM);

        /* remove all affects */
        for (paf = obj->affected; paf != NULL; paf = paf_next)
        {
            paf_next = paf->next;
            aff_free(paf);
        }
        obj->affected = NULL;

        SET_BIT(obj->extra_flags, ITEM_ENCHANTED);
        return;
    }

    if (result <= fail)  /* failed, no bad result */
    {
        char_act("  .", ch);
        return;
    }

    /* okay, move all the old flags into new vectors if we have to */
    if (!IS_SET(obj->extra_flags, ITEM_ENCHANTED)) {
        AFFECT_DATA *af_new;
        SET_BIT(obj->extra_flags, ITEM_ENCHANTED);

        for (paf = obj->pIndexData->affected; paf != NULL; paf = paf->next)
        {
            af_new = aff_new();

            af_new->next = obj->affected;
            obj->affected = af_new;

            af_new->where   = paf->where;
            af_new->type    = UMAX(0,paf->type);
            af_new->level   = paf->level;
            af_new->duration    = paf->duration;
            af_new->location    = paf->location;
            af_new->modifier    = paf->modifier;
            af_new->bitvector   = paf->bitvector;
        }
    }

    if (result <= (90 - level/5))  /* success! */
    {
        act("$p  {Y {x.",ch,obj,NULL,TO_CHAR);
        act("$p  {Y {x.",ch,obj,NULL,TO_ROOM);
        SET_BIT(obj->extra_flags, ITEM_MAGIC);
        added = -1;
    }

    else  /* exceptional enchant */
    {
        act("$p  {W {Y {x!",ch,obj,NULL,TO_CHAR);
        act("$p  {W {Y {x!",ch,obj,NULL,TO_ROOM);
        SET_BIT(obj->extra_flags,ITEM_MAGIC);
        SET_BIT(obj->extra_flags,ITEM_GLOW);
        added = -2;
    }

    /* now add the enchantments */

    if (obj->level < LEVEL_HERO)
        obj->level = UMIN(LEVEL_HERO - 1,obj->level + 1);

    if (ac_found)
    {
        for (paf = obj->affected; paf != NULL; paf = paf->next)
        {
            if (paf->location == APPLY_AC)
            {
            paf->type = sn;
            paf->modifier += added;
            paf->level = UMAX(paf->level,level);
            }
        }
    }
    else /* add a new affect */
    {
    paf = aff_new();

        paf->where  = TO_OBJECT;
        paf->type   = sn;
        paf->level  = level;
        paf->duration   = -1;
        paf->location   = APPLY_AC;
        paf->modifier   =  added;
        paf->bitvector  = 0;
        paf->next   = obj->affected;
        obj->affected   = paf;
    }

}

SPELL_FUN(spell_enchant_weapon)
{
    OBJ_DATA *obj = (OBJ_DATA *) vo;
    AFFECT_DATA *paf;
    int result, fail;
    int hit_bonus, dam_bonus, added;
    bool hit_found = FALSE, dam_found = FALSE;

    return;

    if (obj->pIndexData->item_type != ITEM_WEAPON)
    {
        char_act("  .", ch);
        return;
    }

    if (obj->wear_loc != -1)
    {
        char_act("   ,   .", ch);
        return;
    }

        if (check_material(obj, "unique")) {
        act_puts("    $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    /* this means they have no bonus */
    hit_bonus = 0;
    dam_bonus = 0;
    fail = 10;  /* base 10% chance of failure */

    /* find the bonuses */

    if (!IS_SET(obj->extra_flags, ITEM_ENCHANTED))
        for (paf = obj->pIndexData->affected; paf != NULL; paf = paf->next)
        {
            if (paf->location == APPLY_HITROLL)
            {
                hit_bonus = paf->modifier;
            hit_found = TRUE;
                fail += 2 * (hit_bonus * hit_bonus);
        }

            else if (paf->location == APPLY_DAMROLL)
            {
                dam_bonus = paf->modifier;
            dam_found = TRUE;
                fail += 2 * (dam_bonus * dam_bonus);
            }

            else  /* things get a little harder */
                fail += 10;
        }

    for (paf = obj->affected; paf != NULL; paf = paf->next)
    {
        if (paf->location == APPLY_HITROLL)
    {
            hit_bonus = paf->modifier;
            hit_found = TRUE;
            fail += 2 * (hit_bonus * hit_bonus);
        }

        else if (paf->location == APPLY_DAMROLL)
    {
            dam_bonus = paf->modifier;
            dam_found = TRUE;
            fail += 2 * (dam_bonus * dam_bonus);
        }

        else /* things get a little harder */
            fail += 10;
    }

    /* apply other modifiers */
    fail -= 3 * level/2;

    if (IS_OBJ_STAT(obj,ITEM_BLESS))
        fail -= 15;
    if (IS_OBJ_STAT(obj,ITEM_GLOW))
        fail -= 5;

    if (IS_NPC(ch))
        fail = URANGE(5,fail,50);
    else
        fail = URANGE(5,fail,95);

    result = number_percent();

    /* the moment of truth */
    if (result < (fail / 10) && IS_NPC(ch))  /* item destroyed */
    {
        act("$p   !",ch,obj,NULL,TO_CHAR);
        act("$p   !",ch,obj,NULL,TO_ROOM);
        extract_obj(obj);
        return;
    }

    if (result < (fail / 4)) /* item disenchanted */
    {
        AFFECT_DATA *paf_next;

        act("$p  ,  ... !.",ch,obj,NULL,TO_CHAR);
        act("$p  ,  ... !.",ch,obj,NULL,TO_ROOM);

        /* remove all affects */
        for (paf = obj->affected; paf != NULL; paf = paf_next)
        {
            paf_next = paf->next;
            aff_free(paf);
        }
        obj->affected = NULL;

        SET_BIT(obj->extra_flags, ITEM_ENCHANTED);
        return;
    }

    if (result <= fail)  /* failed, no bad result */
    {
        char_act("  .", ch);
        return;
    }

    /* okay, move all the old flags into new vectors if we have to */
    if (!IS_SET(obj->extra_flags, ITEM_ENCHANTED)) {
        AFFECT_DATA *af_new;
        SET_BIT(obj->extra_flags, ITEM_ENCHANTED);

        for (paf = obj->pIndexData->affected; paf != NULL; paf = paf->next)
        {
            af_new = aff_new();

            af_new->next = obj->affected;
            obj->affected = af_new;

            af_new->where   = paf->where;
            af_new->type    = UMAX(0,paf->type);
            af_new->level   = paf->level;
            af_new->duration    = paf->duration;
            af_new->location    = paf->location;
            af_new->modifier    = paf->modifier;
            af_new->bitvector   = paf->bitvector;
        }
    }

    if (result <= (100 - level/5))  /* success! */
    {
        act("$p  {B {x.",ch,obj,NULL,TO_CHAR);
        act("$p  {B {x.",ch,obj,NULL,TO_ROOM);
        SET_BIT(obj->extra_flags, ITEM_MAGIC);
        added = 1;
    }

    else  /* exceptional enchant */
    {
        act("$p  {W {B {x!",ch,obj,NULL,TO_CHAR);
        act("$p  {W {B {x!",ch,obj,NULL,TO_ROOM);
        SET_BIT(obj->extra_flags,ITEM_MAGIC);
        SET_BIT(obj->extra_flags,ITEM_GLOW);
        added = 2;
    }

    /* now add the enchantments */

    if (obj->level < LEVEL_HERO - 1)
        obj->level = UMIN(LEVEL_HERO - 1,obj->level + 2);

    if (dam_found)
    {
        for (paf = obj->affected; paf != NULL; paf = paf->next)
        {
            if (paf->location == APPLY_DAMROLL)
            {
            paf->type = sn;
            paf->modifier += added;
            paf->level = UMAX(paf->level,level);
            if (paf->modifier > 4)
                SET_BIT(obj->extra_flags,ITEM_HUM);
            }
        }
    }
    else /* add a new affect */
    {
        paf = aff_new();

        paf->where  = TO_OBJECT;
        paf->type   = sn;
        paf->level  = level;
        paf->duration   = -1;
        paf->location   = APPLY_DAMROLL;
        paf->modifier   =  added;
        paf->bitvector  = 0;
        paf->next   = obj->affected;
        obj->affected   = paf;
    }

    if (hit_found)
    {
        for (paf = obj->affected; paf != NULL; paf = paf->next)
        {
            if (paf->location == APPLY_HITROLL)
            {
            paf->type = sn;
                paf->modifier += added;
                paf->level = UMAX(paf->level,level);
                if (paf->modifier > 4)
                    SET_BIT(obj->extra_flags,ITEM_HUM);
            }
        }
    }
    else /* add a new affect */
    {
        paf = aff_new();

        paf->type       = sn;
        paf->level      = level;
        paf->duration   = -1;
        paf->location   = APPLY_HITROLL;
        paf->modifier   =  added;
        paf->bitvector  = 0;
        paf->next       = obj->affected;
        obj->affected   = paf;
    }

}

SPELL_FUN(spell_firebolt)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam = 0;
    int nbolt = 0;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }
/*
    char_printf(ch, "dam = %d, i = %d, bolt = %d, sn = %s, level = %d ", 
        dam, i, nbolt, sn, level);
*/
    dam = number_range(level * 6, level * 8);

    if (saves_spell(level, victim, DAM_FIRE))
        dam -= dam / 3;
    else
        fire_effect(victim, UMAX(1, level), dam / 2, TARGET_CHAR);
    
    nbolt = UMAX(1, level / 30);

    if (IS_NPC(ch))
        nbolt = number_range(1, nbolt);

    if (!IS_NPC(victim) && victim->in_room != ch->in_room)
        nbolt = number_range(1, nbolt);

    while (nbolt--) 
    {
        if (check_dodge(ch, victim))
            dam -= dam / 4;

        damage(ch, victim, dam, sn, DAM_FIRE, TRUE);

        if (JUST_KILLED(victim))
            return;

        if (saves_spell(level, victim, DAM_FIRE))
            dam -= dam / 3;
    }
}

SPELL_FUN(spell_icebolt)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam = 0;
    int nbolt = 0;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = number_range(level * 6, level * 8);

    if (saves_spell(level, victim, DAM_COLD))
        dam -= dam / 3;
    else
        cold_effect(victim, UMAX (1, level), dam / 2, TARGET_CHAR);
    
    nbolt = UMAX(1, level / 30);

    if (IS_NPC(ch))
        nbolt = number_range(1, nbolt);

    if (!IS_NPC(victim) && victim->in_room != ch->in_room)
        nbolt = number_range(1, nbolt);

    while (nbolt--) 
    {
        if (check_dodge(ch, victim))
            dam -= dam / 4;

        damage(ch, victim, dam, sn, DAM_COLD, TRUE);

        if (JUST_KILLED(victim))
            return;

        if (saves_spell(level, victim, DAM_COLD))
            dam -= dam / 3;
    }
}

SPELL_FUN(spell_fire_and_ice)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam = 0;
    int nbolt = 0;
    int dam_sn;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    // icebolt
    dam = number_range(level * 6, level * 10);

    if (saves_spell(level, victim, DAM_COLD))
        dam /= 2;
    else
        cold_effect(victim, UMAX (1, level), dam / 2, TARGET_CHAR);
    
    if ((dam_sn = sn_lookup("icebolt")) < 0)
        dam_sn = sn;

    nbolt = UMAX(1, level / 45);
    while (nbolt--) 
    {
        if (check_dodge(ch, victim))
            dam -= dam / 8;

        damage(ch, victim, dam, dam_sn, DAM_COLD, TRUE);

        if (JUST_KILLED(victim))
            return;

        if (saves_spell(level, victim, DAM_COLD))
            dam -= dam / 3;
    }

    // firebolt
    dam = number_range(level * 6, level * 10);

    if (saves_spell(level, victim, DAM_FIRE))
        dam /= 2;
    else
        fire_effect(victim, UMAX(1, level), dam / 2, TARGET_CHAR);
    
    if ((dam_sn = sn_lookup("firebolt")) < 0)
        dam_sn = sn;

    nbolt = UMAX(1, level / 45);
    while (nbolt--) 
    {
        if (check_dodge(ch, victim))
            dam -= dam / 8;

        damage(ch, victim, dam, dam_sn, DAM_FIRE, TRUE);

        if (JUST_KILLED(victim))
            return;

        if (saves_spell(level, victim, DAM_FIRE))
            dam -= dam / 3;
    }
}

SPELL_FUN(spell_dragon_strength)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {  
        affect_strip (victim, sn);
        if (victim == ch)
            char_act("You feel the strength of the dragon leave you.", ch);
        else
            act("Strength of the dragon leaves $N!", ch, NULL, victim, TO_CHAR);
        return;
    }
   
    if (IS_AFFECTED(victim, AFF_SLOW))
    {
    
        if (IS_AFFECTED(victim, AFF_HASTE))
            level *= 2;
        dispel1(level, victim, gsn_slow);
        return;
    }
   
    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 3;
    af.bitvector = 0;

    af.modifier  = 2;
    af.location  = APPLY_STR;
    affect_to_char(victim, &af);

    af.modifier  = level / 11;
    af.location  = APPLY_HITROLL;
    affect_to_char(victim, &af);

    af.modifier  = level / 11;
    af.location  = APPLY_DAMROLL;
    af.bitvector = AFF_HASTE;
    affect_to_char(victim, &af);

    char_act("    !", victim);
    act("$n    .", victim, NULL, NULL, TO_ROOM);
}

SPELL_FUN(spell_dragon_skin)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (is_affected(victim, sn))
    {
        if (victim == ch)
            char_act("       .", ch);
        else
            act(" $N    .", ch, NULL, victim, TO_CHAR);
        return;
    }
    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = level;
    af.location     = APPLY_AC;
    af.modifier     = - level;
    af.bitvector    = 0;
    affect_to_char(victim, &af);

    af.location     = APPLY_SAVING_SPELL;
    af.modifier     = -10;
    affect_to_char(victim, &af);

    act(" $n    .", victim, NULL, NULL, TO_ROOM);
    char_act("     .", victim);
    return;
}

SPELL_FUN(spell_dragon_breath)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (IS_AFFECTED(ch, AFF_FEAR))
    {
        char_act("You too scare to do this!", ch);
        return;
    }

    dam = number_range(level * 20, level * 60);

    if (IS_NPC(victim))
        dam *= 2;

    if (saves_spell(level, victim, DAM_FIRE))
        dam -= dam / 3;

    if (check_dodge(ch, victim))
        dam -= dam / 4;

    damage(ch, victim, dam, sn, DAM_FIRE, TRUE);

    if (JUST_KILLED(victim))
        return;

    switch(dice(1, 5)) 
    {
    case 1:
        fire_effect(victim, level, dam, TARGET_CHAR);
    break;
    case 2:
        acid_effect(victim, level, dam, TARGET_CHAR);
    break;
    case 3:
        cold_effect(victim, level, dam, TARGET_CHAR);
    break;
    case 4:
        poison_effect(victim, level, dam, TARGET_CHAR);
    break;
    case 5:
        shock_effect(victim, level, dam, TARGET_CHAR);
    break;
    }
}
