/* $Id: material.c,v 1.666 2004/09/20 10:49:50 shrike Exp $                           */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "merc.h"

varr materials  = {sizeof (material_t), 4};

material_t * material_new ()
{
     material_t * material;

     material                       = varr_enew (&materials);
     material->ename                = str_empty;
     material->rname                = str_empty;
     material->rigidity             = 0;
     material->density              = 0;
     material->fragility            = 0;
     material->races.nsize          = sizeof (mtrace_t);
     material->races.nstep          = 4;
     material->repairer.nsize       = sizeof (mrepair_t);
     material->repairer.nstep       = 4;

     return material ;
}

void material_free(material_t *material)
{
    int i;

    free_string(material->ename);
    free_string(material->rname);

    for (i = 0; i < material->races.nused; i++)
     {
            mtrace_t *race = VARR_GET(&material->races, i);
            free_string(race->name);
     }

    varr_free(&material->races);
    varr_free(&material->repairer);

    free(material);
}

/*
 * Return number of record for russian or english name
 */
int material_n_lookup (const char * name)
{
    int material_n;

    if (IS_NULLSTR(name))
         return -1;

    for (material_n = 0; material_n < materials.nused; material_n++)
         if (!str_cmp(name, MATERIAL(material_n)->ename) || !str_cmp(name, MATERIAL(material_n)->rname))
              return material_n;

    return -1;
}

material_t * material_lookup (const char *name)
{
    int i;

    if (IS_NULLSTR(name))
         return NULL;

    for (i = 0; i < materials.nused; i++)
         if (!str_cmp(name, MATERIAL(i)->ename) || !str_cmp(name, MATERIAL(i)->rname))
              return MATERIAL(i);

    return NULL;
}


/*
 * Check the material
 */
bool check_material(OBJ_DATA *obj, char *material)
{
    return strstr(obj->material, material) ? TRUE : FALSE;
}

bool may_float(OBJ_DATA *obj)
{

    material_t * material;

    if ((obj->pIndexData->item_type == ITEM_BOAT)
        || (obj->pIndexData->item_type == ITEM_CORPSE_PC)
        || (obj->pIndexData->item_type == ITEM_CORPSE_NPC)
        || (obj->pIndexData->item_type == ITEM_WINDOW)
        || IS_OBJ_STAT(obj, ITEM_QUEST))
        return TRUE;

    material = material_lookup(obj->material);

    if (material != NULL)
         if (IS_SET(material->flag, MAT_FLOAT))
              return TRUE;

    return FALSE;

}

bool is_metal(OBJ_DATA * obj)
{
     material_t * material;

     material = material_lookup(obj->material);

     if (material != NULL)
          if (IS_SET(material->flag, MAT_METAL))
               return TRUE;

     return FALSE;

}

bool race_can_wear_material (const char *material_name, int race)
{
  material_t  *material;
  const char  *rname;

  material =  material_lookup(material_name);

  if (material == NULL)
        return FALSE;

  rname = race_name(race);

  if (material_race_lookup(material, rname) != NULL)
        return FALSE;

  return TRUE;
}


bool is_repairer (const char *material, CHAR_DATA *ch) //FIXME:  
{
      return TRUE;
}

bool can_repair (CHAR_DATA *ch, OBJ_DATA *obj) //FIXME:  
{
      return TRUE;
}

