/* $Id: material.h,v 1.666 2004/09/20 10:49:50 shrike Exp $                           */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 
#ifndef _MATERIAL_H_
#define _MATERIAL_H_

typedef struct material_t material_t;
typedef struct mtrace_t   mtrace_t;
typedef struct mrepair_t  mrepair_t;

struct mtrace_t
{
        const char *name;
        int status;
};

struct mrepair_t
{
        int vnum;
        int repair_rate;
};

#define RACE_WEAR_DENIED   (A)

struct material_t
{
     const char * ename;         //                 Ename key
     const char * rname;         //                    Rname key
     flag64_t     flag;          //                        Flags
     int          rigidity;      //                          Rigidity
     int          fragility;     //                          Fragility
     int          density;       //                          Density
     varr         races;         //      
     varr         repairer;      //     
};


material_t *       material_new     (void);
void               material_free    (material_t*);

extern varr     materials;

#define MATERIAL(material_n)         ((material_t*) VARR_GET(&materials, material_n))
//#define material_lookup(material_n)  ((material_t*) varr_get(&materials, material_n))

/*
 * Return number of record for russian or english name
 */
int          material_n_lookup          (const char * name);
material_t * material_lookup            (const char *name);
bool         check_material             (OBJ_DATA *obj, char *material);
bool         may_float                  (OBJ_DATA *obj);
bool         is_metal                   (OBJ_DATA *obj);
bool         race_can_wear_material     (const char *material, int race);
bool         is_repairer                (const char *material, CHAR_DATA *ch);
bool         can_repair                 (CHAR_DATA *ch, OBJ_DATA *obj);


#define cant_float(obj) !may_float(obj)

#define material_race_lookup(material, name) \
    ((mtrace_t*) varr_bsearch(&material->races, &name, cmpstr))

#define material_repair_lookup(material, vnum) \
    ((mrepair_t*) varr_bsearch(&material->repairer, &vnum, cmpint))

#endif

