/* $Id: mem.c,v 1.666 2004/09/20 10:49:50 shrike Exp $                               */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/************************************************************************************
 *  File: mem.c                                                                     *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 *                                                                                  *
 *  This code was freely distributed with the The Isles 1.1 source code,            *
 *  and has been used here for OLC - OLC would not be what it is without            *
 *  all the previous coders who released their source code.                         *
 *                                                                                  *
 ************************************************************************************/

#include <sys/types.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"
#include "db/db.h"

/*
 * Globals
 */
extern          int         top_reset;
extern          int         top_area;
extern          int         top_exit;
extern          int         top_room;
extern          int         top_mprog_index;
extern          int         top_oprog_index;
extern          int         top_rprog_index;

void    ed_free     (ED_DATA *pExtra);
void    aff_free    (AFFECT_DATA *af);

RESET_DATA *new_reset_data(void)
{
        RESET_DATA *pReset;

        pReset = calloc(1, sizeof(*pReset));
        pReset->command = 'X';

        top_reset++;
        return pReset;
}

void free_reset_data(RESET_DATA *pReset)
{
        if (!pReset)
                return;
        top_reset--;
        free(pReset);
}

AREA_DATA *new_area(void)
{
        AREA_DATA *pArea;

        pArea = calloc(1, sizeof(*pArea));
        pArea->vnum                  = top_area;
        pArea->file_name             = str_printf("area%d.are", pArea->vnum);
        pArea->builders               = str_empty;
        pArea->name                   = str_dup("New area");
        pArea->empty                  = TRUE;                            /* ROM patch */
        pArea->security               = 1;
        pArea->climat_type            = 0;
        
        pArea->planet                 = 0;
        pArea->longitude              = 0;
        pArea->breadth                = 0;
        pArea->timezone               = 0;
        
        pArea->x_coord                = 0;
        pArea->y_coord                = 0;
        pArea->z_coord                = 0;
        
        pArea->sunrise                = 0;
        pArea->sunset                 = 0;
                
        pArea->weather.weather_status = 0;
        pArea->weather.weather_delta  = 0;
        pArea->weather.temperature    = 0;
        pArea->weather.wind_direction = 0;
        pArea->weather.wind_speed     = 0;
        pArea->weather.humidity       = 0;

        pArea->mlname                 = NULL;
        pArea->resetmsg               = NULL;

        top_area++;
        return pArea;
}

/*****************************************************************************
 Name:          area_lookup
 Purpose:       Returns pointer to area with given vnum.
 Called by:     do_aedit(olc.c).
 ****************************************************************************/
AREA_DATA *area_lookup(int vnum)
{
        AREA_DATA *pArea;

        for (pArea = area_first; pArea; pArea = pArea->next)
                if (pArea->vnum == vnum)
                        return pArea;

        return 0;
}

AREA_DATA *area_vnum_lookup(int vnum)
{
        AREA_DATA *pArea;

        for (pArea = area_first; pArea; pArea = pArea->next)
        {
                if (vnum >= pArea->min_vnum
                        &&  vnum <= pArea->max_vnum)
                        return pArea;
        }

        return 0;
}

void free_area(AREA_DATA *pArea)
{
        free_string(pArea->name);
        free_string(pArea->file_name);
        free_string(pArea->builders);
        free_string(pArea->credits);
        mlstr_free (pArea->resetmsg);
        mlstr_free (pArea->mlname);
        top_area--;
        free(pArea);
}

EXIT_DATA *new_exit(void)
{
        EXIT_DATA *pExit;

        pExit = calloc(1, sizeof(*pExit));
        pExit->keyword = str_empty;
        pExit->size    = 50;

        top_exit++;
        return pExit;
}

void free_exit(EXIT_DATA *pExit)
{
        if (!pExit)
                return;

        free_string(pExit->keyword);
        mlstr_free(pExit->description);

        top_exit--;
        free(pExit);
}

ROOM_INDEX_DATA *new_room_index(void)
{
        ROOM_INDEX_DATA *pRoom;
        int door;
        
        pRoom = calloc(1, sizeof(*pRoom));
        top_room++;

        pRoom->owner = str_empty;
        pRoom->heal_rate = 100;
        pRoom->mana_rate = 100;
        pRoom->space     = 255;

        pRoom->next             =   NULL;
    pRoom->people           =   NULL;
    pRoom->contents         =   NULL;
    pRoom->ed                           =   NULL;
    pRoom->area             =   NULL;

    for ( door = 0; door < 6; door++ )
    {
        pRoom->exit[door]   =   NULL;
    }

    pRoom->name             =   mlstr_new(str_empty);
    pRoom->description      =   mlstr_new(str_empty);
    pRoom->vnum             =   0;
    pRoom->room_flags       =   0;
    pRoom->light            =   0;
    pRoom->sector_type      =   0;
    return pRoom;
}

void free_room_index(ROOM_INDEX_DATA *pRoom)
{
        int door;
        ED_DATA *pExtra;
        RESET_DATA *pReset;

        mlstr_free(pRoom->name);
        mlstr_free(pRoom->description);
        free_string(pRoom->owner);
        rptrig_free(pRoom->rprogs);

        for (door = 0; door < MAX_DIR; door++)
                if (pRoom->exit[door])
                        free_exit(pRoom->exit[door]);

        for (pExtra = pRoom->ed; pExtra; pExtra = pExtra->next)
                ed_free(pExtra);

        for (pReset = pRoom->reset_first; pReset; pReset = pReset->next)
                free_reset_data(pReset);

        top_room--;
        free(pRoom);
}

SHOP_DATA *new_shop(void)
{
        SHOP_DATA *pShop;

        pShop = calloc(1, sizeof(*pShop));
        pShop->profit_buy   =   100;
        pShop->profit_sell  =   100;
        pShop->close_hour   =   23;

        top_shop++;
        return pShop;
}

void free_shop(SHOP_DATA *pShop)
{
        if (!pShop)
                return;
        top_shop--;
        free(pShop);
}

OBJ_INDEX_DATA *new_obj_index(void)
{
        OBJ_INDEX_DATA *pObj;

        pObj = calloc(1, sizeof(*pObj));

        pObj->name          = str_dup("no name");
        pObj->item_type     = ITEM_TRASH;
        pObj->material      = str_dup("default");
        pObj->condition     = 100;
        pObj->limit         = -1;

        top_obj_index++;
        return pObj;
}

void free_obj_index(OBJ_INDEX_DATA *pObj)
{
        ED_DATA *pExtra;
        AFFECT_DATA *pAf;

        if (!pObj)
                return;

        free_string(pObj->name);
        free_string(pObj->material);
        mlstr_free(pObj->short_descr);
        mlstr_free(pObj->description);
        rptrig_free(pObj->oprogs);

        for (pAf = pObj->affected; pAf; pAf = pAf->next)
                aff_free(pAf);

        for (pExtra = pObj->ed; pExtra; pExtra = pExtra->next)
                ed_free(pExtra);

        top_obj_index--;
        free(pObj);
}



MOB_INDEX_DATA *new_mob_index(void)
{
        MOB_INDEX_DATA *pMob;

        pMob = calloc(1, sizeof(*pMob));
        pMob->name          = str_dup("no name");
        pMob->act           = ACT_NPC;
        pMob->race          = rn_lookup("human");
        pMob->material      = str_dup("unknown");
        pMob->size          = SIZE_MEDIUM;
        pMob->start_pos     = POS_STANDING;
        pMob->default_pos   = POS_STANDING;

        top_mob_index++;
        return pMob;
}

void free_mob_index(MOB_INDEX_DATA *pMob)
{
        if (!pMob)
                return;

        free_string(pMob->name);
        free_string(pMob->material);
        mlstr_free(pMob->short_descr);
        mlstr_free(pMob->long_descr);
        mlstr_free(pMob->description);
        mptrig_free(pMob->mptrig_list);
        free_shop(pMob->pShop);

        top_mob_index--;
        free(pMob);
}

MPCODE *mpcode_list;
MPCODE *opcode_list;
MPCODE *rpcode_list;

MPCODE *mpcode_new(void)
{
        MPCODE *mpcode;

        mpcode = calloc(1, sizeof(*mpcode));
        mpcode->code = str_empty;

        top_mprog_index++;
        return mpcode;
}

void mpcode_add(MPCODE *mpcode)
{
        if (mpcode_list == NULL)
                mpcode_list = mpcode;
        else
        {
                mpcode->next = mpcode_list;
                mpcode_list = mpcode;
        }
}

MPCODE *mpcode_lookup(int vnum)
{
        MPCODE *mpcode;
        for (mpcode = mpcode_list; mpcode; mpcode = mpcode->next)
                if (mpcode->vnum == vnum)
                        return mpcode;
        return NULL;
}    

void mpcode_free(MPCODE *mpcode)
{
        if (!mpcode)
                return;

        free_string(mpcode->code);

        top_mprog_index--;
        free(mpcode);
}

MPCODE *opcode_new(void)
{
        MPCODE *opcode;

        opcode = calloc(1, sizeof(*opcode));
        opcode->code = str_empty;

        top_oprog_index++;
        return opcode;
}

void opcode_add(MPCODE *opcode)
{
        if (opcode_list == NULL)
                opcode_list = opcode;
        else
        {
                opcode->next = opcode_list;
                opcode_list = opcode;
        }
}

MPCODE *opcode_lookup(int vnum)
{
        MPCODE *opcode;
        for (opcode = opcode_list; opcode; opcode = opcode->next)
                if (opcode->vnum == vnum)
                        return opcode;
        return NULL;
}  

void opcode_free(MPCODE *opcode)
{
        if (!opcode)
                return;

        free_string(opcode->code);

        top_oprog_index--;
        free(opcode);
}

MPCODE *rpcode_new(void)
{
        MPCODE *rpcode;

        rpcode = calloc(1, sizeof(*rpcode));
        rpcode->code = str_empty;

        top_rprog_index++;
        return rpcode;
}

void rpcode_add(MPCODE *rpcode)
{
        if (rpcode_list == NULL)
                rpcode_list = rpcode;
        else
        {
                rpcode->next = rpcode_list;
                rpcode_list = rpcode;
        }
}

MPCODE *rpcode_lookup(int vnum)
{
        MPCODE *rpcode;
        for (rpcode = rpcode_list; rpcode; rpcode = rpcode->next)
                if (rpcode->vnum == vnum)
                        return rpcode;
        return NULL;
}  

void rpcode_free(MPCODE *rpcode)
{
        if (!rpcode)
                return;

        free_string(rpcode->code);

        top_rprog_index--;
        free(rpcode);
}


