/* $Id: memento.h,v 1.666 2004/09/20 10:49:50 shrike Exp $                              */
 
/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


typedef struct memento_t memento_t;

struct memento_t
{
	const char * name;
	vo_t	id;
};


#define TYPE_NONE	0
#define TYPE_ROOM	1
#define TYPE_OBJ	2
#define	TYPE_MOB	3
#define TYPE_PC		4


bool	memento_set(CHAR_DATA *ch, const char *name, int vnum, int type);
ROOM_INDEX_DATA*	get_remembered_room_index	(CHAR_DATA *ch, const char *name);
MOB_INDEX_DATA*	get_remembered_mob_index		(CHAR_DATA *ch, const char *name);
OBJ_INDEX_DATA*	get_remembered_obj_index		(CHAR_DATA *ch, const char *name); 
int				get_remembered_pc_id		(CHAR_DATA *ch, const char *name);
CHAR_DATA* get_remembered_char_world	(CHAR_DATA *ch, const char *name);

memento_t * lookup_remembered_room 	(CHAR_DATA *ch, ROOM_INDEX_DATA *room);
memento_t * lookup_remembered_obj 	(CHAR_DATA *ch, OBJ_INDEX_DATA *obj);
memento_t * lookup_remembered_mob 	(CHAR_DATA *ch, MOB_INDEX_DATA *mob);
memento_t * lookup_remembered_pc 	(CHAR_DATA *ch, int id);

#define memento_lookup(list, name)	\
((memento_t*) varr_bsearch(&list, &name, cmpstr)) 
