/* $Id: merc.h,v 1.666 2004/09/20 10:49:50 shrike Exp $                             */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 /************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#ifndef _MERC_H_
#define _MERC_H_

/*
#if defined (LINUX) || defined (WIN32)
#   undef  NOCRYPT
#   define NOCRYPT
#   pragma warning (disable : 4244 4018 4761)
#endif
*/

#include <limits.h>
#include <ctype.h>
#include <zlib.h>
#include "typedef.h"
#include "const.h"

/* basic types */
#include "namedp.h"
#include "buffer.h"
#include "str.h"
#include "mlstring.h"
#include "varr.h"
#include "flag.h"

#include "tables.h"
#include "comm/comm.h"
#include "comm/comm_act.h"
#include "db/alias.h"
#include "db/cmd.h"
#include "db/dofun.h"
#include "db/gsn.h"
#include "db/spellfn.h"
#include "db/msg.h"
#include "db/hometown.h"
#include "db/socials.h"
#include "db/specvar.h"

#include "ext_flags.h"
#include "memento.h"
#include "argument.h"
#include "price.h"

#include "db/planet.h"
#include "planets.h"
#include "wquest.h"

/* utils */
#include "log.h"
#include "util.h"
#include "lookup.h"
#include "string_edit.h"

#include "gambling.h"
#include "psionics.h"

#include "event.h"
#include "prog.h"

#include "keyring.h"

#ifdef IMC
    #include "imc.h"
#endif
#ifdef I3
   #include "i3.h"
#endif

#if defined (WIN32)
#define inline __inline
#endif


void    info    (CHAR_DATA * ch, int level, const char * message, ...);

#define TELOPT_COMPRESS     85
#define TELOPT_COMPRESS2    86
#define COMPRESS_BUF_SIZE   16384

/*
 * Equpiment wear locations.
 * Used in #RESETS.
 */
#define WEAR_NONE            -1
#define WEAR_LIGHT            0
#define WEAR_FINGER_L         1
#define WEAR_FINGER_R         2
#define WEAR_NECK_1           3
#define WEAR_EAR              4
#define WEAR_BODY             5
#define WEAR_HEAD             6
#define WEAR_LEGS             7
#define WEAR_FEET             8
#define WEAR_HANDS            9
#define WEAR_ARMS            10
#define WEAR_SHIELD          11
#define WEAR_ABOUT           12
#define WEAR_WAIST           13
#define WEAR_WRIST_L         14
#define WEAR_WRIST_R         15
#define WEAR_WIELD           16
#define WEAR_HOLD            17
#define WEAR_FLOAT           18
#define WEAR_TATTOO          19
#define WEAR_SECOND_WIELD    20
#define WEAR_CLANMARK        21
#define WEAR_STUCK_IN        22
#define WEAR_PLUG_IN         23
#define WEAR_TAIL            24
#define WEAR_FACE            25
#define MAX_WEAR             26

/* damage classes */
#define DAM_NONE        0      // generic damage type

#define DAM_PHYSICAL    1      // generic physical damage class
#define DAM_OTHER       2      // generic nonphysical damage class

#define DAM_WEAPON      3      // generic weapon damage class
#define DAM_MAGIC       4      // generic magic damage class

#define DAM_BASH        5      // specialized weapon damage classes
#define DAM_PIERCE      6
#define DAM_SLASH       7

#define DAM_FIRE        8      // specialized physical non-weapon damages
#define DAM_COLD        9
#define DAM_LIGHTNING   10
#define DAM_ENERGY      11
#define DAM_ACID        12
#define DAM_LIGHT       13
#define DAM_SOUND       14

#define DAM_NEGATIVE    15     // nonphysical(other) magic damage classes
#define DAM_HOLY        16
#define DAM_LIGHT_V     17
#define DAM_HARM        18
#define DAM_CHARM       19
#define DAM_SUMMON      20

#define DAM_MENTAL      21    // nonphysical(other) nonmagic damage classes
#define DAM_POISON      22
#define DAM_DISEASE     23
#define DAM_THIRST      24
#define DAM_HUNGER      25
#define DAM_TRAP_ROOM   26
#define DAM_SPACE       27
#define DAM_RADIATION   28
#define DAM_WOOD        29
#define DAM_IRON        30
#define DAM_SILVER      31
#define MAX_DAM         32

#define IMM_NONE        (1 << DAM_NONE)     /* Immunity to everything */

#define IMM_PHYSICAL    (1 << DAM_PHYSICAL) // metadamages
#define IMM_OTHER       (1 << DAM_OTHER)
#define IMM_WEAPON      (1 << DAM_WEAPON)
#define IMM_MAGIC       (1 << DAM_MAGIC)

#define IMM_BASH        (1 << DAM_BASH)     // weapon+physical
#define IMM_PIERCE      (1 << DAM_PIERCE)
#define IMM_SLASH       (1 << DAM_SLASH)

#define IMM_FIRE        (1 << DAM_FIRE)     // magic+physical
#define IMM_COLD        (1 << DAM_COLD)
#define IMM_LIGHTNING   (1 << DAM_LIGHTNING)
#define IMM_ACID        (1 << DAM_ACID)
#define IMM_ENERGY      (1 << DAM_ENERGY)
#define IMM_LIGHT       (1 << DAM_LIGHT)
#define IMM_SOUND       (1 << DAM_SOUND)
                                            // "non-physical"(other):

#define IMM_NEGATIVE    (1 << DAM_NEGATIVE)  // magic + other
#define IMM_HOLY        (1 << DAM_HOLY)
#define IMM_LIGHT_V     (1 << DAM_LIGHT_V)
#define IMM_HARM        (1 << DAM_HARM)
#define IMM_CHARM       (1 << DAM_CHARM)
#define IMM_SUMMON      (1 << DAM_SUMMON)

#define IMM_MENTAL      (1 << DAM_MENTAL)    // just other
#define IMM_POISON      (1 << DAM_POISON)
#define IMM_DISEASE     (1 << DAM_DISEASE)
#define IMM_THIRST      (1 << DAM_THIRST)
#define IMM_HUNGER      (1 << DAM_HUNGER)
#define IMM_TRAP_ROOM   (1 << DAM_TRAP_ROOM)
#define IMM_SPACE       (1 << DAM_SPACE)
#define IMM_RADIATION   (1 << DAM_RADIATION)
#define IMM_WOOD        (1 << DAM_WOOD)
#define IMM_IRON        (1 << DAM_IRON)
#define IMM_SILVER      (1 << DAM_SILVER)


#include "race.h"
#include "class.h"
#include "clan.h"
#include "skills.h"
#include "religion.h"
#include "meteor.h"
#include "security.h"
#include "immortal.h"
#include "material.h"
#include "shamans.h"
#include "db/liquid.h"

#define COMMAND_KEEP_HIDE   (A)
#define COMMAND_NOORDER (B)
#define COMMAND_CHARMED_OK  (C)
#define COMMAND_HIDDEN  (D)
#define COMMAND_DISABLED    (E)
#define COMMAND_CHARM_PC_OK (F)
#define COMMAND_SOUL    (G)
#define COMMAND_FROZEN_OK   (H)

/*
 * Time and weather stuff.
 */
#define SUN_DARK                    0
#define SUN_RISE                    1
#define SUN_LIGHT                   2
#define SUN_SET                     3

#define F_SUN_DARK                  (A)
#define F_SUN_RISE                  (B)
#define F_SUN_LIGHT                 (C)
#define F_SUN_SET                   (D)

// SKY_XX - temporary for old compatibilites

#define SKY_CLOUDLESS               0
#define SKY_CLOUDY                  1
#define SKY_RAINING                 2
#define SKY_LIGHTNING               3
#define SKY_SNOWING                 4
#define SKY_BLIZZARD                5
#define SKY_FOGGY                   6
#define SKY_HAILSTORM               7
#define SKY_THUNDERSTORM            8
#define SKY_ICESTORM                9

#define WEATHER_NORMAL              0
#define WEATHER_FINE                20
#define WEATHER_BAD                 40
#define WEATHER_RAIN                60
#define WEATHER_DISGUSTING          80
#define WEATHER_CATACLYSM           100

#define CLIMAT_CONTINENTAL          0
#define CLIMAT_TROPIC               1
#define CLIMAT_ARCTIC               2
#define CLIMAT_SEA                  3
#define CLIMAT_DESSERT              4
#define CLIMAT_MOUNTAIN             5
#define CLIMAT_HIGHMOUNTAIN         6

#define WIND_NORTH                  1
#define WIND_SOUTH                  2
#define WIND_WEST                   3
#define WIND_EAST                   4


struct weather_data_area
{
    int weather_status;
    int weather_delta;
    int temperature;
    int wind_direction;
    int wind_speed;
    int humidity;
};

struct time_info_data
{
    int     hour;
    int     day;
    int     month;
    int     year;
};

struct weather_data
{
    int     change;
    int     sky;
    int     sunlight;
};

/*
 * Variables for SUN Rise/Set
 */

int     SUN_RISE_TIME;
int     SUN_SET_TIME;

/*
 * For Moscow
 */

#define BREADTH    54.58
#define LONGITUDE  52.14
#define TIME_ZONE  -3

// Weather patch
bool    number_chance           args((int num));
void    show_weather            args(( CHAR_DATA *ch ));
bool    IS_OUTDOORS             args(( CHAR_DATA *ch ));
// End Weather patch


/*
 * Connected state for a channel.
 */
#define CON_PLAYING          0
#define CON_GET_NAME             1
#define CON_GET_OLD_PASSWORD         2
#define CON_CONFIRM_NEW_NAME         3
#define CON_GET_NEW_PASSWORD         4
#define CON_CONFIRM_NEW_PASSWORD     5
#define CON_GET_NEW_RACE         6
#define CON_GET_NEW_SEX          7
#define CON_GET_NEW_CLASS        8
#define CON_GET_ALIGNMENT        9
#define CON_DEFAULT_CHOICE      10
#define CON_GEN_GROUPS          11
#define CON_PICK_WEAPON         12
#define CON_READ_IMOTD          13
#define CON_READ_MOTD           14
#define CON_BREAK_CONNECT       15
#define CON_ROLL_STATS          16
#define CON_ACCEPT_STATS        17
#define CON_PICK_HOMETOWN       18
#define CON_GET_ETHOS           19
#define CON_CREATE_DONE         20
#define CON_GET_CODEPAGE        21
#define CON_RESOLV          22

/*
 * Descriptor (channel) structure.
 */
struct descriptor_data
{
    DESCRIPTOR_DATA *   next;
    DESCRIPTOR_DATA *   snoop_by;
    CHAR_DATA *         character;
    CHAR_DATA *         original;
    const char *        host;
    int                 descriptor;
    int                 connected;
    bool                wait_for_se;
    bool                fcommand;
    char                inbuf       [4 * MAX_INPUT_LENGTH];
    char                incomm      [MAX_INPUT_LENGTH];
    char                inlast      [MAX_INPUT_LENGTH];
    int                 repeat;
    char *              outbuf;
    uint                outsize;
    uint                outtop;
    const char *        showstr_head;
    const char *        showstr_point;
    struct codepage*    codepage;

/* OLC stuff */
    olced_t *           olced;
    void *              pEdit;      /* edited obj   */
    void *              pEdit2;     /* edited obj 2 */

/* string editor stuff */
    const char **       pString;    /* edited string    */
    const char *        backup;     /* backup       */

/* mccp stuff*/
    bool               wait_compression;
    z_stream         * out_compress;
    unsigned char    * out_compress_buf;
};

/*
 * Attribute bonus structures.
 */
struct str_app_type
{
    int tohit;
    int todam;
    int carry;
    int wield;
};

struct int_app_type
{
    int learn;
};

struct wis_app_type
{
    int practice;
};

struct dex_app_type
{
    int defensive;
    int att;
};

struct con_app_type
{
    int hitp;
    int shock;
};

/*
 * Help table types.
 */
struct help_data
{
    HELP_DATA * next;
    HELP_DATA * next_in_area;
    AREA_DATA * area;

    int     level;
    const char *    keyword;
    mlstring *  text;
};

/*
 * Shop types.
 */

struct shop_data
{
    SHOP_DATA * next;                   /* Next shop in list            */
    int         keeper;                 /* Vnum of shop keeper mob      */
    int         buy_type [MAX_TRADE];   /* Item types shop will buy     */
    uint        profit_buy;             /* Cost multiplier for buying   */
    uint        profit_sell;            /* Cost multiplier for selling  */
    int         open_hour;              /* First opening hour           */
    int         close_hour;             /* First closing hour           */
};

/*
 * Per-class stuff.
 */

#define GET_STAT_BY_NAME(name)  (flag_value(stat_names, name))
#define GET_STAT_NAME(stat) (flag_string(stat_names, stat))


#define    CLASS_WITCH          (cn_lookup("witch"))
#define    CLASS_CLERIC         (cn_lookup("cleric"))
#define    CLASS_THIEF          (cn_lookup("thief"))
#define    CLASS_WARRIOR        (cn_lookup("warrior"))
#define    CLASS_PALADIN        (cn_lookup("paladin"))
#define    CLASS_ANTI_PALADIN   (cn_lookup("anti-paladin"))
#define    CLASS_NINJA          (cn_lookup("ninja"))
#define    CLASS_RANGER         (cn_lookup("ranger"))
#define    CLASS_WARLOCK        (cn_lookup("warlock"))
#define    CLASS_SAMURAI        (cn_lookup("samurai"))
#define    CLASS_VAMPIRE        (cn_lookup("vampire"))
#define    CLASS_NECROMANCER    (cn_lookup("necromancer"))
#define    CLASS_CYBER_MAGE     (cn_lookup("cyber-mage"))
#define    CLASS_ENGINEER       (cn_lookup("engineer"))
#define    CLASS_DRUID          (cn_lookup("druid"))
#define    CLASS_BEASTMASTER    (cn_lookup("beastmaster"))
#define    CLASS_PRIEST         (cn_lookup("priest"))
#define    CLASS_OCCULTIST      (cn_lookup("occultist"))
#define    CLASS_SHAMAN         (cn_lookup("shaman"))


enum {
    SLANG_COMMON,
    SLANG_HUMAN,
    SLANG_ELVISH,
    SLANG_DWARVISH,
    SLANG_GNOMISH,
    SLANG_GIANT,
    SLANG_TROLLISH,
    SLANG_CAT,
    SLANG_ILLITHID,
    SLANG_MAX
};

struct wiznet_type
{
    char *  name;
    int     flag;
    int     level;
};

struct attack_type
{
    char *  name;           /* name */
    char *  noun;           /* message */
    char *  rnoun;          /* message */
    int     damage;         /* damage class */
    int     gender;         /* damage gender */
};

struct spec_type
{
    char *      name;           /* special function name */
    SPEC_FUN *  function;       /* the function */
};

/*-------------------------------------------------------------------
 * affects stuff
 */
struct affect_data
{
    AFFECT_DATA *   next;
    flag32_t     where;
    int     type;
    int     level;
    int     duration;
    int     location;
    int     modifier;
    flag64_t      bitvector;
};

/* where definitions */
#define TO_AFFECTS  0
#define TO_OBJECT   1
#define TO_IMMUNE   2
#define TO_RESIST   3
/*#define TO_VULN     4*/
#define TO_WEAPON   5
#define TO_FORM     6

struct where_t
{
    flag32_t where;
    flag_t *  table;
    char *  format;
};

where_t *where_lookup(flag32_t where);

/* where definitions for room */
#define TO_ROOM_AFFECTS 0
#define TO_ROOM_CONST   1
#define TO_ROOM_FLAGS   2

/* room applies */
#define APPLY_ROOM_NONE     0
#define APPLY_ROOM_HEAL     1
#define APPLY_ROOM_MANA     2

/*
 * A kill structure (indexed by level).
 */
struct kill_data
{
    int     number;
    int     killed;
};

/***************************************************************************
 *                                                                         *
 *           VALUES OF INTEREST TO AREA BUILDERS                           *
 *           (Start of section ... start here)                             *
 *                                                                         *
 ***************************************************************************/

#define SILVER_WEIGHT (1/10)
#define GOLD_WEIGHT   (2/5)

/* MUD server options (etc/system.conf) */
#define OPT_ASCII_ONLY_NAMES (A)

extern flag32_t mud_options;

#define LVL(ch)         UMAX(1,ch->level+ch->aff_level+ch->sector_level)

/* general align */
#define ALIGN_NONE      -1
#define ALIGN_GOOD      1000
#define ALIGN_NEUTRAL   0
#define ALIGN_EVIL      -1000

/* align restrictions */
#define RA_NONE         (0)
#define RA_GOOD         (A)
#define RA_NEUTRAL      (B)
#define RA_EVIL         (C)

/* note types */
#define NOTE_NOTE       0
#define NOTE_IDEA       1
#define NOTE_PENALTY    2
#define NOTE_NEWS       3
#define NOTE_CHANGES    4

/*
 * Data structure for notes.
 */
struct note_t
{
    note_t *    next;
    flag32_t        type;
    const char *    sender;
    const char *    from;
    const char *    date;
    const char *    to_list;
    const char *    subject;
    const char *    text;
    time_t      date_stamp;
};

/* skills group numbers*/
#define GROUP_NONE              0
#define GROUP_WEAPONSMASTER     (A)
#define GROUP_ATTACK            (B)
#define GROUP_BEGUILING         (C)
#define GROUP_BENEDICTIONS      (D)
#define GROUP_COMBAT            (E)
#define GROUP_SUMMONING         (F)
#define GROUP_CURATIVE          (G)
#define GROUP_DETECTION         (H)
#define GROUP_DRACONIAN         (I)
#define GROUP_ENCHANTMENT       (J)
#define GROUP_ENHANCEMENT       (K)
#define GROUP_HARMFUL           (L)
#define GROUP_HEALING           (M)
#define GROUP_ILLUSION          (N)
#define GROUP_MALADICTIONS      (O)
#define GROUP_PROTECTIVE        (P)
#define GROUP_TRANSPORTATION    (Q)
#define GROUP_WEATHER           (R)
#define GROUP_FIGHTMASTER       (S)
#define GROUP_ABJURATION        (T)
#define GROUP_MEDITATION        (U)
#define GROUP_CLAN              (V)
#define GROUP_DEFENSIVE         (W)
#define GROUP_WIZARD            (X)
#define GROUP_PSIONICS          (Y)
#define GROUP_COVERT            (Z)
#define GROUP_CRAFT             (aa)
#define GROUP_NATURAL           (bb)
#define GROUP_NECROMANCY        (cc)
#define GROUP_ELEMENTAL         (dd)
#define GROUP_FISHING           (ee)
#define GROUP_TATTOO            (ff)
#define GROUP_RITUAL            (gg)

/* psionic disciplines */
#define DISC_CLAIRSENTIENCE     (A)
#define DISC_PSYCHOKINESIS      (B)
#define DISC_PSYCHOMETABOLISM   (C)
#define DISC_PSYCHOPORTATION    (D)
#define DISC_TELEPATHY          (E)
#define DISC_METAPSIONICS       (F)

/*
 * AREA FLAGS
 */
#define AREA_HOMETOWN           (A) // area is a hometown
#define AREA_UNDER_CONSTRUCTION (B) // transportation does not work,
#define AREA_NOQUEST            (C) // no quests in this area
#define AREA_GRAVEYARD          (D)
#define AREA_GQACTIVE           (E) // there are GQ mobs in this area (c) Illinar
#define AREA_NOWEATHER          (F) // no weather affects in room
#define AREA_NOMETEOR           (G) // no meteorit faled in area
#define AREA_WAR_ENABLED        (H) // wars in this area are enabled
#define AREA_WAR_ACTIVE         (I) // war in this area is in progress
#define AREA_NOWQUEST           (J) // no wquests in area
#define AREA_HIDDEN             (K) // doesn't appear in 'area' for mortals 
#define AREA_HAS_QUEST          (L) // has quest like kassandra quest
#define AREA_TEMPORARY          (M) // not saved when 'asave area'

#define AREA_CHANGED            (Z) // area has been modified


/*
 * ACT bits for mobs.  *ACT*
 * Used in #MOBILES.
 */
#define ACT_NPC             (A)     /* Auto set for mobs    */
#define ACT_SENTINEL        (B)     /* Stays in one room    */
#define ACT_SCAVENGER       (C)     /* Picks up objects */
#define ACT_AGGRESSIVE      (F)     /* Attacks PC's     */
#define ACT_STAY_AREA       (G)     /* Won't leave area */
#define ACT_WIMPY           (H)
#define ACT_PET             (I)     /* Auto set for pets    */
#define ACT_TRAIN           (J)     /* Can train PC's   */
#define ACT_PRACTICE        (K)     /* Can practice PC's    */
#define ACT_HUNTER          (L)
#define ACT_UNDEAD          (O)     /* no longer used */
#define ACT_CLERIC          (Q)
#define ACT_MAGE            (R)
#define ACT_THIEF           (S)
#define ACT_WARRIOR         (T)
#define ACT_NOALIGN         (U)
#define ACT_NOPURGE         (V)
#define ACT_OUTDOORS        (W)
#define ACT_QUESTOR         (X)
#define ACT_INDOORS         (Y)
#define ACT_RIDEABLE        (Z)
#define ACT_HEALER          (aa)
#define ACT_GAIN            (bb)
#define ACT_UPDATE_ALWAYS   (cc)
#define ACT_CHANGER         (dd)
#define ACT_NOTRACK         (ee)
#define ACT_CLAN_GUARD      (ff)
#define ACT_REPAIRMAN       (gg)
#define ACT_FORGER          (hh)
#define ACT_NOQUEST         (ii)
#define ACT_NOREMEMBR       (jj)
#define ACT_NOREMEMBER_THIS (kk)
#define ACT_AREA_GUARD      (ll)
#define ACT_WANDERER        (mm)
#define ACT_RECEIVE_LEVEL   (nn)


/* OFF bits for mobiles *OFF  */
#define OFF_AREA_ATTACK     (A)
#define OFF_BACKSTAB        (B)
#define OFF_BASH            (C)
#define OFF_BERSERK         (D)
#define OFF_DISARM          (E)
#define OFF_DODGE           (F)
#define OFF_FADE            (G)
#define OFF_FAST            (H)
#define OFF_KICK            (I)
#define OFF_DIRT_KICK       (J)
#define OFF_PARRY           (K)
#define OFF_RESCUE          (L)
#define OFF_TAIL            (M)
#define OFF_TRIP            (N)
#define OFF_CRUSH           (O)
#define ASSIST_ALL          (P)
#define ASSIST_ALIGN        (Q)
#define ASSIST_RACE         (R)
#define ASSIST_PLAYERS      (S)
#define ASSIST_GUARD        (T)
#define ASSIST_VNUM         (U)

// RES bits for mobs *RES (oldstyle, used for converting)
#define RES_SUMMON          (A)
#define RES_CHARM           (B)
#define RES_MAGIC           (C)
#define RES_WEAPON          (D)
#define RES_BASH            (E)
#define RES_PIERCE          (F)
#define RES_SLASH           (G)
#define RES_FIRE            (H)
#define RES_COLD            (I)
#define RES_LIGHTNING       (J)
#define RES_ACID            (K)
#define RES_POISON          (L)
#define RES_NEGATIVE        (M)
#define RES_HOLY            (N)
#define RES_ENERGY          (O)
#define RES_MENTAL          (P)
#define RES_DISEASE         (Q)
#define RES_PHYSICAL        (R)
#define RES_LIGHT           (S)
#define RES_SOUND           (T)
#define RES_WOOD            (U)
#define RES_RADIATION       (X)
#define RES_SILVER          (Y)
#define RES_IRON            (Z)

// body forms
#define FORM_EDIBLE         (A)
#define FORM_POISON         (B)
#define FORM_MAGICAL        (C)
#define FORM_INSTANT_DECAY  (D)
#define FORM_OTHER          (E)  // defined by material bit

/* actual form */
#define FORM_ANIMAL     (G)
#define FORM_SENTIENT   (H)
#define FORM_UNDEAD     (I) /* mainly used to determine undeads */
#define FORM_CONSTRUCT  (J)
#define FORM_MIST       (K)
#define FORM_INTANGIBLE (L)

#define FORM_BIPED      (M)
#define FORM_CENTAUR    (N)
#define FORM_INSECT     (O)
#define FORM_SPIDER     (P)
#define FORM_CRUSTACEAN (Q)
#define FORM_WORM       (R)
#define FORM_BLOB       (S)

#define FORM_MAMMAL     (V)
#define FORM_BIRD       (W)
#define FORM_REPTILE    (X)
#define FORM_SNAKE      (Y)
#define FORM_DRAGON     (Z)
#define FORM_AMPHIBIAN  (aa)
#define FORM_FISH       (bb)
#define FORM_COLD_BLOOD (cc)

/* "pc" forms */
#define FORM_VAMPIRE    (dd)
#define FORM_CYBORG     (ee)
#define FORM_MECH       (ff)
#define FORM_DEMON_AIR  (gg)
#define FORM_DEMON_WATER    (hh)
#define FORM_DEMON_EARTH    (ii)
#define FORM_DEMON_FIRE     (jj)
#define FORM_BEAR       (kk)
#define FORM_WOLF       (ll)

#define FORM_DEMON      (FORM_DEMON_AIR | FORM_DEMON_WATER | \
                        FORM_DEMON_EARTH | FORM_DEMON_FIRE)
#define FORM_CHANGED    (FORM_VAMPIRE | FORM_MECH | FORM_DEMON | \
                            FORM_BEAR | FORM_WOLF)

/* body parts */
#define PART_HEAD       (A)
#define PART_ARMS       (B)
#define PART_LEGS       (C)
#define PART_HEART      (D)
#define PART_BRAINS     (E)
#define PART_GUTS       (F)
#define PART_HANDS      (G)
#define PART_FEET       (H)
#define PART_FINGERS        (I)
#define PART_EAR        (J)
#define PART_EYE        (K)
#define PART_LONG_TONGUE    (L)
#define PART_EYESTALKS      (M)
#define PART_TENTACLES      (N)
#define PART_FINS       (O)
#define PART_WINGS      (P)
#define PART_TAIL       (Q)
/* for combat */
#define PART_CLAWS      (U)
#define PART_FANGS      (V)
#define PART_HORNS      (W)
#define PART_SCALES     (X)
#define PART_TUSKS      (Y)


/*
 * Bits for 'affected_by'.  *AFF*
 * Used in #MOBILES.
 */
#define AFF_BLIND           (A)
#define AFF_INVIS           (B)
#define AFF_DETECT_EVIL     (C)
#define AFF_DETECT_INVIS    (D)
#define AFF_DETECT_MAGIC    (E)
#define AFF_DETECT_HIDDEN   (F)
#define AFF_DETECT_GOOD     (G)
#define AFF_SANCTUARY       (H)
#define AFF_FAERIE_FIRE     (I)
#define AFF_INFRARED        (J)
#define AFF_CURSE           (K)
#define AFF_CORRUPTION      (L)
#define AFF_POISON          (M)
#define AFF_PROTECT_EVIL    (N)
#define AFF_PROTECT_GOOD    (O)
#define AFF_SNEAK           (P)
#define AFF_HIDE            (Q)
#define AFF_SLEEP           (R)
#define AFF_CHARM           (S)
#define AFF_FLYING          (T)
#define AFF_PASS_DOOR       (U)
#define AFF_HASTE           (V)
#define AFF_CALM            (W)
#define AFF_PLAGUE          (X)
#define AFF_SPELLBANE       (Y)     /* BR's SpellBane */
#define AFF_DARK_VISION     (Z)
#define AFF_BERSERK         (aa)
#define AFF_SWIM            (bb)
#define AFF_REGENERATION    (cc)
#define AFF_SLOW            (dd)
#define AFF_CAMOUFLAGE      (ee)
#define AFF_IMP_INVIS       (ff)    /* improved invis */
#define AFF_FADE            (gg)
#define AFF_ABSORB          (hh)    /* absorb */
#define AFF_BLOODTHIRST     (ii)
#define AFF_STUN            (jj)
#define AFF_SUFFOCATE       (kk)    /* suffocate */
#define AFF_DETECT_IMP_INVIS    (ll)    /* detect improved invis */
#define AFF_DETECT_FADE     (mm)
#define AFF_DETECT_UNDEAD   (nn)
#define AFF_FEAR            (oo)
#define AFF_EARTHFADE       (pp)
#define AFF_GROUNDING       (qq)    /* grounding */
#define AFF_WEB             (rr)
#define AFF_DETECT_LIFE     (ss)
#define AFF_ACUTE_VISION    (tt)
#define AFF_BLACK_SHROUD    (uu)    /* for SoG areas */
#define AFF_TRAP            (vv)
#define AFF_RESISTANCE      (ww)    /* BR's resistance */
#define AFF_AUTOREPAIR      (xx)    /* Cyborg Heal */
#define AFF_DETECT_TRAP     (yy)    /* detect trap */
#define AFF_PROTECTION      (zz)

#define AFF_WEAK_STUN       ((flag64_t) 1 << 52)  /* don't need to be saved */
#define AFF_DOPPELGANGER    ((flag64_t) 1 << 53)
#define AFF_MIRROR          ((flag64_t) 1 << 54)

#define WISH_SHOWSCRY     (A)
#define WISH_EXPRATE1     (B)
#define WISH_EXPRATE2     (C)
#define WISH_SPELLUP1     (D)
#define WISH_SPELLUP2     (E)
#define WISH_GROUP        (F)
#define WISH_DURATION     (G)
#define WISH_NOHUNGER     (H)
#define WISH_LEARNUP1     (I)
#define WISH_LEARNUP2     (J)
#define WISH_SAFFECTS     (K)
#define WISH_MINDBLANK    (L)

/*
 * *AFF* bits for rooms
 */
#define RAFF_SHOCKING       (A)
#define RAFF_LSHIELD        (B)
#define RAFF_THIEF_TRAP     (C)
#define RAFF_RANDOMIZER     (D)
#define RAFF_ESPIRIT        (E)
#define RAFF_FWALL          (F)
#define RAFF_CURSE          (K)
#define RAFF_POISON         (M)
#define RAFF_SLEEP          (R)
#define RAFF_RADIATION      (S)
#define RAFF_RANGER_TRAP    (T)
#define RAFF_PLAGUE         (X)
#define RAFF_SLOW           (dd)
#define RAFF_PREVENT        (ee)
#define RAFF_PROTECTION     (ff) // for shamans' ritual 'circle of protection'

/*
 * Sex.
 * Used in #MOBILES.
 */
enum {
    SEX_NEUTRAL,
    SEX_MALE,
    SEX_FEMALE,
    SEX_EITHER,     /* used only for NPC, means random sex in create_mob */
    SEX_PLURAL,
    SEX_MAX = SEX_EITHER
};

/* Sexual restrictions */
#define R_SEX_NEUTRAL       (A)
#define R_SEX_MALE          (B)
#define R_SEX_FEMALE        (C)

/* AC types */
#define AC_PIERCE           0
#define AC_BASH             1
#define AC_SLASH            2
#define AC_EXOTIC           3

/* dice */
#define DICE_NUMBER         0
#define DICE_TYPE           1
#define DICE_BONUS          2

/* size */
#define SIZE_TINY_MIN           0
#define SIZE_TINY           1
#define SIZE_TINY_MAX           2
#define SIZE_SMALL_MIN          3
#define SIZE_SMALL          4
#define SIZE_SMALL_MAX          4
#define SIZE_MEDIUM_MIN         5
#define SIZE_MEDIUM         6
#define SIZE_MEDIUM_MAX         7
#define SIZE_LARGE_MIN          8
#define SIZE_LARGE          10
#define SIZE_LARGE_MAX          12
#define SIZE_HUGE_MIN           13
#define SIZE_HUGE           15
#define SIZE_HUGE_MAX           17
#define SIZE_GIANT_MIN          18
#define SIZE_GIANT          22
#define SIZE_GIANT_MAX          26
#define SIZE_GARGANTUAN_MIN         27
#define SIZE_GARGANTUAN         38
#define SIZE_GARGANTUAN_MAX         50


/*
 * Item types.
 * Used in #OBJECTS.
 */
#define ITEM_LIGHT          1
#define ITEM_SCROLL         2
#define ITEM_WAND           3
#define ITEM_STAFF          4
#define ITEM_WEAPON         5
#define ITEM_TREASURE       8
#define ITEM_ARMOR          9
#define ITEM_POTION         10
#define ITEM_CLOTHING       11
#define ITEM_FURNITURE      12
#define ITEM_TRASH          13
#define ITEM_CONTAINER      15
#define ITEM_DRINK_CON      17
#define ITEM_KEY            18
#define ITEM_FOOD           19
#define ITEM_MONEY          20
#define ITEM_BOAT           22
#define ITEM_CORPSE_NPC     23
#define ITEM_CORPSE_PC      24
#define ITEM_FOUNTAIN       25
#define ITEM_PILL           26
#define ITEM_PROTECT        27
#define ITEM_MAP            28
#define ITEM_PORTAL         29
#define ITEM_WARP_STONE     30
#define ITEM_ROOM_KEY       31
#define ITEM_GEM            32
#define ITEM_JEWELRY        33
#define ITEM_JUKEBOX        34
#define ITEM_TATTOO         35
#define ITEM_POLE           36
#define ITEM_SCABBARD       37
#define ITEM_WINDOW         38
#define ITEM_SLOT_MACHINE   39
#define ITEM_RIDDLE         40
#define ITEM_RALTAR         41
#define ITEM_SHAMAN_TATTOO  42
#define ITEM_PAINT          43
#define ITEM_LEARN_BOOK     44
#define ITEM_KEYRING        45


/*
 * Extra flags.  *EXT*
 * Used in #OBJECTS.
 */
#define ITEM_GLOW           (A)
#define ITEM_HUM            (B)
#define ITEM_DARK           (C)
#define ITEM_LOCK           (D)
#define ITEM_EVIL           (E)
#define ITEM_INVIS          (F)
#define ITEM_MAGIC          (G)
#define ITEM_NODROP         (H)
#define ITEM_BLESS          (I)
#define ITEM_ANTI_GOOD      (J)
#define ITEM_ANTI_EVIL      (K)
#define ITEM_ANTI_NEUTRAL   (L)
#define ITEM_NOREMOVE       (M)
#define ITEM_INVENTORY      (N)
#define ITEM_NOPURGE        (O)
#define ITEM_ROT_DEATH      (P)
#define ITEM_VIS_DEATH      (Q)
#define ITEM_NOSAC          (R)
#define ITEM_NONMETAL       (S)
#define ITEM_NOLOCATE       (T)
#define ITEM_MELT_DROP      (U)
#define ITEM_HAD_TIMER      (V)
#define ITEM_SELL_EXTRACT   (W)
#define ITEM_BURN_PROOF     (Y)
#define ITEM_NOUNCURSE      (Z)
#define ITEM_NOSELL         (aa)
#define ITEM_NOT_EDIBLE     (bb)
#define ITEM_QUEST          (cc)
#define ITEM_ENCHANTED      (dd)    /* obj is enchanted */
#define ITEM_MAGE_ONLY      (ee)
#define ITEM_WARRIOR_ONLY   (ff)
#define ITEM_HERO_ONLY      (gg)
#define ITEM_GOD_ONLY       (hh)
#define ITEM_RADIATION      (ii)
#define ITEM_DEATH          (jj)
#define ITEM_PIT            (kk)
#define ITEM_SINGING        (ss)
#define ITEM_NOFIND         (tt)
#define ITEM_NOLOOT         (uu)
#define ITEM_INDESTRUCTABLE (vv)
#define ITEM_HIDURABILITY   (ww)
#define ITEM_OLDSTYLE       (zz)    /* obj is in oldstyle format */

/*
 * Wear flags.   *WEAR*
 * Used in #OBJECTS.
 */
#define ITEM_TAKE           (A)
#define ITEM_WEAR_FINGER    (B)
#define ITEM_WEAR_NECK      (C)
#define ITEM_WEAR_BODY      (D)
#define ITEM_WEAR_HEAD      (E)
#define ITEM_WEAR_LEGS      (F)
#define ITEM_WEAR_FEET      (G)
#define ITEM_WEAR_HANDS     (H)
#define ITEM_WEAR_ARMS      (I)
#define ITEM_WEAR_SHIELD    (J)
#define ITEM_WEAR_ABOUT     (K)
#define ITEM_WEAR_WAIST     (L)
#define ITEM_WEAR_WRIST     (M)
#define ITEM_WIELD          (N)
#define ITEM_HOLD           (O)
#define ITEM_WEAR_NOSAC     (P)
#define ITEM_WEAR_FLOAT     (Q)
#define ITEM_WEAR_TATTOO    (R)
#define ITEM_WEAR_CLANMARK  (S)
#define ITEM_WEAR_EAR       (T)
#define ITEM_WEAR_PLUG_IN   (U)
#define ITEM_WEAR_TAIL      (V)
#define ITEM_WEAR_FACE      (W)

/* obj_data->condition */
#define COND_EXCELLENT      100
#define COND_FINE            80
#define COND_GOOD            60
#define COND_AVERAGE         40
#define COND_POOR            20
#define COND_FRAGILE          0

/* weapon class */
#define WEAPON_EXOTIC       0
#define WEAPON_SWORD        1
#define WEAPON_DAGGER       2
#define WEAPON_SPEAR        3
#define WEAPON_MACE         4
#define WEAPON_AXE          5
#define WEAPON_FLAIL        6
#define WEAPON_WHIP         7
#define WEAPON_POLEARM      8
#define WEAPON_BOW          9
#define WEAPON_ARROW        10
#define WEAPON_LANCE        11
#define WEAPON_SHURIKEN     12
#define WEAPON_KNIFE        13
#define WEAPON_GRENADE      14
#define WEAPON_LIGHTSABER   15

/* fighting stances */

#define STANCE_OFFENSE_II   (2)
#define STANCE_OFFENSE      (1)
#define STANCE_NORMAL       (0)
#define STANCE_DEFENSE      (-1)
#define STANCE_DEFENSE_II   (-2)

/* fighting styles */

#define STYLE_IRONBODY     (2)
#define STYLE_TIGER        (1)
#define STYLE_NORMAL       (0)
#define STYLE_COBRA        (-1)
#define STYLE_DRUNKMAN     (-2)

/* weapon specializations */

#define SPEC_NONE       0
#define SPEC_SWORD      1
#define SPEC_DAGGER     2
#define SPEC_AXE        3
#define SPEC_WHIP       4
#define SPEC_FLAIL      4
#define SPEC_SPEAR      5
#define SPEC_STAFF      5
#define SPEC_HAND       6
#define SPEC_MACE       7

/* weapon types */
#define WEAPON_FLAMING      (A)
#define WEAPON_FROST        (B)
#define WEAPON_VAMPIRIC     (C)
#define WEAPON_SHARP        (D)
#define WEAPON_VORPAL       (E)
#define WEAPON_TWO_HANDS    (F)
#define WEAPON_SHOCKING     (G)
#define WEAPON_POISON       (H)
#define WEAPON_HOLY         (I)
#define WEAPON_KATANA       (J)
#define WEAPON_RADIATION    (K)

/* gate flags */
#define GATE_NORMAL_EXIT    (A)
#define GATE_NOCURSE        (B)
#define GATE_GOWITH         (C)
#define GATE_BUGGY          (D)
#define GATE_RANDOM         (E)
#define GATE_TRANSPARENT    (F)
#define GATE_NOPUMPED       (G)

/* furniture flags */
#define STAND_AT        (A)
#define STAND_ON        (B)
#define STAND_IN        (C)
#define SIT_AT          (D)
#define SIT_ON          (E)
#define SIT_IN          (F)
#define REST_AT         (G)
#define REST_ON         (H)
#define REST_IN         (I)
#define SLEEP_AT        (J)
#define SLEEP_ON        (K)
#define SLEEP_IN        (L)
#define PUT_AT          (M)
#define PUT_ON          (N)
#define PUT_IN          (O)
#define PUT_INSIDE      (P)

/*
 * Apply types (for affects).
 * Used in #OBJECTS.
 */
#define APPLY_NONE           0
#define APPLY_STR            1
#define APPLY_DEX            2
#define APPLY_INT            3
#define APPLY_WIS            4
#define APPLY_CON            5
#define APPLY_CHA            6
#define APPLY_SEX            7
#define APPLY_LEVEL          8
#define APPLY_AGE            9
#define APPLY_HEIGHT        10
#define APPLY_WEIGHT        11
#define APPLY_MANA          12
#define APPLY_HIT           13
#define APPLY_MOVE          14
#define APPLY_GOLD          15
#define APPLY_EXP           16
#define APPLY_AC            17
#define APPLY_HITROLL       18
#define APPLY_DAMROLL       19
#define APPLY_SAVES         20
#define APPLY_SAVING_PARA   20
#define APPLY_SAVING_ROD    21
#define APPLY_SAVING_PETRI  22
#define APPLY_SAVING_BREATH 23
#define APPLY_SAVING_SPELL  24
#define APPLY_SPELL_AFFECT  25
#define APPLY_SIZE          26
#define APPLY_CLASS         27
#define APPLY_RACE          28
#define APPLY_LCK           29

/*
 * Values for containers (value[1]).
 * Used in #OBJECTS.
 */
#define CONT_CLOSEABLE      (A)
#define CONT_PICKPROOF      (B)
#define CONT_CLOSED         (C)
#define CONT_LOCKED         (D)
#define CONT_PUT_ON         (E)
#define CONT_QUIVER         (F)
#define CONT_ROOMY          (G)

/*
 * Room flags.
 * Used in #ROOMS.
 */
#define ROOM_DARK           (A)
#define ROOM_NOMOB          (C)
#define ROOM_INDOORS        (D)
#define ROOM_PEACE          (H)
#define ROOM_PRIVATE        (J)
#define ROOM_SAFE           (K)
#define ROOM_SOLITARY       (L)
#define ROOM_PET_SHOP       (M)
#define ROOM_NORECALL       (N)
#define ROOM_IMP_ONLY       (O)
#define ROOM_GODS_ONLY      (P)
#define ROOM_HEROES_ONLY    (Q)
#define ROOM_NEWBIES_ONLY   (R)
#define ROOM_LAW            (S)
#define ROOM_NOWHERE        (T)
#define ROOM_BANK           (U)
#define ROOM_NOMAGIC        (W)
#define ROOM_NOSUMMON       (X)
#define ROOM_BATTLE_ARENA   (Z)
#define ROOM_REGISTRY       (bb)
#define ROOM_CLANBANK       (cc)
#define ROOM_NOHP           (dd)
#define ROOM_NOMANA         (ee)
#define ROOM_NOMOVE         (ff)
#define ROOM_GAMBLE         (gg)
#define ROOM_SALTWATER_FISH (hh)
#define ROOM_FRESHWATER_FISH (ii)
#define ROOM_MAGIC          (jj)
#define ROOM_NOTIMER        (kk)
#define ROOM_NOEXPLORE      (ll)
#define ROOM_ROAD           (mm)
#define ROOM_FULL_PK        (pp)
#define ROOM_EXIT              (rr)
/*
 * Directions.
 * Used in #ROOMS.
 */
#define DIR_NORTH             0
#define DIR_EAST              1
#define DIR_SOUTH             2
#define DIR_WEST              3
#define DIR_UP                4
#define DIR_DOWN              5

/*
 * Exit flags.
 * Used in #ROOMS.
 */
#define EX_ISDOOR       (A)
#define EX_CLOSED       (B)
#define EX_LOCKED       (C)
#define EX_NOFLEE       (D)
#define EX_TRAP         (E)
#define EX_PICKPROOF    (F)
#define EX_NOPASS       (G)
#define EX_EASY         (H)
#define EX_HARD         (I)
#define EX_INFURIATING  (J)
#define EX_NOCLOSE      (K)
#define EX_NOLOCK       (L)
#define EX_INVIS        (M)
#define EX_NOSCAN       (N)
#define EX_BITVAL       (Z)

/*
 * Sector types.
 * Used in #ROOMS.
 */
#define SECT_INSIDE           0
#define SECT_CITY             1
#define SECT_FIELD            2
#define SECT_FOREST           3
#define SECT_HILLS            4
#define SECT_MOUNTAIN         5
#define SECT_WATER_SWIM       6
#define SECT_WATER_NOSWIM     7
#define SECT_UNUSED           8
#define SECT_AIR              9
#define SECT_DESERT          10

// sector flags - used for rituals
#define F_SECT_INSIDE         (A)
#define F_SECT_CITY           (B)
#define F_SECT_FIELD          (C)
#define F_SECT_FOREST         (D)
#define F_SECT_HILLS          (E)
#define F_SECT_MOUNTAIN       (F)
#define F_SECT_WATER_SWIM     (G)
#define F_SECT_WATER_NOSWIM   (H)
#define F_SECT_UNUSED         (I)
#define F_SECT_AIR            (J)
#define F_SECT_DESERT         (K)

#define SECT_MAX             11

/***************************************************************************/
/*            (Defined casino slot types)                                  */
/***************************************************************************/

#define SLOT_IS_PROGRESSIVE  0
#define SLOT_NO_PROGRESSIVE  1

/***************************************************************************
 *                                     *
 *           VALUES OF INTEREST TO AREA BUILDERS           *
 *           (End of this section ... stop here)           *
 *                                     *
 ***************************************************************************/

/*
 * Conditions.
 */
#define COND_DRUNK          0
#define COND_FULL           1
#define COND_THIRST         2
#define COND_HUNGER         3
#define COND_BLOODLUST      4
#define COND_DESIRE         5

/*
 * Positions.
 */
#define POS_DEAD              0
#define POS_MORTAL            1
#define POS_INCAP             2
#define POS_STUNNED           3
#define POS_SLEEPING          4
#define POS_RESTING           5
#define POS_SITTING           6
#define POS_FIGHTING          7
#define POS_STANDING          8


#define    ETHOS_NONE        0
#define    ETHOS_LAWFUL     (A)
#define    ETHOS_NEUTRAL    (B)
#define    ETHOS_CHAOTIC    (C)


/*
 * ACT bits for players.
 */
#define PLR_NPC         ACT_NPC     /* Don't EVER set.  */
#define PLR_BOUGHT_PET      (B)

/* RT auto flags */
#define PLR_AUTOASSIST      (C)
#define PLR_AUTOEXIT        (D)
#define PLR_AUTOLOOT        (E)
#define PLR_AUTOSAC         (F)
#define PLR_AUTOGOLD        (G)
#define PLR_AUTOSILVER      (V)
#define PLR_AUTOSPLIT       (H)
#define PLR_COLOR           (I) /* obsolete, use COMM_COLOR instead */
#define PLR_WANTED          (J)
#define PLR_NOTITLE         (K)
/* RT personal flags */
#define PLR_NOEXP           (L)
#define PLR_AUTOLOOK        (M)
#define PLR_HOLYLIGHT       (N)
#define PLR_AUTOTITLE       (P)
#define PLR_NOSUMMON        (Q)
#define PLR_NOFOLLOW        (R)
#define PLR_AUTOWEATHER     (S)  //Autoweather
#define PLR_GHOST           (T)
#define PLR_SOUL            (O)
/* penalty flags */
#define PLR_PERMIT          (U)
#define PLR_LOG             (W)
#define PLR_DENY            (X)
#define PLR_FREEZE          (Y)
#define PLR_PUMPED          (Z) /* adrenalin is gushing */

#define PLR_NOSOUL          (aa)
#define PLR_AUTODAMAGE      (bb)
#define PLR_CONFIRM_DELETE  (cc)
#define PLR_HARA_KIRI       (dd)
#define PLR_BLINK           (ee)
#define PLR_NEW             (ff)
#define PLR_TESTER          (zz)

/* Trust stuff */
#define TRUST_GROUP     (A)
#define TRUST_CLAN      (B)
#define TRUST_ALL       (C) /* mutually exclusive with previous two */
#define TRUST_ALIGN     (D)

#define IS_SKILL(sn) (SKILL(sn)->type == TYPE_SKILL)
#define IS_SPELL(sn) (SKILL(sn)->type == TYPE_SPELL)
#define IS_MIRACLE(sn) (SKILL(sn)->type == TYPE_MIRACLE)
#define IS_POWER(sn) (SKILL(sn)->type == TYPE_POWER)
#define IS_SONG(sn) (SKILL(sn)->type == TYPE_SONG)
#define IS_PROGRAM(sn) (SKILL(sn)->type == TYPE_PROGRAM)
#define IS_AUTOSKILL(sn) (SKILL(sn)->type == TYPE_AUTO)
#define IS_LANGUAGE(sn)        (SKILL(sn)->type == TYPE_LANGUAGE)
#define IS_ABILITY(sn)  (SKILL(sn)->type == TYPE_ABILITY)
#define IS_TATTOO(sn)  (SKILL(sn)->type == TYPE_TATTOO)
#define IS_RITUAL(sn)  (SKILL(sn)->type == TYPE_RITUAL)
// commonly used macro:
// for so-called hate_magic checks
#define IS_MAGIC(sn)        (IS_SPELL(sn) || IS_MIRACLE(sn) || IS_PROGRAM(sn))
// for so-called 'nomagic' rooms
#define IS_NONMAGIC(sn) (IS_SKILL(sn) || IS_AUTOSKILL(sn))

#define IS_HARA_KIRI(ch) (IS_SET((ch)->plr_flags, PLR_HARA_KIRI))
#define IS_CLAN_GUARD(ch) (IS_NPC(ch) && IS_SET(ch->pIndexData->act, ACT_CLAN_GUARD))

#define IS_PUMPED(ch) (IS_SET((ch)->plr_flags, PLR_PUMPED))
#define SET_FIGHT_TIME(ch)                  \
    {                           \
        (ch)->last_fight_time = current_time;       \
        SET_BIT((ch)->plr_flags, PLR_PUMPED);       \
    }
#define RESET_FIGHT_TIME(ch)                    \
    {                           \
        (ch)->last_fight_time = -1;         \
        REMOVE_BIT((ch)->plr_flags, PLR_PUMPED);    \
    }

// RT comm flags -- may be used on both mobs and chars
#define COMM_QUIET          (A)
#define COMM_DEAF           (B)
#define COMM_NOWIZ          (C)
#define COMM_NOAUCTION      (D)
#define COMM_NOGOSSIP       (E)
#define COMM_NOQUESTION     (F) // not used yet!
#define COMM_NOMUSIC        (G)
#define COMM_NORTALK        (H)
#define COMM_WARINFO        (I)
#define COMM_NOCLAN         (J)

// display flags
#define COMM_QUIET_EDITOR   (K)
#define COMM_COMPACT        (L)
#define COMM_BRIEF          (M)
#define COMM_PROMPT         (N)
#define COMM_COMBINE        (O)
#define COMM_TELNET_GA      (P)
#define COMM_SHOWAFF        (Q)
#define COMM_AUTOSNOOP      (R)
#define COMM_COLOR          (S)

// penalties
#define COMM_NOEMOTE        (T)
#define COMM_NOCAST         (U)
#define COMM_NOTELL         (V)
#define COMM_NOCHANNELS     (W)

#define COMM_NOENG          (X)
#define COMM_SNOOP_PROOF    (Y)
#define COMM_AFK            (Z)

#define COMM_LONG           (aa)
#define COMM_NOTELNET       (bb)
#define COMM_NOIAC          (cc)
#define COMM_NOVERBOSE      (dd)

// for new channels
#define COMM_NOASK          (ee)
#define COMM_NOHUMOR        (ff)
#define COMM_BUST_PROMPT    (gg)
#define COMM_NONOTE         (hh)
#define COMM_NOQUEST        (ii)
#define COMM_NOOOC          (jj)
#define COMM_NOHERO         (kk)
#define COMM_NOSEND         (ll)
#define PLR_PEACE           (mm)
#define COMM_NOGIVE         (nn)
#define COMM_DEV            (oo)
#define COMM_TRACK          (pp) // for do_track: manual/auto switch
#define COMM_FISHING        (qq)
#define COMM_FISH_ON        (rr)
#define COMM_BONUS          (ss)
#define COMM_CHAT           (tt)
#define COMM_BTALK          (uu)
#define COMM_INFO           (vv)
#define COMM_NOWHOIS        (ww)
#define COMM_NOGQUEST       (xx)
#define COMM_MEMORIAL       (yy)
#define COMM_AGENTNET       (zz)

// flags for comm2
#define COMM2_NOWAR         (A)
#define COMM2_VNUM_SHOW     (B)
#define COMM2_RUSSKILLS     (C)
#define COMM2_RUSEXIT       (D)
#define COMM2_RUSNAMES      (E)

/* IAC replacement if COMM_NOIAC is set */
/* COMM_NOIAC is useful to map '' (IAC) to '' when using win1251 codepage */
#define IAC_REPL    223

/*
 * Command logging types.
 */
#define LOG_NORMAL       0
#define LOG_ALWAYS      (A)
#define LOG_NEVER       (B)

/* WIZnet flags */
#define WIZ_ON          (A)
#define WIZ_TICKS       (B)
#define WIZ_LOGINS      (C)
#define WIZ_SITES       (D)
#define WIZ_LINKS       (E)
#define WIZ_DEATHS      (F)
#define WIZ_RESETS      (G)
#define WIZ_MOBDEATHS   (H)
#define WIZ_FLAGS       (I)
#define WIZ_PENALTIES   (J)
#define WIZ_SACCING     (K)
#define WIZ_LEVELS      (L)
#define WIZ_SECURE      (M)
#define WIZ_SWITCHES    (N)
#define WIZ_SNOOPS      (O)
#define WIZ_RESTORE     (P)
#define WIZ_LOAD        (Q)
#define WIZ_NEWBIE      (R)
#define WIZ_PREFIX      (S)
#define WIZ_SPAM        (T)
#define WIZ_OLC         (U)
#define WIZ_BUGS        (V)
#define WIZ_AUCTION     (W)

struct war_player
{
    CHAR_DATA    * war_char;
    WAR_PLAYER   * next;
    int team;  // used only if team war is in progress
};

struct war_data
{
    WAR_DATA      * next; // for future use
    WAR_PLAYER    * player;
    AREA_DATA     * war_area;
    int             type;
    int             time_limit;     // for future use: time limited wars
    int             time_lasts;     // ticks
    int             time_to_begin;  // war preparation stuff
    int             maxlevel;
    int             minlevel;
    int             max_fighters;   // for tournaments; -1 means unlimited
    int             curr_fighters;
    flag32_t        flags;
    int             qp_reward;
    int             bp_reward;
    int             gold_reward;
    int             obj_reward_vnum;
    int             qp_join_fee;
    int             bp_join_fee;
    int             gold_join_fee;
};

WAR_DATA * war_root;
void war_update (void);
bool war_handle_death (CHAR_DATA * ch, CHAR_DATA * victim);
bool check_war_move (CHAR_DATA * ch, ROOM_INDEX_DATA *to_room, bool silent);
void war_init (void);
void war_quit (CHAR_DATA * ch);

#define WAR_MAX_TYPE        7


#define MAX_AREA_ROOMS 777 /* UnderDark 480 rooms */

struct char_explored_data
{
    CHAR_EXPLORED_DATA *         next;
    const char *name;
    int explored_room_count;
    int explored_room_vnums[MAX_AREA_ROOMS];
    int attitude_good;
    int attitude_evil;
    int attitude_neutral;
    int bribes;
    int bribe_gold;
    int bribe_gems;
    int donations;
    int donate_gold;
    int donate_gems;
};

CHAR_EXPLORED_DATA * get_curr_explored_data (CHAR_DATA * ch);


/*
 * Prototype for a mob.
 * This is the in-memory version of #MOBILES.
 */
struct mob_index_data
{
    MOB_INDEX_DATA *  next;
    SPEC_FUN *        spec_fun;
    SHOP_DATA *       pShop;
    MPTRIG *          mptrig_list;
    int               mptrig_types;
    int               vnum;
    int               fvnum;
    int               group;
    int               count;
    int               killed;
    const char *      name;
    mlstring *        short_descr;
    mlstring *        long_descr;
    mlstring *        description;
    flag64_t          affected_by;
    int               alignment;
    int               level;
    int               hitroll;
    int               hit[3];
    int               mana[3];
    int               damage[3];
    int               ac[4];
    int               dam_type;
    flag64_t          act;
    flag64_t          off_flags;
    flag64_t          immunes;          /* immunities */
    sh_int            resists[MAX_DAM]; /* resistances/vulnerabilities */
    flag64_t          start_pos;
    flag64_t          default_pos;
    flag64_t          sex;
    int               race;
    int               wealth;
    flag64_t          form;
    flag64_t          parts;
    int               pcnt;
    int               size;
    const char *      material;
    flag64_t          practicer;
    int               clan;
    int               invis_level;    /* mobinvis level */
    mlstring *        listen_data;    // for use in do_listen
};

/*
 * One character (PC or NPC). *CHAR_DATA*
 */
#define MAX_TREES 3

struct char_data
{
    CHAR_DATA *         next;
    CHAR_DATA *         next_in_room;
    CHAR_DATA *         master;
    CHAR_DATA *         leader;
    CHAR_DATA *         fighting;
    CHAR_DATA *         reply;
    CHAR_DATA *         repeat;
    CHAR_DATA *         last_fought;
    time_t              last_fight_time;
    time_t              last_death_time;
    CHAR_DATA *         pet;
    CHAR_DATA *         mprog_target;
    CHAR_DATA *         guarding;
    CHAR_DATA *         guarded_by;
    SPEC_FUN *          spec_fun;
    MOB_INDEX_DATA *    pIndexData;
    DESCRIPTOR_DATA *   desc;
    AFFECT_DATA *       affected;
    note_t *            pnote;
    OBJ_DATA *          carrying;
    OBJ_DATA *          on;
    ROOM_INDEX_DATA *   in_room;
    ROOM_INDEX_DATA *   was_in_room;
    AREA_DATA *         zone;
    PC_DATA *           pcdata;
    const char *        name;
    int                 id;
    int                 version;
    mlstring *          short_descr;
    mlstring *          long_descr;
    mlstring *          description;
    mlstring *          immdesc;
    const char *        prompt;
    const char *        prefix;
    int                 group;
    flag32_t            sex;
    int                 class;
    int                 race;
    int                 clan;
    int                 hometown;
    int                 ethos;
    int                 level;
    int                 aff_level;
    int                 played;
    int                 lines;  /* for the pager */
    time_t              logon;
    int                 timer;
    int                 wait;
    int                 daze;
    int                 hit;                // hit points (health)
    int                 max_hit;
    int                 mana;        // mana points (magic energy)
    int                 max_mana;
    int                 move;        //movement (endurance) points
    int                 max_move;
    int                 psp;        //psionic power points
                                //max is derivative
    uint                gold;
    uint                silver;
    int                 exp;    // total exp
    int                 exp_tl; // exp gained this level
    flag64_t            plr_flags;
    flag64_t            comm;   // RT added to pad the vector
    flag64_t            comm2;  
    flag64_t            immunes;            /* immunities */
    sh_int              resists[MAX_DAM];   /* resistances/vulnerabilities */
    int                 invis_level;
    int                 incog_level;
    flag64_t            affected_by;
    flag32_t            position;
    int                 practice;
    int                 train;
    int                 carry_weight;
    int                 carry_number;
    int                 saving_throw;
    int                 alignment;
    int                 hitroll;
    int                 damroll;
    int                 armor[4];
    int                 wimpy;
    int                 stance;
    int                 style;
    int                 psi_def;
    int                 psi_att;
  /* stats */
    int                 perm_stat[MAX_STATS];
    int                 mod_stat[MAX_STATS];
    /* parts stuff */
    flag64_t         form;
    flag32_t         parts;
    int              pcnt;
    int              size;
    const char *     material;
    /* mobile stuff */
    int              damage[3];
    int              dam_type;
    flag32_t         start_pos;
    flag32_t         default_pos;
    int              mprog_delay;
    int              status;
    bool             extracted;
    const char *     in_mind;
    int              religion;
    CHAR_DATA *      hunting;    /* hunt data */
    int              endur;
    bool             riding; /* mount data */
    CHAR_DATA *      mount;
    int              slang;  /* spoken language */
    int              lang; /* interface language */
    CHAR_DATA *      hunter; /* who quested to slay */
    CHAR_DATA *      doppel;
    const char *     imm_name;

    CHAR_DATA *      contact[MAX_CONTACTS];  /* full contacts */
    CHAR_DATA *      tangent;                /* contact in progress */
    int              tangents;                           /* number of touches (max 3) */

    ext_flag_t       ext_flags;
    varr             remembered_rooms;
    varr             remembered_mobs;
    varr             remembered_objects;
    varr             remembered_people;
    mlstring *       listen_data;
    int              marked_tree[MAX_TREES]; // not in pc_data because it might be used for NPCs

    // for wars
    WAR_DATA *       in_war; // not in pc_data because it also might be used for NPCs
    int              stat_wars_all;
    int              stat_wars_win;
    int              stat_type_wars_all [WAR_MAX_TYPE];
    int              stat_type_wars_win [WAR_MAX_TYPE];
    int              total_war_kills;
    int              total_war_deaths;
    int              war_status; // killed or not
    // end especially for duels
    int              duels_provoked;
    int              duels_joined;
    int              duels_win;
    int              last_duel_time;

    // for mobs who can receive exp: see wanderers.c for details
    int              mob_rank;       // mob's "rank" used to calculate kills_left_to_level and in spec_fun
    flag64_t         abilities;      // m.b. abilities2 etc
    flag64_t         actions;
    int              mob_tnl;
    int              extra_attacks;

    EVENT  *         events;
    int              sector_level;  // + or - to level granted by race-specific love or hate to sector type
};

/*
 * Data which only PC's have.
 */
struct pc_data
{
    PC_DATA      *  next;
    BUFFER       *  buffer;
    const char   *  pwd;
    const char   *  bamfin;
    const char   *  bamfout;
    const char   *  title;
    const char   *  pretitle;
    const char   *  twitlist;
    const char   *  linked_list;    /* multis */
    const char   *  granted;    /* granted wiz commands */
    time_t          last_note;
    time_t          last_idea;
    time_t          last_penalty;
    time_t          last_news;
    time_t          last_changes;
    int             perm_hit;
    int             perm_mana;
    int             perm_move;
    flag32_t        true_sex;
    flag32_t        wiznet; /* wiz stuff */
    flag32_t        trust;
    int             last_level;
    int             condition   [MAX_COND];
    varr            learned;
    int             points;
    const char   *  alias[MAX_ALIAS];
    const char   *  alias_sub[MAX_ALIAS];
    int             security;   /* OLC */ /* Builder security */
    int             bank_s;
    int             bank_g;
    int             headprice;
    int             element;
    int             death;
    int             played;
    int             anti_killed;
    int             has_killed;
    int             specialization[3];
    flag32_t        disciplines[6];

    int             bonuspoints;
    int             religionpoints;
    int             religionlevel;
    int             questgiver;
    int             questpoints;
    int             qpbalance;  /* granted qp - donated qp */
    int             questtime;
    int             questobj;
    int             questmob;
    qtrouble_t   *  qtrouble;
    ROOM_INDEX_DATA *   questroom;
    int             questnumber;
    int             questcomplete;

    int             race;
    int             pc_killed;
    int             pc_died;

    int             clan_status;
    int             petition;

    unsigned long   freeze;
    unsigned long   nochan;
    unsigned long   nocast;
    unsigned long   notell;
    unsigned long   noemote;
    unsigned long   nonote;
    unsigned long   noquest;
    unsigned long   nowar;
    unsigned long   peaceful;

    int             plevels;    /* penalty levels */
    const char   *  host;
    const char   *  last_login;
    int             limit_timer;
    bool            has_limit;

    int             StatAllGlobalQuests;
    int             StatWinGlobalQuests;

    CHAR_EXPLORED_DATA * explored_areas;
    CHAR_EXPLORED_DATA * last_visited;
    int TotalExploredRooms;

    const char   * marryed;        /* name(s) :) of players, who marry with ch */
    int            marry_room;
    const char   * proposal;     /* to marry :) */
    time_t         last_divorce;
    time_t         last_marry;

    flag32_t       wishes;

    int            real_level;  // real stuff ;)
    int            real_sec;

    int            this_level_played;
    int            qp_earned;
    int            bp_earned;
    const char   * prog_vars;

#ifdef IMC
    IMC_CHARDATA *imcchardata;
#endif
#ifdef I3
    I3_CHARDATA  *i3chardata;
#endif
    // wquests
    WQ_QUESTDATA * wquest;
    int wq_personal_join;
    int wq_personal_win;
    int wq_mult_join;
    int wq_mult_win;
    int wq_next_time;

    // for quest hp/mana/moves
    int quest_hp_gained;
    int quest_mana_gained;
    int fishes_caught;
    const char * rusnames[6];
};

#define XS_NONE            0
#define XS_FORGOT  (A)

struct pcskill_t {
    int sn;
    flag64_t xs_flags; /* extended skill/spell data flags */
    int percent;
    int level;
};

#define pc_skill_lookup(ch, sn) \
    ((pcskill_t*) varr_bsearch(&ch->pcdata->learned, &sn, cmpint))

/*
 * Liquids.
 */
#define LIQ_WATER    0

// TODO Delete need.
/*
struct liq_type
{
    char *  liq_name;
    char *  liq_color;
    int     liq_affect[5];
};
*/


/*
 * Drunk struct
 */

struct struckdrunk
{
    int min_drunk_level;
    int number_of_rep;
    char *replacement[11];
};

/*
 * Extra description data for a room or object.
 */
struct ed_data
{
    ED_DATA *   next;       /* Next in list         */
    const char *    keyword;    /* Keyword in look/examine  */
    mlstring *  description;    /* What to see          */
};


struct oprog_data {
    char *name;
    OPROG_FUN *fn;
};

enum {
    OPROG_WEAR,
    OPROG_REMOVE,
    OPROG_DROP,
    OPROG_SAC,
    OPROG_GIVE,
    OPROG_GREET,
    OPROG_FIGHT,
    OPROG_DEATH,
    OPROG_SPEECH,
    OPROG_ENTRY,
    OPROG_GET,
    OPROG_AREA,

    OPROG_MAX
};

/*
 * Prototype for an object.
 */
struct obj_index_data
{
    OBJ_INDEX_DATA *    next;
    ED_DATA *           ed;
    AFFECT_DATA *       affected;
    const char *        name;
    mlstring *          short_descr;
    mlstring *          description;
    int                 vnum;
    int                 reset_num;
    const char *        material;
    flag64_t            item_type;
    flag64_t            extra_flags;
    flag64_t            wear_flags;
    int                 level;
    int                 condition;
    int                 count;
    int                 weight;
    uint                cost;
    int                 value[5];
    int                 limit;
    OPROG_FUN **        oprogs_old;
    int                 clan;
    flag64_t            gender;
    MPTRIG *            oprogs;
    long                oprog_flags;
    int                 riddle;
    int                 size;
    ext_flag_t          progtypes; //for events programms

};

/*
 * One object.
 */
struct obj_data
{
    OBJ_DATA *          next;
    OBJ_DATA *          next_content;
    OBJ_DATA *          contains;
    OBJ_DATA *          in_obj;
    OBJ_DATA *          on;
    CHAR_DATA *         carried_by;
    ED_DATA *           ed;
    AFFECT_DATA *       affected;
    OBJ_INDEX_DATA *    pIndexData;
    ROOM_INDEX_DATA *   in_room;
    const char *        name;
    mlstring *          short_descr;
    mlstring *          description;
    flag64_t            extra_flags;
    flag32_t            wear_flags;
    flag32_t            wear_loc;
    int                 weight;
    uint                cost;
    int                 level;
    int                 condition;
    const char *        material;
    int                 timer;
    int                 value   [5];
    int                 progtypes;
    const char *        owner;
    altar_t *           altar;
    bool                extracted;
    int                 water_float;
    CHAR_DATA *         oprog_target;
    sh_int              oprog_delay;
    int                 id;

    EVENT     *         events;
    bool                deleted;

    KEY_DATA  *         keys;
    int                 size;
};

/*
 * Exit data.
 */
struct exit_data
{
    vo_t        to_room;
    flag32_t    exit_info;
    int     key;
    const char *    keyword;
    mlstring *  description;
    EXIT_DATA * next;       /* OLC */
    flag32_t     rs_flags;   /* OLC */
    int     orig_door;  /* OLC */
    int     size;
};

/*
 * Reset commands:
 *   '*': comment
 *   'M': read a mobile
 *   'O': read an object
 *   'P': put object in object
 *   'G': give object to mobile
 *   'E': equip object to mobile
 *   'D': set state of door
 *   'R': randomize room exits
 *   'S': stop (end of list)
 */


// End KeyRing section

/*
 * Area-reset definition.
 */
struct reset_data
{
    RESET_DATA *    next;
    char        command;
    int     arg1;
    int     arg2;
    int     arg3;
    int     arg4;
};

/*
 * Area definition.
 */

#define MAX_GUARD_COUNT    5
#define MAX_ALTAR_COUNT    11

struct area_data
{
    AREA_DATA *                next;
    RESET_DATA *               reset_first;
    RESET_DATA *               reset_last;
    HELP_DATA *                help_first;
    HELP_DATA *                help_last;
    const char *               file_name;
    const char *               name;
    mlstring *                 mlname; // mlstring to show in commands: where, areas, quest etc
    const char *               credits;
    int                        age;
    int                        nplayer;
    int                        min_level;
    int                        max_level;
    int                        min_vnum;
    int                        max_vnum;
    bool                       empty;
    int                        clan;
    const char *               builders;   /* OLC */ /* Listing of */
    int                        vnum;       /* OLC */ /* Area vnum  */
    flag64_t                   flags;      /* OLC */
    int                        security;   /* OLC */ /* Value 1-9  */
    uint                       count;
    mlstring *                 resetmsg;
    double                     version;
    int                        explorable_rooms;
    flag64_t                   climat_type;
    struct weather_data_area   weather;

    // area-control
    int                        area_rating_modifier;
    int                        max_guard_count; // total guards in area
    bool                       conq_enabled;
    int                        guard_vnums [MAX_GUARD_COUNT];
    int                        guard_room_vnums[MAX_GUARD_COUNT];
    clan_t *                   clan_owner;
    clan_t *                   prev_clan_owner;
    int                        guards_left;
    int                        curr_attack_time;
    int                        curr_defence_time;
    int                        prev_lock_time;
    int                        areaguard_rank; // standard, veteran or elite areaguard
    int                        time_owned;
    int                        explore_required;
    CHAR_DATA                * areaguards[MAX_GUARD_COUNT];
    CHAR_DATA                * priests   [MAX_ALTAR_COUNT];
    OBJ_DATA                 * altars    [MAX_ALTAR_COUNT];
    int                        defence_attempts;

    // planet and coordinates
    flag64_t                   planet;
    int                        x_coord;
    int                        y_coord;
    int                        z_coord;

    // geo parameters
    double                     breadth;
    double                     longitude;
    int                        timezone;

    int                        sunrise;
    int                        sunset;

    EVENT     *                events;

};

struct room_history_data
{
    const char *name;
    int went;
    ROOM_HISTORY_DATA *next;
    ROOM_HISTORY_DATA *prev;
};

/*
 * Room type.
 */
struct room_index_data
{
    ROOM_INDEX_DATA *   next;
    ROOM_INDEX_DATA *   aff_next;
    CHAR_DATA *         people;
    OBJ_DATA *          contents;
    ED_DATA *           ed;
    AREA_DATA *         area;
    EXIT_DATA *         exit    [6];
    RESET_DATA *        reset_first;    /* OLC */
    RESET_DATA *        reset_last;     /* OLC */
    mlstring *          name;
    mlstring *          description;
    const char *        owner;
    int                 clan;
    int                 vnum;
    flag64_t            room_flags;
    int                 light;
    flag64_t            sector_type;
    int                 heal_rate;
    int                 mana_rate;
    ROOM_HISTORY_DATA * history;
    AFFECT_DATA *       affected;
    int                 affected_by;
    int                 space;
    MPTRIG *            rprogs;        /* Room olc */
    CHAR_DATA *         rprog_target;
    long                rprog_flags;
    sh_int              rprog_delay;

    ext_flag_t          progtypes;
    EVENT     *         events;
};

/*
 * MOBprog definitions
 */
#define TRIG_ACT    (A)
#define TRIG_BRIBE  (B)
#define TRIG_DEATH  (C)
#define TRIG_ENTRY  (D)
#define TRIG_FIGHT  (E)
#define TRIG_GIVE   (F)
#define TRIG_GREET  (G)
#define TRIG_GRALL  (H)
#define TRIG_KILL   (I)
#define TRIG_HPCNT  (J)
#define TRIG_RANDOM (K)
#define TRIG_SPEECH (L)
#define TRIG_EXIT   (M)
#define TRIG_EXALL  (N)
#define TRIG_DELAY  (O)
#define TRIG_SURR   (P)
#define TRIG_START  (Q)
#define TRIG_GET    (R)
#define TRIG_DROP   (S)
#define TRIG_SIT    (T)

/*
 * Prog types
 */
#define PRG_MPROG       0
#define PRG_OPROG       1
#define PRG_RPROG       2

/* trigger flags */
#define TRIG_CASEDEP    (A)
#define TRIG_REGEXP (B)

struct mptrig
{
    int             type;
    const char *    phrase;
    flag32_t        flags;
    int             vnum;       // mob prog code vnum
    void *          extra;
    MPTRIG *        next;
};

struct mpcode
{
    int             vnum;
    const char *    code;
    MPCODE *        next;
};

/*
 * Types of attacks.
 * Must be non-overlapping with spell/skill types,
 * but may be arbitrary beyond that.
 */
#define TYPE_UNDEFINED           -1
#define TYPE_HIT             1000
#define TYPE_HUNGER          999

/*
 * Skill types (skill, spell, miracle, power, song, ...)
 */
#define TYPE_SKILL          0
#define TYPE_SPELL          1
#define TYPE_MIRACLE        2
#define TYPE_POWER          3
#define TYPE_SONG           4
#define TYPE_PROGRAM        5
#define TYPE_AUTO           6
#define TYPE_LANGUAGE       7
#define TYPE_ABILITY        8
#define TYPE_TATTOO         9
#define TYPE_RITUAL         10

/*
 *  Target types.
 */
#define TAR_IGNORE              0
#define TAR_CHAR_OFFENSIVE      1
#define TAR_CHAR_DEFENSIVE      2
#define TAR_CHAR_SELF           3
#define TAR_OBJ_INV             4
#define TAR_OBJ_CHAR_DEF        5
#define TAR_OBJ_CHAR_OFF        6

#define TARGET_CHAR         0
#define TARGET_OBJ          1
#define TARGET_ROOM         2
#define TARGET_NONE         3

/*
 * Agent net defines
 */
#define ANET_KILLED         0
#define ANET_ATTACK         1
#define ANET_WANTED_FOUND       2
#define ANET_SET_WANTED         3
#define ANET_REMOVE_WANTED      4
#define ANET_ARREST         5
#define ANET_CONDEMN            6
#define ANET_FREE           7

/*
 * Damage defines
 */
#define DAM_NONE            0
#define DAM_SCRATCH         2
#define DAM_GRAZE           4
#define DAM_HIT             6
#define DAM_INJURE          8
#define DAM_WOUND           10
#define DAM_MAUL            12
#define DAM_DECIMATE            14
#define DAM_DEVASTATE           16
#define DAM_MAIM            18
#define DAM_MUTILATE            20
#define DAM_DISEMBOWEL          22
#define DAM_DISMEMBER           24
#define DAM_MASSACRE            26
#define DAM_MANGLE          28
#define DAM_DEMOLISH            30
#define DAM_DEVASTATE_T         32
#define DAM_OBLITERATE          34
#define DAM_ATOMIZE         36
#define DAM_ANNIHILATE          38
#define DAM_ERADICATE           40
#define DAM_ELECTRONIZE         42
#define DAM_SKELETONIZE         44
#define DAM_NUKE            46
#define DAM_TERMINATE           48
#define DAM_TEAR_UP         50
#define DAM_POWER_HIT           52
#define DAM_UNSPEAKABLE         54

#define RUS_DAMAGE          56
#define VS_DAMAGE           0
#define VP_DAMAGE           1
/*
 * Utility macros.
 */
#define IS_WATER(var)   (((var)->sector_type == SECT_WATER_SWIM) || \
                 ((var)->sector_type == SECT_WATER_NOSWIM))
#define PERCENT(cur, max)   (max==0?0:((cur)*100)/(max))
#define CHECK_POS(a, b, c, d)                       \
        {                           \
            (a) = (b);                  \
            if ((a) < 0)                    \
                bug("CHECK_POS : " c " < 0 vnum %d", d);    \
        }

/*
 * Character macros.
 */
#define IS_NPC(ch)          (IS_SET((ch)->plr_flags, ACT_NPC))
#define IS_IMMORTAL(ch)     (!IS_NPC(ch) && (ch)->level >= LEVEL_IMMORTAL)
#define IS_HERO(ch)         (!IS_NPC(ch) && (ch)->level >= LEVEL_HERO)

// here u are, my beloved sit-on-kewl-level-and-do-everything!
// bonuses to slowly progressing newbies! ;)  ! /Aser.
#define IS_NEWBIE(ch)   (ch->pcdata && ch->pcdata->this_level_played < TFN)

#define IS_NOT_NEWBIE(ch) !IS_NEWBIE(ch)

#define IS_TRUSTED(ch, lev) ((((IS_NPC(ch) ?                  \
                    UMIN((ch)->level, LEVEL_HERO - 1) : \
                    (ch)->level) >= (lev)) ))
#define IS_AFFECTED(ch, bit)    (IS_SET((ch)->affected_by, (bit)))
#define IS_MARRYED(ch)  (!IS_NPC(ch) && ((ch)->pcdata->marryed!=NULL) && (ch)->pcdata->marryed[0]!='\0')

#define IS_PK(ch, vt)       (!IS_NPC((ch)) & !IS_NPC((vt)))

#define ORG_RACE(ch)        (IS_NPC(ch) ? ch->pIndexData->race : ch->pcdata->race)
#define IS_CYBORG(ch)       (IS_SET((ch)->form, FORM_CYBORG))
#define IS_MECH(ch)         (IS_SET((ch)->form, FORM_MECH))
#define IS_SAMURAI(ch)      (!IS_NPC(ch) && ch->class == CLASS_SAMURAI)
#define IS_UNDEAD(ch)       (IS_SET((ch)->form, FORM_UNDEAD) || \
                            (IS_NPC((ch)) && IS_SET(ch->pIndexData->act, ACT_UNDEAD)))
#define CAN_HEAL(ch, victim) (((ch) == (victim)) ||(IS_UNDEAD((victim)) ? \
                ((ch)->religion == RELIGION_ASTERN) :  TRUE ))
#if defined(WIN32)
void SET_ORG_RACE(CHAR_DATA *ch, int race);
#else
#   define SET_ORG_RACE(victim, race)   ORG_RACE(victim) = race
#endif

#define GET_AGE(ch)     ((int) (17 + ((ch)->played \
                    + current_time - (ch)->logon)/72000))

#define IS_GOOD(ch)     (ch->alignment >= 350)
#define IS_EVIL(ch)     (ch->alignment <= -350)
#define IS_NEUTRAL(ch)      (!IS_GOOD(ch) && !IS_EVIL(ch))

#define RALIGN(ch)  (IS_GOOD(ch) ? RA_GOOD :    \
             IS_EVIL(ch) ? RA_EVIL :    \
                       RA_NEUTRAL)
#define NALIGN(ch)  (IS_GOOD(ch) ? ANUM_GOOD :  \
             IS_EVIL(ch) ? ANUM_EVIL :  \
                       ANUM_NEUTRAL)

#define IS_AWAKE(ch)        (ch->position > POS_SLEEPING)
#define GET_AC(ch,type)     ((ch)->armor[type]              \
            + (IS_AWAKE(ch)             \
            ? dex_app[get_curr_stat(ch,STAT_DEX)].defensive : 0))
#define GET_HITROLL(ch) \
        ((ch)->hitroll+str_app[get_curr_stat(ch,STAT_STR)].tohit)
#define GET_DAMROLL(ch) \
        ((ch)->damroll+str_app[get_curr_stat(ch,STAT_STR)].todam)

#define IS_OUTSIDE(ch)  (!IS_SET((ch)->in_room->room_flags, ROOM_INDOORS))

#define WAIT_STATE(ch, npulse)  ((ch)->wait = IS_IMMORTAL(ch) ? \
                 1 : UMAX((ch)->wait, (npulse)))
#define RESET_WAIT_STATE(ch)    ((ch)->wait = 1)
#define DAZE_STATE(ch, npulse)  ((ch)->daze = UMAX((ch)->daze, (npulse)))
#define get_carry_weight(ch)    ((ch)->carry_weight + (ch)->silver*SILVER_WEIGHT +  \
                              (ch)->gold * GOLD_WEIGHT)
#define HAS_TRIGGER_MOB(ch,trig)    (IS_SET((ch)->pIndexData->mptrig_types,(trig)))
#define HAS_TRIGGER_OBJ(obj,trig)   (IS_SET((obj)->pIndexData->oprog_flags,(trig)))
#define HAS_TRIGGER_ROOM(room,trig) (IS_SET((room)->rprog_flags,(trig)))

#define IS_SWITCHED( ch )       (ch->desc && ch->desc->original)
#define IS_BUILDER(ch, Area)    (!IS_NPC(ch) && !IS_SWITCHED(ch) && \
                (ch->pcdata->security >= Area->security \
                || is_name_raw(ch->name, Area->builders, str_cmp)))

#define IS_DEMON(ch)        (IS_SET((ch)->form, FORM_DEMON))

/*
 * room macros
 */

#define IS_ROOM_AFFECTED(room, sn)  (IS_SET((room)->affected_by, (sn)))
#define IS_RAFFECTED(room, sn)  (IS_SET((room)->affected_by, (sn)))

#define MOUNTED(ch) ((!IS_NPC(ch) && ch->mount && ch->riding) ? \
                ch->mount : NULL)
#define RIDDEN(ch)  ((IS_NPC(ch) && ch->mount && ch->riding) ? \
                ch->mount : NULL)
#define IS_DRUNK(ch)    (IS_NPC(ch)  ? \
                  FALSE : ch->pcdata->condition[COND_DRUNK] > 10)

#define IS_GOLEM(ch)        (IS_NPC(ch) &&\
                (ch->pIndexData->vnum==MOB_VNUM_LESSER_GOLEM \
                 || ch->pIndexData->vnum==MOB_VNUM_STONE_GOLEM \
                 || ch->pIndexData->vnum==MOB_VNUM_IRON_GOLEM \
                 || ch->pIndexData->vnum==MOB_VNUM_ADAMANTITE_GOLEM \
                 || ch->pIndexData->vnum==MOB_VNUM_DIAMOND_GOLEM))
#define JUST_KILLED(ch) ((ch) == NULL || (ch)->last_death_time >= current_time)

/*
 * Object macros.
 */

#define CAN_WEAR(obj, part)     (IS_SET((obj)->wear_flags,  (part)))
#define IS_OBJ_STAT(obj, stat)  (IS_SET((obj)->extra_flags, (stat)))
#define IS_WEAPON_STAT(obj,stat)(IS_SET((obj)->value[4],(stat)))
#define WEIGHT_MULT(obj)        ((obj)->pIndexData->item_type == ITEM_CONTAINER ? \
    (obj)->value[4] : 100)

#define FREE_HAND1(ch) (get_eq_char(ch, WEAR_WIELD) == NULL)
#define FREE_HAND2(ch) (get_eq_char(ch,WEAR_SECOND_WIELD) == NULL && \
      get_eq_char(ch, WEAR_SHIELD) == NULL && get_eq_char(ch, WEAR_HOLD) == NULL)
/*
 * Description macros.
 */
/* new defines */
#define MAX_CHARM(ch)   UMAX(1, get_curr_stat(ch,STAT_INT) / 24 + \
                                        ch->level / 30 - 1)

/*
 * Global constants.
 */
extern  const   struct str_app_type str_app     [26];
extern  const   struct int_app_type int_app     [26];
extern  const   struct wis_app_type wis_app     [26];
extern  const   struct dex_app_type dex_app     [26];
extern  const   struct con_app_type con_app     [26];

extern  const   struct wiznet_type  wiznet_table    [];
extern  const   struct attack_type  attack_table    [];
extern  const   struct spec_type    spec_table  [];
//extern  const   struct liq_type     liq_table   [];

/*
 * Global variables.
 */
extern      SHOP_DATA         * shop_first;

extern      CHAR_DATA         * char_list;
extern      DESCRIPTOR_DATA   * descriptor_list;
extern      OBJ_DATA          * object_list;

extern      MPCODE            *  mpcode_list;
extern      MPCODE            *  rpcode_list;
extern      MPCODE            *  opcode_list;

extern      ROOM_INDEX_DATA   * top_affected_room;

extern      char            bug_buf     [];
extern      time_t          current_time;
extern      bool            fLogAll;
extern      FILE *          fpReserve;
extern      KILL_DATA       kill_table  [];
extern      char            log_buf     [];
extern      TIME_INFO_DATA  time_info;
extern      WEATHER_DATA    weather_info;
extern      int             reboot_counter;

extern      bool            MOBtrigger;

extern      CONNECTIONS_CACHE_ITEM* connectionsCache;

extern  CardTable* pct;
extern  CardHand* pch;
extern  CardDeck* pcd;


// birthday/holidays staff
const char * bdmsg[10];
int          bdflags;

/*
 * The crypt(3) function is not available on some operating systems.
 * In particular, the U.S. Government prohibits its export from the
 * United States to foreign countries.
 * Turn on NOCRYPT to keep passwords in plain text.
 */
#if defined(NOCRYPT)
//#define crypt(s1, s2)   (s1)
#endif

/*
 * Our function prototypes.
 * One big lump ... this is every function in Merc.
 */

void    handle_death(CHAR_DATA *ch, CHAR_DATA *victim);

/* str.c */
char *str_crypt(const char *s);

/* act_hera.c */
/* enter.c */
ROOM_INDEX_DATA  *get_random_room   (CHAR_DATA *ch);
/* hunt.c */
void hunt_victim(CHAR_DATA *ch);
int find_path(int in_room_vnum, int out_room_vnum, CHAR_DATA *ch,
           int depth, int in_zone);

/* effect.c */
void    sound_effect    (void *vo, int level, int dam, int target);
void    acid_effect (void *vo, int level, int dam, int target);
void    cold_effect (void *vo, int level, int dam, int target);
void    fire_effect (void *vo, int level, int dam, int target);
void    poison_effect   (void *vo, int level, int dam, int target);
void    shock_effect    (void *vo, int level, int dam, int target);
void    sand_effect (void *vo, int level, int dam, int target);
void    scream_effect   (void *vo, int level, int dam, int target);

/* gquest.c */
CHAR_DATA *     gq_findchar(const char *name);

/* handler.c */
AFFECT_DATA *affect_find (AFFECT_DATA *paf, int sn);
int affect_level(CHAR_DATA *ch, int sn);
void    affect_check    (CHAR_DATA *ch, int where, flag64_t vector);
int count_users (OBJ_DATA *obj);
int count_used_space(ROOM_INDEX_DATA *room);
void    deduct_cost (CHAR_DATA *ch, uint cost);
void    affect_enchant  (OBJ_DATA *obj);
void resists_modify     (int *dam, int res, bool fInvert);
bool    is_immune       (CHAR_DATA *ch, int dam_type);
int     check_immune    (CHAR_DATA *ch, int dam_type);

int get_age     (CHAR_DATA *ch);
void    reset_char  (CHAR_DATA *ch);
int get_curr_stat   (CHAR_DATA *ch, int stat);
int get_max_train   (CHAR_DATA *ch, int stat);
int class_can_wear  (CHAR_DATA *ch, int location);
int     is_class_mage   (CHAR_DATA *ch);
int     is_class_warrior(CHAR_DATA *ch);
int     can_carry_n     (CHAR_DATA *ch);
int can_carry_w (CHAR_DATA *ch);

bool    is_name     (const char *str, const char *namelist);
bool    is_name_rus (CHAR_DATA * ch, const char * name);
bool    is_name_raw (const char *str, const char *namelist,
             int (*cmpfun)(const char*, const char*));
void    name_add    (CHAR_DATA *ch, const char *name,
             const char *editor_name, const char **namelist);
void    name_delete (CHAR_DATA *ch, const char *name,
             const char *editor_name, const char **namelist);
void    name_toggle (CHAR_DATA *ch, const char *name,
             const char *editor_name, const char **namelist);

void    affect_to_char  (CHAR_DATA *ch, AFFECT_DATA *paf);
void    affect_to_obj   (OBJ_DATA *obj, AFFECT_DATA *paf);
void    affect_remove   (CHAR_DATA *ch, AFFECT_DATA *paf);
void    affect_remove_obj (OBJ_DATA *obj, AFFECT_DATA *paf);
void    affect_strip    (CHAR_DATA *ch, int sn);
void    affect_bit_strip(CHAR_DATA *ch, int where, flag64_t bits);
bool    is_affected (CHAR_DATA *ch, int sn);
bool    is_bit_affected (CHAR_DATA *ch, int where, flag64_t bits);
int has_obj_affect  (CHAR_DATA *ch, int vector);
void    affect_to_room  (ROOM_INDEX_DATA *room, AFFECT_DATA *paf);
void    affect_remove_room  (ROOM_INDEX_DATA *room, AFFECT_DATA *paf);
void    affect_strip_room   (ROOM_INDEX_DATA *ch, int sn);
bool    is_affected_room    (ROOM_INDEX_DATA *ch, int sn);
void    affect_join_room    (ROOM_INDEX_DATA *ch, AFFECT_DATA *paf);
void    affect_join (CHAR_DATA *ch, AFFECT_DATA *paf);
void    char_from_room  (CHAR_DATA *ch);
void    char_to_room    (CHAR_DATA *ch, ROOM_INDEX_DATA *pRoomIndex);
void    obj_to_char (OBJ_DATA *obj, CHAR_DATA *ch);
void    obj_from_char   (OBJ_DATA *obj);
int apply_ac    (OBJ_DATA *obj, int iWear, int type);
OBJ_DATA *  get_eq_char (CHAR_DATA *ch, int iWear);
OBJ_DATA *  equip_char  (CHAR_DATA *ch, OBJ_DATA *obj, int iWear);
void    unequip_char    (CHAR_DATA *ch, OBJ_DATA *obj);
int count_obj_list  (OBJ_INDEX_DATA *obj, OBJ_DATA *list);
void    obj_from_room   (OBJ_DATA *obj);
void    obj_to_room (OBJ_DATA *obj, ROOM_INDEX_DATA *pRoomIndex);
void    obj_to_obj  (OBJ_DATA *obj, OBJ_DATA *obj_to);
void    obj_from_obj    (OBJ_DATA *obj);

/* extract flags */
#define X_F_NOCOUNT     (A) /* do not count */
#define X_F_NORECURSE   (B) /* do not extract contained in objs */

#define extract_obj(obj)          extract_obj_raw(obj, 0)
#define extract_obj_nocount(obj)  extract_obj_raw(obj, X_F_NOCOUNT)

void    extract_obj_raw           (OBJ_DATA *obj, int flags);
void    extract_char              (CHAR_DATA *ch, bool fPull);
void    extract_char_nocount      (CHAR_DATA *ch, bool fPull);
void    extract_char_org          (CHAR_DATA *ch, bool fPull, bool Count);

OBJ_DATA *  get_obj_type          (OBJ_INDEX_DATA *pObjIndexData);
OBJ_DATA *  create_money          (int gold, int silver);


int check_exit(const char *arg);
int opposite_door(int door);

int     get_obj_number      (OBJ_DATA *obj);
int     get_obj_realnumber  (OBJ_DATA *obj);
int     get_obj_weight      (OBJ_DATA *obj);
int     get_true_weight     (OBJ_DATA *obj);
bool    room_is_dark        (CHAR_DATA *ch);
bool    room_dark           (ROOM_INDEX_DATA *pRoomIndex);
int     isn_dark_safe       (CHAR_DATA *ch);
bool    is_room_owner       (CHAR_DATA *ch, ROOM_INDEX_DATA *room);
bool    room_is_private     (ROOM_INDEX_DATA *pRoomIndex);
bool    can_see             (CHAR_DATA *ch, CHAR_DATA *victim);
bool    can_see_obj         (CHAR_DATA *ch, OBJ_DATA *obj);
bool    can_see_room        (CHAR_DATA *ch, ROOM_INDEX_DATA *pRoomIndex);
bool    can_drop_obj        (CHAR_DATA *ch, OBJ_DATA *obj);
void    room_record         (const char *name, ROOM_INDEX_DATA *room,int door);
bool    is_safe_traproom    (int level, CHAR_DATA *victim);
bool    is_safe_rspell      (int level, CHAR_DATA *victim);
bool    is_safe_rspell_nom  (int level, CHAR_DATA *victim);
int     count_charmed       (CHAR_DATA *ch);
void    add_mind            (CHAR_DATA *ch, const char *str);
void    remove_mind         (CHAR_DATA *ch, const char *str);
void    back_home           (CHAR_DATA *ch);
void    path_to_track       (CHAR_DATA *ch, CHAR_DATA *victim, int door);
bool    in_PK               (CHAR_DATA *ch, CHAR_DATA *victim);
bool    in_PK_level         (int level, CHAR_DATA* victim);
bool    can_gate            (CHAR_DATA *ch, CHAR_DATA *victim);
bool    can_gate_room       (CHAR_DATA *ch, ROOM_INDEX_DATA *room);

/* format_obj_affects flags */
#define FOA_F_NODURATION    (A) /* do not show duration     */
#define FOA_F_NOAFFECTS     (B) /* do not show bit affects  */

void format_obj(BUFFER *output, OBJ_DATA *obj, bool russpells);
void format_obj_affects(BUFFER *output, AFFECT_DATA *paf, int flags);

int get_wear_level(CHAR_DATA *ch, OBJ_DATA *obj);

bool    saves_spell (int level, CHAR_DATA *victim, int dam_type);
bool    check_dispel    (int dis_level, CHAR_DATA *victim, int sn);
void    dispel_message  (CHAR_DATA *victim, int sn, bool is_dispel);
void    obj_cast_spell  (int sn, int level, CHAR_DATA *ch, CHAR_DATA *victim,
             OBJ_DATA *obj);
bool    saves_dispel    (int dis_level, int spell_level, int duration);

bool remove_obj (CHAR_DATA * ch, int iWear, bool fReplace);
void wear_obj   (CHAR_DATA * ch, OBJ_DATA * obj, bool fReplace);

bool    check_blind (CHAR_DATA *ch);
bool    check_blind_raw (CHAR_DATA *ch);

void    show_affects(CHAR_DATA *ch, BUFFER *output);


/* interp.c */
DECLARE_DO_FUN(interpret);
void    interpret_raw   (CHAR_DATA *ch, const char *argument, bool is_order);
bool    is_number   (const char *argument);
uint    number_argument (const char *argument, char *arg, size_t len);
uint    mult_argument   (const char *argument, char *arg, size_t len);
const char *    one_argument    (const char *argument, char *arg_first, size_t len);
const char *    first_arg   (const char *argument, char *arg_first,
                 size_t len, bool fCase);
#define PERS(ch, looker) PERS2(ch, looker, 0)
const char* PERS2(CHAR_DATA *ch, CHAR_DATA *looker, flag32_t flags);

/* save.c */
void    save_char_obj   (CHAR_DATA *ch, bool reboot, bool is_quit);
void    load_char_obj   (DESCRIPTOR_DATA *d, const char *name, bool check);
CHAR_DATA * char_load_special   (const char *name);
void    char_nuke       (CHAR_DATA *ch);

/* special.c */
SPEC_FUN *  spec_lookup (const char *name);
char *  spec_name   (SPEC_FUN *function);

void new_reset(ROOM_INDEX_DATA *pRoom, RESET_DATA *pReset);

RESET_DATA  *new_reset_data     (void);
void        free_reset_data     (RESET_DATA *pReset);

AREA_DATA   *new_area       (void);
AREA_DATA * area_lookup     (int vnum);
AREA_DATA * area_vnum_lookup    (int vnum);
void        free_area       (AREA_DATA *pArea);

EXIT_DATA   *new_exit       (void);
void         free_exit       (EXIT_DATA *pExit);
ROOM_INDEX_DATA *new_room_index     (void);
void        free_room_index     (ROOM_INDEX_DATA *pRoom);
AFFECT_DATA *aff_new        (void);
void        aff_free        (AFFECT_DATA* pAf);
SHOP_DATA   *new_shop       (void);
void        free_shop       (SHOP_DATA *pShop);
OBJ_INDEX_DATA  *new_obj_index      (void);
void        free_obj_index      (OBJ_INDEX_DATA *pObj);
MOB_INDEX_DATA  *new_mob_index      (void);
void        free_mob_index      (MOB_INDEX_DATA *pMob);
//void        show_liqlist        (CHAR_DATA *ch);
void        show_damlist        (CHAR_DATA *ch);

MPTRIG *    mptrig_new      (int type, const char *phrase, int vnum);
void        mptrig_add      (MOB_INDEX_DATA *mob, MPTRIG *mptrig);
void        mptrig_fix      (MOB_INDEX_DATA *mob);
void        mptrig_free     (MPTRIG *mptrig);

void        optrig_add      (OBJ_INDEX_DATA *obj, MPTRIG *optrig);
MPTRIG *    optrig_new      (int type, const char *phrase, int vnum);
void        optrig_fix      (OBJ_INDEX_DATA *obj);
void        optrig_free     (MPTRIG *op);


void        rptrig_add      (ROOM_INDEX_DATA *room, MPTRIG *rptrig);
MPTRIG *    rptrig_new      (int type, const char *phrase, int vnum);
void        rptrig_fix      (ROOM_INDEX_DATA *room);
void        rptrig_free     (MPTRIG *rp);

MPCODE *    mpcode_new      (void);
void        mpcode_add      (MPCODE *mpcode);
MPCODE *    mpcode_lookup   (int vnum);
void        mpcode_free     (MPCODE *mpcode);

MPCODE *    opcode_new      (void);
void        opcode_add      (MPCODE *opcode);
MPCODE *    opcode_lookup   (int vnum);
void        opcode_free     (MPCODE *opcode);

MPCODE *    rpcode_new      (void);
void        rpcode_add      (MPCODE *rpcode);
MPCODE *    rpcode_lookup   (int vnum);
void        rpcode_free     (MPCODE *rpcode);

/* extra descr recycling */
ED_DATA *ed_new     (void);
ED_DATA *ed_new2    (const ED_DATA *ed, const char* name);
ED_DATA *ed_dup     (const ED_DATA *ed);
void    ed_fread    (FILE *fp, ED_DATA **edp);
void    ed_fwrite   (FILE *fp, ED_DATA *ed);
void    ed_free     (ED_DATA *ed);

/* affect recycling */
AFFECT_DATA *   aff_new (void);
AFFECT_DATA *   aff_dup (const AFFECT_DATA *af);
void            aff_free(AFFECT_DATA *af);

/* object recycling */
OBJ_DATA *  new_obj (void);
void        free_obj(OBJ_DATA *obj);

/* character recyling */
CHAR_DATA * new_char    (void);
void        free_char   (CHAR_DATA *ch);
PC_DATA *   new_pcdata  (void);
void        free_pcdata (PC_DATA *pcdata);
CHAR_EXPLORED_DATA * new_char_explored_data(void);
void free_char_explored_data(CHAR_EXPLORED_DATA *explored_data);

/* mob id and memory procedures */
long    get_pc_id   (void);
long    get_mob_id  (void);
long    get_obj_id  (void);

HELP_DATA * help_new    (void);
void        help_add    (AREA_DATA*, HELP_DATA*);
HELP_DATA * help_lookup (int num, const char *keyword);
void        help_show   (CHAR_DATA *ch, BUFFER *output,
                 const char *keyword);
void        help_free   (HELP_DATA*);

void        boot_db     (void);
CHAR_DATA * create_mob  (MOB_INDEX_DATA *pMobIndex);
CHAR_DATA * create_named_mob(MOB_INDEX_DATA *pMobIndex, const char *name);
CHAR_DATA * create_mob_org(MOB_INDEX_DATA *pMobIndex, int flags);
void        clone_mob   (CHAR_DATA *parent, CHAR_DATA *clone);
OBJ_DATA *  create_obj  (OBJ_INDEX_DATA *pObjIndex, int level);
OBJ_DATA *  create_named_obj(OBJ_INDEX_DATA *pObjIndex, int level,
                 const char *name);
OBJ_DATA *  create_obj_nocount (OBJ_INDEX_DATA *pObjIndex, int level);
void        clone_obj   (OBJ_DATA *parent, OBJ_DATA *clone);
OBJ_DATA *  create_obj_rand(OBJ_INDEX_DATA *pObjIndex, int level);
void        clear_char  (CHAR_DATA *ch);
ED_DATA *   ed_lookup(const char *name, ED_DATA *ed);

MOB_INDEX_DATA *    get_mob_index   (int vnum);
OBJ_INDEX_DATA *    get_obj_index   (int vnum);
ROOM_INDEX_DATA *   get_room_index  (int vnum);

flag64_t  flag_convert    (char letter);
void *  alloc_perm  (int sMem);
int number_fuzzy    (int number);
int number_range    (int from, int to);
int number_percent  (void);
int number_door     (void);
int number_bits     (int width);
long    number_mm   (void);
int dice            (int number, int size);
int interpolate     (int level, int value_00, int value_32);
char *  capitalize  (const char *str);
void    append_file (CHAR_DATA *ch, const char *file, const char *str);
void    tail_chain  (void);
char *format_flags(flag64_t flags);

#define chance(num) (number_range(1, 100) <= num)

/*****************************************************************************
 *                                    OLC                                    *
 *****************************************************************************/

/*
 * Global Constants
 */
extern  char *  const  dir_name    [];
extern  const   int    rev_dir     [];
extern  const   struct spec_type    spec_table  [];
extern  char           DEFAULT_PROMPT  [];

/* act_comm.c */
void        check_sex       (CHAR_DATA *ch);
void        add_follower    (CHAR_DATA *ch, CHAR_DATA *master);
void        stop_follower   (CHAR_DATA *ch);
void        nuke_pets       (CHAR_DATA *ch);
void        die_follower    (CHAR_DATA *ch);

DECLARE_DO_FUN(do_afk);
DECLARE_DO_FUN(do_lang);
DECLARE_DO_FUN(do_music);
DECLARE_DO_FUN(do_gossip);
DECLARE_DO_FUN(do_ooc);
DECLARE_DO_FUN(do_herotalk);
DECLARE_DO_FUN(do_chat);
CHAR_DATA*  leader_lookup   (CHAR_DATA *ch);
void        do_tell_raw (CHAR_DATA *ch, CHAR_DATA *victim, const char *msg);
void        agent_net_printf(CHAR_DATA *ch, CHAR_DATA *victim, int);
#define is_same_group(ach, bch) (leader_lookup(ach) == leader_lookup(bch))

/* act_info.c */
void    set_title   (CHAR_DATA *ch, const char *title);
void    set_pretitle   (CHAR_DATA *ch, const char *pretitle);
char    *get_cond_alias (OBJ_DATA *obj);
void    do_who_raw  (CHAR_DATA *ch, CHAR_DATA *vch, BUFFER *output);
void    smash_tilde (char *s); // for IMC2-compatibility
const char *fix_short   (const char *short_descr);
const char *format_short(mlstring *mshort, const char *name, CHAR_DATA *looker, int act_flags);
const char *format_descr(mlstring *desc, CHAR_DATA *looker);
#define format_long(desc, looker) format_descr((desc), (looker))

/* act_move.h */
void move_char(CHAR_DATA *ch, int door, bool follow);
char *find_way(CHAR_DATA *ch, ROOM_INDEX_DATA *rstart, ROOM_INDEX_DATA *rend);
int guild_check(CHAR_DATA *ch, ROOM_INDEX_DATA *room);

/* act_obj.h */
bool can_loot       (CHAR_DATA *ch, OBJ_DATA *obj);
int can_get_obj     (CHAR_DATA * ch, OBJ_DATA * obj, bool message);
void get_obj        (CHAR_DATA *ch, OBJ_DATA *obj, OBJ_DATA *container, bool message);
int floating_time   (OBJ_DATA *obj);
bool may_float      (OBJ_DATA *obj);
void wear_obj       (CHAR_DATA *ch, OBJ_DATA *obj, bool fReplace);
void quaff_obj      (CHAR_DATA *ch, OBJ_DATA *obj);

#define cant_float(obj) !may_float(obj)


/* act_wiz.h */
#define wiznet(string, ch, arg, flag, flag_skip, min_level) \
        wiznet_printf(ch, arg, flag, flag_skip, min_level, string)
void wiznet_printf(CHAR_DATA *ch, const void *arg, long flag, long flag_skip,
           int min_level, char* format,...);
void reboot_muddy(void);
ROOM_INDEX_DATA *find_location(CHAR_DATA *ch, const char *argument);

/* olc_save.c */

void save_clan(CHAR_DATA *ch, clan_t *clan, bool message);
void init_clan();

/* Materials */
// Material flags by Aseroth:

#define MAT_ARMOR   (A)           /*    */
#define MAT_METAL   (B)           /*  */
#define MAT_FLOAT   (C)           //  
#define MAT_BURNS   (D)           //    (  ,     , )
#define MAT_MELTS   (E)           //  
#define MAT_FRAGILE (F)           //  
#define MAT_STONE   (G)           //  --  (  )

bool compressStart(DESCRIPTOR_DATA *desc, bool ver2);
bool compressEnd(DESCRIPTOR_DATA *desc);
bool processCompressed(DESCRIPTOR_DATA *desc);
bool writeCompressed(DESCRIPTOR_DATA *desc, char *txt, int length);

struct connectionsCacheItem
{
    const char* name;
    const char* password;

    const char* host;
    int ttl;
    bool ignore_item;

    CONNECTIONS_CACHE_ITEM* next;
};

CONNECTIONS_CACHE_ITEM* DeleteItemFromCache(CONNECTIONS_CACHE_ITEM* cache, CONNECTIONS_CACHE_ITEM* item);
CONNECTIONS_CACHE_ITEM* AddCharToCache(CONNECTIONS_CACHE_ITEM* cache, CHAR_DATA* ch);
int CheckCharsByHost(CONNECTIONS_CACHE_ITEM* cache, CHAR_DATA* ch);
int CheckCharsByPassword(CONNECTIONS_CACHE_ITEM* cache, CHAR_DATA* ch);

struct gc_struct
{
    bool enabled;

    int pulse_char_default;
    int pulse_char;
    bool char_enabled;

    int pulse_room_default;
    int pulse_room;
    bool room_enabled;
} gc;

#ifdef IRC

#define          ircbug(arg)                logprintf("*** IRCBUG *** %s", arg);
/*
 * IRC related structures and #defines
 * --Cronel
 */
/* Login modes for IRC and DCC descriptors */
typedef enum
{
  MODE_NONE, MODE_LOGIN, MODE_SLOGIN, MODE_DCC
} login_modes;

/* Nickserv substates */
typedef enum
{
  NICKSERV_NONE, NICKSERV_START, NICKSERV_UNREG, NICKSERV_UNREC, NICKSERV_REC
} nickserv_states;

/* Mud connetion modes to IRC */
typedef enum
{
  MODE_CLIENT, MODE_SERVER
} mud_con;

/* IRC nickname info */
struct nick_data
{
    char    *       nick;
    char    *       user;
    char    *       host;

    DESCRIPTOR_DATA *   desc;
    sh_int          login_mode;

    struct nick_data *  next;
    struct nick_data *  prev;

    sh_int          nickserv;
};

#define IS_TELNET_DESC(d)   ((d) && (d)->nick_data == NULL )
#define IS_IRC_DESC( d )    ((d) && (d)->nick_data != NULL && (d)->nick_data->login_mode != MODE_DCC )
#define IS_DCC_DESC( d )    ((d) && (d)->nick_data != NULL && (d)->nick_data->login_mode == MODE_DCC )
#define CAN_TELNET( ch )    ((ch) && !IS_NPC(ch) && (IS_IMMORTAL(ch) || NOT_AUTHED(ch) || IS_WAITING_FOR_AUTH(ch)) )

/* Struc for the IRC commands table */
struct irc_cmd
{
    char    *   cmd_name;
    char    *   cmd_letter;
    void        (*cmd_proc)(char *, char*);
};

/* Configuration data for mud IRC connection */
struct ircdata
{
    sh_int      mode;

    char    *   sserver;
    int         sport;
    char    *   spwd;

    char    *   cserver;
    int         cport;
    char    *   cpwd;

    sh_int      resp_timeout;
    bool        reconnect;

    char    *   mud_nick;
    char    *   mud_channel;

    char    *   mud_pseudo_host;
    char    *   mud_server;

    int         dcc_port;
    sh_int      dcc_timeout;

    char    *   mud_desc;
};

void write_to_channel( char *msg, bool use_privmsg );
void send_mirc_sound( CHAR_DATA *ch, char *sound_file );
#endif

/* TODO:    */
struct rwar_struct
{
    bool enabled;

    int  base_price;
    int  price_per_level;
} rwar;


int count_skill_percent (CHAR_DATA * ch);
int count_all_skill_percent (CHAR_DATA * ch);

// ---------------------------------------------------
// History stuff
// ---------------------------------------------------
typedef struct stat_data STAT_DATA;

struct stat_data
{
    // quests
    int quest_requested;
    int quest_completed;

    // global quests
    int gq_started;
    int gq_completed;

    // wars
    int wars_started;
    int wars_completed;
    int wars_timed_out;
    int wars_surrenders;
    // duels
    int duels_provoked;
    int duels_started;

    // kills
    int mobs_killed;
    int pc_killed_by_mobs;
    int PK_count;
    int PK_on_CR;

    // auc
    int auctionned_items;
    int auctionned_limits;

    // rulers' activity
    int arrested;
    int wanted_set;
    int criminals_killed;

    // crafting
    int crafted_items_forged;
    int crafted_by_no_pk;

    // relations
    int bribes;
    int donation;
    int aggressions;
    int good_spells;

    // gold
    int gold_made; // crafting
    int gold_quest_reward;
    int gold_gq_reward;
    int gold_stolen;
    int gold_war_reward; // duels are included

    // clan
    int rewards;

    // WQuests
    int wq_pers_started;
    int wq_pers_win;
    int wq_mult_started;
    int wq_mult_win;
};

//Muddy modes

#define      MUDDY_DODGE_NEW     (A)
#define      MUDDY_ONEHIT_NEW    (B)
#define      MUDDY_NEWBIES       (C)
#define      MUDDY_GAME_LOCK     (D)
#define      MUDDY_TEST_MODE     (E)
#define      MUDDY_STOCK_CONT    (F)  // switch: players can put containers into the stock
#define      MUDDY_RANDOM_SLEEP  (G)  // switch: strangle, bj, vtouch, sleep affects have random duration
#define      MUDDY_SCRIBE_NEW    (H)  // switch: scribeed spells are limited by level 100
#define      MUDDY_WARR_MOVES    (I)  // switch: warriors' skills comsume moves instead of mana
#define      MUDDY_QUEST_NEW     (J)  // switch: players can gain bp/exp/hp/mana as the reward for quests
#define      MUDDY_SPEC_PARTS    (K)  // switch: monster can leave "special parts" after death
#define      MUDDY_EVENTS        (L)  // enable|disable events update in world
#define      MUDDY_RACE_WEAR     (M)  // enable|disable race wear restrictions
#define      MUDDY_FORM_SHOW_NEW (N)  // switch: do not show biped/mammal/etc in check_is_found (argument.c)
#define      MUDDY_SECTOR_BONUS  (O)  // switch: apply sector bonus to chars

flag64_t     muddy_mode;

struct plane_data
{
    PLANE_DATA *next;
    char *name;
    int min_level;
    WEATHER_DATA weather;       /* FIX */
    TIME_INFO_DATA time;        /* FIX */
    EVENT *events;
};

const char * get_rus_name (CHAR_DATA * ch, int fnum);

#endif
