/* $Id: meteor.c,v 1.666 2004/09/20 10:49:51 shrike Exp $                            */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

 
#include <stdio.h>
#include <stdlib.h>

#include "merc.h"
#include "fight.h"

varr mareas  = {sizeof (marea_t), 4};

marea_t * marea_new ()
{
        marea_t * marea;

        marea                          = varr_enew (&mareas);
        marea->area_vnum               = 0;

        return marea ;
}

void marea_free(marea_t *marea)
{
    free(marea);
}

void load_meteor_area()
{
    AREA_DATA             * area;
    marea_t               * marea;
    extern AREA_DATA      * area_first;

    for (area = area_first; area; area = area->next)
    {
        if (!IS_SET(area->flags, AREA_UNDER_CONSTRUCTION) 
        && !IS_SET(area->flags, AREA_NOMETEOR)
        && area->vnum > 2)
        {
            marea = marea_new();
            marea->area_vnum = area->vnum;
        }
    }
}

varr meteors = {sizeof (meteor_t), 4};

meteor_t * meteor_new ()
{
        meteor_t * meteor;

        meteor                         = varr_enew (&meteors);
        meteor->objects.nsize          = sizeof (mobject_t);
        meteor->objects.nstep          = 4;
        meteor->name                   = str_empty;
        meteor->active                 = METEOR_FALSE;
        meteor->area_vnum              = -1;
        meteor->auto_start             = METEOR_FALSE;
        meteor->curr_tick              = -1;
        meteor->damage                 = 0;
        meteor->nopk_damage            = METEOR_FALSE;
        meteor->room_affect            = METEOR_FALSE;
        meteor->size                   = 1;
        meteor->wait_tick              = 10;

        return meteor ;
}

void meteor_free(meteor_t *meteor)
{
    free_string(meteor->name);
    varr_free(&meteor->objects);
    free(meteor);
}

int mrn_lookup (const char * name)
{
    int mrn;

    if (IS_NULLSTR(name))
                return -1;

        for (mrn = 0; mrn < meteors.nused; mrn++)
                if (!str_cmp(name, METEOR(mrn)->name))
                        return mrn;

        return -1;
}

/*
*      
*/
void meteor_update(meteor_number)
{
    meteor_t   * meteor;

    meteor = meteor_lookup(meteor_number);

    if (meteor == NULL)
        return;

    if (meteor->active == METEOR_TRUE)
    {
        if (meteor->area_vnum < 0 )
        {
            meteor->area_vnum = get_random_area();
        }

        switch (meteor->curr_tick)
        {
            case 0:
                meteor->curr_tick = 0 - meteor->wait_tick - 1 ;   //  -       -1
                meteor_damage(meteor_number);                     //  
                meteor_raffect(meteor_number);                    //    
                load_obj_from_meteor(meteor_number);              //  
                break;
            case -1:                                              //  -1 -   
                meteor->curr_tick = number_range(1,meteor->wait_tick)*number_range(1,4);             //     
                meteor->area_vnum = get_random_area();
                break;
            default:
                if (meteor->curr_tick > 0)
                    meteor->curr_tick--;
                else
                    meteor->curr_tick++;
                break;
        }
    }
}

/*
*       
*/
void meteors_update()
{
    int mrn;
    for (mrn = 0; mrn < meteors.nused; mrn++)
    {
        if (METEOR(mrn)->auto_start == METEOR_TRUE)
        {
            if (METEOR(mrn)->active == METEOR_FALSE)
                METEOR(mrn)->active = METEOR_TRUE;
        }

        if (METEOR(mrn)->active == METEOR_TRUE)
        {
            meteor_update(mrn);
        }
    }
}


/*
*   
*/
void meteor_damage(int meteor_number)
{
    meteor_t  * meteor;
    AREA_DATA * area;
    int damage;
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;

    meteor = meteor_lookup(meteor_number);
    if (meteor == NULL)
    {
        bug("Not such meteor", 0);
        return;
    }

    area = area_lookup(meteor->area_vnum);
    if (area == NULL)
    {
        log_printf("** BUG **: meteor_damage: area not found %d",1);
        return;
    }

//    .....    
    for (vch = char_list; vch != NULL; vch = vch_next)
    {        
        vch_next = vch->next;
        
        
        if (vch->in_room && (vch->in_room->area == area) && !IS_IMMORTAL(vch) && vch->level > 10 ) // TODO:  NO_PK
        {
            damage = vch->level*10 + meteor->size * meteor->damage;
            
            act("Splinters of a meteorite fly up upwards and get in you.", vch, NULL, NULL, TO_CHAR);
            act("Splinters of a meteorite fly up upwards and get in $n", vch, NULL, NULL, TO_ROOM);

            if (vch->hit - damage < 0)
                raw_kill(vch,vch);
            else
                vch->hit = vch->hit - damage;
        }
    }
    if (meteor->size > 1000)
        info(NULL, 10, "{r[{RINFO{r]{W Somewhere in area %s{W the {Rambigius{z meteorite %s has fallen.{x", area->name, meteor->name);
    else if (meteor->size > 500)
        info(NULL, 10, "{r[{RINFO{r]{W Somewhere in area %s{W the {Chuge{z meteorite %s has fallen.{x", area->name, meteor->name);
    else if (meteor->size > 100)
        info(NULL, 10, "{r[{RINFO{r]{W Somewhere in area %s{W the {Gsmall{z meteorite %s has fallen.{x", area->name, meteor->name);
    else 
        info(NULL, 10, "{r[{RINFO{r]{W Somewhere in area %s{W the mini meteorite %s has fallen.{x", area->name, meteor->name);
}

/* 
 *    
 */

void meteor_raffect(int meteor_number)
{
    meteor_t        *meteor;
    AREA_DATA       *area;
    ROOM_INDEX_DATA *room;
    int              vnum;
    AFFECT_DATA      af;
    int              sn;
    int              affect_level;
    int              affect_time;
    
    meteor = meteor_lookup(meteor_number);
    if (meteor == NULL)
    {
        bug("Not such meteor", 0);
        return;
    }

    if (meteor->room_affect == METEOR_FALSE)
         return;
         
    area = area_lookup(meteor->area_vnum);
    
    if (area == NULL)
    {
        log_printf("** BUG **: meteor_damage: area not found %d",1);
        return;
    }
    
    affect_time = number_range(1,20);    /* TODO: need right calculation of time and level for affects. */
    affect_level = number_range(1,100);
    
    sn = sn_lookup("fire wall");
    
    for (vnum = area->min_vnum; vnum <= area->max_vnum; vnum++)
    {
        if ((room = get_room_index(vnum)))
        {
             if (IS_SET(room->room_flags, ROOM_LAW) || IS_SET(room->room_flags, ROOM_PEACE) || is_affected_room(room, sn))
                  continue;
                               
             af.type      = sn;
             af.level     = affect_level;
             af.duration  = affect_time;
             af.location  = APPLY_NONE;
             af.modifier  = 0;
             af.bitvector = RAFF_FWALL;
             
             affect_to_room(room, &af);          
             
        }
    }
}


/*
*   
*/
void load_obj_from_meteor(int meteor_number)
{
    meteor_t * meteor;
    int i;
    int j;
    OBJ_DATA * obj;
    int room_vnum;
    
    meteor = meteor_lookup(meteor_number);

    if (meteor == NULL)
    {
        log_printf("** BUG **: load_obj_from_meteor: meteor %d = NULL", meteor_number);
        return;
    }

    if (meteor->area_vnum < 1)
    {
        log_printf("** BUG **: load_obj_from_meteor: meteor %d area vnum = -1", meteor_number);
        return;
    }
    

    for (i = 0; i < meteor->objects.nused; i++)         //      
    {
        mobject_t *mobject = varr_get(&meteor->objects, i);
        if (mobject == NULL)
        {
            log_printf("** BUG **: load_obj_from_meteor: meteor %d moject = NULL", meteor_number);
            continue;
        }

        for (j = 0 ; j < mobject->obj_count; j++)       //   -    
        {
            if (number_percent() < mobject->chanse )    // ...
            {
                room_vnum = get_random_room_in_area(meteor->area_vnum);  //    
                if (room_vnum == 0)
                {  
                    continue;
                }
                                                         
//                log_printf("** DEBUG**: load_obj_from_meteor:  %d in %d", mobject->obj_vnum, room_vnum); 
                obj = create_obj(get_obj_index(mobject->obj_vnum), 0); //  
                obj_to_room(obj, get_room_index(room_vnum));           //   
            }
        }
        
    }
}

/*
*  
*/
void do_meteor_stop(int meteor_id)
{
    meteor_t * meteor;
    
    meteor = meteor_lookup(meteor_id);
    if (meteor == NULL)
        return;
        
    meteor->active = METEOR_FALSE;
}

/*
*  
*/
void do_meteor_start(int meteor_id)
{
    meteor_t * meteor;

    meteor = meteor_lookup(meteor_id);
    if (meteor == NULL)
        return;

    meteor->curr_tick = number_range(meteor->wait_tick, (4 * meteor->wait_tick)); //  , 
    meteor->active = METEOR_TRUE;
}

int get_meteor_area()
{
    return 0;
}

const char * meteor_name(int mrn)
{
       meteor_t * meteor = meteor_lookup(mrn);

       if (meteor) return meteor->name;
       return "None";
}

/*
(c) Welesh -      
*/
int get_random_room_in_area (int area_vnum) 
{
    int random_vnum, i, try_count;
    ROOM_INDEX_DATA * room; 
    AREA_DATA *pArea; 

    pArea = area_lookup(area_vnum);

    if (!pArea)
        return 0;

    try_count = (pArea->max_vnum - pArea->min_vnum) * 10; // let it be
    for (i = 0; i < try_count; ++i)
    {
        random_vnum = number_range (pArea->min_vnum, pArea->max_vnum);
        if ((room = get_room_index(random_vnum)))
            return random_vnum;
    }
    return 0;
}

int get_random_area()
{
    int marea_num;
    marea_t * marea;

    marea_num = number_range(2, mareas.nused - 1);
    marea = marea_lookup(marea_num);
    return marea->area_vnum;
}

/*
*  .....
*/

void do_mtset (CHAR_DATA *ch, const char *argument)
{
     meteor_t * meteor;
     AREA_DATA * area;
     char arg1[MAX_INPUT_LENGTH];
     char arg2[MAX_INPUT_LENGTH];
     char arg3[MAX_INPUT_LENGTH];
      
     argument = one_argument(argument, arg1, sizeof(arg1));
     argument = one_argument(argument, arg2, sizeof(arg2));
     one_argument(argument, arg3, sizeof(arg3));

     if (!is_number(arg1))
     {
         char_printf(ch, "Must be specifed number of meteorit.\n");
         return;
     }

     meteor = meteor_lookup(atoi(arg1));
     
     if (meteor == NULL)
     {
         char_printf(ch, "Not such meteor %s.\n", arg1);
         return;
     }

     switch (arg2[0])
     {
         case 'a': case 'A':
             if (!str_cmp(arg2,"active"))
             {
                 if (meteor->active != METEOR_TRUE)
                 {
                     meteor->active = METEOR_TRUE;
                     char_printf(ch,"Meteor %s now active.\n", arg1);
                     return;
                 } else
                 {
                     meteor->active = METEOR_FALSE;
                     char_printf(ch,"Meteor %s now inactive.\n", arg1);
                     return;
                 }
             } else
             if (!str_cmp(arg2,"area"))
             {
                 if (!is_number(arg3))
                 {
                     char_printf(ch,"Need specify area vnum.\n");
                     return;
                 }

                 area = area_lookup(atoi(arg3));

                 if (area == NULL)
                 {
                     char_printf(ch,"Not such specify area %s.\n", arg3);
                     return;
                 }
                 
                 meteor->area_vnum = area->vnum;
                 char_printf(ch, "Current area for meteor %s: [%s] - %s.\n", arg1, arg3, fmt_color_str(area->name,30));
                 return;
             } 
             
             char_printf(ch,"Unknown parametr %s.\n", arg2);
             do_help(ch, "mtset");
             
             break;
         case 'c': case 'C':
             if (!str_cmp(arg2,"ctick"))
             {
                 if (!is_number(arg3))
                 {
                     char_printf(ch,"Need specify current tick number.\n");
                     return;
                 }

                 meteor->curr_tick = atoi(arg3);
                 char_printf(ch,"Current tick for meteor %s set as %d.\n", arg1, meteor->curr_tick);
                 return;
             }

             char_printf(ch,"Unknown parametr %s.\n", arg2);
             do_help(ch, "mtset");

             break;
         case 'd': case 'D':
             if (!str_cmp(arg2,"damage"))
             {
                 if (!is_number(arg3))
                 {
                     char_printf(ch,"Need specify damage.\n");
                     return;
                 }

                 if (atoi(arg3) < 1)
                 {
                     char_printf(ch,"Damage mus be greater 0.\n");
                     return;
                 }

                 meteor->damage = atoi(arg3);
                 char_printf(ch,"Current damage for meteor %s set as %d.\n", arg1, meteor->damage);
                 return;
             }
             
             char_printf(ch,"Unknown parametr %s.\n", arg2);
             do_help(ch, "mtset");
             break;
         case 'n': case 'N':
             if (!str_cmp(arg2,"nopk"))
             {
                 if (meteor->nopk_damage != METEOR_TRUE)
                 {
                     meteor->nopk_damage = METEOR_TRUE;
                     char_printf(ch,"Meteor %s now strike for NO_PK players.\n", arg1);
                     return;
                 } else
                 {
                     meteor->nopk_damage = METEOR_FALSE;
                     char_printf(ch,"Meteor %s now not strike for NO_PK players.\n", arg1);
                     return;
                 }
             }
             
             char_printf(ch,"Unknown parametr %s.\n", arg2);
             do_help(ch, "mtset");
             break;
         case 's': case 'S':
             if (!str_cmp(arg2,"size"))
             {
                 if (!is_number(arg3))
                 {
                     char_printf(ch,"Need specify size of meteor.\n");
                     return;
                 }

                 if (atoi(arg3) < 1)
                 {
                     char_printf(ch,"Size of meteor must be greater 0.\n");
                     return;
                 }

                 meteor->size = atoi(arg3);
                 char_printf(ch,"Current size for meteor %s set as %d.\n", arg1, meteor->size);
                 return;
             }

             char_printf(ch,"Unknown parametr %s.\n", arg2);
             do_help(ch, "mtset");

             break;
         case 'w': case 'W':
            if (!str_cmp(arg2,"wtick"))
            {
                if (!is_number(arg3))
                {
                    char_printf(ch,"Need specify wait tick number.\n");
                    return;
                }

                if (atoi(arg3) < 1)
                {
                    char_printf(ch,"Wait tick number must be greater 0.\n");
                    return;
                }

                meteor->wait_tick = atoi(arg3);
                char_printf(ch,"Current tick for meteor %s set as %d.\n", arg1, meteor->wait_tick);
                return;
            }

            char_printf(ch,"Unknown parametr %s.\n", arg2);
            do_help(ch, "mtset");

             break;
         default:
             do_help(ch, "mtset");
             return;
     } 
}

void do_mtshow (CHAR_DATA *ch, const char *argument)
{
//    meteor_t * meteor;
//    AREA_DATA * area;
//    char arg1[MAX_INPUT_LENGTH];
    int i;

//    one_argument(argument, arg1, sizeof(arg1));
/*
    if (!str_cmp(arg1,"brief")
    {
    } else
    if (!str_cmp(arg1,"active")
    {
    } else
*/

    for (i = 0; i < meteors.nused; i++)
        char_printf(ch, "[%d] %-20s {Y[Ac]:{W %s {x\n", i, METEOR(i)->name, flag_string(meteor_bool_flags, METEOR(i)->active));

}
