/* $Id: meteor.h,v 1.666 2004/09/20 10:49:51 shrike Exp $                            */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#ifndef _METEOR_H_
#define _METEOR_H_

#define METEOR_TRUE   0
#define METEOR_FALSE  1

typedef struct marea_t marea_t;

struct marea_t
{
     int area_vnum;
};

marea_t *       marea_new     (void);
void            marea_free    (marea_t*);

extern varr     mareas;

#define MAREA(marn)         ((marea_t*) VARR_GET(&mareas, marn))
#define marea_lookup(marn)  ((marea_t*) varr_get(&mareas, marn))

void load_meteor_area();

struct meteor_t
{
    const char * name;      //                             Name key
    int wait_tick;          // -                    Wait key
    int curr_tick;          //   -  0   :)               *
    int size;               //                               Size key                 *
    int area_vnum;          //                               *
    int damage;             //      - 1000 ?       Damage key               *
    flag64_t nopk_damage;   //  no pk                        Nopk key                 *
    flag64_t auto_start;    //                     Autostart key
    flag64_t active;        //   ......                             *
    flag64_t room_affect;   //          RoomAffect

    varr objects;           //   .....
};

struct mobject_t
{
    int obj_vnum;      //  
    int obj_count;     //   
    int chanse;        //     :)
};


meteor_t *      meteor_new    (void);
void            meteor_free   (meteor_t*);


extern varr meteors;


#define METEOR(mrn)        ((meteor_t*) VARR_GET(&meteors, mrn))
#define meteor_lookup(mrn) ((meteor_t*) varr_get(&meteors, mrn))

int get_meteor_area();
int mrn_lookup (const char * name);
const char * meteor_name(int mrn);
void meteor_damage(int meteor_number);
void meteor_raffect(int meteor_number);
void load_obj_from_meteor(int meteor_number);
int get_random_room_in_area (int area_vnum);
void meteors_update();
int get_random_area();

#define meteor_obj_lookup(meteor, num) \
    ((mobject_t*) varr_bsearch(&meteor->objects, &num, cmpint))

#endif
