/* $Id: mining.c,v 1.666 2004/09/20 10:49:51 shrike Exp $                            */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <sys/types.h>
#include <stdio.h>
#include "merc.h"

extern STAT_DATA stat_record; 

DO_FUN(do_woodchop)
{
    OBJ_DATA *axe;
    OBJ_DATA *wood;
    OBJ_DATA *stub;
    int chance, sn, mana, wait;

    if (IS_NPC(ch))
        return;

    if ((axe = get_eq_char(ch, WEAR_WIELD)) == NULL)
    {
        char_act("You need axe to chop wood.", ch);
        return;
    }

    if (axe->value[0] != WEAPON_AXE)
    {
        char_act("You need axe to chop wood.", ch);
        return;
    }

    if (MOUNTED(ch))
    {
        char_act("Free your mount!", ch);
        return;
    }
    if (ch->in_room->sector_type != SECT_FOREST)
    {
        char_act("Wood? You need forest for some wood!", ch);
        return;
    }

    if ((sn = sn_lookup("mining")) < 0
    ||  (chance = get_skill(ch, sn)) == 0)
    {
        char_act("You don't know how to chop.", ch);
        return;
    }
/*
    if (IS_SET(ch->comm, PLR_PEACE))
    {
        act("You can't use crafting.", ch, NULL, NULL, TO_CHAR);
        check_improve(ch, sn, FALSE, 1);
        return;
    }
*/

    for (stub = ch->in_room->contents; stub; stub= stub->next_content)
    {
        if (stub->pIndexData->vnum == OBJ_VNUM_STUB)
        {
            char_act("You try to cut some wood, but instead of trees have found only stubs.", 
                ch);
            return;
        }
    }
    
    mana = SKILL(sn)->min_mana / 10;
    wait = SKILL(sn)->beats;

    if (ch->move < mana)
    {
        char_act("You don't have enough energy to chop.", ch);
        return;
    }

    if (ch->carry_number >= can_carry_n(ch))
    {
        char_act("You don't have free space for wood.", ch);
        return;
    }

    if (get_carry_weight(ch) >= can_carry_w(ch))
    {
        char_act("You can't get wood. Too gravely.", ch);
        return;
    }

    ch->move -= mana;
    WAIT_STATE(ch, wait);

    char_act("You bit the tree with your axe.", ch);
    act("$n bits the tree with the axe.", ch, NULL, NULL, TO_ROOM);

    if (number_percent() * 2 > chance)
    {
       char_act("You failed to chop a wood.", ch);
       check_improve(ch, sn, FALSE, 5);
       return;
    }
    check_improve(ch, sn, TRUE, 5);
    wood = create_obj(get_obj_index(OBJ_VNUM_WOOD), ch->level);
    act_puts("You have successfully chop $p.",
        ch, wood, NULL, TO_CHAR, POS_DEAD);
    obj_to_char(wood, ch);

    // set room with stub
    if (number_percent() > get_curr_stat(ch, STAT_LCK)
    && number_bits(9) == 6)
    {
        stub = create_obj(get_obj_index(OBJ_VNUM_STUB), 0);
        stub->timer = 21;
        obj_to_room(stub, ch->in_room);
    }
}

DO_FUN(do_mining)
{
    OBJ_DATA *ore;
    OBJ_DATA *pick;
    OBJ_DATA *hole;
    AFFECT_DATA af;
    OBJ_INDEX_DATA *pObjIndex;
    int count, count2, mana, wait;
    char arg[MAX_INPUT_LENGTH];
    int chance;
    int color_chance = 100;
    int vnum = -1, vnum2 = -1;
    int sn;
    int color = -1;
    int ore_chance;
    int chance_mod = 1;

    if (IS_NPC(ch))
        return;

    if ((pick = get_eq_char(ch, WEAR_WIELD)) == NULL)
    {
        char_act("You are not holding a pick.", ch);
        return;
    }

    if (pick->pIndexData->vnum != OBJ_VNUM_PICK)
    {
        char_act("You should have mining pick to do this.", ch);
        return;
    } 

    if ((sn = sn_lookup("mining")) < 0
    || (chance = get_skill(ch, sn)) == 0)
    {
        char_act("You don't know mining.", ch);
        return;
    }

    if (ch->in_room->sector_type != SECT_MOUNTAIN
    && ch->in_room->sector_type != SECT_HILLS)
    {
        char_act("You couldn't find rocky yields here.", ch);
        return;
    }

    for (hole = ch->in_room->contents; hole; hole= hole->next_content)
    {
        if (hole->pIndexData->vnum == OBJ_VNUM_HOLE)
        {
            char_act("You try something to dig, but here only a holes!", ch);
            return;
        }
    }

    mana = SKILL(sn)->min_mana / 10;
    wait = SKILL(sn)->beats;

    ore_chance=number_range(1,10000);

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
    if (ore_chance < 3000)
        vnum = OBJ_VNUM_CHUNK_COAL;
    else if (ore_chance < 8000)
        vnum = OBJ_VNUM_IRON_ORE;
    else if (ore_chance < 9950)
        vnum = OBJ_VNUM_GOLD_ORE;
    else if (ore_chance < 9999)
        vnum = OBJ_VNUM_COPPER_ORE;
    else
        vnum = OBJ_VNUM_GEMS;
    }
    else if (!str_prefix(arg, "gold"))
    {
        color = sn_lookup("gold mining");
        vnum = OBJ_VNUM_GOLD_ORE;
        chance_mod = 10;
    }
    else if (!str_prefix(arg, "iron"))
    {
        color = sn_lookup("iron mining");
        vnum = OBJ_VNUM_IRON_ORE;
        chance_mod = 3;
    }
    else if (!str_prefix(arg, "coal"))
    {
        color = sn_lookup("coal mining");
        vnum = OBJ_VNUM_CHUNK_COAL;
    }
    else if (!str_prefix(arg, "copper"))
    {
        color = sn_lookup("copper mining");
        vnum = OBJ_VNUM_COPPER_ORE;
        chance_mod = 50;
    }
    else if (!str_prefix(arg, "gems"))
    {
        color = sn_lookup("precious mining");

        if (number_range(0, 10000) < get_curr_stat(ch, STAT_LCK))
        {
            switch(number_range(0,6))
            {
            case 0:
                vnum = OBJ_VNUM_GEMS;
                break;
            case 1:
                vnum = OBJ_VNUM_R_GEMS;
                break;
            case 2:
                vnum = OBJ_VNUM_B_GEMS;
                break;
            case 3:
                vnum = OBJ_VNUM_G_GEMS;
                break;
            case 4:
                vnum = OBJ_VNUM_M_GEMS;
                break;
            case 5:
                vnum = OBJ_VNUM_W_GEMS;
                break;
            case 6:
                vnum = OBJ_VNUM_Y_GEMS;
                break;
            }
        } else
            vnum = OBJ_VNUM_GEMS;
        chance_mod = 100;
    }

    if (vnum < 0)
    {
        char_act("You don't know exactly how to mine that kind of ore.", ch);
        return;
    }

    if (color > 0)
    {
        color_chance = get_skill(ch, color) / number_range(1, chance_mod);
        mana += SKILL(color)->min_mana / 10;
        wait += SKILL(color)->beats;
    }

    if (ch->move < mana)
    {
        char_act("You don't have enough energy to mine this.", ch);
        return;
    }

    if (ch->carry_number >= can_carry_n(ch))
    {
        char_act("You don't have free space for ore lode.", ch);
        return;
    }

    if (get_carry_weight(ch) >= can_carry_w(ch))
    {
        char_act("You can't get ore lode. Too gravely.", ch);
        return;
    }

    ch->move -= mana;
    WAIT_STATE(ch, wait);

    char_act("You bit the rock with your pick.", ch);
    act("$n bits the rock with the pick.", ch, NULL, NULL, TO_ROOM);

/*    if (IS_SET(ch->comm, PLR_PEACE))
    {
        act("As peaceful you can't use crafting.", ch, NULL, NULL, TO_CHAR);
        check_improve(ch, sn, FALSE, 3);
        check_improve(ch, color, FALSE, 3);
        return;
    }
*/
    pObjIndex = get_obj_index(vnum);

    //   ...
    // ,    ...   ...
    vnum2 = OBJ_VNUM_GEMS;

    switch(number_range(0,7))
    {
    case 0:
        vnum2 = OBJ_VNUM_GEMS;
        break;
    case 1:
        vnum2 = OBJ_VNUM_R_GEMS;
        break;
    case 2:
        vnum2 = OBJ_VNUM_B_GEMS;
        break;
    case 3:
        vnum2 = OBJ_VNUM_G_GEMS;
        break;
    case 4:
        vnum2 = OBJ_VNUM_M_GEMS;
        break;
    case 5:
        vnum2 = OBJ_VNUM_W_GEMS;
        break;
    case 6:
        vnum2 = OBJ_VNUM_Y_GEMS;
        break;
    case 7:
        vnum2 = OBJ_VNUM_GOLD_ORE;
        break;
    }

    count2 = ch->level/30;
    if (count2 < 1)
        count2 = 1;

    for (count = 0; count < count2; count++)
    {
        if (number_percent() > chance * color_chance / 100)
        {
           char_act("You failed to find an ore lode.", ch);
           check_improve(ch, sn, FALSE, 3);

           if (color > 0)
            check_improve(ch, color, FALSE, 3);

            continue;
       }

       check_improve(ch, sn, TRUE, 3);
        if (color > 0)
            check_improve(ch, color, TRUE, 3);

        ore = create_obj(pObjIndex, 0);
//        ore->level = ch->level;
        ore->cost = 2 * ch->level;
    
        if (vnum == OBJ_VNUM_GEMS)
        {
            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.location     = APPLY_MANA;
            af.modifier     = 2 * ch->level;
            af.bitvector    = 0;
            affect_to_obj(ore, &af);
        }

        obj_to_char(ore, ch);
        act_puts("You have find $p.", ch, ore, NULL, TO_CHAR, POS_DEAD);

        //      bonanza
        if (number_percent() < get_curr_stat(ch, STAT_LCK)
        && number_percent() < get_skill(ch, sn)
        && number_bits(1) == 0)
        {
            char_act("You have found a bonanza.", ch);
    
            count = number_range(1, 5);
            if (number_bits(1) == 0)
                count *= 2;
            if (number_bits(2) == 0)
                count *= 4;
    
            act_puts("Bonanza consist of $j gold $qj{pieces}.", ch, (const void *) count, NULL, TO_CHAR, POS_DEAD);
            ch->gold += count;
    
            if (number_bits(3) == 0)
            {
                pObjIndex = get_obj_index(vnum2);
                ore = create_obj(pObjIndex, 0);
//                ore->level = ch->level;
                ore->cost = 10 * ch->level;
                act_puts("Bonanza consist of $p.", ch, ore, NULL, TO_CHAR, POS_DEAD);
                obj_to_char(ore, ch);
            }
            if (number_bits(5) == 0)
            {
                pObjIndex = get_obj_index(vnum2);
                ore = create_obj(pObjIndex, 0);
//                ore->level = ch->level;
                ore->cost = 10 * ch->level;
                act_puts("Bonanza consist of $p.", ch, ore, NULL, TO_CHAR, POS_DEAD);
                obj_to_char(ore, ch);
            }
        }
    }

    // set room with hole
    if (number_percent() > get_curr_stat(ch, STAT_LCK)
    && number_bits(77) == 66)
    {
        hole = create_obj(get_obj_index(OBJ_VNUM_HOLE), 0);
        hole->timer = 21;
        obj_to_room(hole, ch->in_room);
    }
} 

DO_FUN(do_anvil)
{
    OBJ_DATA *anvil;
    OBJ_DATA *obj;
    OBJ_INDEX_DATA *pObjIndex;
    int mana, wait;
    int chance;
    int vnum = -1;
    int sn;

    if (IS_NPC(ch))
        return;

    if ((sn = sn_lookup("anvil")) < 0
    ||  (chance = get_skill(ch, sn)) == 0)
        {
        char_act("You do not know how to make an anvil.", ch);
        return;
    }

    if (ch->in_room->sector_type != SECT_MOUNTAIN
    &&  ch->in_room->sector_type != SECT_HILLS)
    {
        char_act("You can not find big enough stone to make an anvil.", ch);
        return;
    }

    /* Making the anvil */

    for (obj = ch->in_room->contents; obj; obj= obj->next_content)
    if (obj->pIndexData->vnum == OBJ_VNUM_ANVIL)
        break;

    if (obj != NULL)
    {
        char_act("There IS already an anvil here!", ch);
        return;
    } 

    vnum = OBJ_VNUM_ANVIL;
    mana = SKILL(sn)->min_mana;
    wait = SKILL(sn)->beats;
    
    if (ch->mana < mana)
    {
        char_act("You don't have enough energy to do this.", ch);
        return;
    }
        
    ch->mana -= mana;
    WAIT_STATE(ch, wait);
        
    char_act("You cut the big stone to make an anvil.", ch);
    act("$n tries to make an anvil from the big stone.", ch, NULL, NULL, TO_ROOM);

    if (number_percent() > chance)
    {
        char_act("You failed to make an anvil. Try again later.", ch);
        check_improve(ch, sn, FALSE, 3);
        return;
    }
        
    pObjIndex = get_obj_index(vnum);
        
    check_improve(ch, sn, TRUE, 3);

    anvil = create_obj(pObjIndex, 0);

    obj_to_room(anvil, ch->in_room);
    act_puts("You have made $p.", ch, anvil, NULL, TO_CHAR, POS_DEAD);

}

DO_FUN(do_smelt)
{
    OBJ_DATA *ore;
    OBJ_DATA *obj;
    OBJ_DATA *bar;
    OBJ_INDEX_DATA *pObjIndex;
    int mana, wait;
    char arg[MAX_INPUT_LENGTH];
    int chance;
    int vnum = -1;
    int sn;

    if (IS_NPC(ch))
        return;

/*    if (IS_SET(ch->comm, PLR_PEACE))
    {
        act("You can't use crafting.", ch, NULL, NULL, TO_CHAR);
        return;
    }
*/
    argument = one_argument(argument, arg, sizeof(arg));

    if ((ore = get_obj_carry(ch, arg)) == NULL)
    {
        char_act("You do not have that item.", ch);
        return;
    } 

    if ((ore->pIndexData->vnum != OBJ_VNUM_IRON_ORE)
    && (ore->pIndexData->vnum != OBJ_VNUM_COPPER_ORE)
    && (ore->pIndexData->vnum != OBJ_VNUM_GOLD_ORE))
    {
        char_act("Even you are not so silly to smelt this.", ch);
        return;
    } 

    if ((sn = sn_lookup("smelting")) < 0
    ||  (chance = get_skill(ch, sn)) == 0)
    {
        char_act("You don't know smelting.", ch);
        return;
    }


    for (obj = ch->in_room->contents; obj; obj= obj->next_content)
    {
        if (obj->pIndexData->vnum == OBJ_VNUM_FORGE)
            break;
    }
    
    if (obj == NULL)
    {
        char_act("You lack the forge.", ch);
        return;
    } 

    obj = NULL;

    for (obj = ch->carrying; obj != NULL; obj = obj->next_content)
    if (obj->pIndexData->vnum == OBJ_VNUM_CHUNK_COAL)
        break;
    
    if (obj == NULL)
    {
        char_act("You need coal to work.", ch);
        return;
    } 

    if (!str_prefix(arg, "gold"))
        vnum = OBJ_VNUM_CHUNK_GOLD;
    else if (!str_prefix(arg, "iron"))
        vnum = OBJ_VNUM_CHUNK_IRON;
    else if (!str_prefix(arg, "copper"))
        vnum = OBJ_VNUM_CHUNK_COPPER;

    if (vnum == -1)
    {
        char_act("Just put your bars in a bag.", ch);
        return;
    }

    mana = SKILL(sn)->min_mana;
    wait = SKILL(sn)->beats;


    if (ch->mana < mana)
    {
        char_act("You don't have enough energy to work in the smithy.", ch);
        return;
    }

    ch->mana -= mana;
    WAIT_STATE(ch, wait);

    char_act("You try recover pure metal from a piece of ore.", ch);
    act("$n tries to recover pure metal from a piece of ore.",
    ch, NULL, NULL, TO_ROOM);

    if (number_percent() > chance)
    {
        char_act("You failed to recover this. Try again later.", ch);
        check_improve(ch, sn, FALSE, 3);
        return;
    }
    
    pObjIndex = get_obj_index(vnum);

    check_improve(ch, sn, TRUE, 3);

    bar = create_obj(pObjIndex, 0);
    bar->level = 1;
//    bar->level = bar->level * ch->level;
    bar->cost = bar->cost * ch->level;

    obj_from_char(ore);
    obj_from_char(obj);
    obj_to_char(bar, ch);
    act_puts("Now you have $p.", ch, bar, NULL, TO_CHAR, POS_DEAD);
} 

DO_FUN(do_forge)
{
    OBJ_DATA *item;
    OBJ_DATA *obj;
    OBJ_DATA *bar;
    OBJ_DATA *hammer;
    OBJ_DATA *pliers;
    OBJ_DATA *forge;
    OBJ_INDEX_DATA *pObjIndex;
    int mana, wait;
    char arg[MAX_INPUT_LENGTH];
    int chance;
    int vnum = -1;
    int sn;
    char *material;

    if (IS_NPC(ch))
        return;

/*    if (IS_SET(ch->comm, PLR_PEACE))
    {
        act("You can't use crafting.", ch, NULL, NULL, TO_CHAR);
        return;
    }
*/
    if ((sn = sn_lookup("smithery")) < 0
    || (chance = get_skill(ch, sn)) == 0)
    {
        char_act("You are not a blacksmith!", ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        /* Establishing the forge */
        if (ch->in_room->sector_type != SECT_MOUNTAIN
        &&  ch->in_room->sector_type != SECT_HILLS)
        {
            char_act("You can not find enough rocks to set forge here.", ch);
            return;
        }

        for (obj = ch->in_room->contents; obj; obj= obj->next_content)
            if (obj->pIndexData->vnum == OBJ_VNUM_FORGE)
                break;
    
        if (obj != NULL)
        {
            char_act("There IS already a forge here!", ch);
            return;
        } 

        if ((sn = sn_lookup("forge")) < 0
        || (chance = get_skill(ch, sn)) == 0)
        {
            char_act("You don't know how to make a forge.", ch);
            return;
        }
        else {
            vnum = OBJ_VNUM_FORGE;
            mana = SKILL(sn)->min_mana;
            wait = SKILL(sn)->beats;
        
            if (ch->mana < mana)
            {
                char_act("You don't have enough energy to do this.", ch);
                return;
            }
        
            ch->mana -= mana;
            WAIT_STATE(ch, wait);
        
            char_act("You try to heat the forge.", ch);
            act("$n tries to heat the forge.", ch, NULL, NULL, TO_ROOM);

            if (number_percent() > chance)
            {
                char_act("You failed to heat the forge. Try again later.", ch);
                check_improve(ch, sn, FALSE, 3);
                return;
            }
        
            pObjIndex = get_obj_index(vnum);
        
            check_improve(ch, sn, TRUE, 3);

            forge = create_obj(pObjIndex, 0);

            obj_to_room(forge, ch->in_room);
            act_puts("You have successfully established $p.", ch, forge, NULL, TO_CHAR, POS_DEAD);
            return;
        }
    }
    

    if ((hammer = get_eq_char(ch, WEAR_HOLD)) == NULL)
    {
        char_act("You are not holding a hammer.", ch);
        return;
    }

    if (hammer->pIndexData->vnum != OBJ_VNUM_HAMMER)
    {
        char_act("That is not a right hammer.", ch);
        return;
    } 

    if ((pliers = get_eq_char(ch, WEAR_WIELD)) == NULL)
    {
        char_act("You do not have pliers in your hand.", ch);
        return;
    }

    if (pliers->pIndexData->vnum != OBJ_VNUM_PLIERS)
    {
        char_act("You should have forge pliers to forge.", ch);
        return;
    } 
    
    if (!str_prefix(arg, "boots"))
        vnum = OBJ_VNUM_DWARVEN_BOOTS;
    else if (!str_prefix(arg, "legplates"))
        vnum = OBJ_VNUM_DWARVEN_LEGPLATES;
    else if (!str_prefix(arg, "chainmail"))
        vnum = OBJ_VNUM_DWARVEN_CHAINMAIL;
    else if (!str_prefix(arg, "armplates"))
        vnum = OBJ_VNUM_DWARVEN_ARMPLATES;
    else if (!str_prefix(arg, "gauntlets"))
        vnum = OBJ_VNUM_DWARVEN_GAUNTLETS;
    else if (!str_prefix(arg, "bracer"))
        vnum = OBJ_VNUM_DWARVEN_BRACER;
    else if (!str_prefix(arg, "collar"))
        vnum = OBJ_VNUM_DWARVEN_COLLAR;
    else if (!str_prefix(arg, "helmet"))
        vnum = OBJ_VNUM_DWARVEN_HELMET;
    else if (!str_prefix(arg, "ring"))
        vnum = OBJ_VNUM_DWARVEN_RING;
    else if (!str_prefix(arg, "earring"))
        vnum = OBJ_VNUM_DWARVEN_EARRING;
    else if (!str_prefix(arg, "sceptre"))
        vnum = OBJ_VNUM_DWARVEN_SCEPTRE;
    else if (!str_prefix(arg, "mask"))
        vnum = OBJ_VNUM_DWARVEN_MASK;
    else if (!str_prefix(arg, "shield"))
        vnum = OBJ_VNUM_DWARVEN_SHIELD;
    else if (!str_prefix(arg, "dagger"))
        vnum = OBJ_VNUM_DWARVEN_DAGGER;
    else if (!str_prefix(arg, "sword"))
        vnum = OBJ_VNUM_DWARVEN_SWORD;
    else if (!str_prefix(arg, "claymore"))
        vnum = OBJ_VNUM_DWARVEN_CLAYMORE;
    else if (!str_prefix(arg, "axe"))
        vnum = OBJ_VNUM_DWARVEN_AXE;
    else if (!str_prefix(arg, "flail"))
        vnum = OBJ_VNUM_DWARVEN_FLAIL;
    else if (!str_prefix(arg, "mace"))
        vnum = OBJ_VNUM_DWARVEN_MACE;
    else if (!str_prefix(arg, "haulberd"))
        vnum = OBJ_VNUM_DWARVEN_HAULBERD;
    else if (!str_prefix(arg, "spear"))
        vnum = OBJ_VNUM_DWARVEN_SPEAR;
    else if (!str_prefix(arg, "exotic"))
        vnum = OBJ_VNUM_PLIERS;
    else if (!str_prefix(arg, "belt"))
        vnum = OBJ_VNUM_DWARVEN_BELT;
    else if (!str_prefix(arg, "cloak"))
        vnum = OBJ_VNUM_DWARVEN_CLOAK;
    else
    {
        char_act("You cannot forge this.", ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if ((bar = get_obj_carry(ch, arg)) == NULL)
    {
        char_act("You do not have a bar of that metal.", ch);
        return;
    } 

    if ((bar->pIndexData->vnum == OBJ_VNUM_IRON_ORE)
    && (bar->pIndexData->vnum == OBJ_VNUM_COPPER_ORE)
    && (bar->pIndexData->vnum == OBJ_VNUM_GOLD_ORE))
    {
        char_act("You must first SMELT this piece of ore.", ch);
        return;
    }

    if ((bar->pIndexData->vnum != OBJ_VNUM_CHUNK_IRON)
    && (bar->pIndexData->vnum != OBJ_VNUM_CHUNK_COPPER)
    && (bar->pIndexData->vnum != OBJ_VNUM_CHUNK_GOLD))
    {
        char_act("Even you are not so silly to do this.", ch);
        return;
    } 

    /* Looking for the forge in the room */
    for (obj = ch->in_room->contents; obj; obj= obj->next_content)
        if (obj->pIndexData->vnum == OBJ_VNUM_FORGE)
            break;
    
    if (obj == NULL)
    {
        char_act("You lack the forge.", ch);
        return;
    } 

    /* Looking for the anvil in the room */
    obj = NULL;

    for (obj = ch->in_room->contents; obj; obj= obj->next_content)
        if (obj->pIndexData->vnum == OBJ_VNUM_ANVIL)
            break;
    
    if (obj == NULL)
    {
        char_act("You need an anvil to forge!", ch);
        return;
    } 

    /* Looking for the coal in the inventory */
    obj = NULL;


    for (obj = ch->carrying; obj != NULL; obj = obj->next_content)
        if (obj->pIndexData->vnum == OBJ_VNUM_CHUNK_COAL)
            break;
    
    if (obj == NULL)
    {
        char_act("You need coal to work.", ch);
        return;
    } 

    if (!str_prefix(arg, "gold"))
    {
        material = "gold";

        if (vnum == OBJ_VNUM_DWARVEN_GAUNTLETS
        || vnum == OBJ_VNUM_DWARVEN_LEGPLATES
        || vnum == OBJ_VNUM_DWARVEN_ARMPLATES
        || vnum == OBJ_VNUM_DWARVEN_COLLAR
        || vnum == OBJ_VNUM_DWARVEN_CHAINMAIL
        || vnum == OBJ_VNUM_DWARVEN_HELMET
        || vnum == OBJ_VNUM_DWARVEN_SHIELD
        || vnum == OBJ_VNUM_DWARVEN_SWORD
        || vnum == OBJ_VNUM_DWARVEN_DAGGER
        || vnum == OBJ_VNUM_DWARVEN_CLAYMORE
        || vnum == OBJ_VNUM_DWARVEN_AXE
        || vnum == OBJ_VNUM_DWARVEN_FLAIL
        || vnum == OBJ_VNUM_DWARVEN_MACE
        || vnum == OBJ_VNUM_DWARVEN_HAULBERD
        || vnum == OBJ_VNUM_DWARVEN_SPEAR)
        {
            char_act("You can't make this of gold.", ch);
            return;
        }
    }
    else if (!str_prefix(arg, "iron"))
    {
        material = "iron";

        if (vnum == OBJ_VNUM_DWARVEN_RING
        || vnum == OBJ_VNUM_DWARVEN_SCEPTRE
        || vnum == OBJ_VNUM_DWARVEN_MASK
        || vnum == OBJ_VNUM_DWARVEN_BRACER
        || vnum == OBJ_VNUM_DWARVEN_EARRING)
        {
            char_act("You can't make this of iron.", ch);
            return;
        }
    }
    else if (!str_prefix(arg, "copper"))
    {
        material = "copper";

        if (vnum == OBJ_VNUM_DWARVEN_GAUNTLETS
        || vnum == OBJ_VNUM_DWARVEN_LEGPLATES
        || vnum == OBJ_VNUM_DWARVEN_ARMPLATES
        || vnum == OBJ_VNUM_DWARVEN_COLLAR
        || vnum == OBJ_VNUM_DWARVEN_CHAINMAIL
        || vnum == OBJ_VNUM_DWARVEN_HELMET
        || vnum == OBJ_VNUM_DWARVEN_SHIELD
        || vnum == OBJ_VNUM_DWARVEN_SWORD
        || vnum == OBJ_VNUM_DWARVEN_DAGGER
        || vnum == OBJ_VNUM_DWARVEN_CLAYMORE
        || vnum == OBJ_VNUM_DWARVEN_AXE
        || vnum == OBJ_VNUM_DWARVEN_FLAIL
        || vnum == OBJ_VNUM_DWARVEN_MACE
        || vnum == OBJ_VNUM_DWARVEN_HAULBERD
        || vnum == OBJ_VNUM_DWARVEN_SPEAR)
        {
            char_act("You can't make this of copper.", ch);
            return;
        }

        if (vnum == OBJ_VNUM_DWARVEN_RING
        || vnum == OBJ_VNUM_DWARVEN_SCEPTRE
        || vnum == OBJ_VNUM_DWARVEN_MASK
        || vnum == OBJ_VNUM_DWARVEN_BRACER
        || vnum == OBJ_VNUM_DWARVEN_EARRING)
        {
            char_act("You can't make this of copper.", ch);
            return;
        }
    }
    else
    {
        char_act("You cannot make something of it.", ch);
        return;
    }

    mana = SKILL(sn)->min_mana;
    wait = SKILL(sn)->beats;
    
    if (ch->mana < mana)
    {
        char_act("You don't have enough energy to work in the smithy.", ch);
        return;
    }

    ch->mana -= mana;
    WAIT_STATE(ch, wait);

    char_act("You begin to work on the anvil with your hammer.", ch);
    act("$n begins to work on the anvil with the hammer.", ch, NULL, NULL, TO_ROOM);

    if (number_percent() > chance)
    {
        char_act("You failed to make it. Try again later.", ch);
        check_improve(ch, sn, FALSE, 3);
        return;
    }

    pObjIndex = get_obj_index(vnum);
    
    check_improve(ch, sn, TRUE, 3);

    item = create_obj(pObjIndex, 0);
    item->level = ch->level;
    item->cost = item->cost * ch->level;
    item->material = material;

    if (item->pIndexData->item_type == ITEM_WEAPON)
    {
        item->value[1] = 3 + LVL(ch) / 10;
        item->value[2] = 4 + LVL(ch) / 15;
        if (IS_WEAPON_STAT(item, WEAPON_TWO_HANDS))
        {
            item->value[2] = item->value[2] * 4 / 3;
        }
    }

    if (item->pIndexData->item_type == ITEM_ARMOR)
    {
        item->value[0] = item->value[0] * (LVL(ch) / 2);
        item->value[1] = item->value[1] * (LVL(ch) / 2);
        item->value[2] = item->value[2] * (LVL(ch) / 2);
        item->value[3] = item->value[3] * (LVL(ch) / 2);
    }

    if (IS_GOOD(ch))
     SET_BIT(item->extra_flags,(ITEM_ANTI_NEUTRAL | ITEM_ANTI_EVIL));
    else if (IS_NEUTRAL(ch))
     SET_BIT(item->extra_flags,(ITEM_ANTI_GOOD | ITEM_ANTI_EVIL));
    else if (IS_EVIL(ch))
     SET_BIT(item->extra_flags,(ITEM_ANTI_NEUTRAL | ITEM_ANTI_GOOD));
       
    obj_from_char(bar);
    obj_from_char(obj);
    obj_to_char(item, ch);
    act_puts("You have successfully made $p.", ch, item, NULL, TO_CHAR, POS_DEAD);
    ++stat_record.crafted_items_forged;
    if (IS_SET(ch->comm, PLR_PEACE))
        ++stat_record.crafted_by_no_pk;
} 

//  improvement

DO_FUN(do_improvement)
{
    OBJ_DATA *item;
    OBJ_DATA *anvil;
    OBJ_DATA *hammer;
    OBJ_DATA *gems;
    AFFECT_DATA * paf;
    char    arg[MAX_INPUT_LENGTH];
    int chance, sn;

    if (IS_NPC(ch))
        return;

    if ((sn = sn_lookup("smithery")) < 0
    || (chance = get_skill(ch, sn)) == 0)
    {
        char_act("You are not a blacksmith!", ch);
        return;
    }

/*    if (IS_SET(ch->comm, PLR_PEACE))
    {
        act("You can't use crafting.", ch, NULL, NULL, TO_CHAR);
        return;
    }
*/
    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("syntax : improvement <item>", ch);
        return;
    } 

    for (anvil = ch->in_room->contents; anvil; anvil = anvil->next_content)
        if (anvil->pIndexData->vnum == OBJ_VNUM_ANVIL)
            break;
    
    if (anvil == NULL)
    {
        char_act("There is no an anvil here!", ch);
        return;
    } 

    if ((hammer = get_eq_char(ch, WEAR_HOLD)) == NULL)
    {
        char_act("You are not holding a hammer.", ch);
        return;
    }

    if (hammer->pIndexData->vnum != OBJ_VNUM_SMALL_HAMMER)
    {
        char_act("That is not a right hammer.", ch);
        return;
    } 

    if ((item = get_obj_carry(ch, arg)) == NULL) {
        char_act("You're not carrying that.", ch);
        return;
    }

    for (gems = ch->carrying; gems != NULL; gems = gems->next_content)
        if (gems->pIndexData->vnum == OBJ_VNUM_GEMS)
            break;
    
    if (gems == NULL)
    {
        char_act("You need gems to improve.", ch);
        return;
    } 

    if (item->level > ch->level)
    {
        char_act("It's too hard to improve this.", ch);
        return;
    } 

    if (item->pIndexData->vnum != OBJ_VNUM_DWARVEN_BOOTS
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_LEGPLATES
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_CHAINMAIL
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_ARMPLATES
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_GAUNTLETS
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_BRACER
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_COLLAR
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_HELMET
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_RING
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_EARRING
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_SCEPTRE
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_MASK
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_SHIELD
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_DAGGER
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_SWORD
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_CLAYMORE
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_AXE
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_FLAIL
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_MACE
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_HAULBERD
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_SPEAR
    && item->pIndexData->vnum != OBJ_VNUM_WAND_EMPOWERED
    && item->pIndexData->vnum != OBJ_VNUM_STAFF_EMPOWERED
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_BELT
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_CLOAK
    && item->pIndexData->vnum != OBJ_VNUM_MARRY_RING
    && item->pIndexData->vnum != OBJ_VNUM_R_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_B_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_G_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_M_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_W_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_Y_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_PLIERS)
    {
        char_act("You can't improve this item.", ch);
        return;
    } 


    if (number_percent () < chance)
    {
        for (paf = item->affected ; paf != NULL ; paf = paf->next)
        {
            // upgrade hitroll
            if (paf->location == APPLY_HITROLL)
                paf->modifier = UMIN (paf->modifier + 1, LVL(ch) / 13);
            else if (paf->location == APPLY_DAMROLL)
                paf->modifier = UMIN (paf->modifier + 1, LVL(ch) / 13);
            else if (paf->location == APPLY_HIT)
                paf->modifier = UMIN (paf->modifier + 20, LVL(ch));
            else if (paf->location == APPLY_MANA)
                paf->modifier = UMIN (paf->modifier + 20, LVL(ch));
            else if (paf->location == APPLY_AC)
                paf->modifier = UMAX (paf->modifier - 10, (LVL(ch)/-3));
            else if (paf->location == APPLY_SAVING_SPELL)
                paf->modifier = UMAX (paf->modifier - 1, -5);
            else if (paf->location == APPLY_STR)
                paf->modifier = UMIN (paf->modifier + 1, 2);
            else if (paf->location == APPLY_INT)
                paf->modifier = UMIN (paf->modifier + 1, 2);
            else if (paf->location == APPLY_WIS)
                paf->modifier = UMIN (paf->modifier + 1, 2);
            else if (paf->location == APPLY_DEX)
                paf->modifier = UMIN (paf->modifier + 1, 2);
            else if (paf->location == APPLY_CON)
                paf->modifier = UMIN (paf->modifier + 1, 2);
            else if (paf->location == APPLY_LCK)
                paf->modifier = UMIN (paf->modifier + 1, 2);

            act("$n improves $p.", ch, item, NULL, TO_ROOM);
            act("You impove $p.", ch, item, NULL, TO_CHAR);

        }
    }
    else {
        if ((number_percent() > (75 * get_skill(ch, sn) / 100 + get_curr_stat(ch, STAT_LCK)))
        && (number_bits(7) == 0)
        && !IS_OBJ_STAT(item, ITEM_INDESTRUCTABLE))
        {
            act("$n tries to improve $p and $p explodes!", ch, item, NULL, TO_ROOM);
            act("You try to improve $p and $p explodes! Oh, no...", ch, item, NULL, TO_CHAR);
            obj_from_char(gems);
            obj_from_char(item);
            return;
        }
        act("$n tries to improve $p, but failure takes place.", ch, item, NULL, TO_ROOM);
        act("You try to improve $p, but failure takes place.", ch, item, NULL, TO_CHAR);
    }

    act("Your $p disappears.", ch, gems, NULL, TO_CHAR);
    obj_from_char(gems);

    item->level = ch->level;

    if (item->pIndexData->item_type == ITEM_WEAPON)
    {
        item->value[1] = 3 + LVL(ch) / 10;
        item->value[2] = 4 + LVL(ch) / 15;
        if (IS_WEAPON_STAT(item, WEAPON_TWO_HANDS))
        {
            item->value[2] = item->value[2] * 4 / 3;
        }
    }

    if (item->pIndexData->item_type == ITEM_ARMOR)
    {
        item->value[0] = LVL(ch) / 2;
        item->value[1] = LVL(ch) / 2;
        item->value[2] = LVL(ch) / 2;
        item->value[3] = LVL(ch) / 2;
    }
}

//      $p   .
//  mintage

DO_FUN(do_mintage)
{
    OBJ_DATA *item;
    OBJ_DATA *anvil;
    OBJ_DATA *hammer;
    OBJ_DATA *gems;
    AFFECT_DATA * paf;
    AFFECT_DATA af;
    char    obj [MAX_INPUT_LENGTH];
    char    arg2[MAX_INPUT_LENGTH];
    int chance, sn;
    char *value=str_empty;

    if (IS_NPC(ch))
        return;

/*    if (IS_SET(ch->comm, PLR_PEACE))
    {
        act("You can't use crafting.", ch, NULL, NULL, TO_CHAR);
        return;
    }
*/
    if ((sn = sn_lookup("smithery")) < 0
    || (chance = get_skill(ch, sn)) == 0)
    {
        char_act("You are not a blacksmith!", ch);
        return;
    }

    argument = one_argument(argument, obj, sizeof(obj));
    one_argument(argument, arg2, sizeof(arg2));
    if (obj[0] == '\0' || arg2[0] == '\0')
    {
        char_act("syntax : mintage <item> <gem>", ch);
        return;
    } 

    for (anvil = ch->in_room->contents; anvil; anvil = anvil->next_content)
        if (anvil->pIndexData->vnum == OBJ_VNUM_ANVIL)
            break;
    
    if (anvil == NULL)
    {
        char_act("There is no an anvil here!", ch);
        return;
    } 

    if ((hammer = get_eq_char(ch, WEAR_HOLD)) == NULL)
    {
        char_act("You are not holding a hammer.", ch);
        return;
    }

    if (hammer->pIndexData->vnum != OBJ_VNUM_SMALL_HAMMER)
    {
        char_act("That is not a right hammer.", ch);
        return;
    } 

    if ((item = get_obj_carry(ch, obj)) == NULL)
    {
        char_act("You're not carrying that.", ch);
        return;
    }

    if ((gems = get_obj_carry(ch, arg2)) == NULL)
    {
        char_act("You're not carrying gems.", ch);
        return;
    }

    if (item->level > ch->level)
    {
        char_act("It's too hard to mintage this.", ch);
        return;
    } 

    if (item->pIndexData->vnum != OBJ_VNUM_DWARVEN_BOOTS
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_LEGPLATES
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_CHAINMAIL
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_ARMPLATES
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_GAUNTLETS
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_BRACER
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_COLLAR
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_HELMET
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_RING
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_EARRING
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_SCEPTRE
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_MASK
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_SHIELD
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_DAGGER
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_SWORD
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_CLAYMORE
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_AXE
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_FLAIL
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_MACE
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_HAULBERD
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_SPEAR
    && item->pIndexData->vnum != OBJ_VNUM_WAND_EMPOWERED
    && item->pIndexData->vnum != OBJ_VNUM_STAFF_EMPOWERED
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_BELT
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_CLOAK
    && item->pIndexData->vnum != OBJ_VNUM_MARRY_RING
    && item->pIndexData->vnum != OBJ_VNUM_R_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_B_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_G_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_M_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_W_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_Y_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_PLIERS)
    {
        char_act("You can't mintage this item.", ch);
        return;
    } 

    if (gems->pIndexData->vnum != OBJ_VNUM_R_GEMS
    && gems->pIndexData->vnum != OBJ_VNUM_B_GEMS
    && gems->pIndexData->vnum != OBJ_VNUM_G_GEMS
    && gems->pIndexData->vnum != OBJ_VNUM_M_GEMS
    && gems->pIndexData->vnum != OBJ_VNUM_W_GEMS
    && gems->pIndexData->vnum != OBJ_VNUM_Y_GEMS)
    {
        char_act("You can't mintage by this.", ch);
        return;
    } 

    if (number_percent () < chance)
    {
        if (gems->pIndexData->vnum == OBJ_VNUM_R_GEMS)
        {

            value = "HIT ROLL";

            for (paf = item->affected ; paf != NULL ; paf = paf->next)
            {
                if (paf->location == APPLY_HITROLL)
                {
                    act("But $p already gives $T.", ch, item, value, TO_CHAR);
                    obj_from_char(gems);
                    return;
                }
            }

            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.bitvector    = 0;
            af.location     = APPLY_HITROLL;
            af.modifier     = 1;
            affect_to_obj(item,&af);
            act("Now $p gives $T.", ch, item, value, TO_CHAR);
            act("$n mintage $p. Cool!", ch, item, NULL, TO_ROOM);
        }

        if (gems->pIndexData->vnum == OBJ_VNUM_B_GEMS)
        {

            value = "DAM ROLL";

            for (paf = item->affected ; paf != NULL ; paf = paf->next)
            {
                if (paf->location == APPLY_DAMROLL)
                {
                    act("But $p already gives $T.", ch, item, value, TO_CHAR);
                    obj_from_char(gems);
                    return;
                }
            }

            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.bitvector    = 0;
            af.location     = APPLY_DAMROLL;
            af.modifier     = 1;
            affect_to_obj(item,&af);
            act("Now $p gives $T.", ch, item, value, TO_CHAR); 
            act("$n mintage $p. Cool!", ch, item, NULL, TO_ROOM);
        }

        if (gems->pIndexData->vnum == OBJ_VNUM_G_GEMS)
        {

            value = "HP";

            for (paf = item->affected ; paf != NULL ; paf = paf->next)
            {
                if (paf->location == APPLY_HIT)
                {
                    act("But $p already gives $T.", ch, item, value, TO_CHAR);
                    obj_from_char(gems);
                    return;
                }
            }

            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.bitvector    = 0;
            af.location     = APPLY_HIT;
            af.modifier     = 10;
            affect_to_obj(item,&af);
            act("Now $p gives $T.", ch, item, value, TO_CHAR); 
            act("$n mintage $p. Cool!", ch, item, NULL, TO_ROOM);
        }

        if (gems->pIndexData->vnum == OBJ_VNUM_M_GEMS)
        {

            value = "MANA";

            for (paf = item->affected ; paf != NULL ; paf = paf->next)
            {
                if (paf->location == APPLY_MANA)

                {
                    act("But $p already gives $T.", ch, item, value, TO_CHAR);
                    obj_from_char(gems);
                    return;
                }
            }

            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.bitvector    = 0;
            af.location     = APPLY_MANA;
            af.modifier     = 20;
            affect_to_obj(item,&af);
            act("Now $p gives $T.", ch, item, value, TO_CHAR); 
            act("$n mintage $p. Cool!", ch, item, NULL, TO_ROOM);
        }

        if (gems->pIndexData->vnum == OBJ_VNUM_W_GEMS)
        {

            value = "SAVES";

            for (paf = item->affected ; paf != NULL ; paf = paf->next)
            {
                if (paf->location == APPLY_SAVING_SPELL)
                {
                    act("But $p already gives $T.", ch, item, value, TO_CHAR);
                    obj_from_char(gems);
                    return;
                }
            }

            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.bitvector    = 0;
            af.location     = APPLY_SAVING_SPELL;
            af.modifier     = -1;
            affect_to_obj(item,&af);
            act("Now $p gives $T.", ch, item, value, TO_CHAR);      
            act("$n mintage $p. Cool!", ch, item, NULL, TO_ROOM);
        }

        if (gems->pIndexData->vnum == OBJ_VNUM_Y_GEMS)
        {

            value = "AC";
            
            for (paf = item->affected ; paf != NULL ; paf = paf->next)
            {
                if (paf->location == APPLY_AC)
                {
                    act("But $p already gives $T.", ch, item, value, TO_CHAR);
                    obj_from_char(gems);
                    return;
                }
            }

            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.bitvector    = 0;
            af.location     = APPLY_AC;
            af.modifier     = -10;
//            af.modifier     = -5; pwipestaff
            affect_to_obj(item,&af);
            act("Now $p gives $T.", ch, item, value, TO_CHAR);      
            act("$n mintage $p. Cool!", ch, item, NULL, TO_ROOM);
        } 
    }
    else {
        if ((number_percent() > (75 * get_skill(ch, sn) / 100 + get_curr_stat(ch, STAT_LCK)))
        && (number_bits(3) == 0)
        && !IS_OBJ_STAT(item, ITEM_INDESTRUCTABLE))
        {
            act("$n try's to mintage $p and $p explode!", ch, item, NULL, TO_ROOM);
            act("You try's to mintage $p and $p explode! Oh, no...", ch, item, NULL, TO_CHAR);
            obj_from_char(gems);
            obj_from_char(item);
            return;
        }
        act("$n try's to mintage $p, but failed.", ch, item, NULL, TO_ROOM);
        act("You try's to mintage $p, but failed", ch, item, NULL, TO_CHAR);
    }

    item->level = ch->level;
    act("Your $p disappears.", ch, gems, NULL, TO_CHAR);
    obj_from_char(gems);

    if (item->pIndexData->item_type == ITEM_WEAPON)
    {
        item->value[1] = 3 + LVL(ch) / 10;
        item->value[2] = 4 + LVL(ch) / 15;
        if (IS_WEAPON_STAT(item, WEAPON_TWO_HANDS))
        {
            item->value[2] = item->value[2] * 4 / 3;
        }
    }

    if (item->pIndexData->item_type == ITEM_ARMOR)
    {
        item->value[0] = LVL(ch) / 2;
        item->value[1] = LVL(ch) / 2;
        item->value[2] = LVL(ch) / 2;
        item->value[3] = LVL(ch) / 2;
    }
}

// merging - 

DO_FUN(do_merge)
{
    OBJ_DATA *item;
    OBJ_DATA *anvil;
    OBJ_DATA *hammer;
    OBJ_DATA *gems;
    AFFECT_DATA * paf;
    AFFECT_DATA af;
    char    obj [MAX_INPUT_LENGTH];
    char    arg2[MAX_INPUT_LENGTH];
    int chance, sn;
    char *value=str_empty;

    if (IS_NPC(ch))
        return;

/*    if (IS_SET(ch->comm, PLR_PEACE))
    {
        act("You can't use crafting.", ch, NULL, NULL, TO_CHAR);
        return;
    }
*/
    if ((sn = sn_lookup("smithery")) < 0
    || (chance = get_skill(ch, sn)) == 0)
    {
        char_act("You are not a blacksmith!", ch);
        return;
    }

    argument = one_argument(argument, obj, sizeof(obj));
    one_argument(argument, arg2, sizeof(arg2));
    if (obj[0] == '\0' || arg2[0] == '\0')
    {
        char_act("syntax : merge <item> <gem>", ch);
        return;
    } 

    for (anvil = ch->in_room->contents; anvil; anvil = anvil->next_content)
        if (anvil->pIndexData->vnum == OBJ_VNUM_ANVIL)
            break;
    
    if (anvil == NULL)
    {
        char_act("There is no an anvil here!", ch);
        return;
    } 

    if ((hammer = get_eq_char(ch, WEAR_HOLD)) == NULL)
    {
        char_act("You are not holding a hammer.", ch);
        return;
    }

    if (hammer->pIndexData->vnum != OBJ_VNUM_SMALL_HAMMER)
    {
        char_act("That is not a right hammer.", ch);
        return;
    } 

    if ((item = get_obj_carry(ch, obj)) == NULL)
    {
        char_act("You're not carrying that.", ch);
        return;
    }

    if ((gems = get_obj_carry(ch, arg2)) == NULL)
    {
        char_act("You're not carrying gems.", ch);
        return;
    }

    if (item->level > ch->level)
    {
        char_act("It's too hard to merge this and gem.", ch);
        return;
    } 

    if (item->pIndexData->vnum != OBJ_VNUM_DWARVEN_BOOTS
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_LEGPLATES
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_CHAINMAIL
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_ARMPLATES
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_GAUNTLETS
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_BRACER
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_COLLAR
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_HELMET
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_RING
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_EARRING
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_SCEPTRE
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_MASK
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_SHIELD
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_DAGGER
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_SWORD
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_CLAYMORE
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_AXE
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_FLAIL
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_MACE
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_HAULBERD
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_SPEAR
    && item->pIndexData->vnum != OBJ_VNUM_WAND_EMPOWERED
    && item->pIndexData->vnum != OBJ_VNUM_STAFF_EMPOWERED
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_BELT
    && item->pIndexData->vnum != OBJ_VNUM_DWARVEN_CLOAK
    && item->pIndexData->vnum != OBJ_VNUM_MARRY_RING
    && item->pIndexData->vnum != OBJ_VNUM_R_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_B_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_G_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_M_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_W_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_Y_LIGHTSABER
    && item->pIndexData->vnum != OBJ_VNUM_PLIERS)
    {
        char_act("You can't merge this item.", ch);
        return;
    } 

    if (gems->pIndexData->vnum != OBJ_VNUM_R_GEMS
    && gems->pIndexData->vnum != OBJ_VNUM_B_GEMS
    && gems->pIndexData->vnum != OBJ_VNUM_G_GEMS
    && gems->pIndexData->vnum != OBJ_VNUM_M_GEMS
    && gems->pIndexData->vnum != OBJ_VNUM_W_GEMS
    && gems->pIndexData->vnum != OBJ_VNUM_Y_GEMS)
    {
        char_act("You can't merge this type of gems.", ch);
        return;
    } 

    if (number_percent () < chance)
    {
        if (gems->pIndexData->vnum == OBJ_VNUM_R_GEMS)
        {

            value = "Strength";

            for (paf = item->affected ; paf != NULL ; paf = paf->next)
            {
                if (paf->location == APPLY_STR)
                {
                    act("But $p already gives $T.", ch, item, value, TO_CHAR);
                    obj_from_char(gems);
                    return;
                }
            }

            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.bitvector    = 0;
            af.location     = APPLY_STR;
            af.modifier     = 1;
            affect_to_obj(item,&af);
            act("Now $p gives $T.", ch, item, value, TO_CHAR);           
            act("$n merge $p and gem. Cool!", ch, item, NULL, TO_ROOM);
        }

        if (gems->pIndexData->vnum == OBJ_VNUM_B_GEMS)
        {

            value = "Intellect";

            for (paf = item->affected ; paf != NULL ; paf = paf->next)
            {
                if (paf->location == APPLY_INT)
                {
                    act("But $p already gives $T.", ch, item, value, TO_CHAR);
                    obj_from_char(gems);
                    return;
                }
            }

            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.bitvector    = 0;
            af.location     = APPLY_INT;
            af.modifier     = 1;
            affect_to_obj(item,&af);
            act("Now $p gives $T.", ch, item, value, TO_CHAR);      
            act("$n merge $p and gem. Cool!", ch, item, NULL, TO_ROOM);
        }

        if (gems->pIndexData->vnum == OBJ_VNUM_G_GEMS)
        {

            value = "Wisdom";

            for (paf = item->affected ; paf != NULL ; paf = paf->next)
            {
                if (paf->location == APPLY_WIS)
                {
                    act("But $p already gives $T.", ch, item, value, TO_CHAR);
                    obj_from_char(gems);
                    return;
                }
            }

            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.bitvector    = 0;
            af.location     = APPLY_WIS;
            af.modifier     = 1;
            affect_to_obj(item,&af);
            act("Now $p gives $T.", ch, item, value, TO_CHAR);      
            act("$n merge $p and gem. Cool!", ch, item, NULL, TO_ROOM);
        }

        if (gems->pIndexData->vnum == OBJ_VNUM_M_GEMS)
        {

            value = "Dexterity";

            for (paf = item->affected ; paf != NULL ; paf = paf->next)
            {
                if (paf->location == APPLY_DEX)
                {
                    act("But $p already gives $T.", ch, item, value, TO_CHAR);
                    obj_from_char(gems);
                    return;
                }
            }

            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.bitvector    = 0;
            af.location     = APPLY_DEX;
            af.modifier     = 1;
            affect_to_obj(item,&af);
            act("Now $p gives $T.", ch, item, value, TO_CHAR);      
            act("$n merge $p and gem. Cool!", ch, item, NULL, TO_ROOM);
        }

        if (gems->pIndexData->vnum == OBJ_VNUM_W_GEMS)
        {

            value = "Constitution";

            for (paf = item->affected ; paf != NULL ; paf = paf->next)
            {
                if (paf->location == APPLY_CON)
                {
                    act("But $p already gives $T.", ch, item, value, TO_CHAR);
                    obj_from_char(gems);
                    return;
                }
            }

            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.bitvector    = 0;
            af.location     = APPLY_CON;
            af.modifier     = 1;
            affect_to_obj(item,&af);
            act("Now $p gives $T.", ch, item, value, TO_CHAR);      
            act("$n merge $p and gem. Cool!", ch, item, NULL, TO_ROOM);
        }

        if (gems->pIndexData->vnum == OBJ_VNUM_Y_GEMS)
        {

            value = "Luck";
            
            for (paf = item->affected ; paf != NULL ; paf = paf->next)
            {
                if (paf->location == APPLY_LCK)
                {
                    act("But $p already gives $T.", ch, item, value, TO_CHAR);
                    obj_from_char(gems);
                    return;
                }
            }

            af.where        = TO_OBJECT;
            af.type         = sn;
            af.level        = ch->level;
            af.duration     = -1;
            af.bitvector    = 0;
            af.location     = APPLY_LCK;
            af.modifier     = 1;
            affect_to_obj(item,&af);
            act("Now $p gives $T.", ch, item, value, TO_CHAR);      
            act("$n merge $p and gem. Cool!", ch, item, NULL, TO_ROOM);
        } 
    }
    else {
        if ((number_percent() > (75 * get_skill(ch, sn) / 100 + get_curr_stat(ch, STAT_LCK)))
        && (number_bits(3) == 0)
        && !IS_OBJ_STAT(item, ITEM_INDESTRUCTABLE))
        {
            act("$n try's to merge $p and $p explode!", ch, item, NULL, TO_ROOM);
            act("You try's to merge $p and $p explode! Oh, no...", ch, item, NULL, TO_CHAR);
            obj_from_char(gems);
            obj_from_char(item);
            return;
        }

        act("$n try's to merge $p and gem, but failed.", ch, item, NULL, TO_ROOM);
        act("You try's to merge $p and gem, but failed", ch, item, NULL, TO_CHAR);
    }

    item->level = ch->level;
    act("Your $p disappears.", ch, gems, NULL, TO_CHAR);
    obj_from_char(gems);

    if (item->pIndexData->item_type == ITEM_WEAPON)
    {
        item->value[1] = 3 + LVL(ch) / 10;
        item->value[2] = 4 + LVL(ch) / 15;
        if (IS_WEAPON_STAT(item, WEAPON_TWO_HANDS))
        {
            item->value[2] = item->value[2] * 4 / 3;
        }
    }

    if (item->pIndexData->item_type == ITEM_ARMOR)
    {
        item->value[0] = LVL(ch) / 2;
        item->value[1] = LVL(ch) / 2;
        item->value[2] = LVL(ch) / 2;
        item->value[3] = LVL(ch) / 2;
    }
}

void do_scribe(CHAR_DATA * ch, const char *argument)
{
    OBJ_DATA *scribed, *blank;
    int sn;
    pcskill_t *ps;
    skill_t *spell;
    int mana;
    int wait;
    int chance;
    int level;

//    .
    if (IS_NPC(ch))
        return;

    chance = 0;
    sn = -1;
    wait = PULSE_TICK;

    if (get_skill(ch, gsn_scribe) < 50)
    {
        char_act("A skill such as this requires more magical ability.", ch );
        return;
    }

    if ( argument[0] == '\0' || !str_cmp(argument, str_empty) )
    {
        char_act("Scribe what?", ch );
        return;
    }

    if (IS_NPC(ch))
    {
        sn = sn_lookup(argument);
        chance = get_skill(ch, sn);
    }
    else if ((ps = skill_vlookup(&ch->pcdata->learned, argument))
    &&  skill_level(ch, sn = ps->sn) <= ch->level )
        chance = ps->percent;

    spell = SKILL(sn);

    if ( chance == 0 )
    {
        char_act("You have not learned that spell.", ch );
        return;
    }
    if ( chance < 100 )
    {
        char_act("To scribe a spell you should know it ideally.", ch);
        return;
    }

    if ( spell->spell_fun == NULL )
    {
        char_act("That's not a spell!", ch );
        return;
    }

    if (!IS_NPC(ch)
    && (ch->level < LEVEL_IMMORTAL)
    && (IS_CLAN_SKILL(spell)
    || !IS_SET(spell->flags, SKILL_SCRIBE)))
    {
        char_act("You cannot scribe that spell.", ch );
        return;
    }

    if (!IS_NPC(ch))
    {
        mana = 5 * mana_cost(ch, sn);
        wait = 1 + spell->beats * PULSE_TICK/PULSE_VIOLENCE;
//        wait += PULSE_VIOLENCE * skill_level(ch, sn); // GM
        if (ch->mana < mana)
        {
            char_act("You don't have enough mana.", ch );
            return;
        }
    }
    else
        mana = 0;

    if (IS_PUMPED(ch) || (ch->position != POS_SITTING)
    || ((blank = get_eq_char(ch, WEAR_HOLD)) == NULL))
    {
        char_act("Please, relax, sit down and hold scroll/staff/wand.", ch);
        return;
    }

    if (blank->pIndexData->vnum != OBJ_VNUM_SCROLL_SCRIBING
    && blank->pIndexData->vnum != OBJ_VNUM_WAND
    && blank->pIndexData->vnum != OBJ_VNUM_STAFF)
    {
        char_act("You must make scroll/staff/wand for scribe.", ch );
        return;
    }

    WAIT_STATE(ch, wait);

    if (!IS_NPC(ch)
    && number_percent() + 25 > get_skill(ch, gsn_scribe))
    {
        char_act("You failed to scribe. Try again later.", ch);
        check_improve( ch, gsn_scribe, FALSE, 1 );
        extract_obj(blank);
        ch->mana -= (mana / 2);
        return;
    }

    scribed = NULL;

    switch (blank->pIndexData->item_type)
    {
    case ITEM_SCROLL:

        level = ch->level;
        scribed = create_named_obj(get_obj_index(OBJ_VNUM_SCROLL_SCRIBED), 
            level, spell->name);
        scribed->level       = level;
        //scribed->value[0]    = (level + 20) * get_skill(ch, gsn_scribe) / 100;

        scribed->value[0]    = IS_SET (muddy_mode, MUDDY_SCRIBE_NEW) ? 
                             (level + level/10) * get_skill(ch, gsn_scribe) / 100 :
                             (level + 20) * get_skill(ch, gsn_scribe) / 100;
        scribed->value[1]    = sn;

    break;
    case ITEM_WAND:

        level = ch->level;
        scribed = create_named_obj(get_obj_index(OBJ_VNUM_WAND_EMPOWERED),
            level, spell->name);
        scribed->level       = level;
        //scribed->value[0]    = (level + 20) * get_skill(ch, gsn_scribe) / 100;
        scribed->value[0]    = IS_SET (muddy_mode, MUDDY_SCRIBE_NEW) ? 
                             (level + level/10) * get_skill(ch, gsn_scribe) / 100 :
                             (level + 20) * get_skill(ch, gsn_scribe) / 100;

        scribed->value[1]    = 1;
        scribed->value[2]    = 1;
        scribed->value[3]    = sn;

    break;
    case ITEM_STAFF:

        level = ch->level;
        scribed = create_named_obj(get_obj_index(OBJ_VNUM_STAFF_EMPOWERED),
            level, spell->name);
        scribed->level       = level;
        //scribed->value[0]    = (level + 20) * get_skill(ch, gsn_scribe) / 100;
        scribed->value[0]    = IS_SET (muddy_mode, MUDDY_SCRIBE_NEW) ? 
                     (level + level/10) * get_skill(ch, gsn_scribe) / 100 :
                     (level + 20) * get_skill(ch, gsn_scribe) / 100;

        scribed->value[1]    = 1;
        scribed->value[2]    = 1;
        scribed->value[3]    = sn;

    };

    if (!scribed)
        return;

    obj_from_char(blank);
    extract_obj(blank);
    obj_to_char(scribed, ch);
    equip_char(ch, scribed, WEAR_HOLD);

    act("You have successfully scribed $p.", ch, scribed, NULL, TO_CHAR);
    act("$n has successfully scribed $p.", ch, scribed, NULL, TO_ROOM);

    check_improve(ch, gsn_scribe, TRUE, 1);
    ch->mana -= mana;
    return; 
}

void do_empower(CHAR_DATA * ch, const char *argument)
{
    OBJ_DATA *obj, *gems;
    char arg[MAX_INPUT_LENGTH];
    int wait, level;

    one_argument( argument, arg, sizeof(arg) );

    if (arg[0] == '\0')
    {
        do_help(ch, "'EMPOWER'");
        return;
    }

    if (IS_NPC(ch))
        return;

    wait = PULSE_TICK;

    if (get_skill(ch, gsn_scribe) < 50)
    {
        char_act("A skill such as this requires more magical ability.", ch);
        return;
    }

    if ((obj = get_eq_char(ch, WEAR_HOLD)) == NULL)
    {
        char_act("You must hold staff or wand to empower.", ch);
        return;
    }

    if (obj->level > ch->level)
    {
        char_act("It's too hard to empower this.", ch);
        return;
    }

    if (obj->pIndexData->vnum != OBJ_VNUM_WAND_EMPOWERED
    && obj->pIndexData->vnum != OBJ_VNUM_STAFF_EMPOWERED)
    {
        char_act("You can't empower this.", ch );
        return;
    }

    if (!str_cmp(arg, "recharge")
    || !str_cmp(arg, ""))
    {
        for (gems = ch->carrying; gems != NULL; gems = gems->next_content)
            if (gems->pIndexData->vnum == OBJ_VNUM_GEMS)
                break;
    
        if (gems == NULL)
        {
            char_act("You need gem for recharge.", ch);
            WAIT_STATE(ch, 2*PULSE_VIOLENCE);
            return;
        } 

        WAIT_STATE(ch, wait);

        obj->value[2] = obj->value[1];

        act("Your $p disappears.", ch, gems, NULL, TO_CHAR);
        obj_from_char(gems);

        act("You have successfully recharged $p.", ch, obj, NULL, TO_CHAR);
        act("$n has successfully recharged $p.", ch, obj, NULL, TO_ROOM);
        check_improve(ch, gsn_scribe, TRUE, 10);
        return;
    }

    if (!str_cmp(arg, "improve")
    || !str_cmp(arg, ""))
    {
        for (gems = ch->carrying; gems != NULL; gems = gems->next_content)
            if (gems->pIndexData->vnum == OBJ_VNUM_R_GEMS
            || gems->pIndexData->vnum == OBJ_VNUM_B_GEMS
            || gems->pIndexData->vnum == OBJ_VNUM_G_GEMS
            || gems->pIndexData->vnum == OBJ_VNUM_M_GEMS
            || gems->pIndexData->vnum == OBJ_VNUM_W_GEMS
            || gems->pIndexData->vnum == OBJ_VNUM_Y_GEMS)
                break;

        if (gems == NULL)
        {
            char_act("You need unique gem to improve.", ch);
            WAIT_STATE(ch, 2*PULSE_VIOLENCE);
            return;
        }

        WAIT_STATE(ch, wait);

        if (obj->value[2] >= 9000)
        {
            char_act("Maximum improvement status reached.", ch);
            return;
        }

        if (number_percent() < get_curr_stat(ch, STAT_LCK))
            obj->value[1] += 20;
        else if (number_percent() < get_curr_stat(ch, STAT_LCK))
            obj->value[1] += 10;
        else
            obj->value[1] += 5;

        obj->value[2] = UMIN (obj->value[2], 9000);
        obj->value[2] = obj->value[1];

        act("Your $p disappears.", ch, gems, NULL, TO_CHAR);
        obj_from_char(gems);

        act("You have successfully improved $p.", ch, obj, NULL, TO_CHAR);
        act("$n has successfully improved $p.", ch, obj, NULL, TO_ROOM);
        check_improve(ch, gsn_scribe, TRUE, 10);
        return;
    }
    if (!str_cmp(arg, "upgrade")
    || !str_cmp(arg, ""))
    {
        for (gems = ch->carrying; gems != NULL; gems = gems->next_content)
            if (gems->pIndexData->vnum == OBJ_VNUM_GEMS)
                break;
    
        if (gems == NULL)
        {
            char_act("You need gem for upgrade.", ch);
            WAIT_STATE(ch, 2*PULSE_VIOLENCE);
            return;
        } 

        WAIT_STATE(ch, wait);

        level           = ch->level;
        obj->level      = level;
        //obj->value[0]   = (level + 20) * get_skill(ch, gsn_scribe) / 100;
        obj->value[0]    = IS_SET (muddy_mode, MUDDY_SCRIBE_NEW) ? 
                         (level + level/10) * get_skill(ch, gsn_scribe) / 100 :
                         (level + 20) * get_skill(ch, gsn_scribe) / 100;


        act("Your $p disappears.", ch, gems, NULL, TO_CHAR);
        obj_from_char(gems);

        act("You have successfully upgraded $p.", ch, obj, NULL, TO_CHAR);
        act("$n has successfully upgraded $p.", ch, obj, NULL, TO_ROOM);
        check_improve(ch, gsn_scribe, TRUE, 10);
        return;
    }
    do_help(ch, "'EMPOWER'");
    return;
}

