/* $Id: mob_cmds.h,v 1.666 2004/09/20 10:49:51 shrike Exp $                           */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/************************************************************************************
 *                                                                                  *
 *  MOBprograms for ROM 2.4 v0.98g (C) M.Nylander 1996                              *
 *  Based on MERC 2.2 MOBprograms concept by N'Atas-ha.                             *
 *  Written and adapted to ROM 2.4 by                                               *
 *          Markku Nylander (markku.nylander@uta.fi)                                *
 *  This code may be copied and distributed as per the ROM license.                 *
 *                                                                                  *
 ************************************************************************************/

#ifndef _MOB_CMDS_H_
#define _MOB_CMDS_H_

struct      mob_cmd_type
{
    char        * const name;
    DO_FUN      * do_fun;
};



DECLARE_DO_FUN(mob_interpret);

/* the command table itself */
extern      const struct      mob_cmd_type      mob_cmd_table     [];

/*
 * Command functions.
 * Defined in mob_cmds.c
 */
DECLARE_DO_FUN(do_mpasound          );
DECLARE_DO_FUN(do_mpgecho           );
DECLARE_DO_FUN(do_mpzecho           );
DECLARE_DO_FUN(do_mpkill            );
DECLARE_DO_FUN(do_mpattack          );
DECLARE_DO_FUN(do_mpassist          );
DECLARE_DO_FUN(do_mpjunk            );
DECLARE_DO_FUN(do_mpechoaround      );
DECLARE_DO_FUN(do_mpecho            );
DECLARE_DO_FUN(do_mpechoat          );
DECLARE_DO_FUN(do_mpmload           );
DECLARE_DO_FUN(do_mpoload           );
DECLARE_DO_FUN(do_mppurge           );
DECLARE_DO_FUN(do_mpgoto            );
DECLARE_DO_FUN(do_mpat              );
DECLARE_DO_FUN(do_mptransfer        );
DECLARE_DO_FUN(do_mpgtransfer       );
DECLARE_DO_FUN(do_mpforce           );
DECLARE_DO_FUN(do_mpgforce          );
DECLARE_DO_FUN(do_mpvforce          );
DECLARE_DO_FUN(do_mpcast            );
DECLARE_DO_FUN(do_mpdamage          );
DECLARE_DO_FUN(do_mpremember        );
DECLARE_DO_FUN(do_mpforget          );
DECLARE_DO_FUN(do_mpdelay           );
DECLARE_DO_FUN(do_mpcancel          );
DECLARE_DO_FUN(do_mpcall            );
DECLARE_DO_FUN(do_mpflee            );
DECLARE_DO_FUN(do_mpotransfer       );
DECLARE_DO_FUN(do_mpremove          );
DECLARE_DO_FUN(do_mpreligion        );
DECLARE_DO_FUN(do_mpreward          );
#endif

