/* $Id: mob_prog.h,v 1.666 2004/09/20 10:49:51 shrike Exp $                           */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/************************************************************************************
 *                                                                                  *
 *  MOBprograms for ROM 2.4 v0.98g (C) M.Nylander 1996                              *
 *  Based on MERC 2.2 MOBprograms concept by N'Atas-ha.                             *
 *  Written and adapted to ROM 2.4 by                                               *
 *          Markku Nylander (markku.nylander@uta.fi)                                *
 *  This code may be copied and distributed as per the ROM license.                 *
 *                                                                                  *
 ************************************************************************************/

#ifndef _MOB_PROG_H_
#define _MOB_PROG_H_

void    program_flow      (int pvnum, CHAR_DATA *mob, OBJ_DATA *obj, ROOM_INDEX_DATA *room,
                             CHAR_DATA *ch, const void *arg1,  const void *arg2);
void    p_act_trigger     (const char *argument, CHAR_DATA *mob, OBJ_DATA *obj, ROOM_INDEX_DATA *room,
                                       CHAR_DATA *ch, const void *arg1, const void *arg2, int type);
bool    p_percent_trigger (CHAR_DATA *mob, OBJ_DATA *obj, ROOM_INDEX_DATA *room,
                                     CHAR_DATA *ch, const void *arg1, const void *arg2, int type);
void    p_bribe_trigger   (CHAR_DATA *mob, CHAR_DATA *ch, int amount);
bool    p_exit_trigger    (CHAR_DATA *ch, int dir, int type);
void    p_give_trigger    (CHAR_DATA *mob,  OBJ_DATA *obj, ROOM_INDEX_DATA *room, CHAR_DATA *ch, OBJ_DATA *dropped, int type);
void    p_greet_trigger   (CHAR_DATA *ch, int type);
void    p_hprct_trigger   (CHAR_DATA *mob, CHAR_DATA *ch);

#endif
